<?php
 function get_tankers_pending_weight() { $branch_id = active_branch_id(); $weight_for_consume = array(); $weight_consumed = array(); $lots = DB::table('lot')->where('branch',$branch_id)->where('purchase_type','iran_to_border')->get(); $lots = json_decode(json_encode($lots),true); foreach($lots as $row) { $lot_list = json_decode($row['lot_list'],true); foreach($lot_list as $inner_row) { $weight_for_consume[] = (float)$inner_row['gross_weight']; } $division_list = json_decode($row['division_list'],true); foreach($division_list as $inner_row) { $weight_consumed[] = (float)$inner_row['weight']; } } return array_sum($weight_for_consume) - array_sum($weight_consumed); } function lot_pending_report($lots) { $accounts = set_array_keys(fetch_table_branch("accounts"),'uid'); $records = array(); foreach($lots as $row) { $pending_weight = (float)$row['total_gross_weight'] - (float)$row['total_division_gross_weight']; $total_pending = $pending_weight + (float)$row['pending_weight']; $records[] = array( 'uid' => $row['uid'], 'date' => $row['lot_date'], 'receipt' => $row['receipt'], 'supplier' => array_key_exists($row['supplier'], $accounts) ? $accounts[$row['supplier']]['name'] : NULL, 'email_attachment' => $row['email_attachment'], 'total_weight' => $row['total_gross_weight'], 'loaded_weight' => $row['total_division_gross_weight'], 'pending_weight' => $pending_weight, 'old_pending' => $row['pending_weight'], 'total_pending' => $total_pending, ); } return $records; } function get_item_graph_data($item,$currency,$client,$date) { $branch_id = active_branch_id(); $item_data = fetch_table_where('items','uid',$item,true); $months = array(); $months_qty = array(); $last_six_months = get_prev_months(6,$date); foreach($last_six_months as $month) { $item_qty = array(); $month_start = $month.'-01 00:00:00'; $month_end = $month.'-31 23:59:59'; $sales = DB::table('sales')->where('main_approval','approved')->where('branch',$branch_id)->where('sale_items','like','%-++-'.$item.'-++-%'); if(!empty($currency)){ $sales->where('currency',$currency); } if(!empty($client)){ $sales->where('client',$client); } $sales->where('created_at','>=',$month_start); $sales->where('created_at','<=',$month_end); $sales = json_decode(json_encode($sales->get()),true); foreach($sales as $sale) { $sale_items = json_decode($sale['items_details'],true); foreach($sale_items as $irow) { if($irow['item'] == $item) { $item_row_qty = (float)$irow['qty']; if($irow['unit'] == 'purchase'){ $item_row_qty = (float)$item_data['purchase_unit_equalance'] == 0 ? 0 : ($item_row_qty / (float)$item_data['purchase_unit_equalance']); } if($irow['unit'] == 'sale'){ $item_row_qty = (float)$item_data['sale_unit_equalance'] == 0 ? 0 : ($item_row_qty / (float)$item_data['sale_unit_equalance']); } if($irow['unit'] == 'production'){ $item_row_qty = (float)$item_data['production_unit_equalance'] == 0 ? 0 : ($item_row_qty / (float)$item_data['production_unit_equalance']); } $item_qty[] = $item_row_qty; } } } $months[] = date("M", strtotime($month_start)); $months_qty[] = array_sum($item_qty); } return array('months' => $months, 'qty' => $months_qty); } function fetch_transits_with_stats($transits) { $purchases = fetch_table_branch('purchases'); $purchases_transits = array(); foreach($purchases as $purchase) { $purchase_items = json_decode($purchase['items'],true); foreach($purchase_items as $item) { if(!empty($item['expense'])) { if(!array_key_exists($item['expense'],$purchases_transits)){ $purchases_transits[$item['expense']] = array(); } $purchases_transits[$item['expense']][] = (float)$item['transport_expense']; } } } $transits_bucket = array(); foreach($transits as $transit) { $transit_purchases = array_key_exists($transit['uid'],$purchases_transits) ? array_sum($purchases_transits[$transit['uid']]) : 0; $transit_total = (float)$transit['total_exp']; $transit_pending = $transit_total - $transit_purchases; $transit['from_purchases'] = $transit_purchases; $transit['pending'] = $transit_pending; $transits_bucket[] = $transit; } return $transits_bucket; } function manage_profit_loss_data_client_wise($currency,$from,$to) { $branch_id = active_branch_id(); $purchases = DB::table('purchases')->where('main_approval','approved')->where('branch',$branch_id); $sales = DB::table('sales')->where('main_approval','approved')->where('branch',$branch_id); $transfer_out = DB::table('transfer_out')->where('branch',$branch_id); $sales_return = DB::table('sales_return')->where('branch',$branch_id); $services = DB::table('services')->where('branch',$branch_id); $production = DB::table('production_details')->where('branch',$branch_id); $expenses = DB::table('expenses')->where('main_approval','approved')->where('branch',$branch_id); if(!empty($request->currency)) { $purchases->where('currency',$currency); $sales->where('currency',$currency); $transfer_out->where('currency',$currency); $sales_return->where('currency',$currency); $services->where('currency',$currency); $production->where('currency',$currency); $expenses->where('currency',$currency); } if(!empty($from)) { $purchases->where('created_at','>=',get_true_date($from).' 00:00:00'); $sales->where('created_at','>=',get_true_date($from).' 00:00:00'); $transfer_out->where('created_at','>=',get_true_date($from).' 00:00:00'); $sales_return->where('created_at','>=',get_true_date($from).' 00:00:00'); $services->where('created_at','>=',get_true_date($from).' 00:00:00'); $production->where('created_at','>=',get_true_date($from).' 00:00:00'); $expenses->where('created_at','>=',get_true_date($from).' 00:00:00'); } if(!empty($to)) { $purchases->where('created_at','<=',get_true_date($to).' 23:59:59'); $sales->where('created_at','<=',get_true_date($to).' 23:59:59'); $transfer_out->where('created_at','<=',get_true_date($to).' 23:59:59'); $sales_return->where('created_at','<=',get_true_date($to).' 23:59:59'); $services->where('created_at','<=',get_true_date($to).' 23:59:59'); $production->where('created_at','<=',get_true_date($to).' 23:59:59'); $expenses->where('created_at','<=',get_true_date($to).' 23:59:59'); } $sales = json_decode(json_encode($sales->get()),true); $transfer_out = json_decode(json_encode($transfer_out->get()),true); $sales_return = json_decode(json_encode($sales_return->get()),true); $services = json_decode(json_encode($services->get()),true); $purchases = json_decode(json_encode($purchases->get()),true); $production = json_decode(json_encode($production->get()),true); $expenses = json_decode(json_encode($expenses->get()),true); $item_settings = get_item_settings(); if($item_settings['item_measurements'] == 'get') { $fetch_result = DB::table('items')->select(DB::raw('sum((height * width * opening_stock) * cost) as opening_stock'))->where('branch',active_branch_id())->where('currency',$currency); if(!empty($from)) { $fetch_result->where('created_at','>=',get_true_date($from).' 00:00:00'); } if(!empty($to)) { $fetch_result->where('created_at','<=',get_true_date($to).' 23:59:59'); } $fetch_result = $fetch_result->get()->first(); } else { $fetch_result = DB::table('items')->select(DB::raw('sum(opening_stock * cost) as opening_stock'))->where('branch',active_branch_id())->where('currency',$currency); if(!empty($from)) { $fetch_result->where('created_at','>=',get_true_date($from).' 00:00:00'); } if(!empty($to)) { $fetch_result->where('created_at','<=',get_true_date($to).' 23:59:59'); } $fetch_result = $fetch_result->get()->first(); } $opening_stock = $fetch_result->opening_stock; $purchases_amount = DB::table('purchases')->where('main_approval','approved')->where('branch',active_branch_id())->where('currency',$currency); if(!empty($from)) { $purchases_amount->where('created_at','>=',get_true_date($from).' 00:00:00'); } if(!empty($to)) { $purchases_amount->where('created_at','<=',get_true_date($to).' 23:59:59'); } $purchases_amount = $purchases_amount->sum('sub_total_amount'); $cpurchases_amount = DB::table('cpurchases')->where('branch',active_branch_id())->where('currency',$currency); if(!empty($from)) { $cpurchases_amount->where('created_at','>=',get_true_date($from).' 00:00:00'); } if(!empty($to)) { $cpurchases_amount->where('created_at','<=',get_true_date($to).' 23:59:59'); } $cpurchases_amount = $cpurchases_amount->sum('total'); $total_purchase_amount = $purchases_amount + $cpurchases_amount; if($item_settings['item_measurements'] == 'get') { $citems = DB::table('items')->select(DB::raw('sum((height * width * _avail_units) * _avg_cost) as amount')); } else { $citems = DB::table('items')->select(DB::raw('sum(_avail_units * _avg_cost) as amount')); } if(!empty($from)) { $citems->where('created_at','>=',get_true_date($from).' 00:00:00'); } if(!empty($to)) { $citems->where('created_at','<=',get_true_date($to).' 23:59:59'); } $citems = $citems->where('branch',active_branch_id())->where('currency',$currency)->get()->first(); $cpurchases_amount = DB::table('cpurchases')->where('branch',active_branch_id())->where('currency',$currency); if(!empty($from)) { $cpurchases_amount->where('created_at','>=',get_true_date($from).' 00:00:00'); } if(!empty($to)) { $cpurchases_amount->where('created_at','<=',get_true_date($to).' 23:59:59'); } $cpurchases_amount = $cpurchases_amount->sum('total'); $total_current_stock = $citems->amount + $cpurchases_amount; $total_stock = $opening_stock + $total_purchase_amount; $sales_amount = DB::table('sales')->where('main_approval','approved')->where('branch',active_branch_id())->where('currency',$currency); if(!empty($from)) { $sales_amount->where('created_at','>=',get_true_date($from).' 00:00:00'); } if(!empty($to)) { $sales_amount->where('created_at','<=',get_true_date($to).' 23:59:59'); } $sales_amount = $sales_amount->sum('sub_total'); $project_assign_amount = DB::table('projects_assign')->where('branch',active_branch_id())->where('project_currency',$currency)->where('assign_type','material')->where('status','passed'); if(!empty($from)) { $project_assign_amount->where('created_at','>=',get_true_date($from).' 00:00:00'); } if(!empty($to)) { $project_assign_amount->where('created_at','<=',get_true_date($to).' 23:59:59'); } $project_assign_amount = $project_assign_amount->sum('item_total'); $total_sale_amount = $sales_amount + $project_assign_amount; $profit = $total_sale_amount + $total_current_stock - $total_stock; return get_profit_and_loss_statement($services,$sales,$transfer_out,$sales_return,$purchases,$production,$expenses,$profit); } function manage_profit_loss_data_pharmaone($currency,$from,$to) { $sales_amount = DB::table('sales')->where('main_approval','approved')->where('branch',active_branch_id()); if(!empty($currency)){ $sales_amount->where('currency',$currency); } if(!empty($from)){ $sales_amount->where('created_at','>=',get_true_date($from).' 00:00:00');} if(!empty($to)){ $sales_amount->where('created_at','<=',get_true_date($to).' 23:59:59'); } $sales_amount = $sales_amount->sum('sub_total'); $sales_return_amount = DB::table('sales_return')->where('branch',active_branch_id()); if(!empty($currency)){ $sales_return_amount->where('currency',$currency); } if(!empty($from)){ $sales_return_amount->where('created_at','>=',get_true_date($from).' 00:00:00');} if(!empty($to)){ $sales_return_amount->where('created_at','<=',get_true_date($to).' 23:59:59'); } $sales_return_amount = $sales_return_amount->sum('refund_total'); $transfer_out_amount = DB::table('transfer_out')->where('branch',active_branch_id()); if(!empty($currency)){ $transfer_out_amount->where('currency',$currency); } if(!empty($from)){ $transfer_out_amount->where('created_at','>=',get_true_date($from).' 00:00:00');} if(!empty($to)){ $transfer_out_amount->where('created_at','<=',get_true_date($to).' 23:59:59'); } $transfer_out_amount = $transfer_out_amount->sum('gross_total_amount'); $sales_profit = DB::table('sales')->where('main_approval','approved')->where('branch',active_branch_id()); if(!empty($currency)){ $sales_profit->where('currency',$currency); } if(!empty($from)){ $sales_profit->where('created_at','>=',get_true_date($from).' 00:00:00');} if(!empty($to)){ $sales_profit->where('created_at','<=',get_true_date($to).' 23:59:59'); } $sales_profit = $sales_profit->sum('total_profit_amount'); $sales_return_profit = DB::table('sales_return')->where('branch',active_branch_id()); if(!empty($currency)){ $sales_return_profit->where('currency',$currency); } if(!empty($from)){ $sales_return_profit->where('created_at','>=',get_true_date($from).' 00:00:00');} if(!empty($to)){ $sales_return_profit->where('created_at','<=',get_true_date($to).' 23:59:59'); } $sales_return_profit = $sales_return_profit->sum('return_profit'); $transfer_out_profit = DB::table('transfer_out')->where('branch',active_branch_id()); if(!empty($currency)){ $transfer_out_profit->where('currency',$currency); } if(!empty($from)){ $transfer_out_profit->where('created_at','>=',get_true_date($from).' 00:00:00');} if(!empty($to)){ $transfer_out_profit->where('created_at','<=',get_true_date($to).' 23:59:59'); } $transfer_out_profit = $transfer_out_profit->sum('profit'); $extra_income_amount = DB::table('extra_income')->where('branch',active_branch_id()); if(!empty($currency)){ $extra_income_amount->where('currency',$currency); } if(!empty($from)){ $extra_income_amount->where('created_at','>=',get_true_date($from).' 00:00:00');} if(!empty($to)){ $extra_income_amount->where('created_at','<=',get_true_date($to).' 23:59:59'); } $extra_income_amount = $extra_income_amount->sum('amount'); $expenses_amount = DB::table('expenses')->where('main_approval','approved')->where('branch',active_branch_id()); if(!empty($currency)){ $expenses_amount->where('currency',$currency); } if(!empty($from)){ $expenses_amount->where('created_at','>=',get_true_date($from).' 00:00:00');} if(!empty($to)){ $expenses_amount->where('created_at','<=',get_true_date($to).' 23:59:59'); } $expenses_amount = $expenses_amount->sum('amount'); $salary_amount = DB::table('payslips')->where('branch',active_branch_id())->where('status','confirm'); if(!empty($currency)){ $salary_amount->where('currency',$currency); } if(!empty($from)){ $salary_amount->where('created_at','>=',get_true_date($from).' 00:00:00');} if(!empty($to)){ $salary_amount->where('created_at','<=',get_true_date($to).' 23:59:59'); } $salary_amount = $salary_amount->sum('net_salary'); $salary_advance_amount = DB::table('payslips')->where('branch',active_branch_id())->where('status','confirm'); if(!empty($currency)){ $salary_advance_amount->where('currency',$currency); } if(!empty($from)){ $salary_advance_amount->where('created_at','>=',get_true_date($from).' 00:00:00');} if(!empty($to)){ $salary_advance_amount->where('created_at','<=',get_true_date($to).' 23:59:59'); } $salary_advance_amount = $salary_advance_amount->sum('advance_amount'); $total_expenses_amount = (float)$expenses_amount + (float)$salary_amount + (float)$salary_advance_amount; $net_profit = (float)$sales_profit - (float)$sales_return_profit + (float)$transfer_out_profit + (float)$extra_income_amount - (float)$total_expenses_amount; return [ 'sales_amount' => $sales_amount, 'sales_return_amount' => $sales_return_amount, 'transfer_out_amount' => $transfer_out_amount, 'sales_profit' => $sales_profit, 'sales_return_profit' => $sales_return_profit, 'transfer_out_profit' => $transfer_out_profit, 'extra_income_amount' => $extra_income_amount, 'expenses_amount' => $total_expenses_amount, 'net_profit' => $net_profit, ]; } function get_profit_and_loss_statement($services,$sales,$transfer_out,$sales_return,$purchases,$production,$expenses,$profit) { $total_services = array(); $total_sales = array(); $total_sales_return = array(); $total_profits = array(); $total_profits_sales = array(); $total_expenses = array(); $records = array(); foreach($sales as $row) { $sale_sub_total = (float)$row['sub_total']; $sale_profit = (float)$row['total_profit_amount']; $total_profits[] = $sale_profit; $total_profits_sales[] = $sale_profit; if($sale_sub_total > 0) { $narration = 'Sales# '.$row['invoice'].' | Paid: '.round_decimels_digits((float)$row['cash_received']).' | TraExp: '.round_decimels_digits((float)$row['trans_expense']); $total_sales[] = $sale_sub_total; $records[] = array( 'date' => $row['created_at'], 'account' => 'Sale Amount', 'narration' => '<a href="'.url('/sales/invoice').'/'.$row['uid'].'" target="_blank">'.$narration.'</a>', 'amount' => $sale_sub_total, ); } if(1 == 2) { $sale_trans_expense = (float)$row['trans_expense']; if($sale_trans_expense > 0) { $total_expenses[] = $sale_trans_expense; $records[] = array( 'date' => $row['created_at'], 'account' => 'Sale transport expenses', 'narration' => 'Sales# '.$row['invoice'].' | Total: '.round_decimels_digits((float)$row['sub_total']).' | Paid: '.round_decimels_digits((float)$row['cash_received']), 'amount' => $sale_trans_expense, ); } } $sale_items_details = json_decode($row['items_details'],true); foreach($sale_items_details as $sinnerow) { $sale_qty = (float)$sinnerow['qty']; $sale_profit_per_item = (float)$sinnerow['profit']; $sale_profit = $sale_profit_per_item * $sale_qty; if($sale_profit > 0) { $narration = 'Sales# '.$row['invoice'].' | Total: '.round_decimels_digits((float)$row['sub_total']).' | Paid: '.round_decimels_digits((float)$row['cash_received']); $records[] = array( 'date' => $row['created_at'], 'account' => 'Sale profit', 'narration' => '<a href="'.url('/sales/invoice').'/'.$row['uid'].'" target="_blank">'.$narration.'</a>', 'amount' => $sale_profit, ); } } } foreach($transfer_out as $row) { $transfer_out_profit = (float)$row['profit']; $transfer_out_amount = (float)$row['gross_total_amount']; $total_sales[] = $transfer_out_amount; if($transfer_out_profit > 0) { $total_profits[] = $transfer_out_profit; } } foreach($sales_return as $row) { $sale_return_sub_total = (float)$row['refund_total']; if($sale_return_sub_total > 0) { $narration = 'Sales Return# '.$row['return_invoice'].' | Paid: '.round_decimels_digits((float)$row['refund_received']); $total_sales_return[] = $sale_return_sub_total; $records[] = array( 'date' => $row['created_at'], 'account' => 'Sale Return Amount', 'narration' => '<a href="'.url('/sales-return/invoice').'/'.$row['uid'].'" target="_blank">'.$narration.'</a>', 'amount' => $sale_return_sub_total, ); } } foreach($services as $row) { $services_gross_total = (float)$row['gross_total']; $total_services[] = (float)$row['gross_total']; if($services_gross_total > 0) { $narration = 'Services: INVOICE# '.$row['invoice'].' | Total: '.round_decimels_digits((float)$row['gross_total']); $total_profits[] = $services_gross_total; $records[] = array( 'date' => $row['created_at'], 'account' => 'Services Profit', 'narration' => '<a href="'.url('/services/invoice').'/'.$row['uid'].'" target="_blank">'.$narration.'</a>', 'amount' => $services_gross_total, ); } } foreach($purchases as $row) { $purchase_items_details = json_decode($row['items'],true); foreach($purchase_items_details as $pinnerow) { $purchase_transport_expense = 0; if($purchase_transport_expense > 0) { $narration = 'Trans Exp: PRCHS# '.$row['invoice'].' | Total: '.round_decimels_digits((float)$row['sub_total_amount']).' | Paid: '.round_decimels_digits((float)$row['paid_amount']); $total_expenses[] = $purchase_transport_expense; $records[] = array( 'date' => $row['created_at'], 'account' => 'Purchase transport expenses', 'narration' => '<a href="'.url('/purchases/invoice').'/'.$row['uid'].'" target="_blank">'.$narration.'</a>', 'amount' => $purchase_transport_expense, ); } } } foreach($production as $row) { $parent_production = fetch_table_where('production','uid',$row['production_id'],true); $production_extra_expense = (float)$row['expense'] * ((float)$row['qty'] + (float)$row['damage']); if($production_extra_expense > 0) { $narration = 'Extra Exp: PRDCTN# '.$parent_production['invoice'].' | Produced Cost: '.round_decimels_digits((float)$parent_production['total_produced_cost']).' | Raw Cost: '.round_decimels_digits((float)$parent_production['total_raw_cost']); $total_expenses[] = $production_extra_expense; $records[] = array( 'date' => $row['created_at'], 'account' => 'Production extra expenses', 'narration' => '<a href="'.url('/production/invoice').'/'.$parent_production['uid'].'" target="_blank">'.$narration.'</a>', 'amount' => $production_extra_expense, ); } } foreach($expenses as $row) { $expense_amount = (float)$row['amount']; if($expense_amount > 0) { $total_expenses[] = $expense_amount; $records[] = array( 'date' => $row['created_at'], 'account' => 'Expenses', 'narration' => $row['narration'], 'amount' => $expense_amount, ); } } $total_profits = array_sum($total_profits_sales); return array( 'sales' => array_sum($total_sales), 'sales_return' => array_sum($total_sales_return), 'services' => array_sum($total_services), 'profits' => $profit, 'expenses' => array_sum($total_expenses), 'net_profit' => $profit - array_sum($total_expenses), 'records' => sort_data_date_wise($records,'date'), ); } function get_marketer_income_statement($services,$sales,$sales_return,$expenses,$search_convert_currency) { $total_services = array(); $total_sales = array(); $total_sales_return = array(); $total_incomes = array(); $total_paid = array(); $total_pending = array(); $total_incentives = array(); $total_expenses = array(); $records_incomes = array(); $records_expenses = array(); foreach($sales as $row) { $sale_sub_total = (float)$row['sub_total']; $qty_total = array(); $marketer_amount = 0; if(!empty($search_convert_currency)) { $convert_currency_record = fetch_table_where('currency','uid',$search_convert_currency,true); $currency_show = $convert_currency_record['name']; $amount_currency_equalance = $row['currency_usd_equalance']; $convert_currency_equalance = $convert_currency_record['usd_equalance']; if($row['currency'] == $search_convert_currency) { $amount_currency_equalance = 1; $convert_currency_equalance = 1; } $sale_sub_total = amount_conversion((float)$row['sub_total'], $amount_currency_equalance, $convert_currency_equalance); } if($sale_sub_total > 0) { $commission_type = $row['commission_type']; $marketer_commission = (float)$row['marketer_commission']; if($commission_type == 'commission') { $marketer_amount = (float)$row['sub_total'] * $marketer_commission/100; } else { $items = json_decode($row['items_details'],true); if(!empty($items)) { foreach($items as $item) { $qty_total[] = (float)$item['qty']; } } $marketer_amount = array_sum($qty_total) * $marketer_commission; } $cash_received = (float)$row['cash_received']; $remaining_amount = (float)$row['remaining_amount']; if(!empty($search_convert_currency)) { $marketer_amount = amount_conversion($marketer_amount, $amount_currency_equalance, $convert_currency_equalance); $cash_received = amount_conversion($cash_received, $amount_currency_equalance, $convert_currency_equalance); $remaining_amount = amount_conversion($remaining_amount, $amount_currency_equalance, $convert_currency_equalance); } $invoice = $row['invoice']; $total_incomes[] = $sale_sub_total; $total_incentives[] = $marketer_amount; $total_paid[] = $cash_received; $total_pending[] = $remaining_amount; $records_incomes[] = array( 'date' => $row['created_at'], 'invoice' => '<a href="'.url('/sales/invoice').'/'.$row['uid'].'" target="_blank">'.$invoice.'</a>', 'invoice_val' => $invoice, 'income' => $sale_sub_total, 'currency' => $row['currency'], 'currency_usd_equalance' => $row['currency_usd_equalance'], 'paid' => $cash_received, 'pending' => $remaining_amount, 'incentive' => $marketer_amount, 'account' => get_account_name($row['cash_received_account']), ); } } foreach($sales_return as $row) { $sale_return_sub_total = (float)$row['refund_total']; $qty_total = array(); $marketer_amount = 0; if(!empty($search_convert_currency)) { $convert_currency_record = fetch_table_where('currency','uid',$search_convert_currency,true); $currency_show = $convert_currency_record['name']; $amount_currency_equalance = $row['currency_usd_equalance']; $convert_currency_equalance = $convert_currency_record['usd_equalance']; if($row['currency'] == $search_convert_currency) { $amount_currency_equalance = 1; $convert_currency_equalance = 1; } $sale_return_sub_total = amount_conversion((float)$row['refund_total'], $amount_currency_equalance, $convert_currency_equalance); } if($sale_return_sub_total > 0) { $commission_type = $row['commission_type']; $marketer_commission = (float)$row['marketer_commission']; if($commission_type == 'commission') { $marketer_amount = (float)$row['refund_total'] * $marketer_commission/100; } else { $items = json_decode($row['items_details'],true); if(!empty($items)) { foreach($items as $item) { $qty_total[] = (float)$item['r_qty']; } } $marketer_amount = array_sum($qty_total) * $marketer_commission; } $cash_received = (float)$row['refund_received']; if(!empty($search_convert_currency)) { $marketer_amount = amount_conversion($marketer_amount, $amount_currency_equalance, $convert_currency_equalance); $cash_received = amount_conversion($cash_received, $amount_currency_equalance, $convert_currency_equalance); } $invoice = $row['return_invoice']; $total_incomes[] = $sale_return_sub_total; $total_incentives[] = $marketer_amount; $total_paid[] = $cash_received; $records_incomes[] = array( 'date' => $row['created_at'], 'invoice' => '<a href="'.url('/sales-return/invoice').'/'.$row['uid'].'" target="_blank">'.$invoice.'</a>', 'invoice_val' => $invoice, 'income' => $sale_return_sub_total, 'currency' => $row['currency'], 'currency_usd_equalance' => $row['currency_usd_equalance'], 'paid' => $cash_received, 'pending' => 0, 'incentive' => $marketer_amount, 'account' => get_account_name($row['refund_account']), ); } } foreach($services as $row) { $sale_sub_total = (float)$row['gross_total']; $qty_total = array(); $marketer_amount = 0; if(!empty($search_convert_currency)) { $convert_currency_record = fetch_table_where('currency','uid',$search_convert_currency,true); $currency_show = $convert_currency_record['name']; $amount_currency_equalance = $row['currency_usd_equalance']; $convert_currency_equalance = $convert_currency_record['usd_equalance']; if($row['currency'] == $search_convert_currency) { $amount_currency_equalance = 1; $convert_currency_equalance = 1; } $sale_sub_total = amount_conversion((float)$row['gross_total'], $amount_currency_equalance, $convert_currency_equalance); } if($sale_sub_total > 0) { $commission_type = $row['commission_type']; $marketer_commission = (float)$row['marketer_commission']; if($commission_type == 'commission') { $marketer_amount = (float)$row['gross_total'] * $marketer_commission/100; } else { $items = json_decode($row['details'],true); if(!empty($items)) { foreach($items as $item) { $qty_total[] = (float)$item['qty']; } } $marketer_amount = array_sum($qty_total) * $marketer_commission; } $cash_paid = (float)$row['cash_paid']; $pending_amount = (float)$row['pending_amount']; if(!empty($search_convert_currency)) { $marketer_amount = amount_conversion($marketer_amount, $amount_currency_equalance, $convert_currency_equalance); $cash_paid = amount_conversion($cash_paid, $amount_currency_equalance, $convert_currency_equalance); $pending_amount = amount_conversion($pending_amount, $amount_currency_equalance, $convert_currency_equalance); } $invoice = $row['invoice']; $total_incomes[] = $sale_sub_total; $total_incentives[] = $marketer_amount; $total_paid[] = $cash_paid; $total_pending[] = $pending_amount; $records_incomes[] = array( 'date' => $row['created_at'], 'invoice' => '<a href="'.url('/services/invoice').'/'.$row['uid'].'" target="_blank">'.$invoice.'</a>', 'invoice_val' => $invoice, 'income' => $sale_sub_total, 'currency' => $row['currency'], 'currency_usd_equalance' => $row['currency_usd_equalance'], 'paid' => $cash_paid, 'pending' => $pending_amount, 'incentive' => $marketer_amount, 'account' => get_account_name($row['cash_paid_account']), ); } } foreach($expenses as $row) { $expense_amount = (float)$row['amount']; if(!empty($search_convert_currency)) { $convert_currency_record = fetch_table_where('currency','uid',$search_convert_currency,true); $currency_show = $convert_currency_record['name']; $amount_currency_equalance = $row['currency_usd_equalance']; $convert_currency_equalance = $convert_currency_record['usd_equalance']; if($row['currency'] == $search_convert_currency) { $amount_currency_equalance = 1; $convert_currency_equalance = 1; } $expense_amount = amount_conversion((float)$row['amount'], $amount_currency_equalance, $convert_currency_equalance); } if($expense_amount > 0) { $total_expenses[] = $expense_amount; $records_expenses[] = array( 'date' => $row['created_at'], 'currency' => $row['currency'], 'currency_usd_equalance' => $row['currency_usd_equalance'], 'narration' => $row['narration'], 'account' => get_account_name($row['account']), 'amount' => $expense_amount, ); } } return array( 'total_incomes' => array_sum($total_incomes), 'total_expenses' => array_sum($total_expenses), 'total_incentives' => array_sum($total_incentives), 'total_paid' => array_sum($total_paid), 'total_pending' => array_sum($total_pending), 'balance' => array_sum($total_incentives) - array_sum($total_expenses), 'incomes' => sort_data_date_wise($records_incomes,'date'), 'expenses' => sort_data_date_wise($records_expenses,'date'), ); } function get_income_statement($accounts,$journal,$sales,$sales_return,$purchases,$production,$expensesr,$services,$currency) { $accounts = set_array_keys($accounts,'uid'); $incomes = array(); $expenses = array(); $income_records = array(); $expenses_records = array(); $services_records = array(); $accounts_for_ob = array(); foreach($accounts_for_ob as $row) { $account_opening_balances = json_decode($row['opening_balance'],true); foreach($account_opening_balances as $obrow) { if($obrow['currency'] == $currency) { $incomes[] = (float)$obrow['ob_debit']; $income_records[] = array( 'date' => $row['created_at'], 'account' => 'Opening Balance: '.$row['name'], 'narration' => $row['memo'], 'amount' => (float)$obrow['ob_debit'], ); break; } } } foreach($journal as $row) { if(array_key_exists($row['receiving_account'],$accounts)) { $account_data = $accounts[$row['receiving_account']]; if($account_data['type'] == 'client') { $incomes[] = (float)$row['receiving_amount']; $income_records[] = array( 'date' => $row['created_at'], 'account' => 'Journal: '.$account_data['name'], 'narration' => $row['receiving_narration'], 'amount' => (float)$row['receiving_amount'], ); } } } foreach($sales as $row) { $sale_cash_received = (float)$row['cash_received']; if($sale_cash_received > 0) { $incomes[] = $sale_cash_received; $income_records[] = array( 'date' => $row['created_at'], 'account' => 'Sale cash received', 'narration' => 'Sales# '.$row['invoice'].' | Total: '.round_decimels_digits((float)$row['sub_total']).' | TraExp: '.round_decimels_digits((float)$row['trans_expense']), 'amount' => $sale_cash_received, ); } } foreach($sales_return as $row) { $sale_cash_received = (float)$row['refund_received']; if($sale_cash_received > 0) { $expenses[] = $sale_cash_received; $expenses_records[] = array( 'date' => $row['created_at'], 'account' => 'Sale Return cash paid', 'narration' => 'Sales Return# '.$row['return_invoice'].' | Total: '.round_decimels_digits((float)$row['refund_total']), 'amount' => $sale_cash_received, ); } } foreach($purchases as $row) { $purchase_items_details = json_decode($row['items'],true); foreach($purchase_items_details as $pinnerow) { $purchase_transport_expense = (float)$pinnerow['transport_expense']; if($purchase_transport_expense > 0) { $narration = 'Trans Exp: PRCHS# '.$row['invoice'].' | Total: '.round_decimels_digits((float)$row['sub_total_amount']).' | Paid: '.round_decimels_digits((float)$row['paid_amount']); $expenses[] = $purchase_transport_expense; $expenses_records[] = array( 'date' => $row['created_at'], 'account' => 'Purchase transport expenses', 'narration' => '<a href="'.url('/purchases/invoice').'/'.$row['uid'].'" target="_blank">'.$narration.'</a>', 'amount' => $purchase_transport_expense, ); } } } foreach($production as $row) { $parent_production = fetch_table_where('production','uid',$row['production_id'],true); $narration = 'Extra Exp: PRDCTN# '.$parent_production['invoice'].' | Produced Cost: '.round_decimels_digits((float)$parent_production['total_produced_cost']).' | Raw Cost: '.round_decimels_digits((float)$parent_production['total_raw_cost']); $production_extra_expense = (float)$row['expense'] * ((float)$row['qty'] + (float)$row['damage']); if($production_extra_expense > 0) { $expenses[] = $production_extra_expense; $expenses_records[] = array( 'date' => $row['event_date'], 'account' => 'Production extra expenses', 'narration' => '<a href="'.url('/production/invoice').'/'.$parent_production['uid'].'" target="_blank">'.$narration.'</a>', 'amount' => $production_extra_expense, ); } } foreach($expensesr as $row) { $expense_amount = (float)$row['amount']; if($expense_amount > 0) { $expenses[] = $expense_amount; $expenses_records[] = array( 'date' => $row['created_at'], 'account' => 'Expenses', 'narration' => $row['narration'], 'amount' => $expense_amount, ); } } foreach($services as $row) { $services_cash_received = (float)$row['cash_paid']; if($services_cash_received > 0) { $incomes[] = $services_cash_received; $income_records[] = array( 'date' => $row['created_at'], 'account' => 'Services cash received', 'narration' => 'Services# '.$row['invoice'].' | Total: '.round_decimels_digits((float)$row['gross_total']), 'amount' => $services_cash_received, ); } } return array( 'incomes' => array_sum($incomes), 'expenses' => array_sum($expenses), 'balance' => array_sum($incomes) - array_sum($expenses), 'income_records' => sort_data_date_wise($income_records,'date'), 'expenses_records' => sort_data_date_wise($expenses_records,'date'), ); } function get_parent_wise_child_accounts($branch_root_accounts,$branch_all_accounts) { $parent_wise_accounts = array(); foreach($branch_root_accounts as $root_account) { $root_account_childs = array(); foreach($branch_all_accounts as $child_account) { if($child_account['type'] == $root_account['uid']){ $root_account_childs[] = $child_account; } } $root_account['child_accounts'] = $root_account_childs; $parent_wise_accounts[] = $root_account; } return $parent_wise_accounts; } function get_lot_paurchases_cost($currencies,$lots_purchased) { $all_in_usd = array(); foreach($lots_purchased as $lot) { if(array_key_exists($lot['currency'],$currencies)) { $lot_currency_usd_equalance = (float)$lot['currency_usd_equalance']; if($lot_currency_usd_equalance <= 0){ $lot_currency_usd_equalance = 1; } $lot_list = json_decode($lot['lot_list'],true); foreach($lot_list as $list_item) { $real_cost = (float)$list_item['real_cost']; $weight = (float)$list_item['weight']; $purchases_cost = $weight * $real_cost; if(!array_key_exists('purchases_cost',$currencies[$lot['currency']])){ $currencies[$lot['currency']]['purchases_cost'] = array(); } $currencies[$lot['currency']]['purchases_cost'][] = $purchases_cost; $usd_currency_usd_equalance = 1; $all_in_usd[] = amount_conversion($purchases_cost, $lot_currency_usd_equalance, $usd_currency_usd_equalance); } } } return array('currencies' => $currencies, 'all_in_usd' => $all_in_usd); } function get_sales_service($sales) { $data_array = array(); foreach($sales as $sale) { $items = json_decode($sale['items_details'],true); foreach($items as $item) { if(strpos($item['item'],"MITNAME_") !== FALSE) { $item_name = str_replace('MITNAME_', '', $item['item']); $data_array[] = array( 'uid'=>$sale['uid'], 'date'=>$sale['created_at'], 'item'=>$item_name, 'unit'=>$item['unit'], 'qty'=>$item['qty'], 'cost'=>$item['cost'], 'sale_price'=>$item['sale_price'], 'profit'=>$item['profit'], 'invoice_number'=>$sale['invoice'], ); } } } return $data_array; } ?>