<?php  function get_car_purchase_invoice() { $active_branch_id = active_branch_id(); $max_id = DB::table('car_purchases')->where('branch',$active_branch_id)->max('invoice'); return (int)$max_id + 1; } function get_serial_id($table) { $active_branch_id = active_branch_id(); $max_id = DB::table($table)->where('branch',$active_branch_id)->max('serial_id'); return (int)$max_id + 1; } function std_obj_to_array($obj) { return json_decode(json_encode($obj),true); } function print_rr($array) { echo "<pre>"; print_r($array); echo "</pre>"; die; } function generate_uid($prefix=NULL) { $micro_time = microtime(true); $date_n_time = date('YmdHis', intval($micro_time)); $nano_seconds = (int)($micro_time * 1000000000); return $prefix.$date_n_time.$nano_seconds; } function get_branch_safe_account() { $data = DB::table('accounts')->where('branch',active_branch_id())->where('uid','like','SAFEACCOUNT%')->get()->first(); return json_decode(json_encode($data),true); } function randomUniqeId() { return uniqid('RTITEM'); } function fetch_branch_users() { $branch_id = active_branch_id(); $data = DB::table('users')->where('branch',$branch_id)->orWhere('role','SUPERADMIN')->get(); return json_decode(json_encode($data),true); } function compare_dates($expiry_date) { $today = date('Y-m-d'); $today = new DateTime($today); $expiry_date = new DateTime($expiry_date); if($today >= $expiry_date) { return FALSE; } else { return TRUE; } } function check_date_between_two_dates($check_date,$date_begun,$date_end) { $check_date = new DateTime($check_date); $date_begun = new DateTime($date_begun); $date_end = new DateTime($date_end); if($check_date >= $date_begun AND $check_date <= $date_end) { return true; } else { return false; } } function get_logged_user_data($info) { $user_id = Session::get('user_id'); $user_data = fetch_table_where('users','uid',$user_id,true); return $user_data[$info]; } function is_project_user() { $log_type_status = Session::get('log_type_status'); if($log_type_status == 'project_user') { return true; } else { return false; } } function get_month_days($year,$month) { $date = $year.'-'.$month.'-01'; $last_date = date("Y-m-t", strtotime($date)); return explode('-',$last_date)[2]; } function get_day_name($year,$month,$day) { $date = $year.'-'.$month.'-'.$day; return date("l", strtotime($date)); } function is_admin() { $user_role = Session::get('user_role'); if($user_role == 'ADMIN') { return true; } else { return false; } } function is_super_admin() { $user_role = Session::get('user_role'); if($user_role == 'SUPERADMIN') { return true; } else { return false; } } function is_branch_active() { if(Session::get('branch_status') == 'active') { return TRUE; } else { return FALSE; } } function active_branch_id() { return Session::get('branch_uid'); } function active_branch_data() { return fetch_table_where('branches','uid',Session::get('branch_uid'),true); } function menu_settings_array() { return [ '' => '' ]; } function get_production_invoice_number() { $active_branch_id = active_branch_id(); $invoices_counters = DB::table('branches')->where('uid',$active_branch_id)->get(); if($invoices_counters->count() > 0) { $invoices_counters = json_decode(json_encode($invoices_counters[0]),true); $production_invoice_counter = (float)$invoices_counters['production_invoice_counter']; if($production_invoice_counter <= 0){ $production_invoice_counter = 1; } if(DB::table('production')->count() > 0) { $max_id = DB::table('production')->max('invoice'); $max_id = (int)$max_id; if($production_invoice_counter > $max_id) { return $production_invoice_counter; } else { return $max_id+1; } } else { return $production_invoice_counter; } } else { return '1'; } } function get_production_raw_invoice_number() { $active_branch_id = active_branch_id(); $max_id = DB::table('production_raw')->where('branch',$active_branch_id)->max('invoice'); $max_id = (int)$max_id; return $max_id+1; } function get_sale_invoice_number() { $active_branch_id = active_branch_id(); $invoices_counters = DB::table('branches')->where('uid',$active_branch_id)->get(); if($invoices_counters->count() > 0) { $invoices_counters = json_decode(json_encode($invoices_counters[0]),true); $sales_invoice_counter = (float)$invoices_counters['sales_invoice_counter']; if($sales_invoice_counter <= 0){ $sales_invoice_counter = 1; } if(DB::table('sales')->where('branch',$active_branch_id)->count() > 0) { $max_id = DB::table('sales')->where('branch',$active_branch_id)->max('invoice'); $max_id = (int)$max_id; if($sales_invoice_counter > $max_id) { return $sales_invoice_counter; } else { return $max_id+1; } } else { return $sales_invoice_counter; } } else { return '1'; } } function get_sales_refund_number() { $active_branch_id = active_branch_id(); $max_id = DB::table('sales_return')->where('branch',$active_branch_id)->max('return_invoice'); $refund_invoice_counter = (int)$max_id + 1; return $refund_invoice_counter; } function get_transfer_in_invoice_number() { $active_branch_id = active_branch_id(); $max_id = DB::table('transfer_in')->where('branch',$active_branch_id)->max('invoice'); $transfer_in_invoice_counter = (int)$max_id + 1; return $transfer_in_invoice_counter; } function get_transfer_out_invoice_number() { $active_branch_id = active_branch_id(); $max_id = DB::table('transfer_out')->where('branch',$active_branch_id)->max('invoice'); $transfer_out_invoice_counter = (int)$max_id + 1; return $transfer_out_invoice_counter; } function get_services_invoice_number() { $active_branch_id = active_branch_id(); $max_id = DB::table('services')->where('branch',$active_branch_id)->max('invoice'); $services_invoice_counter = (int)$max_id + 1; return $services_invoice_counter; } function get_debit_credit_note_invoice_number() { $active_branch_id = active_branch_id(); $max_id = DB::table('debit_credit_note')->where('branch',$active_branch_id)->max('invoice'); $db_cr_invoice_counter = (int)$max_id + 1; return $db_cr_invoice_counter; } function get_journal_invoice_number() { $active_branch_id = active_branch_id(); $max_id = DB::table('journal')->where('branch',$active_branch_id)->max('invoice'); $journal_invoice_counter = (int)$max_id + 1; return $journal_invoice_counter; } function get_debit_credit_voucher_invoice_number() { $active_branch_id = active_branch_id(); $max_id = DB::table('debit_credit_vouchers')->where('branch',$active_branch_id)->max('invoice'); $db_cr_invoice_counter = (int)$max_id + 1; return $db_cr_invoice_counter; } function get_items_for_item_stock_balance() { $item_query = DB::table('item_stock_balance')->where('branch', active_branch_id()); $item_query->select( 'item', 'item_name', DB::raw('
                sum(in_quantity) as in_quantity_total, 
                sum(out_quantity) as out_quantity_total, 
                sum(in_quantity) - sum(out_quantity) as available' ) ); $item_query->groupBy('item'); $item_query->groupBy('item_name'); $item_query = std_obj_to_array($item_query->get()); return $item_query; } function get_booking_invoice_number() { $active_branch_id = active_branch_id(); $max_id = DB::table('bookings')->where('branch',$active_branch_id)->max('invoice'); $bookings_counter = (int)$max_id + 1; return $bookings_counter; } function get_active_marketer() { $marketer = NULL; $user_id = Session::get('user_id'); $user_data = fetch_table_where('users','uid',$user_id,true); if($user_data['is_marketer'] == 'yes') { $marketer = $user_data['marketer']; } return $marketer; } function is_marketer_user() { $user_id = Session::get('user_id'); $user_data = fetch_table_where('users','uid',$user_id,true); if($user_data['is_marketer'] == 'yes') { return true; } else { return false; } } function get_active_sales_man() { $marketer = NULL; $user_id = Session::get('user_id'); $user_data = fetch_table_where('users','uid',$user_id,true); if($user_data['is_sales_man'] == 'yes') { $marketer = $user_data['sales_man']; } return $marketer; } function is_sales_man_user() { $user_id = Session::get('user_id'); $user_data = fetch_table_where('users','uid',$user_id,true); if($user_data['is_sales_man'] == 'yes') { return true; } else { return false; } } function is_customer_user() { $user_id = Session::get('user_id'); $user_data = fetch_table_where('users','uid',$user_id,true); if($user_data['is_customer'] == 'yes') { return true; } else { return false; } } function get_active_customer() { $customer = NULL; $user_id = Session::get('user_id'); $user_data = fetch_table_where('users','uid',$user_id,true); if($user_data['is_customer'] == 'yes') { $customer = $user_data['customer']; } return $customer; } function get_account_name($uid) { $user_data = fetch_table_where('accounts','uid',$uid,true); return isset($user_data['name']) ? $user_data['name'] : NULL; } function get_account_address($uid) { $user_data = fetch_table_where('accounts','uid',$uid,true); return $user_data['address']; } function get_services_quotation_invoice_number() { $active_branch_id = active_branch_id(); $max_id = DB::table('services_quotation')->where('branch',$active_branch_id)->max('invoice'); $services_invoice_counter = (int)$max_id + 1; return $services_invoice_counter; } function get_quotation_quotation_number() { $active_branch_id = active_branch_id(); $invoices_counters = DB::table('branches')->where('uid',$active_branch_id)->get(); if($invoices_counters->count() > 0) { $invoices_counters = json_decode(json_encode($invoices_counters[0]),true); $sales_invoice_counter = (float)$invoices_counters['sales_invoice_counter']; if($sales_invoice_counter <= 0){ $sales_invoice_counter = 1; } if(DB::table('quotations')->where('branch',$active_branch_id)->count() > 0) { $max_id = DB::table('quotations')->where('branch',$active_branch_id)->max('invoice'); $max_id = (int)$max_id; if($sales_invoice_counter > $max_id) { return $sales_invoice_counter; } else { return $max_id+1; } } else { return $sales_invoice_counter; } } else { return '1'; } } function get_transit_id() { return db_unique_id('transit'); } function get_lot_id() { return db_unique_id('lot'); } function fetch_lot_sold_invoices() { $sold_invoices = array(); $lot_sales = fetch_table_branch('lot_sold'); foreach($lot_sales as $row){ $sold_invoices[] = array('currency' => $row['currency'], 'client' => $row['client'], 'invoice' => $row['invoice']); } return $sold_invoices; } function get_lot_sold_invoice() { $active_branch_id = active_branch_id(); $max_id = DB::table('lot_sold')->where('branch',$active_branch_id)->max('invoice'); $max_id = (int)$max_id; if($max_id == 0){ $max_id = 99; } return $max_id+1; } function get_lot_purchase_invoice() { $active_branch_id = active_branch_id(); $max_id = DB::table('lot')->where('branch',$active_branch_id)->max('receipt'); $max_id = (int)$max_id; if($max_id == 0){ $max_id = 99; } return $max_id+1; } function sorted_lot_records($lots_purchased,$lots_sold,$lots_moved) { $lots_sold = set_array_keys($lots_sold,'child'); $lots_moved = set_array_keys($lots_moved,'lot_child_id'); $lots_bucket = array(); foreach($lots_purchased as $lot_purchase) { $lot_list = json_decode($lot_purchase['lot_list'],true); foreach($lot_list as $list_item) { $item_sold_data = array(); $item_moved_data = array(); $item_status = 'AVAILABLE'; if(array_key_exists($list_item['uid'], $lots_sold)) { $item_status = 'SOLD'; $item_sold_data = $lots_sold[$list_item['uid']]; } if(array_key_exists($list_item['uid'], $lots_moved)) { $item_status = 'MOVED'; $item_moved_data = $lots_moved[$list_item['uid']]; } $list_item['item_lot_purchase_type'] = 'lot'; $lot_purchase['nest_item_data'] = $list_item; $lot_purchase['nest_item_status'] = $item_status; $lot_purchase['nest_item_sold_data'] = $item_sold_data; $lot_purchase['nest_item_moved_data'] = $item_moved_data; $lots_bucket[] = $lot_purchase; } $division_list = json_decode($lot_purchase['division_list'],true); foreach($division_list as $division_list_item) { $item_sold_data = array(); $item_status = 'AVAILABLE'; if(array_key_exists($division_list_item['uid'], $lots_sold)) { $item_status = 'SOLD'; $item_sold_data = $lots_sold[$division_list_item['uid']]; } if(array_key_exists($division_list_item['uid'], $lots_moved)) { $item_status = 'MOVED'; $item_moved_data = $lots_moved[$division_list_item['uid']]; } $division_list_item['item_lot_purchase_type'] = 'division'; $lot_purchase['nest_item_data'] = $division_list_item; $lot_purchase['nest_item_status'] = $item_status; $lot_purchase['nest_item_sold_data'] = $item_sold_data; $lot_purchase['nest_item_moved_data'] = $item_moved_data; $lots_bucket[] = $lot_purchase; } } return $lots_bucket; } function get_branch_image($image_type) { $active_branch_id = active_branch_id(); $branch_data = DB::table('branches')->where('uid',$active_branch_id)->get(); if($branch_data->count() > 0) { $branch_data = json_decode(json_encode($branch_data[0]),true); if($image_type == 'banner') { $branch_image = base_path().'/uploads/branches/'.$branch_data['branch_banner_invoices']; if(is_file($branch_image)) { return url('/').'/uploads/branches/'.$branch_data['branch_banner_invoices']; } else { return url('/assets/img/invoices/invoice_banner.jpg'); } } if($image_type == 'bookings') { $branch_image = base_path().'/uploads/branches/'.$branch_data['branch_banner_bookings']; if(is_file($branch_image)) { return url('/').'/uploads/branches/'.$branch_data['branch_banner_bookings']; } else { return url('/assets/img/invoices/invoice_banner.jpg'); } } if($image_type == 'return') { $branch_image = base_path().'/uploads/branches/'.$branch_data['branch_banner_return']; if(is_file($branch_image)) { return url('/').'/uploads/branches/'.$branch_data['branch_banner_return']; } else { return url('/assets/img/invoices/invoice_banner_return.jpg'); } } if($image_type == 'logo') { $branch_image = base_path().'/uploads/branches/'.$branch_data['branch_logo']; if(is_file($branch_image)) { return url('/').'/uploads/branches/'.$branch_data['branch_logo']; } else { return url('/assets/img/invoices/branch_logo.png'); } } if($image_type == 'report') { $branch_image = base_path().'/uploads/branches/'.$branch_data['branch_banner_reports']; if(is_file($branch_image)) { return url('/').'/uploads/branches/'.$branch_data['branch_banner_reports']; } else { return url('/assets/img/invoices/report_banner.jpg'); } } } else { if($image_type == 'banner') { return url('/assets/img/invoices/invoice_banner.jpg'); } if($image_type == 'logo') { return url('/assets/img/invoices/branch_logo.png'); } if($image_type == 'report') { return url('/assets/img/invoices/report_banner.jpg'); } } } function is_log_in() { $logged_status = Session::get('logged_status'); if($logged_status == 'active') { $user_id = Session::get('user_id'); $user_data = fetch_table_where('users','uid',$user_id,true); if($user_data['uid'] == $user_id) { return TRUE; } else { Session::flush(); return FALSE; } } else { return FALSE; } } function check_user_access($role) { $user_id = Session::get('user_id'); $user_data = fetch_table_where('users','uid',$user_id,true); if($user_data['role'] == 'SUPERADMIN' OR $user_data['role'] == 'ADMIN') { return TRUE; } else { $rights = array(); if(!empty($user_data['rights'])){ $rights = json_decode($user_data['rights']); } if(in_array($role,$rights)) { return TRUE; } else { return FALSE; } } } function check_user_access_quick($right,$user_data) { if($user_data['role'] == 'SUPERADMIN' OR $user_data['role'] == 'ADMIN') { return TRUE; } else { $rights = array(); if(!empty($user_data['rights'])){ $rights = json_decode($user_data['rights']); } if(in_array($right,$rights)) { return TRUE; } else { return FALSE; } } } function getUniqueId($prefix = NULL, $table, $column) { $uniqueId = uniqid($prefix, true); $uniqueId = explode('.',$uniqueId)[0]; $uniqueId = strtoupper($uniqueId); if(DB::table($table)->where($column,$uniqueId)->count() > 0) { return $this->getUniqueId($prefix, $table, $column); } else { return $uniqueId; } } function get_simple_unique_id($prefix = NULL) { $uniqueId = uniqid($prefix, true); $uniqueId = explode('.',$uniqueId)[0]; $uniqueId = strtoupper($uniqueId); return $uniqueId; } function db_unique_id($table,$prefix=NULL) { $max_id = DB::table($table)->max('id'); $max_id = (int)$max_id; $max_id = $max_id+1; return $prefix.$max_id; } function this_is_unique($value, $table, $column) { if(DB::table($table)->where($column,$value)->count() > 0) { return false; } else { return true; } } function sort_data_date_wise($array,$sort_col) { usort($array, function($a, $b) use ($sort_col) { return new DateTime($a[$sort_col]) <=> new DateTime($b[$sort_col]); }); return $array; } function fetch_table($table,$first = FALSE) { if($first == FALSE) { $data = DB::table($table)->get(); } else { $data = DB::table($table)->get()->first(); } $data = json_decode(json_encode($data),true); return $data; } function fetch_table_branch($table,$first = FALSE) { $branch_id = active_branch_id(); if($first == FALSE) { $data = DB::table($table)->where('branch',$branch_id)->get(); } else { $data = DB::table($table)->where('branch',$branch_id)->get()->first(); } $data = json_decode(json_encode($data),true); return $data; } function fetch_table_where($table,$column,$value,$first = FALSE) { if($first == FALSE) { $data = DB::table($table)->where($column,$value)->get(); } else { $data = DB::table($table)->where($column,$value)->get()->first(); } $data = json_decode(json_encode($data),true); return $data; } function fetch_table_where_branch($table,$column,$value,$first = FALSE) { $branch_id = active_branch_id(); if($first == FALSE) { $data = DB::table($table)->where($column,$value)->where('branch',$branch_id)->get(); } else { $data = DB::table($table)->where($column,$value)->where('branch',$branch_id)->get()->first(); } $data = json_decode(json_encode($data),true); return $data; } function set_array_keys($array,$key) { $newArray = array(); foreach($array as $row) { $newArray[$row[$key]] = $row; } return $newArray; } function round_decimels_digits($amount){ return round($amount,2,PHP_ROUND_HALF_UP); } function round_decimels_digits_3($amount){ return round($amount,3,PHP_ROUND_HALF_UP); } function amount_number_format_0($amount){ return number_format((float)$amount, 0); } function amount_number_format($amount){ return number_format((float)$amount, 2); } function amount_number_format_3($amount){ return number_format((float)$amount, 3); } function get_prev_tewelve_months() { $months = array(); $dateTime = new DateTime('first day of this month'); for($i = 1; $i <= 12; $i++) { $months[] = $dateTime->format('Y-m'); $dateTime->modify('-1 month'); } return array_reverse($months); } function get_new_account_code() { $account_code = DB::table('accounts')->max('code'); $account_code = (int)$account_code; if($account_code == 0) { $account_code = 100; } else { $account_code = $account_code+1; } return $account_code; } function get_new_item_id() { $active_branch_id = active_branch_id(); $max_id = DB::table('items')->where('branch',$active_branch_id)->max('item_id'); $max_id = (int)$max_id; return $max_id+1; } function get_new_sale_invoice_number() { $max_id = DB::table('sales')->max('invoice'); $max_id = (int)$max_id; return $max_id+1; } function get_new_money_receipt_invoice_number() { $active_branch_id = active_branch_id(); $max_id = DB::table('money_receipts')->where('branch',$active_branch_id)->max('invoice'); $max_id = (int)$max_id; return $max_id+1; } function fetch_root_accounts() { $active_branch_id = active_branch_id(); $data = DB::table('accounts')->where('type','root')->where(function($query) use ($active_branch_id){ $query->where('branch','general')->orWhere('branch',$active_branch_id); })->get(); return json_decode(json_encode($data),true); } function fetch_all_accounts() { $active_branch_id = active_branch_id(); $data = DB::table('accounts')->where(function($query) use ($active_branch_id){ $query->where('shared','yes')->orWhere('branch','general')->orWhere('branch',$active_branch_id); })->get(); return json_decode(json_encode($data),true); } function fetch_all_accounts_branch() { $active_branch_id = active_branch_id(); $data = DB::table('accounts')->where('branch','general')->orWhere('branch',$active_branch_id)->get(); return json_decode(json_encode($data),true); } function fetch_all_clients() { $active_branch_id = active_branch_id(); $data = DB::table('accounts')->where('type','client')->where(function($query) use ($active_branch_id){ $query->where('shared','yes')->orWhere('branch',$active_branch_id); })->get(); return json_decode(json_encode($data),true); } function fetch_all_cashbooks() { $active_branch_id = active_branch_id(); $data = DB::table('accounts')->where('type','cashbook')->where(function($query) use ($active_branch_id){ $query->where('shared','yes')->orWhere('branch',$active_branch_id); })->get(); return json_decode(json_encode($data),true); } function fetch_all_clients_branchs() { $active_branch_id = active_branch_id(); $data = DB::table('accounts')->where('type','client')->where('branch',$active_branch_id)->get(); return json_decode(json_encode($data),true); } function fetch_all_cashbooks_branch() { $active_branch_id = active_branch_id(); $data = DB::table('accounts')->where('type','cashbook')->where('branch',$active_branch_id)->get(); return json_decode(json_encode($data),true); } function fetch_currencies() { $active_branch_id = active_branch_id(); $data = DB::table('currency')->where('branch','general')->orWhere('branch',$active_branch_id)->get(); return json_decode(json_encode($data),true); } function fetch_nested_accounts() { $active_branch_id = active_branch_id(); $accounts = DB::table('accounts')->where(function($query) use ($active_branch_id){ $query->where('shared','yes')->orWhere('branch','general')->orWhere('branch',$active_branch_id); })->get(); $accounts = json_decode(json_encode($accounts),true); $root_accounts = array(); $accounts_box = array(); foreach($accounts as $row) { if($row['type'] == 'root') { $root_accounts[$row['uid']] = $row['name']; } else { $account_parent = array_key_exists($row['type'], $root_accounts) ? $root_accounts[$row['type']] : NULL; $row['display_name'] = $row['name'].' ('.$account_parent.')'; $accounts_box[] = $row; } } return $accounts_box; } function fetch_nested_accounts_branch() { $active_branch_id = active_branch_id(); $accounts = DB::table('accounts')->where('branch','general')->orWhere('branch',$active_branch_id)->get(); $accounts = json_decode(json_encode($accounts),true); $root_accounts = array(); $accounts_box = array(); foreach($accounts as $row) { if($row['type'] == 'root') { $root_accounts[$row['uid']] = $row['name']; } else { $account_parent = array_key_exists($row['type'], $root_accounts) ? $root_accounts[$row['type']] : NULL; $row['display_name'] = $row['name'].' ('.$account_parent.')'; $accounts_box[] = $row; } } return $accounts_box; } function fetch_accounts_for_extra_incomes() { $active_branch_id = active_branch_id(); $accounts = DB::table('accounts')->where('branch','general')->orWhere('branch',$active_branch_id)->get(); $accounts = json_decode(json_encode($accounts),true); $root_accounts = array(); $accounts_box = array(); foreach($accounts as $row) { if($row['type'] == 'root') { $root_accounts[$row['uid']] = $row['name']; } else { if($row['type'] == 'bank' OR $row['type'] == 'cashbook') { $account_parent = array_key_exists($row['type'], $root_accounts) ? $root_accounts[$row['type']] : NULL; $row['display_name'] = $row['name'].' ('.$account_parent.')'; $accounts_box[] = $row; } } } return $accounts_box; } function fetch_calander() { $active_branch_id = active_branch_id(); $data = DB::table('calander')->where('branch',$active_branch_id)->get(); if($data->count() > 0) { return json_decode(json_encode($data[0]),true); } else { return array('id' => '1', 'name' => 'english'); } } function embed_employees_salaries($employees) { $branch_id = active_branch_id(); $employees = DB::table('employees')->where('branch',$branch_id)->where("employee_status","active"); $increments = DB::table('increments')->where('branch',$branch_id)->where('increment_date','<=',date('Y-m-t')); $advances = DB::table('advances')->where('branch',$branch_id); $payslips = DB::table('payslips')->where('branch',$branch_id)->where('status','confirm'); $employees = json_decode(json_encode($employees->get()),true); $increments = json_decode(json_encode($increments->orderBy('id','desc')->get()),true); $advances = json_decode(json_encode($advances->get()),true); $payslips = json_decode(json_encode($payslips->get()),true); $employees_bucket = array(); foreach($employees as $row) { $employee_salary = $row['joining_salary']; foreach($increments as $irow) { if($row['uid'] == $irow['employee']) { $employee_salary = (float)$irow['new_salary']; break; } } $employee_advances = array(); foreach($advances as $arow) { if($row['uid'] == $arow['employee']) { $employee_advances[] = (float)$arow['new_advance']; } } $employee_returned_advance = array(); foreach($payslips as $prow) { if($row['uid'] == $prow['employee']) { $employee_returned_advance[] = (float)$prow['advance_amount']; } } $row['stats'] = array( 'salary' => $employee_salary, 'advance' => array_sum($employee_advances) - array_sum($employee_returned_advance), ); $employees_bucket[] = $row; } return $employees_bucket; } function obj_to_array($obj){ return json_decode(json_encode($obj),true); } function fetch_last_x_entries($banks,$journal,$extra_income,$currency) { $entries_bucket = array(); $__accounts = set_array_keys(fetch_table_branch('accounts'),'uid'); foreach($journal as $row) { $entry_status = false; if(array_key_exists($row['receiving_account'],$banks) AND $row['receiving_currency'] == $currency) { $info_account = array_key_exists($row['payment_account'],$__accounts) ? $__accounts[$row['payment_account']]['name'] : NULL; $entry_status = true; $entry_time = $row['created_at']; $entry_name = $banks[$row['receiving_account']]['name']; $entry_amount = (float)$row['receiving_amount']; $entry_narration = $info_account.' '.$row['receiving_narration']; } if($entry_status === true) { $entries_bucket[] = array( 'time' => $entry_time, 'name' => $entry_name, 'amount' => $entry_amount, 'narration' => $entry_narration ); } $entry_status = false; if(array_key_exists($row['payment_account'],$banks) AND $row['payment_currency'] == $currency) { $info_account = array_key_exists($row['receiving_account'],$__accounts) ? $__accounts[$row['receiving_account']]['name'] : NULL; $entry_status = true; $entry_time = $row['created_at']; $entry_name = $banks[$row['payment_account']]['name']; $entry_amount = (float)$row['payment_amount']; $entry_narration = $info_account.' '.$row['payment_narration']; } if($entry_status === true) { $entries_bucket[] = array( 'time' => $entry_time, 'name' => $entry_name, 'amount' => $entry_amount, 'narration' => $entry_narration ); } } foreach($extra_income as $row) { $entry_status = false; if(array_key_exists($row['account'],$banks) AND $row['currency'] == $currency) { $entry_status = true; $entry_time = $row['created_at']; $entry_name = $banks[$row['account']]['name']; $entry_amount = (float)$row['amount']; $entry_narration = $row['description']; } if($entry_status === true) { $entries_bucket[] = array( 'time' => $entry_time, 'name' => $entry_name, 'amount' => $entry_amount, 'narration' => $entry_narration ); } } $entries_bucket = sort_data_date_wise($entries_bucket,'time'); $entries_bucket = array_slice($entries_bucket, -5); return $entries_bucket; } function fetch_stats_section($receivable, $payable, $received, $currency) { $_stats_receivable = isset($receivable['currencies'][$currency]['stats']) ? (float)$receivable['currencies'][$currency]['stats'] : 0; $_stats_payable = isset($payable['currencies'][$currency]['payable']) ? array_sum($payable['currencies'][$currency]['payable']) : 0; $_stats_received = isset($received['currencies'][$currency]['stats']) ? (float)$received['currencies'][$currency]['stats'] : 0; $stats_array = array(); $stats_array['receivable'] = $_stats_receivable; $stats_array['payable'] = $_stats_payable; $stats_array['received'] = $_stats_received; if($_stats_receivable < 0){ $_stats_receivable = 0; } if($_stats_payable < 0){ $_stats_payable = 0; } if($_stats_received < 0){ $_stats_received = 0; } $_all_sum = $_stats_receivable + $_stats_payable + $_stats_received; ($_all_sum <= 0) ? $_all_sum_div = 1 : $_all_sum_div = $_all_sum; $_stats_receivable_percent = ($_stats_receivable / $_all_sum_div) * 100; $_stats_payable_percent = ($_stats_payable / $_all_sum_div) * 100; $_stats_received_percent = ($_stats_received / $_all_sum_div) * 100; $stats_array['all_sum'] = $_all_sum; $stats_array['receivable_percent'] = $_stats_receivable_percent; $stats_array['payable_percent'] = $_stats_payable_percent; $stats_array['received_percent'] = $_stats_received_percent; return $stats_array; } function fetch_stats_section_new($db_stats, $currency) { $receivable = empty($db_stats['receivable_amount']) ? array() : json_decode($db_stats['receivable_amount'],true); $payable = empty($db_stats['supplier_due_amount']) ? array() : json_decode($db_stats['supplier_due_amount'],true); $received = empty($db_stats['client_received']) ? array() : json_decode($db_stats['client_received'],true); $_stats_receivable = array_key_exists($currency,$receivable) ? $receivable[$currency] : 0; $_stats_payable = array_key_exists($currency,$payable) ? $payable[$currency] : 0; $_stats_received = array_key_exists($currency,$received) ? $received[$currency] : 0; $stats_array = array(); $stats_array['receivable'] = $_stats_receivable; $stats_array['payable'] = $_stats_payable; $stats_array['received'] = $_stats_received; if($_stats_receivable < 0){ $_stats_receivable = 0; } if($_stats_payable < 0){ $_stats_payable = 0; } if($_stats_received < 0){ $_stats_received = 0; } $_all_sum = $_stats_receivable + $_stats_payable + $_stats_received; ($_all_sum <= 0) ? $_all_sum_div = 1 : $_all_sum_div = $_all_sum; $_stats_receivable_percent = ($_stats_receivable / $_all_sum_div) * 100; $_stats_payable_percent = ($_stats_payable / $_all_sum_div) * 100; $_stats_received_percent = ($_stats_received / $_all_sum_div) * 100; $stats_array['all_sum'] = $_all_sum; $stats_array['receivable_percent'] = $_stats_receivable_percent; $stats_array['payable_percent'] = $_stats_payable_percent; $stats_array['received_percent'] = $_stats_received_percent; return $stats_array; } function fetch_expenses_section($expenses_types,$expenses,$currency) { $expenses_types_bucket = array(); $expenses_amounts_bucket = array(); $_for_graphs_types_names = array(); $_for_graphs_types_amounts = array(); $_for_graphs_types_colors = array(); $exp_types_count = 0; $exp_types_max_count = 12; foreach($expenses_types as $row) { $exp_types_count++; $expense_type_amounts = array(); $expense_type_records = array(); foreach($expenses as $inner_row) { if($inner_row['type'] == $row['uid'] AND $inner_row['currency'] == $currency) { $expenses_amounts_bucket[] = (float)$inner_row['amount']; $expense_type_amounts[] = (float)$inner_row['amount']; $expense_type_records[] = $inner_row; } } if($exp_types_count <= $exp_types_max_count) { $_for_graphs_types_names[] = $row['name']; $_for_graphs_types_colors[] = empty($row['color']) ? '#008000' : $row['color']; $_for_graphs_types_amounts[] = array_sum($expense_type_amounts); $row['_expenses_total'] = array_sum($expense_type_amounts); $row['_expenses_amounts'] = $expense_type_amounts; $row['_expenses_records'] = $expense_type_records; $expenses_types_bucket[] = $row; } } return array( 'total_amount' => array_sum($expenses_amounts_bucket), '_graphs_types_names' => $_for_graphs_types_names, '_graphs_types_colors' => $_for_graphs_types_colors, '_graphs_types_amounts' => $_for_graphs_types_amounts, 'types' => $expenses_types_bucket ); } function fetch_profit_loss_section($profit,$expenses,$currency) { $profit = isset($profit['currencies'][$currency]['stock_cost']) ? array_sum($profit['currencies'][$currency]['stock_cost']) : 0; $expenses = isset($expenses['total_amount']) ? (float)$expenses['total_amount'] : 0; $net_profit = $profit - $expenses; return array('profit' => $profit, 'expenses' => $expenses, 'net_profit' => $net_profit); } function fetch_profit_loss_section_new($db_stats,$expenses,$currency) { $profit = empty($db_stats['profit_amount']) ? array() : json_decode($db_stats['profit_amount'],true); $profit = array_key_exists($currency,$profit) ? $profit[$currency] : 0; $expenses = isset($expenses['total_amount']) ? (float)$expenses['total_amount'] : 0; $net_profit = $profit - $expenses; return array('profit' => $profit, 'expenses' => $expenses, 'net_profit' => $net_profit); } function fetch_dash_alert_notifications($items) { $date_expiry_alerts = array(); $reorder_qty_alerts = array(); foreach($items as $item) { $item['stats'] = (isset($item['stats']) AND !is_array($item['stats'])) ? json_decode($item['stats'],true) : $item['stats']; if(!empty($item['reorder_qty'])) { $_item_reorder_qty = (float)$item['reorder_qty']; $_item_avail_qty = array_sum($item['stats']['avail_units']); if($_item_avail_qty <= $_item_reorder_qty) { $reorder_qty_alerts[] = array( 'id' => $item['id'], 'uid' => $item['uid'], 'item_id' => $item['item_id'], 'name' => $item['name'], 'reorder_qty' => $_item_reorder_qty, 'avail_qty' => $_item_avail_qty, ); } } if(!empty($item['expiry_date']) AND !empty($item['expiry_alert'])) { $_item_expiry_date = $item['expiry_date']; $_item_expiry_alert = (int)$item['expiry_alert']; $_item_expiry_alert_date = get_x_months_before_date($_item_expiry_date,$_item_expiry_alert); if(check_for_expiry_date($_item_expiry_alert_date) === FALSE) { $date_expiry_alerts[] = array( 'id' => $item['id'], 'uid' => $item['uid'], 'item_id' => $item['item_id'], 'name' => $item['name'], 'expiry_date' => $item['expiry_date'], 'expiry_alert' => $item['expiry_alert'], 'expiry_alert_date' => $_item_expiry_alert_date, ); } } } return array('expiry_alerts' => $date_expiry_alerts, 'qty_alerts' => $reorder_qty_alerts); } function fetch_near_expiry_items($items) { $date_expiry_alerts = array(); foreach($items as $key => $item) { $item['stats'] = (isset($item['stats']) AND !is_array($item['stats'])) ? json_decode($item['stats'],true) : $item['stats']; if(!empty($item['expiry_date']) AND !empty($item['expiry_alert'])) { $today = date('Y-m-d'); $today = new DateTime($today); $expiry_date = new DateTime($item['expiry_date']); if($today <= $expiry_date) { $_item_expiry_date = $item['expiry_date']; $_item_expiry_alert = (int)$item['expiry_alert']; $_item_expiry_alert_date = get_x_months_before_date($_item_expiry_date,$_item_expiry_alert); if(check_for_expiry_date($_item_expiry_alert_date) === FALSE) { $date_expiry_alerts[] = $item; } } } } return $date_expiry_alerts; } function fetch_expired_items($items) { $date_expiry_alerts = array(); foreach($items as $key => $item) { $item['stats'] = (isset($item['stats']) AND !is_array($item['stats'])) ? json_decode($item['stats'],true) : $item['stats']; if(!empty($item['expiry_date']) AND !empty($item['expiry_alert'])) { $today = date('Y-m-d'); $today = new DateTime($today); $expiry_date = new DateTime($item['expiry_date']); if($today > $expiry_date) { $date_expiry_alerts[] = $item; } } } return $date_expiry_alerts; } function fetch_shortage_items($items) { $reorder_qty_alerts = array(); foreach($items as $key => $item) { $item['stats'] = (isset($item['stats']) AND !is_array($item['stats'])) ? json_decode($item['stats'],true) : $item['stats']; if(!empty($item['reorder_qty'])) { $_item_reorder_qty = (float)$item['reorder_qty']; $_item_avail_qty = array_sum($item['stats']['avail_units']); if($_item_avail_qty <= $_item_reorder_qty) { $reorder_qty_alerts[] = $item; } } } return $reorder_qty_alerts; } function get_activity_alerts($limit,$activity) { $branch_id = active_branch_id(); $activity_alerts = DB::table('activity_alerts')->where('branch',$branch_id); if(!empty($activity) AND $activity != 'all'){ $activity_alerts->where('module',$activity); } $activity_alerts = json_decode(json_encode($activity_alerts->orderBy('id','desc')->limit($limit)->get()),true); return $activity_alerts; } function set_activity_alert($_details) { if(is_array($_details)) { $alert_data = array( 'uid' => generate_uid(), 'branch' => active_branch_id(), 'module' => array_key_exists('module',$_details) ? $_details['module'] : NULL, 'activity' => array_key_exists('activity',$_details) ? $_details['activity'] : NULL, 'details' => array_key_exists('details',$_details) ? $_details['details'] : NULL, 'url' => array_key_exists('url',$_details) ? $_details['url'] : NULL, 'activity_time' => date('Y-m-d H:i:s'), 'user' => get_logged_user_data('uid'), 'user_name' => get_logged_user_data('name'), ); insert_table('activity_alerts',$alert_data); } } function get_x_months_before_date($point_date,$months) { $date_obj = new DateTime($point_date); $date_obj->modify('-'.$months.' months'); return $date_obj->format('Y-m-d'); } function check_for_expiry_date($expiry_date) { $today = date('Y-m-d'); $today = new DateTime($today); $expiry_date = new DateTime($expiry_date); if($today >= $expiry_date) { return FALSE; } else { return TRUE; } } function get_elapsed_time($event_time_stamp) { $_seconds_to_words_str = ''; $event_time_stamp_unix = strtotime($event_time_stamp); $current_time_stamp = date('Y-m-d H:i:s'); $current_time_stamp_unix = strtotime($current_time_stamp); $elapsed_seconds = $current_time_stamp_unix - $event_time_stamp_unix; $elapsed_seconds = ($elapsed_seconds < 1) ? 1 : $elapsed_seconds; $_days = intval(intval($elapsed_seconds) / (3600*24)); if($_days > 0) { $_seconds_to_words_str .= $_days.( ($_days == 1) ? " Day " : " Days " ); return $_seconds_to_words_str.' Ago'; } $_hours = (intval($elapsed_seconds) / 3600) % 24; if($_hours > 0) { $_seconds_to_words_str .= $_hours.( ($_hours == 1) ? " Hour " : " Hours " ); return $_seconds_to_words_str.' Ago'; } $_minutes = (intval($elapsed_seconds) / 60) % 60; if($_minutes > 0) { $_seconds_to_words_str .= $_minutes.( ($_minutes == 1) ? " Minute " : " Minutes " ); return $_seconds_to_words_str.' Ago'; } $_seconds = intval($elapsed_seconds) % 60; if($_seconds > 0) { $_seconds_to_words_str .= $_seconds.( ($_seconds == 1) ? " Second" : " Seconds" ); return $_seconds_to_words_str.' Ago'; } return NULL; } function convert_seconds_to_Words($__seconds) { $_seconds_to_words_str = ""; $_days = intval(intval($__seconds) / (3600*24)); if($_days > 0){ $_seconds_to_words_str .= $_days.( ($_days == 1) ? " Day " : " Days " ); } $_hours = (intval($__seconds) / 3600) % 24; if($_hours > 0){ $_seconds_to_words_str .= $_hours.( ($_hours == 1) ? " Hour " : " Hours " ); } $_minutes = (intval($__seconds) / 60) % 60; if($_minutes > 0){ $_seconds_to_words_str .= $_minutes.( ($_minutes == 1) ? " Minute " : " Minutes " ); } $_seconds = intval($__seconds) % 60; if($_seconds > 0){ $_seconds_to_words_str .= $_seconds.( ($_seconds == 1) ? " Second" : " Seconds" ); } return $_seconds_to_words_str; } function get_prev_months($num_months,$date) { $date = date("Y-m-01", strtotime($date)); $months = array(); $dateTime = new DateTime($date); for($i = 1; $i <= $num_months; $i++) { $months[] = $dateTime->format('Y-m'); $dateTime->modify('-1 month'); } return array_reverse($months); } function sum_up_array_values($amounts_array) { $amounts_bucket = array(); foreach($amounts_array as $arow) { $amounts_bucket[] = $arow; } return array_sum($amounts_bucket); } function amount_conversion($amount_to_convert, $amount_usd_equalance, $conversion_usd_equalance) { $amount_to_convert = (float)$amount_to_convert; $amount_usd_equalance = (float)$amount_usd_equalance; $conversion_usd_equalance = (float)$conversion_usd_equalance; if($amount_usd_equalance == 0){ $amount_usd_equalance = 1; } $amount_to_usd = $amount_to_convert / $amount_usd_equalance; $conversion_amount = $amount_to_usd * $conversion_usd_equalance; return $conversion_amount; } function unit_based_conversion($item_data,$unit,$convert_obj) { if($unit == 'production') { $convert_obj = $convert_obj * (float)$item_data['production_unit_equalance']; } if($unit == 'sale') { $convert_obj = $convert_obj * (float)$item_data['sale_unit_equalance']; } return $convert_obj; } function amount_unit_based_conversion($item_data,$unit,$convert_obj) { if($unit == 'production') { $convert_obj = $convert_obj / (float)$item_data['production_unit_equalance']; } if($unit == 'sale') { $convert_obj = $convert_obj / (float)$item_data['sale_unit_equalance']; } return $convert_obj; } function unit_based_conversion_of_array($item_data,$unit,$array_of_units) { $converted_units = array(); foreach($array_of_units as $ukey => $urow) { if($unit == 'production') { $converted_units[$ukey] = $urow * (float)$item_data['production_unit_equalance']; } if($unit == 'sale') { $converted_units[$ukey] = $urow * (float)$item_data['sale_unit_equalance']; } } if($unit == 'purchase') { return $array_of_units; } else { return $converted_units; } } function fetch_calander_name() { $active_branch_id = active_branch_id(); $data = DB::table('calander')->where('branch',$active_branch_id)->get(); if($data->count() > 0) { $calander_name = json_decode(json_encode($data[0]),true); return $calander_name['name']; } else { return 'english'; } } function get_true_date($date) { $calander_db = fetch_calander_name(); if($calander_db == 'persian') { $date1 = $date; if (str_contains($date, '/')) { $date1 = explode('/', $date); } if (str_contains($date, '-')) { $date1 = explode('-', $date); } $year = $date1[0]; $month = $date1[1]; $day = $date1[2]; $date_arr = jalali_to_gregorian ($year, $month, $day); if($date_arr[1] < 10){ $date_arr[1] = '0'.$date_arr[1];} if($date_arr[2] < 10){ $date_arr[2] = '0'.$date_arr[2];} return $date_arr[0].'-'.$date_arr[1].'-'.$date_arr[2]; } else { $date1 = $date; if (str_contains($date, '/')) { $date1 = explode('/', $date); } if (str_contains($date, '-')) { $date1 = explode('-', $date); } $year = $date1[0]; $month = $date1[1]; $day = $date1[2]; return $year.'-'.$month.'-'.$day; } } function get_persian_date($date) { $date1 = new DateTime($date); $year = $date1->format('Y'); $month = $date1->format('m'); $day = $date1->format('d'); $date_arr = gregorian_to_jalali($year, $month, $day); return $date_arr[0].'-'.$date_arr[1].'-'.$date_arr[2]; } function get_persian_date_day($date) { $date1 = new DateTime($date); $year = $date1->format('Y'); $month = $date1->format('m'); $day = $date1->format('d'); $date_arr = gregorian_to_jalali($year, $month, $day); return $date_arr[2]; } function get_persian_date_month($date) { $date1 = new DateTime($date); $year = $date1->format('Y'); $month = $date1->format('m'); $day = $date1->format('d'); $date_arr = gregorian_to_jalali($year, $month, $day); return $date_arr[1]; } function get_persian_date_year($date) { $date1 = new DateTime($date); $year = $date1->format('Y'); $month = $date1->format('m'); $day = $date1->format('d'); $date_arr = gregorian_to_jalali($year, $month, $day); return $date_arr[0]; } function display_true_date($date) { if(empty($date)){ return $date; } $calander_db = fetch_calander_name(); $year = date('Y', strtotime($date)); $month = date('m', strtotime($date)); $day = date('d', strtotime($date)); if($calander_db == 'persian') { $date_arr = gregorian_to_jalali($year, $month, $day); return $date_arr[0].'-'.$date_arr[1].'-'.$date_arr[2]; } else { return $day.'-'.$month.'-'.$year; } } function display_true_date_filter($date,$required) { $calander_db = fetch_calander_name(); $year = date('Y', strtotime($date)); $month = date('m', strtotime($date)); $day = date('d', strtotime($date)); if($calander_db == 'persian') { $date_arr = gregorian_to_jalali($year, $month, $day); if($required == 'year') { return $date_arr[0]; } if($required == 'month') { return $date_arr[1]; } if($required == 'day') { return $date_arr[2]; } } else { if($required == 'year') { return $year; } if($required == 'month') { return $month; } if($required == 'day') { return $day; } } } function true_date_for_inputs($date) { if(empty($date)){ return $date; } $calander_db = fetch_calander_name(); if($calander_db == 'persian') { return str_replace('-', '/', $date); } else { return date('Y-m-d',strtotime($date)); } } function div($a,$b) { return (int) ($a / $b); } function gregorian_to_jalali ($g_y, $g_m, $g_d) { $g_days_in_month = array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31); $j_days_in_month = array(31, 31, 31, 31, 31, 31, 30, 30, 30, 30, 30, 29); $gy = $g_y-1600; $gm = $g_m-1; $gd = $g_d-1; $g_day_no = 365*$gy+div($gy+3,4)-div($gy+99,100)+div($gy+399,400); for ($i=0; $i < $gm; ++$i) $g_day_no += $g_days_in_month[$i]; if ($gm>1 && (($gy%4==0 && $gy%100!=0) || ($gy%400==0))) $g_day_no++; $g_day_no += $gd; $j_day_no = $g_day_no-79; $j_np = div($j_day_no, 12053); $j_day_no = $j_day_no % 12053; $jy = 979+33*$j_np+4*div($j_day_no,1461); $j_day_no %= 1461; if ($j_day_no >= 366) { $jy += div($j_day_no-1, 365); $j_day_no = ($j_day_no-1)%365; } for ($i = 0; $i < 11 && $j_day_no >= $j_days_in_month[$i]; ++$i) $j_day_no -= $j_days_in_month[$i]; $jm = $i+1; $jd = $j_day_no+1; return array($jy, $jm, $jd); } function jalali_to_gregorian($j_y, $j_m, $j_d) { $g_days_in_month = array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31); $j_days_in_month = array(31, 31, 31, 31, 31, 31, 30, 30, 30, 30, 30, 29); $jy = $j_y-979; $jm = $j_m-1; $jd = $j_d-1; $j_day_no = 365*$jy + div($jy, 33)*8 + div($jy%33+3, 4); for ($i=0; $i < $jm; ++$i) $j_day_no += $j_days_in_month[$i]; $j_day_no += $jd; $g_day_no = $j_day_no+79; $gy = 1600 + 400*div($g_day_no, 146097); $g_day_no = $g_day_no % 146097; $leap = true; if ($g_day_no >= 36525) { $g_day_no--; $gy += 100*div($g_day_no, 36524); $g_day_no = $g_day_no % 36524; if ($g_day_no >= 365) $g_day_no++; else $leap = false; } $gy += 4*div($g_day_no, 1461); $g_day_no %= 1461; if ($g_day_no >= 366) { $leap = false; $g_day_no--; $gy += div($g_day_no, 365); $g_day_no = $g_day_no % 365; } for ($i = 0; $g_day_no >= $g_days_in_month[$i] + ($i == 1 && $leap); $i++) $g_day_no -= $g_days_in_month[$i] + ($i == 1 && $leap); $gm = $i+1; $gd = $g_day_no+1; return array($gy, $gm, $gd); } function employee_attendence_report($employees,$year,$month) { $branch_id = active_branch_id(); $calander_db = fetch_calander_name(); $data_array['employees'] = array(); foreach($employees as $employee) { $month_presents = array(); $month_absents = array(); $month_sick = array(); $month_leave = array(); $month_holiday = array(); if(!array_key_exists($employee['uid'], $data_array['employees'])) { $data_array['employees'][$employee['uid']] = array(); $data_array['employees'][$employee['uid']]['info'] = $employee; $data_array['employees'][$employee['uid']]['month_days'] = array(); } $month_days=get_month_days($year,$month); for($i=1; $i <= $month_days; $i++) { $day_name = get_day_name($year,$month,$i); $status = 'Not available'; if(!array_key_exists($i, $data_array['employees'][$employee['uid']]['month_days'])) { $data_array['employees'][$employee['uid']]['month_days'][$i] = array(); } $employee_attendence = std_obj_to_array(DB::table("attendence")->where("branch_id",$branch_id)->where("year",$year)->where("month",$month)->where("day",$i)->where("employee",$employee['uid'])->get()->first()); if(!empty($employee_attendence)) { $status = $employee_attendence['status']; if($status == 'present'){ $month_presents[] = 1; } if($status == 'absent'){ $month_absents[] = 1; } if($status == 'sick'){ $month_sick[] = 1; } if($status == 'leave'){ $month_leave[] = 1; } if($status == 'holiday'){ $month_holiday[] = 1; } } $data_array['employees'][$employee['uid']]['month_days'][$i] = array( 'year' => $year, 'month' => $month, 'day' => $i, 'day_name' => $day_name, 'status' => $status, 'is_holiday' => '', ); $data_array['employees'][$employee['uid']]['totals'] = array( 'presents' => array_sum($month_presents), 'absent' => array_sum($month_absents), 'sick' => array_sum($month_sick), 'leave' => array_sum($month_leave), 'holiday' => array_sum($month_holiday), ); } } return $data_array; } function persian_months($index) { $months_array = array( '1' => 'حمل ', '2' => 'ثور ', '3' => 'جوزا ', '4' => 'سرطان ', '5' => 'اسد ', '6' => 'سنبله ', '7' => 'میزان ', '8' => 'عقرب ', '9' => 'قوس ', '10' => 'جدی ', '11' => 'دلو ', '12' => 'حوت ', ); return $months_array[$index]; } function persian_months_array() { $months_array = array( '1' => 'حمل  ', '2' => 'ثور ', '3' => 'جوزا  ', '4' => 'سرطان  ', '5' => 'اسد  ', '6' => 'سنبله  ', '7' => 'میزان  ', '8' => 'عقرب   ', '9' => 'قوس    ', '10' => 'جدی   ', '11' => 'دلو  ', '12' => 'حوت ', ); return $months_array; } function get_years_data() { $earliest_year = 1950; $year_array = array(); foreach (range(date('Y'), $earliest_year) as $x) { $year_array[$x] = get_persian_year($x); } return $year_array; } function get_last_20_years_data() { $calander_db = fetch_calander_name(); $earliest_year = 1950; $year_array = array(); if($calander_db == 'persian') { foreach (range(date('Y'), $earliest_year) as $x) { $year_array[$x] = get_persian_year($x); } } else { foreach (range(date('Y'), $earliest_year) as $x) { $year_array[$x] = $x; } } return $year_array; } function get_persian_year($date) { $date = date("".$date."-m-d"); $date1 = new DateTime($date); $year = $date1->format('Y'); $month = $date1->format('m'); $day = $date1->format('d'); $date_arr = gregorian_to_jalali ($year, $month, $day); return $date_arr[0]; } function mail_alert($email,$name,$amount) { $amount = implode(" - ",$amount); $mail_file = 'user.emails.mail_template'; $subject = 'Payment Alert Notification'; $email_from = Config::get('constants.mail.email'); $email_to = $email; $email_to_name = $name; $mail_vars = array("name" => $name, "amount" => $amount); Mail::send($mail_file,$mail_vars, function($message) use ($email_from,$email_to,$email_to_name,$subject) { $message->from($email_from); $message->to($email_to, $email_to_name)->subject($subject); }); } function sale_email($email,$name,$invoice_data,$currencies,$clients,$units,$app_lang,$app_direction) { $mail_file = 'user.emails.sales_new'; $subject = 'Sales Invoice'; $email_from = Config::get('constants.mail.email'); $email_to = $email; $email_to_name = $name; $mail_vars = array("invoice_data" => $invoice_data, "currencies" => $currencies, "clients" => $clients, "units" => $units, "app_lang" => $app_lang, "app_direction" => $app_direction); Mail::send($mail_file,$mail_vars, function($message) use ($email_from,$email_to,$email_to_name,$subject) { $message->from($email_from); $message->to($email_to, $email_to_name)->subject($subject); }); } function get_items_batch_options($uid,$warehouse,$value) { $selected = ''; $batch_array = array(); $batch = std_obj_to_array(DB::table("batch_wise_stock")->where('item',$uid)->where('warehouse',$warehouse)->where("module",'!=','sales')->where("module",'!=','transfer_out')->where("module",'!=','damage')->where('status','passed')->get()); foreach($batch as $row) { $batch_array[$row['batch']] = $row['batch']; } $batch_array = array_unique($batch_array); $options_snippet = ''; foreach($batch_array as $ba) { $stock_in = DB::table('batch_wise_stock')->where('item',$uid)->where('warehouse',$warehouse)->where('batch',$ba)->where('status','passed')->sum('stock_in'); $bonus_in = DB::table('batch_wise_stock')->where('item',$uid)->where('warehouse',$warehouse)->where('batch',$ba)->where('status','passed')->sum('bonus_in'); $stock_out = DB::table('batch_wise_stock')->where('item',$uid)->where('warehouse',$warehouse)->where('batch',$ba)->where('status','passed')->sum('stock_out'); $bonus_out = DB::table('batch_wise_stock')->where('item',$uid)->where('warehouse',$warehouse)->where('batch',$ba)->where('status','passed')->sum('bonus_out'); $stock_in_total = (float)$stock_in + (float)$bonus_in; $stock_out_total = (float)$stock_out + (float)$bonus_out; $stock_ava = $stock_in_total - $stock_out_total; $batch_profit_last = std_obj_to_array(DB::table('batch_wise_stock')->where('item',$uid)->where('warehouse',$warehouse)->where('module','!=','sales')->where('status','passed')->where('module','!=','transfer_out')->where('module','!=','damage')->where('batch',$ba)->whereNotNull('profit')->get()->first()); $profit = (float)$batch_profit_last['profit']; $batch_sale_price_last = std_obj_to_array(DB::table('batch_wise_stock')->where('item',$uid)->where('warehouse',$warehouse)->where('module','!=','sales')->where('status','passed')->where('module','!=','transfer_out')->where('module','!=','damage')->where('batch',$ba)->whereNotNull('sale_price')->orderBy('module_created_at','desc')->get()->first()); $sale_price = (float)$batch_sale_price_last['sale_price']; $expiry = std_obj_to_array(DB::table("batch_wise_stock")->where('batch',$ba)->where('status','passed')->where('module','!=','sales')->where('module','!=','transfer_out')->where('module','!=','damage')->where('status','passed')->whereNotNull('expiry_date')->orderBy('module_created_at','desc')->get()->first()); if(empty($expiry['expiry_date'])) { $expiry_date = ''; } else { $expiry_date = $expiry['expiry_date']; } if($value == $ba) { $selected = 'selected="selected"'; } $option_show = $ba.'- ('.display_true_date($expiry_date).')'.'- (ava-'.$stock_ava.')'; $options_snippet .= '<option '.$selected.' value="'.$ba.'" data-profit="'.$profit.'" data-sale-price="'.$sale_price.'" data-expiry="'.$expiry_date.'">'.$option_show.'</option>'; } return $options_snippet; } function sales_recovery() { $sales = fetch_table('sales'); foreach($sales as $row) { $db_array = array('sale_id' => $row['uid']); DB::table('sales_return')->where('branch',$row['branch'])->where('invoice',$row['invoice'])->update($db_array); } } function sales_recovery_for_return() { $sales = fetch_table('sales'); foreach($sales as $row) { $items_details = array(); $items_details_data = json_decode($row['items_details'],true); $sic = 0; while($sic < count($items_details_data)) { if(empty($items_details_data[$sic]['item'])){ $sic++; continue; } $items_details[] = array( 'agent' => $items_details_data[$sic]['agent'], 'plate' => $items_details_data[$sic]['plate'], 'item' => $items_details_data[$sic]['item'], 'item_uqid' => randomUniqeId(), 'warehouse' => $items_details_data[$sic]['warehouse'], 'batch' => $items_details_data[$sic]['batch'], 'mfg' => isset($items_details_data[$sic]['mfg']) ? $items_details_data[$sic]['mfg'] : NULL, 'expiry' => isset($items_details_data[$sic]['expiry']) ? $items_details_data[$sic]['expiry'] : NULL, 'narration' => $items_details_data[$sic]['narration'], 'cost' => (float)$items_details_data[$sic]['cost'], 'sale_price' => (float)$items_details_data[$sic]['sale_price'], 'qty' => (float)$items_details_data[$sic]['qty'], 'bonus' => (float)$items_details_data[$sic]['bonus'], 'm2' => (float)$items_details_data[$sic]['m2'], 'width' => (float)$items_details_data[$sic]['width'], 'height' => (float)$items_details_data[$sic]['height'], 'unit' => $items_details_data[$sic]['unit'], 'discount' => (float)$items_details_data[$sic]['discount'], 'discount_2' => (float)$items_details_data[$sic]['discount_2'], 'profit' => (float)$items_details_data[$sic]['profit'], 'item_total' => (float)$items_details_data[$sic]['item_total'], ); $sic++; } $db_array = array('items_details' => json_encode($items_details)); DB::table('sales')->where('branch',$row['branch'])->where('uid',$row['uid'])->update($db_array); } echo "successfully"; die; } function sales_return_recovery_for_return() { $sales_return = fetch_table('sales_return'); foreach($sales_return as $row) { $items_details = array(); $items_details_data = json_decode($row['items_details'],true); $sale_data = fetch_table_where('sales','uid',$row['sale_id'],true); $sales_items = json_decode($sale_data['items_details'],true); $sic = 0; while($sic < count($items_details_data)) { if(empty($items_details_data[$sic]['item'])){ $sic++; continue; } $items_details[] = array( 'agent' => $items_details_data[$sic]['agent'], 'plate' => $items_details_data[$sic]['plate'], 'item' => $items_details_data[$sic]['item'], 'item_uqid' => $sales_items[$sic]['item_uqid'], 'warehouse' => $items_details_data[$sic]['warehouse'], 'batch' => $items_details_data[$sic]['batch'], 'narration' => $items_details_data[$sic]['narration'], 'cost' => (float)$items_details_data[$sic]['cost'], 'sale_price' => (float)$items_details_data[$sic]['sale_price'], 'qty' => (float)$items_details_data[$sic]['qty'], 'r_qty' => isset($items_details_data[$sic]['r_qty']) ? $items_details_data[$sic]['r_qty'] : 0, 'bonus' => isset($items_details_data[$sic]['bonus']) ? $items_details_data[$sic]['bonus'] : 0, 'r_bonus' => isset($items_details_data[$sic]['r_bonus']) ? $items_details_data[$sic]['r_bonus'] : 0, 'm2' => (float)$items_details_data[$sic]['m2'], 'width' => (float)$items_details_data[$sic]['width'], 'height' => (float)$items_details_data[$sic]['height'], 'unit' => $items_details_data[$sic]['unit'], 'discount' => (float)$items_details_data[$sic]['discount'], 'discount_2' => (float)$items_details_data[$sic]['discount_2'], 'profit' => (float)$items_details_data[$sic]['profit'], 'item_total' => (float)$items_details_data[$sic]['item_total'], 'r_item_total' => (float)$items_details_data[$sic]['r_item_total'], ); $sic++; } $db_array = array('items_details' => json_encode($items_details)); DB::table('sales_return')->where('branch',$row['branch'])->where('uid',$row['uid'])->update($db_array); } die; } function recover_batch_stock() { $branch_id = active_branch_id(); $batch_wise_stock = std_obj_to_array(DB::table('batch_wise_stock')->select('batch','item')->distinct()->get()); echo date("Y-m-d H:i:s"); foreach($batch_wise_stock as $row) { $item = fetch_table_where('items','uid',$row['item'],true); $item_currency = $item['currency']; $item_currency_usd_equalance = (float)$item['currency_usd_equalance']; $item_stock_in = DB::table('batch_wise_stock')->where('item',$row['item'])->where('batch',$row['batch'])->where('module','items')->where('status','passed')->sum('stock_in'); $purchases_stock_in = DB::table('batch_wise_stock')->where('item',$row['item'])->where('batch',$row['batch'])->where('module','purchases')->where('status','passed')->sum('stock_in'); $purchases_bonus_in = DB::table('batch_wise_stock')->where('item',$row['item'])->where('batch',$row['batch'])->where('module','purchases')->where('status','passed')->sum('bonus_in'); $return_stock_in = DB::table('batch_wise_stock')->where('item',$row['item'])->where('batch',$row['batch'])->where('module','sales_return')->where('status','passed')->sum('stock_in'); $transfer_stock_in = DB::table('batch_wise_stock')->where('item',$row['item'])->where('batch',$row['batch'])->where('module','transfer_in')->where('status','passed')->sum('stock_in'); $transfer_bonus_in = DB::table('batch_wise_stock')->where('item',$row['item'])->where('batch',$row['batch'])->where('module','transfer_in')->where('status','passed')->sum('bonus_in'); $sales_stock_out = DB::table('batch_wise_stock')->where('item',$row['item'])->where('batch',$row['batch'])->where('module','sales')->where('status','passed')->sum('stock_out'); $sales_bonus_out = DB::table('batch_wise_stock')->where('item',$row['item'])->where('batch',$row['batch'])->where('module','sales')->where('status','passed')->sum('bonus_out'); $transfer_stock_out = DB::table('batch_wise_stock')->where('item',$row['item'])->where('batch',$row['batch'])->where('module','transfer_out')->where('status','passed')->sum('stock_out'); $transfer_bonus_out = DB::table('batch_wise_stock')->where('item',$row['item'])->where('batch',$row['batch'])->where('module','transfer_out')->where('status','passed')->sum('bonus_out'); $damage_stock_out = DB::table('batch_wise_stock')->where('item',$row['item'])->where('batch',$row['batch'])->where('module','damage')->where('status','passed')->sum('stock_out'); $item_last_batch_tp = std_obj_to_array(DB::table('batch_wise_stock')->where('item',$row['item'])->where('batch',$row['batch'])->where('module','!=','sales')->where('module','!=','damage')->where('module','!=','transfer_out')->whereNotNull('sale_price')->orderBy('module_created_at','desc')->orderBy('id','desc')->get()->first()); $item_tp = (float)$item_last_batch_tp['sale_price']; $batch_currency = $item_last_batch_tp['currency']; $batch_currency_equalance = (float)$item_last_batch_tp['currency_usd_equalance']; if($batch_currency == $item_currency) { $item_tp = $item_tp; } else { $item_tp = amount_conversion($item_tp, $batch_currency_equalance, $item_currency_usd_equalance); } $mfg_batch = std_obj_to_array(DB::table('batch_wise_stock')->where('item',$row['item'])->where('batch',$row['batch'])->where("module",'!=','sales')->where('status','passed')->where("module",'!=','transfer_out')->where("module",'!=','damage')->whereNotNull('mfg_date')->orderBy('module_created_at','desc')->get()->first()); if(empty($mfg_batch['mfg_date'])) { $mfg_date = ''; } else { $mfg_date = $mfg_batch['mfg_date']; } $expiry_batch = std_obj_to_array(DB::table('batch_wise_stock')->where('item',$row['item'])->where('batch',$row['batch'])->where("module",'!=','sales')->where('status','passed')->where("module",'!=','transfer_out')->where("module",'!=','damage')->whereNotNull('expiry_date')->orderBy('module_created_at','desc')->get()->first()); if(empty($expiry_batch['expiry_date'])) { $expiry_date = ''; } else { $expiry_date = $expiry_batch['expiry_date']; } $stock_in_total = (float)$item_stock_in + (float)$purchases_stock_in + (float)$purchases_bonus_in; $stock_out_total = (float)$sales_stock_out + (float)$sales_bonus_out; $transfer_out_total = (float)$transfer_stock_out + (float)$transfer_bonus_out; $transfer_in_total = (float)$transfer_stock_in + (float)$transfer_bonus_in; $stock_ava = $stock_in_total + (float)$transfer_in_total + (float)$return_stock_in - $stock_out_total - $transfer_out_total - (float)$damage_stock_out; $db_array = [ 'item' => $row['item'], 'item_name' => $item['name'], 'unit' => $item['purchase_unit'], 'batch' => $row['batch'], 'purchases' => (float)$item_stock_in + (float)$purchases_stock_in + (float)$purchases_bonus_in, 'sales' => (float)$sales_stock_out + (float)$sales_bonus_out, 'returns' => (float)$return_stock_in, 'transfer_in' => (float)$transfer_stock_in + (float)$transfer_bonus_in, 'transfer_out' => (float)$transfer_stock_out + (float)$transfer_bonus_out, 'damage' => (float)$damage_stock_out, 'available' => (float)$stock_ava, 'stock_in' => (float)$item_stock_in + (float)$purchases_stock_in + (float)$purchases_bonus_in + (float)$return_stock_in + (float)$transfer_stock_in + (float)$transfer_bonus_in, 'stock_out' => (float)$sales_stock_out + (float)$sales_bonus_out + (float)$damage_stock_out + (float)$transfer_stock_out + (float)$transfer_bonus_out, 'mfg' => $mfg_date, 'expiry' => $expiry_date, 'avg_cost' => (float)$item['_avg_cost'], 'tp' => (float)$item_tp, 'branch' => $item['branch'], ]; insert_table('batch_wise_items_stock',$db_array); } echo date("Y-m-d H:i:s"); print_rr($batch_wise_stock); } function handle_batch_stock($item,$batch) { $item_data = fetch_table_where('items','uid',$item,true); $item_currency = $item['currency']; $item_currency_usd_equalance = (float)$item['currency_usd_equalance']; $item_stock_in = DB::table('batch_wise_stock')->where('item',$item)->where('batch',$batch)->where('module','items')->where('status','passed')->sum('stock_in'); $purchases_stock_in = DB::table('batch_wise_stock')->where('item',$item)->where('batch',$batch)->where('module','purchases')->where('status','passed')->sum('stock_in'); $purchases_bonus_in = DB::table('batch_wise_stock')->where('item',$item)->where('batch',$batch)->where('module','purchases')->where('status','passed')->sum('bonus_in'); $return_stock_in = DB::table('batch_wise_stock')->where('item',$item)->where('batch',$batch)->where('module','sales_return')->where('status','passed')->sum('stock_in'); $transfer_stock_in = DB::table('batch_wise_stock')->where('item',$item)->where('batch',$batch)->where('module','transfer_in')->where('status','passed')->sum('stock_in'); $transfer_bonus_in = DB::table('batch_wise_stock')->where('item',$item)->where('batch',$batch)->where('module','transfer_in')->where('status','passed')->sum('bonus_in'); $sales_stock_out = DB::table('batch_wise_stock')->where('item',$item)->where('batch',$batch)->where('module','sales')->where('status','passed')->sum('stock_out'); $sales_bonus_out = DB::table('batch_wise_stock')->where('item',$item)->where('batch',$batch)->where('module','sales')->where('status','passed')->sum('bonus_out'); $transfer_stock_out = DB::table('batch_wise_stock')->where('item',$item)->where('batch',$batch)->where('module','transfer_out')->where('status','passed')->sum('stock_out'); $transfer_bonus_out = DB::table('batch_wise_stock')->where('item',$item)->where('batch',$batch)->where('module','transfer_out')->where('status','passed')->sum('bonus_out'); $damage_stock_out = DB::table('batch_wise_stock')->where('item',$item)->where('batch',$batch)->where('module','damage')->where('status','passed')->sum('stock_out'); $item_last_batch_tp = std_obj_to_array(DB::table('batch_wise_stock')->where('item',$item)->where('batch',$batch)->where('module','!=','sales')->where('module','!=','damage')->where('module','!=','transfer_out')->whereNotNull('sale_price')->orderBy('module_created_at','desc')->orderBy('id','desc')->get()->first()); $item_tp = (float)$item_last_batch_tp['sale_price']; $batch_currency = $item_last_batch_tp['currency']; $batch_currency_equalance = (float)$item_last_batch_tp['currency_usd_equalance']; if($batch_currency == $item_currency) { $item_tp = $item_tp; } else { $item_tp = amount_conversion($item_tp, $batch_currency_equalance, $item_currency_usd_equalance); } $mfg_batch = std_obj_to_array(DB::table('batch_wise_stock')->where('item',$item)->where('batch',$batch)->where("module",'!=','sales')->where('status','passed')->where("module",'!=','transfer_out')->where("module",'!=','damage')->whereNotNull('mfg_date')->orderBy('module_created_at','desc')->get()->first()); if(empty($mfg_batch['mfg_date'])) { $mfg_date = ''; } else { $mfg_date = $mfg_batch['mfg_date']; } $expiry_batch = std_obj_to_array(DB::table('batch_wise_stock')->where('item',$item)->where('batch',$batch)->where("module",'!=','sales')->where('status','passed')->where("module",'!=','transfer_out')->where("module",'!=','damage')->whereNotNull('expiry_date')->orderBy('module_created_at','desc')->get()->first()); if(empty($expiry_batch['expiry_date'])) { $expiry_date = ''; } else { $expiry_date = $expiry_batch['expiry_date']; } $stock_in_total = (float)$item_stock_in + (float)$purchases_stock_in + (float)$purchases_bonus_in; $stock_out_total = (float)$sales_stock_out + (float)$sales_bonus_out; $transfer_out_total = (float)$transfer_stock_out + (float)$transfer_bonus_out; $transfer_in_total = (float)$transfer_stock_in + (float)$transfer_bonus_in; $stock_ava = $stock_in_total + (float)$transfer_in_total + (float)$return_stock_in - $stock_out_total - $transfer_out_total - (float)$damage_stock_out; $batch_entry = std_obj_to_array(DB::table('batch_wise_items_stock')->where('item',$item)->where('batch',$batch)->get()->first()); if(!empty($batch_entry)) { $db_array = [ 'item' => $item, 'item_name' => $item_data['name'], 'unit' => $item_data['purchase_unit'], 'batch' => $batch, 'purchases' => (float)$item_stock_in + (float)$purchases_stock_in + (float)$purchases_bonus_in, 'sales' => (float)$sales_stock_out + (float)$sales_bonus_out, 'returns' => (float)$return_stock_in, 'transfer_in' => (float)$transfer_stock_in + (float)$transfer_bonus_in, 'transfer_out' => (float)$transfer_stock_out + (float)$transfer_bonus_out, 'damage' => (float)$damage_stock_out, 'available' => (float)$stock_ava, 'stock_in' => (float)$item_stock_in + (float)$purchases_stock_in + (float)$purchases_bonus_in + (float)$return_stock_in + (float)$transfer_stock_in + (float)$transfer_bonus_in, 'stock_out' => (float)$sales_stock_out + (float)$sales_bonus_out + (float)$damage_stock_out + (float)$transfer_stock_out + (float)$transfer_bonus_out, 'mfg' => $mfg_date, 'expiry' => $expiry_date, 'avg_cost' => (float)$item_data['_avg_cost'], 'tp' => (float)$item_tp, 'branch' => $item_data['branch'], ]; update_table('batch_wise_items_stock','id',$batch_entry['id'],$db_array); } else { $db_array = [ 'item' => $item, 'item_name' => $item_data['name'], 'unit' => $item_data['purchase_unit'], 'batch' => $batch, 'purchases' => (float)$item_stock_in + (float)$purchases_stock_in + (float)$purchases_bonus_in, 'sales' => (float)$sales_stock_out + (float)$sales_bonus_out, 'returns' => (float)$return_stock_in, 'transfer_in' => (float)$transfer_stock_in + (float)$transfer_bonus_in, 'transfer_out' => (float)$transfer_stock_out + (float)$transfer_bonus_out, 'damage' => (float)$damage_stock_out, 'available' => (float)$stock_ava, 'stock_in' => (float)$item_stock_in + (float)$purchases_stock_in + (float)$purchases_bonus_in + (float)$return_stock_in + (float)$transfer_stock_in + (float)$transfer_bonus_in, 'stock_out' => (float)$sales_stock_out + (float)$sales_bonus_out + (float)$damage_stock_out + (float)$transfer_stock_out + (float)$transfer_bonus_out, 'mfg' => $mfg_date, 'expiry' => $expiry_date, 'avg_cost' => (float)$item_data['_avg_cost'], 'tp' => (float)$item_tp, 'branch' => $item_data['branch'], ]; insert_table('batch_wise_items_stock',$db_array); } } function handle_item_wise_stock($item) { $branch_id = active_branch_id(); $batch_wise_stock = std_obj_to_array(DB::table('batch_wise_stock')->select('batch','item')->where('item',$item)->distinct()->get()); delete_table('batch_wise_items_stock','item',$item); foreach($batch_wise_stock as $row) { $item = fetch_table_where('items','uid',$row['item'],true); if(!empty($item)) { $item_details = json_decode($item['stats'],true); $item_currency = $item['currency']; $item_currency_usd_equalance = $item['currency_usd_equalance']; $item_tp = (float)$item_details['last_cost'] + (float)$item_details['last_profit']; $batch_currency = NULL; $batch_currency_equalance = 1; $items_inventory = std_obj_to_array( DB::select("
                    SELECT 
                    sum(items_in) items_registration, 
                    sum(purchase_in) items_purchases,
                    sum(purchase_bonus_in) items_purchases_bonus,
                    sum(transfer_in) items_transfer_in,
                    sum(transfer_bonus_in) items_transfer_in_bonus,
                    sum(return_in) items_sales_return,
                    sum(return_bonus_in) items_sales_return_bonus,
                    sum(sales_out) items_sales,
                    sum(sales_bonus_out) items_sales_bonus,
                    sum(transfer_out) items_transfer_out,
                    sum(transfer_bonus_out) items_transfer_out_bonus,
                    sum(b_to_b_in) items_b_to_b_in,
                    sum(b_to_b_out) items_b_to_b_out,
                    sum(damage) items_damage
                    FROM item_inventory
                    where batch = '".$row['batch']."' AND item = '".$row['item']."' AND status = 'passed'
                    ") ); $item_btach_tp = std_obj_to_array( DB::select("
                    SELECT * FROM item_inventory 
                    where batch = '".$row['batch']."' 
                    AND item = '".$row['item']."' 
                    AND status = 'passed' 
                    AND module != 'sales' 
                    AND module != 'damage' 
                    AND module != 'transfer_out' 
                    AND module != 'b_to_b_transfer_out' 
                    AND sale_price IS NOT NULL 
                    ORDER BY module_created_at DESC, id
                ") ); if(!empty($item_btach_tp)) { $item_tp = (float)$item_btach_tp[0]['sale_price']; $batch_currency = $item_btach_tp[0]['currency']; $batch_currency_equalance = (float)$item_btach_tp[0]['currency_usd_equalance']; } if($batch_currency == $item_currency) { $item_tp = $item_tp; } else { $item_tp = amount_conversion($item_tp, $batch_currency_equalance, $item_currency_usd_equalance); } $mfg_date = NULL; $item_btach_mfg_date = std_obj_to_array( DB::select("
                    SELECT * FROM item_inventory 
                    where batch = '".$row['batch']."' 
                    AND item = '".$row['item']."' 
                    AND status = 'passed' 
                    AND module != 'sales' 
                    AND module != 'damage' 
                    AND module != 'transfer_out' 
                    AND mfg_date IS NOT NULL 
                    ORDER BY module_created_at DESC
                ") ); if(!empty($item_btach_mfg_date)){ $mfg_date = $item_btach_mfg_date[0]['mfg_date']; } $expiry_date = NULL; $item_btach_expiry_date = std_obj_to_array( DB::select("
                    SELECT * FROM item_inventory 
                    where batch = '".$row['batch']."' 
                    AND item = '".$row['item']."' 
                    AND status = 'passed' 
                    AND module != 'sales' 
                    AND module != 'damage' 
                    AND module != 'transfer_out' 
                    AND expiry_date IS NOT NULL 
                    ORDER BY module_created_at DESC
                ") ); if(!empty($item_btach_expiry_date)){ $expiry_date = $item_btach_expiry_date[0]['expiry_date']; } $items_registration = $items_inventory[0]['items_registration']; $items_purchases = $items_inventory[0]['items_purchases']; $items_purchases_bonus = $items_inventory[0]['items_purchases_bonus']; $items_transfer_in = $items_inventory[0]['items_transfer_in']; $items_transfer_in_bonus = $items_inventory[0]['items_transfer_in_bonus']; $items_sales_return = $items_inventory[0]['items_sales_return']; $items_sales_return_bonus = $items_inventory[0]['items_sales_return_bonus']; $items_sales = $items_inventory[0]['items_sales']; $items_sales_bonus = $items_inventory[0]['items_sales_bonus']; $items_transfer_out = $items_inventory[0]['items_transfer_out']; $items_transfer_out_bonus = $items_inventory[0]['items_transfer_out_bonus']; $items_damage = $items_inventory[0]['items_damage']; $items_b_to_b_in = $items_inventory[0]['items_b_to_b_in']; $items_b_to_b_out = $items_inventory[0]['items_b_to_b_out']; $stock_in_total = (float)$items_registration + (float)$items_purchases + (float)$items_purchases_bonus; $stock_out_total = (float)$items_sales + (float)$items_sales_bonus; $transfer_out_total = (float)$items_transfer_out + (float)$items_transfer_out_bonus; $transfer_in_total = (float)$items_transfer_in + (float)$items_transfer_in_bonus; $stock_ava = $stock_in_total + (float)$transfer_in_total + (float)$items_sales_return + (float)$items_sales_return_bonus - $stock_out_total - $transfer_out_total - (float)$items_damage + (float)$items_b_to_b_in - (float)$items_b_to_b_out; $db_array = [ 'item' => $row['item'], 'item_name' => $item['name'], 'unit' => $item['purchase_unit'], 'batch' => $row['batch'], 'purchases' => (float)$items_registration + (float)$items_purchases + (float)$items_purchases_bonus, 'sales' => (float)$items_sales + (float)$items_sales_bonus, 'returns' => (float)$items_sales_return + (float)$items_sales_return_bonus, 'transfer_in' => (float)$items_transfer_in + (float)$items_transfer_in_bonus, 'transfer_out' => (float)$items_transfer_out + (float)$items_transfer_out_bonus, 'damage' => (float)$items_damage, 'b_to_b_in' => (float)$items_b_to_b_in, 'b_to_b_out' => (float)$items_b_to_b_out, 'available' => (float)$stock_ava, 'stock_in' => (float)$items_registration + (float)$items_purchases + (float)$items_purchases_bonus + (float)$items_sales_return + (float)$items_sales_return_bonus + (float)$items_transfer_in + (float)$items_transfer_in_bonus + (float)$items_b_to_b_in, 'stock_out' => (float)$items_sales + (float)$items_sales_bonus + (float)$items_transfer_out + (float)$items_transfer_out_bonus + (float)$items_damage + (float)$items_b_to_b_out, 'mfg' => $mfg_date, 'expiry' => $expiry_date, 'avg_cost' => (float)$item['_avg_cost'], 'tp' => (float)$item_tp, 'branch' => $item['branch'], ]; insert_table('batch_wise_items_stock',$db_array); } } } function handle_item_bundle_toop_quantity($item) { $bundle_stock_in = DB::table('items_bundle_toop_stock')->where('item',$item)->sum('bundle_stock_in'); $bundle_stock_out = DB::table('items_bundle_toop_stock')->where('item',$item)->sum('bundle_stock_out'); $toop_stock_in = DB::table('items_bundle_toop_stock')->where('item',$item)->sum('toop_stock_in'); $toop_stock_out = DB::table('items_bundle_toop_stock')->where('item',$item)->sum('toop_stock_out'); $ava_bundle = $bundle_stock_in - $bundle_stock_out; $ava_toop = $toop_stock_in - $toop_stock_out; update_table('items','uid',$item,['ava_bundle' => $ava_bundle, 'ava_toop' => $ava_toop]); } function handle_items_last_data() { $items = fetch_table('items'); foreach($items as $row) { handle_item_batch_mfg_expiry($row['uid']); } } function handle_item_batch_mfg_expiry($item) { ini_set('max_execution_time', 18000000); $item_batch_last = NULL; $item_batch = std_obj_to_array( DB::select("
            SELECT * FROM batch_wise_stock 
            where item = '".$item."' 
            AND status = 'passed' 
            AND module != 'sales' 
            AND module != 'damage' 
            AND module != 'transfer_out' 
            AND batch IS NOT NULL 
            ORDER BY module_created_at DESC, id
        ") ); if(!empty($item_batch)) { $item_batch_last = $item_batch[0]['batch']; } $expiry = std_obj_to_array( DB::select("
            SELECT * FROM batch_wise_stock 
            where item = '".$item."' 
            AND batch = '".$item_batch_last."'
            AND status = 'passed' 
            AND module != 'sales' 
            AND module != 'damage' 
            AND module != 'transfer_out' 
            AND expiry_date IS NOT NULL 
            AND expiry_date != 0000-00-00
            ORDER BY module_created_at DESC
        ") ); $mfg = std_obj_to_array( DB::select("
            SELECT * FROM batch_wise_stock 
            where item = '".$item."' 
            AND batch = '".$item_batch_last."'
            AND status = 'passed' 
            AND module != 'sales' 
            AND module != 'damage' 
            AND module != 'transfer_out' 
            AND mfg_date IS NOT NULL 
            AND mfg_date != 0000-00-00
            ORDER BY module_created_at DESC
        ") ); if(empty($expiry[0]['expiry_date'])){ $expiry_date = ''; }else{ $expiry_date = $expiry[0]['expiry_date']; } if(empty($mfg[0]['mfg_date'])){ $mfg_date = ''; }else{ $mfg_date = $mfg[0]['mfg_date']; } $db_array = ['last_batch' => $item_batch_last, 'last_mfg_date' => $mfg_date, 'last_expiry_date' => $expiry_date]; update_table('items','uid',$item,$db_array); } function _items_warehouse_wise_batch($uid,$warehouse) { $active_branch_id = active_branch_id(); $item_data = fetch_table_where('items','uid',$uid,true); $item_currency = $item_data['currency']; $item_currency_usd_equalance = (float)$item_data['currency_usd_equalance']; $batch_array = array(); $batch = std_obj_to_array(DB::table("batch_wise_stock")->where('item',$uid)->where('warehouse',$warehouse)->where("module",'!=','sales')->where("module",'!=','transfer_out')->where("module",'!=','damage')->where('status','passed')->get()); foreach($batch as $row) { $batch_array[$row['batch']] = $row['batch']; } $batch_array = array_unique($batch_array); $_batch_array = []; foreach($batch_array as $ba) { $batch_value = null; $items_inventory = std_obj_to_array( DB::select("
                SELECT 
                sum(items_in) items_registration, 
                sum(purchase_in) items_purchases,
                sum(purchase_bonus_in) items_purchases_bonus,
                sum(transfer_in) items_transfer_in,
                sum(transfer_bonus_in) items_transfer_in_bonus,
                sum(return_in) items_sales_return,
                sum(return_bonus_in) items_sales_return_bonus,
                sum(sales_out) items_sales,
                sum(sales_bonus_out) items_sales_bonus,
                sum(transfer_out) items_transfer_out,
                sum(transfer_bonus_out) items_transfer_out_bonus,
                sum(b_to_b_in) items_b_to_b_in,
                sum(b_to_b_out) items_b_to_b_out,
                sum(damage) items_damage
                FROM item_inventory
                where batch = '".$ba."' AND item = '".$uid."' AND warehouse = '".$warehouse."' AND status = 'passed'
                ") ); $stock_ava = ($items_inventory[0]['items_registration'] + $items_inventory[0]['items_purchases'] + $items_inventory[0]['items_purchases_bonus'] + $items_inventory[0]['items_transfer_in'] + $items_inventory[0]['items_transfer_in_bonus'] + $items_inventory[0]['items_sales_return'] + $items_inventory[0]['items_sales_return_bonus'] + $items_inventory[0]['items_b_to_b_in']) - ($items_inventory[0]['items_sales'] + $items_inventory[0]['items_sales_bonus'] + $items_inventory[0]['items_transfer_out'] + $items_inventory[0]['items_transfer_out_bonus'] + $items_inventory[0]['items_damage'] + $items_inventory[0]['items_b_to_b_out']); if($stock_ava > 0){ $batch_value = $ba.' ('.$stock_ava.')'; $_batch_array[$ba] = $batch_value; } } return $_batch_array; } function user_approval_info($info) { $stats['sub_approval'] = 'pending'; $stats['main_approval'] = 'pending'; $stats['sub_approval_user'] = null; $stats['sub_approval_user_name'] = null; $stats['main_approval_user'] = null; $stats['main_approval_user_name'] = null; if(check_user_access('sub_approval') === TRUE) { $stats['sub_approval'] = 'approved'; $stats['sub_approval_user'] = get_logged_user_data('uid'); $stats['sub_approval_user_name'] = get_logged_user_data('name'); } if(check_user_access('main_approval') === TRUE) { $stats['sub_approval'] = 'approved'; $stats['sub_approval_user'] = get_logged_user_data('uid'); $stats['sub_approval_user_name'] = get_logged_user_data('name'); $stats['main_approval'] = 'approved'; $stats['main_approval_user'] = get_logged_user_data('uid'); $stats['main_approval_user_name'] = get_logged_user_data('name'); } return $stats[$info]; } function get_item_settings() { $active_branch_id = active_branch_id(); $item_settings = DB::table('item_settings')->where('branch',$active_branch_id)->get(); if($item_settings->count() > 0) { return json_decode(json_encode($item_settings[0]),true); } else { return array( 'item_measurements' => 'ignore', 'invoice_units' => 'one_unit', 'fuel_parts' => 'disable', 'showroom' => 'disable', 'construction' => 'disable', 'service' => 'disable', 'sale_invoice' => 'sales_invoice_3', 'transfer' => 'n_transfer', 'cbm' => 'disable', 'bundle_toop' => 'disable', 'item_token' => 'disable', 'carton_purchase_sale' => 'disable', 'synchronization' => 'disable', 'distribution' => 'enable', 'orderm' => 'enable', 'journal' => 'enable', 'debit_credit_note' => 'enable', 'debit_credit_voucher' => 'enable', 'quotation' => 'enable', 'transferm' => 'enable', 'sale' => 'enable', 'shareholder' => 'enable', 'stock' => 'enable', 'turnover' => 'enable', 'purchase' => 'enable', 'production' => 'enable', 'production_raw' => 'enable', 'production_new' => 'enable', 'extra_income' => 'enable', 'extra_income_type' => 'enable', 'shareholder_credit' => 'enable', 'financial_accounts_ledger' => 'enable', 'item_stock' => 'enable', 'expenses' => 'enable', 'transit' => 'enable', 'hrm' => 'enable', 'assets' => 'enable', 'share_capital' => 'enable', 'metu' => 'enable', 'b_to_b_business' => 'enable', 'item_stock_in_out' => 'enable', ); } } function trigger_whatsapp_message($number,$message) { $wt_client = env('WHATSAPP_CLIENT'); if($wt_client == 'none') { return false; } $number = $number.'@c.us'; $curl = curl_init(); curl_setopt_array($curl, [ CURLOPT_URL => "https://waapi.app/api/v1/instances/2858/client/action/send-message", CURLOPT_RETURNTRANSFER => true, CURLOPT_ENCODING => "", CURLOPT_MAXREDIRS => 10, CURLOPT_TIMEOUT => 30, CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1, CURLOPT_CUSTOMREQUEST => "POST", CURLOPT_POSTFIELDS => "{\"chatId\":\"".$number."\",\"message\":\"".$message."\",\"mentions\":[\"123456789@c.us\",\"987654321@c.us\"]}", CURLOPT_HTTPHEADER => [ "Authorization: Bearer KEsFmVq55ZtX9ub8jt03EbAyGOp46XQbCtZAHu3T", "content-type: application/json" ], ]); $response = curl_exec($curl); $err = curl_error($curl); curl_close($curl); } function message_from_sales($uid) { $lang = get_app_language(); $db_entry = fetch_table_where('sales','uid',$uid,true); if(!empty($db_entry)) { $customer = $db_entry['client']; $currency_data = fetch_table_where('currency','uid',$db_entry['currency'],true); $currency_symbol = isset($currency_data['symbol']) ? $currency_data['symbol'] : null; $customer_data = fetch_table_where('accounts','uid',$db_entry['client'],true); $customer_phone = isset($customer_data['mobile']) ? $customer_data['mobile'] : null; $customer_name = isset($customer_data['name']) ? $customer_data['name'] : null; $branch_address = isset(active_branch_data()['branch_address']) ? active_branch_data()['branch_address'] : null; $branch_mobile = isset(active_branch_data()['branch_mobile']) ? active_branch_data()['branch_mobile'] : null; $grand_total_balance = 0; if(strpos($db_entry['client'],"CASHSALE") === FALSE){ $grand_total_balance = ($db_entry['remaining_amount']) + ($db_entry['old_balance']); } else { if((float)$db_entry['old_balance'] > 0) { $grand_total_balance = ($db_entry['remaining_amount']); } else { $grand_total_balance = ($db_entry['remaining_amount']); } } if(!empty($customer_phone)) { $text_value = '\n*'.ucfirst(active_branch_data()['branch_name']).'*'; $text_value .= '\n'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_sales_text_dear').' *'.$customer_name.'!*'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_sales_text_you_have_purchased').' *'.$db_entry['invoice'].'*'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_sales_text_invoice_total_amount').' *'.$currency_symbol.' '.amount_number_format($db_entry['sub_total']).'*'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_sales_text_paid').' *'.$currency_symbol.' '.amount_number_format($db_entry['cash_received']).'*'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_sales_text_pending').' *'.$currency_symbol.' '.amount_number_format($db_entry['remaining_amount']).'*'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_sales_text_prevoious_balance').' *'.$currency_symbol.' '.amount_number_format((float)$db_entry['old_balance']).'*'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_sales_text_balance').' *'.$currency_symbol.' '.amount_number_format($grand_total_balance).'*'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_sales_text_date').' *'.display_true_date($db_entry['created_at']).' '.date('h:i:s a',strtotime($db_entry['created_at'])).'*'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_sales_text_branch_address').' *'.$branch_address.'*'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_sales_text_branch_mobile').' *'.$branch_mobile.'*'; $text_value .= '\n'; $text_value .= ' *'.print_lang($lang,'system_whatsapp_message_sales_text_thanks').'!*'; $text_value .= '\n'; $text_value .= '\n'; $text_value .= ' *'.print_lang($lang,'system_whatsapp_message_sales_text_fastbooks_erp').'*'; trigger_whatsapp_message($customer_phone,$text_value); } } } function message_from_journal($uid) { $lang = get_app_language(); $db_entry = fetch_table_where('journal','uid',$uid,true); if(!empty($db_entry)) { $branch_address = isset(active_branch_data()['branch_address']) ? active_branch_data()['branch_address'] : null; $branch_mobile = isset(active_branch_data()['branch_mobile']) ? active_branch_data()['branch_mobile'] : null; if(!empty($db_entry['receiving_account'])) { $customer_data = fetch_table_where('accounts','uid',$db_entry['receiving_account'],true); $customer_phone = isset($customer_data['mobile']) ? $customer_data['mobile'] : null; $customer_name = isset($customer_data['name']) ? $customer_data['name'] : null; $currency_data = fetch_table_where('currency','uid',$db_entry['receiving_currency'],true); $currency_symbol = isset($currency_data['symbol']) ? $currency_data['symbol'] : null; $grand_total_balance = get_account_balance($db_entry['receiving_account'],$db_entry['receiving_currency']); if(!empty($customer_phone)) { $text_value = '\n*'.ucfirst(active_branch_data()['branch_name']).'*'; $text_value .= '\n'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_sales_text_dear').' *'.$customer_name.'!*'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_journal_text_we_have_received').' *'.$currency_symbol.' '.amount_number_format($db_entry['receiving_amount']).'* '.print_lang($lang,'system_whatsapp_message_journal_text_from_your_balance'); $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_journal_text_your_new_balance_is').' *'.$currency_symbol.' '.amount_number_format($grand_total_balance).'*'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_journal_text_receipt').' *'.$db_entry['serial_id'].'*'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_journal_text_details').' *'.$db_entry['receiving_narration'].'*'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_sales_text_date').' *'.display_true_date($db_entry['journal_date']).' '.date('h:i:s a',strtotime($db_entry['created_at'])).'*'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_sales_text_branch_address').' *'.$branch_address.'*'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_sales_text_branch_mobile').' *'.$branch_mobile.'*'; $text_value .= '\n'; $text_value .= ' *'.print_lang($lang,'system_whatsapp_message_sales_text_thanks').'!*'; $text_value .= '\n'; $text_value .= '\n'; $text_value .= ' *'.print_lang($lang,'system_whatsapp_message_sales_text_fastbooks_erp').'*'; trigger_whatsapp_message($customer_phone,$text_value); } } if(!empty($db_entry['payment_account'])) { $customer_data = fetch_table_where('accounts','uid',$db_entry['payment_account'],true); $customer_phone = isset($customer_data['mobile']) ? $customer_data['mobile'] : null; $customer_name = isset($customer_data['name']) ? $customer_data['name'] : null; $currency_data = fetch_table_where('currency','uid',$db_entry['payment_currency'],true); $currency_symbol = isset($currency_data['symbol']) ? $currency_data['symbol'] : null; $grand_total_balance = get_account_balance($db_entry['payment_account'],$db_entry['payment_currency']); if(!empty($customer_phone)) { $text_value = '\n*'.ucfirst(active_branch_data()['branch_name']).'*'; $text_value .= '\n'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_sales_text_dear').' *'.$customer_name.'!*'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_journal_text_you_have_received').' *'.$currency_symbol.' '.amount_number_format($db_entry['payment_amount']).'* '.print_lang($lang,'system_whatsapp_message_journal_text_to_your_balance'); $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_journal_text_your_new_balance_is').' *'.$currency_symbol.' '.amount_number_format($grand_total_balance).'*'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_journal_text_receipt').' *'.$db_entry['serial_id'].'*'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_journal_text_details').' *'.$db_entry['payment_narration'].'*'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_sales_text_date').' *'.display_true_date($db_entry['journal_date']).' '.date('h:i:s a',strtotime($db_entry['created_at'])).'*'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_sales_text_branch_address').' *'.$branch_address.'*'; $text_value .= '\n'; $text_value .= print_lang($lang,'system_whatsapp_message_sales_text_branch_mobile').' *'.$branch_mobile.'*'; $text_value .= '\n'; $text_value .= ' *'.print_lang($lang,'system_whatsapp_message_sales_text_thanks').'!*'; $text_value .= '\n'; $text_value .= '\n'; $text_value .= ' *'.print_lang($lang,'system_whatsapp_message_sales_text_fastbooks_erp').'*'; trigger_whatsapp_message($customer_phone,$text_value); } } } } function update_new_database_columns() { $host = env('DB_HOST'); $database = env('DB_DATABASE'); $user = env('DB_USERNAME'); $password = env('DB_PASSWORD'); $mysqli = new mysqli($host,$user,$password,$database); if ($mysqli -> connect_errno) { echo "Failed to connect to MySQL: " . $mysqli -> connect_error; exit(); } $mysqli -> query("ALTER TABLE items ADD COLUMN IF NOT EXISTS ava_bundle DOUBLE DEFAULT NULL AFTER _avg_cost;"); $mysqli -> query("ALTER TABLE items_inventory_stats ADD COLUMN IF NOT EXISTS invoice INT DEFAULT NULL AFTER batch;"); $mysqli -> query("ALTER TABLE activity_alerts ADD COLUMN IF NOT EXISTS user Varchar(255) DEFAULT NULL AFTER activity_time;"); $mysqli -> query("ALTER TABLE activity_alerts ADD COLUMN IF NOT EXISTS user_name Varchar(255) DEFAULT NULL AFTER user;"); $mysqli -> query("
        CREATE TABLE `sets` (
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `uid` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8_general_ci',
            `branch` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8_general_ci',
            `name` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8_general_ci',
            `items_details` LONGTEXT NULL DEFAULT NULL COLLATE 'utf8_general_ci',
            `created_at` DATETIME NULL DEFAULT current_timestamp(),
            PRIMARY KEY (`id`) USING BTREE
        )
        COLLATE='utf8_general_ci'
        ENGINE=InnoDB
        AUTO_INCREMENT=3
        ;
    "); $mysqli -> query("ALTER TABLE item_settings ADD COLUMN IF NOT EXISTS item_token Varchar(255) DEFAULT 'disable' AFTER bundle_toop;"); $mysqli -> query("ALTER TABLE items_inventory_stats ADD COLUMN IF NOT EXISTS item_token_in DOUBLE DEFAULT NULL AFTER toop_stock_out;"); $mysqli -> query("ALTER TABLE items_inventory_stats ADD COLUMN IF NOT EXISTS item_token_out DOUBLE DEFAULT NULL AFTER item_token_in;"); $mysqli -> query("ALTER TABLE items_inventory_stats ADD COLUMN IF NOT EXISTS token_rate DOUBLE DEFAULT NULL AFTER item_token_out;"); $mysqli -> query("ALTER TABLE metu_stock ADD COLUMN IF NOT EXISTS profit DOUBLE DEFAULT NULL AFTER sale_price;"); $mysqli -> query("ALTER TABLE items ADD COLUMN IF NOT EXISTS token_rate DOUBLE DEFAULT NULL AFTER _avg_cost;"); $mysqli -> query("
        CREATE TABLE `tokens` (
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `uid` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `branch` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `client` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `client_name` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `item` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `item_name` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `currency` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `currency_usd_equalance` DOUBLE NULL DEFAULT NULL,
            `currency_name` VARCHAR(50) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `currency_symbol` VARCHAR(50) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `token_date` DATETIME NULL DEFAULT NULL,
            `sold_qty` DOUBLE NULL DEFAULT NULL,
            `sold_amount` DOUBLE NULL DEFAULT NULL,
            `purchase_qty` DOUBLE NULL DEFAULT NULL,
            `purchase_amount` DOUBLE NULL DEFAULT NULL,
            `balance` DOUBLE NULL DEFAULT NULL,
            `account` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `account_name` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `created_at` DATETIME NOT NULL DEFAULT current_timestamp(),
            PRIMARY KEY (`id`) USING BTREE
        )
        COLLATE='utf8mb4_general_ci'
        ENGINE=InnoDB
        AUTO_INCREMENT=3
        ;
    "); $mysqli -> query("ALTER TABLE sales ADD COLUMN IF NOT EXISTS user Varchar(255) DEFAULT NULL AFTER delivery_type;"); $mysqli -> query("ALTER TABLE sales ADD COLUMN IF NOT EXISTS user_name Varchar(255) DEFAULT NULL AFTER user;"); $mysqli -> query("ALTER TABLE purchases ADD COLUMN IF NOT EXISTS user Varchar(255) DEFAULT NULL AFTER status;"); $mysqli -> query("ALTER TABLE purchases ADD COLUMN IF NOT EXISTS user_name Varchar(255) DEFAULT NULL AFTER user;"); $mysqli -> query("ALTER TABLE accounts_ledger ADD COLUMN IF NOT EXISTS module_details TEXT DEFAULT NULL AFTER narration;"); $mysqli -> query("ALTER TABLE capitals ADD COLUMN IF NOT EXISTS shareholder Varchar(255) DEFAULT NULL AFTER account_name;"); $mysqli -> query("ALTER TABLE capitals ADD COLUMN IF NOT EXISTS shareholder_name Varchar(255) DEFAULT NULL AFTER shareholder;"); $mysqli -> query("ALTER TABLE capitals ADD COLUMN IF NOT EXISTS percentage DOUBLE DEFAULT NULL AFTER amount;"); $mysqli -> query("
    	CREATE TABLE `turnover` (
    		`id` INT(11) NOT NULL AUTO_INCREMENT,
    		`uid` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`branch` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`currency` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`currency_name` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`currency_symbol` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`currency_usd_equalance` DOUBLE NULL DEFAULT NULL,
    		`from` DATE NULL DEFAULT NULL,
    		`to` DATE NULL DEFAULT NULL,
    		`sales_income` DOUBLE NULL DEFAULT NULL,
    		`services_income` DOUBLE NULL DEFAULT NULL,
    		`other_income` DOUBLE NULL DEFAULT NULL,
    		`total_revenue` DOUBLE NULL DEFAULT NULL,
    		`salaries` DOUBLE NULL DEFAULT NULL,
    		`costs_of_goods_sold` DOUBLE NULL DEFAULT NULL,
    		`expenses` DOUBLE NULL DEFAULT NULL,
    		`assets` DOUBLE NULL DEFAULT NULL,
    		`total_expenses` DOUBLE NULL DEFAULT NULL,
    		`net_income` DOUBLE NULL DEFAULT NULL,
    		`created_at` DATETIME NULL DEFAULT current_timestamp(),
    		PRIMARY KEY (`id`) USING BTREE
    	)
    	COLLATE='utf8mb4_general_ci'
    	ENGINE=InnoDB
    	AUTO_INCREMENT=22
    	;
    "); $mysqli -> query("
    	CREATE TABLE `turnover_details` (
    		`id` INT(11) NOT NULL AUTO_INCREMENT,
    		`uid` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`turnover_id` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`branch` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`currency` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`currency_name` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`currency_symbol` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`currency_usd_equalance` DOUBLE NULL DEFAULT NULL,
    		`from` DATE NULL DEFAULT NULL,
    		`to` DATE NULL DEFAULT NULL,
    		`sales_income` DOUBLE NULL DEFAULT NULL,
    		`services_income` DOUBLE NULL DEFAULT NULL,
    		`other_income` DOUBLE NULL DEFAULT NULL,
    		`total_revenue` DOUBLE NULL DEFAULT NULL,
    		`salaries` DOUBLE NULL DEFAULT NULL,
    		`costs_of_goods_sold` DOUBLE NULL DEFAULT NULL,
    		`expenses` DOUBLE NULL DEFAULT NULL,
    		`assets` DOUBLE NULL DEFAULT NULL,
    		`total_expenses` DOUBLE NULL DEFAULT NULL,
    		`net_income` DOUBLE NULL DEFAULT NULL,
    		`shareholder` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`shareholder_name` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`percentage` DOUBLE NULL DEFAULT NULL,
    		`amount` DOUBLE NULL DEFAULT NULL,
    		`created_at` DATETIME NULL DEFAULT current_timestamp(),
    		PRIMARY KEY (`id`) USING BTREE
    	)
    	COLLATE='utf8mb4_general_ci'
    	ENGINE=InnoDB
    	AUTO_INCREMENT=28
    	;
    "); $mysqli -> query("
    	CREATE TABLE `shareholder_credit` (
    		`id` INT(11) NOT NULL AUTO_INCREMENT,
    		`uid` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`branch` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`event_date` DATE NULL DEFAULT NULL,
    		`currency` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`currency_name` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`currency_symbol` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`shareholder` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`shareholder_name` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `amount` DOUBLE NULL DEFAULT NULL,
    		`percentage` DOUBLE NULL DEFAULT NULL,
    		`credit_account` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`credit_account_name` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`details` TEXT NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`created_at` DATETIME NULL DEFAULT current_timestamp(),
    		PRIMARY KEY (`id`) USING BTREE
    	)
    	COLLATE='utf8mb4_general_ci'
    	ENGINE=InnoDB
    	AUTO_INCREMENT=21
    	;
    "); $mysqli -> query("
    	CREATE TABLE `shareholder_ledger` (
    		`id` INT(11) NOT NULL AUTO_INCREMENT,
    		`uid` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`event_date` DATE NULL DEFAULT NULL,
    		`branch` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`module_uid` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`module_name` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`shareholder` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`shareholder_name` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`currency` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`currency_name` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`currency_symbol` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`credit` DOUBLE NULL DEFAULT NULL,
    		`debit` DOUBLE NULL DEFAULT NULL,
    		`details` TEXT NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
    		`created_at` DATETIME NULL DEFAULT current_timestamp(),
    		PRIMARY KEY (`id`) USING BTREE
    	)
    	COLLATE='utf8mb4_general_ci'
    	ENGINE=InnoDB
    	AUTO_INCREMENT=31
    	;
    "); $mysqli -> query("ALTER TABLE shareholder ADD COLUMN IF NOT EXISTS percentage DOUBLE DEFAULT NULL AFTER branch;"); $mysqli -> query("
        CREATE TABLE `item_stock_in` (
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `uid` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `branch` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `account` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `account_name` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `currency` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `currency_name` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `currency_symbol` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `event_date` DATE NULL DEFAULT NULL,
            `item` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `bill_number` INT(11) NULL DEFAULT NULL,
            `unit` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `quantity` DOUBLE NULL DEFAULT NULL,
            `cost` DOUBLE NULL DEFAULT NULL,
            `total` DOUBLE NULL DEFAULT NULL,
            `details` LONGTEXT NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `created_at` DATETIME NULL DEFAULT current_timestamp(),
            `import_query` VARCHAR(400) NULL DEFAULT 'no' COLLATE 'utf8mb4_general_ci',
            PRIMARY KEY (`id`) USING BTREE
        )
        COLLATE='utf8mb4_general_ci'
        ENGINE=InnoDB
        AUTO_INCREMENT=23
        ;
    "); $mysqli -> query("
        CREATE TABLE `item_stock_out` (
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `uid` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `branch` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `event_date` DATE NULL DEFAULT NULL,
            `item` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `item_name` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `unit` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `out_quantity` DOUBLE NULL DEFAULT NULL,
            `details` LONGTEXT NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `created_at` DATETIME NULL DEFAULT current_timestamp(),
            `import_query` VARCHAR(400) NULL DEFAULT 'no' COLLATE 'utf8mb4_general_ci',
            PRIMARY KEY (`id`) USING BTREE
        )
        COLLATE='utf8mb4_general_ci'
        ENGINE=InnoDB
        AUTO_INCREMENT=13
        ;
    "); $mysqli -> query("
        CREATE TABLE `item_stock_balance` (
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `uid` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `branch` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `event_date` DATE NULL DEFAULT NULL,
            `module_uid` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `module_name` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `item` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `item_name` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `bill_number` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `unit` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `cost` DOUBLE NULL DEFAULT NULL,
            `in_quantity` DOUBLE NULL DEFAULT NULL,
            `out_quantity` DOUBLE NULL DEFAULT NULL,
            `total` DOUBLE NULL DEFAULT NULL,
            `details` LONGTEXT NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `created_at` DATETIME NULL DEFAULT current_timestamp(),
            `import_query` VARCHAR(400) NULL DEFAULT 'no' COLLATE 'utf8mb4_general_ci',
            PRIMARY KEY (`id`) USING BTREE
        )
        COLLATE='utf8mb4_general_ci'
        ENGINE=InnoDB
        AUTO_INCREMENT=31
        ;
    "); $mysqli -> query("
        CREATE TABLE `division` (
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `uid` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `branch` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `name` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `created_at` DATETIME NULL DEFAULT current_timestamp(),
            PRIMARY KEY (`id`) USING BTREE
        )
        COLLATE='utf8mb4_general_ci'
        ENGINE=InnoDB
        AUTO_INCREMENT=11
        ;
    "); $mysqli -> query("ALTER TABLE employees ADD COLUMN IF NOT EXISTS division_uid VARCHAR(255) DEFAULT NULL AFTER employee_status;"); $mysqli -> query("ALTER TABLE employees ADD COLUMN IF NOT EXISTS division VARCHAR(255) DEFAULT NULL AFTER division_uid;"); $mysqli -> query("ALTER TABLE employees ADD COLUMN IF NOT EXISTS division_name VARCHAR(255) DEFAULT NULL AFTER division;"); $mysqli -> query("ALTER TABLE item_settings ADD COLUMN IF NOT EXISTS b_to_b_business VARCHAR(255) DEFAULT 'enable' AFTER metu;"); $mysqli -> query("ALTER TABLE item_settings ADD COLUMN IF NOT EXISTS item_stock_in_out VARCHAR(255) DEFAULT 'enable' AFTER b_to_b_business;"); $mysqli -> query("ALTER TABLE accounts ADD COLUMN IF NOT EXISTS employee_uid VARCHAR(255) DEFAULT NULL AFTER email;"); $mysqli -> query("ALTER TABLE item_stock_in ADD COLUMN IF NOT EXISTS item_name VARCHAR(255) DEFAULT NULL AFTER item;"); $mysqli -> query("ALTER TABLE item_stock_out ADD COLUMN IF NOT EXISTS total DOUBLE DEFAULT NULL AFTER out_quantity;"); $mysqli -> query("ALTER TABLE item_stock_out ADD COLUMN IF NOT EXISTS expense_type VARCHAR(255) DEFAULT NULL AFTER total;"); $mysqli -> query("ALTER TABLE expenses ADD COLUMN IF NOT EXISTS stock_uid VARCHAR(255) DEFAULT NULL AFTER narration;"); $mysqli -> query("
        CREATE TABLE `item_stock` (
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `uid` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `branch` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `name` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `currency` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `currency_name` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `currency_symbol` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `unit` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `avg_cost` DOUBLE NULL DEFAULT NULL,
            `in_qty` DOUBLE NULL DEFAULT NULL,
            `out_qty` DOUBLE NULL DEFAULT NULL,
            `ava_qty` DOUBLE NULL DEFAULT NULL,
            `created_at` DATETIME NULL DEFAULT current_timestamp(),
            PRIMARY KEY (`id`) USING BTREE
        )
        COLLATE='utf8mb4_general_ci'
        ENGINE=InnoDB
        AUTO_INCREMENT=4
        ;
    "); $mysqli -> query("ALTER TABLE production DROP IF EXISTS total_qty;"); $mysqli -> query("ALTER TABLE production DROP IF EXISTS ready_qty;"); $mysqli -> query("ALTER TABLE production DROP IF EXISTS pending_qty;"); $mysqli -> query("ALTER TABLE production DROP IF EXISTS total_produced_cost;"); $mysqli -> query("ALTER TABLE production DROP IF EXISTS total_damage;"); $mysqli -> query("ALTER TABLE production DROP IF EXISTS total_item_cost;"); $mysqli -> query("ALTER TABLE production DROP IF EXISTS total_profit;"); $mysqli -> query("ALTER TABLE production ADD COLUMN IF NOT EXISTS item VARCHAR(255) DEFAULT NULL AFTER branch;"); $mysqli -> query("ALTER TABLE production ADD COLUMN IF NOT EXISTS item_name VARCHAR(255) DEFAULT NULL AFTER item;"); $mysqli -> query("ALTER TABLE production ADD COLUMN IF NOT EXISTS total_real_cost DOUBLE DEFAULT NULL AFTER total_raw_cost;"); $mysqli -> query("ALTER TABLE production ADD COLUMN IF NOT EXISTS produced_per_item_cost DOUBLE DEFAULT NULL AFTER total_real_cost;"); $mysqli -> query("ALTER TABLE production ADD COLUMN IF NOT EXISTS cost DOUBLE DEFAULT NULL AFTER produced_per_item_cost;"); $mysqli -> query("ALTER TABLE production ADD COLUMN IF NOT EXISTS total_produced_qty DOUBLE DEFAULT NULL AFTER cost;"); $mysqli -> query("ALTER TABLE production ADD COLUMN IF NOT EXISTS qty DOUBLE DEFAULT NULL AFTER total_produced_qty;"); $mysqli -> query("ALTER TABLE production_details DROP IF EXISTS ready_qty;"); $mysqli -> query("ALTER TABLE production_details DROP IF EXISTS pending_qty;"); $mysqli -> query("ALTER TABLE production_details DROP IF EXISTS damage;"); $mysqli -> query("ALTER TABLE production_details DROP IF EXISTS ava_qty;"); $mysqli -> query("ALTER TABLE production_details DROP IF EXISTS expense;"); $mysqli -> query("ALTER TABLE production_details DROP IF EXISTS expense_account;"); $mysqli -> query("ALTER TABLE production_details ADD COLUMN IF NOT EXISTS rel_qty DOUBLE DEFAULT NULL AFTER qty;"); $mysqli -> query("ALTER TABLE production_details ADD COLUMN IF NOT EXISTS rel_cost DOUBLE DEFAULT NULL AFTER rel_qty;"); $mysqli -> query("ALTER TABLE production_details ADD COLUMN IF NOT EXISTS produced_item_cost_percentage DOUBLE DEFAULT NULL AFTER rel_cost;"); $mysqli -> query("ALTER TABLE production_details ADD COLUMN IF NOT EXISTS expense_type VARCHAR(255) DEFAULT NULL AFTER produced_item_cost_percentage;"); $mysqli -> query("ALTER TABLE production_details ADD COLUMN IF NOT EXISTS expense_amount DOUBLE DEFAULT NULL AFTER expense_type;"); $mysqli -> query("ALTER TABLE production_details ADD COLUMN IF NOT EXISTS general VARCHAR(255) DEFAULT 'no' AFTER expense_amount;"); $mysqli -> query("
        CREATE TABLE `production_raw` (
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `uid` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `branch` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `item` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `item_name` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `currency` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `currency_usd_equalance` DOUBLE NULL DEFAULT NULL,
            `serial_id` INT(11) NULL DEFAULT NULL,
            `invoice` INT(25) NULL DEFAULT NULL,
            `total_raw_cost` DOUBLE NULL DEFAULT NULL,
            `total_real_cost` DOUBLE NULL DEFAULT NULL,
            `produced_per_item_cost` DOUBLE NULL DEFAULT NULL,
            `cost` DOUBLE NULL DEFAULT NULL,
            `total_produced_qty` DOUBLE NULL DEFAULT NULL,
            `total_expenses` DOUBLE NULL DEFAULT NULL,
            `qty` DOUBLE NULL DEFAULT NULL,
            `created_at` DATETIME NOT NULL DEFAULT current_timestamp(),
            PRIMARY KEY (`id`) USING BTREE,
            INDEX `uid` (`uid`) USING BTREE
        )
        COLLATE='utf8mb4_general_ci'
        ENGINE=InnoDB
        AUTO_INCREMENT=9
        ;
    "); $mysqli -> query("
        CREATE TABLE `production_raw_details` (
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `uid` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `branch` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `event_date` DATETIME NULL DEFAULT NULL,
            `production_id` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `pro_type` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `currency` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `currency_usd_equalance` DOUBLE NOT NULL,
            `invoice` INT(25) NULL DEFAULT NULL,
            `warehouse` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `item` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `batch` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `unit` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `qty` DOUBLE NULL DEFAULT NULL,
            `rel_qty` DOUBLE NULL DEFAULT NULL,
            `rel_cost` DOUBLE NULL DEFAULT NULL,
            `cost` DOUBLE NULL DEFAULT NULL,
            `real_cost` DOUBLE NULL DEFAULT NULL,
            `produced_item_cost_percentage` DOUBLE NULL DEFAULT NULL,
            `profit` DOUBLE NULL DEFAULT NULL,
            `sale_price` DOUBLE NULL DEFAULT NULL,
            `total` DOUBLE NULL DEFAULT NULL,
            `expense_type` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `expense_amount` DOUBLE NULL DEFAULT NULL,
            `general` VARCHAR(50) NULL DEFAULT 'no' COLLATE 'utf8mb4_general_ci',
            `created_at` DATETIME NOT NULL DEFAULT current_timestamp(),
            PRIMARY KEY (`id`) USING BTREE,
            INDEX `uid` (`uid`) USING BTREE
        )
        COLLATE='utf8mb4_general_ci'
        ENGINE=InnoDB
        AUTO_INCREMENT=62
        ;
    "); $mysqli -> query("
        CREATE TABLE `production_raw_relation` (
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `uid` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `branch` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `item` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `item_name` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `qty` DOUBLE NULL DEFAULT NULL,
            `user` VARCHAR(255) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `user_name` VARCHAR(255) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `created_at` DATETIME NOT NULL DEFAULT current_timestamp(),
            PRIMARY KEY (`id`) USING BTREE,
            INDEX `uid` (`uid`) USING BTREE
        )
        COLLATE='utf8mb4_general_ci'
        ENGINE=InnoDB
        AUTO_INCREMENT=4
        ;
    "); $mysqli -> query("
        CREATE TABLE `production_raw_relation_details` (
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `uid` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `branch` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `module_uid` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `item_type` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `item` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `item_name` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `qty` DOUBLE NULL DEFAULT NULL,
            `cost_percentage` DOUBLE NULL DEFAULT NULL,
            `user` VARCHAR(255) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `user_name` VARCHAR(255) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `created_at` DATETIME NOT NULL DEFAULT current_timestamp(),
            PRIMARY KEY (`id`) USING BTREE,
            INDEX `uid` (`uid`) USING BTREE
        )
        COLLATE='utf8mb4_general_ci'
        ENGINE=InnoDB
        AUTO_INCREMENT=20
        ;
    "); $mysqli -> query("
        CREATE TABLE `production_relation` (
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `uid` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `branch` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `item` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `item_name` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `qty` DOUBLE NULL DEFAULT NULL,
            `user` VARCHAR(255) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `user_name` VARCHAR(255) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `created_at` DATETIME NOT NULL DEFAULT current_timestamp(),
            PRIMARY KEY (`id`) USING BTREE,
            INDEX `uid` (`uid`) USING BTREE
        )
        COLLATE='utf8mb4_general_ci'
        ENGINE=InnoDB
        AUTO_INCREMENT=3
        ;
    "); $mysqli -> query("
        CREATE TABLE `production_relation_details` (
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `uid` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `branch` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `module_uid` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `item_type` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `item` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `item_name` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `qty` DOUBLE NULL DEFAULT NULL,
            `cost_percentage` DOUBLE NULL DEFAULT NULL,
            `user` VARCHAR(255) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `user_name` VARCHAR(255) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `created_at` DATETIME NOT NULL DEFAULT current_timestamp(),
            PRIMARY KEY (`id`) USING BTREE,
            INDEX `uid` (`uid`) USING BTREE
        )
        COLLATE='utf8mb4_general_ci'
        ENGINE=InnoDB
        AUTO_INCREMENT=11
        ;
    "); $mysqli -> query("ALTER TABLE production ADD COLUMN IF NOT EXISTS warehouse VARCHAR(255) DEFAULT NULL AFTER item_name;"); $mysqli -> query("ALTER TABLE production ADD COLUMN IF NOT EXISTS warehouse_name VARCHAR(255) DEFAULT NULL AFTER warehouse;"); $mysqli -> query("ALTER TABLE production ADD COLUMN IF NOT EXISTS total_system_expenses DOUBLE DEFAULT NULL AFTER total_expenses;"); $mysqli -> query("ALTER TABLE production_raw ADD COLUMN IF NOT EXISTS warehouse VARCHAR(255) DEFAULT NULL AFTER item_name;"); $mysqli -> query("ALTER TABLE production_raw ADD COLUMN IF NOT EXISTS warehouse_name VARCHAR(255) DEFAULT NULL AFTER warehouse;"); $mysqli -> query("ALTER TABLE production_raw ADD COLUMN IF NOT EXISTS total_system_expenses DOUBLE DEFAULT NULL AFTER total_expenses;"); $mysqli -> query("
        CREATE TABLE `new_production` (
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `uid` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `branch` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `formula` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `formula_name` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `currency` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `currency_name` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `currency_symbol` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `usd_equalance` DOUBLE NULL DEFAULT NULL,
            `item` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `item_name` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `warehouse` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `warehouse_name` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `serial_id` INT(11) NULL DEFAULT NULL,
            `unit` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `qty` DOUBLE NULL DEFAULT NULL,
            `weight` DOUBLE NULL DEFAULT NULL,
            `total_weight` DOUBLE NULL DEFAULT NULL,
            `system_expenses` DOUBLE NULL DEFAULT NULL,
            `used_expenses` DOUBLE NULL DEFAULT NULL,
            `total_cost` DOUBLE NULL DEFAULT NULL,
            `total_real_cost` DOUBLE NULL DEFAULT NULL,
            `per_item_cost` DOUBLE NULL DEFAULT NULL,
            `created_at` DATETIME NULL DEFAULT current_timestamp(),
            PRIMARY KEY (`id`) USING BTREE
        )
        COLLATE='utf8mb4_general_ci'
        ENGINE=InnoDB
        AUTO_INCREMENT=2
        ;
    "); $mysqli -> query("
        CREATE TABLE `new_production_details` (
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `uid` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `branch` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `event_date` DATETIME NULL DEFAULT NULL,
            `production_id` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `pro_type` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `currency` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `currency_usd_equalance` DOUBLE NOT NULL,
            `invoice` INT(25) NULL DEFAULT NULL,
            `warehouse` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `item` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `batch` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `qty` DOUBLE NULL DEFAULT NULL,
            `percentage` DOUBLE NULL DEFAULT NULL,
            `unit` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `cost` DOUBLE NULL DEFAULT NULL,
            `real_cost` DOUBLE NULL DEFAULT NULL,
            `profit` DOUBLE NULL DEFAULT NULL,
            `sale_price` DOUBLE NULL DEFAULT NULL,
            `total` DOUBLE NULL DEFAULT NULL,
            `created_at` DATETIME NOT NULL DEFAULT current_timestamp(),
            PRIMARY KEY (`id`) USING BTREE,
            INDEX `uid` (`uid`) USING BTREE
        )
        COLLATE='utf8mb4_general_ci'
        ENGINE=InnoDB
        AUTO_INCREMENT=123
        ;
    "); $mysqli -> query("
        CREATE TABLE `new_production_formula` (
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `uid` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `branch` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `name` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `items` LONGTEXT NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `created_at` DATETIME NULL DEFAULT current_timestamp(),
            PRIMARY KEY (`id`) USING BTREE
        )
        COLLATE='utf8mb4_general_ci'
        ENGINE=InnoDB
        AUTO_INCREMENT=2
        ;
    "); $mysqli -> query("ALTER TABLE expenses ADD COLUMN IF NOT EXISTS sub_approval VARCHAR(255) DEFAULT 'approved' AFTER stock_uid;"); $mysqli -> query("ALTER TABLE expenses ADD COLUMN IF NOT EXISTS sub_approval_user VARCHAR(255) DEFAULT NULL AFTER sub_approval;"); $mysqli -> query("ALTER TABLE expenses ADD COLUMN IF NOT EXISTS sub_approval_user_name VARCHAR(255) DEFAULT NULL AFTER sub_approval_user;"); $mysqli -> query("ALTER TABLE expenses ADD COLUMN IF NOT EXISTS main_approval VARCHAR(255) DEFAULT 'approved' AFTER sub_approval_user_name;"); $mysqli -> query("ALTER TABLE expenses ADD COLUMN IF NOT EXISTS main_approval_user VARCHAR(255) DEFAULT NULL AFTER main_approval;"); $mysqli -> query("ALTER TABLE expenses ADD COLUMN IF NOT EXISTS main_approval_user_name VARCHAR(255) DEFAULT NULL AFTER main_approval_user;"); $mysqli -> query("ALTER TABLE item_stock_in ADD COLUMN IF NOT EXISTS sub_approval VARCHAR(255) DEFAULT 'approved' AFTER details;"); $mysqli -> query("ALTER TABLE item_stock_in ADD COLUMN IF NOT EXISTS sub_approval_user VARCHAR(255) DEFAULT NULL AFTER sub_approval;"); $mysqli -> query("ALTER TABLE item_stock_in ADD COLUMN IF NOT EXISTS sub_approval_user_name VARCHAR(255) DEFAULT NULL AFTER sub_approval_user;"); $mysqli -> query("ALTER TABLE item_stock_in ADD COLUMN IF NOT EXISTS main_approval VARCHAR(255) DEFAULT 'approved' AFTER sub_approval_user_name;"); $mysqli -> query("ALTER TABLE item_stock_in ADD COLUMN IF NOT EXISTS main_approval_user VARCHAR(255) DEFAULT NULL AFTER main_approval;"); $mysqli -> query("ALTER TABLE item_stock_in ADD COLUMN IF NOT EXISTS main_approval_user_name VARCHAR(255) DEFAULT NULL AFTER main_approval_user;"); $mysqli -> query("ALTER TABLE item_stock_out ADD COLUMN IF NOT EXISTS sub_approval VARCHAR(255) DEFAULT 'approved' AFTER details;"); $mysqli -> query("ALTER TABLE item_stock_out ADD COLUMN IF NOT EXISTS sub_approval_user VARCHAR(255) DEFAULT NULL AFTER sub_approval;"); $mysqli -> query("ALTER TABLE item_stock_out ADD COLUMN IF NOT EXISTS sub_approval_user_name VARCHAR(255) DEFAULT NULL AFTER sub_approval_user;"); $mysqli -> query("ALTER TABLE item_stock_out ADD COLUMN IF NOT EXISTS main_approval VARCHAR(255) DEFAULT 'approved' AFTER sub_approval_user_name;"); $mysqli -> query("ALTER TABLE item_stock_out ADD COLUMN IF NOT EXISTS main_approval_user VARCHAR(255) DEFAULT NULL AFTER main_approval;"); $mysqli -> query("ALTER TABLE item_stock_out ADD COLUMN IF NOT EXISTS main_approval_user_name VARCHAR(255) DEFAULT NULL AFTER main_approval_user;"); $mysqli -> query("ALTER TABLE journal ADD COLUMN IF NOT EXISTS sub_approval VARCHAR(255) DEFAULT 'approved' AFTER receipt_uid;"); $mysqli -> query("ALTER TABLE journal ADD COLUMN IF NOT EXISTS sub_approval_user VARCHAR(255) DEFAULT NULL AFTER sub_approval;"); $mysqli -> query("ALTER TABLE journal ADD COLUMN IF NOT EXISTS sub_approval_user_name VARCHAR(255) DEFAULT NULL AFTER sub_approval_user;"); $mysqli -> query("ALTER TABLE journal ADD COLUMN IF NOT EXISTS main_approval VARCHAR(255) DEFAULT 'approved' AFTER sub_approval_user_name;"); $mysqli -> query("ALTER TABLE journal ADD COLUMN IF NOT EXISTS main_approval_user VARCHAR(255) DEFAULT NULL AFTER main_approval;"); $mysqli -> query("ALTER TABLE journal ADD COLUMN IF NOT EXISTS main_approval_user_name VARCHAR(255) DEFAULT NULL AFTER main_approval_user;"); $mysqli -> query("ALTER TABLE purchases ADD COLUMN IF NOT EXISTS sub_approval VARCHAR(255) DEFAULT 'approved' AFTER user_name;"); $mysqli -> query("ALTER TABLE purchases ADD COLUMN IF NOT EXISTS sub_approval_user VARCHAR(255) DEFAULT NULL AFTER sub_approval;"); $mysqli -> query("ALTER TABLE purchases ADD COLUMN IF NOT EXISTS sub_approval_user_name VARCHAR(255) DEFAULT NULL AFTER sub_approval_user;"); $mysqli -> query("ALTER TABLE purchases ADD COLUMN IF NOT EXISTS main_approval VARCHAR(255) DEFAULT 'approved' AFTER sub_approval_user_name;"); $mysqli -> query("ALTER TABLE purchases ADD COLUMN IF NOT EXISTS main_approval_user VARCHAR(255) DEFAULT NULL AFTER main_approval;"); $mysqli -> query("ALTER TABLE purchases ADD COLUMN IF NOT EXISTS main_approval_user_name VARCHAR(255) DEFAULT NULL AFTER main_approval_user;"); $mysqli -> query("ALTER TABLE sales ADD COLUMN IF NOT EXISTS sub_approval VARCHAR(255) DEFAULT 'approved' AFTER user_name;"); $mysqli -> query("ALTER TABLE sales ADD COLUMN IF NOT EXISTS sub_approval_user VARCHAR(255) DEFAULT NULL AFTER sub_approval;"); $mysqli -> query("ALTER TABLE sales ADD COLUMN IF NOT EXISTS sub_approval_user_name VARCHAR(255) DEFAULT NULL AFTER sub_approval_user;"); $mysqli -> query("ALTER TABLE sales ADD COLUMN IF NOT EXISTS main_approval VARCHAR(255) DEFAULT 'approved' AFTER sub_approval_user_name;"); $mysqli -> query("ALTER TABLE sales ADD COLUMN IF NOT EXISTS main_approval_user VARCHAR(255) DEFAULT NULL AFTER main_approval;"); $mysqli -> query("ALTER TABLE sales ADD COLUMN IF NOT EXISTS main_approval_user_name VARCHAR(255) DEFAULT NULL AFTER main_approval_user;"); $mysqli -> query("
        CREATE TABLE `extra_income_type` (
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `uid` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `branch` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `name` VARCHAR(400) NULL DEFAULT NULL COLLATE 'utf8mb4_general_ci',
            `created_at` DATETIME NOT NULL DEFAULT current_timestamp(),
            PRIMARY KEY (`id`) USING BTREE,
            INDEX `uid` (`uid`) USING BTREE
        )
        COLLATE='utf8mb4_general_ci'
        ENGINE=InnoDB
        AUTO_INCREMENT=126
        ;
    "); $mysqli -> query("ALTER TABLE extra_income ADD COLUMN IF NOT EXISTS type VARCHAR(255) DEFAULT NULL AFTER account;"); $mysqli -> query("ALTER TABLE extra_income ADD COLUMN IF NOT EXISTS type_name VARCHAR(255) DEFAULT NULL AFTER type;"); $mysqli -> query("ALTER TABLE accounts_ledger ADD COLUMN IF NOT EXISTS module_columns LONGTEXT DEFAULT NULL AFTER module_details;"); $mysqli -> query("ALTER TABLE item_settings ADD COLUMN IF NOT EXISTS production_raw VARCHAR(255) DEFAULT 'enable' AFTER production;"); $mysqli -> query("ALTER TABLE item_settings ADD COLUMN IF NOT EXISTS production_new VARCHAR(255) DEFAULT 'enable' AFTER production_raw;"); $mysqli -> close(); echo "Successfully Updated database"; echo "<br>"; echo "<br>"; echo "<a href=".url('/').">Go To Dashboard</a>"; } function _handle_module_columns_in_accounts_ledger() { $items = fetch_table('items'); $purchases = fetch_table('purchases'); $sales = fetch_table('sales'); $transfer_in = fetch_table('transfer_in'); $transfer_out = fetch_table('transfer_out'); $expenses = fetch_table('expenses'); $journal = fetch_table('journal'); $production = fetch_table('production'); $extra_income = fetch_table('extra_income'); } ?>