<?php
 function fetch_construction_projects_cost($data_array) { $currencies = $data_array['currencies']; $projects = $data_array['projects']; $all_in_usd = array(); foreach($projects as $row) { if($row['status'] == 'completed') { if(array_key_exists($row['currency'],$currencies)) { $amount = (float)$row['cost']; $amount_currency_usd_equalance = (float)$row['currency_usd_equalance']; if($amount_currency_usd_equalance <= 0){ $amount_currency_usd_equalance = 1; } if(!array_key_exists('amount',$currencies[$row['currency']])){ $currencies[$row['currency']]['amount'] = array(); } $currencies[$row['currency']]['amount'][] = $amount; $usd_currency_usd_equalance = 1; $all_in_usd[] = amount_conversion($amount, $amount_currency_usd_equalance, $usd_currency_usd_equalance); } } } return array('currencies' => $currencies, 'all_in_usd' => $all_in_usd); } function fetch_construction_projects_pending_amount($data_array) { $currencies = $data_array['currencies']; $projects = $data_array['projects']; $all_in_usd = array(); foreach($projects as $row) { if(array_key_exists($row['currency'],$currencies)) { $amount = (float)$row['pending_amount']; $amount_currency_usd_equalance = (float)$row['currency_usd_equalance']; if($amount_currency_usd_equalance <= 0){ $amount_currency_usd_equalance = 1; } if(!array_key_exists('amount',$currencies[$row['currency']])){ $currencies[$row['currency']]['amount'] = array(); } $currencies[$row['currency']]['amount'][] = $amount; $usd_currency_usd_equalance = 1; $all_in_usd[] = amount_conversion($amount, $amount_currency_usd_equalance, $usd_currency_usd_equalance); } } return array('currencies' => $currencies, 'all_in_usd' => $all_in_usd); } function fetch_construction_projects_expenses($data_array) { $currencies = $data_array['currencies']; $expenses_deductions = $data_array['expenses_deductions']; $all_in_usd = array(); foreach($expenses_deductions as $row) { if(array_key_exists($row['currency'],$currencies)) { $amount = (float)$row['amount']; $amount_currency_usd_equalance = (float)$row['currency_usd_equalance']; if($amount_currency_usd_equalance <= 0){ $amount_currency_usd_equalance = 1; } if(!array_key_exists('amount',$currencies[$row['currency']])){ $currencies[$row['currency']]['amount'] = array(); } $currencies[$row['currency']]['amount'][] = $amount; $usd_currency_usd_equalance = 1; $all_in_usd[] = amount_conversion($amount, $amount_currency_usd_equalance, $usd_currency_usd_equalance); } } return array('currencies' => $currencies, 'all_in_usd' => $all_in_usd); } function fetch_construction_projects_profit($data_array) { $currencies = $data_array['currencies']; $projects = $data_array['projects']; $expenses_deductions = $data_array['expenses_deductions']; $all_in_usd = array(); foreach($projects as $row) { if($row['status'] == 'completed') { if(array_key_exists($row['currency'],$currencies)) { $project_cost = (float)$row['cost']; $project_expenses = array(); $project_currency_usd_equalance = (float)$row['currency_usd_equalance']; if($project_currency_usd_equalance <= 0){ $project_currency_usd_equalance = 1; } foreach($expenses_deductions as $expense_deduction) { if($expense_deduction['project'] == $row['uid']){ $project_expenses[] = $expense_deduction['amount']; } } $project_expenses = array_sum($project_expenses); $project_profit = $project_cost - $project_expenses; if(!array_key_exists('amount',$currencies[$row['currency']])){ $currencies[$row['currency']]['amount'] = array(); } $currencies[$row['currency']]['amount'][] = $project_profit; $usd_currency_usd_equalance = 1; $all_in_usd[] = amount_conversion($project_profit, $project_currency_usd_equalance, $usd_currency_usd_equalance); } } } return array('currencies' => $currencies, 'all_in_usd' => $all_in_usd); } function get_projects_dashboard_stats($data_array) { $pending_amount_of_projects_bucket = array(); $cash_paid_amount_of_projects_bucket = array(); $number_of_pending_projects_bucket = array(); $cost_of_pending_projects_bucket = array(); $number_of_completed_projects_bucket = array(); $cost_of_completed_projects_bucket = array(); $expenses_deductions_of_completed_projects_bucket = array(); $profit_of_completed_projects_bucket = array(); foreach($data_array['projects'] as $project) { $row_project_expenses_deductions = array(); if($project['currency'] == $data_array['currency']) { $cash_paid_amount_of_projects_bucket[] = (float)$project['cash_paid']; if($project['status'] == 'pending') { $number_of_pending_projects_bucket[] = $project['uid']; $cost_of_pending_projects_bucket[] = (float)$project['cost']; } if($project['status'] == 'completed') { $number_of_completed_projects_bucket[] = $project['uid']; $cost_of_completed_projects_bucket[] = (float)$project['cost']; $row_project_cost[] = (float)$project['cost']; $payment_deductions = DB::table('payment_deductions')->where('project',$project['uid'])->sum('project_according_amount'); $cash_paid = (float)$project['cash_paid'] + $payment_deductions; $pending_amount = (float)$project['cost'] - $cash_paid; $pending_amount_of_projects_bucket[] = (float)$pending_amount; $project_deductions = calculate_project_deductions($project['uid']); $deductions_balance = (float)$project_deductions['expenses']; $profit_amount = (float)$project['cost'] - $deductions_balance; $expenses_deductions_of_completed_projects_bucket[] = $deductions_balance; $profit_of_completed_projects_bucket[] = $profit_amount; } } } $number_of_pending_expenses_deductions_bucket = array(); foreach($data_array['expenses_deductions'] as $expense) { if($expense['status'] == 'pending') { $number_of_pending_expenses_deductions_bucket[] = $expense['uid']; } } return array( 'number_of_pending_projects' => count($number_of_pending_projects_bucket), 'number_of_completed_projects' => count($number_of_completed_projects_bucket), 'cost_of_pending_projects' => array_sum($cost_of_pending_projects_bucket), 'cost_of_completed_projects' => array_sum($cost_of_completed_projects_bucket), 'pending_amount_of_projects' => array_sum($pending_amount_of_projects_bucket), 'cash_paid_of_projects' => array_sum($cash_paid_amount_of_projects_bucket), 'expenses_deductions_of_completed_projects' => array_sum($expenses_deductions_of_completed_projects_bucket), 'profit_of_completed_projects' => array_sum($profit_of_completed_projects_bucket), 'number_of_pending_expenses_deductions' => count($number_of_pending_expenses_deductions_bucket), ); } function get_project_assign_ledger($project_assign) { $data_array = array(); $total_machine_time_worked = 0; $total_working_time = 0; $amount = 0; $total_amount = 0; $working_time_user = ''; if(!empty($project_assign)) { $project_data = fetch_table_where_branch('projects','uid',$project_assign['project'],true); if($project_assign['assign_type'] == 'employee') { $total_working_time = $project_assign['num_of_duration']; $working_time_user = $project_assign['num_of_duration']; $contract_data = fetch_table_where_branch('ccontracts','uid',$project_assign['employee'],true); $employee_data = fetch_table_where_branch('accounts','uid',$contract_data['employee'],true); $contract_duration_type = isset($contract_data['duration_type']) ? $contract_data['duration_type'] : NULL; $description = ucwords($project_data['name'])." ".$project_data['address']." ".round_decimels_digits($total_working_time).' '.$contract_duration_type." ".$project_assign['employee_comments']; $description_process = ucwords($employee_data['name']).": ".round_decimels_digits($total_working_time).' '.$contract_duration_type." ".$project_assign['employee_comments']; $amount = (float)$contract_data['amount']; $total_amount = $total_working_time * $amount; $data_array = array( 'description' => $description, 'description_process' => $description_process, 'total_amount' => round_decimels_digits($total_amount), 'account' => $employee_data['uid'], 'type' => 'employee', 'working_time' => $working_time_user, 'item' => '', 'unit' => '', 'qty' => '', 'item_total' => '', 'user' => $project_assign['user'], ); } if($project_assign['assign_type'] == 'machinery') { $contract_data = fetch_table_where_branch('ccontracts','uid',$project_assign['machinery'],true); $supplier_data = fetch_table_where_branch('accounts','uid',$contract_data['supplier'],true); $machine_working_hour_per_day = (float)$contract_data['machinery_working_hours']; $total_working_time = $project_assign['number_of_hours']; $total_machine_time_worked = $total_working_time; $amount = (float)$contract_data['machinery_rate']; $total_amount = $total_machine_time_worked * $amount; $description = ucwords($supplier_data['name'])." ".round_decimels_digits($total_machine_time_worked)." hours ".$project_assign['machinery_comments']; $description_process = ucwords($project_data['name'])." ".$project_data['address']." ".round_decimels_digits($total_machine_time_worked)." hours ".$project_assign['machinery_comments']; $data_array = array( 'description' => $description, 'description_process' => $description_process, 'total_amount' => round_decimels_digits($total_amount), 'account' => $supplier_data['uid'], 'type' => 'supplier', 'working_time' => $total_machine_time_worked, 'item' => '', 'unit' => '', 'qty' => '', 'item_total' => '', 'user' => $project_assign['user'], ); } if($project_assign['assign_type'] == 'material') { $citems_data = fetch_table_where_branch('citems','uid',$project_assign['item'],true); $description_process = ucwords($citems_data['name'])." ".ucwords($citems_data['unit'])." ".$project_assign['qty']." ".$project_assign['material_comments']; $data_array = array( 'description' => '', 'description_process' => $description_process, 'total_amount' => '', 'account' => '', 'type' => 'material', 'working_time' => '', 'item' => $citems_data['name'], 'unit' => $citems_data['unit'], 'qty' => $project_assign['qty'].( isset($citems_data['unit']) ? ' '.ucwords($citems_data['unit']) : NULL ), 'item_total' => $project_assign['item_total'], 'user' => $project_assign['user'], ); } } return $data_array; } function get_date_differences($date1,$date2) { $d1 = strtotime($date1." 00:00:00"); $d2 = strtotime($date2." 24:00:00"); $totalSecondsDiff = abs($d1-$d2); $totalMinutesDiff = $totalSecondsDiff/60; $totalHoursDiff = $totalSecondsDiff/60/60; $totalDaysDiff = $totalSecondsDiff/60/60/24; $totalMonthsDiff = $totalSecondsDiff/60/60/24/30; $totalYearsDiff = $totalSecondsDiff/60/60/24/365; return array( 'seconds' => $totalSecondsDiff, 'minutes' => $totalMinutesDiff, 'hours' => $totalHoursDiff, 'days' => $totalDaysDiff, 'months' => $totalMonthsDiff, 'years' => $totalYearsDiff, ); } function get_project_assign_employees() { $employees_array = array(); $accounts = set_array_keys(fetch_table_where_branch('accounts','type','employee'),'uid'); $contracts = fetch_table_where_branch('ccontracts','contract_type','employee'); if(!empty($contracts)) { foreach($contracts as $contract) { if(!empty($contract['employee'])) { $employees_array[] = array( 'uid' => $contract['uid'], 'name' => array_key_exists($contract['employee'],$accounts) ? $accounts[$contract['employee']]['name'] : NULL, ); } } } return $employees_array; } function c_warehouse_details($c_items,$purchases,$projects_assign) { $data_array = array(); if(!empty($purchases)) { foreach($c_items as $item) { $purchase_array = array(); $assign_array = array(); $item_cost = 0; foreach($purchases as $purchase) { $last_cost = DB::table("cpurchases")->where("item",$item['uid'])->orderBy('id','desc')->get()->first(); $last_cost = json_decode(json_encode($last_cost),true); $item_cost = $last_cost['rate']; if($purchase['item'] == $item['uid']) { if(!array_key_exists($item['uid'], $data_array)) { $data_array[$item['uid']] = array(); } $purchase_array[] = $purchase['qty']; $data_array[$item['uid']] = array( 'name' => $item['name'], 'unit' => $item['unit'], 'last_cost' => $item_cost, 'total_purchases' => array_sum($purchase_array), 'total_assign' => 0, 'available' => array_sum($purchase_array) - array_sum($assign_array), ); } } foreach($projects_assign as $assign) { if($assign['item'] == $item['uid']) { if(!array_key_exists($item['uid'], $data_array)) { $data_array[$item['uid']] = array(); } $assign_array[] = $assign['qty']; $data_array[$item['uid']]['total_assign'] = array_sum($assign_array); $data_array[$item['uid']]['available'] = array_sum($purchase_array) - array_sum($assign_array); } } } } return $data_array; } function get_received_money_data($data_array) { $project = $data_array['project']; $expenses_deductions = $data_array['expenses_deductions']; $project_payments = $data_array['project_payments']; $accounts = $data_array['accounts']; $project_currency = $project['currency']; $project_currency_usd_equalance = (float)$project['currency_usd_equalance']; $data_bucket = array(); foreach($expenses_deductions as $row) { if($row['payment_type'] == 'cash') { $expense_amount = (float)$row['amount']; if($row['currency'] != $project_currency) { $expense_amount = amount_conversion($expense_amount, $row['currency_usd_equalance'], $project_currency_usd_equalance); } $data_bucket[] = array( 'type' => 'expenses_deductions', 'date' => $row['edate'], 'details' => $row['comments'], 'credit' => NULL, 'debit' => $expense_amount, ); } if($row['payment_type'] == 'loan') { $loan_cash_paid = (float)$row['loan_cash_paid']; if($row['currency'] != $project_currency) { $loan_cash_paid = amount_conversion($loan_cash_paid, $row['currency_usd_equalance'], $project_currency_usd_equalance); } $data_bucket[] = array( 'type' => 'loan', 'date' => $row['edate'], 'details' => $row['loan_details'], 'credit' => NULL, 'debit' => $loan_cash_paid, ); } } foreach($project_payments as $row) { $payment_amount = (float)$row['amount']; if($row['currency'] != $project_currency) { $payment_amount = amount_conversion($payment_amount, $row['currency_usd_equalance'], $project_currency_usd_equalance); } $credit = $payment_amount; $debit = NULL; $data_bucket[] = array( 'type' => 'project_payments', 'date' => $row['pdate'], 'details' => $row['comments'], 'credit' => $credit, 'debit' => $debit, ); } return $data_bucket; } function calculate_project_deductions($uid) { $project = DB::table('projects')->where('uid',$uid); $payment_deductions = DB::table('payment_deductions')->where('project',$uid); $expenses_deductions = DB::table('expenses_deductions')->where('project',$uid); $projects_assign = DB::table('projects_assign')->where('project',$uid); $project = json_decode(json_encode($project->get()->first()),true); $payment_deductions = json_decode(json_encode($payment_deductions->get()),true); $expenses_deductions = json_decode(json_encode($expenses_deductions->get()),true); $projects_assign = json_decode(json_encode($projects_assign->get()),true); return get_project_process_details($project,$payment_deductions,$expenses_deductions,$projects_assign,'deductions'); } function get_project_process_details($project,$payment_deductions,$expenses_deductions,$projects_assign,$return_mood=FALSE) { $process_details_bucket = array(); $payment_collections = array(); $expenses_collections = array(); $project_currency = $project['currency']; $project_currency_usd_equalance = (float)$project['currency_usd_equalance']; $process_details_bucket[] = array( 'currency' => $project_currency, 'date' => $project['start_date'].' 00:00:00', 'description' => 'Project registration cash paid', 'supervisor' => $project['user'], 'type' => NULL, 'unit' => NULL, 'qty' => NULL, 'debit' => NULL, 'credit' => $project['cash_paid'], 'entry_type' => 'project_cash_paid', 'entry_source' => $project, ); foreach($payment_deductions as $row) { $payment_amount = (float)$row['amount']; if($row['currency'] != $project_currency) { $payment_amount = amount_conversion($payment_amount, $row['currency_usd_equalance'], $project_currency_usd_equalance); } $payment_collections[] = $payment_amount; $process_details_bucket[] = array( 'currency' => $project_currency, 'date' => $row['pdate'].' 00:00:00', 'description' => $row['comments'], 'supervisor' => $row['user'], 'type' => 'Payment', 'unit' => NULL, 'qty' => NULL, 'debit' => NULL, 'credit' => $payment_amount, 'entry_type' => 'payment_deduction', 'source_data' => $row, ); } foreach($expenses_deductions as $row) { if($row['user_type'] == 'project_user') { if($row['status'] == 'pending'){ continue; } } if($row['expenses_mood'] == 'inventory_expenses') { $expenses_amount = $row['amount']; $expenses_collections[] = $expenses_amount; $process_details_bucket[] = array( 'currency' => $project_currency, 'date' => $row['edate'].' 00:00:00', 'description' => $row['comments'], 'supervisor' => $row['user'], 'type' => 'Expenses', 'unit' => $row['unit'], 'qty' => $row['qty'], 'debit' => $expenses_amount, 'credit' => NULL, 'entry_type' => 'expenses_inventory_deduction', 'source_data' => $row, ); } else { if($row['deduction_type'] != 'project'){ continue; } $expenses_amount = $row['amount']; if($row['currency'] != $project_currency) { $expenses_amount = amount_conversion($expenses_amount, $row['currency_usd_equalance'], $project_currency_usd_equalance); } $expenses_collections[] = $expenses_amount; $process_details_bucket[] = array( 'currency' => $project_currency, 'date' => $row['edate'].' 00:00:00', 'description' => $row['comments'], 'supervisor' => $row['user'], 'type' => 'Expenses', 'unit' => NULL, 'qty' => NULL, 'debit' => $expenses_amount, 'credit' => NULL, 'entry_type' => 'expenses_cash_deduction', 'source_data' => $row, ); } } foreach($projects_assign as $row) { $project_assign_data = get_project_assign_ledger($row); if(!empty($project_assign_data)) { if($project_assign_data['type'] == 'material') { $amount = $project_assign_data['item_total']; } else { $amount = $project_assign_data['total_amount']; } if($row['project_currency'] != $project_currency) { $amount = amount_conversion($amount, (float)$row['project_currency_usd_equalance'], $project_currency_usd_equalance); } $expenses_collections[] = $amount; $process_details_bucket[] = array( 'currency' => $project_currency, 'date' => $row['created_at'], 'description' => $project_assign_data['description_process'], 'supervisor' => $project_assign_data['user'], 'type' => 'Project Assign', 'unit' => $project_assign_data['unit'], 'qty' => $project_assign_data['qty'], 'debit' => $amount, 'credit' => NULL, 'entry_type' => $project_assign_data['type'], 'source_data' => $row, ); } } if($return_mood == 'deductions') { return array('payments' => array_sum($payment_collections), 'expenses' => array_sum($expenses_collections)); } else { return $process_details_bucket; } } function get_warehouse_details($warehouse,$items,$purchases,$production,$sales,$sales_return,$transfer_in,$transfer_out,$branch_to_branch_transfer,$damage,$transfer,$branch_transfer_in,$branch_transfer_out,$expenses_deductions,$bundle_toop) { $branch_id = active_branch_id(); $warehouse_wise_items = get_items_complete_info($items,$purchases,$production,$sales,$sales_return,$transfer_in,$transfer_out,$branch_to_branch_transfer,$damage,$transfer,$branch_transfer_in,$branch_transfer_out,$expenses_deductions,$bundle_toop); $warehouse_items = array(); foreach($warehouse_wise_items as $row) { if(array_key_exists($warehouse, $row['stats']['avail_units'])) { $warehouse_items[] = $row; } } return $warehouse_items; } function get_item_related_for_expenses_deduction($app_lang,$uid) { $item_stats = array(); $warehouse_wise_stats = get_item_stats($uid); if(count($warehouse_wise_stats) > 0) { $item_stats['avg_cost'] = amount_conversion($warehouse_wise_stats[0]['stats']['avg_cost'], $warehouse_wise_stats[0]['currency_usd_equalance'], 1); $warehouses_in_db = set_array_keys(fetch_table_branch('warehouse'),'uid'); $warehouse_options = array(); $avail_units = $warehouse_wise_stats[0]['stats']['avail_units']; foreach($avail_units as $warehouse_uid => $avail_units) { $warehouse_name = array_key_exists($warehouse_uid,$warehouses_in_db) ? $warehouses_in_db[$warehouse_uid]['name'] : NULL; $warehouse_options[$warehouse_uid] = $warehouse_name.' (AV: '.$avail_units.')'; } $item_stats['warehouse_options'] = $warehouse_options; $units_in_db = set_array_keys(fetch_table_branch('units'),'uid'); $units_options = array(); $purchase_unit_name = array_key_exists($warehouse_wise_stats[0]['purchase_unit'],$units_in_db) ? $units_in_db[$warehouse_wise_stats[0]['purchase_unit']]['name'] : NULL; $units_options['purchase'] = $warehouse_wise_stats[0]['purchase_unit_equalance'].'-,-'.$purchase_unit_name; if($warehouse_wise_stats[0]['purchase_unit'] != $warehouse_wise_stats[0]['sale_unit']) { $sale_unit_name = array_key_exists($warehouse_wise_stats[0]['sale_unit'],$units_in_db) ? $units_in_db[$warehouse_wise_stats[0]['sale_unit']]['name'] : NULL; $units_options['sale'] = $warehouse_wise_stats[0]['sale_unit_equalance'].'-,-'.$sale_unit_name; } if($warehouse_wise_stats[0]['production_unit'] != $warehouse_wise_stats[0]['purchase_unit'] AND $warehouse_wise_stats[0]['production_unit'] != $warehouse_wise_stats[0]['sale_unit']) { $production_unit_name = array_key_exists($warehouse_wise_stats[0]['production_unit'],$units_in_db) ? $units_in_db[$warehouse_wise_stats[0]['production_unit']]['name'] : NULL; $units_options['production'] = $warehouse_wise_stats[0]['production_unit_equalance'].'-,-'.$production_unit_name; } $item_stats['units_options'] = $units_options; $item_stats['status'] = 'success'; return $item_stats; } else { return array('status' => 'error', 'message_head' => 'System Error', 'message_body' => 'System not found any data.'); } } function fetch_item_avg_cost($item_stats){ return isset($item_stats['stats']['avg_cost']) ? $item_stats['stats']['avg_cost'] : 0; } function fetch_item_last_cost($item_stats){ return isset($item_stats['stats']['last_cost']) ? $item_stats['stats']['last_cost'] : 0; } function fetch_item_last_profit($item_stats){ return isset($item_stats['stats']['last_profit']) ? $item_stats['stats']['last_profit'] : 0; } function get_items_for_sale() { $branch_id = active_branch_id(); $items = DB::table('items')->where('branch',$branch_id); $purchases = DB::table('purchases')->where('branch',$branch_id); $production = DB::table('production_details')->where('branch',$branch_id); $sales = DB::table('sales')->where('branch',$branch_id); $sales_return = DB::table('sales_return')->where('branch',$branch_id); $transfer_in = DB::table('transfer_in')->where('branch',$branch_id); $transfer_out = DB::table('transfer_out')->where('branch',$branch_id); $branch_to_branch_transfer = DB::table('branch_to_branch_transfer'); $damage = DB::table('damage')->where('branch',$branch_id); $transfer = DB::table('transfer')->where('branch',$branch_id); $branch_transfer_in = DB::table('branch_transfer_in')->where('branch',$branch_id); $branch_transfer_out = DB::table('branch_transfer_out')->where('branch',$branch_id); $expenses_deductions = DB::table('expenses_deductions')->where('branch',$branch_id)->where('expenses_mood','inventory_expenses')->where('status','approved'); $bundle_toop = DB::table('items_bundle_toop_stock')->where('branch',$branch_id); $items = json_decode(json_encode($items->get()),true); $purchases = json_decode(json_encode($purchases->get()),true); $production = json_decode(json_encode($production->get()),true); $sales = json_decode(json_encode($sales->get()),true); $sales_return = json_decode(json_encode($sales_return->get()),true); $transfer_in = json_decode(json_encode($transfer_in->get()),true); $transfer_out = json_decode(json_encode($transfer_out->get()),true); $branch_to_branch_transfer = json_decode(json_encode($branch_to_branch_transfer->get()),true); $damage = json_decode(json_encode($damage->get()),true); $transfer = json_decode(json_encode($transfer->get()),true); $branch_transfer_in = json_decode(json_encode($branch_transfer_in->get()),true); $branch_transfer_out = json_decode(json_encode($branch_transfer_out->get()),true); $expenses_deductions = json_decode(json_encode($expenses_deductions->get()),true); $bundle_toop = json_decode(json_encode($bundle_toop->get()),true); $warehouse_wise_items = get_items_complete_info($items,$purchases,$production,$sales,$sales_return,$transfer_in,$transfer_out,$branch_to_branch_transfer,$damage,$transfer,$branch_transfer_in,$branch_transfer_out,$expenses_deductions,$bundle_toop); return $warehouse_wise_items; } function get_item_stats($uid) { $branch_id = active_branch_id(); $item_data = fetch_table_where('items','uid',$uid,true); $_item_in_to_other_branch = isset($item_data['b_to_b_rel_uid']) ? $item_data['b_to_b_rel_uid'] : null; $items = DB::table('items')->where('branch',$branch_id)->where('uid',$uid); $purchases = DB::table('purchases')->where('branch',$branch_id)->where('status','passed')->where('items_uid','like','%-++-'.$uid.'-++-%'); $production = DB::table('production_details')->where('branch',$branch_id)->where('item',$uid); $sales = DB::table('sales')->where('branch',$branch_id)->where('sale_items','like','%-++-'.$uid.'-++-%'); $sales_return = DB::table('sales_return')->where('branch',$branch_id)->where('sale_items','like','%-++-'.$uid.'-++-%'); $transfer_in = DB::table('transfer_in')->where('branch',$branch_id)->where('items_uid','like','%-++-'.$uid.'-++-%'); $transfer_out = DB::table('transfer_out')->where('branch',$branch_id)->where('items_uid','like','%-++-'.$uid.'-++-%'); $branch_to_branch_transfer = DB::table('branch_to_branch_transfer') ->where(function($query) use ($branch_id,$uid,$_item_in_to_other_branch){ $query->where('branch',$branch_id)->orWhere('to_branch',$branch_id); $query->where('item',$uid)->orWhere('b_to_b_rel_uid',$uid); $query->where('item',$_item_in_to_other_branch)->orWhere('b_to_b_rel_uid',$_item_in_to_other_branch); }); $damage = DB::table('damage')->where('branch',$branch_id)->where('item',$uid); $transfer = DB::table('transfer')->where('branch',$branch_id)->where('item',$uid); $branch_transfer_in = DB::table('branch_transfer_in')->where('branch',$branch_id)->where('item',$uid); $branch_transfer_out = DB::table('branch_transfer_out')->where('branch',$branch_id)->where('item',$uid); $expenses_deductions = DB::table('expenses_deductions')->where('branch',$branch_id)->where('item',$uid)->where('expenses_mood','inventory_expenses')->where('status','approved'); $bundle_toop = DB::table('items_bundle_toop_stock')->where('branch',$branch_id)->where('item',$uid); $items = json_decode(json_encode($items->get()),true); $purchases = json_decode(json_encode($purchases->get()),true); $production = json_decode(json_encode($production->get()),true); $sales = json_decode(json_encode($sales->get()),true); $sales_return = json_decode(json_encode($sales_return->get()),true); $transfer_in = json_decode(json_encode($transfer_in->get()),true); $transfer_out = json_decode(json_encode($transfer_out->get()),true); $branch_to_branch_transfer = json_decode(json_encode($branch_to_branch_transfer->get()),true); $damage = json_decode(json_encode($damage->get()),true); $transfer = json_decode(json_encode($transfer->get()),true); $branch_transfer_in = json_decode(json_encode($branch_transfer_in->get()),true); $branch_transfer_out = json_decode(json_encode($branch_transfer_out->get()),true); $expenses_deductions = json_decode(json_encode($expenses_deductions->get()),true); $bundle_toop = json_decode(json_encode($bundle_toop->get()),true); $warehouse_wise_items = get_items_complete_info($items,$purchases,$production,$sales,$sales_return,$transfer_in,$transfer_out,$branch_to_branch_transfer,$damage,$transfer,$branch_transfer_in,$branch_transfer_out,$expenses_deductions,$bundle_toop); return $warehouse_wise_items; } function get_items_complete_info($items,$purchases,$production,$sales,$sales_return,$transfer_in,$transfer_out,$branch_to_branch_transfer,$damage,$transfer,$branch_transfer_in,$branch_transfer_out,$expenses_deductions,$bundle_toop) { $items_joined_data = join_item_data($items,$purchases,$production,$sales,$sales_return,$transfer_in,$transfer_out,$branch_to_branch_transfer,$damage,$transfer,$branch_transfer_in,$branch_transfer_out,$expenses_deductions,$bundle_toop); $embeded_stats_items = array(); foreach($items_joined_data as $row) { $stats = array(); $stats['avg_cost'] = $row['items']['_avg_cost']; $stats['last_cost'] = process_get_item_last_cost($row['items'],$row['purchases'],$row['production_in'],$row['item_branch_to_branch_transfer_in']); $stats['last_profit'] = process_get_item_last_profit($row['items'],$row['purchases'],$row['production_in'],$row['item_branch_to_branch_transfer_in']); $stats['total_profit'] = process_get_item_profit($row['items'],$row['sales']); $stats['opening_units'] = fetch_item_opening_units($row['items']); $stats['purchase_units'] = fetch_item_purchase_units($row['items'],$row['purchases']); $stats['production_in_units'] = fetch_item_production_in_units($row['items'],$row['production_in']); $stats['production_out_units'] = fetch_item_production_out_units($row['items'],$row['production_out']); $stats['sale_units'] = fetch_item_sale_units($row['items'],$row['sales']); $stats['sale_return_units'] = fetch_item_sale_return_units($row['items'],$row['sales_return']); $stats['branch_to_branch_transfer_in_units'] = fetch_item_branch_to_branch_transfer_in_units($row['items'],$row['item_branch_to_branch_transfer_in']); $stats['branch_to_branch_transfer_out_units'] = fetch_item_branch_to_branch_transfer_out_units($row['items'],$row['item_branch_to_branch_transfer_out']); $stats['damage_units'] = fetch_item_damage_units($row['items'],$row['damage']); $stats['expenses_deductions_units'] = fetch_item_expenses_deductions_units($row['items'],$row['expenses_deductions']); $item_transferred_units = fetch_item_transfer_units($row['items'],$row['transfer']); $stats['transfer_in_units'] = $item_transferred_units['in']; $stats['transfer_out_units'] = $item_transferred_units['out']; $branch_transfer_units = fetch_item_branch_transfer_units($row['items'],$row['branch_transfer_in'],$row['branch_transfer_out']); $stats['branch_transfer_in_units'] = $branch_transfer_units['in']; $stats['branch_transfer_out_units'] = $branch_transfer_units['out']; $transfer_in_out_units = fetch_item_branch_transfer_units_pharmaone($row['items'],$row['transfer_in'],$row['transfer_out']); $stats['transfer_in_pharma'] = $transfer_in_out_units['in']; $stats['transfer_out_pharma'] = $transfer_in_out_units['out']; $bundle_stock_in_out_units = fetch_item_bundle_units($row['items'],$row['bundle_stock_in'],$row['bundle_stock_out']); $stats['bundle_stock_in_units'] = $bundle_stock_in_out_units['in']; $stats['bundle_stock_out_units'] = $bundle_stock_in_out_units['out']; $toop_stock_in_out_units = fetch_item_toop_units($row['items'],$row['toop_stock_in'],$row['toop_stock_out']); $stats['toop_stock_in_units'] = $toop_stock_in_out_units['in']; $stats['toop_stock_out_units'] = $toop_stock_in_out_units['out']; $affected_warehouses = array(); foreach($stats['opening_units'] as $whcr_key => $whcr_value){ $affected_warehouses[] = $whcr_key; } foreach($stats['purchase_units'] as $whcr_key => $whcr_value){ $affected_warehouses[] = $whcr_key; } foreach($stats['production_in_units'] as $whcr_key => $whcr_value){ $affected_warehouses[] = $whcr_key; } foreach($stats['production_out_units'] as $whcr_key => $whcr_value){ $affected_warehouses[] = $whcr_key; } foreach($stats['sale_units'] as $whcr_key => $whcr_value){ $affected_warehouses[] = $whcr_key; } foreach($stats['sale_return_units'] as $whcr_key => $whcr_value){ $affected_warehouses[] = $whcr_key; } foreach($stats['branch_to_branch_transfer_in_units'] as $whcr_key => $whcr_value){ $affected_warehouses[] = $whcr_key; } foreach($stats['branch_to_branch_transfer_out_units'] as $whcr_key => $whcr_value){ $affected_warehouses[] = $whcr_key; } foreach($stats['damage_units'] as $whcr_key => $whcr_value){ $affected_warehouses[] = $whcr_key; } foreach($stats['transfer_in_units'] as $whcr_key => $whcr_value){ $affected_warehouses[] = $whcr_key; } foreach($stats['transfer_out_units'] as $whcr_key => $whcr_value){ $affected_warehouses[] = $whcr_key; } foreach($stats['branch_transfer_in_units'] as $whcr_key => $whcr_value){ $affected_warehouses[] = $whcr_key; } foreach($stats['branch_transfer_out_units'] as $whcr_key => $whcr_value){ $affected_warehouses[] = $whcr_key; } foreach($stats['expenses_deductions_units'] as $whcr_key => $whcr_value){ $affected_warehouses[] = $whcr_key; } foreach($stats['transfer_in_pharma'] as $whcr_key => $whcr_value){ $affected_warehouses[] = $whcr_key; } foreach($stats['transfer_out_pharma'] as $whcr_key => $whcr_value){ $affected_warehouses[] = $whcr_key; } foreach($stats['bundle_stock_in_units'] as $whcr_key => $whcr_value){ $affected_warehouses[] = $whcr_key; } foreach($stats['bundle_stock_out_units'] as $whcr_key => $whcr_value){ $affected_warehouses[] = $whcr_key; } foreach($stats['toop_stock_in_units'] as $whcr_key => $whcr_value){ $affected_warehouses[] = $whcr_key; } foreach($stats['toop_stock_out_units'] as $whcr_key => $whcr_value){ $affected_warehouses[] = $whcr_key; } $affected_warehouses = array_unique($affected_warehouses); $item_receiving_units = array(); $item_stock_in_units = array(); $item_stock_out_units = array(); $item_avail_stock_units = array(); foreach($affected_warehouses as $aw_uid) { $warehouse_stock_in_units = array(); $warehouse_stock_out_units = array(); $warehouse_branch_wtransfer_in_units = array(); $warehouse_branch_wtransfer_out_units = array(); $warehouse_branch_transfer_in_units = array(); $warehouse_branch_transfer_out_units = array(); $warehouse_transfer_in_pharma_units = array(); $warehouse_transfer_out_pharma_units = array(); $warehouse_bundle_stock_in_units = array(); $warehouse_bundle_stock_out_units = array(); $warehouse_toop_stock_in_units = array(); $warehouse_toop_stock_out_units = array(); $warehouse_branch_to_branch_transfer_in_units = array(); $warehouse_branch_to_branch_transfer_out_units = array(); $warehouse_production_in_units = array(); $warehouse_production_out_units = array(); $warehouse_damage_units = array(); $warehouse_expenses_deductions_units = array(); $warehouse_receiving_units = array(); if(array_key_exists($aw_uid, $stats['opening_units'])) { $warehouse_stock_in_units[] = $stats['opening_units'][$aw_uid]; $warehouse_receiving_units[] = $stats['opening_units'][$aw_uid]; } if(array_key_exists($aw_uid, $stats['purchase_units'])) { $warehouse_stock_in_units[] = $stats['purchase_units'][$aw_uid]; $warehouse_receiving_units[] = $stats['purchase_units'][$aw_uid]; } if(array_key_exists($aw_uid, $stats['sale_return_units'])) { $warehouse_stock_in_units[] = $stats['sale_return_units'][$aw_uid]; $warehouse_receiving_units[] = $stats['sale_return_units'][$aw_uid]; } if(array_key_exists($aw_uid, $stats['transfer_in_units'])) { $warehouse_branch_wtransfer_in_units[] = $stats['transfer_in_units'][$aw_uid]; } if(array_key_exists($aw_uid, $stats['branch_transfer_in_units'])) { $warehouse_receiving_units[] = $stats['branch_transfer_in_units'][$aw_uid]; $warehouse_branch_transfer_in_units[] = $stats['branch_transfer_in_units'][$aw_uid]; } if(array_key_exists($aw_uid, $stats['branch_transfer_out_units'])) { $warehouse_branch_transfer_out_units[] = $stats['branch_transfer_out_units'][$aw_uid]; } if(array_key_exists($aw_uid, $stats['transfer_in_pharma'])) { $warehouse_receiving_units[] = $stats['transfer_in_pharma'][$aw_uid]; $warehouse_transfer_in_pharma_units[] = $stats['transfer_in_pharma'][$aw_uid]; } if(array_key_exists($aw_uid, $stats['transfer_out_pharma'])) { $warehouse_transfer_out_pharma_units[] = $stats['transfer_out_pharma'][$aw_uid]; } if(array_key_exists($aw_uid, $stats['bundle_stock_in_units'])) { $warehouse_bundle_stock_in_units_units[] = $stats['bundle_stock_in_units'][$aw_uid]; } if(array_key_exists($aw_uid, $stats['bundle_stock_out_units'])) { $warehouse_bundle_stock_out_units_units[] = $stats['bundle_stock_out_units'][$aw_uid]; } if(array_key_exists($aw_uid, $stats['toop_stock_in_units'])) { $toop_stock_in_units_units[] = $stats['toop_stock_in_units'][$aw_uid]; } if(array_key_exists($aw_uid, $stats['toop_stock_out_units'])) { $warehouse_toop_stock_out_units_units[] = $stats['toop_stock_out_units'][$aw_uid]; } if(array_key_exists($aw_uid, $stats['sale_units'])){ $warehouse_stock_out_units[] = $stats['sale_units'][$aw_uid]; } if(array_key_exists($aw_uid, $stats['transfer_out_units'])) { $warehouse_branch_wtransfer_out_units[] = $stats['transfer_out_units'][$aw_uid]; } if(array_key_exists($aw_uid, $stats['branch_to_branch_transfer_in_units'])){ $warehouse_branch_to_branch_transfer_in_units[] = $stats['branch_to_branch_transfer_in_units'][$aw_uid]; } if(array_key_exists($aw_uid, $stats['branch_to_branch_transfer_out_units'])){ $warehouse_branch_to_branch_transfer_out_units[] = $stats['branch_to_branch_transfer_out_units'][$aw_uid]; } if(array_key_exists($aw_uid, $stats['production_in_units'])){ $warehouse_production_in_units[] = $stats['production_in_units'][$aw_uid]; } if(array_key_exists($aw_uid, $stats['production_out_units'])){ $warehouse_production_out_units[] = $stats['production_out_units'][$aw_uid]; } if(array_key_exists($aw_uid, $stats['damage_units'])){ $warehouse_damage_units[] = $stats['damage_units'][$aw_uid]; } if(array_key_exists($aw_uid, $stats['expenses_deductions_units'])){ $warehouse_expenses_deductions_units[] = $stats['expenses_deductions_units'][$aw_uid]; } $item_receiving_units[$aw_uid] = array_sum($warehouse_receiving_units); $item_stock_in_units[$aw_uid] = array_sum($warehouse_stock_in_units); $item_stock_out_units[$aw_uid] = array_sum($warehouse_stock_out_units); $cal_item_avail_stock_units = array_sum($warehouse_stock_in_units) - array_sum($warehouse_stock_out_units); $cal_item_avail_stock_units = $cal_item_avail_stock_units - array_sum($warehouse_damage_units); $cal_item_avail_stock_units = $cal_item_avail_stock_units - array_sum($warehouse_expenses_deductions_units); $cal_item_avail_stock_units = $cal_item_avail_stock_units + array_sum($warehouse_branch_transfer_in_units) + array_sum($warehouse_transfer_in_pharma_units) + array_sum($warehouse_branch_wtransfer_in_units); $cal_item_avail_stock_units = $cal_item_avail_stock_units - array_sum($warehouse_branch_transfer_out_units) - array_sum($warehouse_branch_wtransfer_out_units); $cal_item_avail_stock_units = $cal_item_avail_stock_units - array_sum($warehouse_transfer_out_pharma_units); $cal_item_avail_stock_units = $cal_item_avail_stock_units + array_sum($warehouse_branch_to_branch_transfer_in_units); $cal_item_avail_stock_units = $cal_item_avail_stock_units - array_sum($warehouse_branch_to_branch_transfer_out_units); $cal_item_avail_stock_units = $cal_item_avail_stock_units + array_sum($warehouse_production_in_units); $cal_item_avail_stock_units = $cal_item_avail_stock_units - array_sum($warehouse_production_out_units); $item_avail_stock_units[$aw_uid] = $cal_item_avail_stock_units; } $stats['receiving_units'] = $item_receiving_units; $stats['stock_in_units'] = $item_stock_in_units; $stats['stock_out_units'] = $item_stock_out_units; $stats['avail_units'] = $item_avail_stock_units; $row['items']['stats'] = $stats; $embeded_stats_items[] = $row['items']; } return $embeded_stats_items; } function get_items_for_production() { $items = fetch_table_branch('items'); $purchases = fetch_table_branch('purchases'); $production = fetch_table_branch('production'); $sales = fetch_table_branch('sales'); $sales_return = fetch_table_branch('sales_return'); $transfer_in = fetch_table_branch('transfer_in'); $transfer_out = fetch_table_branch('transfer_out'); $damage = fetch_table_branch('damage'); $transfer = fetch_table_branch('transfer'); $branch_transfer_in = fetch_table_branch('branch_transfer_in'); $branch_transfer_out = fetch_table_branch('branch_transfer_out'); $expenses_deductions = fetch_table_branch('expenses_deductions'); $items_joined_data = join_item_data($items,$purchases,$production,$sales,$sales_return,$transfer_in,$transfer_out,$damage,$transfer,$branch_transfer_in,$branch_transfer_out,$expenses_deductions); $embeded_stats_items = array(); foreach($items_joined_data as $row) { $row['items']['fn_avail_units'] = unit_based_conversion($row['items'],'purchase',process_get_item_avail_units($row['items'],$row['purchases'],$row['production'],$row['sales'],$row['damage'],$row['branch_transfer_in'],$row['branch_transfer_out'])); $row['items']['fn_avg_cost'] = unit_based_conversion($row['items'],'purchase',process_item_batch_wise_avg_cost($row['items'])); $row['items']['fn_first_cost'] = unit_based_conversion($row['items'],'purchase',$row['items']['cost']); $embeded_stats_items[] = $row['items']; } return $embeded_stats_items; } function join_item_data($items,$purchases,$production,$sales,$sales_return,$transfer_in,$transfer_out,$branch_to_branch_transfer,$damage,$transfer,$branch_transfer_in,$branch_transfer_out,$expenses_deductions,$bundle_toop) { usort($purchases, function ($a, $b) {return $a['id'] < $b['id'];}); usort($production, function ($a, $b) {return $a['id'] < $b['id'];}); $items_bucket = array(); foreach($items as $item) { $item_purchases_avg = array(); $item_purchases = array(); $item_production_avg = array(); $item_production = array(); $item_production_in = array(); $item_production_out = array(); $item_sales = array(); $item_sales_return = array(); $item_transfer_in = array(); $item_transfer_out = array(); $item_branch_to_branch_transfer_in = array(); $item_branch_to_branch_transfer_out = array(); $item_damage = array(); $item_transfer = array(); $item_branch_transfer_in = array(); $item_branch_transfer_out = array(); $item_expenses_deductions = array(); foreach($purchases as $row) { $purchase_details = json_decode($row['items'],true); foreach($purchase_details as $inner_row) { if($inner_row['item'] == $item['uid']) { if(count($item_purchases) < 3) { $item_purchases_avg[] = $row; } $item_purchases[] = $row; break; } } } foreach($production as $row) { if($row['pro_type'] == 'produced') { if($row['item'] == $item['uid']) { if(count($item_production_in) < 3) { if($row['qty'] != 0 AND !empty($row['qty'])) { $item_production_avg[] = $row; } } if($row['qty'] != 0 AND !empty($row['qty'])) { $item_production_in[] = $row; } } } if($row['pro_type'] == 'raw') { if($row['item'] == $item['uid']) { $item_production_out[] = $row; } } } foreach($sales as $row) { $sale_details = json_decode($row['items_details'],true); foreach($sale_details as $inner_row) { if($inner_row['item'] == $item['uid']) { $item_sales[] = $row; break; } } } foreach($sales_return as $row) { $sale_details = json_decode($row['items_details'],true); foreach($sale_details as $inner_row) { if($inner_row['item'] == $item['uid']) { $item_sales_return[] = $row; break; } } } foreach($transfer_in as $row) { $transfer_in_details = json_decode($row['items'],true); foreach($transfer_in_details as $inner_row) { if($inner_row['item'] == $item['uid']) { $item_transfer_in[] = $row; break; } } } foreach($transfer_out as $row) { $transfer_out_details = json_decode($row['items'],true); foreach($transfer_out_details as $inner_row) { if($inner_row['item'] == $item['uid']) { $item_transfer_out[] = $row; break; } } } foreach($branch_to_branch_transfer as $row) { if($row['item'] == $item['uid']) { if($row['branch'] == active_branch_id()) { $item_branch_to_branch_transfer_out[] = $row; } } if($row['b_to_b_rel_uid'] == $item['uid'] OR $row['b_to_b_rel_uid'] == $item['b_to_b_rel_uid']) { if($row['to_branch'] == active_branch_id()) { $row['item'] = $item['uid']; $row['warehouse'] = $row['to_warehouse']; $item_branch_to_branch_transfer_in[] = $row; } } } foreach($damage as $row) { if($row['item'] == $item['uid']) { $item_damage[] = $row; } } foreach($transfer as $row) { if($row['item'] == $item['uid']) { $item_transfer[] = $row; } } foreach($branch_transfer_in as $row) { if($row['item'] == $item['uid']) { $item_branch_transfer_in[] = $row; } } foreach($branch_transfer_out as $row) { if($row['item'] == $item['uid']) { $item_branch_transfer_out[] = $row; } } foreach($expenses_deductions as $row) { if($row['item'] == $item['uid']) { $item_expenses_deductions[] = $row; } } $bundle_stock_in = []; $bundle_stock_out = []; $toop_stock_in = []; $toop_stock_out = []; foreach($bundle_toop as $row) { if($row['item'] == $item['uid'] AND (empty($row['bundle_stock_out']) OR $row['bundle_stock_out'] == 0)) { $bundle_stock_in[] = $row; } if($row['item'] == $item['uid'] AND (empty($row['bundle_stock_in']) OR $row['bundle_stock_in'] == 0)) { $bundle_stock_out[] = $row; } if($row['item'] == $item['uid'] AND (empty($row['toop_stock_out']) OR $row['toop_stock_out'] == 0)) { $toop_stock_in[] = $row; } if($row['item'] == $item['uid'] AND (empty($row['toop_stock_in']) OR $row['toop_stock_in'] == 0)) { $toop_stock_out[] = $row; } } $items_bucket[] = array('items' => $item, 'purchases' => $item_purchases, 'purchases_avg' => $item_purchases_avg, 'production' => $item_production, 'production_in' => $item_production_in, 'production_out' => $item_production_out, 'production_avg' => $item_production_avg, 'sales' => $item_sales, 'sales_return' => $item_sales_return, 'transfer_in' => $item_transfer_in, 'transfer_out' => $item_transfer_out, 'damage' => $item_damage, 'transfer' => $item_transfer, 'branch_transfer_in' => $item_branch_transfer_in, 'branch_transfer_out' => $item_branch_transfer_out, 'expenses_deductions' => $item_expenses_deductions, 'item_branch_to_branch_transfer_in' => $item_branch_to_branch_transfer_in, 'item_branch_to_branch_transfer_out' => $item_branch_to_branch_transfer_out, 'bundle_stock_in' => $bundle_stock_in, 'bundle_stock_out' => $bundle_stock_out, 'toop_stock_in' => $toop_stock_in, 'toop_stock_out' => $toop_stock_out); } return $items_bucket; } function fetch_item_opening_units($item) { $opening_units_bucket = array(); $item_settings = get_item_settings(); $warehouses = json_decode($item['warehouses'],true); $opening_stocks = json_decode($item['opening_stocks'],true); foreach($warehouses as $key => $row) { $qty = isset($opening_stocks[$key]) ? $opening_stocks[$key] : 0; if(!array_key_exists($row,$opening_units_bucket)){ $opening_units_bucket[$row] = array(); } $opening_units_bucket[$row][] = $qty; } $fnf_opening_units_bucket = array(); foreach($opening_units_bucket as $key => $values) { $fnf_opening_units_bucket[$key] = array_sum($values); } return $fnf_opening_units_bucket; } function fetch_item_purchase_units($item,$purchases) { $purchase_units_bucket = array(); $item_settings = get_item_settings(); foreach($purchases as $row) { if($row['status'] != 'passed'){ continue; } $purchase_details = json_decode($row['items'],true); foreach($purchase_details as $inner_row) { $purchase_item_bonus = isset($inner_row['bonus']) ? (float)$inner_row['bonus'] : 0; if($inner_row['item'] == $item['uid']) { if($item_settings['item_measurements'] == 'get') { $purchase_item_qty = (float)$inner_row['qty'] + $purchase_item_bonus; } else { $purchase_item_qty = (float)$inner_row['qty'] + $purchase_item_bonus; } if($inner_row['unit'] == 'purchase'){ $purchase_item_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($purchase_item_qty / (float)$item['purchase_unit_equalance']); } if($inner_row['unit'] == 'sale'){ $purchase_item_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($purchase_item_qty / (float)$item['sale_unit_equalance']); } if($inner_row['unit'] == 'production'){ $purchase_item_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($purchase_item_qty / (float)$item['production_unit_equalance']); } if(!array_key_exists($inner_row['warehouse'],$purchase_units_bucket)){ $purchase_units_bucket[$inner_row['warehouse']] = array(); } $purchase_units_bucket[$inner_row['warehouse']][] = $purchase_item_qty; } } } $fnf_purchase_units_bucket = array(); foreach($purchase_units_bucket as $key => $values) { $fnf_purchase_units_bucket[$key] = array_sum($values); } return $fnf_purchase_units_bucket; } function fetch_item_production_units($item,$production) { $production_units_bucket = array(); foreach($production as $row) { if($item['type'] == 'sales') { if($row['item'] == $item['uid']) { $production_item_qty = (float)$row['qty']; if($row['unit'] == 'purchase'){ $production_item_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($production_item_qty / (float)$item['purchase_unit_equalance']); } if($row['unit'] == 'sale'){ $production_item_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($production_item_qty / (float)$item['sale_unit_equalance']); } if($row['unit'] == 'production'){ $production_item_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($production_item_qty / (float)$item['production_unit_equalance']); } if(!array_key_exists($row['warehouse'],$production_units_bucket)){ $production_units_bucket[$row['warehouse']] = array(); } $production_units_bucket[$row['warehouse']][] = $production_item_qty; } } else { $raw_items = json_decode($row['raw_details'],true); foreach($raw_items as $raw_item) { if($raw_item['item'] == $item['uid']) { $production_raw_item_qty = (float)$raw_item['used_qty']; if($raw_item['unit'] == 'purchase'){ $production_raw_item_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($production_raw_item_qty / (float)$item['purchase_unit_equalance']); } if($raw_item['unit'] == 'sale'){ $production_raw_item_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($production_raw_item_qty / (float)$item['sale_unit_equalance']); } if($raw_item['unit'] == 'production'){ $production_raw_item_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($production_raw_item_qty / (float)$item['production_unit_equalance']); } if(!array_key_exists($raw_item['warehouse'],$production_units_bucket)){ $production_units_bucket[$raw_item['warehouse']] = array(); } $production_units_bucket[$raw_item['warehouse']][] = $production_raw_item_qty; } } } } $fnf_production_units_bucket = array(); foreach($production_units_bucket as $key => $values) { $fnf_production_units_bucket[$key] = array_sum($values); } return $fnf_production_units_bucket; } function fetch_item_production_in_units($item,$production) { $production_units_bucket = array(); foreach($production as $row) { if($row['item'] == $item['uid']) { $production_item_qty = (float)$row['qty']; if($row['unit'] == 'purchase'){ $production_item_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($production_item_qty / (float)$item['purchase_unit_equalance']); } if($row['unit'] == 'sale'){ $production_item_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($production_item_qty / (float)$item['sale_unit_equalance']); } if($row['unit'] == 'production'){ $production_item_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($production_item_qty / (float)$item['production_unit_equalance']); } if(!array_key_exists($row['warehouse'],$production_units_bucket)){ $production_units_bucket[$row['warehouse']] = array(); } $production_units_bucket[$row['warehouse']][] = $production_item_qty; } } $fnf_production_units_bucket = array(); foreach($production_units_bucket as $key => $values) { $fnf_production_units_bucket[$key] = array_sum($values); } return $fnf_production_units_bucket; } function fetch_item_production_out_units($item,$production) { $production_units_bucket = array(); foreach($production as $row) { if($row['item'] == $item['uid']) { $production_item_qty = (float)$row['qty']; if($row['unit'] == 'purchase'){ $production_item_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($production_item_qty / (float)$item['purchase_unit_equalance']); } if($row['unit'] == 'sale'){ $production_item_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($production_item_qty / (float)$item['sale_unit_equalance']); } if($row['unit'] == 'production'){ $production_item_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($production_item_qty / (float)$item['production_unit_equalance']); } if(!array_key_exists($row['warehouse'],$production_units_bucket)){ $production_units_bucket[$row['warehouse']] = array(); } $production_units_bucket[$row['warehouse']][] = $production_item_qty; } } $fnf_production_units_bucket = array(); foreach($production_units_bucket as $key => $values) { $fnf_production_units_bucket[$key] = array_sum($values); } return $fnf_production_units_bucket; } function fetch_item_sale_units($item,$sales) { $sale_units_bucket = array(); foreach($sales as $row) { $sale_details = json_decode($row['items_details'],true); foreach($sale_details as $inner_row) { $sale_item_bonus = isset($inner_row['bonus']) ? (float)$inner_row['bonus'] : 0; if($inner_row['item'] == $item['uid']) { $sale_item_qty = (float)$inner_row['qty'] + $sale_item_bonus; if($inner_row['unit'] == 'purchase'){ $sale_item_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($sale_item_qty / (float)$item['purchase_unit_equalance']); } if($inner_row['unit'] == 'sale'){ $sale_item_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($sale_item_qty / (float)$item['sale_unit_equalance']); } if($inner_row['unit'] == 'production'){ $sale_item_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($sale_item_qty / (float)$item['production_unit_equalance']); } if(!array_key_exists($inner_row['warehouse'],$sale_units_bucket)){ $sale_units_bucket[$inner_row['warehouse']] = array(); } $sale_units_bucket[$inner_row['warehouse']][] = $sale_item_qty; } } } $fnf_sale_units_bucket = array(); foreach($sale_units_bucket as $key => $values) { $fnf_sale_units_bucket[$key] = array_sum($values); } return $fnf_sale_units_bucket; } function fetch_item_sale_return_units($item,$sales_return) { $sale_units_bucket = array(); foreach($sales_return as $row) { $sale_details = json_decode($row['items_details'],true); foreach($sale_details as $inner_row) { if($inner_row['item'] == $item['uid']) { $sale_item_r_qty = isset($inner_row['r_qty']) ? (float)$inner_row['r_qty'] : 0; $sale_item_r_bonus = isset($inner_row['r_bonus']) ? (float)$inner_row['r_bonus'] : 0; $sale_item_qty = $sale_item_r_qty + $sale_item_r_bonus; if($inner_row['unit'] == 'purchase'){ $sale_item_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($sale_item_qty / (float)$item['purchase_unit_equalance']); } if($inner_row['unit'] == 'sale'){ $sale_item_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($sale_item_qty / (float)$item['sale_unit_equalance']); } if($inner_row['unit'] == 'production'){ $sale_item_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($sale_item_qty / (float)$item['production_unit_equalance']); } if(!array_key_exists($inner_row['warehouse'],$sale_units_bucket)){ $sale_units_bucket[$inner_row['warehouse']] = array(); } $sale_units_bucket[$inner_row['warehouse']][] = $sale_item_qty; } } } $fnf_sale_units_bucket = array(); foreach($sale_units_bucket as $key => $values) { $fnf_sale_units_bucket[$key] = array_sum($values); } return $fnf_sale_units_bucket; } function fetch_item_expenses_deductions_units($item,$expenses_deductions) { $expenses_deductions_units_bucket = array(); foreach($expenses_deductions as $row) { if($row['item'] == $item['uid']) { $expense_units = (float)$row['qty']; if($row['unit'] == 'purchase'){ $expense_units = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($expense_units / (float)$item['purchase_unit_equalance']); } if($row['unit'] == 'sale'){ $expense_units = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($expense_units / (float)$item['sale_unit_equalance']); } if($row['unit'] == 'production'){ $expense_units = (float)$item['production_unit_equalance'] == 0 ? 0 : ($expense_units / (float)$item['production_unit_equalance']); } if(!array_key_exists($row['warehouse'],$expenses_deductions_units_bucket)){ $expenses_deductions_units_bucket[$row['warehouse']] = array(); } $expenses_deductions_units_bucket[$row['warehouse']][] = $expense_units; } } $fnf_expenses_deductions_units_bucket = array(); foreach($expenses_deductions_units_bucket as $key => $values) { $fnf_expenses_deductions_units_bucket[$key] = array_sum($values); } return $fnf_expenses_deductions_units_bucket; } function fetch_item_branch_to_branch_transfer_in_units($item,$branch_to_branch_transfer_in) { $branch_to_branch_transfer_in_units_bucket = array(); foreach($branch_to_branch_transfer_in as $row) { if($row['item'] == $item['uid']) { $branch_to_branch_transfer_in_units = (float)$row['qty']; if($row['unit'] == 'purchase'){ $branch_to_branch_transfer_in_units = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($branch_to_branch_transfer_in_units / (float)$item['purchase_unit_equalance']); } if($row['unit'] == 'sale'){ $branch_to_branch_transfer_in_units = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($branch_to_branch_transfer_in_units / (float)$item['sale_unit_equalance']); } if($row['unit'] == 'production'){ $branch_to_branch_transfer_in_units = (float)$item['production_unit_equalance'] == 0 ? 0 : ($branch_to_branch_transfer_in_units / (float)$item['production_unit_equalance']); } if(!array_key_exists($row['warehouse'],$branch_to_branch_transfer_in_units_bucket)){ $branch_to_branch_transfer_in_units_bucket[$row['warehouse']] = array(); } $branch_to_branch_transfer_in_units_bucket[$row['warehouse']][] = $branch_to_branch_transfer_in_units; } } $fnf_branch_to_branch_transfer_in_units_bucket = array(); foreach($branch_to_branch_transfer_in_units_bucket as $key => $values) { $fnf_branch_to_branch_transfer_in_units_bucket[$key] = array_sum($values); } return $fnf_branch_to_branch_transfer_in_units_bucket; } function fetch_item_branch_to_branch_transfer_out_units($item,$branch_to_branch_transfer_out) { $branch_to_branch_transfer_out_units_bucket = array(); foreach($branch_to_branch_transfer_out as $row) { if($row['item'] == $item['uid']) { $branch_to_branch_transfer_out_units = (float)$row['qty']; if($row['unit'] == 'purchase'){ $branch_to_branch_transfer_out_units = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($branch_to_branch_transfer_out_units / (float)$item['purchase_unit_equalance']); } if($row['unit'] == 'sale'){ $branch_to_branch_transfer_out_units = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($branch_to_branch_transfer_out_units / (float)$item['sale_unit_equalance']); } if($row['unit'] == 'production'){ $branch_to_branch_transfer_out_units = (float)$item['production_unit_equalance'] == 0 ? 0 : ($branch_to_branch_transfer_out_units / (float)$item['production_unit_equalance']); } if(!array_key_exists($row['warehouse'],$branch_to_branch_transfer_out_units_bucket)){ $branch_to_branch_transfer_out_units_bucket[$row['warehouse']] = array(); } $branch_to_branch_transfer_out_units_bucket[$row['warehouse']][] = $branch_to_branch_transfer_out_units; } } $fnf_branch_to_branch_transfer_out_units_bucket = array(); foreach($branch_to_branch_transfer_out_units_bucket as $key => $values) { $fnf_branch_to_branch_transfer_out_units_bucket[$key] = array_sum($values); } return $fnf_branch_to_branch_transfer_out_units_bucket; } function fetch_item_damage_units($item,$damage) { $damage_units_bucket = array(); foreach($damage as $row) { if($row['item'] == $item['uid']) { $damage_units = (float)$row['qty']; if($row['unit'] == 'purchase'){ $damage_units = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($damage_units / (float)$item['purchase_unit_equalance']); } if($row['unit'] == 'sale'){ $damage_units = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($damage_units / (float)$item['sale_unit_equalance']); } if($row['unit'] == 'production'){ $damage_units = (float)$item['production_unit_equalance'] == 0 ? 0 : ($damage_units / (float)$item['production_unit_equalance']); } if(!array_key_exists($row['warehouse'],$damage_units_bucket)){ $damage_units_bucket[$row['warehouse']] = array(); } $damage_units_bucket[$row['warehouse']][] = $damage_units; } } $fnf_damage_units_bucket = array(); foreach($damage_units_bucket as $key => $values) { $fnf_damage_units_bucket[$key] = array_sum($values); } return $fnf_damage_units_bucket; } function fetch_item_transfer_units($item,$transfer) { $transfer_in_units_bucket = array(); $transfer_out_units_bucket = array(); foreach($transfer as $row) { if($row['item'] == $item['uid']) { $transfer_qty = (float)$row['qty']; if($row['unit'] == 'purchase'){ $transfer_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($transfer_qty / (float)$item['purchase_unit_equalance']); } if($row['unit'] == 'sale'){ $transfer_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($transfer_qty / (float)$item['sale_unit_equalance']); } if($row['unit'] == 'production'){ $transfer_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($transfer_qty / (float)$item['production_unit_equalance']); } if(!array_key_exists($row['receiving_warehouse'],$transfer_in_units_bucket)){ $transfer_in_units_bucket[$row['receiving_warehouse']] = array(); } $transfer_in_units_bucket[$row['receiving_warehouse']][] = $transfer_qty; if(!array_key_exists($row['sending_warehouse'],$transfer_out_units_bucket)){ $transfer_out_units_bucket[$row['sending_warehouse']] = array(); } $transfer_out_units_bucket[$row['sending_warehouse']][] = $transfer_qty; } } $fnf_transfer_in_units_bucket = array(); foreach($transfer_in_units_bucket as $key => $values) { $fnf_transfer_in_units_bucket[$key] = array_sum($values); } $fnf_transfer_out_units_bucket = array(); foreach($transfer_out_units_bucket as $key => $values) { $fnf_transfer_out_units_bucket[$key] = array_sum($values); } return array('in' => $fnf_transfer_in_units_bucket, 'out' => $fnf_transfer_out_units_bucket); } function fetch_item_branch_transfer_units($item,$branch_transfer_in,$branch_transfer_out) { $transfer_in_units_bucket = array(); $transfer_out_units_bucket = array(); foreach($branch_transfer_in as $row) { if($row['item'] == $item['uid']) { $transfer_qty = (float)$row['qty']; if($row['unit'] == 'purchase'){ $transfer_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($transfer_qty / (float)$item['purchase_unit_equalance']); } if($row['unit'] == 'sale'){ $transfer_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($transfer_qty / (float)$item['sale_unit_equalance']); } if($row['unit'] == 'production'){ $transfer_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($transfer_qty / (float)$item['production_unit_equalance']); } if(!array_key_exists($row['to_warehouse'],$transfer_in_units_bucket)){ $transfer_in_units_bucket[$row['to_warehouse']] = array(); } $transfer_in_units_bucket[$row['to_warehouse']][] = $transfer_qty; } } foreach($branch_transfer_out as $row) { if($row['item'] == $item['uid']) { $transfer_qty = (float)$row['qty']; if($row['unit'] == 'purchase'){ $transfer_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($transfer_qty / (float)$item['purchase_unit_equalance']); } if($row['unit'] == 'sale'){ $transfer_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($transfer_qty / (float)$item['sale_unit_equalance']); } if($row['unit'] == 'production'){ $transfer_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($transfer_qty / (float)$item['production_unit_equalance']); } if(!array_key_exists($row['warehouse'],$transfer_out_units_bucket)){ $transfer_out_units_bucket[$row['warehouse']] = array(); } $transfer_out_units_bucket[$row['warehouse']][] = $transfer_qty; } } $fnf_transfer_in_units_bucket = array(); foreach($transfer_in_units_bucket as $key => $values) { $fnf_transfer_in_units_bucket[$key] = array_sum($values); } $fnf_transfer_out_units_bucket = array(); foreach($transfer_out_units_bucket as $key => $values) { $fnf_transfer_out_units_bucket[$key] = array_sum($values); } return array('in' => $fnf_transfer_in_units_bucket, 'out' => $fnf_transfer_out_units_bucket); } function fetch_item_branch_transfer_units_pharmaone($item,$branch_transfer_in,$branch_transfer_out) { $transfer_in_units_bucket = array(); $transfer_out_units_bucket = array(); foreach($branch_transfer_in as $btin) { $item_details = json_decode($btin['items'],true); foreach($item_details as $row) { if($row['item'] == $item['uid']) { $bonus = isset($row['bonus']) ? $row['bonus'] : 0; $transfer_qty = (float)$row['qty'] + $bonus; if($row['unit'] == 'purchase'){ $transfer_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($transfer_qty / (float)$item['purchase_unit_equalance']); } if($row['unit'] == 'sale'){ $transfer_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($transfer_qty / (float)$item['sale_unit_equalance']); } if($row['unit'] == 'production'){ $transfer_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($transfer_qty / (float)$item['production_unit_equalance']); } if(!array_key_exists($row['warehouse'],$transfer_in_units_bucket)){ $transfer_in_units_bucket[$row['warehouse']] = array(); } $transfer_in_units_bucket[$row['warehouse']][] = $transfer_qty; } } } foreach($branch_transfer_out as $btout) { $item_details_o = json_decode($btout['items'],true); foreach($item_details_o as $row) { if($row['item'] == $item['uid']) { $transfer_qt = (float)$row['qty']; $transfer_qty_bonus = (float)$row['bonus']; $transfer_qty = $transfer_qt + $transfer_qty_bonus; if($row['unit'] == 'purchase'){ $transfer_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($transfer_qty / (float)$item['purchase_unit_equalance']); } if($row['unit'] == 'sale'){ $transfer_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($transfer_qty / (float)$item['sale_unit_equalance']); } if($row['unit'] == 'production'){ $transfer_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($transfer_qty / (float)$item['production_unit_equalance']); } if(!array_key_exists($row['warehouse'],$transfer_out_units_bucket)){ $transfer_out_units_bucket[$row['warehouse']] = array(); } $transfer_out_units_bucket[$row['warehouse']][] = $transfer_qty; } } } $fnf_transfer_in_units_bucket = array(); foreach($transfer_in_units_bucket as $key => $values) { $fnf_transfer_in_units_bucket[$key] = array_sum($values); } $fnf_transfer_out_units_bucket = array(); foreach($transfer_out_units_bucket as $key => $values) { $fnf_transfer_out_units_bucket[$key] = array_sum($values); } return array('in' => $fnf_transfer_in_units_bucket, 'out' => $fnf_transfer_out_units_bucket); } function fetch_item_bundle_units($item,$bundle_stock_in,$bundle_stock_out) { $bundle_stock_in_units_bucket = array(); $bundle_stock_out_units_bucket = array(); foreach($bundle_stock_in as $row) { if($row['item'] == $item['uid']) { $stock_in_qty = isset($row['bundle_stock_in']) ? $row['bundle_stock_in'] : 0; if(!array_key_exists($row['warehouse'],$bundle_stock_in_units_bucket)){ $bundle_stock_in_units_bucket[$row['warehouse']] = array(); } $bundle_stock_in_units_bucket[$row['warehouse']][] = $stock_in_qty; } } foreach($bundle_stock_out as $row) { if($row['item'] == $item['uid']) { $stock_out_qty = isset($row['bundle_stock_out']) ? $row['bundle_stock_out'] : 0; if(!array_key_exists($row['warehouse'],$bundle_stock_out_units_bucket)){ $bundle_stock_out_units_bucket[$row['warehouse']] = array(); } $bundle_stock_out_units_bucket[$row['warehouse']][] = $stock_out_qty; } } $fnf_bundle_stock_in_units_bucket = array(); foreach($bundle_stock_in_units_bucket as $key => $values) { $fnf_bundle_stock_in_units_bucket[$key] = array_sum($values); } $fnf_bundle_stock_out_units_bucket = array(); foreach($bundle_stock_out_units_bucket as $key => $values) { $fnf_bundle_stock_out_units_bucket[$key] = array_sum($values); } return array('in' => $fnf_bundle_stock_in_units_bucket, 'out' => $fnf_bundle_stock_out_units_bucket); } function fetch_item_toop_units($item,$toop_stock_in,$toop_stock_out) { $toop_stock_in_units_bucket = array(); $toop_stock_out_units_bucket = array(); foreach($toop_stock_in as $row) { if($row['item'] == $item['uid']) { $stock_in_qty = isset($row['toop_stock_in']) ? $row['toop_stock_in'] : 0; if(!array_key_exists($row['warehouse'],$toop_stock_in_units_bucket)){ $toop_stock_in_units_bucket[$row['warehouse']] = array(); } $toop_stock_in_units_bucket[$row['warehouse']][] = $stock_in_qty; } } foreach($toop_stock_out as $row) { if($row['item'] == $item['uid']) { $stock_out_qty = isset($row['toop_stock_out']) ? $row['toop_stock_out'] : 0; if(!array_key_exists($row['warehouse'],$toop_stock_out_units_bucket)){ $toop_stock_out_units_bucket[$row['warehouse']] = array(); } $toop_stock_out_units_bucket[$row['warehouse']][] = $stock_out_qty; } } $fnf_toop_stock_in_units_bucket = array(); foreach($toop_stock_in_units_bucket as $key => $values) { $fnf_toop_stock_in_units_bucket[$key] = array_sum($values); } $fnf_toop_stock_out_units_bucket = array(); foreach($toop_stock_out_units_bucket as $key => $values) { $fnf_toop_stock_out_units_bucket[$key] = array_sum($values); } return array('in' => $fnf_toop_stock_in_units_bucket, 'out' => $fnf_toop_stock_out_units_bucket); } function get_item_avg_cost($item) { $item_data = fetch_table_where('items','uid',$item,true); $item_purchases = DB::table('purchases')->where('status','passed')->where('items_uid','like','%-++-'.$item.'-++-%')->get(); $item_purchases = json_decode(json_encode($item_purchases),true); $item_production = DB::table('production')->where('item',$item)->get(); $item_production = json_decode(json_encode($item_production),true); return process_item_batch_wise_avg_cost($row['items']); } function process_item_batch_wise_avg_cost($item) { $branch_id = active_branch_id(); $item_currency = $item['currency']; $item_currency_usd_equalance = (float)$item['currency_usd_equalance']; $batch_currency = $item['currency']; $batch_currency_equalance = (float)$item['currency_usd_equalance']; $item_cost = 0; $items_batch = std_obj_to_array(DB::table('batch_wise_stock')->where('branch',$branch_id)->where('item',$item['uid'])->select('batch')->distinct()->get()); $item_ava_total = array(); $item_cost_total = array(); $item_amount_total = array(); foreach($items_batch as $_batch) { $item_cost = 0; $item_stock_in = DB::table('batch_wise_stock')->where('branch',$branch_id)->where('item',$item['uid'])->where('batch',$_batch['batch'])->where('status','passed')->sum('stock_in'); $item_bonus_in = DB::table('batch_wise_stock')->where('branch',$branch_id)->where('item',$item['uid'])->where('batch',$_batch['batch'])->where('status','passed')->sum('bonus_in'); $item_stock_out = DB::table('batch_wise_stock')->where('branch',$branch_id)->where('item',$item['uid'])->where('batch',$_batch['batch'])->where('status','passed')->sum('stock_out'); $item_bonus_out = DB::table('batch_wise_stock')->where('branch',$branch_id)->where('item',$item['uid'])->where('batch',$_batch['batch'])->where('status','passed')->sum('bonus_out'); $item_stock_ava = ( (float)$item_stock_in + (float)$item_bonus_in ) - ( (float)$item_stock_out + (float)$item_bonus_out ); $item_batch_cost = std_obj_to_array(DB::table('batch_wise_stock') ->where('branch',$branch_id) ->where('item',$item['uid']) ->where('batch',$_batch['batch']) ->where('module','!=','sales') ->where('module','!=','damage') ->where('module','!=','transfer_out') ->where('module','!=','sales_return') ->where('module','!=','b_to_b_transfer_out') ->where('module','!=','production_out') ->whereNotNull('real_cost') ->orderBy('module_created_at','desc') ->orderBy('id','desc') ->get()->first()); if(!empty($item_batch_cost)){ $item_cost = (float)$item_batch_cost['real_cost']; $batch_currency = $item_batch_cost['currency']; $batch_currency_equalance = $item_batch_cost['currency_usd_equalance']; } if(!empty($item_batch_cost['unit'])) { if($item_batch_cost['unit'] == 'purchase'){ $item_cost = $item_cost * (float)$item['purchase_unit_equalance']; } if($item_batch_cost['unit'] == 'sale'){ $item_cost = $item_cost * (float)$item['sale_unit_equalance']; } if($item_batch_cost['unit'] == 'production'){ $item_cost = $item_cost * (float)$item['production_unit_equalance']; } } if($batch_currency == $item_currency) { $item_cost = $item_cost; } else { $item_cost = amount_conversion($item_cost, $batch_currency_equalance, $item_currency_usd_equalance); } if($item_stock_ava > 0) { $item_ava_total[] = $item_stock_ava; $item_cost_total[] = $item_cost; $item_amount_total[] = $item_cost * $item_stock_ava; } } $total_amount = array_sum($item_amount_total); $total_qty = array_sum($item_ava_total); if($total_qty == 0){$total_qty = 1;} $avg_cost = $total_amount / $total_qty; return $avg_cost; } function process_get_item_avg_cost($item,$purchases,$production) { $item_costs_bucket = array(); $purchases_count = count($purchases); $production_count = count($production); $total_items_counts = $purchases_count + $production_count; $item_currency = $item['currency']; $item_currency_usd_equalance = (float)$item['currency_usd_equalance']; foreach($purchases as $row) { if($row['status'] != 'passed'){ continue; } $purchase_details = json_decode($row['items'],true); $purchase_currency = $row['currency']; $purchase_currency_usd_equalance = $row['currency_usd_equalance']; foreach($purchase_details as $inner_row) { if($inner_row['item'] == $item['uid']) { $purchase_cost = (float)$inner_row['real_cost']; if($inner_row['unit'] == 'purchase'){ $purchase_cost = $purchase_cost * (float)$item['purchase_unit_equalance']; } if($inner_row['unit'] == 'sale'){ $purchase_cost = $purchase_cost * (float)$item['sale_unit_equalance']; } if($inner_row['unit'] == 'production'){ $purchase_cost = $purchase_cost * (float)$item['production_unit_equalance']; } if($purchase_currency == $item_currency) { $item_costs_bucket[] = $purchase_cost; } else { $item_costs_bucket[] = amount_conversion($purchase_cost, $purchase_currency_usd_equalance, $item_currency_usd_equalance); } } } } foreach($production as $row) { if($row['item'] == $item['uid']) { $production_currency = $row['currency']; $production_currency_usd_equalance = $row['currency_usd_equalance']; $production_cost = (float)$row['cost']; if($row['unit'] == 'purchase'){ $production_cost = $production_cost * (float)$item['purchase_unit_equalance']; } if($row['unit'] == 'sale'){ $production_cost = $production_cost * (float)$item['sale_unit_equalance']; } if($row['unit'] == 'production'){ $production_cost = $production_cost * (float)$item['production_unit_equalance']; } if($production_currency == $item_currency) { $item_costs_bucket[] = $production_cost; } else { $item_costs_bucket[] = amount_conversion($production_cost, $production_currency_usd_equalance, $item_currency_usd_equalance); } } } if(count($item_costs_bucket) == 0) { $item_costs_bucket[] = $item['cost']; } return array_sum($item_costs_bucket) / count($item_costs_bucket); } function get_item_last_cost($item) { $item_data = fetch_table_where('items','uid',$item,true); $item_purchases = DB::table('purchases')->where('status','passed')->where('items_uid','like','%-++-'.$item.'-++-%')->get(); $item_purchases = json_decode(json_encode($item_purchases),true); $item_production = DB::table('production')->where('item',$item)->get(); $item_production = json_decode(json_encode($item_production),true); return process_get_item_last_cost($item_data,$item_purchases,$item_production); } function process_get_item_last_cost($item,$purchases,$production,$item_branch_to_branch_transfer_in) { $item_costs_bucket = array(); $item_costs_bucket[] = array('date' => $item['created_at'], 'cost' => $item['cost']); $item_currency = $item['currency']; $item_currency_usd_equalance = (float)$item['currency_usd_equalance']; foreach($purchases as $row) { if($row['status'] != 'passed'){ continue; } $purchase_details = json_decode($row['items'],true); $purchase_currency = $row['currency']; $purchase_currency_usd_equalance = $row['currency_usd_equalance']; foreach($purchase_details as $inner_row) { if($inner_row['item'] == $item['uid']) { $purchase_cost = (float)$inner_row['real_cost']; if($inner_row['unit'] == 'purchase'){ $purchase_cost = $purchase_cost * (float)$item['purchase_unit_equalance']; } if($inner_row['unit'] == 'sale'){ $purchase_cost = $purchase_cost * (float)$item['sale_unit_equalance']; } if($inner_row['unit'] == 'production'){ $purchase_cost = $purchase_cost * (float)$item['production_unit_equalance']; } if($purchase_currency != $item_currency) { $purchase_cost = amount_conversion($purchase_cost, $purchase_currency_usd_equalance, $item_currency_usd_equalance); } $item_costs_bucket[] = array('date' => $row['created_at'], 'cost' => $purchase_cost); } } } foreach($production as $row) { if($row['item'] == $item['uid']) { $production_currency = $row['currency']; $production_currency_usd_equalance = $row['currency_usd_equalance']; $production_cost = (float)$row['real_cost']; if($row['unit'] == 'purchase'){ $production_cost = $production_cost * (float)$item['purchase_unit_equalance']; } if($row['unit'] == 'sale'){ $production_cost = $production_cost * (float)$item['sale_unit_equalance']; } if($row['unit'] == 'production'){ $production_cost = $production_cost * (float)$item['production_unit_equalance']; } if($production_currency != $item_currency) { $production_cost = amount_conversion($production_cost, $production_currency_usd_equalance, $item_currency_usd_equalance); } $item_costs_bucket[] = array('date' => $row['created_at'], 'cost' => $production_cost); } } foreach($item_branch_to_branch_transfer_in as $row) { if($row['item'] == $item['uid']) { $b_t_b_in_currency = $row['currency']; $b_t_b_in_currency_usd_equalance = $row['currency_usd_equalance']; $b_to_b_cost = (float)$row['cost']; if($row['unit'] == 'purchase'){ $b_to_b_cost = $b_to_b_cost * (float)$item['purchase_unit_equalance']; } if($row['unit'] == 'sale'){ $b_to_b_cost = $b_to_b_cost * (float)$item['sale_unit_equalance']; } if($row['unit'] == 'production'){ $b_to_b_cost = $b_to_b_cost * (float)$item['production_unit_equalance']; } if($b_t_b_in_currency != $item_currency) { $b_to_b_cost = amount_conversion($b_to_b_cost, $b_t_b_in_currency_usd_equalance, $item_currency_usd_equalance); } $item_costs_bucket[] = array('date' => $row['created_at'], 'cost' => $b_to_b_cost); } } $item_costs_bucket = sort_data_date_wise($item_costs_bucket,'date'); $last_cost = end($item_costs_bucket); return $last_cost['cost']; } function get_item_last_profit($item) { $item_data = fetch_table_where('items','uid',$item,true); $item_purchases = DB::table('purchases')->where('status','passed')->where('items_uid','like','%-++-'.$item.'-++-%')->get(); $item_purchases = json_decode(json_encode($item_purchases),true); $item_production = DB::table('production')->where('item',$item)->get(); $item_production = json_decode(json_encode($item_production),true); return process_get_item_last_profit($item_data,$item_purchases,$item_production); } function process_get_item_last_profit($item,$purchases,$production,$branch_to_branch_transfer_in) { $item_profits_bucket = array(); $item_profit = (float)$item['sale_price'] - (float)$item['cost']; if($item_profit < 0){ $item_profit = 0; } $item_profits_bucket[] = array('date' => $item['created_at'], 'profit' => $item_profit); $item_currency = $item['currency']; $item_currency_usd_equalance = (float)$item['currency_usd_equalance']; foreach($purchases as $row) { if($row['status'] != 'passed'){ continue; } $purchase_details = json_decode($row['items'],true); $purchase_currency = $row['currency']; $purchase_currency_usd_equalance = $row['currency_usd_equalance']; foreach($purchase_details as $inner_row) { if($inner_row['item'] == $item['uid']) { $purchase_profit = (float)$inner_row['profit']; if($inner_row['unit'] == 'purchase'){ $purchase_profit = $purchase_profit * (float)$item['purchase_unit_equalance']; } if($inner_row['unit'] == 'sale'){ $purchase_profit = $purchase_profit * (float)$item['sale_unit_equalance']; } if($inner_row['unit'] == 'production'){ $purchase_profit = $purchase_profit * (float)$item['production_unit_equalance']; } if($purchase_currency != $item_currency) { $purchase_profit = amount_conversion($purchase_profit, $purchase_currency_usd_equalance, $item_currency_usd_equalance); } $item_profits_bucket[] = array('date' => $row['created_at'], 'profit' => $purchase_profit); } } } foreach($production as $row) { if($row['item'] == $item['uid']) { $production_currency = $row['currency']; $production_currency_usd_equalance = $row['currency_usd_equalance']; $production_profit = (float)$row['profit']; if($row['unit'] == 'purchase'){ $production_profit = $production_profit * (float)$item['purchase_unit_equalance']; } if($row['unit'] == 'sale'){ $production_profit = $production_profit * (float)$item['sale_unit_equalance']; } if($row['unit'] == 'production'){ $production_profit = $production_profit * (float)$item['production_unit_equalance']; } if($production_currency != $item_currency) { $production_profit = amount_conversion($production_profit, $production_currency_usd_equalance, $item_currency_usd_equalance); } $item_profits_bucket[] = array('date' => $row['created_at'], 'profit' => $production_profit); } } foreach($branch_to_branch_transfer_in as $row) { if($row['item'] == $item['uid']) { $b_to_b_transfer_in_currency = $row['currency']; $b_to_b_transfer_in_currency_usd_equalance = $row['currency_usd_equalance']; $b_to_b_transfer_in_profit = (float)$row['profit']; if($row['unit'] == 'purchase'){ $b_to_b_transfer_in_profit = $b_to_b_transfer_in_profit * (float)$item['purchase_unit_equalance']; } if($row['unit'] == 'sale'){ $b_to_b_transfer_in_profit = $b_to_b_transfer_in_profit * (float)$item['sale_unit_equalance']; } if($row['unit'] == 'production'){ $b_to_b_transfer_in_profit = $b_to_b_transfer_in_profit * (float)$item['production_unit_equalance']; } if($b_to_b_transfer_in_currency != $item_currency) { $b_to_b_transfer_in_profit = amount_conversion($b_to_b_transfer_in_profit, $b_to_b_transfer_in_currency_usd_equalance, $item_currency_usd_equalance); } $item_profits_bucket[] = array('date' => $row['created_at'], 'profit' => $b_to_b_transfer_in_profit); } } $item_profits_bucket = sort_data_date_wise($item_profits_bucket,'date'); $last_profit = end($item_profits_bucket); return $last_profit['profit']; } function get_item_stock_in_units($item) { $item_data = fetch_table_where('items','uid',$item,true); $item_purchases = DB::table('purchases')->where('status','passed')->where('items_uid','like','%-++-'.$item.'-++-%')->get(); $item_purchases = json_decode(json_encode($item_purchases),true); $item_production = array(); if($item_data['type'] == 'sales') { $item_production = DB::table('production')->where('item',$item)->get(); $item_production = json_decode(json_encode($item_production),true); } return process_get_item_stock_in_units($item_data,$item_purchases,$item_production); } function process_get_item_stock_in_units($item,$purchases,$production,$warehouse_separation=FALSE) { $stock_in_bucket = array(); $stock_in_warehouse_bucket = array(); if($warehouse_separation === TRUE) { if(!array_key_exists($item['warehouse'],$stock_in_warehouse_bucket)){ $stock_in_warehouse_bucket[$item['warehouse']] = array(); } $stock_in_warehouse_bucket[$item['warehouse']][] = (float)$item['opening_stock']; } else { $stock_in_bucket[] = (float)$item['opening_stock']; } foreach($purchases as $row) { if($row['status'] != 'passed'){ continue; } $purchase_details = json_decode($row['items'],true); foreach($purchase_details as $inner_row) { if($inner_row['item'] == $item['uid']) { $purchase_item_qty = (float)$inner_row['qty']; if($inner_row['unit'] == 'purchase'){ $purchase_item_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($purchase_item_qty / (float)$item['purchase_unit_equalance']); } if($inner_row['unit'] == 'sale'){ $purchase_item_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($purchase_item_qty / (float)$item['sale_unit_equalance']); } if($inner_row['unit'] == 'production'){ $purchase_item_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($purchase_item_qty / (float)$item['production_unit_equalance']); } if($warehouse_separation === TRUE) { if(!array_key_exists($inner_row['warehouse'],$stock_in_warehouse_bucket)){ $stock_in_warehouse_bucket[$inner_row['warehouse']] = array(); } $stock_in_warehouse_bucket[$inner_row['warehouse']][] = $purchase_item_qty; } else { $stock_in_bucket[] = $purchase_item_qty; } } } } if($item['type'] == 'sales') { foreach($production as $row) { if($row['item'] == $item['uid']) { $production_item_qty = (float)$row['qty']; if($row['unit'] == 'purchase'){ $production_item_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($production_item_qty / (float)$item['purchase_unit_equalance']); } if($row['unit'] == 'sale'){ $production_item_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($production_item_qty / (float)$item['sale_unit_equalance']); } if($row['unit'] == 'production'){ $production_item_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($production_item_qty / (float)$item['production_unit_equalance']); } if($warehouse_separation === TRUE) { if(!array_key_exists($row['warehouse'],$stock_in_warehouse_bucket)){ $stock_in_warehouse_bucket[$row['warehouse']] = array(); } $stock_in_warehouse_bucket[$row['warehouse']][] = $production_item_qty; } else { $stock_in_bucket[] = $production_item_qty; } } } } if($warehouse_separation === TRUE) { $fnf_warehouse_stock_in_bucket = array(); foreach($stock_in_warehouse_bucket as $key => $values) { $fnf_warehouse_stock_in_bucket[$key] = array_sum($values); } return $fnf_warehouse_stock_in_bucket; } else { return array_sum($stock_in_bucket); } } function get_item_stock_out_units($item) { $item_data = fetch_table_where('items','uid',$item,true); $item_production = array(); if($item_data['type'] == 'raw') { $item_production = DB::table('production')->where('raw_items','like','%-++-'.$item.'-++-%')->get(); $item_production = json_decode(json_encode($item_production),true); } $item_sales = DB::table('sales')->where('sale_items','like','%-++-'.$item.'-++-%')->get(); $item_sales = json_decode(json_encode($item_sales),true); $item_damage = DB::table('damage')->where('item',$item)->get(); $item_damage = json_decode(json_encode($item_damage),true); return process_get_item_stock_out_units($item_data,$item_production,$item_sales,$item_damage); } function process_get_item_stock_out_units($item,$production,$sales,$damage,$warehouse_separation=FALSE) { $used_stock_bucket = array(); $used_stock_warehouse_bucket = array(); if($item['type'] == 'raw') { foreach($production as $row) { $raw_items = json_decode($row['raw_details'],true); foreach($raw_items as $raw_item) { if($raw_item['item'] == $item['uid']) { $production_item_qty = (float)$raw_item['used_qty']; if($raw_item['unit'] == 'purchase'){ $production_item_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($production_item_qty / (float)$item['purchase_unit_equalance']); } if($raw_item['unit'] == 'sale'){ $production_item_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($production_item_qty / (float)$item['sale_unit_equalance']); } if($raw_item['unit'] == 'production'){ $production_item_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($production_item_qty / (float)$item['production_unit_equalance']); } if($warehouse_separation === TRUE) { if(!array_key_exists($raw_item['warehouse'],$used_stock_warehouse_bucket)){ $used_stock_warehouse_bucket[$raw_item['warehouse']] = array(); } $used_stock_warehouse_bucket[$raw_item['warehouse']][] = $production_item_qty; } else { $used_stock_bucket[] = $production_item_qty; } } } } } foreach($sales as $row) { $sale_details = json_decode($row['items_details'],true); foreach($sale_details as $inner_row) { if($inner_row['item'] == $item['uid']) { $sale_item_qty = (float)$inner_row['qty']; if($inner_row['unit'] == 'purchase'){ $sale_item_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($sale_item_qty / (float)$item['purchase_unit_equalance']); } if($inner_row['unit'] == 'sale'){ $sale_item_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($sale_item_qty / (float)$item['sale_unit_equalance']); } if($inner_row['unit'] == 'production'){ $sale_item_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($sale_item_qty / (float)$item['production_unit_equalance']); } if($warehouse_separation === TRUE) { if(!array_key_exists($inner_row['warehouse'],$used_stock_warehouse_bucket)){ $used_stock_warehouse_bucket[$inner_row['warehouse']] = array(); } $used_stock_warehouse_bucket[$inner_row['warehouse']][] = $sale_item_qty; } else { $used_stock_bucket[] = $sale_item_qty; } } } } if($warehouse_separation === TRUE) { $fnf_warehouse_stock_out_bucket = array(); foreach($used_stock_warehouse_bucket as $key => $values) { $fnf_warehouse_stock_out_bucket[$key] = array_sum($values); } return $fnf_warehouse_stock_out_bucket; } else { return array_sum($used_stock_bucket); } } function get_item_damage_units($item) { $item_data = fetch_table_where('items','uid',$item,true); $item_damage = DB::table('damage')->where('item',$item)->get(); $item_damage = json_decode(json_encode($item_damage),true); return process_get_item_stock_out_units($item_data,$item_damage); } function process_get_item_damage_units($item,$damage,$warehouse_separation=FALSE) { $damage_stock_bucket = array(); $damage_stock_warehouse_bucket = array(); foreach($damage as $row) { if($row['item'] == $item['uid']) { $damage_units = (float)$row['qty']; if($row['unit'] == 'purchase'){ $damage_units = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($damage_units / (float)$item['purchase_unit_equalance']); } if($row['unit'] == 'sale'){ $damage_units = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($damage_units / (float)$item['sale_unit_equalance']); } if($row['unit'] == 'production'){ $damage_units = (float)$item['production_unit_equalance'] == 0 ? 0 : ($damage_units / (float)$item['production_unit_equalance']); } if($warehouse_separation === TRUE) { if(!array_key_exists($row['warehouse'],$damage_stock_warehouse_bucket)){ $damage_stock_warehouse_bucket[$row['warehouse']] = array(); } $damage_stock_warehouse_bucket[$row['warehouse']][] = $damage_units; } else { $damage_stock_bucket[] = $damage_units; } } } if($warehouse_separation === TRUE) { $fnf_warehouse_stock_out_bucket = array(); foreach($damage_stock_warehouse_bucket as $key => $values) { $fnf_warehouse_stock_out_bucket[$key] = array_sum($values); } return $fnf_warehouse_stock_out_bucket; } else { return array_sum($damage_stock_bucket); } } function get_item_branch_transfer_in_units($item) { $item_data = fetch_table_where('items','uid',$item,true); $branch_transfer_in = DB::table('branch_transfer_in')->where('item',$item)->get(); $branch_transfer_in = json_decode(json_encode($branch_transfer_in),true); return process_get_item_branch_transfer_in_units($item_data,$branch_transfer_in); } function process_get_item_branch_transfer_in_units($item,$branch_transfer_in,$warehouse_separation=FALSE) { $transfer_in_units_bucket = array(); $transfer_in_units_warehouse_bucket = array(); foreach($branch_transfer_in as $row) { if($row['item'] == $item['uid']) { $transfer_in_qty = (float)$row['qty']; if($row['unit'] == 'purchase'){ $transfer_in_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($transfer_in_qty / (float)$item['purchase_unit_equalance']); } if($row['unit'] == 'sale'){ $transfer_in_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($transfer_in_qty / (float)$item['sale_unit_equalance']); } if($row['unit'] == 'production'){ $transfer_in_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($transfer_in_qty / (float)$item['production_unit_equalance']); } if($warehouse_separation === TRUE) { if(!array_key_exists($row['to_warehouse'],$transfer_in_units_warehouse_bucket)){ $transfer_in_units_warehouse_bucket[$row['to_warehouse']] = array(); } $transfer_in_units_warehouse_bucket[$row['to_warehouse']][] = $transfer_in_qty; } else { $transfer_in_units_bucket[] = $transfer_in_qty; } } } if($warehouse_separation === TRUE) { $fnf_warehouse_transfer_in_units_bucket = array(); foreach($transfer_in_units_warehouse_bucket as $key => $values) { $fnf_warehouse_transfer_in_units_bucket[$key] = array_sum($values); } return $fnf_warehouse_transfer_in_units_bucket; } else { return array_sum($transfer_in_units_bucket); } } function get_item_branch_transfer_out_units($item) { $item_data = fetch_table_where('items','uid',$item,true); $branch_transfer_out = DB::table('branch_transfer_out')->where('item',$item)->get(); $branch_transfer_out = json_decode(json_encode($branch_transfer_out),true); return process_get_item_branch_transfer_out_units($item_data,$branch_transfer_out); } function process_get_item_branch_transfer_out_units($item,$branch_transfer_out,$warehouse_separation=FALSE) { $transfer_out_units_bucket = array(); $transfer_out_units_warehouse_bucket = array(); foreach($branch_transfer_out as $row) { if($row['item'] == $item['uid']) { $transfer_out_qty = (float)$row['qty']; if($row['unit'] == 'purchase'){ $transfer_out_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($transfer_out_qty / (float)$item['purchase_unit_equalance']); } if($row['unit'] == 'sale'){ $transfer_out_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($transfer_out_qty / (float)$item['sale_unit_equalance']); } if($row['unit'] == 'production'){ $transfer_out_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($transfer_out_qty / (float)$item['production_unit_equalance']); } if($warehouse_separation === TRUE) { if(!array_key_exists($row['warehouse'],$transfer_out_units_warehouse_bucket)){ $transfer_out_units_warehouse_bucket[$row['warehouse']] = array(); } $transfer_out_units_warehouse_bucket[$row['warehouse']][] = $transfer_out_qty; } else { $transfer_out_units_bucket[] = $transfer_out_qty; } } } if($warehouse_separation === TRUE) { $fnf_warehouse_transfer_out_units_bucket = array(); foreach($transfer_out_units_warehouse_bucket as $key => $values) { $fnf_warehouse_transfer_out_units_bucket[$key] = array_sum($values); } return $fnf_warehouse_transfer_out_units_bucket; } else { return array_sum($transfer_out_units_bucket); } } function get_item_avail_units($item) { $item_data = fetch_table_where('items','uid',$item,true); $item_purchases = DB::table('purchases')->where('status','passed')->where('items_uid','like','%-++-'.$item.'-++-%')->get(); $item_purchases = json_decode(json_encode($item_purchases),true); if($item_data['type'] == 'sales') { $item_production = DB::table('production')->where('item',$item)->get(); } else { $item_production = DB::table('production')->where('raw_items','like','%-++-'.$item.'-++-%')->get(); } $item_production = json_decode(json_encode($item_production),true); $item_sales = DB::table('sales')->where('sale_items','like','%-++-'.$item.'-++-%')->get(); $item_sales = json_decode(json_encode($item_sales),true); $damage_items = DB::table('damage')->where('item',$item)->get(); $damage_items = json_decode(json_encode($damage_items),true); return process_get_item_avail_units($item_data,$item_purchases,$item_production,$item_sales,$damage_items); } function process_get_item_avail_units($item,$purchases,$production,$sales,$damage,$branch_transfer_in,$branch_transfer_out,$warehouse_separation=FALSE) { $avail_stock_warehouse_bucket = array(); $used_stock_warehouse_bucket = array(); $avail_stock_bucket = array(); $used_stock_bucket = array(); if($warehouse_separation === TRUE) { if(!array_key_exists($item['warehouse'],$avail_stock_warehouse_bucket)){ $avail_stock_warehouse_bucket[$item['warehouse']] = array(); } $avail_stock_warehouse_bucket[$item['warehouse']][] = (float)$item['opening_stock']; } else { $avail_stock_bucket[] = (float)$item['opening_stock']; } foreach($purchases as $row) { if($row['status'] != 'passed'){ continue; } $purchase_details = json_decode($row['items'],true); foreach($purchase_details as $inner_row) { if($inner_row['item'] == $item['uid']) { $purchase_item_qty = (float)$inner_row['qty']; if($inner_row['unit'] == 'purchase'){ $purchase_item_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($purchase_item_qty / (float)$item['purchase_unit_equalance']); } if($inner_row['unit'] == 'sale'){ $purchase_item_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($purchase_item_qty / (float)$item['sale_unit_equalance']); } if($inner_row['unit'] == 'production'){ $purchase_item_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($purchase_item_qty / (float)$item['production_unit_equalance']); } if($warehouse_separation === TRUE) { if(!array_key_exists($inner_row['warehouse'],$avail_stock_warehouse_bucket)){ $avail_stock_warehouse_bucket[$inner_row['warehouse']] = array(); } $avail_stock_warehouse_bucket[$inner_row['warehouse']][] = $purchase_item_qty; } else { $avail_stock_bucket[] = $purchase_item_qty; } } } } foreach($production as $row) { if($item['type'] == 'sales') { if($row['item'] == $item['uid']) { $production_item_qty = (float)$row['qty']; if($row['unit'] == 'purchase'){ $production_item_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($production_item_qty / (float)$item['purchase_unit_equalance']); } if($row['unit'] == 'sale'){ $production_item_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($production_item_qty / (float)$item['sale_unit_equalance']); } if($row['unit'] == 'production'){ $production_item_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($production_item_qty / (float)$item['production_unit_equalance']); } if($warehouse_separation === TRUE) { if(!array_key_exists($row['warehouse'],$avail_stock_warehouse_bucket)){ $avail_stock_warehouse_bucket[$row['warehouse']] = array(); } $avail_stock_warehouse_bucket[$row['warehouse']][] = $production_item_qty; } else { $avail_stock_bucket[] = $production_item_qty; } } } else { $raw_items = json_decode($row['raw_details'],true); foreach($raw_items as $raw_item) { if($raw_item['item'] == $item['uid']) { $production_raw_item_qty = (float)$raw_item['used_qty']; if($raw_item['unit'] == 'purchase'){ $production_raw_item_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($production_raw_item_qty / (float)$item['purchase_unit_equalance']); } if($raw_item['unit'] == 'sale'){ $production_raw_item_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($production_raw_item_qty / (float)$item['sale_unit_equalance']); } if($raw_item['unit'] == 'production'){ $production_raw_item_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($production_raw_item_qty / (float)$item['production_unit_equalance']); } if($warehouse_separation === TRUE) { if(!array_key_exists($raw_item['warehouse'],$used_stock_warehouse_bucket)){ $used_stock_warehouse_bucket[$raw_item['warehouse']] = array(); } $used_stock_warehouse_bucket[$raw_item['warehouse']][] = $production_raw_item_qty; } else { $used_stock_bucket[] = $production_raw_item_qty; } } } } } foreach($sales as $row) { $sale_details = json_decode($row['items_details'],true); foreach($sale_details as $inner_row) { if($inner_row['item'] == $item['uid']) { $sale_item_qty = (float)$inner_row['qty']; if($inner_row['unit'] == 'purchase'){ $sale_item_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($sale_item_qty / (float)$item['purchase_unit_equalance']); } if($inner_row['unit'] == 'sale'){ $sale_item_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($sale_item_qty / (float)$item['sale_unit_equalance']); } if($inner_row['unit'] == 'production'){ $sale_item_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($sale_item_qty / (float)$item['production_unit_equalance']); } if($warehouse_separation === TRUE) { if(!array_key_exists($inner_row['warehouse'],$used_stock_warehouse_bucket)){ $used_stock_warehouse_bucket[$inner_row['warehouse']] = array(); } $used_stock_warehouse_bucket[$inner_row['warehouse']][] = $sale_item_qty; } else { $used_stock_bucket[] = $sale_item_qty; } } } } foreach($branch_transfer_in as $row) { if($row['item'] == $item['uid']) { $transferred_qty = (float)$row['qty']; if($row['unit'] == 'purchase'){ $transferred_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($transferred_qty / (float)$item['purchase_unit_equalance']); } if($row['unit'] == 'sale'){ $transferred_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($transferred_qty / (float)$item['sale_unit_equalance']); } if($row['unit'] == 'production'){ $transferred_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($transferred_qty / (float)$item['production_unit_equalance']); } if($warehouse_separation === TRUE) { if(!array_key_exists($row['to_warehouse'],$avail_stock_warehouse_bucket)){ $avail_stock_warehouse_bucket[$row['to_warehouse']] = array(); } $avail_stock_warehouse_bucket[$row['to_warehouse']][] = $transferred_qty; } else { $avail_stock_bucket[] = $transferred_qty; } } } foreach($branch_transfer_out as $row) { if($row['item'] == $item['uid']) { $transferred_qty = (float)$row['qty']; if($row['unit'] == 'purchase'){ $transferred_qty = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($transferred_qty / (float)$item['purchase_unit_equalance']); } if($row['unit'] == 'sale'){ $transferred_qty = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($transferred_qty / (float)$item['sale_unit_equalance']); } if($row['unit'] == 'production'){ $transferred_qty = (float)$item['production_unit_equalance'] == 0 ? 0 : ($transferred_qty / (float)$item['production_unit_equalance']); } if($warehouse_separation === TRUE) { if(!array_key_exists($row['warehouse'],$used_stock_warehouse_bucket)){ $used_stock_warehouse_bucket[$row['warehouse']] = array(); } $used_stock_warehouse_bucket[$row['warehouse']][] = $transferred_qty; } else { $used_stock_bucket[] = $transferred_qty; } } } foreach($damage as $row) { if($row['item'] == $item['uid']) { $damage_units = (float)$row['qty']; if($row['unit'] == 'purchase'){ $damage_units = (float)$item['purchase_unit_equalance'] == 0 ? 0 : ($damage_units / (float)$item['purchase_unit_equalance']); } if($row['unit'] == 'sale'){ $damage_units = (float)$item['sale_unit_equalance'] == 0 ? 0 : ($damage_units / (float)$item['sale_unit_equalance']); } if($row['unit'] == 'production'){ $damage_units = (float)$item['production_unit_equalance'] == 0 ? 0 : ($damage_units / (float)$item['production_unit_equalance']); } if($warehouse_separation === TRUE) { if(!array_key_exists($row['warehouse'],$used_stock_warehouse_bucket)){ $used_stock_warehouse_bucket[$row['warehouse']] = array(); } $used_stock_warehouse_bucket[$row['warehouse']][] = $damage_units; } else { $used_stock_bucket[] = $damage_units; } } } if($warehouse_separation === TRUE) { $fnf_warehouse_avail_stock_bucket = array(); foreach($avail_stock_warehouse_bucket as $key => $values) { $fn_warehouse_avail_stock_bucket = array_sum($values); $fn_warehouse_used_stock_bucket = array_key_exists($key, $used_stock_warehouse_bucket) ? array_sum($used_stock_warehouse_bucket[$key]) : 0; $fnf_warehouse_avail_stock_bucket[$key] = $fn_warehouse_avail_stock_bucket - $fn_warehouse_used_stock_bucket; } return $fnf_warehouse_avail_stock_bucket; } else { return array_sum($avail_stock_bucket) - array_sum($used_stock_bucket); } } function get_item_profit($item) { $item_data = fetch_table_where('items','uid',$item,true); $item_sales = DB::table('sales')->where('sale_items','like','%-++-'.$item.'-++-%')->get(); $item_sales = json_decode(json_encode($item_sales),true); return process_get_item_stock_out_units($item_data,$item_sales); } function process_get_item_profit($item,$sales) { $item_profits_bucket = array(); $item_currency = $item['currency']; $item_currency_usd_equalance = (float)$item['currency_usd_equalance']; foreach($sales as $row) { $sale_details = json_decode($row['items_details'],true); $sale_currency = $row['currency']; $sale_currency_usd_equalance = $row['currency_usd_equalance']; foreach($sale_details as $inner_row) { if($inner_row['item'] == $item['uid']) { $sale_item_qty = (float)$inner_row['qty']; $sale_item_profit_per_item = (float)$inner_row['profit']; $sale_item_total_profit = $sale_item_qty * $sale_item_profit_per_item; if($sale_currency == $item_currency) { $item_profits_bucket[] = $sale_item_total_profit; } else { $item_profits_bucket[] = amount_conversion($sale_item_total_profit, $sale_currency_usd_equalance, $item_currency_usd_equalance); } } } } return array_sum($item_profits_bucket); } function get_item_first_cost($item) { $item_data = fetch_table_where('items','uid',$item,true); return $item_data['cost']; } function get_items_with_stats($items) { $purchases = fetch_table_branch('purchases'); $production = fetch_table_branch('production'); $sales = fetch_table_branch('sales'); $damage = fetch_table_branch('damage'); $transfer = fetch_table_branch('transfer'); $branch_transfer_in = fetch_table_branch('branch_transfer_in'); $branch_transfer_out = fetch_table_branch('branch_transfer_out'); $items_joined_data = join_item_data($items,$purchases,$production,$sales,$damage,$transfer,$branch_transfer_in,$branch_transfer_out); $embeded_stats_items = array(); foreach($items_joined_data as $row) { $row['items']['fn_avg_cost'] = unit_based_conversion($row['items'],'purchase',process_item_batch_wise_avg_cost($row['items'])); $row['items']['fn_last_cost'] = unit_based_conversion($row['items'],'purchase',process_get_item_last_cost($row['items'],$row['purchases'],$row['production'])); $row['items']['fn_profit'] = unit_based_conversion($row['items'],'purchase',process_get_item_last_profit($row['items'],$row['purchases'],$row['production'])); $row['items']['fn_stock_in_units'] = unit_based_conversion($row['items'],'purchase',process_get_item_stock_in_units($row['items'],$row['purchases'],$row['production'])); $row['items']['fn_stock_out_units'] = unit_based_conversion($row['items'],'purchase',process_get_item_stock_out_units($row['items'],$row['production'],$row['sales'],$row['damage'])); $row['items']['fn_branch_transfer_in_units'] = unit_based_conversion($row['items'],'purchase',process_get_item_branch_transfer_in_units($row['items'],$row['branch_transfer_in'])); $row['items']['fn_branch_transfer_out_units'] = unit_based_conversion($row['items'],'purchase',process_get_item_branch_transfer_out_units($row['items'],$row['branch_transfer_out'])); $row['items']['fn_damage_units'] = unit_based_conversion($row['items'],'purchase',process_get_item_damage_units($row['items'],$row['damage'])); $row['items']['fn_avail_units'] = unit_based_conversion($row['items'],'purchase',process_get_item_avail_units($row['items'],$row['purchases'],$row['production'],$row['sales'],$row['damage'],$row['branch_transfer_in'],$row['branch_transfer_out'])); $embeded_stats_items[] = $row['items']; } return $embeded_stats_items; } function get_warehouse_wise_items() { $items = fetch_table_branch('items'); return process_get_warehouse_wise_items($items); } function embed_warehouse_wise_items($items) { return process_get_warehouse_wise_items($items); } function process_get_warehouse_wise_items($items) { $branch_id = active_branch_id(); $purchases = fetch_table_branch('purchases'); $production = DB::table('production_details')->where('branch',$branch_id); $sales = fetch_table_branch('sales'); $sales_return = fetch_table_branch('sales_return'); $transfer_in = fetch_table_branch('transfer_in'); $transfer_out = fetch_table_branch('transfer_out'); $branch_to_branch_transfer = DB::table('branch_to_branch_transfer'); $damage = fetch_table_branch('damage'); $transfers = fetch_table_branch('transfer'); $branch_transfer_in = fetch_table_branch('branch_transfer_in'); $branch_transfer_out = fetch_table_branch('branch_transfer_out'); $bundle_toop = fetch_table_branch('items_bundle_toop_stock'); $inventory_expenses_deductions = DB::table('expenses_deductions')->where('branch',$branch_id)->where('expenses_mood','inventory_expenses')->where('status','approved'); $production = json_decode(json_encode($production->get()),true); $branch_to_branch_transfer = json_decode(json_encode($branch_to_branch_transfer->get()),true); $inventory_expenses_deductions = json_decode(json_encode($inventory_expenses_deductions->get()),true); $items_joined_data = join_item_data($items,$purchases,$production,$sales,$sales_return,$transfer_in,$transfer_out,$branch_to_branch_transfer,$damage,$transfers,$branch_transfer_in,$branch_transfer_out,$inventory_expenses_deductions,$bundle_toop); $embeded_stats_items = array(); foreach($items_joined_data as $row) { $row['items']['fn_avail_units'] = unit_based_conversion_of_array($row['items'],'purchase',process_get_item_avail_units($row['items'],$row['purchases'],$row['production'],$row['sales'],$row['damage'],$row['branch_transfer_in'],$row['branch_transfer_out'],TRUE)); $row['items']['fn_stock_in_units'] = unit_based_conversion_of_array($row['items'],'purchase',process_get_item_stock_in_units($row['items'],$row['purchases'],$row['production'],TRUE)); $row['items']['fn_stock_out_units'] = unit_based_conversion_of_array($row['items'],'purchase',process_get_item_stock_out_units($row['items'],$row['production'],$row['sales'],$row['damage'],TRUE)); $row['items']['fn_damage_units'] = unit_based_conversion($row['items'],'purchase',process_get_item_damage_units($row['items'],$row['damage'],TRUE)); $row['items']['fn_avg_cost'] = unit_based_conversion($row['items'],'purchase',process_item_batch_wise_avg_cost($row['items'])); $row['items']['fn_last_cost'] = unit_based_conversion($row['items'],'purchase',process_get_item_last_cost($row['items'],$row['purchases'],$row['production'],$row['item_branch_to_branch_transfer_in'])); $row['items']['fn_profit'] = unit_based_conversion($row['items'],'purchase',process_get_item_last_profit($row['items'],$row['purchases'],$row['production'],$row['item_branch_to_branch_transfer_in'])); $embeded_stats_items[] = $row['items']; } $transfer_handeled_items = array(); foreach($embeded_stats_items as $i_row) { foreach($transfers as $ti_row) { if($ti_row['item'] == $i_row['uid']) { $transfered_qty = (float)$ti_row['qty']; if($ti_row['unit'] == 'purchase'){ $transfered_qty = (float)$i_row['purchase_unit_equalance'] == 0 ? 0 : ($transfered_qty / (float)$i_row['purchase_unit_equalance']); } if($ti_row['unit'] == 'sale'){ $transfered_qty = (float)$i_row['sale_unit_equalance'] == 0 ? 0 : ($transfered_qty / (float)$i_row['sale_unit_equalance']); } if($ti_row['unit'] == 'production'){ $transfered_qty = (float)$i_row['production_unit_equalance'] == 0 ? 0 : ($transfered_qty / (float)$i_row['production_unit_equalance']); } if(array_key_exists($ti_row['sending_warehouse'], $i_row['fn_avail_units'])) { $i_row['fn_avail_units'][$ti_row['sending_warehouse']] = (float)$i_row['fn_avail_units'][$ti_row['sending_warehouse']] - $transfered_qty; } if(array_key_exists($ti_row['sending_warehouse'], $i_row['fn_stock_out_units'])) { $i_row['fn_stock_out_units'][$ti_row['sending_warehouse']] = (float)$i_row['fn_stock_out_units'][$ti_row['sending_warehouse']] + $transfered_qty; } else { $i_row['fn_stock_out_units'][$ti_row['sending_warehouse']] = $transfered_qty; } if(array_key_exists($ti_row['receiving_warehouse'], $i_row['fn_avail_units'])) { $i_row['fn_avail_units'][$ti_row['receiving_warehouse']] = (float)$i_row['fn_avail_units'][$ti_row['receiving_warehouse']] + $transfered_qty; } if(array_key_exists($ti_row['receiving_warehouse'], $i_row['fn_stock_in_units'])) { $i_row['fn_stock_in_units'][$ti_row['receiving_warehouse']] = (float)$i_row['fn_stock_in_units'][$ti_row['receiving_warehouse']] + $transfered_qty; } else { $i_row['fn_stock_in_units'][$ti_row['receiving_warehouse']] = $transfered_qty; } } } $transfer_handeled_items[] = $i_row; } return $transfer_handeled_items; } function get_warehouse_items_stats($warehouse) { $purchases = fetch_table_where_branch("cpurchases","warehouse",$warehouse); $items = set_array_keys(fetch_table_branch("citems"),"uid"); $items_array = array(); foreach($purchases as $row) { if(!array_key_exists($row['item'], $items_array)) { $item_name = array_key_exists($row['item'], $items) ? $items[$row['item']]['name'] : NULL; $items_array[$row['item']] = array("uid" => $row['item'], "name" => $item_name); } } return $items_array; } function get_warehouse_items($warehouse) { $purchases = fetch_table_where_branch("cpurchases","warehouse",$warehouse); $items = set_array_keys(fetch_table_branch("citems"),"uid"); $items_array = array(); foreach($purchases as $row) { if(!array_key_exists($row['item'], $items_array)) { $item_name = array_key_exists($row['item'], $items) ? $items[$row['item']]['name'] : NULL; $items_array[$row['item']] = array("uid" => $row['item'], "name" => $item_name); } } return $items_array; } function get_marketers_report($sales,$services) { $records = array(); foreach($sales as $row) { if(!empty($row['marketer'])) { $records[] = array( 'uid' => $row['uid'], 'date' => $row['created_at'], 'invoice' => '<a href="'.url('/sales/invoice').'/'.$row['uid'].'" target="_blank">'.$row['invoice'].'</a>', 'module' => 'sales', 'marketer' => $row['marketer'], 'currency' => $row['currency'], 'amount' => $row['sales_total'], ); } } foreach($services as $row) { if(!empty($row['marketer'])) { $records[] = array( 'uid' => $row['uid'], 'date' => $row['created_at'], 'invoice' => '<a href="'.url('/services/invoice').'/'.$row['uid'].'" target="_blank">'.$row['invoice'].'</a>', 'module' => 'services', 'marketer' => $row['marketer'], 'currency' => $row['currency'], 'amount' => $row['gross_total'], ); } } return sort_data_date_wise($records,'date'); } function process_item_stock_report($item,$purchases,$sales,$sales_return,$transfer_in,$transfer_out,$damage) { $stock_in = array(); $stock_out = array(); $records = array(); $purchase_totals = array(); $sales_totals = array(); $sales_return_totals = array(); $transfer_in_totals = array(); $transfer_out_totals = array(); $damage_totals = array(); $item_data = fetch_table_where('items','uid',$item,true); $item_stats = json_decode($item_data['stats'],true); if(!empty($purchases)) { foreach($purchases as $row) { if(!array_key_exists($row['currency'], $purchase_totals)) { $purchase_totals[$row['currency']] = array(); } $inner_details = json_decode($row['items'],true); if(count($inner_details) > 0) { foreach($inner_details as $inner_row) { if($inner_row['item'] == $item) { $qty = (float)$inner_row['qty'] + (float)$inner_row['bonus']; $narration = 'Purchase# '.$row['invoice'].', Total: '.amount_number_format((float)$row['sub_total_amount']).', Paid: '.amount_number_format((float)$row['paid_amount']); $invoice = '<a href="'.url('/purchases/invoice').'/'.$row['uid'].'" target="_blank">'.(float)$row['invoice'].'</a>'; if($qty > 0) { $stock_in[] = $qty; $purchase_totals[$row['currency']][] = (float)$inner_row['total']; $records[] = array( 'module' => 'purchases', 'date' => $row['created_at'], 'invoice' => $invoice, 'narration' => $narration, 'currency' => $row['currency'], 'currency_usd_equalance' => $row['currency_usd_equalance'], 'account' => $row['supplier'], 'account_name' => get_account_name($row['supplier']), 'batch' => $inner_row['batch'], 'stock_in' => $qty, 'stock_out' => 0, ); } } } } } } if(!empty($sales_return)) { foreach($sales_return as $row) { if(!array_key_exists($row['currency'], $sales_return_totals)) { $sales_return_totals[$row['currency']] = array(); } $inner_details = json_decode($row['items_details'],true); if(count($inner_details) > 0) { foreach($inner_details as $inner_row) { if($inner_row['item'] == $item) { $qty = (float)$inner_row['r_qty']; $bonus = (float)$inner_row['r_bonus']; $narration = 'Sales Return# '.$row['return_invoice'].', Total: '.amount_number_format((float)$row['refund_total']).', Paid: '.amount_number_format((float)$row['refund_received']); $invoice = '<a href="'.url('/sales-return/invoice').'/'.$row['uid'].'" target="_blank">'.(float)$row['return_invoice'].'</a>'; if($qty > 0) { $stock_in[] = $qty + $bonus; $sales_return_totals[$row['currency']][] = (float)$inner_row['r_item_total']; $records[] = array( 'module' => 'sales_return', 'date' => $row['created_at'], 'invoice' => $invoice, 'narration' => $narration, 'currency' => $row['currency'], 'currency_usd_equalance' => $row['currency_usd_equalance'], 'account' => $row['client'], 'account_name' => get_account_name($row['client']), 'batch' => $inner_row['batch'], 'stock_in' => $qty + $bonus, 'stock_out' => 0, ); } } } } } } if(!empty($transfer_in)) { foreach($transfer_in as $row) { if(!array_key_exists($row['currency'], $transfer_in_totals)) { $transfer_in_totals[$row['currency']] = array(); } $inner_details = json_decode($row['items'],true); if(count($inner_details) > 0) { foreach($inner_details as $inner_row) { if($inner_row['item'] == $item) { $bonus = isset($inner_row['bonus']) ? (float)$inner_row['bonus'] : 0; $qty = (float)$inner_row['qty'] + $bonus; $narration = 'Transfer in# '.$row['invoice'].', Total: '.amount_number_format((float)$row['grand_total']); $invoice = '<a href="'.url('/transfer-in/invoice').'/'.$row['uid'].'" target="_blank">'.(float)$row['invoice'].'</a>'; if($qty > 0) { $stock_in[] = $qty; $transfer_in_totals[$row['currency']][] = (float)$inner_row['total']; $records[] = array( 'module' => 'transfer in', 'date' => $row['created_at'], 'invoice' => $invoice, 'narration' => $narration, 'currency' => $row['currency'], 'currency_usd_equalance' => $row['currency_usd_equalance'], 'account' => $row['client'], 'account_name' => get_account_name($row['client']), 'batch' => $inner_row['batch'], 'stock_in' => $qty, 'stock_out' => 0, ); } } } } } } if(!empty($sales)) { foreach($sales as $row) { if(!array_key_exists($row['currency'], $sales_totals)) { $sales_totals[$row['currency']] = array(); } $inner_details = json_decode($row['items_details'],true); if(count($inner_details) > 0) { foreach($inner_details as $inner_row) { if($inner_row['item'] == $item) { $qty = (float)$inner_row['qty'] + (float)$inner_row['bonus']; $narration = 'Sales# '.$row['invoice'].', Total: '.amount_number_format((float)$row['sub_total']).', Trans Exp: '.amount_number_format((float)$row['trans_expense']).', Paid: '.amount_number_format((float)$row['cash_received']); $invoice = '<a href="'.url('/sales/invoice').'/'.$row['uid'].'" target="_blank">'.(float)$row['invoice'].'</a>'; if($qty > 0) { $stock_out[] = $qty; $sales_totals[$row['currency']][] = (float)$inner_row['item_total']; $records[] = array( 'module' => 'sales', 'date' => $row['created_at'], 'invoice' => $invoice, 'narration' => $narration, 'currency' => $row['currency'], 'currency_usd_equalance' => $row['currency_usd_equalance'], 'account' => $row['client'], 'account_name' => get_account_name($row['client']), 'batch' => $inner_row['batch'], 'stock_in' => 0, 'stock_out' => $qty, ); } } } } } } if(!empty($transfer_out)) { foreach($transfer_out as $row) { if(!array_key_exists($row['currency'], $transfer_out_totals)) { $transfer_out_totals[$row['currency']] = array(); } $inner_details = json_decode($row['items'],true); if(count($inner_details) > 0) { foreach($inner_details as $inner_row) { if($inner_row['item'] == $item) { $qty = (float)$inner_row['qty'] + (float)$inner_row['bonus']; $narration = 'Transfer out# '.$row['invoice'].', Total: '.amount_number_format((float)$row['gross_total_amount']); $invoice = '<a href="'.url('/transfer-out/invoice').'/'.$row['uid'].'" target="_blank">'.(float)$row['invoice'].'</a>'; if($qty > 0) { $stock_out[] = $qty; $transfer_out_totals[$row['currency']][] = (float)$inner_row['item_total']; $records[] = array( 'module' => 'transfer out', 'date' => $row['created_at'], 'invoice' => $invoice, 'narration' => $narration, 'currency' => $row['currency'], 'currency_usd_equalance' => $row['currency_usd_equalance'], 'account' => $row['client'], 'account_name' => get_account_name($row['client']), 'batch' => $inner_row['batch'], 'stock_in' => 0, 'stock_out' => $qty, ); } } } } } } if(!empty($damage)) { $amount_total = 0; foreach($damage as $row) { $qty = (float)$row['qty']; $amount_total = (float)$qty * (float)$item_stats['avg_cost']; $narration = 'Damage: '.$row['narration']; if($qty > 0) { $stock_out[] = $qty; $damage_totals[] = round_decimels_digits($amount_total); $records[] = array( 'module' => 'damage', 'date' => $row['created_at'], 'invoice' => '', 'narration' => $narration, 'currency' => $item_data['currency'], 'currency_usd_equalance' => $item_data['currency_usd_equalance'], 'account' => '', 'account_name' => '', 'batch' => '', 'stock_in' => 0, 'stock_out' => $qty, ); } } } $records = sort_data_date_wise($records,'date'); $data_array = array( 'records' => $records, 'stock_in' => $stock_in, 'stock_out' => $stock_out, 'purchase_totals' => $purchase_totals, 'sales_totals' => $sales_totals, 'sales_return_totals' => $sales_return_totals, 'transfer_in_totals' => $transfer_in_totals, 'transfer_out_totals' => $transfer_out_totals, 'damage_totals' => $damage_totals, ); return $data_array; } function items_warehouse_batch_unit_qty($item,$warehouse,$batch,$unit) { $item_batch_wise_stock_in = DB::table('batch_wise_stock')->where('item',$item)->where('warehouse',$warehouse)->where('batch',$batch)->where('unit',$unit)->sum('stock_in'); $item_batch_wise_bonus_in = DB::table('batch_wise_stock')->where('item',$item)->where('warehouse',$warehouse)->where('batch',$batch)->where('unit',$unit)->sum('bonus_in'); $item_batch_wise_stock_out = DB::table('batch_wise_stock')->where('item',$item)->where('warehouse',$warehouse)->where('batch',$batch)->where('unit',$unit)->sum('stock_out'); $item_batch_wise_bonus_out = DB::table('batch_wise_stock')->where('item',$item)->where('warehouse',$warehouse)->where('batch',$batch)->where('unit',$unit)->sum('bonus_out'); $item_ava_units = ($item_batch_wise_stock_in + $item_batch_wise_bonus_in) - ($item_batch_wise_stock_out + $item_batch_wise_bonus_out); return $item_ava_units; } function get_item_warehouse_wise_batch($uid,$warehouse) { $active_branch_id = active_branch_id(); $item_data = fetch_table_where('items','uid',$uid,true); $item_stats = json_decode($item_data['stats'],true); $item_currency = $item_data['currency']; $item_currency_usd_equalance = (float)$item_data['currency_usd_equalance']; $batch_array = []; $batch = std_obj_to_array(DB::table("items_inventory_stats")->where('item',$uid)->where('warehouse',$warehouse)->select('batch')->distinct()->get()); foreach($batch as $row) { $batch_array[$row['batch']] = $row['batch']; } $batch_array = array_unique($batch_array); $batch_details = []; foreach($batch_array as $ba) { $items_inventory = std_obj_to_array( DB::select("
                SELECT 
                sum(purchase_unit_stock_in) stock_in, 
                sum(purchase_unit_bonus_in) bonus_in, 
                sum(purchase_unit_stock_out) stock_out,
                sum(purchase_unit_bonus_out) bonus_out
                FROM items_inventory_stats
                where batch = '".$ba."' AND item = '".$uid."' AND warehouse = '".$warehouse."'
                ") ); $stock_ava = ($items_inventory[0]['stock_in'] + $items_inventory[0]['bonus_in']) - ($items_inventory[0]['stock_out'] + $items_inventory[0]['bonus_out']); $batch_details[] = [ 'batch' => $ba, 'stock_ava' => $stock_ava, ]; } return $batch_details; } function _handle_items_inventory_stats_from_item_registration($sources) { $uid = $sources['uid']; $entry_status = $sources['entry_status']; $db_entry = fetch_table_where('items','uid',$uid,TRUE); if($entry_status == 'update' OR $entry_status == 'delete') { delete_table('items_inventory_stats','module_uid',$uid); } if($entry_status == 'new' OR $entry_status == 'update') { if(!empty($db_entry)) { $warehouses = json_decode($db_entry['warehouses'],true); $opening_stocks = json_decode($db_entry['opening_stocks'],true); if(!empty($warehouses)) { foreach($warehouses as $key => $row) { if(!empty($row)) { $warehouse_data = fetch_table_where('warehouse','uid',$row,true); $sale_unit_equalance = (float)$db_entry['sale_unit_equalance']; if($sale_unit_equalance == 0){ $sale_unit_equalance = 1; } $production_unit_equalance = (float)$db_entry['production_unit_equalance']; if($production_unit_equalance == 0){ $production_unit_equalance = 1; } $opening_stock = isset($opening_stocks[$key]) ? (float)$opening_stocks[$key] : 0; $purchase_unit_qty = (float)$opening_stock; $sale_unit_qty = (float)$opening_stock * $sale_unit_equalance; $production_unit_qty = (float)$opening_stock * $production_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost']; $sale_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_cost = (float)$db_entry['cost'] / $production_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['cost']; $sale_unit_real_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_real_cost = (float)$db_entry['cost'] / $production_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit']; $sale_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $production_unit_profit = (float)$db_entry['profit'] / $production_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price']; $sale_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price'] / $production_unit_equalance; $inventory_array = [ 'uid' => getUniqueId('ITINT', 'items_inventory_stats', 'uid'), 'branch' => $db_entry['branch'], 'event_date' => $db_entry['created_at'], 'item' => $db_entry['uid'], 'item_name' => $db_entry['name'], 'item_category' => $db_entry['category'], 'item_type' => $db_entry['type'], 'warehouse' => $row, 'warehouse_name' => isset($warehouse_data['name']) ? $warehouse_data['name'] : null, 'unit' => $db_entry['purchase_unit'], 'unit_name' => $db_entry['purchase_unit_name'], 'batch' => $db_entry['batch'], 'module_uid' => $db_entry['uid'], 'module_name' => 'items', 'purchase_unit_stock_in' => $purchase_unit_qty, 'sale_unit_stock_in' => $sale_unit_qty, 'production_unit_stock_in' => $production_unit_qty, 'currency' => $db_entry['currency'], 'currency_name' => $db_entry['currency_name'], 'currency_symbol' => $db_entry['currency_symbol'], 'currency_usd_equalance' => $db_entry['currency_usd_equalance'], 'item_currency' => $db_entry['currency'], 'item_currency_name' => $db_entry['currency_name'], 'item_currency_symbol' => $db_entry['currency_symbol'], 'item_currency_usd_equalance' => $db_entry['currency_usd_equalance'], 'purchase_unit_cost' => $purchase_unit_cost, 'sale_unit_cost' => $sale_unit_cost, 'production_unit_cost' => $production_unit_cost, 'item_currency_purchase_unit_cost' => $purchase_unit_cost, 'item_currency_sale_unit_cost' => $sale_unit_cost, 'item_currency_production_unit_cost' => $production_unit_cost, 'purchase_unit_real_cost' => $purchase_unit_real_cost, 'sale_unit_real_cost' => $sale_unit_real_cost, 'production_unit_real_cost' => $production_unit_real_cost, 'item_currency_purchase_unit_real_cost' => $purchase_unit_real_cost, 'item_currency_sale_unit_real_cost' => $sale_unit_real_cost, 'item_currency_production_unit_real_cost' => $production_unit_real_cost, 'purchase_unit_profit' => $purchase_unit_profit, 'sale_unit_profit' => $sale_unit_profit, 'production_unit_profit' => $production_unit_profit, 'item_currency_purchase_unit_profit' => $purchase_unit_profit, 'item_currency_sale_unit_profit' => $sale_unit_profit, 'item_currency_production_unit_profit' => $production_unit_profit, 'purchase_unit_sale_price' => $purchase_unit_sale_price, 'sale_unit_sale_price' => $sale_unit_sale_price, 'production_unit_sale_price' => $production_unit_sale_price, 'item_currency_purchase_unit_sale_price' => $purchase_unit_sale_price, 'item_currency_sale_unit_sale_price' => $sale_unit_sale_price, 'item_currency_production_unit_sale_price' => $production_unit_sale_price, 'mfg' => $db_entry['mfg_date'], 'expiry' => $db_entry['expiry_date'], ]; insert_table('items_inventory_stats',$inventory_array); } } } _calculate_item_wise_stats(['item' => $uid]); } } } function _handle_items_inventory_stats_from_purchases($sources) { $uid = $sources['uid']; $entry_status = $sources['entry_status']; $db_entry = fetch_table_where('purchases','uid',$uid,TRUE); if($entry_status == 'update' OR $entry_status == 'delete') { delete_table('items_inventory_stats','module_uid',$uid); } if($entry_status == 'new' OR $entry_status == 'update') { if(!empty($db_entry)) { $account_data = fetch_table_where('accounts','uid',$db_entry['supplier'],TRUE); $purchase_items_db = json_decode($db_entry['items'],true); if(!empty($purchase_items_db)) { foreach($purchase_items_db as $entry_item) { $item_data = fetch_table_where('items','uid',$entry_item['item'],TRUE); $item_currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $currency_data = fetch_table_where('currency','uid',$db_entry['currency'],TRUE); $warehouse_data = fetch_table_where('warehouse','uid',$entry_item['warehouse'],TRUE); $expense_account_data = fetch_table_where('accounts','uid',$entry_item['expense'],TRUE); $sale_unit_equalance = (float)$item_data['sale_unit_equalance']; if($sale_unit_equalance == 0){ $sale_unit_equalance = 1; } $production_unit_equalance = (float)$item_data['production_unit_equalance']; if($production_unit_equalance == 0){ $production_unit_equalance = 1; } $item_currency = $item_data['currency']; $item_currency_usd_equalance = $item_data['currency_usd_equalance']; $item_currency_cost = (float)$entry_item['cost']; $item_currency_real_cost = (float)$entry_item['real_cost']; $item_currency_profit = (float)$entry_item['profit']; $item_currency_sale_price = (float)$entry_item['sale_price']; $item_currency_discount = (float)$entry_item['discount']; $item_currency_discount_amount = ($item_currency_cost * $item_currency_discount) / 100; $item_currency_expense = (float)$entry_item['transport_expense'] / $entry_item['qty']; $discount_amount = $item_currency_discount_amount; $expense = $item_currency_expense; if($item_currency != $db_entry['currency']) { $item_currency_cost = amount_conversion((float)$entry_item['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_real_cost = amount_conversion((float)$entry_item['real_cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_profit = amount_conversion((float)$entry_item['profit'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_sale_price = amount_conversion((float)$entry_item['sale_price'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_discount = amount_conversion($item_currency_discount, $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_discount_amount = amount_conversion($item_currency_discount_amount, $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_expense = amount_conversion($item_currency_expense, $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); } $entry_item['qty'] = isset($entry_item['qty']) ? $entry_item['qty'] : 0; $entry_item['bonus'] = isset($entry_item['bonus']) ? $entry_item['bonus'] : 0; if($entry_item['unit'] == 'purchase') { $purchase_unit_qty = (float)$entry_item['qty']; $sale_unit_qty = (float)$entry_item['qty'] * $sale_unit_equalance; $production_unit_qty = (float)$entry_item['qty'] * $production_unit_equalance; $purchase_bonus_qty = (float)$entry_item['bonus']; $sale_bonus_qty = (float)$entry_item['bonus'] * $sale_unit_equalance; $production_bonus_qty = (float)$entry_item['bonus'] * $production_unit_equalance; $purchase_unit_cost = (float)$entry_item['cost']; $sale_unit_cost = (float)$entry_item['cost'] / $sale_unit_equalance; $production_unit_cost = (float)$entry_item['cost'] / $production_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost; $item_currency_sale_unit_cost = $item_currency_cost / $sale_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost / $production_unit_equalance; $purchase_unit_real_cost = (float)$entry_item['real_cost']; $sale_unit_real_cost = (float)$entry_item['real_cost'] / $sale_unit_equalance; $production_unit_real_cost = (float)$entry_item['real_cost'] / $production_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost; $item_currency_sale_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost / $production_unit_equalance; $purchase_unit_profit = (float)$entry_item['profit']; $sale_unit_profit = (float)$entry_item['profit'] / $sale_unit_equalance; $production_unit_profit = (float)$entry_item['profit'] / $production_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit; $item_currency_sale_unit_profit = $item_currency_profit / $sale_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit / $production_unit_equalance; $purchase_unit_sale_price = (float)$entry_item['sale_price']; $sale_unit_sale_price = (float)$entry_item['sale_price'] / $sale_unit_equalance; $production_unit_sale_price = (float)$entry_item['sale_price'] / $production_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price; $item_currency_sale_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price / $production_unit_equalance; $purchase_unit_discount = (float)$entry_item['discount']; $sale_unit_discount = (float)$entry_item['discount'] / $sale_unit_equalance; $production_unit_discount = (float)$entry_item['discount'] / $production_unit_equalance; $item_currency_purchase_unit_discount = $item_currency_discount; $item_currency_sale_unit_discount = $item_currency_discount / $sale_unit_equalance; $item_currency_production_unit_discount = $item_currency_discount / $production_unit_equalance; $purchase_unit_discount_amount = $discount_amount; $sale_unit_discount_amount = $discount_amount / $sale_unit_equalance; $production_unit_discount_amount = $discount_amount / $production_unit_equalance; $item_currency_purchase_unit_discount_amount = $item_currency_discount_amount; $item_currency_sale_unit_discount_amount = $item_currency_discount_amount / $sale_unit_equalance; $item_currency_production_unit_discount_amount = $item_currency_discount_amount / $production_unit_equalance; $purchase_unit_expense = $expense; $sale_unit_expense = $expense / $sale_unit_equalance; $production_unit_expense = $expense / $production_unit_equalance; $item_currency_purchase_unit_expense = $item_currency_expense; $item_currency_sale_unit_expense = $item_currency_expense / $sale_unit_equalance; $item_currency_production_unit_expense = $item_currency_expense / $production_unit_equalance; } else if($entry_item['unit'] == 'sale') { $purchase_unit_qty = (float)$entry_item['qty'] / $sale_unit_equalance; $sale_unit_qty = (float)$entry_item['qty']; $production_unit_qty = (float)$entry_item['qty'] * $sale_unit_equalance; $purchase_bonus_qty = (float)$entry_item['bonus'] / $sale_unit_equalance; $sale_bonus_qty = (float)$entry_item['bonus']; $production_bonus_qty = (float)$entry_item['bonus'] * $sale_unit_equalance; $purchase_unit_cost = (float)$entry_item['cost'] * $sale_unit_equalance; $sale_unit_cost = (float)$entry_item['cost']; $production_unit_cost = (float)$entry_item['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost * $sale_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost; $item_currency_production_unit_cost = $item_currency_cost / $sale_unit_equalance; $purchase_unit_real_cost = (float)$entry_item['real_cost'] * $sale_unit_equalance; $sale_unit_real_cost = (float)$entry_item['real_cost']; $production_unit_real_cost = (float)$entry_item['real_cost'] / $sale_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $sale_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost; $item_currency_production_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $purchase_unit_profit = (float)$entry_item['profit'] * $sale_unit_equalance; $sale_unit_profit = (float)$entry_item['profit']; $production_unit_profit = (float)$entry_item['profit'] / $sale_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit * $sale_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit; $item_currency_production_unit_profit = $item_currency_profit / $sale_unit_equalance; $purchase_unit_sale_price = (float)$entry_item['sale_price'] * $sale_unit_equalance; $sale_unit_sale_price = (float)$entry_item['sale_price']; $production_unit_sale_price = (float)$entry_item['sale_price'] / $sale_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $sale_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price; $item_currency_production_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $purchase_unit_discount = (float)$entry_item['discount'] * $sale_unit_equalance; $sale_unit_discount = (float)$entry_item['discount']; $production_unit_discount = (float)$entry_item['discount'] / $sale_unit_equalance; $item_currency_purchase_unit_discount = $item_currency_discount * $sale_unit_equalance; $item_currency_sale_unit_discount = $item_currency_discount; $item_currency_production_unit_discount = $item_currency_discount / $sale_unit_equalance; $purchase_unit_discount = (float)$entry_item['discount'] * $sale_unit_equalance; $sale_unit_discount = (float)$entry_item['discount']; $production_unit_discount = (float)$entry_item['discount'] / $sale_unit_equalance; $item_currency_purchase_unit_discount = $item_currency_discount * $sale_unit_equalance; $item_currency_sale_unit_discount = $item_currency_discount * $sale_unit_equalance; $item_currency_production_unit_discount = $item_currency_discount / $sale_unit_equalance; $purchase_unit_discount_amount = $discount_amount * $sale_unit_equalance; $sale_unit_discount_amount = $discount_amount; $production_unit_discount_amount = $discount_amount / $sale_unit_equalance; $item_currency_purchase_unit_discount_amount = $item_currency_discount_amount * $sale_unit_equalance; $item_currency_sale_unit_discount_amount = $item_currency_discount_amount; $item_currency_production_unit_discount_amount = $item_currency_discount_amount / $sale_unit_equalance; $purchase_unit_expense = $expense * $sale_unit_equalance; $sale_unit_expense = $expense; $production_unit_expense = $expense / $sale_unit_equalance; $item_currency_purchase_unit_expense = $item_currency_expense * $sale_unit_equalance; $item_currency_sale_unit_expense = $item_currency_expense; $item_currency_production_unit_expense = $item_currency_expense / $sale_unit_equalance; } else { $purchase_unit_qty = (float)$entry_item['qty'] / $production_unit_equalance; $sale_unit_qty = (float)$entry_item['qty'] / $production_unit_equalance; $production_unit_qty = (float)$entry_item['qty']; $purchase_bonus_qty = (float)$entry_item['bonus'] / $production_unit_equalance; $sale_bonus_qty = (float)$entry_item['bonus'] / $production_unit_equalance; $production_bonus_qty = (float)$entry_item['bonus']; $purchase_unit_cost = (float)$entry_item['cost'] * $production_unit_equalance; $sale_unit_cost = (float)$entry_item['cost'] * $production_unit_equalance; $production_unit_cost = (float)$entry_item['cost']; $item_currency_purchase_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost; $purchase_unit_real_cost = (float)$entry_item['real_cost'] * $production_unit_equalance; $sale_unit_real_cost = (float)$entry_item['real_cost'] * $production_unit_equalance; $production_unit_real_cost = (float)$entry_item['real_cost']; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost; $purchase_unit_profit = (float)$entry_item['profit'] * $production_unit_equalance; $sale_unit_profit = (float)$entry_item['profit'] * $production_unit_equalance; $production_unit_profit = (float)$entry_item['profit']; $item_currency_purchase_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit; $purchase_unit_sale_price = (float)$entry_item['sale_price'] * $production_unit_equalance; $sale_unit_sale_price = (float)$entry_item['sale_price'] * $production_unit_equalance; $production_unit_sale_price = (float)$entry_item['sale_price']; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price; $purchase_unit_discount = (float)$entry_item['discount'] * $production_unit_equalance; $sale_unit_discount = (float)$entry_item['discount'] * $production_unit_equalance; $production_unit_discount = (float)$entry_item['discount']; $item_currency_purchase_unit_discount = $item_currency_discount * $production_unit_equalance; $item_currency_sale_unit_discount = $item_currency_discount * $production_unit_equalance; $item_currency_production_unit_discount = $item_currency_discount; $purchase_unit_discount = (float)$entry_item['discount'] * $production_unit_equalance; $sale_unit_discount = (float)$entry_item['discount'] * $production_unit_equalance; $production_unit_discount = (float)$entry_item['discount']; $item_currency_purchase_unit_discount = $item_currency_discount * $production_unit_equalance; $item_currency_sale_unit_discount = $item_currency_discount * $production_unit_equalance * $production_unit_equalance; $item_currency_production_unit_discount = $item_currency_discount; $purchase_unit_discount_amount = $discount_amount * $production_unit_equalance; $sale_unit_discount_amount = $discount_amount * $production_unit_equalance; $production_unit_discount_amount = $discount_amount; $item_currency_purchase_unit_discount_amount = $item_currency_discount_amount * $production_unit_equalance; $item_currency_sale_unit_discount_amount = $item_currency_discount_amount * $production_unit_equalance; $item_currency_production_unit_discount_amount = $item_currency_discount_amount; $purchase_unit_expense = $expense * $production_unit_equalance; $sale_unit_expense = $expense * $production_unit_equalance; $production_unit_expense = $expense; $item_currency_purchase_unit_expense = $item_currency_expense * $production_unit_equalance; $item_currency_sale_unit_expense = $item_currency_expense * $production_unit_equalance; $item_currency_production_unit_expense = $item_currency_expense; } $inventory_array = [ 'uid' => getUniqueId('ITINT', 'items_inventory_stats', 'uid'), 'branch' => $db_entry['branch'], 'event_date' => $db_entry['created_at'], 'item' => $item_data['uid'], 'item_name' => $item_data['name'], 'item_category' => $item_data['category'], 'item_type' => $item_data['type'], 'account' => $account_data['uid'], 'account_name' => $account_data['name'], 'expense_account' => isset($expense_account_data['uid']) ? $expense_account_data['uid'] : null, 'expense_account_name' => isset($expense_account_data['name']) ? $expense_account_data['name'] : null, 'warehouse' => $warehouse_data['uid'], 'warehouse_name' => $warehouse_data['name'], 'batch' => $entry_item['batch'], 'invoice' => $db_entry['invoice'], 'module_uid' => $db_entry['uid'], 'module_name' => 'purchases', 'purchase_unit_stock_in' => $purchase_unit_qty, 'sale_unit_stock_in' => $sale_unit_qty, 'production_unit_stock_in' => $production_unit_qty, 'purchase_unit_bonus_in' => $purchase_bonus_qty, 'sale_unit_bonus_in' => $sale_bonus_qty, 'production_unit_bonus_in' => $production_bonus_qty, 'currency' => $currency_data['uid'], 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'currency_usd_equalance' => $currency_data['usd_equalance'], 'item_currency' => $item_currency_data['uid'], 'item_currency_name' => $item_currency_data['name'], 'item_currency_symbol' => $item_currency_data['symbol'], 'item_currency_usd_equalance' => $item_currency_data['usd_equalance'], 'purchase_unit_cost' => $purchase_unit_cost, 'sale_unit_cost' => $sale_unit_cost, 'production_unit_cost' => $production_unit_cost, 'item_currency_purchase_unit_cost' => $item_currency_purchase_unit_cost, 'item_currency_sale_unit_cost' => $item_currency_sale_unit_cost, 'item_currency_production_unit_cost' => $item_currency_production_unit_cost, 'purchase_unit_real_cost' => $purchase_unit_real_cost, 'sale_unit_real_cost' => $sale_unit_real_cost, 'production_unit_real_cost' => $production_unit_real_cost, 'item_currency_purchase_unit_real_cost' => $item_currency_purchase_unit_real_cost, 'item_currency_sale_unit_real_cost' => $item_currency_sale_unit_real_cost, 'item_currency_production_unit_real_cost' => $item_currency_production_unit_real_cost, 'purchase_unit_profit' => $purchase_unit_profit, 'sale_unit_profit' => $sale_unit_profit, 'production_unit_profit' => $production_unit_profit, 'item_currency_purchase_unit_profit' => $item_currency_purchase_unit_profit, 'item_currency_sale_unit_profit' => $item_currency_sale_unit_profit, 'item_currency_production_unit_profit' => $item_currency_production_unit_profit, 'purchase_unit_sale_price' => $purchase_unit_sale_price, 'sale_unit_sale_price' => $sale_unit_sale_price, 'production_unit_sale_price' => $production_unit_sale_price, 'item_currency_purchase_unit_sale_price' => $item_currency_purchase_unit_sale_price, 'item_currency_sale_unit_sale_price' => $item_currency_sale_unit_sale_price, 'item_currency_production_unit_sale_price' => $item_currency_production_unit_sale_price, 'purchase_unit_discount' => $purchase_unit_discount, 'sale_unit_discount' => $sale_unit_discount, 'production_unit_discount' => $production_unit_discount, 'item_currency_purchase_unit_discount' => $item_currency_purchase_unit_discount, 'item_currency_sale_unit_discount' => $item_currency_sale_unit_discount, 'item_currency_production_unit_discount' => $item_currency_production_unit_discount, 'purchase_unit_discount_amount' => $purchase_unit_discount_amount, 'sale_unit_discount_amount' => $sale_unit_discount_amount, 'production_unit_discount_amount' => $production_unit_discount_amount, 'item_currency_purchase_unit_discount_amount' => $item_currency_purchase_unit_discount_amount, 'item_currency_sale_unit_discount_amount' => $item_currency_sale_unit_discount_amount, 'item_currency_production_unit_discount_amount' => $item_currency_production_unit_discount_amount, 'purchase_unit_expense' => $purchase_unit_expense, 'sale_unit_expense' => $sale_unit_expense, 'production_unit_expense' => $production_unit_expense, 'item_currency_purchase_unit_expense' => $item_currency_purchase_unit_expense, 'item_currency_sale_unit_expense' => $item_currency_sale_unit_expense, 'item_currency_production_unit_expense' => $item_currency_production_unit_expense, 'bundle_stock_in' => $entry_item['bundle'], 'toop_stock_in' => $entry_item['toop'], 'mfg' => $entry_item['mfg'], 'expiry' => $entry_item['expiry'], 'token_rate' => isset($entry_item['token_rate']) ? $entry_item['token_rate'] : null, 'item_token_in' => isset($entry_item['item_token']) ? $entry_item['item_token'] : null, ]; insert_table('items_inventory_stats',$inventory_array); _calculate_item_wise_stats(['item' => $inventory_array['item']]); } } } } } function _handle_items_inventory_stats_from_sales($sources) { $uid = $sources['uid']; $entry_status = $sources['entry_status']; $db_entry = fetch_table_where('sales','uid',$uid,TRUE); if($entry_status == 'update' OR $entry_status == 'delete') { delete_table('items_inventory_stats','module_uid',$uid); } if($entry_status == 'new' OR $entry_status == 'update') { if(!empty($db_entry)) { $account_data = fetch_table_where('accounts','uid',$db_entry['client'],TRUE); $sale_items_db = json_decode($db_entry['items_details'],true); if(!empty($sale_items_db)) { foreach($sale_items_db as $entry_item) { if(strpos($entry_item['item'],"MITNAME_") === FALSE) { $item_data = fetch_table_where('items','uid',$entry_item['item'],TRUE); $item_currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $currency_data = fetch_table_where('currency','uid',$db_entry['currency'],TRUE); $warehouse_data = fetch_table_where('warehouse','uid',$entry_item['warehouse'],TRUE); $sale_unit_equalance = (float)$item_data['sale_unit_equalance']; if($sale_unit_equalance == 0){ $sale_unit_equalance = 1; } $production_unit_equalance = (float)$item_data['production_unit_equalance']; if($production_unit_equalance == 0){ $production_unit_equalance = 1; } $item_currency = $item_data['currency']; $item_currency_usd_equalance = $item_data['currency_usd_equalance']; $item_currency_cost = (float)$entry_item['cost']; $item_currency_real_cost = (float)$entry_item['cost']; $item_currency_profit = (float)$entry_item['profit']; $item_currency_sale_price = (float)$entry_item['sale_price']; $item_currency_discount = (float)$entry_item['discount']; $item_currency_discount_amount = ($item_currency_sale_price * $item_currency_discount) / 100; $item_currency_discount_2 = (float)$entry_item['discount_2']; $item_currency_discount_amount_2 = (($item_currency_sale_price - $item_currency_discount_amount) * $item_currency_discount_2) / 100; $discount_amount = $item_currency_discount_amount; $discount_amount_2 = $item_currency_discount_amount_2; if($item_currency != $db_entry['currency']) { $item_currency_cost = amount_conversion((float)$entry_item['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_real_cost = amount_conversion((float)$entry_item['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_profit = amount_conversion((float)$entry_item['profit'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_sale_price = amount_conversion((float)$entry_item['sale_price'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_discount = amount_conversion($item_currency_discount, $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_discount_amount = amount_conversion($item_currency_discount_amount, $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_discount_2 = amount_conversion($item_currency_discount_2, $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_discount_amount_2 = amount_conversion($item_currency_discount_amount_2, $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); } if($entry_item['unit'] == 'purchase') { $purchase_unit_qty = (float)$entry_item['qty']; $sale_unit_qty = (float)$entry_item['qty'] * $sale_unit_equalance; $production_unit_qty = (float)$entry_item['qty'] * $production_unit_equalance; $purchase_bonus_qty = (float)$entry_item['bonus']; $sale_bonus_qty = (float)$entry_item['bonus'] * $sale_unit_equalance; $production_bonus_qty = (float)$entry_item['bonus'] * $production_unit_equalance; $purchase_unit_cost = (float)$entry_item['cost']; $sale_unit_cost = (float)$entry_item['cost'] / $sale_unit_equalance; $production_unit_cost = (float)$entry_item['cost'] / $production_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost; $item_currency_sale_unit_cost = $item_currency_cost / $sale_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost / $production_unit_equalance; $purchase_unit_real_cost = (float)$entry_item['cost']; $sale_unit_real_cost = (float)$entry_item['cost'] / $sale_unit_equalance; $production_unit_real_cost = (float)$entry_item['cost'] / $production_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost; $item_currency_sale_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost / $production_unit_equalance; $purchase_unit_profit = (float)$entry_item['profit']; $sale_unit_profit = (float)$entry_item['profit'] / $sale_unit_equalance; $production_unit_profit = (float)$entry_item['profit'] / $production_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit; $item_currency_sale_unit_profit = $item_currency_profit / $sale_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit / $production_unit_equalance; $purchase_unit_sale_price = (float)$entry_item['sale_price']; $sale_unit_sale_price = (float)$entry_item['sale_price'] / $sale_unit_equalance; $production_unit_sale_price = (float)$entry_item['sale_price'] / $production_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price; $item_currency_sale_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price / $production_unit_equalance; $purchase_unit_discount = (float)$entry_item['discount']; $sale_unit_discount = (float)$entry_item['discount'] / $sale_unit_equalance; $production_unit_discount = (float)$entry_item['discount'] / $production_unit_equalance; $item_currency_purchase_unit_discount = $item_currency_discount; $item_currency_sale_unit_discount = $item_currency_discount / $sale_unit_equalance; $item_currency_production_unit_discount = $item_currency_discount / $production_unit_equalance; $purchase_unit_discount_amount = $discount_amount; $sale_unit_discount_amount = $discount_amount / $sale_unit_equalance; $production_unit_discount_amount = $discount_amount / $production_unit_equalance; $item_currency_purchase_unit_discount_amount = $item_currency_discount_amount; $item_currency_sale_unit_discount_amount = $item_currency_discount_amount / $sale_unit_equalance; $item_currency_production_unit_discount_amount = $item_currency_discount_amount / $production_unit_equalance; $purchase_unit_discount_2 = (float)$entry_item['discount_2']; $sale_unit_discount_2 = (float)$entry_item['discount_2'] / $sale_unit_equalance; $production_unit_discount_2 = (float)$entry_item['discount_2'] / $production_unit_equalance; $item_currency_purchase_unit_discount_2 = $item_currency_discount_2; $item_currency_sale_unit_discount_2 = $item_currency_discount_2 / $sale_unit_equalance; $item_currency_production_unit_discount_2 = $item_currency_discount_2 / $production_unit_equalance; $purchase_unit_discount_amount_2 = $discount_amount_2; $sale_unit_discount_amount_2 = $discount_amount_2 / $sale_unit_equalance; $production_unit_discount_amount_2 = $discount_amount_2 / $production_unit_equalance; $item_currency_purchase_unit_discount_amount_2 = $item_currency_discount_amount_2; $item_currency_sale_unit_discount_amount_2 = $item_currency_discount_amount_2 / $sale_unit_equalance; $item_currency_production_unit_discount_amount_2 = $item_currency_discount_amount_2 / $production_unit_equalance; } else if($entry_item['unit'] == 'sale') { $purchase_unit_qty = (float)$entry_item['qty'] / $sale_unit_equalance; $sale_unit_qty = (float)$entry_item['qty']; $production_unit_qty = (float)$entry_item['qty'] * $sale_unit_equalance; $purchase_bonus_qty = (float)$entry_item['bonus'] / $sale_unit_equalance; $sale_bonus_qty = (float)$entry_item['bonus']; $production_bonus_qty = (float)$entry_item['bonus'] * $sale_unit_equalance; $purchase_unit_cost = (float)$entry_item['cost'] * $sale_unit_equalance; $sale_unit_cost = (float)$entry_item['cost']; $production_unit_cost = (float)$entry_item['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost * $sale_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost; $item_currency_production_unit_cost = $item_currency_cost / $sale_unit_equalance; $purchase_unit_real_cost = (float)$entry_item['cost'] * $sale_unit_equalance; $sale_unit_real_cost = (float)$entry_item['cost']; $production_unit_real_cost = (float)$entry_item['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $sale_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost; $item_currency_production_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $purchase_unit_profit = (float)$entry_item['profit'] * $sale_unit_equalance; $sale_unit_profit = (float)$entry_item['profit']; $production_unit_profit = (float)$entry_item['profit'] / $sale_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit * $sale_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit; $item_currency_production_unit_profit = $item_currency_profit / $sale_unit_equalance; $purchase_unit_sale_price = (float)$entry_item['sale_price'] * $sale_unit_equalance; $sale_unit_sale_price = (float)$entry_item['sale_price']; $production_unit_sale_price = (float)$entry_item['sale_price'] / $sale_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $sale_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price; $item_currency_production_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $purchase_unit_discount = (float)$entry_item['discount'] * $sale_unit_equalance; $sale_unit_discount = (float)$entry_item['discount']; $production_unit_discount = (float)$entry_item['discount'] / $sale_unit_equalance; $item_currency_purchase_unit_discount = $item_currency_discount * $sale_unit_equalance; $item_currency_sale_unit_discount = $item_currency_discount * $sale_unit_equalance; $item_currency_production_unit_discount = $item_currency_discount / $sale_unit_equalance; $purchase_unit_discount_amount = $discount_amount * $sale_unit_equalance; $sale_unit_discount_amount = $discount_amount; $production_unit_discount_amount = $discount_amount / $sale_unit_equalance; $item_currency_purchase_unit_discount_amount = $item_currency_discount_amount * $sale_unit_equalance; $item_currency_sale_unit_discount_amount = $item_currency_discount_amount; $item_currency_production_unit_discount_amount = $item_currency_discount_amount / $sale_unit_equalance; $purchase_unit_discount_2 = (float)$entry_item['discount_2'] * $sale_unit_equalance; $sale_unit_discount_2 = (float)$entry_item['discount_2']; $production_unit_discount_2 = (float)$entry_item['discount_2'] / $sale_unit_equalance; $item_currency_purchase_unit_discount_2 = $item_currency_discount_2 * $sale_unit_equalance; $item_currency_sale_unit_discount_2 = $item_currency_discount_2 * $sale_unit_equalance; $item_currency_production_unit_discount_2 = $item_currency_discount_2 / $sale_unit_equalance; $purchase_unit_discount_amount_2 = $discount_amount_2 * $sale_unit_equalance; $sale_unit_discount_amount_2 = $discount_amount_2; $production_unit_discount_amount_2 = $discount_amount_2 / $sale_unit_equalance; $item_currency_purchase_unit_discount_amount_2 = $item_currency_discount_amount_2 * $sale_unit_equalance; $item_currency_sale_unit_discount_amount_2 = $item_currency_discount_amount_2; $item_currency_production_unit_discount_amount_2 = $item_currency_discount_amount_2 / $sale_unit_equalance; } else { $purchase_unit_qty = (float)$entry_item['qty'] / $production_unit_equalance; $sale_unit_qty = (float)$entry_item['qty'] / $production_unit_equalance; $production_unit_qty = (float)$entry_item['qty']; $purchase_bonus_qty = (float)$entry_item['bonus'] / $production_unit_equalance; $sale_bonus_qty = (float)$entry_item['bonus'] / $production_unit_equalance; $production_bonus_qty = (float)$entry_item['bonus']; $purchase_unit_cost = (float)$entry_item['cost'] * $production_unit_equalance; $sale_unit_cost = (float)$entry_item['cost'] * $production_unit_equalance; $production_unit_cost = (float)$entry_item['cost']; $item_currency_purchase_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost; $purchase_unit_real_cost = (float)$entry_item['cost'] * $production_unit_equalance; $sale_unit_real_cost = (float)$entry_item['cost'] * $production_unit_equalance; $production_unit_real_cost = (float)$entry_item['cost']; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost; $purchase_unit_profit = (float)$entry_item['profit'] * $production_unit_equalance; $sale_unit_profit = (float)$entry_item['profit'] * $production_unit_equalance; $production_unit_profit = (float)$entry_item['profit']; $item_currency_purchase_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit; $purchase_unit_sale_price = (float)$entry_item['sale_price'] * $production_unit_equalance; $sale_unit_sale_price = (float)$entry_item['sale_price'] * $production_unit_equalance; $production_unit_sale_price = (float)$entry_item['sale_price']; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price; $purchase_unit_discount = (float)$entry_item['discount'] * $production_unit_equalance; $sale_unit_discount = (float)$entry_item['discount'] * $production_unit_equalance; $production_unit_discount = (float)$entry_item['discount']; $item_currency_purchase_unit_discount = $item_currency_discount * $production_unit_equalance; $item_currency_sale_unit_discount = $item_currency_discount * $production_unit_equalance * $production_unit_equalance; $item_currency_production_unit_discount = $item_currency_discount; $purchase_unit_discount_amount = $discount_amount * $production_unit_equalance; $sale_unit_discount_amount = $discount_amount * $production_unit_equalance; $production_unit_discount_amount = $discount_amount; $item_currency_purchase_unit_discount_amount = $item_currency_discount_amount * $production_unit_equalance; $item_currency_sale_unit_discount_amount = $item_currency_discount_amount * $production_unit_equalance; $item_currency_production_unit_discount_amount = $item_currency_discount_amount; $purchase_unit_discount_2 = (float)$entry_item['discount_2'] * $production_unit_equalance; $sale_unit_discount_2 = (float)$entry_item['discount_2'] * $production_unit_equalance; $production_unit_discount_2 = (float)$entry_item['discount_2']; $item_currency_purchase_unit_discount_2 = $item_currency_discount_2 * $production_unit_equalance; $item_currency_sale_unit_discount_2 = $item_currency_discount_2 * $production_unit_equalance * $production_unit_equalance; $item_currency_production_unit_discount_2 = $item_currency_discount_2; $purchase_unit_discount_amount_2 = $discount_amount_2 * $production_unit_equalance; $sale_unit_discount_amount_2 = $discount_amount_2 * $production_unit_equalance; $production_unit_discount_amount_2 = $discount_amount_2; $item_currency_purchase_unit_discount_amount_2 = $item_currency_discount_amount_2 * $production_unit_equalance; $item_currency_sale_unit_discount_amount_2 = $item_currency_discount_amount_2 * $production_unit_equalance; $item_currency_production_unit_discount_amount_2 = $item_currency_discount_amount_2; } $inventory_array = [ 'uid' => getUniqueId('ITINT', 'items_inventory_stats', 'uid'), 'branch' => $db_entry['branch'], 'event_date' => $db_entry['created_at'], 'item' => $item_data['uid'], 'item_name' => $item_data['name'], 'item_category' => $item_data['category'], 'item_type' => $item_data['type'], 'account' => $account_data['uid'], 'account_name' => $account_data['name'], 'warehouse' => $warehouse_data['uid'], 'warehouse_name' => $warehouse_data['name'], 'batch' => $entry_item['batch'], 'invoice' => $db_entry['invoice'], 'module_uid' => $db_entry['uid'], 'module_name' => 'sales', 'purchase_unit_stock_out' => $purchase_unit_qty, 'sale_unit_stock_out' => $sale_unit_qty, 'production_unit_stock_out' => $production_unit_qty, 'purchase_unit_bonus_out' => $purchase_bonus_qty, 'sale_unit_bonus_out' => $sale_bonus_qty, 'production_unit_bonus_out' => $production_bonus_qty, 'currency' => $currency_data['uid'], 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'currency_usd_equalance' => $currency_data['usd_equalance'], 'item_currency' => $item_currency_data['uid'], 'item_currency_name' => $item_currency_data['name'], 'item_currency_symbol' => $item_currency_data['symbol'], 'item_currency_usd_equalance' => $item_currency_data['usd_equalance'], 'purchase_unit_cost' => $purchase_unit_cost, 'sale_unit_cost' => $sale_unit_cost, 'production_unit_cost' => $production_unit_cost, 'item_currency_purchase_unit_cost' => $item_currency_purchase_unit_cost, 'item_currency_sale_unit_cost' => $item_currency_sale_unit_cost, 'item_currency_production_unit_cost' => $item_currency_production_unit_cost, 'purchase_unit_real_cost' => $purchase_unit_real_cost, 'sale_unit_real_cost' => $sale_unit_real_cost, 'production_unit_real_cost' => $production_unit_real_cost, 'item_currency_purchase_unit_real_cost' => $item_currency_purchase_unit_real_cost, 'item_currency_sale_unit_real_cost' => $item_currency_sale_unit_real_cost, 'item_currency_production_unit_real_cost' => $item_currency_production_unit_real_cost, 'purchase_unit_profit' => $purchase_unit_profit, 'sale_unit_profit' => $sale_unit_profit, 'production_unit_profit' => $production_unit_profit, 'item_currency_purchase_unit_profit' => $item_currency_purchase_unit_profit, 'item_currency_sale_unit_profit' => $item_currency_sale_unit_profit, 'item_currency_production_unit_profit' => $item_currency_production_unit_profit, 'purchase_unit_sale_price' => $purchase_unit_sale_price, 'sale_unit_sale_price' => $sale_unit_sale_price, 'production_unit_sale_price' => $production_unit_sale_price, 'item_currency_purchase_unit_sale_price' => $item_currency_purchase_unit_sale_price, 'item_currency_sale_unit_sale_price' => $item_currency_sale_unit_sale_price, 'item_currency_production_unit_sale_price' => $item_currency_production_unit_sale_price, 'purchase_unit_discount' => $purchase_unit_discount, 'sale_unit_discount' => $sale_unit_discount, 'production_unit_discount' => $production_unit_discount, 'item_currency_purchase_unit_discount' => $item_currency_purchase_unit_discount, 'item_currency_sale_unit_discount' => $item_currency_sale_unit_discount, 'item_currency_production_unit_discount' => $item_currency_production_unit_discount, 'purchase_unit_discount_amount' => $purchase_unit_discount_amount, 'sale_unit_discount_amount' => $sale_unit_discount_amount, 'production_unit_discount_amount' => $production_unit_discount_amount, 'item_currency_purchase_unit_discount_amount' => $item_currency_purchase_unit_discount_amount, 'item_currency_sale_unit_discount_amount' => $item_currency_sale_unit_discount_amount, 'item_currency_production_unit_discount_amount' => $item_currency_production_unit_discount_amount, 'purchase_unit_discount_2' => $purchase_unit_discount_2, 'sale_unit_discount_2' => $sale_unit_discount_2, 'production_unit_discount_2' => $production_unit_discount_2, 'item_currency_purchase_unit_discount_2' => $item_currency_purchase_unit_discount_2, 'item_currency_sale_unit_discount_2' => $item_currency_sale_unit_discount_2, 'item_currency_production_unit_discount_2' => $item_currency_production_unit_discount_2, 'purchase_unit_discount_amount_2' => $purchase_unit_discount_amount_2, 'sale_unit_discount_amount_2' => $sale_unit_discount_amount_2, 'production_unit_discount_amount_2' => $production_unit_discount_amount_2, 'item_currency_purchase_unit_discount_amount_2' => $item_currency_purchase_unit_discount_amount_2, 'item_currency_sale_unit_discount_amount_2' => $item_currency_sale_unit_discount_amount_2, 'item_currency_production_unit_discount_amount_2' => $item_currency_production_unit_discount_amount_2, 'bundle_stock_out' => $entry_item['bundle'], 'toop_stock_out' => $entry_item['toop'], 'mfg' => $entry_item['mfg'], 'expiry' => $entry_item['expiry'], 'token_rate' => (float)$item_data['token_rate'], 'item_token_out' => isset($entry_item['item_token']) ? $entry_item['item_token'] : null, ]; insert_table('items_inventory_stats',$inventory_array); _calculate_item_wise_stats(['item' => $inventory_array['item']]); } } } } } } function _handle_items_inventory_stats_from_sales_return($sources) { $uid = $sources['uid']; $entry_status = $sources['entry_status']; $db_entry = fetch_table_where('sales_return','uid',$uid,TRUE); if($entry_status == 'update' OR $entry_status == 'delete') { delete_table('items_inventory_stats','module_uid',$uid); } if($entry_status == 'new' OR $entry_status == 'update') { if(!empty($db_entry)) { $account_data = fetch_table_where('accounts','uid',$db_entry['client'],TRUE); $sale_items_db = json_decode($db_entry['items_details'],true); if(!empty($sale_items_db)) { foreach($sale_items_db as $entry_item) { $item_data = fetch_table_where('items','uid',$entry_item['item'],TRUE); $item_currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $currency_data = fetch_table_where('currency','uid',$db_entry['currency'],TRUE); $warehouse_data = fetch_table_where('warehouse','uid',$entry_item['warehouse'],TRUE); $sale_unit_equalance = (float)$item_data['sale_unit_equalance']; if($sale_unit_equalance == 0){ $sale_unit_equalance = 1; } $production_unit_equalance = (float)$item_data['production_unit_equalance']; if($production_unit_equalance == 0){ $production_unit_equalance = 1; } $item_currency = $item_data['currency']; $item_currency_usd_equalance = $item_data['currency_usd_equalance']; $item_currency_cost = (float)$entry_item['cost']; $item_currency_real_cost = (float)$entry_item['cost']; $item_currency_profit = (float)$entry_item['profit']; $item_currency_sale_price = (float)$entry_item['sale_price']; $item_currency_discount = (float)$entry_item['discount']; $item_currency_discount_amount = ($item_currency_sale_price * $item_currency_discount) / 100; $item_currency_discount_2 = (float)$entry_item['discount_2']; $item_currency_discount_amount_2 = (($item_currency_sale_price - $item_currency_discount_amount) * $item_currency_discount_2) / 100; $discount_amount = $item_currency_discount_amount; $discount_amount_2 = $item_currency_discount_amount_2; if($item_currency != $db_entry['currency']) { $item_currency_cost = amount_conversion((float)$entry_item['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_real_cost = amount_conversion((float)$entry_item['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_profit = amount_conversion((float)$entry_item['profit'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_sale_price = amount_conversion((float)$entry_item['sale_price'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_discount = amount_conversion($item_currency_discount, $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_discount_amount = amount_conversion($item_currency_discount_amount, $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_discount_2 = amount_conversion($item_currency_discount_2, $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_discount_amount_2 = amount_conversion($item_currency_discount_amount_2, $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); } if($entry_item['unit'] == 'purchase') { $purchase_unit_qty = (float)$entry_item['r_qty']; $sale_unit_qty = (float)$entry_item['r_qty'] * $sale_unit_equalance; $production_unit_qty = (float)$entry_item['r_qty'] * $production_unit_equalance; $purchase_bonus_qty = (float)$entry_item['r_bonus']; $sale_bonus_qty = (float)$entry_item['r_bonus'] * $sale_unit_equalance; $production_bonus_qty = (float)$entry_item['r_bonus'] * $production_unit_equalance; $purchase_unit_cost = (float)$entry_item['cost']; $sale_unit_cost = (float)$entry_item['cost'] / $sale_unit_equalance; $production_unit_cost = (float)$entry_item['cost'] / $production_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost; $item_currency_sale_unit_cost = $item_currency_cost / $sale_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost / $production_unit_equalance; $purchase_unit_real_cost = (float)$entry_item['cost']; $sale_unit_real_cost = (float)$entry_item['cost'] / $sale_unit_equalance; $production_unit_real_cost = (float)$entry_item['cost'] / $production_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost; $item_currency_sale_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost / $production_unit_equalance; $purchase_unit_profit = (float)$entry_item['profit']; $sale_unit_profit = (float)$entry_item['profit'] / $sale_unit_equalance; $production_unit_profit = (float)$entry_item['profit'] / $production_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit; $item_currency_sale_unit_profit = $item_currency_profit / $sale_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit / $production_unit_equalance; $purchase_unit_sale_price = (float)$entry_item['sale_price']; $sale_unit_sale_price = (float)$entry_item['sale_price'] / $sale_unit_equalance; $production_unit_sale_price = (float)$entry_item['sale_price'] / $production_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price; $item_currency_sale_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price / $production_unit_equalance; $purchase_unit_discount = (float)$entry_item['discount']; $sale_unit_discount = (float)$entry_item['discount'] / $sale_unit_equalance; $production_unit_discount = (float)$entry_item['discount'] / $production_unit_equalance; $item_currency_purchase_unit_discount = $item_currency_discount; $item_currency_sale_unit_discount = $item_currency_discount / $sale_unit_equalance; $item_currency_production_unit_discount = $item_currency_discount / $production_unit_equalance; $purchase_unit_discount_amount = $discount_amount; $sale_unit_discount_amount = $discount_amount / $sale_unit_equalance; $production_unit_discount_amount = $discount_amount / $production_unit_equalance; $item_currency_purchase_unit_discount_amount = $item_currency_discount_amount; $item_currency_sale_unit_discount_amount = $item_currency_discount_amount / $sale_unit_equalance; $item_currency_production_unit_discount_amount = $item_currency_discount_amount / $production_unit_equalance; $purchase_unit_discount_2 = (float)$entry_item['discount_2']; $sale_unit_discount_2 = (float)$entry_item['discount_2'] / $sale_unit_equalance; $production_unit_discount_2 = (float)$entry_item['discount_2'] / $production_unit_equalance; $item_currency_purchase_unit_discount_2 = $item_currency_discount_2; $item_currency_sale_unit_discount_2 = $item_currency_discount_2 / $sale_unit_equalance; $item_currency_production_unit_discount_2 = $item_currency_discount_2 / $production_unit_equalance; $purchase_unit_discount_amount_2 = $discount_amount_2; $sale_unit_discount_amount_2 = $discount_amount_2 / $sale_unit_equalance; $production_unit_discount_amount_2 = $discount_amount_2 / $production_unit_equalance; $item_currency_purchase_unit_discount_amount_2 = $item_currency_discount_amount_2; $item_currency_sale_unit_discount_amount_2 = $item_currency_discount_amount_2 / $sale_unit_equalance; $item_currency_production_unit_discount_amount_2 = $item_currency_discount_amount_2 / $production_unit_equalance; } else if($entry_item['unit'] == 'sale') { $purchase_unit_qty = (float)$db_entry['r_qty'] / $sale_unit_equalance; $sale_unit_qty = (float)$db_entry['r_qty']; $production_unit_qty = (float)$db_entry['r_qty'] * $sale_unit_equalance; $purchase_bonus_qty = (float)$db_entry['r_bonus'] / $sale_unit_equalance; $sale_bonus_qty = (float)$db_entry['r_bonus']; $production_bonus_qty = (float)$db_entry['r_bonus'] * $sale_unit_equalance; $purchase_unit_cost = (float)$entry_item['cost'] * $sale_unit_equalance; $sale_unit_cost = (float)$entry_item['cost']; $production_unit_cost = (float)$entry_item['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost * $sale_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost; $item_currency_production_unit_cost = $item_currency_cost / $sale_unit_equalance; $purchase_unit_real_cost = (float)$entry_item['cost'] * $sale_unit_equalance; $sale_unit_real_cost = (float)$entry_item['cost']; $production_unit_real_cost = (float)$entry_item['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $sale_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost; $item_currency_production_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $purchase_unit_profit = (float)$entry_item['profit'] * $sale_unit_equalance; $sale_unit_profit = (float)$entry_item['profit']; $production_unit_profit = (float)$entry_item['profit'] / $sale_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit * $sale_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit; $item_currency_production_unit_profit = $item_currency_profit / $sale_unit_equalance; $purchase_unit_sale_price = (float)$entry_item['sale_price'] * $sale_unit_equalance; $sale_unit_sale_price = (float)$entry_item['sale_price']; $production_unit_sale_price = (float)$entry_item['sale_price'] / $sale_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $sale_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price; $item_currency_production_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $purchase_unit_discount = (float)$entry_item['discount'] * $sale_unit_equalance; $sale_unit_discount = (float)$entry_item['discount']; $production_unit_discount = (float)$entry_item['discount'] / $sale_unit_equalance; $item_currency_purchase_unit_discount = $item_currency_discount * $sale_unit_equalance; $item_currency_sale_unit_discount = $item_currency_discount * $sale_unit_equalance; $item_currency_production_unit_discount = $item_currency_discount / $sale_unit_equalance; $purchase_unit_discount_amount = $discount_amount * $sale_unit_equalance; $sale_unit_discount_amount = $discount_amount; $production_unit_discount_amount = $discount_amount / $sale_unit_equalance; $item_currency_purchase_unit_discount_amount = $item_currency_discount_amount * $sale_unit_equalance; $item_currency_sale_unit_discount_amount = $item_currency_discount_amount; $item_currency_production_unit_discount_amount = $item_currency_discount_amount / $sale_unit_equalance; $purchase_unit_discount_2 = (float)$entry_item['discount_2'] * $sale_unit_equalance; $sale_unit_discount_2 = (float)$entry_item['discount_2']; $production_unit_discount_2 = (float)$entry_item['discount_2'] / $sale_unit_equalance; $item_currency_purchase_unit_discount_2 = $item_currency_discount_2 * $sale_unit_equalance; $item_currency_sale_unit_discount_2 = $item_currency_discount_2 * $sale_unit_equalance; $item_currency_production_unit_discount_2 = $item_currency_discount_2 / $sale_unit_equalance; $purchase_unit_discount_amount_2 = $discount_amount_2 * $sale_unit_equalance; $sale_unit_discount_amount_2 = $discount_amount_2; $production_unit_discount_amount_2 = $discount_amount_2 / $sale_unit_equalance; $item_currency_purchase_unit_discount_amount_2 = $item_currency_discount_amount_2 * $sale_unit_equalance; $item_currency_sale_unit_discount_amount_2 = $item_currency_discount_amount_2; $item_currency_production_unit_discount_amount_2 = $item_currency_discount_amount_2 / $sale_unit_equalance; } else { $purchase_unit_qty = (float)$db_entry['r_qty'] / $production_unit_equalance; $sale_unit_qty = (float)$db_entry['r_qty'] / $production_unit_equalance; $production_unit_qty = (float)$db_entry['r_qty']; $purchase_bonus_qty = (float)$db_entry['r_bonus'] / $production_unit_equalance; $sale_bonus_qty = (float)$db_entry['r_bonus'] / $production_unit_equalance; $production_bonus_qty = (float)$db_entry['r_bonus']; $purchase_unit_cost = (float)$entry_item['cost'] * $production_unit_equalance; $sale_unit_cost = (float)$entry_item['cost'] * $production_unit_equalance; $production_unit_cost = (float)$entry_item['cost']; $item_currency_purchase_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost; $purchase_unit_real_cost = (float)$entry_item['cost'] * $production_unit_equalance; $sale_unit_real_cost = (float)$entry_item['cost'] * $production_unit_equalance; $production_unit_real_cost = (float)$entry_item['cost']; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost; $purchase_unit_profit = (float)$entry_item['profit'] * $production_unit_equalance; $sale_unit_profit = (float)$entry_item['profit'] * $production_unit_equalance; $production_unit_profit = (float)$entry_item['profit']; $item_currency_purchase_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit; $purchase_unit_sale_price = (float)$entry_item['sale_price'] * $production_unit_equalance; $sale_unit_sale_price = (float)$entry_item['sale_price'] * $production_unit_equalance; $production_unit_sale_price = (float)$entry_item['sale_price']; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price; $purchase_unit_discount = (float)$entry_item['discount'] * $production_unit_equalance; $sale_unit_discount = (float)$entry_item['discount'] * $production_unit_equalance; $production_unit_discount = (float)$entry_item['discount']; $item_currency_purchase_unit_discount = $item_currency_discount * $production_unit_equalance; $item_currency_sale_unit_discount = $item_currency_discount * $production_unit_equalance * $production_unit_equalance; $item_currency_production_unit_discount = $item_currency_discount; $purchase_unit_discount_amount = $discount_amount * $production_unit_equalance; $sale_unit_discount_amount = $discount_amount * $production_unit_equalance; $production_unit_discount_amount = $discount_amount; $item_currency_purchase_unit_discount_amount = $item_currency_discount_amount * $production_unit_equalance; $item_currency_sale_unit_discount_amount = $item_currency_discount_amount * $production_unit_equalance; $item_currency_production_unit_discount_amount = $item_currency_discount_amount; $purchase_unit_discount_2 = (float)$entry_item['discount_2'] * $production_unit_equalance; $sale_unit_discount_2 = (float)$entry_item['discount_2'] * $production_unit_equalance; $production_unit_discount_2 = (float)$entry_item['discount_2']; $item_currency_purchase_unit_discount_2 = $item_currency_discount_2 * $production_unit_equalance; $item_currency_sale_unit_discount_2 = $item_currency_discount_2 * $production_unit_equalance * $production_unit_equalance; $item_currency_production_unit_discount_2 = $item_currency_discount_2; $purchase_unit_discount_amount_2 = $discount_amount_2 * $production_unit_equalance; $sale_unit_discount_amount_2 = $discount_amount_2 * $production_unit_equalance; $production_unit_discount_amount_2 = $discount_amount_2; $item_currency_purchase_unit_discount_amount_2 = $item_currency_discount_amount_2 * $production_unit_equalance; $item_currency_sale_unit_discount_amount_2 = $item_currency_discount_amount_2 * $production_unit_equalance; $item_currency_production_unit_discount_amount_2 = $item_currency_discount_amount_2; } $inventory_array = [ 'uid' => getUniqueId('ITINT', 'items_inventory_stats', 'uid'), 'branch' => $db_entry['branch'], 'event_date' => $db_entry['created_at'], 'item' => $item_data['uid'], 'item_name' => $item_data['name'], 'item_category' => $item_data['category'], 'item_type' => $item_data['type'], 'account' => $account_data['uid'], 'account_name' => $account_data['name'], 'warehouse' => $warehouse_data['uid'], 'warehouse_name' => $warehouse_data['name'], 'batch' => $entry_item['batch'], 'invoice' => $db_entry['return_invoice'], 'module_uid' => $db_entry['uid'], 'module_name' => 'sales_return', 'purchase_unit_stock_in' => $purchase_unit_qty, 'sale_unit_stock_in' => $sale_unit_qty, 'production_unit_stock_in' => $production_unit_qty, 'purchase_unit_bonus_in' => $purchase_bonus_qty, 'sale_unit_bonus_in' => $sale_bonus_qty, 'production_unit_bonus_in' => $production_bonus_qty, 'currency' => $currency_data['uid'], 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'currency_usd_equalance' => $currency_data['usd_equalance'], 'item_currency' => $item_currency_data['uid'], 'item_currency_name' => $item_currency_data['name'], 'item_currency_symbol' => $item_currency_data['symbol'], 'item_currency_usd_equalance' => $item_currency_data['usd_equalance'], 'purchase_unit_cost' => $purchase_unit_cost, 'sale_unit_cost' => $sale_unit_cost, 'production_unit_cost' => $production_unit_cost, 'item_currency_purchase_unit_cost' => $item_currency_purchase_unit_cost, 'item_currency_sale_unit_cost' => $item_currency_sale_unit_cost, 'item_currency_production_unit_cost' => $item_currency_production_unit_cost, 'purchase_unit_real_cost' => $purchase_unit_real_cost, 'sale_unit_real_cost' => $sale_unit_real_cost, 'production_unit_real_cost' => $production_unit_real_cost, 'item_currency_purchase_unit_real_cost' => $item_currency_purchase_unit_real_cost, 'item_currency_sale_unit_real_cost' => $item_currency_sale_unit_real_cost, 'item_currency_production_unit_real_cost' => $item_currency_production_unit_real_cost, 'purchase_unit_profit' => $purchase_unit_profit, 'sale_unit_profit' => $sale_unit_profit, 'production_unit_profit' => $production_unit_profit, 'item_currency_purchase_unit_profit' => $item_currency_purchase_unit_profit, 'item_currency_sale_unit_profit' => $item_currency_sale_unit_profit, 'item_currency_production_unit_profit' => $item_currency_production_unit_profit, 'purchase_unit_sale_price' => $purchase_unit_sale_price, 'sale_unit_sale_price' => $sale_unit_sale_price, 'production_unit_sale_price' => $production_unit_sale_price, 'item_currency_purchase_unit_sale_price' => $item_currency_purchase_unit_sale_price, 'item_currency_sale_unit_sale_price' => $item_currency_sale_unit_sale_price, 'item_currency_production_unit_sale_price' => $item_currency_production_unit_sale_price, 'purchase_unit_discount' => $purchase_unit_discount, 'sale_unit_discount' => $sale_unit_discount, 'production_unit_discount' => $production_unit_discount, 'item_currency_purchase_unit_discount' => $item_currency_purchase_unit_discount, 'item_currency_sale_unit_discount' => $item_currency_sale_unit_discount, 'item_currency_production_unit_discount' => $item_currency_production_unit_discount, 'purchase_unit_discount_amount' => $purchase_unit_discount_amount, 'sale_unit_discount_amount' => $sale_unit_discount_amount, 'production_unit_discount_amount' => $production_unit_discount_amount, 'item_currency_purchase_unit_discount_amount' => $item_currency_purchase_unit_discount_amount, 'item_currency_sale_unit_discount_amount' => $item_currency_sale_unit_discount_amount, 'item_currency_production_unit_discount_amount' => $item_currency_production_unit_discount_amount, 'purchase_unit_discount_2' => $purchase_unit_discount_2, 'sale_unit_discount_2' => $sale_unit_discount_2, 'production_unit_discount_2' => $production_unit_discount_2, 'item_currency_purchase_unit_discount_2' => $item_currency_purchase_unit_discount_2, 'item_currency_sale_unit_discount_2' => $item_currency_sale_unit_discount_2, 'item_currency_production_unit_discount_2' => $item_currency_production_unit_discount_2, 'purchase_unit_discount_amount_2' => $purchase_unit_discount_amount_2, 'sale_unit_discount_amount_2' => $sale_unit_discount_amount_2, 'production_unit_discount_amount_2' => $production_unit_discount_amount_2, 'item_currency_purchase_unit_discount_amount_2' => $item_currency_purchase_unit_discount_amount_2, 'item_currency_sale_unit_discount_amount_2' => $item_currency_sale_unit_discount_amount_2, 'item_currency_production_unit_discount_amount_2' => $item_currency_production_unit_discount_amount_2, ]; insert_table('items_inventory_stats',$inventory_array); _calculate_item_wise_stats(['item' => $inventory_array['item']]); } } } } } function _handle_items_inventory_stats_from_damage($sources) { $uid = $sources['uid']; $entry_status = $sources['entry_status']; $db_entry = fetch_table_where('damage','uid',$uid,TRUE); if($entry_status == 'update' OR $entry_status == 'delete') { delete_table('items_inventory_stats','module_uid',$uid); } if($entry_status == 'new' OR $entry_status == 'update') { if(!empty($db_entry)) { $item_data = fetch_table_where('items','uid',$db_entry['item'],TRUE); $item_currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $warehouse_data = fetch_table_where('warehouse','uid',$db_entry['warehouse'],TRUE); $sale_unit_equalance = (float)$item_data['sale_unit_equalance']; if($sale_unit_equalance == 0){ $sale_unit_equalance = 1; } $production_unit_equalance = (float)$item_data['production_unit_equalance']; if($production_unit_equalance == 0){ $production_unit_equalance = 1; } $item_currency = $item_data['currency']; $item_currency_usd_equalance = $item_data['currency_usd_equalance']; $item_currency_cost = (float)$db_entry['cost']; $item_currency_real_cost = (float)$db_entry['cost']; $item_currency_profit = (float)$db_entry['cost']; $item_currency_sale_price = (float)$db_entry['cost']; if($item_currency != $db_entry['currency']) { $item_currency_cost = amount_conversion((float)$db_entry['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_real_cost = amount_conversion((float)$db_entry['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_profit = amount_conversion((float)$db_entry['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_sale_price = amount_conversion((float)$db_entry['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); } if($db_entry['unit'] == 'purchase') { $purchase_unit_qty = (float)$db_entry['qty']; $sale_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $production_unit_qty = (float)$db_entry['qty'] * $production_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost']; $sale_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost; $item_currency_sale_unit_cost = $item_currency_cost / $sale_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost / $production_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['cost']; $sale_unit_real_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_real_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost; $item_currency_sale_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost / $production_unit_equalance; $purchase_unit_profit = (float)$db_entry['cost']; $sale_unit_profit = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_profit = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit; $item_currency_sale_unit_profit = $item_currency_profit / $sale_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit / $production_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['cost']; $sale_unit_sale_price = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_sale_price = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price; $item_currency_sale_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price / $production_unit_equalance; } else if($db_entry['unit'] == 'sale') { $purchase_unit_qty = (float)$db_entry['qty'] / $sale_unit_equalance; $sale_unit_qty = (float)$db_entry['qty']; $production_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_cost = (float)$db_entry['cost']; $production_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost * $sale_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost; $item_currency_production_unit_cost = $item_currency_cost / $sale_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_real_cost = (float)$db_entry['cost']; $production_unit_real_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $sale_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost; $item_currency_production_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $purchase_unit_profit = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_profit = (float)$db_entry['cost']; $production_unit_profit = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit * $sale_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit; $item_currency_production_unit_profit = $item_currency_profit / $sale_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_sale_price = (float)$db_entry['cost']; $production_unit_sale_price = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $sale_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price; $item_currency_production_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; } else { $purchase_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $sale_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $production_unit_qty = (float)$db_entry['qty']; $purchase_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost; $purchase_unit_real_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_real_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_real_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost; $purchase_unit_profit = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_profit = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_profit = (float)$db_entry['cost']; $item_currency_purchase_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit; $purchase_unit_sale_price = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_sale_price = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_sale_price = (float)$db_entry['cost']; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price; } $inventory_array = [ 'uid' => getUniqueId('ITINT', 'items_inventory_stats', 'uid'), 'branch' => $db_entry['branch'], 'event_date' => $db_entry['created_at'], 'item' => $item_data['uid'], 'item_name' => $item_data['name'], 'item_category' => $item_data['category'], 'item_type' => $item_data['type'], 'warehouse' => $warehouse_data['uid'], 'warehouse_name' => $warehouse_data['name'], 'batch' => $db_entry['batch'], 'module_uid' => $db_entry['uid'], 'module_name' => 'damage', 'purchase_unit_stock_out' => $purchase_unit_qty, 'sale_unit_stock_out' => $sale_unit_qty, 'production_unit_stock_out' => $production_unit_qty, 'currency' => $currency_data['uid'], 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'currency_usd_equalance' => $currency_data['usd_equalance'], 'item_currency' => $item_currency_data['uid'], 'item_currency_name' => $item_currency_data['name'], 'item_currency_symbol' => $item_currency_data['symbol'], 'item_currency_usd_equalance' => $item_currency_data['usd_equalance'], 'purchase_unit_cost' => $purchase_unit_cost, 'sale_unit_cost' => $sale_unit_cost, 'production_unit_cost' => $production_unit_cost, 'item_currency_purchase_unit_cost' => $item_currency_purchase_unit_cost, 'item_currency_sale_unit_cost' => $item_currency_sale_unit_cost, 'item_currency_production_unit_cost' => $item_currency_production_unit_cost, 'purchase_unit_real_cost' => $purchase_unit_real_cost, 'sale_unit_real_cost' => $sale_unit_real_cost, 'production_unit_real_cost' => $production_unit_real_cost, 'item_currency_purchase_unit_real_cost' => $item_currency_purchase_unit_real_cost, 'item_currency_sale_unit_real_cost' => $item_currency_sale_unit_real_cost, 'item_currency_production_unit_real_cost' => $item_currency_production_unit_real_cost, 'purchase_unit_profit' => $purchase_unit_profit, 'sale_unit_profit' => $sale_unit_profit, 'production_unit_profit' => $production_unit_profit, 'item_currency_purchase_unit_profit' => $item_currency_purchase_unit_profit, 'item_currency_sale_unit_profit' => $item_currency_sale_unit_profit, 'item_currency_production_unit_profit' => $item_currency_production_unit_profit, 'purchase_unit_sale_price' => $purchase_unit_sale_price, 'sale_unit_sale_price' => $sale_unit_sale_price, 'production_unit_sale_price' => $production_unit_sale_price, 'item_currency_purchase_unit_sale_price' => $item_currency_purchase_unit_sale_price, 'item_currency_sale_unit_sale_price' => $item_currency_sale_unit_sale_price, 'item_currency_production_unit_sale_price' => $item_currency_production_unit_sale_price, ]; insert_table('items_inventory_stats',$inventory_array); _calculate_item_wise_stats(['item' => $inventory_array['item']]); } } } function _handle_items_inventory_stats_from_transfer_in($sources) { $uid = $sources['uid']; $entry_status = $sources['entry_status']; $db_entry = fetch_table_where('transfer_in','uid',$uid,TRUE); if($entry_status == 'update' OR $entry_status == 'delete') { delete_table('items_inventory_stats','module_uid',$uid); } if($entry_status == 'new' OR $entry_status == 'update') { if(!empty($db_entry)) { $account_data = fetch_table_where('accounts','uid',$db_entry['client'],TRUE); $transfer_in_items_db = json_decode($db_entry['items'],true); if(!empty($transfer_in_items_db)) { foreach($transfer_in_items_db as $entry_item) { $item_data = fetch_table_where('items','uid',$entry_item['item'],TRUE); $item_currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $currency_data = fetch_table_where('currency','uid',$db_entry['currency'],TRUE); $warehouse_data = fetch_table_where('warehouse','uid',$entry_item['warehouse'],TRUE); $sale_unit_equalance = (float)$item_data['sale_unit_equalance']; if($sale_unit_equalance == 0){ $sale_unit_equalance = 1; } $production_unit_equalance = (float)$item_data['production_unit_equalance']; if($production_unit_equalance == 0){ $production_unit_equalance = 1; } $item_currency = $item_data['currency']; $item_currency_usd_equalance = $item_data['currency_usd_equalance']; $item_currency_cost = (float)$entry_item['cost']; $item_currency_real_cost = (float)$entry_item['cost']; $item_currency_profit = (float)$entry_item['profit']; $item_currency_sale_price = (float)$entry_item['sale_price']; $item_currency_discount = (float)$entry_item['discount']; $item_currency_discount_amount = ($item_currency_sale_price * $item_currency_discount) / 100; $item_currency_discount_2 = (float)$entry_item['discount_2']; $item_currency_discount_amount_2 = (($item_currency_sale_price - $item_currency_discount_amount) * $item_currency_discount_2) / 100; $discount_amount = $item_currency_discount_amount; $discount_amount_2 = $item_currency_discount_amount_2; if($item_currency != $db_entry['currency']) { $item_currency_cost = amount_conversion((float)$entry_item['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_real_cost = amount_conversion((float)$entry_item['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_profit = amount_conversion((float)$entry_item['profit'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_sale_price = amount_conversion((float)$entry_item['sale_price'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_discount = amount_conversion($item_currency_discount, $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_discount_amount = amount_conversion($item_currency_discount_amount, $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_discount_2 = amount_conversion($item_currency_discount_2, $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_discount_amount_2 = amount_conversion($item_currency_discount_amount_2, $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); } if($entry_item['unit'] == 'purchase') { $purchase_unit_qty = (float)$entry_item['qty']; $sale_unit_qty = (float)$entry_item['qty'] * $sale_unit_equalance; $production_unit_qty = (float)$entry_item['qty'] * $production_unit_equalance; $purchase_bonus_qty = (float)$entry_item['bonus']; $sale_bonus_qty = (float)$entry_item['bonus'] * $sale_unit_equalance; $production_bonus_qty = (float)$entry_item['bonus'] * $production_unit_equalance; $purchase_unit_cost = (float)$entry_item['cost']; $sale_unit_cost = (float)$entry_item['cost'] / $sale_unit_equalance; $production_unit_cost = (float)$entry_item['cost'] / $production_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost; $item_currency_sale_unit_cost = $item_currency_cost / $sale_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost / $production_unit_equalance; $purchase_unit_real_cost = (float)$entry_item['cost']; $sale_unit_real_cost = (float)$entry_item['cost'] / $sale_unit_equalance; $production_unit_real_cost = (float)$entry_item['cost'] / $production_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost; $item_currency_sale_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost / $production_unit_equalance; $purchase_unit_profit = (float)$entry_item['profit']; $sale_unit_profit = (float)$entry_item['profit'] / $sale_unit_equalance; $production_unit_profit = (float)$entry_item['profit'] / $production_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit; $item_currency_sale_unit_profit = $item_currency_profit / $sale_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit / $production_unit_equalance; $purchase_unit_sale_price = (float)$entry_item['sale_price']; $sale_unit_sale_price = (float)$entry_item['sale_price'] / $sale_unit_equalance; $production_unit_sale_price = (float)$entry_item['sale_price'] / $production_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price; $item_currency_sale_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price / $production_unit_equalance; $purchase_unit_discount = (float)$entry_item['discount']; $sale_unit_discount = (float)$entry_item['discount'] / $sale_unit_equalance; $production_unit_discount = (float)$entry_item['discount'] / $production_unit_equalance; $item_currency_purchase_unit_discount = $item_currency_discount; $item_currency_sale_unit_discount = $item_currency_discount / $sale_unit_equalance; $item_currency_production_unit_discount = $item_currency_discount / $production_unit_equalance; $purchase_unit_discount_amount = $discount_amount; $sale_unit_discount_amount = $discount_amount / $sale_unit_equalance; $production_unit_discount_amount = $discount_amount / $production_unit_equalance; $item_currency_purchase_unit_discount_amount = $item_currency_discount_amount; $item_currency_sale_unit_discount_amount = $item_currency_discount_amount / $sale_unit_equalance; $item_currency_production_unit_discount_amount = $item_currency_discount_amount / $production_unit_equalance; $purchase_unit_discount_2 = (float)$entry_item['discount_2']; $sale_unit_discount_2 = (float)$entry_item['discount_2'] / $sale_unit_equalance; $production_unit_discount_2 = (float)$entry_item['discount_2'] / $production_unit_equalance; $item_currency_purchase_unit_discount_2 = $item_currency_discount_2; $item_currency_sale_unit_discount_2 = $item_currency_discount_2 / $sale_unit_equalance; $item_currency_production_unit_discount_2 = $item_currency_discount_2 / $production_unit_equalance; $purchase_unit_discount_amount_2 = $discount_amount_2; $sale_unit_discount_amount_2 = $discount_amount_2 / $sale_unit_equalance; $production_unit_discount_amount_2 = $discount_amount_2 / $production_unit_equalance; $item_currency_purchase_unit_discount_amount_2 = $item_currency_discount_amount_2; $item_currency_sale_unit_discount_amount_2 = $item_currency_discount_amount_2 / $sale_unit_equalance; $item_currency_production_unit_discount_amount_2 = $item_currency_discount_amount_2 / $production_unit_equalance; } else if($entry_item['unit'] == 'sale') { $purchase_unit_qty = (float)$entry_item['qty'] / $sale_unit_equalance; $sale_unit_qty = (float)$entry_item['qty']; $production_unit_qty = (float)$entry_item['qty'] * $sale_unit_equalance; $purchase_bonus_qty = (float)$entry_item['bonus'] / $sale_unit_equalance; $sale_bonus_qty = (float)$entry_item['bonus']; $production_bonus_qty = (float)$entry_item['bonus'] * $sale_unit_equalance; $purchase_unit_cost = (float)$entry_item['cost'] * $sale_unit_equalance; $sale_unit_cost = (float)$entry_item['cost']; $production_unit_cost = (float)$entry_item['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost * $sale_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost; $item_currency_production_unit_cost = $item_currency_cost / $sale_unit_equalance; $purchase_unit_real_cost = (float)$entry_item['cost'] * $sale_unit_equalance; $sale_unit_real_cost = (float)$entry_item['cost']; $production_unit_real_cost = (float)$entry_item['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $sale_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost; $item_currency_production_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $purchase_unit_profit = (float)$entry_item['profit'] * $sale_unit_equalance; $sale_unit_profit = (float)$entry_item['profit']; $production_unit_profit = (float)$entry_item['profit'] / $sale_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit * $sale_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit; $item_currency_production_unit_profit = $item_currency_profit / $sale_unit_equalance; $purchase_unit_sale_price = (float)$entry_item['sale_price'] * $sale_unit_equalance; $sale_unit_sale_price = (float)$entry_item['sale_price']; $production_unit_sale_price = (float)$entry_item['sale_price'] / $sale_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $sale_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price; $item_currency_production_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $purchase_unit_discount = (float)$entry_item['discount'] * $sale_unit_equalance; $sale_unit_discount = (float)$entry_item['discount']; $production_unit_discount = (float)$entry_item['discount'] / $sale_unit_equalance; $item_currency_purchase_unit_discount = $item_currency_discount * $sale_unit_equalance; $item_currency_sale_unit_discount = $item_currency_discount * $sale_unit_equalance; $item_currency_production_unit_discount = $item_currency_discount / $sale_unit_equalance; $purchase_unit_discount_amount = $discount_amount * $sale_unit_equalance; $sale_unit_discount_amount = $discount_amount; $production_unit_discount_amount = $discount_amount / $sale_unit_equalance; $item_currency_purchase_unit_discount_amount = $item_currency_discount_amount * $sale_unit_equalance; $item_currency_sale_unit_discount_amount = $item_currency_discount_amount; $item_currency_production_unit_discount_amount = $item_currency_discount_amount / $sale_unit_equalance; $purchase_unit_discount_2 = (float)$entry_item['discount_2'] * $sale_unit_equalance; $sale_unit_discount_2 = (float)$entry_item['discount_2']; $production_unit_discount_2 = (float)$entry_item['discount_2'] / $sale_unit_equalance; $item_currency_purchase_unit_discount_2 = $item_currency_discount_2 * $sale_unit_equalance; $item_currency_sale_unit_discount_2 = $item_currency_discount_2 * $sale_unit_equalance; $item_currency_production_unit_discount_2 = $item_currency_discount_2 / $sale_unit_equalance; $purchase_unit_discount_amount_2 = $discount_amount_2 * $sale_unit_equalance; $sale_unit_discount_amount_2 = $discount_amount_2; $production_unit_discount_amount_2 = $discount_amount_2 / $sale_unit_equalance; $item_currency_purchase_unit_discount_amount_2 = $item_currency_discount_amount_2 * $sale_unit_equalance; $item_currency_sale_unit_discount_amount_2 = $item_currency_discount_amount_2; $item_currency_production_unit_discount_amount_2 = $item_currency_discount_amount_2 / $sale_unit_equalance; } else { $purchase_unit_qty = (float)$entry_item['qty'] / $production_unit_equalance; $sale_unit_qty = (float)$entry_item['qty'] / $production_unit_equalance; $production_unit_qty = (float)$entry_item['qty']; $purchase_bonus_qty = (float)$entry_item['bonus'] / $production_unit_equalance; $sale_bonus_qty = (float)$entry_item['bonus'] / $production_unit_equalance; $production_bonus_qty = (float)$entry_item['bonus']; $purchase_unit_cost = (float)$entry_item['cost'] * $production_unit_equalance; $sale_unit_cost = (float)$entry_item['cost'] * $production_unit_equalance; $production_unit_cost = (float)$entry_item['cost']; $item_currency_purchase_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost; $purchase_unit_real_cost = (float)$entry_item['cost'] * $production_unit_equalance; $sale_unit_real_cost = (float)$entry_item['cost'] * $production_unit_equalance; $production_unit_real_cost = (float)$entry_item['cost']; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost; $purchase_unit_profit = (float)$entry_item['profit'] * $production_unit_equalance; $sale_unit_profit = (float)$entry_item['profit'] * $production_unit_equalance; $production_unit_profit = (float)$entry_item['profit']; $item_currency_purchase_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit; $purchase_unit_sale_price = (float)$entry_item['sale_price'] * $production_unit_equalance; $sale_unit_sale_price = (float)$entry_item['sale_price'] * $production_unit_equalance; $production_unit_sale_price = (float)$entry_item['sale_price']; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price; $purchase_unit_discount = (float)$entry_item['discount'] * $production_unit_equalance; $sale_unit_discount = (float)$entry_item['discount'] * $production_unit_equalance; $production_unit_discount = (float)$entry_item['discount']; $item_currency_purchase_unit_discount = $item_currency_discount * $production_unit_equalance; $item_currency_sale_unit_discount = $item_currency_discount * $production_unit_equalance * $production_unit_equalance; $item_currency_production_unit_discount = $item_currency_discount; $purchase_unit_discount_amount = $discount_amount * $production_unit_equalance; $sale_unit_discount_amount = $discount_amount * $production_unit_equalance; $production_unit_discount_amount = $discount_amount; $item_currency_purchase_unit_discount_amount = $item_currency_discount_amount * $production_unit_equalance; $item_currency_sale_unit_discount_amount = $item_currency_discount_amount * $production_unit_equalance; $item_currency_production_unit_discount_amount = $item_currency_discount_amount; $purchase_unit_discount_2 = (float)$entry_item['discount_2'] * $production_unit_equalance; $sale_unit_discount_2 = (float)$entry_item['discount_2'] * $production_unit_equalance; $production_unit_discount_2 = (float)$entry_item['discount_2']; $item_currency_purchase_unit_discount_2 = $item_currency_discount_2 * $production_unit_equalance; $item_currency_sale_unit_discount_2 = $item_currency_discount_2 * $production_unit_equalance * $production_unit_equalance; $item_currency_production_unit_discount_2 = $item_currency_discount_2; $purchase_unit_discount_amount_2 = $discount_amount_2 * $production_unit_equalance; $sale_unit_discount_amount_2 = $discount_amount_2 * $production_unit_equalance; $production_unit_discount_amount_2 = $discount_amount_2; $item_currency_purchase_unit_discount_amount_2 = $item_currency_discount_amount_2 * $production_unit_equalance; $item_currency_sale_unit_discount_amount_2 = $item_currency_discount_amount_2 * $production_unit_equalance; $item_currency_production_unit_discount_amount_2 = $item_currency_discount_amount_2; } $inventory_array = [ 'uid' => getUniqueId('ITINT', 'items_inventory_stats', 'uid'), 'branch' => $db_entry['branch'], 'event_date' => $db_entry['created_at'], 'item' => $item_data['uid'], 'item_name' => $item_data['name'], 'item_category' => $item_data['category'], 'item_type' => $item_data['type'], 'account' => $account_data['uid'], 'account_name' => $account_data['name'], 'warehouse' => $warehouse_data['uid'], 'warehouse_name' => $warehouse_data['name'], 'batch' => $entry_item['batch'], 'invoice' => $db_entry['invoice'], 'module_uid' => $db_entry['uid'], 'module_name' => 'transfer_in', 'purchase_unit_stock_in' => $purchase_unit_qty, 'sale_unit_stock_in' => $sale_unit_qty, 'production_unit_stock_in' => $production_unit_qty, 'purchase_unit_bonus_in' => $purchase_bonus_qty, 'sale_unit_bonus_in' => $sale_bonus_qty, 'production_unit_bonus_in' => $production_bonus_qty, 'currency' => $currency_data['uid'], 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'currency_usd_equalance' => $currency_data['usd_equalance'], 'item_currency' => $item_currency_data['uid'], 'item_currency_name' => $item_currency_data['name'], 'item_currency_symbol' => $item_currency_data['symbol'], 'item_currency_usd_equalance' => $item_currency_data['usd_equalance'], 'purchase_unit_cost' => $purchase_unit_cost, 'sale_unit_cost' => $sale_unit_cost, 'production_unit_cost' => $production_unit_cost, 'item_currency_purchase_unit_cost' => $item_currency_purchase_unit_cost, 'item_currency_sale_unit_cost' => $item_currency_sale_unit_cost, 'item_currency_production_unit_cost' => $item_currency_production_unit_cost, 'purchase_unit_real_cost' => $purchase_unit_real_cost, 'sale_unit_real_cost' => $sale_unit_real_cost, 'production_unit_real_cost' => $production_unit_real_cost, 'item_currency_purchase_unit_real_cost' => $item_currency_purchase_unit_real_cost, 'item_currency_sale_unit_real_cost' => $item_currency_sale_unit_real_cost, 'item_currency_production_unit_real_cost' => $item_currency_production_unit_real_cost, 'purchase_unit_profit' => $purchase_unit_profit, 'sale_unit_profit' => $sale_unit_profit, 'production_unit_profit' => $production_unit_profit, 'item_currency_purchase_unit_profit' => $item_currency_purchase_unit_profit, 'item_currency_sale_unit_profit' => $item_currency_sale_unit_profit, 'item_currency_production_unit_profit' => $item_currency_production_unit_profit, 'purchase_unit_sale_price' => $purchase_unit_sale_price, 'sale_unit_sale_price' => $sale_unit_sale_price, 'production_unit_sale_price' => $production_unit_sale_price, 'item_currency_purchase_unit_sale_price' => $item_currency_purchase_unit_sale_price, 'item_currency_sale_unit_sale_price' => $item_currency_sale_unit_sale_price, 'item_currency_production_unit_sale_price' => $item_currency_production_unit_sale_price, 'purchase_unit_discount' => $purchase_unit_discount, 'sale_unit_discount' => $sale_unit_discount, 'production_unit_discount' => $production_unit_discount, 'item_currency_purchase_unit_discount' => $item_currency_purchase_unit_discount, 'item_currency_sale_unit_discount' => $item_currency_sale_unit_discount, 'item_currency_production_unit_discount' => $item_currency_production_unit_discount, 'purchase_unit_discount_amount' => $purchase_unit_discount_amount, 'sale_unit_discount_amount' => $sale_unit_discount_amount, 'production_unit_discount_amount' => $production_unit_discount_amount, 'item_currency_purchase_unit_discount_amount' => $item_currency_purchase_unit_discount_amount, 'item_currency_sale_unit_discount_amount' => $item_currency_sale_unit_discount_amount, 'item_currency_production_unit_discount_amount' => $item_currency_production_unit_discount_amount, 'purchase_unit_discount_2' => $purchase_unit_discount_2, 'sale_unit_discount_2' => $sale_unit_discount_2, 'production_unit_discount_2' => $production_unit_discount_2, 'item_currency_purchase_unit_discount_2' => $item_currency_purchase_unit_discount_2, 'item_currency_sale_unit_discount_2' => $item_currency_sale_unit_discount_2, 'item_currency_production_unit_discount_2' => $item_currency_production_unit_discount_2, 'purchase_unit_discount_amount_2' => $purchase_unit_discount_amount_2, 'sale_unit_discount_amount_2' => $sale_unit_discount_amount_2, 'production_unit_discount_amount_2' => $production_unit_discount_amount_2, 'item_currency_purchase_unit_discount_amount_2' => $item_currency_purchase_unit_discount_amount_2, 'item_currency_sale_unit_discount_amount_2' => $item_currency_sale_unit_discount_amount_2, 'item_currency_production_unit_discount_amount_2' => $item_currency_production_unit_discount_amount_2, 'mfg' => $entry_item['mfg'], 'expiry' => $entry_item['expiry'], ]; insert_table('items_inventory_stats',$inventory_array); _calculate_item_wise_stats(['item' => $inventory_array['item']]); } } } } } function _handle_items_inventory_stats_from_transfer_out($sources) { $uid = $sources['uid']; $entry_status = $sources['entry_status']; $db_entry = fetch_table_where('transfer_out','uid',$uid,TRUE); if($entry_status == 'update' OR $entry_status == 'delete') { delete_table('items_inventory_stats','module_uid',$uid); } if($entry_status == 'new' OR $entry_status == 'update') { if(!empty($db_entry)) { $account_data = fetch_table_where('accounts','uid',$db_entry['client'],TRUE); $transfer_in_items_db = json_decode($db_entry['items'],true); if(!empty($transfer_in_items_db)) { foreach($transfer_in_items_db as $entry_item) { $item_data = fetch_table_where('items','uid',$entry_item['item'],TRUE); $item_currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $currency_data = fetch_table_where('currency','uid',$db_entry['currency'],TRUE); $warehouse_data = fetch_table_where('warehouse','uid',$entry_item['warehouse'],TRUE); $sale_unit_equalance = (float)$item_data['sale_unit_equalance']; if($sale_unit_equalance == 0){ $sale_unit_equalance = 1; } $production_unit_equalance = (float)$item_data['production_unit_equalance']; if($production_unit_equalance == 0){ $production_unit_equalance = 1; } $item_currency = $item_data['currency']; $item_currency_usd_equalance = $item_data['currency_usd_equalance']; $item_currency_cost = (float)$entry_item['cost']; $item_currency_real_cost = (float)$entry_item['cost']; $item_currency_profit = (float)$entry_item['profit']; $item_currency_sale_price = (float)$entry_item['sale_price']; $item_currency_discount = (float)$entry_item['discount']; $item_currency_discount_amount = ($item_currency_sale_price * $item_currency_discount) / 100; $item_currency_discount_2 = (float)$entry_item['discount_2']; $item_currency_discount_amount_2 = (($item_currency_sale_price - $item_currency_discount_amount) * $item_currency_discount_2) / 100; $discount_amount = $item_currency_discount_amount; $discount_amount_2 = $item_currency_discount_amount_2; if($item_currency != $db_entry['currency']) { $item_currency_cost = amount_conversion((float)$entry_item['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_real_cost = amount_conversion((float)$entry_item['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_profit = amount_conversion((float)$entry_item['profit'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_sale_price = amount_conversion((float)$entry_item['sale_price'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_discount = amount_conversion($item_currency_discount, $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_discount_amount = amount_conversion($item_currency_discount_amount, $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_discount_2 = amount_conversion($item_currency_discount_2, $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_discount_amount_2 = amount_conversion($item_currency_discount_amount_2, $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); } if($entry_item['unit'] == 'purchase') { $purchase_unit_qty = (float)$entry_item['qty']; $sale_unit_qty = (float)$entry_item['qty'] * $sale_unit_equalance; $production_unit_qty = (float)$entry_item['qty'] * $production_unit_equalance; $purchase_bonus_qty = (float)$entry_item['bonus']; $sale_bonus_qty = (float)$entry_item['bonus'] * $sale_unit_equalance; $production_bonus_qty = (float)$entry_item['bonus'] * $production_unit_equalance; $purchase_unit_cost = (float)$entry_item['cost']; $sale_unit_cost = (float)$entry_item['cost'] / $sale_unit_equalance; $production_unit_cost = (float)$entry_item['cost'] / $production_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost; $item_currency_sale_unit_cost = $item_currency_cost / $sale_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost / $production_unit_equalance; $purchase_unit_real_cost = (float)$entry_item['cost']; $sale_unit_real_cost = (float)$entry_item['cost'] / $sale_unit_equalance; $production_unit_real_cost = (float)$entry_item['cost'] / $production_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost; $item_currency_sale_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost / $production_unit_equalance; $purchase_unit_profit = (float)$entry_item['profit']; $sale_unit_profit = (float)$entry_item['profit'] / $sale_unit_equalance; $production_unit_profit = (float)$entry_item['profit'] / $production_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit; $item_currency_sale_unit_profit = $item_currency_profit / $sale_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit / $production_unit_equalance; $purchase_unit_sale_price = (float)$entry_item['sale_price']; $sale_unit_sale_price = (float)$entry_item['sale_price'] / $sale_unit_equalance; $production_unit_sale_price = (float)$entry_item['sale_price'] / $production_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price; $item_currency_sale_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price / $production_unit_equalance; $purchase_unit_discount = (float)$entry_item['discount']; $sale_unit_discount = (float)$entry_item['discount'] / $sale_unit_equalance; $production_unit_discount = (float)$entry_item['discount'] / $production_unit_equalance; $item_currency_purchase_unit_discount = $item_currency_discount; $item_currency_sale_unit_discount = $item_currency_discount / $sale_unit_equalance; $item_currency_production_unit_discount = $item_currency_discount / $production_unit_equalance; $purchase_unit_discount_amount = $discount_amount; $sale_unit_discount_amount = $discount_amount / $sale_unit_equalance; $production_unit_discount_amount = $discount_amount / $production_unit_equalance; $item_currency_purchase_unit_discount_amount = $item_currency_discount_amount; $item_currency_sale_unit_discount_amount = $item_currency_discount_amount / $sale_unit_equalance; $item_currency_production_unit_discount_amount = $item_currency_discount_amount / $production_unit_equalance; $purchase_unit_discount_2 = (float)$entry_item['discount_2']; $sale_unit_discount_2 = (float)$entry_item['discount_2'] / $sale_unit_equalance; $production_unit_discount_2 = (float)$entry_item['discount_2'] / $production_unit_equalance; $item_currency_purchase_unit_discount_2 = $item_currency_discount_2; $item_currency_sale_unit_discount_2 = $item_currency_discount_2 / $sale_unit_equalance; $item_currency_production_unit_discount_2 = $item_currency_discount_2 / $production_unit_equalance; $purchase_unit_discount_amount_2 = $discount_amount_2; $sale_unit_discount_amount_2 = $discount_amount_2 / $sale_unit_equalance; $production_unit_discount_amount_2 = $discount_amount_2 / $production_unit_equalance; $item_currency_purchase_unit_discount_amount_2 = $item_currency_discount_amount_2; $item_currency_sale_unit_discount_amount_2 = $item_currency_discount_amount_2 / $sale_unit_equalance; $item_currency_production_unit_discount_amount_2 = $item_currency_discount_amount_2 / $production_unit_equalance; } else if($entry_item['unit'] == 'sale') { $purchase_unit_qty = (float)$db_entry['qty'] / $sale_unit_equalance; $sale_unit_qty = (float)$db_entry['qty']; $production_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $purchase_bonus_qty = (float)$db_entry['bonus'] / $sale_unit_equalance; $sale_bonus_qty = (float)$db_entry['bonus']; $production_bonus_qty = (float)$db_entry['bonus'] * $sale_unit_equalance; $purchase_unit_cost = (float)$entry_item['cost'] * $sale_unit_equalance; $sale_unit_cost = (float)$entry_item['cost']; $production_unit_cost = (float)$entry_item['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost * $sale_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost; $item_currency_production_unit_cost = $item_currency_cost / $sale_unit_equalance; $purchase_unit_real_cost = (float)$entry_item['cost'] * $sale_unit_equalance; $sale_unit_real_cost = (float)$entry_item['cost']; $production_unit_real_cost = (float)$entry_item['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $sale_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost; $item_currency_production_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $purchase_unit_profit = (float)$entry_item['profit'] * $sale_unit_equalance; $sale_unit_profit = (float)$entry_item['profit']; $production_unit_profit = (float)$entry_item['profit'] / $sale_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit * $sale_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit; $item_currency_production_unit_profit = $item_currency_profit / $sale_unit_equalance; $purchase_unit_sale_price = (float)$entry_item['sale_price'] * $sale_unit_equalance; $sale_unit_sale_price = (float)$entry_item['sale_price']; $production_unit_sale_price = (float)$entry_item['sale_price'] / $sale_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $sale_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price; $item_currency_production_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $purchase_unit_discount = (float)$entry_item['discount'] * $sale_unit_equalance; $sale_unit_discount = (float)$entry_item['discount']; $production_unit_discount = (float)$entry_item['discount'] / $sale_unit_equalance; $item_currency_purchase_unit_discount = $item_currency_discount * $sale_unit_equalance; $item_currency_sale_unit_discount = $item_currency_discount * $sale_unit_equalance; $item_currency_production_unit_discount = $item_currency_discount / $sale_unit_equalance; $purchase_unit_discount_amount = $discount_amount * $sale_unit_equalance; $sale_unit_discount_amount = $discount_amount; $production_unit_discount_amount = $discount_amount / $sale_unit_equalance; $item_currency_purchase_unit_discount_amount = $item_currency_discount_amount * $sale_unit_equalance; $item_currency_sale_unit_discount_amount = $item_currency_discount_amount; $item_currency_production_unit_discount_amount = $item_currency_discount_amount / $sale_unit_equalance; $purchase_unit_discount_2 = (float)$entry_item['discount_2'] * $sale_unit_equalance; $sale_unit_discount_2 = (float)$entry_item['discount_2']; $production_unit_discount_2 = (float)$entry_item['discount_2'] / $sale_unit_equalance; $item_currency_purchase_unit_discount_2 = $item_currency_discount_2 * $sale_unit_equalance; $item_currency_sale_unit_discount_2 = $item_currency_discount_2 * $sale_unit_equalance; $item_currency_production_unit_discount_2 = $item_currency_discount_2 / $sale_unit_equalance; $purchase_unit_discount_amount_2 = $discount_amount_2 * $sale_unit_equalance; $sale_unit_discount_amount_2 = $discount_amount_2; $production_unit_discount_amount_2 = $discount_amount_2 / $sale_unit_equalance; $item_currency_purchase_unit_discount_amount_2 = $item_currency_discount_amount_2 * $sale_unit_equalance; $item_currency_sale_unit_discount_amount_2 = $item_currency_discount_amount_2; $item_currency_production_unit_discount_amount_2 = $item_currency_discount_amount_2 / $sale_unit_equalance; } else { $purchase_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $sale_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $production_unit_qty = (float)$db_entry['qty']; $purchase_bonus_qty = (float)$db_entry['bonus'] / $production_unit_equalance; $sale_bonus_qty = (float)$db_entry['bonus'] / $production_unit_equalance; $production_bonus_qty = (float)$db_entry['bonus']; $purchase_unit_cost = (float)$entry_item['cost'] * $production_unit_equalance; $sale_unit_cost = (float)$entry_item['cost'] * $production_unit_equalance; $production_unit_cost = (float)$entry_item['cost']; $item_currency_purchase_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost; $purchase_unit_real_cost = (float)$entry_item['cost'] * $production_unit_equalance; $sale_unit_real_cost = (float)$entry_item['cost'] * $production_unit_equalance; $production_unit_real_cost = (float)$entry_item['cost']; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost; $purchase_unit_profit = (float)$entry_item['profit'] * $production_unit_equalance; $sale_unit_profit = (float)$entry_item['profit'] * $production_unit_equalance; $production_unit_profit = (float)$entry_item['profit']; $item_currency_purchase_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit; $purchase_unit_sale_price = (float)$entry_item['sale_price'] * $production_unit_equalance; $sale_unit_sale_price = (float)$entry_item['sale_price'] * $production_unit_equalance; $production_unit_sale_price = (float)$entry_item['sale_price']; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price; $purchase_unit_discount = (float)$entry_item['discount'] * $production_unit_equalance; $sale_unit_discount = (float)$entry_item['discount'] * $production_unit_equalance; $production_unit_discount = (float)$entry_item['discount']; $item_currency_purchase_unit_discount = $item_currency_discount * $production_unit_equalance; $item_currency_sale_unit_discount = $item_currency_discount * $production_unit_equalance * $production_unit_equalance; $item_currency_production_unit_discount = $item_currency_discount; $purchase_unit_discount_amount = $discount_amount * $production_unit_equalance; $sale_unit_discount_amount = $discount_amount * $production_unit_equalance; $production_unit_discount_amount = $discount_amount; $item_currency_purchase_unit_discount_amount = $item_currency_discount_amount * $production_unit_equalance; $item_currency_sale_unit_discount_amount = $item_currency_discount_amount * $production_unit_equalance; $item_currency_production_unit_discount_amount = $item_currency_discount_amount; $purchase_unit_discount_2 = (float)$entry_item['discount_2'] * $production_unit_equalance; $sale_unit_discount_2 = (float)$entry_item['discount_2'] * $production_unit_equalance; $production_unit_discount_2 = (float)$entry_item['discount_2']; $item_currency_purchase_unit_discount_2 = $item_currency_discount_2 * $production_unit_equalance; $item_currency_sale_unit_discount_2 = $item_currency_discount_2 * $production_unit_equalance * $production_unit_equalance; $item_currency_production_unit_discount_2 = $item_currency_discount_2; $purchase_unit_discount_amount_2 = $discount_amount_2 * $production_unit_equalance; $sale_unit_discount_amount_2 = $discount_amount_2 * $production_unit_equalance; $production_unit_discount_amount_2 = $discount_amount_2; $item_currency_purchase_unit_discount_amount_2 = $item_currency_discount_amount_2 * $production_unit_equalance; $item_currency_sale_unit_discount_amount_2 = $item_currency_discount_amount_2 * $production_unit_equalance; $item_currency_production_unit_discount_amount_2 = $item_currency_discount_amount_2; } $inventory_array = [ 'uid' => getUniqueId('ITINT', 'items_inventory_stats', 'uid'), 'branch' => $db_entry['branch'], 'event_date' => $db_entry['created_at'], 'item' => $item_data['uid'], 'item_name' => $item_data['name'], 'item_category' => $item_data['category'], 'item_type' => $item_data['type'], 'account' => $account_data['uid'], 'account_name' => $account_data['name'], 'warehouse' => $warehouse_data['uid'], 'warehouse_name' => $warehouse_data['name'], 'batch' => $entry_item['batch'], 'invoice' => $db_entry['invoice'], 'module_uid' => $db_entry['uid'], 'module_name' => 'transfer_out', 'purchase_unit_stock_out' => $purchase_unit_qty, 'sale_unit_stock_out' => $sale_unit_qty, 'production_unit_stock_out' => $production_unit_qty, 'purchase_unit_bonus_out' => $purchase_bonus_qty, 'sale_unit_bonus_out' => $sale_bonus_qty, 'production_unit_bonus_out' => $production_bonus_qty, 'currency' => $currency_data['uid'], 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'currency_usd_equalance' => $currency_data['usd_equalance'], 'item_currency' => $item_currency_data['uid'], 'item_currency_name' => $item_currency_data['name'], 'item_currency_symbol' => $item_currency_data['symbol'], 'item_currency_usd_equalance' => $item_currency_data['usd_equalance'], 'purchase_unit_cost' => $purchase_unit_cost, 'sale_unit_cost' => $sale_unit_cost, 'production_unit_cost' => $production_unit_cost, 'item_currency_purchase_unit_cost' => $item_currency_purchase_unit_cost, 'item_currency_sale_unit_cost' => $item_currency_sale_unit_cost, 'item_currency_production_unit_cost' => $item_currency_production_unit_cost, 'purchase_unit_real_cost' => $purchase_unit_real_cost, 'sale_unit_real_cost' => $sale_unit_real_cost, 'production_unit_real_cost' => $production_unit_real_cost, 'item_currency_purchase_unit_real_cost' => $item_currency_purchase_unit_real_cost, 'item_currency_sale_unit_real_cost' => $item_currency_sale_unit_real_cost, 'item_currency_production_unit_real_cost' => $item_currency_production_unit_real_cost, 'purchase_unit_profit' => $purchase_unit_profit, 'sale_unit_profit' => $sale_unit_profit, 'production_unit_profit' => $production_unit_profit, 'item_currency_purchase_unit_profit' => $item_currency_purchase_unit_profit, 'item_currency_sale_unit_profit' => $item_currency_sale_unit_profit, 'item_currency_production_unit_profit' => $item_currency_production_unit_profit, 'purchase_unit_sale_price' => $purchase_unit_sale_price, 'sale_unit_sale_price' => $sale_unit_sale_price, 'production_unit_sale_price' => $production_unit_sale_price, 'item_currency_purchase_unit_sale_price' => $item_currency_purchase_unit_sale_price, 'item_currency_sale_unit_sale_price' => $item_currency_sale_unit_sale_price, 'item_currency_production_unit_sale_price' => $item_currency_production_unit_sale_price, 'purchase_unit_discount' => $purchase_unit_discount, 'sale_unit_discount' => $sale_unit_discount, 'production_unit_discount' => $production_unit_discount, 'item_currency_purchase_unit_discount' => $item_currency_purchase_unit_discount, 'item_currency_sale_unit_discount' => $item_currency_sale_unit_discount, 'item_currency_production_unit_discount' => $item_currency_production_unit_discount, 'purchase_unit_discount_amount' => $purchase_unit_discount_amount, 'sale_unit_discount_amount' => $sale_unit_discount_amount, 'production_unit_discount_amount' => $production_unit_discount_amount, 'item_currency_purchase_unit_discount_amount' => $item_currency_purchase_unit_discount_amount, 'item_currency_sale_unit_discount_amount' => $item_currency_sale_unit_discount_amount, 'item_currency_production_unit_discount_amount' => $item_currency_production_unit_discount_amount, 'purchase_unit_discount_2' => $purchase_unit_discount_2, 'sale_unit_discount_2' => $sale_unit_discount_2, 'production_unit_discount_2' => $production_unit_discount_2, 'item_currency_purchase_unit_discount_2' => $item_currency_purchase_unit_discount_2, 'item_currency_sale_unit_discount_2' => $item_currency_sale_unit_discount_2, 'item_currency_production_unit_discount_2' => $item_currency_production_unit_discount_2, 'purchase_unit_discount_amount_2' => $purchase_unit_discount_amount_2, 'sale_unit_discount_amount_2' => $sale_unit_discount_amount_2, 'production_unit_discount_amount_2' => $production_unit_discount_amount_2, 'item_currency_purchase_unit_discount_amount_2' => $item_currency_purchase_unit_discount_amount_2, 'item_currency_sale_unit_discount_amount_2' => $item_currency_sale_unit_discount_amount_2, 'item_currency_production_unit_discount_amount_2' => $item_currency_production_unit_discount_amount_2, 'mfg' => $entry_item['mfg'], 'expiry' => $entry_item['expiry'], ]; insert_table('items_inventory_stats',$inventory_array); _calculate_item_wise_stats(['item' => $inventory_array['item']]); } } } } } function _handle_items_inventory_stats_from_branch_transfer_in($sources) { $uid = $sources['uid']; $entry_status = $sources['entry_status']; $db_entry = fetch_table_where('branch_transfer_in','uid',$uid,TRUE); if($entry_status == 'update' OR $entry_status == 'delete') { delete_table('items_inventory_stats','module_uid',$uid); } if($entry_status == 'new' OR $entry_status == 'update') { if(!empty($db_entry)) { $item_data = fetch_table_where('items','uid',$db_entry['item'],TRUE); $item_currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $warehouse_data = fetch_table_where('warehouse','uid',$db_entry['to_warehouse'],TRUE); $sale_unit_equalance = (float)$item_data['sale_unit_equalance']; if($sale_unit_equalance == 0){ $sale_unit_equalance = 1; } $production_unit_equalance = (float)$item_data['production_unit_equalance']; if($production_unit_equalance == 0){ $production_unit_equalance = 1; } $item_currency = $item_data['currency']; $item_currency_usd_equalance = $item_data['currency_usd_equalance']; $item_currency_cost = (float)$db_entry['cost']; $item_currency_real_cost = (float)$db_entry['cost']; $item_currency_profit = (float)$db_entry['profit']; $item_currency_sale_price = (float)$db_entry['sale_price']; if($db_entry['unit'] == 'purchase') { $purchase_unit_qty = (float)$db_entry['qty']; $sale_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $production_unit_qty = (float)$db_entry['qty'] * $production_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost']; $sale_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost; $item_currency_sale_unit_cost = $item_currency_cost / $sale_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost / $production_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['cost']; $sale_unit_real_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_real_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost; $item_currency_sale_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost / $production_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit']; $sale_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $production_unit_profit = (float)$db_entry['profit'] / $production_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit; $item_currency_sale_unit_profit = $item_currency_profit / $sale_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit / $production_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price']; $sale_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price'] / $production_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price; $item_currency_sale_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price / $production_unit_equalance; } else if($db_entry['unit'] == 'sale') { $purchase_unit_qty = (float)$db_entry['qty'] / $sale_unit_equalance; $sale_unit_qty = (float)$db_entry['qty']; $production_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_cost = (float)$db_entry['cost']; $production_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost * $sale_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost; $item_currency_production_unit_cost = $item_currency_cost / $sale_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_real_cost = (float)$db_entry['cost']; $production_unit_real_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $sale_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost; $item_currency_production_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit'] * $sale_unit_equalance; $sale_unit_profit = (float)$db_entry['profit']; $production_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit * $sale_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit; $item_currency_production_unit_profit = $item_currency_profit / $sale_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $sale_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price']; $production_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $sale_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price; $item_currency_production_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; } else { $purchase_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $sale_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $production_unit_qty = (float)$db_entry['qty']; $purchase_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost; $purchase_unit_real_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_real_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_real_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost; $purchase_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $sale_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $production_unit_profit = (float)$db_entry['profit']; $item_currency_purchase_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price']; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price; } $inventory_array = [ 'uid' => getUniqueId('ITINT', 'items_inventory_stats', 'uid'), 'branch' => $db_entry['branch'], 'event_date' => $db_entry['created_at'], 'item' => $item_data['uid'], 'item_name' => $item_data['name'], 'item_category' => $item_data['category'], 'item_type' => $item_data['type'], 'warehouse' => $warehouse_data['uid'], 'warehouse_name' => $warehouse_data['name'], 'batch' => $db_entry['batch'], 'module_uid' => $db_entry['uid'], 'module_name' => 'branch_transfer_in', 'purchase_unit_stock_in' => $purchase_unit_qty, 'sale_unit_stock_in' => $sale_unit_qty, 'production_unit_stock_in' => $production_unit_qty, 'currency' => $currency_data['uid'], 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'currency_usd_equalance' => $currency_data['usd_equalance'], 'item_currency' => $item_currency_data['uid'], 'item_currency_name' => $item_currency_data['name'], 'item_currency_symbol' => $item_currency_data['symbol'], 'item_currency_usd_equalance' => $item_currency_data['usd_equalance'], 'purchase_unit_cost' => $purchase_unit_cost, 'sale_unit_cost' => $sale_unit_cost, 'production_unit_cost' => $production_unit_cost, 'item_currency_purchase_unit_cost' => $item_currency_purchase_unit_cost, 'item_currency_sale_unit_cost' => $item_currency_sale_unit_cost, 'item_currency_production_unit_cost' => $item_currency_production_unit_cost, 'purchase_unit_real_cost' => $purchase_unit_real_cost, 'sale_unit_real_cost' => $sale_unit_real_cost, 'production_unit_real_cost' => $production_unit_real_cost, 'item_currency_purchase_unit_real_cost' => $item_currency_purchase_unit_real_cost, 'item_currency_sale_unit_real_cost' => $item_currency_sale_unit_real_cost, 'item_currency_production_unit_real_cost' => $item_currency_production_unit_real_cost, 'purchase_unit_profit' => $purchase_unit_profit, 'sale_unit_profit' => $sale_unit_profit, 'production_unit_profit' => $production_unit_profit, 'item_currency_purchase_unit_profit' => $item_currency_purchase_unit_profit, 'item_currency_sale_unit_profit' => $item_currency_sale_unit_profit, 'item_currency_production_unit_profit' => $item_currency_production_unit_profit, 'purchase_unit_sale_price' => $purchase_unit_sale_price, 'sale_unit_sale_price' => $sale_unit_sale_price, 'production_unit_sale_price' => $production_unit_sale_price, 'item_currency_purchase_unit_sale_price' => $item_currency_purchase_unit_sale_price, 'item_currency_sale_unit_sale_price' => $item_currency_sale_unit_sale_price, 'item_currency_production_unit_sale_price' => $item_currency_production_unit_sale_price, ]; insert_table('items_inventory_stats',$inventory_array); _calculate_item_wise_stats(['item' => $inventory_array['item']]); } } } function _handle_items_inventory_stats_from_branch_transfer_out($sources) { $uid = $sources['uid']; $entry_status = $sources['entry_status']; $db_entry = fetch_table_where('branch_transfer_out','uid',$uid,TRUE); if($entry_status == 'update' OR $entry_status == 'delete') { delete_table('items_inventory_stats','module_uid',$uid); } if($entry_status == 'new' OR $entry_status == 'update') { if(!empty($db_entry)) { $item_data = fetch_table_where('items','uid',$db_entry['item'],TRUE); $item_currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $warehouse_data = fetch_table_where('warehouse','uid',$db_entry['warehouse'],TRUE); $sale_unit_equalance = (float)$item_data['sale_unit_equalance']; if($sale_unit_equalance == 0){ $sale_unit_equalance = 1; } $production_unit_equalance = (float)$item_data['production_unit_equalance']; if($production_unit_equalance == 0){ $production_unit_equalance = 1; } $item_currency = $item_data['currency']; $item_currency_usd_equalance = $item_data['currency_usd_equalance']; $item_currency_cost = (float)$db_entry['cost']; $item_currency_real_cost = (float)$db_entry['cost']; $item_currency_profit = (float)$db_entry['profit']; $item_currency_sale_price = (float)$db_entry['sale_price']; if($db_entry['unit'] == 'purchase') { $purchase_unit_qty = (float)$db_entry['qty']; $sale_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $production_unit_qty = (float)$db_entry['qty'] * $production_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost']; $sale_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost; $item_currency_sale_unit_cost = $item_currency_cost / $sale_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost / $production_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['cost']; $sale_unit_real_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_real_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost; $item_currency_sale_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost / $production_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit']; $sale_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $production_unit_profit = (float)$db_entry['profit'] / $production_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit; $item_currency_sale_unit_profit = $item_currency_profit / $sale_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit / $production_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price']; $sale_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price'] / $production_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price; $item_currency_sale_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price / $production_unit_equalance; } else if($db_entry['unit'] == 'sale') { $purchase_unit_qty = (float)$db_entry['qty'] / $sale_unit_equalance; $sale_unit_qty = (float)$db_entry['qty']; $production_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_cost = (float)$db_entry['cost']; $production_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost * $sale_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost; $item_currency_production_unit_cost = $item_currency_cost / $sale_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_real_cost = (float)$db_entry['cost']; $production_unit_real_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $sale_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost; $item_currency_production_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit'] * $sale_unit_equalance; $sale_unit_profit = (float)$db_entry['profit']; $production_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit * $sale_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit; $item_currency_production_unit_profit = $item_currency_profit / $sale_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $sale_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price']; $production_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $sale_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price; $item_currency_production_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; } else { $purchase_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $sale_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $production_unit_qty = (float)$db_entry['qty']; $purchase_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost; $purchase_unit_real_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_real_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_real_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost; $purchase_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $sale_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $production_unit_profit = (float)$db_entry['profit']; $item_currency_purchase_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price']; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price; } $inventory_array = [ 'uid' => getUniqueId('ITINT', 'items_inventory_stats', 'uid'), 'branch' => $db_entry['branch'], 'event_date' => $db_entry['created_at'], 'item' => $item_data['uid'], 'item_name' => $item_data['name'], 'item_category' => $item_data['category'], 'item_type' => $item_data['type'], 'warehouse' => $warehouse_data['uid'], 'warehouse_name' => $warehouse_data['name'], 'batch' => $db_entry['batch'], 'module_uid' => $db_entry['uid'], 'module_name' => 'branch_transfer_out', 'purchase_unit_stock_out' => $purchase_unit_qty, 'sale_unit_stock_out' => $sale_unit_qty, 'production_unit_stock_out' => $production_unit_qty, 'currency' => $currency_data['uid'], 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'currency_usd_equalance' => $currency_data['usd_equalance'], 'item_currency' => $item_currency_data['uid'], 'item_currency_name' => $item_currency_data['name'], 'item_currency_symbol' => $item_currency_data['symbol'], 'item_currency_usd_equalance' => $item_currency_data['usd_equalance'], 'purchase_unit_cost' => $purchase_unit_cost, 'sale_unit_cost' => $sale_unit_cost, 'production_unit_cost' => $production_unit_cost, 'item_currency_purchase_unit_cost' => $item_currency_purchase_unit_cost, 'item_currency_sale_unit_cost' => $item_currency_sale_unit_cost, 'item_currency_production_unit_cost' => $item_currency_production_unit_cost, 'purchase_unit_real_cost' => $purchase_unit_real_cost, 'sale_unit_real_cost' => $sale_unit_real_cost, 'production_unit_real_cost' => $production_unit_real_cost, 'item_currency_purchase_unit_real_cost' => $item_currency_purchase_unit_real_cost, 'item_currency_sale_unit_real_cost' => $item_currency_sale_unit_real_cost, 'item_currency_production_unit_real_cost' => $item_currency_production_unit_real_cost, 'purchase_unit_profit' => $purchase_unit_profit, 'sale_unit_profit' => $sale_unit_profit, 'production_unit_profit' => $production_unit_profit, 'item_currency_purchase_unit_profit' => $item_currency_purchase_unit_profit, 'item_currency_sale_unit_profit' => $item_currency_sale_unit_profit, 'item_currency_production_unit_profit' => $item_currency_production_unit_profit, 'purchase_unit_sale_price' => $purchase_unit_sale_price, 'sale_unit_sale_price' => $sale_unit_sale_price, 'production_unit_sale_price' => $production_unit_sale_price, 'item_currency_purchase_unit_sale_price' => $item_currency_purchase_unit_sale_price, 'item_currency_sale_unit_sale_price' => $item_currency_sale_unit_sale_price, 'item_currency_production_unit_sale_price' => $item_currency_production_unit_sale_price, ]; insert_table('items_inventory_stats',$inventory_array); _calculate_item_wise_stats(['item' => $inventory_array['item']]); } } } function _handle_items_inventory_stats_from_transfer($sources) { $uid = $sources['uid']; $entry_status = $sources['entry_status']; $db_entry = fetch_table_where('transfer','uid',$uid,TRUE); if($entry_status == 'update' OR $entry_status == 'delete') { delete_table('items_inventory_stats','module_uid',$uid); } if($entry_status == 'new' OR $entry_status == 'update') { if(!empty($db_entry)) { $item_data = fetch_table_where('items','uid',$db_entry['item'],TRUE); $item_currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $sending_warehouse_data = fetch_table_where('warehouse','uid',$db_entry['sending_warehouse'],TRUE); $receiving_warehouse_data = fetch_table_where('warehouse','uid',$db_entry['receiving_warehouse'],TRUE); $sale_unit_equalance = (float)$item_data['sale_unit_equalance']; if($sale_unit_equalance == 0){ $sale_unit_equalance = 1; } $production_unit_equalance = (float)$item_data['production_unit_equalance']; if($production_unit_equalance == 0){ $production_unit_equalance = 1; } $item_currency = $item_data['currency']; $item_currency_usd_equalance = $item_data['currency_usd_equalance']; $item_currency_cost = (float)$db_entry['cost']; $item_currency_real_cost = (float)$db_entry['cost']; $item_currency_profit = (float)$db_entry['profit']; $item_currency_sale_price = (float)$db_entry['sale_price']; if($db_entry['unit'] == 'purchase') { $purchase_unit_qty = (float)$db_entry['qty']; $sale_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $production_unit_qty = (float)$db_entry['qty'] * $production_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost']; $sale_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost; $item_currency_sale_unit_cost = $item_currency_cost / $sale_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost / $production_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['cost']; $sale_unit_real_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_real_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost; $item_currency_sale_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost / $production_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit']; $sale_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $production_unit_profit = (float)$db_entry['profit'] / $production_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit; $item_currency_sale_unit_profit = $item_currency_profit / $sale_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit / $production_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price']; $sale_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price'] / $production_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price; $item_currency_sale_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price / $production_unit_equalance; } else if($db_entry['unit'] == 'sale') { $purchase_unit_qty = (float)$db_entry['qty'] / $sale_unit_equalance; $sale_unit_qty = (float)$db_entry['qty']; $production_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_cost = (float)$db_entry['cost']; $production_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost * $sale_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost; $item_currency_production_unit_cost = $item_currency_cost / $sale_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_real_cost = (float)$db_entry['cost']; $production_unit_real_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $sale_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost; $item_currency_production_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit'] * $sale_unit_equalance; $sale_unit_profit = (float)$db_entry['profit']; $production_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit * $sale_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit; $item_currency_production_unit_profit = $item_currency_profit / $sale_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $sale_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price']; $production_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $sale_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price; $item_currency_production_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; } else { $purchase_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $sale_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $production_unit_qty = (float)$db_entry['qty']; $purchase_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost; $purchase_unit_real_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_real_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_real_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost; $purchase_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $sale_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $production_unit_profit = (float)$db_entry['profit']; $item_currency_purchase_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price']; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price; } $inventory_array = [ 'uid' => getUniqueId('ITINT', 'items_inventory_stats', 'uid'), 'branch' => $db_entry['branch'], 'event_date' => $db_entry['created_at'], 'item' => $item_data['uid'], 'item_name' => $item_data['name'], 'item_category' => $item_data['category'], 'item_type' => $item_data['type'], 'warehouse' => $sending_warehouse_data['uid'], 'warehouse_name' => $sending_warehouse_data['name'], 'batch' => $db_entry['batch'], 'module_uid' => $db_entry['uid'], 'module_name' => 'warehouse_transfer_out', 'purchase_unit_stock_out' => $purchase_unit_qty, 'sale_unit_stock_out' => $sale_unit_qty, 'production_unit_stock_out' => $production_unit_qty, 'currency' => $currency_data['uid'], 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'currency_usd_equalance' => $currency_data['usd_equalance'], 'item_currency' => $item_currency_data['uid'], 'item_currency_name' => $item_currency_data['name'], 'item_currency_symbol' => $item_currency_data['symbol'], 'item_currency_usd_equalance' => $item_currency_data['usd_equalance'], 'purchase_unit_cost' => $purchase_unit_cost, 'sale_unit_cost' => $sale_unit_cost, 'production_unit_cost' => $production_unit_cost, 'item_currency_purchase_unit_cost' => $item_currency_purchase_unit_cost, 'item_currency_sale_unit_cost' => $item_currency_sale_unit_cost, 'item_currency_production_unit_cost' => $item_currency_production_unit_cost, 'purchase_unit_real_cost' => $purchase_unit_real_cost, 'sale_unit_real_cost' => $sale_unit_real_cost, 'production_unit_real_cost' => $production_unit_real_cost, 'item_currency_purchase_unit_real_cost' => $item_currency_purchase_unit_real_cost, 'item_currency_sale_unit_real_cost' => $item_currency_sale_unit_real_cost, 'item_currency_production_unit_real_cost' => $item_currency_production_unit_real_cost, 'purchase_unit_profit' => $purchase_unit_profit, 'sale_unit_profit' => $sale_unit_profit, 'production_unit_profit' => $production_unit_profit, 'item_currency_purchase_unit_profit' => $item_currency_purchase_unit_profit, 'item_currency_sale_unit_profit' => $item_currency_sale_unit_profit, 'item_currency_production_unit_profit' => $item_currency_production_unit_profit, 'purchase_unit_sale_price' => $purchase_unit_sale_price, 'sale_unit_sale_price' => $sale_unit_sale_price, 'production_unit_sale_price' => $production_unit_sale_price, 'item_currency_purchase_unit_sale_price' => $item_currency_purchase_unit_sale_price, 'item_currency_sale_unit_sale_price' => $item_currency_sale_unit_sale_price, 'item_currency_production_unit_sale_price' => $item_currency_production_unit_sale_price, 'bundle_stock_out' => $db_entry['bundle'], 'toop_stock_out' => $db_entry['toop'], ]; insert_table('items_inventory_stats',$inventory_array); _calculate_item_wise_stats(['item' => $inventory_array['item']]); $inventory_array = [ 'uid' => getUniqueId('ITINT', 'items_inventory_stats', 'uid'), 'branch' => $db_entry['branch'], 'event_date' => $db_entry['created_at'], 'item' => $item_data['uid'], 'item_name' => $item_data['name'], 'item_category' => $item_data['category'], 'item_type' => $item_data['type'], 'warehouse' => $receiving_warehouse_data['uid'], 'warehouse_name' => $receiving_warehouse_data['name'], 'batch' => $db_entry['batch'], 'module_uid' => $db_entry['uid'], 'module_name' => 'warehouse_transfer_in', 'purchase_unit_stock_in' => $purchase_unit_qty, 'sale_unit_stock_in' => $sale_unit_qty, 'production_unit_stock_in' => $production_unit_qty, 'currency' => $currency_data['uid'], 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'currency_usd_equalance' => $currency_data['usd_equalance'], 'item_currency' => $item_currency_data['uid'], 'item_currency_name' => $item_currency_data['name'], 'item_currency_symbol' => $item_currency_data['symbol'], 'item_currency_usd_equalance' => $item_currency_data['usd_equalance'], 'purchase_unit_cost' => $purchase_unit_cost, 'sale_unit_cost' => $sale_unit_cost, 'production_unit_cost' => $production_unit_cost, 'item_currency_purchase_unit_cost' => $item_currency_purchase_unit_cost, 'item_currency_sale_unit_cost' => $item_currency_sale_unit_cost, 'item_currency_production_unit_cost' => $item_currency_production_unit_cost, 'purchase_unit_real_cost' => $purchase_unit_real_cost, 'sale_unit_real_cost' => $sale_unit_real_cost, 'production_unit_real_cost' => $production_unit_real_cost, 'item_currency_purchase_unit_real_cost' => $item_currency_purchase_unit_real_cost, 'item_currency_sale_unit_real_cost' => $item_currency_sale_unit_real_cost, 'item_currency_production_unit_real_cost' => $item_currency_production_unit_real_cost, 'purchase_unit_profit' => $purchase_unit_profit, 'sale_unit_profit' => $sale_unit_profit, 'production_unit_profit' => $production_unit_profit, 'item_currency_purchase_unit_profit' => $item_currency_purchase_unit_profit, 'item_currency_sale_unit_profit' => $item_currency_sale_unit_profit, 'item_currency_production_unit_profit' => $item_currency_production_unit_profit, 'purchase_unit_sale_price' => $purchase_unit_sale_price, 'sale_unit_sale_price' => $sale_unit_sale_price, 'production_unit_sale_price' => $production_unit_sale_price, 'item_currency_purchase_unit_sale_price' => $item_currency_purchase_unit_sale_price, 'item_currency_sale_unit_sale_price' => $item_currency_sale_unit_sale_price, 'item_currency_production_unit_sale_price' => $item_currency_production_unit_sale_price, 'bundle_stock_in' => $db_entry['bundle'], 'toop_stock_in' => $db_entry['toop'], ]; insert_table('items_inventory_stats',$inventory_array); _calculate_item_wise_stats(['item' => $inventory_array['item']]); } } } function _handle_items_inventory_stats_from_branch_to_branch_transfer($sources) { $uid = $sources['uid']; $entry_status = $sources['entry_status']; $db_entry = fetch_table_where('branch_to_branch_transfer','uid',$uid,TRUE); if($entry_status == 'update' OR $entry_status == 'delete') { delete_table('items_inventory_stats','module_uid',$uid); } if($entry_status == 'new' OR $entry_status == 'update') { if(!empty($db_entry)) { $item_data = fetch_table_where('items','uid',$db_entry['item'],TRUE); $item_currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $warehouse_data = fetch_table_where('warehouse','uid',$db_entry['warehouse'],TRUE); $to_warehouse_data = fetch_table_where('warehouse','uid',$db_entry['to_warehouse'],TRUE); $sale_unit_equalance = (float)$item_data['sale_unit_equalance']; if($sale_unit_equalance == 0){ $sale_unit_equalance = 1; } $production_unit_equalance = (float)$item_data['production_unit_equalance']; if($production_unit_equalance == 0){ $production_unit_equalance = 1; } $item_currency = $item_data['currency']; $item_currency_usd_equalance = $item_data['currency_usd_equalance']; $item_currency_cost = (float)$db_entry['cost']; $item_currency_real_cost = (float)$db_entry['cost']; $item_currency_profit = (float)$db_entry['profit']; $item_currency_sale_price = (float)$db_entry['sale_price']; if($item_currency != $db_entry['currency']) { $item_currency_cost = amount_conversion((float)$db_entry['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_real_cost = amount_conversion((float)$db_entry['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_profit = amount_conversion((float)$db_entry['profit'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_sale_price = amount_conversion((float)$db_entry['sale_price'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); } if($db_entry['unit'] == 'purchase') { $purchase_unit_qty = (float)$db_entry['qty']; $sale_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $production_unit_qty = (float)$db_entry['qty'] * $production_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost']; $sale_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost; $item_currency_sale_unit_cost = $item_currency_cost / $sale_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost / $production_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['cost']; $sale_unit_real_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_real_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost; $item_currency_sale_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost / $production_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit']; $sale_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $production_unit_profit = (float)$db_entry['profit'] / $production_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit; $item_currency_sale_unit_profit = $item_currency_profit / $sale_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit / $production_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price']; $sale_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price'] / $production_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price; $item_currency_sale_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price / $production_unit_equalance; } else if($db_entry['unit'] == 'sale') { $purchase_unit_qty = (float)$db_entry['qty'] / $sale_unit_equalance; $sale_unit_qty = (float)$db_entry['qty']; $production_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_cost = (float)$db_entry['cost']; $production_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost * $sale_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost; $item_currency_production_unit_cost = $item_currency_cost / $sale_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_real_cost = (float)$db_entry['cost']; $production_unit_real_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $sale_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost; $item_currency_production_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit'] * $sale_unit_equalance; $sale_unit_profit = (float)$db_entry['profit']; $production_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit * $sale_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit; $item_currency_production_unit_profit = $item_currency_profit / $sale_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $sale_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price']; $production_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $sale_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price; $item_currency_production_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; } else { $purchase_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $sale_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $production_unit_qty = (float)$db_entry['qty']; $purchase_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost; $purchase_unit_real_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_real_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_real_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost; $purchase_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $sale_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $production_unit_profit = (float)$db_entry['profit']; $item_currency_purchase_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price']; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price; } $inventory_array = [ 'uid' => getUniqueId('ITINT', 'items_inventory_stats', 'uid'), 'branch' => $db_entry['branch'], 'event_date' => $db_entry['t_date'], 'item' => $item_data['uid'], 'item_name' => $item_data['name'], 'item_category' => $item_data['category'], 'item_type' => $item_data['type'], 'warehouse' => $warehouse_data['uid'], 'warehouse_name' => $warehouse_data['name'], 'batch' => $db_entry['batch'], 'module_uid' => $db_entry['uid'], 'module_name' => 'branch_to_branch_transfer_out', 'purchase_unit_stock_out' => $purchase_unit_qty, 'sale_unit_stock_out' => $sale_unit_qty, 'production_unit_stock_out' => $production_unit_qty, 'currency' => $currency_data['uid'], 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'currency_usd_equalance' => $currency_data['usd_equalance'], 'item_currency' => $item_currency_data['uid'], 'item_currency_name' => $item_currency_data['name'], 'item_currency_symbol' => $item_currency_data['symbol'], 'item_currency_usd_equalance' => $item_currency_data['usd_equalance'], 'purchase_unit_cost' => $purchase_unit_cost, 'sale_unit_cost' => $sale_unit_cost, 'production_unit_cost' => $production_unit_cost, 'item_currency_purchase_unit_cost' => $item_currency_purchase_unit_cost, 'item_currency_sale_unit_cost' => $item_currency_sale_unit_cost, 'item_currency_production_unit_cost' => $item_currency_production_unit_cost, 'purchase_unit_real_cost' => $purchase_unit_real_cost, 'sale_unit_real_cost' => $sale_unit_real_cost, 'production_unit_real_cost' => $production_unit_real_cost, 'item_currency_purchase_unit_real_cost' => $item_currency_purchase_unit_real_cost, 'item_currency_sale_unit_real_cost' => $item_currency_sale_unit_real_cost, 'item_currency_production_unit_real_cost' => $item_currency_production_unit_real_cost, 'purchase_unit_profit' => $purchase_unit_profit, 'sale_unit_profit' => $sale_unit_profit, 'production_unit_profit' => $production_unit_profit, 'item_currency_purchase_unit_profit' => $item_currency_purchase_unit_profit, 'item_currency_sale_unit_profit' => $item_currency_sale_unit_profit, 'item_currency_production_unit_profit' => $item_currency_production_unit_profit, 'purchase_unit_sale_price' => $purchase_unit_sale_price, 'sale_unit_sale_price' => $sale_unit_sale_price, 'production_unit_sale_price' => $production_unit_sale_price, 'item_currency_purchase_unit_sale_price' => $item_currency_purchase_unit_sale_price, 'item_currency_sale_unit_sale_price' => $item_currency_sale_unit_sale_price, 'item_currency_production_unit_sale_price' => $item_currency_production_unit_sale_price, ]; insert_table('items_inventory_stats',$inventory_array); _calculate_item_wise_stats(['item' => $inventory_array['item']]); $item_data = std_obj_to_array(DB::table('items')->where('branch',$db_entry['to_branch'])->where('b_to_b_rel_uid',$db_entry['b_to_b_rel_uid'])->get()->first()); $item_currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $warehouse_data = fetch_table_where('warehouse','uid',$db_entry['warehouse'],TRUE); $to_warehouse_data = fetch_table_where('warehouse','uid',$db_entry['to_warehouse'],TRUE); $sale_unit_equalance = (float)$item_data['sale_unit_equalance']; if($sale_unit_equalance == 0){ $sale_unit_equalance = 1; } $production_unit_equalance = (float)$item_data['production_unit_equalance']; if($production_unit_equalance == 0){ $production_unit_equalance = 1; } $item_currency = $item_data['currency']; $item_currency_usd_equalance = $item_data['currency_usd_equalance']; $item_currency_cost = (float)$db_entry['cost']; $item_currency_real_cost = (float)$db_entry['cost']; $item_currency_profit = (float)$db_entry['profit']; $item_currency_sale_price = (float)$db_entry['sale_price']; if($item_currency != $db_entry['currency']) { $item_currency_cost = amount_conversion((float)$db_entry['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_real_cost = amount_conversion((float)$db_entry['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_profit = amount_conversion((float)$db_entry['profit'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_sale_price = amount_conversion((float)$db_entry['sale_price'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); } if($db_entry['unit'] == 'purchase') { $purchase_unit_qty = (float)$db_entry['qty']; $sale_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $production_unit_qty = (float)$db_entry['qty'] * $production_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost']; $sale_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost; $item_currency_sale_unit_cost = $item_currency_cost / $sale_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost / $production_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['cost']; $sale_unit_real_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_real_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost; $item_currency_sale_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost / $production_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit']; $sale_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $production_unit_profit = (float)$db_entry['profit'] / $production_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit; $item_currency_sale_unit_profit = $item_currency_profit / $sale_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit / $production_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price']; $sale_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price'] / $production_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price; $item_currency_sale_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price / $production_unit_equalance; } else if($db_entry['unit'] == 'sale') { $purchase_unit_qty = (float)$db_entry['qty'] / $sale_unit_equalance; $sale_unit_qty = (float)$db_entry['qty']; $production_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_cost = (float)$db_entry['cost']; $production_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost * $sale_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost; $item_currency_production_unit_cost = $item_currency_cost / $sale_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_real_cost = (float)$db_entry['cost']; $production_unit_real_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $sale_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost; $item_currency_production_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit'] * $sale_unit_equalance; $sale_unit_profit = (float)$db_entry['profit']; $production_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit * $sale_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit; $item_currency_production_unit_profit = $item_currency_profit / $sale_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $sale_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price']; $production_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $sale_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price; $item_currency_production_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; } else { $purchase_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $sale_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $production_unit_qty = (float)$db_entry['qty']; $purchase_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost; $purchase_unit_real_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_real_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_real_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost; $purchase_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $sale_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $production_unit_profit = (float)$db_entry['profit']; $item_currency_purchase_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price']; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price; } $inventory_array = [ 'uid' => getUniqueId('ITINT', 'items_inventory_stats', 'uid'), 'branch' => $db_entry['to_branch'], 'event_date' => $db_entry['t_date'], 'item' => $item_data['uid'], 'item_name' => $item_data['name'], 'item_category' => $item_data['category'], 'item_type' => $item_data['type'], 'warehouse' => $to_warehouse_data['uid'], 'warehouse_name' => $to_warehouse_data['name'], 'batch' => $db_entry['batch'], 'module_uid' => $db_entry['uid'], 'module_name' => 'branch_to_branch_transfer_in', 'purchase_unit_stock_in' => $purchase_unit_qty, 'sale_unit_stock_in' => $sale_unit_qty, 'production_unit_stock_in' => $production_unit_qty, 'currency' => $currency_data['uid'], 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'currency_usd_equalance' => $currency_data['usd_equalance'], 'item_currency' => $item_currency_data['uid'], 'item_currency_name' => $item_currency_data['name'], 'item_currency_symbol' => $item_currency_data['symbol'], 'item_currency_usd_equalance' => $item_currency_data['usd_equalance'], 'purchase_unit_cost' => $purchase_unit_cost, 'sale_unit_cost' => $sale_unit_cost, 'production_unit_cost' => $production_unit_cost, 'item_currency_purchase_unit_cost' => $item_currency_purchase_unit_cost, 'item_currency_sale_unit_cost' => $item_currency_sale_unit_cost, 'item_currency_production_unit_cost' => $item_currency_production_unit_cost, 'purchase_unit_real_cost' => $purchase_unit_real_cost, 'sale_unit_real_cost' => $sale_unit_real_cost, 'production_unit_real_cost' => $production_unit_real_cost, 'item_currency_purchase_unit_real_cost' => $item_currency_purchase_unit_real_cost, 'item_currency_sale_unit_real_cost' => $item_currency_sale_unit_real_cost, 'item_currency_production_unit_real_cost' => $item_currency_production_unit_real_cost, 'purchase_unit_profit' => $purchase_unit_profit, 'sale_unit_profit' => $sale_unit_profit, 'production_unit_profit' => $production_unit_profit, 'item_currency_purchase_unit_profit' => $item_currency_purchase_unit_profit, 'item_currency_sale_unit_profit' => $item_currency_sale_unit_profit, 'item_currency_production_unit_profit' => $item_currency_production_unit_profit, 'purchase_unit_sale_price' => $purchase_unit_sale_price, 'sale_unit_sale_price' => $sale_unit_sale_price, 'production_unit_sale_price' => $production_unit_sale_price, 'item_currency_purchase_unit_sale_price' => $item_currency_purchase_unit_sale_price, 'item_currency_sale_unit_sale_price' => $item_currency_sale_unit_sale_price, 'item_currency_production_unit_sale_price' => $item_currency_production_unit_sale_price, ]; insert_table('items_inventory_stats',$inventory_array); _calculate_item_wise_stats(['item' => $inventory_array['item']]); } } } function _handle_items_inventory_stats_from_production_old($sources) { $uid = $sources['uid']; $entry_status = $sources['entry_status']; $db_entries = fetch_table_where('production_details','production_id',$uid); if($entry_status == 'update' OR $entry_status == 'delete') { delete_table('items_inventory_stats','module_uid',$uid); } if($entry_status == 'new' OR $entry_status == 'update') { if(!empty($db_entries)) { foreach($db_entries as $db_entry) { if($db_entry['pro_type'] == 'raw') { $item_data = fetch_table_where('items','uid',$db_entry['item'],TRUE); $item_currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $currency_data = fetch_table_where('currency','uid',$db_entry['currency'],TRUE); $warehouse_data = fetch_table_where('warehouse','uid',$db_entry['warehouse'],TRUE); $expense_account_data = fetch_table_where('accounts','uid',$db_entry['expense_account'],TRUE); $sale_unit_equalance = (float)$item_data['sale_unit_equalance']; if($sale_unit_equalance == 0){ $sale_unit_equalance = 1; } $production_unit_equalance = (float)$item_data['production_unit_equalance']; if($production_unit_equalance == 0){ $production_unit_equalance = 1; } $item_currency = $item_data['currency']; $item_currency_usd_equalance = $item_data['currency_usd_equalance']; $item_currency_cost = (float)$db_entry['cost']; $item_currency_real_cost = (float)$db_entry['real_cost']; $item_currency_profit = (float)$db_entry['profit']; $item_currency_sale_price = (float)$db_entry['sale_price']; $item_currency_expense = (float)$db_entry['expense']; if($item_currency != $db_entry['currency']) { $item_currency_cost = amount_conversion((float)$db_entry['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_real_cost = amount_conversion((float)$db_entry['real_cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_profit = amount_conversion((float)$db_entry['profit'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_sale_price = amount_conversion((float)$db_entry['sale_price'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_expense = amount_conversion((float)$db_entry['expense'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); } if($db_entry['unit'] == 'purchase') { $purchase_unit_qty = (float)$db_entry['qty']; $sale_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $production_unit_qty = (float)$db_entry['qty'] * $production_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost']; $sale_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost; $item_currency_sale_unit_cost = $item_currency_cost / $sale_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost / $production_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['real_cost']; $sale_unit_real_cost = (float)$db_entry['real_cost'] / $sale_unit_equalance; $production_unit_real_cost = (float)$db_entry['real_cost'] / $production_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost; $item_currency_sale_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost / $production_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit']; $sale_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $production_unit_profit = (float)$db_entry['profit'] / $production_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit; $item_currency_sale_unit_profit = $item_currency_profit / $sale_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit / $production_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price']; $sale_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price'] / $production_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price; $item_currency_sale_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price / $production_unit_equalance; $purchase_unit_expense = (float)$db_entry['expense']; $sale_unit_expense = (float)$db_entry['expense'] / $sale_unit_equalance; $production_unit_expense = (float)$db_entry['expense'] / $production_unit_equalance; $item_currency_purchase_unit_expense = $item_currency_expense; $item_currency_sale_unit_expense = $item_currency_expense / $sale_unit_equalance; $item_currency_production_unit_expense = $item_currency_expense / $production_unit_equalance; } else if($db_entry['unit'] == 'sale') { $purchase_unit_qty = (float)$db_entry['qty'] / $sale_unit_equalance; $sale_unit_qty = (float)$db_entry['qty']; $production_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_cost = (float)$db_entry['cost']; $production_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost * $sale_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost; $item_currency_production_unit_cost = $item_currency_cost / $sale_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['real_cost'] * $sale_unit_equalance; $sale_unit_real_cost = (float)$db_entry['real_cost']; $production_unit_real_cost = (float)$db_entry['real_cost'] / $sale_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $sale_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost; $item_currency_production_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit'] * $sale_unit_equalance; $sale_unit_profit = (float)$db_entry['profit']; $production_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit * $sale_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit; $item_currency_production_unit_profit = $item_currency_profit / $sale_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $sale_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price']; $production_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $sale_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price; $item_currency_production_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $purchase_unit_expense = (float)$db_entry['expense'] * $sale_unit_equalance; $sale_unit_expense = (float)$db_entry['expense']; $production_unit_expense = (float)$db_entry['expense'] / $sale_unit_equalance; $item_currency_purchase_unit_expense = $item_currency_expense * $sale_unit_equalance; $item_currency_sale_unit_expense = $item_currency_expense; $item_currency_production_unit_expense = $item_currency_expense / $sale_unit_equalance; } else { $purchase_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $sale_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $production_unit_qty = (float)$db_entry['qty']; $purchase_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost; $purchase_unit_real_cost = (float)$db_entry['real_cost'] * $production_unit_equalance; $sale_unit_real_cost = (float)$db_entry['real_cost'] * $production_unit_equalance; $production_unit_real_cost = (float)$db_entry['real_cost']; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost; $purchase_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $sale_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $production_unit_profit = (float)$db_entry['profit']; $item_currency_purchase_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price']; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price; $purchase_unit_expense = (float)$db_entry['expense'] * $production_unit_equalance; $sale_unit_expense = (float)$db_entry['expense'] * $production_unit_equalance; $production_unit_expense = (float)$db_entry['expense']; $item_currency_purchase_unit_expense = $item_currency_expense * $production_unit_equalance; $item_currency_sale_unit_expense = $item_currency_expense * $production_unit_equalance; $item_currency_production_unit_expense = $item_currency_expense; } $inventory_array = [ 'uid' => getUniqueId('ITINT', 'items_inventory_stats', 'uid'), 'branch' => $db_entry['branch'], 'event_date' => $db_entry['event_date'], 'item' => $item_data['uid'], 'item_name' => $item_data['name'], 'item_category' => $item_data['category'], 'item_type' => $item_data['type'], 'warehouse' => $warehouse_data['uid'], 'warehouse_name' => $warehouse_data['name'], 'expense_account' => isset($expense_account_data['uid']) ? $expense_account_data['uid'] : null, 'expense_account_name' => isset($expense_account_data['name']) ? $expense_account_data['name'] : null, 'batch' => $db_entry['batch'], 'invoice' => $db_entry['invoice'], 'module_uid' => $db_entry['production_id'], 'module_name' => 'production_out', 'purchase_unit_stock_out' => $purchase_unit_qty, 'sale_unit_stock_out' => $sale_unit_qty, 'production_unit_stock_out' => $production_unit_qty, 'currency' => $currency_data['uid'], 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'currency_usd_equalance' => $currency_data['usd_equalance'], 'item_currency' => $item_currency_data['uid'], 'item_currency_name' => $item_currency_data['name'], 'item_currency_symbol' => $item_currency_data['symbol'], 'item_currency_usd_equalance' => $item_currency_data['usd_equalance'], 'purchase_unit_cost' => $purchase_unit_cost, 'sale_unit_cost' => $sale_unit_cost, 'production_unit_cost' => $production_unit_cost, 'item_currency_purchase_unit_cost' => $item_currency_purchase_unit_cost, 'item_currency_sale_unit_cost' => $item_currency_sale_unit_cost, 'item_currency_production_unit_cost' => $item_currency_production_unit_cost, 'purchase_unit_real_cost' => $purchase_unit_real_cost, 'sale_unit_real_cost' => $sale_unit_real_cost, 'production_unit_real_cost' => $production_unit_real_cost, 'item_currency_purchase_unit_real_cost' => $item_currency_purchase_unit_real_cost, 'item_currency_sale_unit_real_cost' => $item_currency_sale_unit_real_cost, 'item_currency_production_unit_real_cost' => $item_currency_production_unit_real_cost, 'purchase_unit_profit' => $purchase_unit_profit, 'sale_unit_profit' => $sale_unit_profit, 'production_unit_profit' => $production_unit_profit, 'item_currency_purchase_unit_profit' => $item_currency_purchase_unit_profit, 'item_currency_sale_unit_profit' => $item_currency_sale_unit_profit, 'item_currency_production_unit_profit' => $item_currency_production_unit_profit, 'purchase_unit_sale_price' => $purchase_unit_sale_price, 'sale_unit_sale_price' => $sale_unit_sale_price, 'production_unit_sale_price' => $production_unit_sale_price, 'item_currency_purchase_unit_sale_price' => $item_currency_purchase_unit_sale_price, 'item_currency_sale_unit_sale_price' => $item_currency_sale_unit_sale_price, 'item_currency_production_unit_sale_price' => $item_currency_production_unit_sale_price, 'purchase_unit_expense' => $purchase_unit_expense, 'sale_unit_expense' => $sale_unit_expense, 'production_unit_expense' => $production_unit_expense, 'item_currency_purchase_unit_expense' => $item_currency_purchase_unit_expense, 'item_currency_sale_unit_expense' => $item_currency_sale_unit_expense, 'item_currency_production_unit_expense' => $item_currency_production_unit_expense, ]; insert_table('items_inventory_stats',$inventory_array); _calculate_item_wise_stats(['item' => $inventory_array['item']]); } if($db_entry['pro_type'] == 'produced') { $item_data = fetch_table_where('items','uid',$db_entry['item'],TRUE); $item_currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $currency_data = fetch_table_where('currency','uid',$db_entry['currency'],TRUE); $warehouse_data = fetch_table_where('warehouse','uid',$db_entry['warehouse'],TRUE); $sale_unit_equalance = (float)$item_data['sale_unit_equalance']; if($sale_unit_equalance == 0){ $sale_unit_equalance = 1; } $production_unit_equalance = (float)$item_data['production_unit_equalance']; if($production_unit_equalance == 0){ $production_unit_equalance = 1; } $item_currency = $item_data['currency']; $item_currency_usd_equalance = $item_data['currency_usd_equalance']; $item_currency_cost = (float)$db_entry['cost']; $item_currency_real_cost = (float)$db_entry['cost']; $item_currency_profit = (float)$db_entry['profit']; $item_currency_sale_price = (float)$db_entry['sale_price']; if($item_currency != $db_entry['currency']) { $item_currency_cost = amount_conversion((float)$db_entry['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_real_cost = amount_conversion((float)$db_entry['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_profit = amount_conversion((float)$db_entry['profit'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_sale_price = amount_conversion((float)$db_entry['sale_price'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); } if($db_entry['unit'] == 'purchase') { $purchase_unit_qty = (float)$db_entry['qty']; $sale_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $production_unit_qty = (float)$db_entry['qty'] * $production_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost']; $sale_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost; $item_currency_sale_unit_cost = $item_currency_cost / $sale_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost / $production_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['cost']; $sale_unit_real_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_real_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost; $item_currency_sale_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost / $production_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit']; $sale_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $production_unit_profit = (float)$db_entry['profit'] / $production_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit; $item_currency_sale_unit_profit = $item_currency_profit / $sale_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit / $production_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price']; $sale_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price'] / $production_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price; $item_currency_sale_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price / $production_unit_equalance; } else if($db_entry['unit'] == 'sale') { $purchase_unit_qty = (float)$db_entry['qty'] / $sale_unit_equalance; $sale_unit_qty = (float)$db_entry['qty']; $production_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_cost = (float)$db_entry['cost']; $production_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost * $sale_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost; $item_currency_production_unit_cost = $item_currency_cost / $sale_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_real_cost = (float)$db_entry['cost']; $production_unit_real_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $sale_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost; $item_currency_production_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit'] * $sale_unit_equalance; $sale_unit_profit = (float)$db_entry['profit']; $production_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit * $sale_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit; $item_currency_production_unit_profit = $item_currency_profit / $sale_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $sale_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price']; $production_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $sale_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price; $item_currency_production_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; } else { $purchase_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $sale_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $production_unit_qty = (float)$db_entry['qty']; $purchase_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost; $purchase_unit_real_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_real_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_real_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost; $purchase_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $sale_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $production_unit_profit = (float)$db_entry['profit']; $item_currency_purchase_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price']; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price; } $inventory_array = [ 'uid' => getUniqueId('ITINT', 'items_inventory_stats', 'uid'), 'branch' => $db_entry['branch'], 'event_date' => $db_entry['event_date'], 'item' => $item_data['uid'], 'item_name' => $item_data['name'], 'item_category' => $item_data['category'], 'item_type' => $item_data['type'], 'warehouse' => $warehouse_data['uid'], 'warehouse_name' => $warehouse_data['name'], 'batch' => $db_entry['batch'], 'invoice' => $db_entry['invoice'], 'module_uid' => $db_entry['production_id'], 'module_name' => 'production_in', 'purchase_unit_stock_in' => $purchase_unit_qty, 'sale_unit_stock_in' => $sale_unit_qty, 'production_unit_stock_in' => $production_unit_qty, 'currency' => $currency_data['uid'], 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'currency_usd_equalance' => $currency_data['usd_equalance'], 'item_currency' => $item_currency_data['uid'], 'item_currency_name' => $item_currency_data['name'], 'item_currency_symbol' => $item_currency_data['symbol'], 'item_currency_usd_equalance' => $item_currency_data['usd_equalance'], 'purchase_unit_cost' => $purchase_unit_cost, 'sale_unit_cost' => $sale_unit_cost, 'production_unit_cost' => $production_unit_cost, 'item_currency_purchase_unit_cost' => $item_currency_purchase_unit_cost, 'item_currency_sale_unit_cost' => $item_currency_sale_unit_cost, 'item_currency_production_unit_cost' => $item_currency_production_unit_cost, 'purchase_unit_real_cost' => $purchase_unit_real_cost, 'sale_unit_real_cost' => $sale_unit_real_cost, 'production_unit_real_cost' => $production_unit_real_cost, 'item_currency_purchase_unit_real_cost' => $item_currency_purchase_unit_real_cost, 'item_currency_sale_unit_real_cost' => $item_currency_sale_unit_real_cost, 'item_currency_production_unit_real_cost' => $item_currency_production_unit_real_cost, 'purchase_unit_profit' => $purchase_unit_profit, 'sale_unit_profit' => $sale_unit_profit, 'production_unit_profit' => $production_unit_profit, 'item_currency_purchase_unit_profit' => $item_currency_purchase_unit_profit, 'item_currency_sale_unit_profit' => $item_currency_sale_unit_profit, 'item_currency_production_unit_profit' => $item_currency_production_unit_profit, 'purchase_unit_sale_price' => $purchase_unit_sale_price, 'sale_unit_sale_price' => $sale_unit_sale_price, 'production_unit_sale_price' => $production_unit_sale_price, 'item_currency_purchase_unit_sale_price' => $item_currency_purchase_unit_sale_price, 'item_currency_sale_unit_sale_price' => $item_currency_sale_unit_sale_price, 'item_currency_production_unit_sale_price' => $item_currency_production_unit_sale_price, ]; insert_table('items_inventory_stats',$inventory_array); _calculate_item_wise_stats(['item' => $inventory_array['item']]); } } } } } function _handle_items_inventory_stats_from_production($sources) { $uid = $sources['uid']; $entry_status = $sources['entry_status']; $db_entries = fetch_table_where('production_details','production_id',$uid); if($entry_status == 'update' OR $entry_status == 'delete') { delete_table('items_inventory_stats','module_uid',$uid); } if($entry_status == 'new' OR $entry_status == 'update') { if(!empty($db_entries)) { foreach($db_entries as $db_entry) { if($db_entry['pro_type'] == 'raw') { $item_data = fetch_table_where('items','uid',$db_entry['item'],TRUE); $item_currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $currency_data = fetch_table_where('currency','uid',$db_entry['currency'],TRUE); $warehouse_data = fetch_table_where('warehouse','uid',$db_entry['warehouse'],TRUE); $expense_account_data = []; $sale_unit_equalance = (float)$item_data['sale_unit_equalance']; if($sale_unit_equalance == 0){ $sale_unit_equalance = 1; } $production_unit_equalance = (float)$item_data['production_unit_equalance']; if($production_unit_equalance == 0){ $production_unit_equalance = 1; } $item_currency = $item_data['currency']; $item_currency_usd_equalance = $item_data['currency_usd_equalance']; $item_currency_cost = (float)$db_entry['cost']; $item_currency_real_cost = (float)$db_entry['real_cost']; $item_currency_profit = (float)$db_entry['profit']; $item_currency_sale_price = (float)$db_entry['sale_price']; if($item_currency != $db_entry['currency']) { $item_currency_cost = amount_conversion((float)$db_entry['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_real_cost = amount_conversion((float)$db_entry['real_cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_profit = amount_conversion((float)$db_entry['profit'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_sale_price = amount_conversion((float)$db_entry['sale_price'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); } if($db_entry['unit'] == 'purchase') { $purchase_unit_qty = (float)$db_entry['qty']; $sale_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $production_unit_qty = (float)$db_entry['qty'] * $production_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost']; $sale_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost; $item_currency_sale_unit_cost = $item_currency_cost / $sale_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost / $production_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['real_cost']; $sale_unit_real_cost = (float)$db_entry['real_cost'] / $sale_unit_equalance; $production_unit_real_cost = (float)$db_entry['real_cost'] / $production_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost; $item_currency_sale_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost / $production_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit']; $sale_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $production_unit_profit = (float)$db_entry['profit'] / $production_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit; $item_currency_sale_unit_profit = $item_currency_profit / $sale_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit / $production_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price']; $sale_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price'] / $production_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price; $item_currency_sale_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price / $production_unit_equalance; } else if($db_entry['unit'] == 'sale') { $purchase_unit_qty = (float)$db_entry['qty'] / $sale_unit_equalance; $sale_unit_qty = (float)$db_entry['qty']; $production_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_cost = (float)$db_entry['cost']; $production_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost * $sale_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost; $item_currency_production_unit_cost = $item_currency_cost / $sale_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['real_cost'] * $sale_unit_equalance; $sale_unit_real_cost = (float)$db_entry['real_cost']; $production_unit_real_cost = (float)$db_entry['real_cost'] / $sale_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $sale_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost; $item_currency_production_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit'] * $sale_unit_equalance; $sale_unit_profit = (float)$db_entry['profit']; $production_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit * $sale_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit; $item_currency_production_unit_profit = $item_currency_profit / $sale_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $sale_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price']; $production_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $sale_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price; $item_currency_production_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; } else { $purchase_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $sale_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $production_unit_qty = (float)$db_entry['qty']; $purchase_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost; $purchase_unit_real_cost = (float)$db_entry['real_cost'] * $production_unit_equalance; $sale_unit_real_cost = (float)$db_entry['real_cost'] * $production_unit_equalance; $production_unit_real_cost = (float)$db_entry['real_cost']; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost; $purchase_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $sale_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $production_unit_profit = (float)$db_entry['profit']; $item_currency_purchase_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price']; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price; } $inventory_array = [ 'uid' => getUniqueId('ITINT', 'items_inventory_stats', 'uid'), 'branch' => $db_entry['branch'], 'event_date' => $db_entry['event_date'], 'item' => $item_data['uid'], 'item_name' => $item_data['name'], 'item_category' => $item_data['category'], 'item_type' => $item_data['type'], 'warehouse' => $warehouse_data['uid'], 'warehouse_name' => $warehouse_data['name'], 'expense_account' => isset($expense_account_data['uid']) ? $expense_account_data['uid'] : null, 'expense_account_name' => isset($expense_account_data['name']) ? $expense_account_data['name'] : null, 'batch' => $db_entry['batch'], 'invoice' => $db_entry['invoice'], 'module_uid' => $db_entry['production_id'], 'module_name' => 'production_out', 'purchase_unit_stock_out' => $purchase_unit_qty, 'sale_unit_stock_out' => $sale_unit_qty, 'production_unit_stock_out' => $production_unit_qty, 'currency' => $currency_data['uid'], 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'currency_usd_equalance' => $currency_data['usd_equalance'], 'item_currency' => $item_currency_data['uid'], 'item_currency_name' => $item_currency_data['name'], 'item_currency_symbol' => $item_currency_data['symbol'], 'item_currency_usd_equalance' => $item_currency_data['usd_equalance'], 'purchase_unit_cost' => $purchase_unit_cost, 'sale_unit_cost' => $sale_unit_cost, 'production_unit_cost' => $production_unit_cost, 'item_currency_purchase_unit_cost' => $item_currency_purchase_unit_cost, 'item_currency_sale_unit_cost' => $item_currency_sale_unit_cost, 'item_currency_production_unit_cost' => $item_currency_production_unit_cost, 'purchase_unit_real_cost' => $purchase_unit_real_cost, 'sale_unit_real_cost' => $sale_unit_real_cost, 'production_unit_real_cost' => $production_unit_real_cost, 'item_currency_purchase_unit_real_cost' => $item_currency_purchase_unit_real_cost, 'item_currency_sale_unit_real_cost' => $item_currency_sale_unit_real_cost, 'item_currency_production_unit_real_cost' => $item_currency_production_unit_real_cost, 'purchase_unit_profit' => $purchase_unit_profit, 'sale_unit_profit' => $sale_unit_profit, 'production_unit_profit' => $production_unit_profit, 'item_currency_purchase_unit_profit' => $item_currency_purchase_unit_profit, 'item_currency_sale_unit_profit' => $item_currency_sale_unit_profit, 'item_currency_production_unit_profit' => $item_currency_production_unit_profit, 'purchase_unit_sale_price' => $purchase_unit_sale_price, 'sale_unit_sale_price' => $sale_unit_sale_price, 'production_unit_sale_price' => $production_unit_sale_price, 'item_currency_purchase_unit_sale_price' => $item_currency_purchase_unit_sale_price, 'item_currency_sale_unit_sale_price' => $item_currency_sale_unit_sale_price, 'item_currency_production_unit_sale_price' => $item_currency_production_unit_sale_price, ]; insert_table('items_inventory_stats',$inventory_array); _calculate_item_wise_stats(['item' => $inventory_array['item']]); } if($db_entry['pro_type'] == 'produced') { $item_data = fetch_table_where('items','uid',$db_entry['item'],TRUE); $item_currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $currency_data = fetch_table_where('currency','uid',$db_entry['currency'],TRUE); $warehouse_data = fetch_table_where('warehouse','uid',$db_entry['warehouse'],TRUE); $sale_unit_equalance = (float)$item_data['sale_unit_equalance']; if($sale_unit_equalance == 0){ $sale_unit_equalance = 1; } $production_unit_equalance = (float)$item_data['production_unit_equalance']; if($production_unit_equalance == 0){ $production_unit_equalance = 1; } $item_currency = $item_data['currency']; $item_currency_usd_equalance = $item_data['currency_usd_equalance']; $item_currency_cost = (float)$db_entry['cost']; $item_currency_real_cost = (float)$db_entry['cost']; $item_currency_profit = (float)$db_entry['profit']; $item_currency_sale_price = (float)$db_entry['sale_price']; if($item_currency != $db_entry['currency']) { $item_currency_cost = amount_conversion((float)$db_entry['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_real_cost = amount_conversion((float)$db_entry['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_profit = amount_conversion((float)$db_entry['profit'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_sale_price = amount_conversion((float)$db_entry['sale_price'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); } if($db_entry['unit'] == 'purchase') { $purchase_unit_qty = (float)$db_entry['qty']; $sale_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $production_unit_qty = (float)$db_entry['qty'] * $production_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost']; $sale_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost; $item_currency_sale_unit_cost = $item_currency_cost / $sale_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost / $production_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['cost']; $sale_unit_real_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_real_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost; $item_currency_sale_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost / $production_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit']; $sale_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $production_unit_profit = (float)$db_entry['profit'] / $production_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit; $item_currency_sale_unit_profit = $item_currency_profit / $sale_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit / $production_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price']; $sale_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price'] / $production_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price; $item_currency_sale_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price / $production_unit_equalance; } else if($db_entry['unit'] == 'sale') { $purchase_unit_qty = (float)$db_entry['qty'] / $sale_unit_equalance; $sale_unit_qty = (float)$db_entry['qty']; $production_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_cost = (float)$db_entry['cost']; $production_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost * $sale_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost; $item_currency_production_unit_cost = $item_currency_cost / $sale_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_real_cost = (float)$db_entry['cost']; $production_unit_real_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $sale_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost; $item_currency_production_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit'] * $sale_unit_equalance; $sale_unit_profit = (float)$db_entry['profit']; $production_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit * $sale_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit; $item_currency_production_unit_profit = $item_currency_profit / $sale_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $sale_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price']; $production_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $sale_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price; $item_currency_production_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; } else { $purchase_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $sale_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $production_unit_qty = (float)$db_entry['qty']; $purchase_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost; $purchase_unit_real_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_real_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_real_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost; $purchase_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $sale_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $production_unit_profit = (float)$db_entry['profit']; $item_currency_purchase_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price']; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price; } $inventory_array = [ 'uid' => getUniqueId('ITINT', 'items_inventory_stats', 'uid'), 'branch' => $db_entry['branch'], 'event_date' => $db_entry['event_date'], 'item' => $item_data['uid'], 'item_name' => $item_data['name'], 'item_category' => $item_data['category'], 'item_type' => $item_data['type'], 'warehouse' => $warehouse_data['uid'], 'warehouse_name' => $warehouse_data['name'], 'batch' => $db_entry['batch'], 'invoice' => $db_entry['invoice'], 'module_uid' => $db_entry['production_id'], 'module_name' => 'production_in', 'purchase_unit_stock_in' => $purchase_unit_qty, 'sale_unit_stock_in' => $sale_unit_qty, 'production_unit_stock_in' => $production_unit_qty, 'currency' => $currency_data['uid'], 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'currency_usd_equalance' => $currency_data['usd_equalance'], 'item_currency' => $item_currency_data['uid'], 'item_currency_name' => $item_currency_data['name'], 'item_currency_symbol' => $item_currency_data['symbol'], 'item_currency_usd_equalance' => $item_currency_data['usd_equalance'], 'purchase_unit_cost' => $purchase_unit_cost, 'sale_unit_cost' => $sale_unit_cost, 'production_unit_cost' => $production_unit_cost, 'item_currency_purchase_unit_cost' => $item_currency_purchase_unit_cost, 'item_currency_sale_unit_cost' => $item_currency_sale_unit_cost, 'item_currency_production_unit_cost' => $item_currency_production_unit_cost, 'purchase_unit_real_cost' => $purchase_unit_real_cost, 'sale_unit_real_cost' => $sale_unit_real_cost, 'production_unit_real_cost' => $production_unit_real_cost, 'item_currency_purchase_unit_real_cost' => $item_currency_purchase_unit_real_cost, 'item_currency_sale_unit_real_cost' => $item_currency_sale_unit_real_cost, 'item_currency_production_unit_real_cost' => $item_currency_production_unit_real_cost, 'purchase_unit_profit' => $purchase_unit_profit, 'sale_unit_profit' => $sale_unit_profit, 'production_unit_profit' => $production_unit_profit, 'item_currency_purchase_unit_profit' => $item_currency_purchase_unit_profit, 'item_currency_sale_unit_profit' => $item_currency_sale_unit_profit, 'item_currency_production_unit_profit' => $item_currency_production_unit_profit, 'purchase_unit_sale_price' => $purchase_unit_sale_price, 'sale_unit_sale_price' => $sale_unit_sale_price, 'production_unit_sale_price' => $production_unit_sale_price, 'item_currency_purchase_unit_sale_price' => $item_currency_purchase_unit_sale_price, 'item_currency_sale_unit_sale_price' => $item_currency_sale_unit_sale_price, 'item_currency_production_unit_sale_price' => $item_currency_production_unit_sale_price, ]; insert_table('items_inventory_stats',$inventory_array); _calculate_item_wise_stats(['item' => $inventory_array['item']]); } } } } } function _handle_items_inventory_stats_from_production_raw($sources) { $uid = $sources['uid']; $entry_status = $sources['entry_status']; $db_entries = fetch_table_where('production_raw_details','production_id',$uid); if($entry_status == 'update' OR $entry_status == 'delete') { delete_table('items_inventory_stats','module_uid',$uid); } if($entry_status == 'new' OR $entry_status == 'update') { if(!empty($db_entries)) { foreach($db_entries as $db_entry) { if($db_entry['pro_type'] == 'raw') { $item_data = fetch_table_where('items','uid',$db_entry['item'],TRUE); $item_currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $currency_data = fetch_table_where('currency','uid',$db_entry['currency'],TRUE); $warehouse_data = fetch_table_where('warehouse','uid',$db_entry['warehouse'],TRUE); $expense_account_data = []; $sale_unit_equalance = (float)$item_data['sale_unit_equalance']; if($sale_unit_equalance == 0){ $sale_unit_equalance = 1; } $production_unit_equalance = (float)$item_data['production_unit_equalance']; if($production_unit_equalance == 0){ $production_unit_equalance = 1; } $item_currency = $item_data['currency']; $item_currency_usd_equalance = $item_data['currency_usd_equalance']; $item_currency_cost = (float)$db_entry['cost']; $item_currency_real_cost = (float)$db_entry['real_cost']; $item_currency_profit = (float)$db_entry['profit']; $item_currency_sale_price = (float)$db_entry['sale_price']; if($item_currency != $db_entry['currency']) { $item_currency_cost = amount_conversion((float)$db_entry['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_real_cost = amount_conversion((float)$db_entry['real_cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_profit = amount_conversion((float)$db_entry['profit'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_sale_price = amount_conversion((float)$db_entry['sale_price'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); } if($db_entry['unit'] == 'purchase') { $purchase_unit_qty = (float)$db_entry['qty']; $sale_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $production_unit_qty = (float)$db_entry['qty'] * $production_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost']; $sale_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost; $item_currency_sale_unit_cost = $item_currency_cost / $sale_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost / $production_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['real_cost']; $sale_unit_real_cost = (float)$db_entry['real_cost'] / $sale_unit_equalance; $production_unit_real_cost = (float)$db_entry['real_cost'] / $production_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost; $item_currency_sale_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost / $production_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit']; $sale_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $production_unit_profit = (float)$db_entry['profit'] / $production_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit; $item_currency_sale_unit_profit = $item_currency_profit / $sale_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit / $production_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price']; $sale_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price'] / $production_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price; $item_currency_sale_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price / $production_unit_equalance; } else if($db_entry['unit'] == 'sale') { $purchase_unit_qty = (float)$db_entry['qty'] / $sale_unit_equalance; $sale_unit_qty = (float)$db_entry['qty']; $production_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_cost = (float)$db_entry['cost']; $production_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost * $sale_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost; $item_currency_production_unit_cost = $item_currency_cost / $sale_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['real_cost'] * $sale_unit_equalance; $sale_unit_real_cost = (float)$db_entry['real_cost']; $production_unit_real_cost = (float)$db_entry['real_cost'] / $sale_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $sale_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost; $item_currency_production_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit'] * $sale_unit_equalance; $sale_unit_profit = (float)$db_entry['profit']; $production_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit * $sale_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit; $item_currency_production_unit_profit = $item_currency_profit / $sale_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $sale_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price']; $production_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $sale_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price; $item_currency_production_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; } else { $purchase_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $sale_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $production_unit_qty = (float)$db_entry['qty']; $purchase_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost; $purchase_unit_real_cost = (float)$db_entry['real_cost'] * $production_unit_equalance; $sale_unit_real_cost = (float)$db_entry['real_cost'] * $production_unit_equalance; $production_unit_real_cost = (float)$db_entry['real_cost']; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost; $purchase_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $sale_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $production_unit_profit = (float)$db_entry['profit']; $item_currency_purchase_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price']; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price; } $inventory_array = [ 'uid' => getUniqueId('ITINT', 'items_inventory_stats', 'uid'), 'branch' => $db_entry['branch'], 'event_date' => $db_entry['event_date'], 'item' => $item_data['uid'], 'item_name' => $item_data['name'], 'item_category' => $item_data['category'], 'item_type' => $item_data['type'], 'warehouse' => $warehouse_data['uid'], 'warehouse_name' => $warehouse_data['name'], 'expense_account' => isset($expense_account_data['uid']) ? $expense_account_data['uid'] : null, 'expense_account_name' => isset($expense_account_data['name']) ? $expense_account_data['name'] : null, 'batch' => $db_entry['batch'], 'invoice' => $db_entry['invoice'], 'module_uid' => $db_entry['production_id'], 'module_name' => 'production_out', 'purchase_unit_stock_out' => $purchase_unit_qty, 'sale_unit_stock_out' => $sale_unit_qty, 'production_unit_stock_out' => $production_unit_qty, 'currency' => $currency_data['uid'], 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'currency_usd_equalance' => $currency_data['usd_equalance'], 'item_currency' => $item_currency_data['uid'], 'item_currency_name' => $item_currency_data['name'], 'item_currency_symbol' => $item_currency_data['symbol'], 'item_currency_usd_equalance' => $item_currency_data['usd_equalance'], 'purchase_unit_cost' => $purchase_unit_cost, 'sale_unit_cost' => $sale_unit_cost, 'production_unit_cost' => $production_unit_cost, 'item_currency_purchase_unit_cost' => $item_currency_purchase_unit_cost, 'item_currency_sale_unit_cost' => $item_currency_sale_unit_cost, 'item_currency_production_unit_cost' => $item_currency_production_unit_cost, 'purchase_unit_real_cost' => $purchase_unit_real_cost, 'sale_unit_real_cost' => $sale_unit_real_cost, 'production_unit_real_cost' => $production_unit_real_cost, 'item_currency_purchase_unit_real_cost' => $item_currency_purchase_unit_real_cost, 'item_currency_sale_unit_real_cost' => $item_currency_sale_unit_real_cost, 'item_currency_production_unit_real_cost' => $item_currency_production_unit_real_cost, 'purchase_unit_profit' => $purchase_unit_profit, 'sale_unit_profit' => $sale_unit_profit, 'production_unit_profit' => $production_unit_profit, 'item_currency_purchase_unit_profit' => $item_currency_purchase_unit_profit, 'item_currency_sale_unit_profit' => $item_currency_sale_unit_profit, 'item_currency_production_unit_profit' => $item_currency_production_unit_profit, 'purchase_unit_sale_price' => $purchase_unit_sale_price, 'sale_unit_sale_price' => $sale_unit_sale_price, 'production_unit_sale_price' => $production_unit_sale_price, 'item_currency_purchase_unit_sale_price' => $item_currency_purchase_unit_sale_price, 'item_currency_sale_unit_sale_price' => $item_currency_sale_unit_sale_price, 'item_currency_production_unit_sale_price' => $item_currency_production_unit_sale_price, ]; insert_table('items_inventory_stats',$inventory_array); _calculate_item_wise_stats(['item' => $inventory_array['item']]); } if($db_entry['pro_type'] == 'produced') { $item_data = fetch_table_where('items','uid',$db_entry['item'],TRUE); $item_currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $currency_data = fetch_table_where('currency','uid',$db_entry['currency'],TRUE); $warehouse_data = fetch_table_where('warehouse','uid',$db_entry['warehouse'],TRUE); $sale_unit_equalance = (float)$item_data['sale_unit_equalance']; if($sale_unit_equalance == 0){ $sale_unit_equalance = 1; } $production_unit_equalance = (float)$item_data['production_unit_equalance']; if($production_unit_equalance == 0){ $production_unit_equalance = 1; } $item_currency = $item_data['currency']; $item_currency_usd_equalance = $item_data['currency_usd_equalance']; $item_currency_cost = (float)$db_entry['cost']; $item_currency_real_cost = (float)$db_entry['cost']; $item_currency_profit = (float)$db_entry['profit']; $item_currency_sale_price = (float)$db_entry['sale_price']; if($item_currency != $db_entry['currency']) { $item_currency_cost = amount_conversion((float)$db_entry['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_real_cost = amount_conversion((float)$db_entry['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_profit = amount_conversion((float)$db_entry['profit'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_sale_price = amount_conversion((float)$db_entry['sale_price'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); } if($db_entry['unit'] == 'purchase') { $purchase_unit_qty = (float)$db_entry['qty']; $sale_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $production_unit_qty = (float)$db_entry['qty'] * $production_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost']; $sale_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost; $item_currency_sale_unit_cost = $item_currency_cost / $sale_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost / $production_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['cost']; $sale_unit_real_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_real_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost; $item_currency_sale_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost / $production_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit']; $sale_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $production_unit_profit = (float)$db_entry['profit'] / $production_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit; $item_currency_sale_unit_profit = $item_currency_profit / $sale_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit / $production_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price']; $sale_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price'] / $production_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price; $item_currency_sale_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price / $production_unit_equalance; } else if($db_entry['unit'] == 'sale') { $purchase_unit_qty = (float)$db_entry['qty'] / $sale_unit_equalance; $sale_unit_qty = (float)$db_entry['qty']; $production_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_cost = (float)$db_entry['cost']; $production_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost * $sale_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost; $item_currency_production_unit_cost = $item_currency_cost / $sale_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_real_cost = (float)$db_entry['cost']; $production_unit_real_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $sale_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost; $item_currency_production_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit'] * $sale_unit_equalance; $sale_unit_profit = (float)$db_entry['profit']; $production_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit * $sale_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit; $item_currency_production_unit_profit = $item_currency_profit / $sale_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $sale_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price']; $production_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $sale_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price; $item_currency_production_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; } else { $purchase_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $sale_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $production_unit_qty = (float)$db_entry['qty']; $purchase_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost; $purchase_unit_real_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_real_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_real_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost; $purchase_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $sale_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $production_unit_profit = (float)$db_entry['profit']; $item_currency_purchase_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price']; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price; } $inventory_array = [ 'uid' => getUniqueId('ITINT', 'items_inventory_stats', 'uid'), 'branch' => $db_entry['branch'], 'event_date' => $db_entry['event_date'], 'item' => $item_data['uid'], 'item_name' => $item_data['name'], 'item_category' => $item_data['category'], 'item_type' => $item_data['type'], 'warehouse' => $warehouse_data['uid'], 'warehouse_name' => $warehouse_data['name'], 'batch' => $db_entry['batch'], 'invoice' => $db_entry['invoice'], 'module_uid' => $db_entry['production_id'], 'module_name' => 'production_in', 'purchase_unit_stock_in' => $purchase_unit_qty, 'sale_unit_stock_in' => $sale_unit_qty, 'production_unit_stock_in' => $production_unit_qty, 'currency' => $currency_data['uid'], 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'currency_usd_equalance' => $currency_data['usd_equalance'], 'item_currency' => $item_currency_data['uid'], 'item_currency_name' => $item_currency_data['name'], 'item_currency_symbol' => $item_currency_data['symbol'], 'item_currency_usd_equalance' => $item_currency_data['usd_equalance'], 'purchase_unit_cost' => $purchase_unit_cost, 'sale_unit_cost' => $sale_unit_cost, 'production_unit_cost' => $production_unit_cost, 'item_currency_purchase_unit_cost' => $item_currency_purchase_unit_cost, 'item_currency_sale_unit_cost' => $item_currency_sale_unit_cost, 'item_currency_production_unit_cost' => $item_currency_production_unit_cost, 'purchase_unit_real_cost' => $purchase_unit_real_cost, 'sale_unit_real_cost' => $sale_unit_real_cost, 'production_unit_real_cost' => $production_unit_real_cost, 'item_currency_purchase_unit_real_cost' => $item_currency_purchase_unit_real_cost, 'item_currency_sale_unit_real_cost' => $item_currency_sale_unit_real_cost, 'item_currency_production_unit_real_cost' => $item_currency_production_unit_real_cost, 'purchase_unit_profit' => $purchase_unit_profit, 'sale_unit_profit' => $sale_unit_profit, 'production_unit_profit' => $production_unit_profit, 'item_currency_purchase_unit_profit' => $item_currency_purchase_unit_profit, 'item_currency_sale_unit_profit' => $item_currency_sale_unit_profit, 'item_currency_production_unit_profit' => $item_currency_production_unit_profit, 'purchase_unit_sale_price' => $purchase_unit_sale_price, 'sale_unit_sale_price' => $sale_unit_sale_price, 'production_unit_sale_price' => $production_unit_sale_price, 'item_currency_purchase_unit_sale_price' => $item_currency_purchase_unit_sale_price, 'item_currency_sale_unit_sale_price' => $item_currency_sale_unit_sale_price, 'item_currency_production_unit_sale_price' => $item_currency_production_unit_sale_price, ]; insert_table('items_inventory_stats',$inventory_array); _calculate_item_wise_stats(['item' => $inventory_array['item']]); } } } } } function _handle_items_inventory_stats_from_production_new($sources) { $uid = $sources['uid']; $entry_status = $sources['entry_status']; $db_entries = fetch_table_where('new_production_details','production_id',$uid); if($entry_status == 'update' OR $entry_status == 'delete') { delete_table('items_inventory_stats','module_uid',$uid); } if($entry_status == 'new' OR $entry_status == 'update') { if(!empty($db_entries)) { foreach($db_entries as $db_entry) { if($db_entry['pro_type'] == 'raw') { $item_data = fetch_table_where('items','uid',$db_entry['item'],TRUE); $item_currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $currency_data = fetch_table_where('currency','uid',$db_entry['currency'],TRUE); $warehouse_data = fetch_table_where('warehouse','uid',$db_entry['warehouse'],TRUE); $expense_account_data = []; $sale_unit_equalance = (float)$item_data['sale_unit_equalance']; if($sale_unit_equalance == 0){ $sale_unit_equalance = 1; } $production_unit_equalance = (float)$item_data['production_unit_equalance']; if($production_unit_equalance == 0){ $production_unit_equalance = 1; } $item_currency = $item_data['currency']; $item_currency_usd_equalance = $item_data['currency_usd_equalance']; $item_currency_cost = (float)$db_entry['cost']; $item_currency_real_cost = (float)$db_entry['real_cost']; $item_currency_profit = (float)$db_entry['profit']; $item_currency_sale_price = (float)$db_entry['sale_price']; if($item_currency != $db_entry['currency']) { $item_currency_cost = amount_conversion((float)$db_entry['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_real_cost = amount_conversion((float)$db_entry['real_cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_profit = amount_conversion((float)$db_entry['profit'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_sale_price = amount_conversion((float)$db_entry['sale_price'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); } if($db_entry['unit'] == 'purchase') { $purchase_unit_qty = (float)$db_entry['qty']; $sale_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $production_unit_qty = (float)$db_entry['qty'] * $production_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost']; $sale_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost; $item_currency_sale_unit_cost = $item_currency_cost / $sale_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost / $production_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['real_cost']; $sale_unit_real_cost = (float)$db_entry['real_cost'] / $sale_unit_equalance; $production_unit_real_cost = (float)$db_entry['real_cost'] / $production_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost; $item_currency_sale_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost / $production_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit']; $sale_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $production_unit_profit = (float)$db_entry['profit'] / $production_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit; $item_currency_sale_unit_profit = $item_currency_profit / $sale_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit / $production_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price']; $sale_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price'] / $production_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price; $item_currency_sale_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price / $production_unit_equalance; } else if($db_entry['unit'] == 'sale') { $purchase_unit_qty = (float)$db_entry['qty'] / $sale_unit_equalance; $sale_unit_qty = (float)$db_entry['qty']; $production_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_cost = (float)$db_entry['cost']; $production_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost * $sale_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost; $item_currency_production_unit_cost = $item_currency_cost / $sale_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['real_cost'] * $sale_unit_equalance; $sale_unit_real_cost = (float)$db_entry['real_cost']; $production_unit_real_cost = (float)$db_entry['real_cost'] / $sale_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $sale_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost; $item_currency_production_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit'] * $sale_unit_equalance; $sale_unit_profit = (float)$db_entry['profit']; $production_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit * $sale_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit; $item_currency_production_unit_profit = $item_currency_profit / $sale_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $sale_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price']; $production_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $sale_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price; $item_currency_production_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; } else { $purchase_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $sale_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $production_unit_qty = (float)$db_entry['qty']; $purchase_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost; $purchase_unit_real_cost = (float)$db_entry['real_cost'] * $production_unit_equalance; $sale_unit_real_cost = (float)$db_entry['real_cost'] * $production_unit_equalance; $production_unit_real_cost = (float)$db_entry['real_cost']; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost; $purchase_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $sale_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $production_unit_profit = (float)$db_entry['profit']; $item_currency_purchase_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price']; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price; } $inventory_array = [ 'uid' => getUniqueId('ITINT', 'items_inventory_stats', 'uid'), 'branch' => $db_entry['branch'], 'event_date' => $db_entry['event_date'], 'item' => $item_data['uid'], 'item_name' => $item_data['name'], 'item_category' => $item_data['category'], 'item_type' => $item_data['type'], 'warehouse' => $warehouse_data['uid'], 'warehouse_name' => $warehouse_data['name'], 'expense_account' => isset($expense_account_data['uid']) ? $expense_account_data['uid'] : null, 'expense_account_name' => isset($expense_account_data['name']) ? $expense_account_data['name'] : null, 'batch' => $db_entry['batch'], 'invoice' => $db_entry['invoice'], 'module_uid' => $db_entry['production_id'], 'module_name' => 'production_out', 'purchase_unit_stock_out' => $purchase_unit_qty, 'sale_unit_stock_out' => $sale_unit_qty, 'production_unit_stock_out' => $production_unit_qty, 'currency' => $currency_data['uid'], 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'currency_usd_equalance' => $currency_data['usd_equalance'], 'item_currency' => $item_currency_data['uid'], 'item_currency_name' => $item_currency_data['name'], 'item_currency_symbol' => $item_currency_data['symbol'], 'item_currency_usd_equalance' => $item_currency_data['usd_equalance'], 'purchase_unit_cost' => $purchase_unit_cost, 'sale_unit_cost' => $sale_unit_cost, 'production_unit_cost' => $production_unit_cost, 'item_currency_purchase_unit_cost' => $item_currency_purchase_unit_cost, 'item_currency_sale_unit_cost' => $item_currency_sale_unit_cost, 'item_currency_production_unit_cost' => $item_currency_production_unit_cost, 'purchase_unit_real_cost' => $purchase_unit_real_cost, 'sale_unit_real_cost' => $sale_unit_real_cost, 'production_unit_real_cost' => $production_unit_real_cost, 'item_currency_purchase_unit_real_cost' => $item_currency_purchase_unit_real_cost, 'item_currency_sale_unit_real_cost' => $item_currency_sale_unit_real_cost, 'item_currency_production_unit_real_cost' => $item_currency_production_unit_real_cost, 'purchase_unit_profit' => $purchase_unit_profit, 'sale_unit_profit' => $sale_unit_profit, 'production_unit_profit' => $production_unit_profit, 'item_currency_purchase_unit_profit' => $item_currency_purchase_unit_profit, 'item_currency_sale_unit_profit' => $item_currency_sale_unit_profit, 'item_currency_production_unit_profit' => $item_currency_production_unit_profit, 'purchase_unit_sale_price' => $purchase_unit_sale_price, 'sale_unit_sale_price' => $sale_unit_sale_price, 'production_unit_sale_price' => $production_unit_sale_price, 'item_currency_purchase_unit_sale_price' => $item_currency_purchase_unit_sale_price, 'item_currency_sale_unit_sale_price' => $item_currency_sale_unit_sale_price, 'item_currency_production_unit_sale_price' => $item_currency_production_unit_sale_price, ]; insert_table('items_inventory_stats',$inventory_array); _calculate_item_wise_stats(['item' => $inventory_array['item']]); } if($db_entry['pro_type'] == 'produced') { $item_data = fetch_table_where('items','uid',$db_entry['item'],TRUE); $item_currency_data = fetch_table_where('currency','uid',$item_data['currency'],TRUE); $currency_data = fetch_table_where('currency','uid',$db_entry['currency'],TRUE); $warehouse_data = fetch_table_where('warehouse','uid',$db_entry['warehouse'],TRUE); $sale_unit_equalance = (float)$item_data['sale_unit_equalance']; if($sale_unit_equalance == 0){ $sale_unit_equalance = 1; } $production_unit_equalance = (float)$item_data['production_unit_equalance']; if($production_unit_equalance == 0){ $production_unit_equalance = 1; } $item_currency = $item_data['currency']; $item_currency_usd_equalance = $item_data['currency_usd_equalance']; $item_currency_cost = (float)$db_entry['cost']; $item_currency_real_cost = (float)$db_entry['cost']; $item_currency_profit = (float)$db_entry['profit']; $item_currency_sale_price = (float)$db_entry['sale_price']; if($item_currency != $db_entry['currency']) { $item_currency_cost = amount_conversion((float)$db_entry['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_real_cost = amount_conversion((float)$db_entry['cost'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_profit = amount_conversion((float)$db_entry['profit'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); $item_currency_sale_price = amount_conversion((float)$db_entry['sale_price'], $db_entry['currency_usd_equalance'], $item_currency_usd_equalance); } if($db_entry['unit'] == 'purchase') { $purchase_unit_qty = (float)$db_entry['qty']; $sale_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $production_unit_qty = (float)$db_entry['qty'] * $production_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost']; $sale_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost; $item_currency_sale_unit_cost = $item_currency_cost / $sale_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost / $production_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['cost']; $sale_unit_real_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $production_unit_real_cost = (float)$db_entry['cost'] / $production_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost; $item_currency_sale_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost / $production_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit']; $sale_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $production_unit_profit = (float)$db_entry['profit'] / $production_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit; $item_currency_sale_unit_profit = $item_currency_profit / $sale_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit / $production_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price']; $sale_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price'] / $production_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price; $item_currency_sale_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price / $production_unit_equalance; } else if($db_entry['unit'] == 'sale') { $purchase_unit_qty = (float)$db_entry['qty'] / $sale_unit_equalance; $sale_unit_qty = (float)$db_entry['qty']; $production_unit_qty = (float)$db_entry['qty'] * $sale_unit_equalance; $purchase_unit_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_cost = (float)$db_entry['cost']; $production_unit_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_cost = $item_currency_cost * $sale_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost; $item_currency_production_unit_cost = $item_currency_cost / $sale_unit_equalance; $purchase_unit_real_cost = (float)$db_entry['cost'] * $sale_unit_equalance; $sale_unit_real_cost = (float)$db_entry['cost']; $production_unit_real_cost = (float)$db_entry['cost'] / $sale_unit_equalance; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $sale_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost; $item_currency_production_unit_real_cost = $item_currency_real_cost / $sale_unit_equalance; $purchase_unit_profit = (float)$db_entry['profit'] * $sale_unit_equalance; $sale_unit_profit = (float)$db_entry['profit']; $production_unit_profit = (float)$db_entry['profit'] / $sale_unit_equalance; $item_currency_purchase_unit_profit = $item_currency_profit * $sale_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit; $item_currency_production_unit_profit = $item_currency_profit / $sale_unit_equalance; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $sale_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price']; $production_unit_sale_price = (float)$db_entry['sale_price'] / $sale_unit_equalance; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $sale_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price; $item_currency_production_unit_sale_price = $item_currency_sale_price / $sale_unit_equalance; } else { $purchase_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $sale_unit_qty = (float)$db_entry['qty'] / $production_unit_equalance; $production_unit_qty = (float)$db_entry['qty']; $purchase_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_sale_unit_cost = $item_currency_cost * $production_unit_equalance; $item_currency_production_unit_cost = $item_currency_cost; $purchase_unit_real_cost = (float)$db_entry['cost'] * $production_unit_equalance; $sale_unit_real_cost = (float)$db_entry['cost'] * $production_unit_equalance; $production_unit_real_cost = (float)$db_entry['cost']; $item_currency_purchase_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_sale_unit_real_cost = $item_currency_real_cost * $production_unit_equalance; $item_currency_production_unit_real_cost = $item_currency_real_cost; $purchase_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $sale_unit_profit = (float)$db_entry['profit'] * $production_unit_equalance; $production_unit_profit = (float)$db_entry['profit']; $item_currency_purchase_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_sale_unit_profit = $item_currency_profit * $production_unit_equalance; $item_currency_production_unit_profit = $item_currency_profit; $purchase_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $sale_unit_sale_price = (float)$db_entry['sale_price'] * $production_unit_equalance; $production_unit_sale_price = (float)$db_entry['sale_price']; $item_currency_purchase_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_sale_unit_sale_price = $item_currency_sale_price * $production_unit_equalance; $item_currency_production_unit_sale_price = $item_currency_sale_price; } $inventory_array = [ 'uid' => getUniqueId('ITINT', 'items_inventory_stats', 'uid'), 'branch' => $db_entry['branch'], 'event_date' => $db_entry['event_date'], 'item' => $item_data['uid'], 'item_name' => $item_data['name'], 'item_category' => $item_data['category'], 'item_type' => $item_data['type'], 'warehouse' => $warehouse_data['uid'], 'warehouse_name' => $warehouse_data['name'], 'batch' => $db_entry['batch'], 'invoice' => $db_entry['invoice'], 'module_uid' => $db_entry['production_id'], 'module_name' => 'production_in', 'purchase_unit_stock_in' => $purchase_unit_qty, 'sale_unit_stock_in' => $sale_unit_qty, 'production_unit_stock_in' => $production_unit_qty, 'currency' => $currency_data['uid'], 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'currency_usd_equalance' => $currency_data['usd_equalance'], 'item_currency' => $item_currency_data['uid'], 'item_currency_name' => $item_currency_data['name'], 'item_currency_symbol' => $item_currency_data['symbol'], 'item_currency_usd_equalance' => $item_currency_data['usd_equalance'], 'purchase_unit_cost' => $purchase_unit_cost, 'sale_unit_cost' => $sale_unit_cost, 'production_unit_cost' => $production_unit_cost, 'item_currency_purchase_unit_cost' => $item_currency_purchase_unit_cost, 'item_currency_sale_unit_cost' => $item_currency_sale_unit_cost, 'item_currency_production_unit_cost' => $item_currency_production_unit_cost, 'purchase_unit_real_cost' => $purchase_unit_real_cost, 'sale_unit_real_cost' => $sale_unit_real_cost, 'production_unit_real_cost' => $production_unit_real_cost, 'item_currency_purchase_unit_real_cost' => $item_currency_purchase_unit_real_cost, 'item_currency_sale_unit_real_cost' => $item_currency_sale_unit_real_cost, 'item_currency_production_unit_real_cost' => $item_currency_production_unit_real_cost, 'purchase_unit_profit' => $purchase_unit_profit, 'sale_unit_profit' => $sale_unit_profit, 'production_unit_profit' => $production_unit_profit, 'item_currency_purchase_unit_profit' => $item_currency_purchase_unit_profit, 'item_currency_sale_unit_profit' => $item_currency_sale_unit_profit, 'item_currency_production_unit_profit' => $item_currency_production_unit_profit, 'purchase_unit_sale_price' => $purchase_unit_sale_price, 'sale_unit_sale_price' => $sale_unit_sale_price, 'production_unit_sale_price' => $production_unit_sale_price, 'item_currency_purchase_unit_sale_price' => $item_currency_purchase_unit_sale_price, 'item_currency_sale_unit_sale_price' => $item_currency_sale_unit_sale_price, 'item_currency_production_unit_sale_price' => $item_currency_production_unit_sale_price, ]; insert_table('items_inventory_stats',$inventory_array); _calculate_item_wise_stats(['item' => $inventory_array['item']]); } } } } } function _calculate_item_wise_stats($sources) { $item = $sources['item']; $item_db_record = fetch_table_where('items','uid',$item,true); $item_db_stats = json_decode($item_db_record['stats'],true); $item_avg_cost = isset($item_db_stats['avg_cost']) ? $item_db_stats['avg_cost'] : null; $item_last_cost = isset($item_db_stats['last_cost']) ? $item_db_stats['last_cost'] : null; $item_last_profit = isset($item_db_stats['last_profit']) ? $item_db_stats['last_profit'] : null; $item_mfg_date = isset($item_db_record['mfg_date']) ? $item_db_record['mfg_date'] : null; $item_expiry_date = isset($item_db_record['expiry_date']) ? $item_db_record['expiry_date'] : null; $module = 'items'; $item_total_profit_query = DB::table('items_inventory_stats')->where('item',$item)->where('module_name','sales')->select((DB::raw('sum(purchase_unit_stock_out * item_currency_purchase_unit_profit) as total_profit_amount'))); $item_total_profit_query = std_obj_to_array($item_total_profit_query->get()->first()); $item_total_profit_amount = (float)$item_total_profit_query['total_profit_amount']; $item_last_record_for_stock_in = DB::table('items_inventory_stats')->where('item',$item); $item_last_record_for_stock_in = $item_last_record_for_stock_in->where(function($query) use ($module) { $query->where('module_name','items'); $query->orWhere('module_name','purchases'); $query->orWhere('module_name','production_in'); $query->orWhere('module_name','transfer_in'); $query->orWhere('module_name','branch_transfer_in'); $query->orWhere('module_name','branch_to_branch_transfer_in'); }); $item_last_record_for_stock_in = std_obj_to_array($item_last_record_for_stock_in->orderBy('event_date','desc')->get()->first()); if(!empty($item_last_record_for_stock_in)) { if(!empty($item_last_record_for_stock_in['item_currency_purchase_unit_real_cost']) AND $item_last_record_for_stock_in['item_currency_purchase_unit_real_cost'] != 0){ $item_last_cost = (float)$item_last_record_for_stock_in['item_currency_purchase_unit_real_cost']; } if(!empty($item_last_record_for_stock_in['item_currency_purchase_unit_profit']) AND $item_last_record_for_stock_in['item_currency_purchase_unit_profit'] != 0){ $item_last_profit = (float)$item_last_record_for_stock_in['item_currency_purchase_unit_profit']; } if(!empty($item_last_record_for_stock_in['mfg'])){ $item_mfg_date = $item_last_record_for_stock_in['mfg']; } if(!empty($item_last_record_for_stock_in['expiry'])){ $item_expiry_date = $item_last_record_for_stock_in['expiry']; } } $item_inventory_query = DB::table('items_inventory_stats')->where('item',$item); $item_inventory_query->select( 'warehouse', DB::raw('
                sum(case when 
                module_name = "items"
                then purchase_unit_stock_in END) as opening_units' ), DB::raw('
                sum(case when 
                module_name = "purchases"
                then purchase_unit_stock_in END) as purchase_units' ), DB::raw('
                sum(case when 
                module_name = "purchases"
                then purchase_unit_bonus_in END) as purchase_bonus_units' ), DB::raw('
                sum(case when 
                module_name = "production_in"
                then purchase_unit_stock_in END) as production_in_units' ), DB::raw('
                sum(case when 
                module_name = "production_out"
                then purchase_unit_stock_out END) as production_out_units' ), DB::raw('
                sum(case when 
                module_name = "sales"
                then purchase_unit_stock_out END) as sale_units' ), DB::raw('
                sum(case when 
                module_name = "sales"
                then purchase_unit_bonus_out END) as sale_bonus_units' ), DB::raw('
                sum(case when 
                module_name = "sales_return"
                then purchase_unit_stock_in END) as sale_return_units' ), DB::raw('
                sum(case when 
                module_name = "sales_return"
                then purchase_unit_bonus_in END) as sale_return_bonus_units' ), DB::raw('
                sum(case when 
                module_name = "branch_to_branch_transfer_in"
                then purchase_unit_stock_in END) as branch_to_branch_transfer_in_units' ), DB::raw('
                sum(case when 
                module_name = "branch_to_branch_transfer_out"
                then purchase_unit_stock_out END) as branch_to_branch_transfer_out_units' ), DB::raw('
                sum(case when 
                module_name = "damage"
                then purchase_unit_stock_out END) as damage_units' ), DB::raw('
                sum(case when 
                module_name = "expenses_deductions"
                then purchase_unit_stock_in END) as expenses_deductions_units' ), DB::raw('
                sum(case when 
                module_name = "transfer_in"
                then purchase_unit_stock_in END) as transfer_in_pharma' ), DB::raw('
                sum(case when 
                module_name = "transfer_in"
                then purchase_unit_bonus_in END) as transfer_in_bonus_pharma' ), DB::raw('
                sum(case when 
                module_name = "transfer_out"
                then purchase_unit_stock_out END) as transfer_out_pharma' ), DB::raw('
                sum(case when 
                module_name = "transfer_out"
                then purchase_unit_bonus_out END) as transfer_out_bonus_pharma' ), DB::raw('
                sum(case when 
                module_name = "warehouse_transfer_in"
                then purchase_unit_stock_in END) as transfer_in_units' ), DB::raw('
                sum(case when 
                module_name = "warehouse_transfer_out"
                then purchase_unit_stock_out END) as transfer_out_units' ), DB::raw('
                sum(case when 
                module_name = "branch_transfer_in"
                then purchase_unit_stock_in END) as branch_transfer_in_units' ), DB::raw('
                sum(case when 
                module_name = "branch_transfer_out"
                then purchase_unit_stock_out END) as branch_transfer_out_units' ), DB::raw('
                sum(case when 
                module_name = "purchases"
                then bundle_stock_in END) as bundle_stock_in_units' ), DB::raw('
                sum(case when 
                module_name = "purchases"
                then item_token_in END) as item_token_in_units' ), DB::raw('
                sum(case when 
                module_name = "purchases"
                then toop_stock_in END) as toop_stock_in_units' ), DB::raw('
                sum(case when 
                module_name = "sales"
                then bundle_stock_out END) as bundle_stock_out_units' ), DB::raw('
                sum(case when 
                module_name = "sales"
                then item_token_out END) as item_token_out_units' ), DB::raw('
                sum(case when 
                module_name = "sales"
                then toop_stock_out END) as toop_stock_out_units' ), ); $item_inventory_query->groupBy('warehouse'); $item_inventory_query = std_obj_to_array($item_inventory_query->get()); $item_stats = [ 'opening_units' => [], 'purchase_units' => [], 'production_in_units' => [], 'production_out_units' => [], 'sale_units' => [], 'sale_return_units' => [], 'branch_to_branch_transfer_in_units' => [], 'branch_to_branch_transfer_out_units' => [], 'damage_units' => [], 'expenses_deductions_units' => [], 'transfer_in_units' => [], 'transfer_out_units' => [], 'branch_transfer_in_units' => [], 'branch_transfer_out_units' => [], 'transfer_in_pharma' => [], 'transfer_out_pharma' => [], 'bundle_stock_in_units' => [], 'bundle_stock_out_units' => [], 'toop_stock_in_units' => [], 'toop_stock_out_units' => [], 'item_token_in_units' => [], 'item_token_out_units' => [], 'receiving_units' => [], 'out_units' => [], 'stock_in_units' => [], 'stock_out_units' => [], 'avail_units' => [], ]; if(!empty($item_inventory_query)) { foreach($item_inventory_query as $row) { $receiving_units = 0; $out_units = 0; $stock_in_units = 0; $stock_out_units = 0; $avail_units = 0; if(!empty($row['opening_units']) AND $row['opening_units'] != 0){ $item_stats['opening_units'][$row['warehouse']] = $row['opening_units']; } if((!empty($row['purchase_units']) AND $row['purchase_units'] != 0) OR (!empty($row['purchase_bonus_units']) AND $row['purchase_bonus_units'] != 0)){ $item_stats['purchase_units'][$row['warehouse']] = $row['purchase_units'] + $row['purchase_bonus_units']; } if(!empty($row['production_in_units']) AND $row['production_in_units'] != 0){ $item_stats['production_in_units'][$row['warehouse']] = $row['production_in_units']; } if(!empty($row['production_out_units']) AND $row['production_out_units'] != 0){ $item_stats['production_out_units'][$row['warehouse']] = $row['production_out_units']; } if((!empty($row['sale_units']) AND $row['sale_units'] != 0) OR (!empty($row['sale_bonus_units']) AND $row['sale_bonus_units'] != 0)){ $item_stats['sale_units'][$row['warehouse']] = $row['sale_units'] + $row['sale_bonus_units']; } if((!empty($row['sale_return_units']) AND $row['sale_return_units'] != 0) OR (!empty($row['sale_return_bonus_units']) AND $row['sale_return_bonus_units'] != 0)){ $item_stats['sale_return_units'][$row['warehouse']] = $row['sale_return_units'] + $row['sale_return_bonus_units']; } if(!empty($row['branch_to_branch_transfer_in_units']) AND $row['branch_to_branch_transfer_in_units'] != 0){ $item_stats['branch_to_branch_transfer_in_units'][$row['warehouse']] = $row['branch_to_branch_transfer_in_units']; } if(!empty($row['branch_to_branch_transfer_out_units']) AND $row['branch_to_branch_transfer_out_units'] != 0){ $item_stats['branch_to_branch_transfer_out_units'][$row['warehouse']] = $row['branch_to_branch_transfer_out_units']; } if(!empty($row['damage_units']) AND $row['damage_units'] != 0){ $item_stats['damage_units'][$row['warehouse']] = $row['damage_units']; } if(!empty($row['expenses_deductions_units']) AND $row['expenses_deductions_units'] != 0){ $item_stats['expenses_deductions_units'][$row['warehouse']] = $row['expenses_deductions_units']; } if((!empty($row['transfer_in_pharma']) AND $row['transfer_in_pharma'] != 0) OR (!empty($row['transfer_in_bonus_pharma']) AND $row['transfer_in_bonus_pharma'] != 0)){ $item_stats['transfer_in_pharma'][$row['warehouse']] = $row['transfer_in_pharma'] + $row['transfer_in_bonus_pharma']; } if((!empty($row['transfer_out_pharma']) AND $row['transfer_out_pharma'] != 0) OR (!empty($row['transfer_out_bonus_pharma']) AND $row['transfer_out_bonus_pharma'] != 0)){ $item_stats['transfer_out_pharma'][$row['warehouse']] = $row['transfer_out_pharma'] + $row['transfer_out_bonus_pharma']; } if(!empty($row['transfer_in_units']) AND $row['transfer_in_units'] != 0){ $item_stats['transfer_in_units'][$row['warehouse']] = $row['transfer_in_units']; } if(!empty($row['transfer_out_units']) AND $row['transfer_out_units'] != 0){ $item_stats['transfer_out_units'][$row['warehouse']] = $row['transfer_out_units']; } if(!empty($row['branch_transfer_in_units']) AND $row['branch_transfer_in_units'] != 0){ $item_stats['branch_transfer_in_units'][$row['warehouse']] = $row['branch_transfer_in_units']; } if(!empty($row['branch_transfer_out_units']) AND $row['branch_transfer_out_units'] != 0){ $item_stats['branch_transfer_out_units'][$row['warehouse']] = $row['branch_transfer_out_units']; } if(!empty($row['bundle_stock_in_units']) AND $row['bundle_stock_in_units'] != 0){ $item_stats['bundle_stock_in_units'][$row['warehouse']] = $row['bundle_stock_in_units']; } if(!empty($row['toop_stock_in_units']) AND $row['toop_stock_in_units'] != 0){ $item_stats['toop_stock_in_units'][$row['warehouse']] = $row['toop_stock_in_units']; } if(!empty($row['item_token_in_units']) AND $row['item_token_in_units'] != 0){ $item_stats['item_token_in_units'][$row['warehouse']] = $row['item_token_in_units']; } if(!empty($row['bundle_stock_out_units']) AND $row['bundle_stock_out_units'] != 0){ $item_stats['bundle_stock_out_units'][$row['warehouse']] = $row['bundle_stock_out_units']; } if(!empty($row['toop_stock_out_units']) AND $row['toop_stock_out_units'] != 0){ $item_stats['toop_stock_out_units'][$row['warehouse']] = $row['toop_stock_out_units']; } if(!empty($row['item_token_out_units']) AND $row['item_token_out_units'] != 0){ $item_stats['item_token_out_units'][$row['warehouse']] = $row['item_token_out_units']; } $receiving_units = $row['opening_units'] + $row['purchase_units'] + $row['purchase_bonus_units'] + $row['production_in_units'] + $row['sale_return_units'] + $row['sale_return_bonus_units'] + $row['branch_to_branch_transfer_in_units'] + $row['transfer_in_pharma'] + $row['transfer_in_bonus_pharma'] + $row['transfer_in_units'] + $row['branch_transfer_in_units']; $out_units = $row['production_out_units'] + $row['sale_units'] + $row['sale_bonus_units'] + $row['branch_to_branch_transfer_out_units'] + $row['damage_units'] + $row['expenses_deductions_units'] + $row['transfer_out_pharma'] + $row['transfer_out_bonus_pharma'] + $row['transfer_out_units'] + $row['branch_transfer_out_units']; $avail_units = (float)$receiving_units - (float)$out_units; $item_stats['receiving_units'][$row['warehouse']] = $receiving_units; $item_stats['out_units'][$row['warehouse']] = $out_units; $item_stats['stock_in_units'][$row['warehouse']] = $receiving_units; $item_stats['stock_out_units'][$row['warehouse']] = $out_units; $item_stats['avail_units'][$row['warehouse']] = $avail_units; } } $item_total_purchase_query = DB::table('items_inventory_stats')->where('item',$item)->select((DB::raw('sum(purchase_unit_stock_in * item_currency_purchase_unit_real_cost) as total_purchased_amount, sum(purchase_unit_bonus_in * item_currency_purchase_unit_real_cost) as total_purchased_bonus_amount, sum(purchase_unit_stock_in) as purchased_qty, sum(purchase_unit_bonus_in) as purchased_bonus_qty'))); $item_total_purchase_query = $item_total_purchase_query->where(function($query) use ($module) { $query->where('module_name','items'); $query->orWhere('module_name','purchases'); $query->orWhere('module_name','production_in'); $query->orWhere('module_name','transfer_in'); $query->orWhere('module_name','branch_transfer_in'); $query->orWhere('module_name','branch_to_branch_transfer_in'); $query->orWhere('module_name','warehouse_transfer_in'); }); $item_total_purchase_query = std_obj_to_array($item_total_purchase_query->get()->first()); $item_total_sale_query = DB::table('items_inventory_stats')->where('item',$item)->select((DB::raw('sum(purchase_unit_stock_out * item_currency_purchase_unit_real_cost) as total_sale_amount, sum(purchase_unit_bonus_out * item_currency_purchase_unit_real_cost) as total_sale_bonus_amount, sum(purchase_unit_stock_out) as sale_qty, sum(purchase_unit_bonus_out) as sale_bonus_qty'))); $item_total_sale_query = std_obj_to_array($item_total_sale_query->get()->first()); $item_total_purchase_amount = $item_total_purchase_query['total_purchased_amount'] + $item_total_purchase_query['total_purchased_bonus_amount']; $item_total_sale_amount = $item_total_sale_query['total_sale_amount'] + $item_total_sale_query['total_sale_bonus_amount']; $item_total_purchase_qty = $item_total_purchase_query['purchased_qty'] + $item_total_purchase_query['purchased_bonus_qty']; $item_total_sale_qty = $item_total_sale_query['sale_qty'] + $item_total_sale_query['sale_bonus_qty']; $item_avaialable_units = array_sum($item_stats['avail_units']); if($item_avaialable_units == 0){$item_avaialable_units = 1;} $item_avg_cost = ($item_total_purchase_amount - $item_total_sale_amount) / $item_avaialable_units; $item_stats['avg_cost'] = $item_avg_cost; $item_stats['last_cost'] = $item_last_cost; $item_stats['last_profit'] = $item_last_profit; $item_stats['total_profit'] = $item_total_profit_amount; $item_token_rate = 0; $token_query = std_obj_to_array(DB::table('items_inventory_stats')->where('item',$item)->where('module_name','purchases')->orderBy('event_date','desc')->get()->first()); if(!empty($token_query)) { $item_token_rate = (float)$token_query['token_rate']; } $item_db_array = [ 'mfg_date' => $item_mfg_date, 'expiry_date' => $item_expiry_date, '_avail_units' => array_sum($item_stats['avail_units']), 'ava_bundle' => array_sum($item_stats['bundle_stock_in_units']) - array_sum($item_stats['bundle_stock_out_units']), 'ava_toop' => array_sum($item_stats['toop_stock_in_units']) - array_sum($item_stats['toop_stock_out_units']), '_avg_cost' => $item_stats['avg_cost'], 'token_rate' => $item_token_rate, 'stats' => json_encode($item_stats), ]; update_table('items','uid',$item,$item_db_array); } function sort_day_closing_records($sources) { $lang = get_app_language(); $records = []; if(!empty($sources['sales'])) { foreach($sources['sales'] as $row) { $item_details = json_decode($row['items_details'],true); if(!empty($item_details)) { foreach($item_details as $irow) { $currency_data = fetch_table_where('currency','uid',$row['currency'],true); $client_data = fetch_table_where('accounts','uid',$row['client'],true); $item_data = fetch_table_where('items','uid',$irow['item'],true); $item_name = isset($item_data['name']) ? $item_data['name'] : null; $qty = isset($irow['qty']) ? (float)$irow['qty'] : null; $unit = isset($irow['unit']) ? (float)$irow['unit'] : null; $unit_name = null; if(!empty($item_data)) { if($unit == 'purchase'){ $unit_name = $item_data['purchase_unit_name']; }elseif($unit == 'sale'){$unit_name = $item_data['sale_unit_name'];}elseif($unit == 'production'){$unit_name = $item_data['production_unit_name'];}else{$unit_name = null;} } $details = $item_name.' '.$qty.' '.$unit_name.' '.$row['memo']; $records[] = [ 'date' => $row['created_at'], 'module' => print_lang($lang,'day_closing_view_thead_module_sales'), 'details' => $details, 'cr_currency' => isset($currency_data['name']) ? $currency_data['name'] : null, 'dr_currency' => isset($currency_data['name']) ? $currency_data['name'] : null, 'dr_account' => isset($client_data['name']) ? $client_data['name'] : null, 'debit' => isset($irow['item_total']) ? $irow['item_total'] : null, 'cr_account' => print_lang($lang,'day_closing_view_thead_text_stock'), 'credit' => isset($irow['item_total']) ? $irow['item_total'] : null, ]; } } } } if(!empty($sources['purchases'])) { foreach($sources['purchases'] as $row) { $item_details = json_decode($row['items'],true); if(!empty($item_details)) { foreach($item_details as $irow) { $currency_data = fetch_table_where('currency','uid',$row['currency'],true); $supplier_data = fetch_table_where('accounts','uid',$row['supplier'],true); $item_data = fetch_table_where('items','uid',$irow['item'],true); $item_name = isset($item_data['name']) ? $item_data['name'] : null; $qty = isset($irow['qty']) ? (float)$irow['qty'] : null; $unit = isset($irow['unit']) ? (float)$irow['unit'] : null; $unit_name = null; if(!empty($item_data)) { if($unit == 'purchase'){ $unit_name = $item_data['purchase_unit_name']; }elseif($unit == 'sale'){$unit_name = $item_data['sale_unit_name'];}elseif($unit == 'production'){$unit_name = $item_data['production_unit_name'];}else{$unit_name = null;} } $details = $item_name.' '.$qty.' '.$unit_name.' '.$row['memo']; $records[] = [ 'date' => $row['created_at'], 'module' => print_lang($lang,'day_closing_view_thead_module_purchase'), 'details' => $details, 'cr_currency' => isset($currency_data['name']) ? $currency_data['name'] : null, 'dr_currency' => isset($currency_data['name']) ? $currency_data['name'] : null, 'dr_account' => print_lang($lang,'day_closing_view_thead_text_stock'), 'debit' => isset($irow['total']) ? $irow['total'] : null, 'cr_account' => isset($supplier_data['name']) ? $supplier_data['name'] : null, 'credit' => isset($irow['total']) ? $irow['total'] : null, ]; } } } } if(!empty($sources['expenses'])) { foreach($sources['expenses'] as $row) { $currency_data = fetch_table_where('currency','uid',$row['currency'],true); $account_data = fetch_table_where('accounts','uid',$row['account'],true); $expense_type_data = fetch_table_where('expenses_types','uid',$row['type'],true); $account_name = isset($account_data['name']) ? $account_data['name'] : null; $expense_type_name = isset($expense_type_data['name']) ? $expense_type_data['name'] : null; if(!empty($row['stock_uid'])) { $account_name = print_lang($lang,'mod_item_stock_out_expense_account_name_title'); } $records[] = [ 'date' => $row['exp_date'], 'module' => $expense_type_name, 'details' => $row['narration'], 'cr_currency' => isset($currency_data['name']) ? $currency_data['name'] : null, 'dr_currency' => isset($currency_data['name']) ? $currency_data['name'] : null, 'dr_account' => print_lang($lang,'day_closing_view_thead_text_expense'), 'debit' => isset($row['amount']) ? $row['amount'] : null, 'cr_account' => $account_name, 'credit' => isset($row['amount']) ? $row['amount'] : null, ]; } } if(!empty($sources['extra_income'])) { foreach($sources['extra_income'] as $row) { $currency_data = fetch_table_where('currency','uid',$row['currency'],true); $account_data = fetch_table_where('accounts','uid',$row['account'],true); $records[] = [ 'date' => $row['created_at'], 'module' => print_lang($lang,'day_closing_view_thead_module_extra_income'), 'details' => $row['description'], 'cr_currency' => isset($currency_data['name']) ? $currency_data['name'] : null, 'dr_currency' => isset($currency_data['name']) ? $currency_data['name'] : null, 'dr_account' => isset($account_data['name']) ? $account_data['name'] : null, 'debit' => isset($row['amount']) ? $row['amount'] : null, 'cr_account' => print_lang($lang,'day_closing_view_thead_text_extra_income'), 'credit' => isset($row['amount']) ? $row['amount'] : null, ]; } } if(!empty($sources['item_stock_in'])) { foreach($sources['item_stock_in'] as $row) { $account_data = fetch_table_where('accounts','uid',$row['account'],true); $details = $row['item_name'].' '.$row['quantity'].' '.$row['unit'].' '.$row['details']; $records[] = [ 'date' => $row['event_date'], 'module' => print_lang($lang,'day_closing_view_thead_module_item_stock_in'), 'details' => $details, 'cr_currency' => isset($row['currency_name']) ? $row['currency_name'] : null, 'dr_currency' => isset($row['currency_name']) ? $row['currency_name'] : null, 'dr_account' => print_lang($lang,'day_closing_view_thead_text_stock'), 'debit' => isset($row['total']) ? $row['total'] : null, 'cr_account' => isset($account_data['name']) ? $account_data['name'] : null, 'credit' => isset($row['total']) ? $row['total'] : null, ]; } } if(!empty($sources['journal'])) { foreach($sources['journal'] as $row) { $rcurrency_data = fetch_table_where('currency','uid',$row['receiving_currency'],true); $pcurrency_data = fetch_table_where('currency','uid',$row['payment_currency'],true); $r_account_data = fetch_table_where('accounts','uid',$row['receiving_account'],true); $p_account_data = fetch_table_where('accounts','uid',$row['payment_account'],true); $records[] = [ 'date' => $row['journal_date'], 'module' => print_lang($lang,'day_closing_view_thead_module_journal'), 'details' => $row['receiving_narration'], 'cr_currency' => isset($rcurrency_data['name']) ? $rcurrency_data['name'] : null, 'dr_currency' => isset($pcurrency_data['name']) ? $pcurrency_data['name'] : null, 'dr_account' => isset($p_account_data['name']) ? $p_account_data['name'] : null, 'debit' => isset($row['payment_amount']) ? $row['payment_amount'] : null, 'cr_account' => isset($r_account_data['name']) ? $r_account_data['name'] : null, 'credit' => isset($row['receiving_amount']) ? $row['receiving_amount'] : null, ]; } } return $records; } ?>