<?php
 function _dashboard_calculate_system_sales_return($sources) { $sales_return = DB::table('sales_return')->where('branch',active_branch_id())->where('currency',$sources['currency']); if(isset($sources['date'])) { $sales_return->whereBetween('created_at', [$sources['date'].' 00:00:00', $sources['date'].' 23:59:59']); } $sales_return = $sales_return->sum('refund_total'); return $sales_return; } function _dashboard_calculate_system_extra_income($sources) { $camount = DB::table('extra_income')->where('branch',active_branch_id())->where('currency',$sources['currency']); if(isset($sources['date'])) { $camount->whereBetween('created_at', [$sources['date'].' 00:00:00', $sources['date'].' 23:59:59']); } $camount = $camount->sum('amount'); return $camount; } function _calculate_system_opening_stock($sources) { $item_settings = get_item_settings(); $data_bucket = array(); $all_in_usd = array(); foreach($sources['currencies'] as $currency) { if($item_settings['item_measurements'] == 'get') { $fetch_result = DB::table('items')->select(DB::raw('sum((height * width * opening_stock) * cost) as opening_stock'))->where('branch',active_branch_id())->where('currency',$currency['uid'])->get()->first(); } else { $fetch_result = DB::table('items')->select(DB::raw('sum(opening_stock * cost) as opening_stock'))->where('branch',active_branch_id())->where('currency',$currency['uid'])->get()->first(); } $data_bucket[$currency['uid']] = $fetch_result->opening_stock; $all_in_usd[] = amount_conversion($fetch_result->opening_stock, (float)$currency['usd_equalance'], '1'); } $data_bucket['all_in_usd'] = array_sum($all_in_usd); return $data_bucket; } function _calculate_dashboard_system_opening_stock($sources) { $item_settings = get_item_settings(); if($item_settings['item_measurements'] == 'get') { $fetch_result = DB::table('items')->select(DB::raw('sum((height * width * opening_stock) * cost) as opening_stock'))->where('branch',active_branch_id())->where('currency',$sources['currency']); if(isset($sources['date'])) { $fetch_result->whereBetween('created_at', [$sources['date'].' 00:00:00', $sources['date'].' 23:59:59']); } $fetch_result = $fetch_result->get()->first(); } else { $fetch_result = DB::table('items')->select(DB::raw('sum(opening_stock * cost) as opening_stock'))->where('branch',active_branch_id())->where('currency',$sources['currency']); if(isset($sources['date'])) { $fetch_result->whereBetween('created_at', [$sources['date'].' 00:00:00', $sources['date'].' 23:59:59']); } $fetch_result = $fetch_result->get()->first(); } $opening_stock = $fetch_result->opening_stock; return $opening_stock; } function _calculate_system_purchases_amount($sources) { $data_bucket = array(); $all_in_usd = array(); foreach($sources['currencies'] as $currency) { $purchases_amount = DB::table('purchases')->where('branch',active_branch_id())->where('currency',$currency['uid'])->where('main_approval','approved')->sum('sub_total_amount'); $production_amount = DB::table('production')->where('branch',active_branch_id())->where('currency',$currency['uid'])->sum('total_raw_cost'); $cpurchases_amount = DB::table('cpurchases')->where('branch',active_branch_id())->where('currency',$currency['uid'])->sum('total'); $camount = $purchases_amount + $cpurchases_amount + $production_amount; $data_bucket[$currency['uid']] = $camount; $all_in_usd[] = amount_conversion($camount, (float)$currency['usd_equalance'], '1'); } $data_bucket['all_in_usd'] = array_sum($all_in_usd); return $data_bucket; } function _dashboard_calculate_system_purchases_amount($sources) { $purchases_amount = DB::table('purchases')->where('branch',active_branch_id())->where('main_approval','approved')->where('currency',$sources['currency']); if(isset($sources['date'])) { $purchases_amount->whereBetween('created_at', [$sources['date'].' 00:00:00', $sources['date'].' 23:59:59']); } $purchases_amount = $purchases_amount->sum('sub_total_amount'); $production_amount = DB::table('production')->where('branch',active_branch_id())->where('currency',$sources['currency']); if(isset($sources['date'])) { $production_amount->whereBetween('created_at', [$sources['date'].' 00:00:00', $sources['date'].' 23:59:59']); } $production_amount = $production_amount->sum('total_raw_cost'); $cpurchases_amount = DB::table('cpurchases')->where('branch',active_branch_id())->where('currency',$sources['currency']); if(isset($sources['date'])) { $cpurchases_amount->whereBetween('created_at', [$sources['date'].' 00:00:00', $sources['date'].' 23:59:59']); } $cpurchases_amount = $cpurchases_amount->sum('total'); $camount = $purchases_amount + $cpurchases_amount + $production_amount; return $camount; } function _calculate_system_total_stock($sources) { $processed_bucket = array(); $opening_stock = $sources['_stats']['opening_stock']; $purchases_amount = $sources['_stats']['purchases_amount']; foreach($sources['currencies'] as $currency) { $c_opening_stock = array_key_exists($currency['uid'],$opening_stock) ? $opening_stock[$currency['uid']] : 0; $c_purchases_amount = array_key_exists($currency['uid'],$purchases_amount) ? $purchases_amount[$currency['uid']] : 0; $camount = $c_opening_stock + $c_purchases_amount; $processed_bucket[$currency['uid']] = $camount; } $aiu_opening_stock = array_key_exists('all_in_usd',$opening_stock) ? $opening_stock['all_in_usd'] : 0; $aiu_purchases_amount = array_key_exists('all_in_usd',$purchases_amount) ? $purchases_amount['all_in_usd'] : 0; $processed_bucket['all_in_usd'] = $aiu_opening_stock + $aiu_purchases_amount; return $processed_bucket; } function _calculate_dashboard_system_total_stock($sources) { if(isset($sources['date'])) { $total_stock = $sources['_stats']['today_opening_stock'] + $sources['_stats']['today_purchases_amount']; } else { $total_stock = $sources['_stats']['opening_stock'] + $sources['_stats']['purchases_amount']; } return $total_stock; } function _calculate_dashboard_profit_amount_stock_wise($sources) { if(isset($sources['date'])) { $profit_amount = $sources['_stats']['today_sales_amount'] + $sources['_stats']['today_current_stock'] - $sources['_stats']['today_total_stock']; } else { $profit_amount = $sources['_stats']['sales_amount'] + $sources['_stats']['current_stock'] - $sources['_stats']['total_stock']; } return $profit_amount; } function _calculate_system_sales_amount($sources) { $data_bucket = array(); $all_in_usd = array(); foreach($sources['currencies'] as $currency) { $sales_amount = DB::table('sales')->where('branch',active_branch_id())->where('currency',$currency['uid'])->where('main_approval','approved')->sum('sub_total'); $project_assign_amount = DB::table('projects_assign')->where('branch',active_branch_id())->where('project_currency',$currency['uid'])->where('assign_type','material')->where('status','passed')->sum('item_total'); $camount = $sales_amount + $project_assign_amount; $data_bucket[$currency['uid']] = $camount; $all_in_usd[] = amount_conversion($camount, (float)$currency['usd_equalance'], '1'); } $data_bucket['all_in_usd'] = array_sum($all_in_usd); return $data_bucket; } function _dashboard_calculate_system_sales_amount($sources) { $sales_amount = DB::table('sales')->where('branch',active_branch_id())->where('main_approval','approved')->where('currency',$sources['currency']); if(isset($sources['date'])) { $sales_amount->whereBetween('created_at', [$sources['date'].' 00:00:00', $sources['date'].' 23:59:59']); } $sales_amount = $sales_amount->sum('sub_total'); $project_assign_amount = DB::table('projects_assign')->where('branch',active_branch_id())->where('project_currency',$sources['currency'])->where('assign_type','material')->where('status','passed'); if(isset($sources['date'])) { $project_assign_amount->whereBetween('created_at', [$sources['date'].' 00:00:00', $sources['date'].' 23:59:59']); } $project_assign_amount = $project_assign_amount->sum('item_total'); $camount = $sales_amount + $project_assign_amount; return $camount; } function _calculate_system_damage_stock($sources) { $damages = std_obj_to_array( DB::table('damage')->where('branch',active_branch_id())->get() ); $data_bucket = array(); $all_in_usd = array(); foreach($sources['currencies'] as $currency) { $c_damage_costs = array(); foreach($damages as $damage) { $item_data = fetch_table_where('items','uid',$damage['item'],true); if(isset($item_data['currency']) AND $item_data['currency'] == $currency['uid']) { $item_data['stats'] = json_decode($item_data['stats'],true); $item_avg_cost = (float)$item_data['stats']['avg_cost']; $damage_qty = (float)$damage['qty']; if($damage['unit'] == 'purchase'){ $damage_qty = $damage_qty / (float)$item_data['purchase_unit_equalance']; } if($damage['unit'] == 'sale'){ $damage_qty = $damage_qty / (float)$item_data['sale_unit_equalance']; } if($damage['unit'] == 'production'){ $damage_qty = $damage_qty / (float)$item_data['production_unit_equalance']; } $c_damage_costs[] = $damage_qty * $item_avg_cost; } } $camount = array_sum($c_damage_costs); $data_bucket[$currency['uid']] = $camount; $all_in_usd[] = amount_conversion($camount, (float)$currency['usd_equalance'], '1'); } $data_bucket['all_in_usd'] = array_sum($all_in_usd); return $data_bucket; } function _dashboard_calculate_system_damage_stock($sources) { $damages = std_obj_to_array( DB::table('damage')->where('branch',active_branch_id())->get() ); $c_damage_costs = array(); foreach($damages as $damage) { $item_data = fetch_table_where('items','uid',$damage['item'],true); if(isset($item_data['currency']) AND $item_data['currency'] == $sources['currency']) { $item_data['stats'] = json_decode($item_data['stats'],true); $item_avg_cost = (float)$item_data['stats']['avg_cost']; $damage_qty = (float)$damage['qty']; if($damage['unit'] == 'purchase'){ $damage_qty = $damage_qty / (float)$item_data['purchase_unit_equalance']; } if($damage['unit'] == 'sale'){ $damage_qty = $damage_qty / (float)$item_data['sale_unit_equalance']; } if($damage['unit'] == 'production'){ $damage_qty = $damage_qty / (float)$item_data['production_unit_equalance']; } $c_damage_costs[] = $damage_qty * $item_avg_cost; } } $camount = array_sum($c_damage_costs); return $camount; } function _calculate_system_current_stock($sources) { $item_settings = get_item_settings(); $data_bucket = array(); $all_in_usd = array(); foreach($sources['currencies'] as $currency) { if($item_settings['item_measurements'] == 'get') { $citems = DB::table('items')->select(DB::raw('sum((height * width * _avail_units) * _avg_cost) as amount')); } else { $citems = DB::table('items')->select(DB::raw('sum(_avail_units * _avg_cost) as amount')); } $citems = $citems->where('branch',active_branch_id())->where('currency',$currency['uid'])->get()->first(); $cpurchases_amount = DB::table('cpurchases')->where('branch',active_branch_id())->where('currency',$currency['uid'])->sum('total'); $camount = $citems->amount + $cpurchases_amount; $data_bucket[$currency['uid']] = $camount; $all_in_usd[] = amount_conversion($camount, (float)$currency['usd_equalance'], '1'); } $data_bucket['all_in_usd'] = array_sum($all_in_usd); return $data_bucket; } function _dashboard_calculate_system_current_stock($sources) { $item_settings = get_item_settings(); if($item_settings['item_measurements'] == 'get') { $citems = DB::table('items')->select(DB::raw('sum((height * width * _avail_units) * _avg_cost) as amount')); } else { $citems = DB::table('items')->select(DB::raw('sum(_avail_units * _avg_cost) as amount')); } if(isset($sources['date'])) { $citems->whereBetween('created_at', [$sources['date'].' 00:00:00', $sources['date'].' 23:59:59']); } $citems = $citems->where('branch',active_branch_id())->where('currency',$sources['currency'])->get()->first(); $cpurchases_amount = DB::table('cpurchases')->where('branch',active_branch_id())->where('currency',$sources['currency']); if(isset($sources['date'])) { $cpurchases_amount->whereBetween('created_at', [$sources['date'].' 00:00:00', $sources['date'].' 23:59:59']); } $cpurchases_amount = $cpurchases_amount->sum('total'); $camount = $citems->amount + $cpurchases_amount; return $camount; } function _calculate_system_profit_amount($sources) { $data_bucket = array(); $all_in_usd = array(); foreach($sources['currencies'] as $currency) { $sales_profit = DB::table('sales')->where('branch',active_branch_id())->where('main_approval','approved')->where('currency',$currency['uid'])->sum('total_profit_amount'); $transfer_out_profit = DB::table('transfer_out')->where('branch',active_branch_id())->where('currency',$currency['uid'])->sum('profit'); $services_profit = DB::table('services')->where('branch',active_branch_id())->where('currency',$currency['uid'])->sum('gross_total'); $lot_sales_profit = DB::table('lot_sold')->where('branch',active_branch_id())->where('currency',$currency['uid'])->sum('total_profit'); $projects = std_obj_to_array( DB::table('projects')->where('branch',active_branch_id())->where('currency',$currency['uid'])->where('status','completed')->get() ); $project_profits = array(); foreach($projects as $project) { if($project['currency'] == $currency['uid']) { $project_deductions = calculate_project_deductions($project['uid']); $deductions_balance = (float)$project_deductions['payments'] - (float)$project_deductions['expenses']; $project_profits[] = (float)$project['cost'] - $deductions_balance; } } $camount = $sales_profit; $data_bucket[$currency['uid']] = $camount; $all_in_usd[] = amount_conversion($camount, (float)$currency['usd_equalance'], '1'); } $data_bucket['all_in_usd'] = array_sum($all_in_usd); return $data_bucket; } function _calculate_system_profit_amount_stock_wise($sources) { $data_bucket = array(); $all_in_usd = array(); foreach($sources['currencies'] as $currency) { $currency_sold_stock = $sources['_stats']['sales_amount'][$currency['uid']]; $currency_current_stock = $sources['_stats']['current_stock'][$currency['uid']]; $currency_total_stock = $sources['_stats']['total_stock'][$currency['uid']]; $camount = $currency_sold_stock + $currency_current_stock - $currency_total_stock; $data_bucket[$currency['uid']] = $camount; $all_in_usd[] = amount_conversion($camount, (float)$currency['usd_equalance'], '1'); } $data_bucket['all_in_usd'] = array_sum($all_in_usd); return $data_bucket; } function _calculate_system_profit_amount_pharmaone($sources) { $data_bucket = array(); $all_in_usd = array(); foreach($sources['currencies'] as $currency) { $sales_profit = DB::table('sales')->where('branch',active_branch_id())->where('main_approval','approved')->where('currency',$currency['uid'])->sum('total_profit_amount'); $sales_return_profit = DB::table('sales_return')->where('branch',active_branch_id())->where('currency',$currency['uid'])->sum('return_profit'); $transfer_out_profit = DB::table('transfer_out')->where('branch',active_branch_id())->where('currency',$currency['uid'])->sum('profit'); $services_profit = DB::table('services')->where('branch',active_branch_id())->where('currency',$currency['uid'])->sum('gross_total'); $lot_sales_profit = DB::table('lot_sold')->where('branch',active_branch_id())->where('currency',$currency['uid'])->sum('total_profit'); $extra_income = DB::table('extra_income')->where('branch',active_branch_id())->where('currency',$currency['uid'])->sum('amount'); $projects = std_obj_to_array( DB::table('projects')->where('branch',active_branch_id())->where('currency',$currency['uid'])->where('status','completed')->get() ); $project_profits = array(); foreach($projects as $project) { if($project['currency'] == $currency['uid']) { $project_deductions = calculate_project_deductions($project['uid']); $deductions_balance = (float)$project_deductions['payments'] - (float)$project_deductions['expenses']; $project_profits[] = (float)$project['cost'] - $deductions_balance; } } $camount = $sales_profit - $sales_return_profit + $extra_income + $transfer_out_profit + $services_profit + $lot_sales_profit + array_sum($project_profits); $data_bucket[$currency['uid']] = $camount; $all_in_usd[] = amount_conversion($camount, (float)$currency['usd_equalance'], '1'); } $data_bucket['all_in_usd'] = array_sum($all_in_usd); return $data_bucket; } function _dashboard_calculate_system_profit_amount($sources) { $sales_profit = DB::table('sales')->where('branch',active_branch_id())->where('main_approval','approved')->where('currency',$sources['currency']); if(isset($sources['date'])) { $sales_profit->whereBetween('created_at', [$sources['date'].' 00:00:00', $sources['date'].' 23:59:59']); } $sales_profit = $sales_profit->sum('total_profit_amount'); $transfer_out_profit = DB::table('transfer_out')->where('branch',active_branch_id())->where('currency',$sources['currency']); if(isset($sources['date'])) { $transfer_out_profit->whereBetween('created_at', [$sources['date'].' 00:00:00', $sources['date'].' 23:59:59']); } $transfer_out_profit = $transfer_out_profit->sum('profit'); $services_profit = DB::table('services')->where('branch',active_branch_id())->where('currency',$sources['currency']); if(isset($sources['date'])) { $services_profit->whereBetween('created_at', [$sources['date'].' 00:00:00', $sources['date'].' 23:59:59']); } $services_profit = $services_profit->sum('gross_total'); $lot_sales_profit = DB::table('lot_sold')->where('branch',active_branch_id())->where('currency',$sources['currency']); if(isset($sources['date'])) { $lot_sales_profit->whereBetween('created_at', [$sources['date'].' 00:00:00', $sources['date'].' 23:59:59']); } $lot_sales_profit = $lot_sales_profit->sum('total_profit'); $projects = DB::table('projects')->where('branch',active_branch_id())->where('currency',$sources['currency'])->where('status','completed'); if(isset($sources['date'])) { $projects->whereBetween('start_date', [$sources['date'], $sources['date']]); } $projects = std_obj_to_array( $projects->get() ); $project_profits = array(); foreach($projects as $project) { $project_deductions = calculate_project_deductions($project['uid']); $deductions_balance = (float)$project_deductions['payments'] - (float)$project_deductions['expenses']; $project_profits[] = (float)$project['cost'] - $deductions_balance; } $camount = $sales_profit + $transfer_out_profit + $services_profit + $lot_sales_profit + array_sum($project_profits); return $sales_profit; } function _dashboard_calculate_system_profit_amount_pharmaone($sources) { $sales_profit = DB::table('sales')->where('branch',active_branch_id())->where('main_approval','approved')->where('currency',$sources['currency']); if(isset($sources['date'])) { $sales_profit->whereBetween('created_at', [$sources['date'].' 00:00:00', $sources['date'].' 23:59:59']); } $sales_profit = $sales_profit->sum('total_profit_amount'); $sales_return_profit = DB::table('sales_return')->where('branch',active_branch_id())->where('currency',$sources['currency']); if(isset($sources['date'])) { $sales_return_profit->whereBetween('created_at', [$sources['date'].' 00:00:00', $sources['date'].' 23:59:59']); } $sales_return_profit = $sales_return_profit->sum('return_profit'); $extra_income = DB::table('extra_income')->where('branch',active_branch_id())->where('currency',$sources['currency']); if(isset($sources['date'])) { $extra_income->whereBetween('created_at', [$sources['date'].' 00:00:00', $sources['date'].' 23:59:59']); } $extra_income = $extra_income->sum('amount'); $transfer_out_profit = DB::table('transfer_out')->where('branch',active_branch_id())->where('currency',$sources['currency']); if(isset($sources['date'])) { $transfer_out_profit->whereBetween('created_at', [$sources['date'].' 00:00:00', $sources['date'].' 23:59:59']); } $transfer_out_profit = $transfer_out_profit->sum('profit'); $services_profit = DB::table('services')->where('branch',active_branch_id())->where('currency',$sources['currency']); if(isset($sources['date'])) { $services_profit->whereBetween('created_at', [$sources['date'].' 00:00:00', $sources['date'].' 23:59:59']); } $services_profit = $services_profit->sum('gross_total'); $lot_sales_profit = DB::table('lot_sold')->where('branch',active_branch_id())->where('currency',$sources['currency']); if(isset($sources['date'])) { $lot_sales_profit->whereBetween('created_at', [$sources['date'].' 00:00:00', $sources['date'].' 23:59:59']); } $lot_sales_profit = $lot_sales_profit->sum('total_profit'); $projects = DB::table('projects')->where('branch',active_branch_id())->where('currency',$sources['currency'])->where('status','completed'); if(isset($sources['date'])) { $projects->whereBetween('start_date', [$sources['date'], $sources['date']]); } $projects = std_obj_to_array( $projects->get() ); $project_profits = array(); foreach($projects as $project) { $project_deductions = calculate_project_deductions($project['uid']); $deductions_balance = (float)$project_deductions['payments'] - (float)$project_deductions['expenses']; $project_profits[] = (float)$project['cost'] - $deductions_balance; } $camount = $sales_profit - $sales_return_profit + $extra_income + $transfer_out_profit + $services_profit + $lot_sales_profit + array_sum($project_profits); return $camount; } function _calculate_system_expenses_amount($sources) { $data_bucket = array(); $all_in_usd = array(); foreach($sources['currencies'] as $currency) { $camount = DB::table('expenses')->where('branch',active_branch_id())->where('main_approval','approved')->where('currency',$currency['uid'])->sum('amount'); $data_bucket[$currency['uid']] = $camount; $all_in_usd[] = amount_conversion($camount, (float)$currency['usd_equalance'], '1'); } $data_bucket['all_in_usd'] = array_sum($all_in_usd); return $data_bucket; } function _calculate_system_services_amount($sources) { $data_bucket = array(); $all_in_usd = array(); foreach($sources['currencies'] as $currency) { $camount = DB::table('services')->where('branch',active_branch_id())->where('currency',$currency['uid'])->sum('cash_paid'); $data_bucket[$currency['uid']] = $camount; $all_in_usd[] = amount_conversion($camount, (float)$currency['usd_equalance'], '1'); } $data_bucket['all_in_usd'] = array_sum($all_in_usd); return $data_bucket; } function _dashboard_calculate_system_expenses_amount($sources) { $camount = DB::table('expenses')->where('branch',active_branch_id())->where('main_approval','approved')->where('currency',$sources['currency']); if(isset($sources['date'])) { $camount->whereBetween('exp_date', [$sources['date'], $sources['date']]); } $camount = $camount->sum('amount'); return $camount; } function _calculate_system_fixed_assets($sources) { $data_bucket = array(); $all_in_usd = array(); foreach($sources['currencies'] as $currency) { $assets_amount = DB::table('assets')->select(DB::raw('sum(price * qty) as amount'))->where('branch',active_branch_id())->where('currency',$currency['uid'])->get()->first(); $camount = $assets_amount->amount; $data_bucket[$currency['uid']] = $camount; $all_in_usd[] = amount_conversion($camount, (float)$currency['usd_equalance'], '1'); } $data_bucket['all_in_usd'] = array_sum($all_in_usd); return $data_bucket; } function _dashboard_calculate_system_fixed_assets($sources) { $assets_amount = DB::table('assets')->select(DB::raw('sum(price * qty) as amount'))->where('branch',active_branch_id())->where('currency',$sources['currency'])->get()->first(); $camount = $assets_amount->amount; return $camount; } function _calculate_system_account_type_balance($sources) { $active_branch_id = active_branch_id(); $item_settings = get_item_settings(); $data_bucket = array(); $all_in_usd = array(); $shared_accounts = array(); $shared_uids_accounts = std_obj_to_array(DB::table('accounts')->where('branch',active_branch_id())->where('type',$sources['type'])->pluck('uid')->toArray()); foreach($sources['currencies'] as $currency) { $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray()); if($item_settings['item_measurements'] == 'get') { $ledger_balance = DB::table('accounts_ledger')->select((DB::raw('sum(wim_debit) - sum(wim_credit) as balance')))->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$shared_uids_accounts)->where('account_type',$sources['type'])->get()->first(); } else { $ledger_balance = DB::table('accounts_ledger')->select((DB::raw('sum(debit) - sum(credit) as balance')))->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$shared_uids_accounts)->where('account_type',$sources['type'])->get()->first(); } $camount = $ledger_balance->balance; $data_bucket[$currency['uid']] = $camount; $all_in_usd[] = amount_conversion($camount, (float)$currency['usd_equalance'], '1'); } $data_bucket['all_in_usd'] = array_sum($all_in_usd); return $data_bucket; } function _calculate_system_account_type_balance_details($sources) { $active_branch_id = active_branch_id(); $item_settings = get_item_settings(); $from = $sources['from']; $to = $sources['to']; $shared_accounts = array(); $currency = $sources['currency']; $currency_data = fetch_table_where('currency','uid',$currency,true); $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency_data['branch_equalance'])->pluck('uid')->toArray()); $shared_currencies = array(); $shared_uids_accounts = std_obj_to_array(DB::table('accounts')->where('branch',active_branch_id())->where('type',$sources['type'])->pluck('uid')->toArray()); if($item_settings['item_measurements'] == 'get') { $ledger_balance = DB::table('accounts_ledger')->select((DB::raw('sum(wim_debit) - sum(wim_credit) as balance, sum(wim_debit) as debit, sum(wim_credit) as credit')))->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$shared_uids_accounts)->where('account_type',$sources['type']); if(!empty($from)){ $ledger_balance->where('created_at','>=',get_true_date($from).' 00:00:00'); } if(!empty($to)){ $ledger_balance->where('created_at','<=',get_true_date($to).' 23:59:59'); } $ledger_balance = $ledger_balance->get()->first(); } else { $ledger_balance = DB::table('accounts_ledger')->select((DB::raw('sum(debit) - sum(credit) as balance, sum(debit) as debit, sum(credit) as credit')))->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$shared_uids_accounts)->where('account_type',$sources['type']); if(!empty($from)){ $ledger_balance->where('created_at','>=',get_true_date($from).' 00:00:00'); } if(!empty($to)){ $ledger_balance->where('created_at','<=',get_true_date($to).' 23:59:59'); } $ledger_balance = $ledger_balance->get()->first(); } return $ledger_balance; } function _dashboard_calculate_system_account_type_balance_dated($sources) { $active_branch_id = active_branch_id(); $item_settings = get_item_settings(); $data_bucket = array(); $shared_uids_accounts = std_obj_to_array(DB::table('accounts')->where('branch',active_branch_id())->where('type',$sources['type'])->pluck('uid')->toArray()); foreach($sources['currencies'] as $currency) { $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray()); if($item_settings['item_measurements'] == 'get') { $ledger_balance = DB::table('accounts_ledger')->select((DB::raw('sum(wim_debit) - sum(wim_credit) as balance')))->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$shared_uids_accounts)->where('account_type',$sources['type']); } else { $ledger_balance = DB::table('accounts_ledger')->select((DB::raw('sum(debit) - sum(credit) as balance')))->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$shared_uids_accounts)->where('account_type',$sources['type']); } if(isset($sources['date'])) { $ledger_balance->whereBetween('aldate', [$sources['date'].' 00:00:00', $sources['date'].' 23:59:59']); } $ledger_balance = $ledger_balance->get()->first(); $camount = $ledger_balance->balance; $data_bucket[$currency['uid']] = $camount; } return $data_bucket; } function _dashboard_calculate_system_account_type_balance($sources) { $active_branch_id = active_branch_id(); $item_settings = get_item_settings(); $shared_accounts = array(); $shared_currencies = array(); $currency = $sources['currency']; $currency_data = fetch_table_where('currency','uid',$currency,true); $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency_data['branch_equalance'])->pluck('uid')->toArray()); $shared_uids_accounts = std_obj_to_array(DB::table('accounts')->where('branch',active_branch_id())->where('type',$sources['type'])->pluck('uid')->toArray()); if($item_settings['item_measurements'] == 'get') { if($sources['amount'] == 'debit') { $ledger_balance = DB::table('accounts_ledger')->select((DB::raw('sum(wim_debit) as balance')))->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$shared_uids_accounts)->where('account_type',$sources['type']); } else if($sources['amount'] == 'credit') { $ledger_balance = DB::table('accounts_ledger')->select((DB::raw('sum(wim_credit) as balance')))->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$shared_uids_accounts)->where('account_type',$sources['type']); } else { $ledger_balance = DB::table('accounts_ledger')->select((DB::raw('sum(wim_debit) - sum(wim_credit) as balance')))->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$shared_uids_accounts)->where('account_type',$sources['type']); } } else { if($sources['amount'] == 'debit') { $ledger_balance = DB::table('accounts_ledger')->select((DB::raw('sum(debit) as balance')))->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$shared_uids_accounts)->where('account_type',$sources['type']); } else if($sources['amount'] == 'credit') { $ledger_balance = DB::table('accounts_ledger')->select((DB::raw('sum(credit) as balance')))->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$shared_uids_accounts)->where('account_type',$sources['type']); } else { $ledger_balance = DB::table('accounts_ledger')->select((DB::raw('sum(debit) - sum(credit) as balance')))->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$shared_uids_accounts)->where('account_type',$sources['type']); } } if(isset($sources['date'])) { $ledger_balance->whereBetween('aldate', [$sources['date'].' 00:00:00', $sources['date'].' 23:59:59']); } $ledger_balance = $ledger_balance->get()->first(); $camount = $ledger_balance->balance; return $camount; } function _calculate_system_other_accounts_balance($sources) { $item_settings = get_item_settings(); $data_bucket = array(); $all_in_usd = array(); foreach($sources['currencies'] as $currency) { if($item_settings['item_measurements'] == 'get') { $ledger_balance = DB::table('accounts_ledger')->select(DB::raw('sum(wim_debit) - sum(wim_credit) as balance'))->where('branch',active_branch_id())->where('currency',$currency['uid']); } else { $ledger_balance = DB::table('accounts_ledger')->select(DB::raw('sum(debit) - sum(credit) as balance'))->where('branch',active_branch_id())->where('currency',$currency['uid']); } $ledger_balance->where('account_type','!=','bank'); $ledger_balance->where('account_type','!=','client'); $ledger_balance->where('account_type','!=','supplier'); $ledger_balance->where('account_type','!=','cashbook'); $ledger_balance->where('account_type','!=','missing'); $ledger_balance->where('account_type','!=','transit_module'); $ledger_balance = $ledger_balance->get()->first(); $camount = $ledger_balance->balance; $data_bucket[$currency['uid']] = $camount; $all_in_usd[] = amount_conversion($camount, (float)$currency['usd_equalance'], '1'); } $data_bucket['all_in_usd'] = array_sum($all_in_usd); return $data_bucket; } function _dashboard_calculate_system_other_accounts_balance($sources) { $item_settings = get_item_settings(); if($item_settings['item_measurements'] == 'get') { $ledger_balance = DB::table('accounts_ledger')->select(DB::raw('sum(wim_debit) - sum(wim_credit) as balance'))->where('branch',active_branch_id())->where('currency',$sources['currency']); } else { $ledger_balance = DB::table('accounts_ledger')->select(DB::raw('sum(debit) - sum(credit) as balance'))->where('branch',active_branch_id())->where('currency',$sources['currency']); } $ledger_balance->where('account_type','!=','bank'); $ledger_balance->where('account_type','!=','client'); $ledger_balance->where('account_type','!=','supplier'); $ledger_balance->where('account_type','!=','cashbook'); $ledger_balance->where('account_type','!=','missing'); $ledger_balance->where('account_type','!=','transit_module'); $ledger_balance = $ledger_balance->get()->first(); $camount = $ledger_balance->balance; return $camount; } function _calculate_system_current_assets($sources) { $bank_amount = $sources['_stats']['bank_amount']; $cash_amount = $sources['_stats']['cash_amount']; $receivable_amount = $sources['_stats']['receivable_amount']; $current_stock = $sources['_stats']['current_stock']; $fixed_assets = $sources['_stats']['fixed_assets']; $processed_bucket = array(); foreach($sources['currencies'] as $currency) { $row_currency_stats = array(); $row_currency_stats[] = array_key_exists($currency['uid'],$bank_amount) ? $bank_amount[$currency['uid']] : 0; $row_currency_stats[] = array_key_exists($currency['uid'],$cash_amount) ? $cash_amount[$currency['uid']] : 0; $row_currency_stats[] = array_key_exists($currency['uid'],$receivable_amount) ? $receivable_amount[$currency['uid']] : 0; $row_currency_stats[] = array_key_exists($currency['uid'],$current_stock) ? $current_stock[$currency['uid']] : 0; $row_currency_stats[] = array_key_exists($currency['uid'],$fixed_assets) ? $fixed_assets[$currency['uid']] : 0; $processed_bucket[$currency['uid']] = array_sum($row_currency_stats); } $all_in_usd_stats = array(); $all_in_usd_stats[] = array_key_exists('all_in_usd',$bank_amount) ? $bank_amount['all_in_usd'] : 0; $all_in_usd_stats[] = array_key_exists('all_in_usd',$cash_amount) ? $cash_amount['all_in_usd'] : 0; $all_in_usd_stats[] = array_key_exists('all_in_usd',$receivable_amount) ? $receivable_amount['all_in_usd'] : 0; $all_in_usd_stats[] = array_key_exists('all_in_usd',$current_stock) ? $current_stock['all_in_usd'] : 0; $all_in_usd_stats[] = array_key_exists('all_in_usd',$fixed_assets) ? $fixed_assets['all_in_usd'] : 0; $processed_bucket['all_in_usd'] = array_sum($all_in_usd_stats); return $processed_bucket; } function _dashboard_calculate_system_current_assets($sources) { $c_assets = array(); $c_assets[] = $sources['_stats']['bank_amount']; $c_assets[] = $sources['_stats']['cash_amount']; $c_assets[] = $sources['_stats']['receivable_amount']; $c_assets[] = $sources['_stats']['current_stock']; $c_assets[] = $sources['_stats']['fixed_assets']; return array_sum($c_assets); } function _calculate_system_liability_amount($sources) { $supplier_due_amount = $sources['_stats']['supplier_due_amount']; $other_accounts = $sources['_stats']['other_accounts']; $processed_bucket = array(); foreach($sources['currencies'] as $currency) { $c_supplier_due_amount = array_key_exists($currency['uid'],$supplier_due_amount) ? $supplier_due_amount[$currency['uid']] : 0; $c_other_accounts = array_key_exists($currency['uid'],$other_accounts) ? $other_accounts[$currency['uid']] : 0; $processed_bucket[$currency['uid']] = $c_supplier_due_amount + $c_other_accounts; } $aiu_supplier_due_amount = array_key_exists('all_in_usd',$supplier_due_amount) ? $supplier_due_amount['all_in_usd'] : 0; $aiu_other_accounts = array_key_exists('all_in_usd',$other_accounts) ? $other_accounts['all_in_usd'] : 0; $processed_bucket['all_in_usd'] = $aiu_supplier_due_amount + $aiu_other_accounts; return $processed_bucket; } function _calculate_system_equity_amount($sources) { $current_assets = $sources['_stats']['current_assets']; $other_accounts = $sources['_stats']['other_accounts']; $supplier_due_amount = $sources['_stats']['supplier_due_amount']; $processed_bucket = array(); foreach($sources['currencies'] as $currency) { $row_currency_stats = array(); $row_currency_stats[] = array_key_exists($currency['uid'],$current_assets) ? $current_assets[$currency['uid']] : 0; $row_currency_stats[] = array_key_exists($currency['uid'],$other_accounts) ? $other_accounts[$currency['uid']] : 0; $row_currency_stats[] = array_key_exists($currency['uid'],$supplier_due_amount) ? $supplier_due_amount[$currency['uid']] : 0; $processed_bucket[$currency['uid']] = array_sum($row_currency_stats); } $all_in_usd_stats = array(); $all_in_usd_stats[] = array_key_exists('all_in_usd',$current_assets) ? $current_assets['all_in_usd'] : 0; $all_in_usd_stats[] = array_key_exists('all_in_usd',$other_accounts) ? $other_accounts['all_in_usd'] : 0; $all_in_usd_stats[] = array_key_exists('all_in_usd',$supplier_due_amount) ? $supplier_due_amount['all_in_usd'] : 0; $processed_bucket['all_in_usd'] = array_sum($all_in_usd_stats); return $processed_bucket; } function _dashboard_calculate_system_equity_amount($sources) { $equity_am = array(); $equity_am[] = $sources['_stats']['current_assets']; $equity_am[] = $sources['_stats']['other_accounts']; $equity_am[] = $sources['_stats']['supplier_due_amount']; return array_sum($equity_am); } function _calculate_system_construction_projects_cost($sources) { $data_bucket = array(); $all_in_usd = array(); foreach($sources['currencies'] as $currency) { $camount = DB::table('projects')->where('branch',active_branch_id())->where('currency',$currency['uid'])->where('status','completed')->sum('cost'); $data_bucket[$currency['uid']] = $camount; $all_in_usd[] = amount_conversion($camount, (float)$currency['usd_equalance'], '1'); } $data_bucket['all_in_usd'] = array_sum($all_in_usd); return $data_bucket; } function _calculate_system_construction_projects_pending_amount($sources) { $data_bucket = array(); $all_in_usd = array(); foreach($sources['currencies'] as $currency) { $camount = DB::table('projects')->where('branch',active_branch_id())->where('currency',$currency['uid'])->sum('pending_amount'); $data_bucket[$currency['uid']] = $camount; $all_in_usd[] = amount_conversion($camount, (float)$currency['usd_equalance'], '1'); } $data_bucket['all_in_usd'] = array_sum($all_in_usd); return $data_bucket; } function _calculate_system_construction_projects_expenses($sources) { $data_bucket = array(); $all_in_usd = array(); $projects = std_obj_to_array(DB::table('projects')->where('branch',active_branch_id())->where('status','completed')->get()); $projects_uids = array_column($projects, 'uid'); foreach($sources['currencies'] as $currency) { $camount = DB::table('expenses_deductions')->where('branch',active_branch_id())->where('currency',$currency['uid'])->where('expenses_mood','cash_expenses')->whereIn('project', $projects_uids)->sum('amount'); $data_bucket[$currency['uid']] = $camount; $all_in_usd[] = amount_conversion($camount, (float)$currency['usd_equalance'], '1'); } $data_bucket['all_in_usd'] = array_sum($all_in_usd); return $data_bucket; } function _calculate_system_construction_projects_profit($sources) { $projects_cost = $sources['_stats']['projects_cost']; $projects_expenses = $sources['_stats']['projects_expenses']; $processed_bucket = array(); foreach($sources['currencies'] as $currency) { $c_projects_cost = array_key_exists($currency['uid'],$projects_cost) ? $projects_cost[$currency['uid']] : 0; $c_projects_expenses = array_key_exists($currency['uid'],$projects_expenses) ? $projects_expenses[$currency['uid']] : 0; $processed_bucket[$currency['uid']] = $c_projects_cost - $c_projects_expenses; } $aiu_projects_cost = array_key_exists('all_in_usd',$projects_cost) ? $projects_cost['all_in_usd'] : 0; $aiu_projects_expenses = array_key_exists('all_in_usd',$projects_expenses) ? $projects_expenses['all_in_usd'] : 0; $processed_bucket['all_in_usd'] = $aiu_projects_cost - $aiu_projects_expenses; return $processed_bucket; } function _dashboard_calculate_system_stats_section($_stats_receivable,$_stats_payable,$_stats_received) { $stats_array = array(); $stats_array['receivable'] = $_stats_receivable; $stats_array['payable'] = $_stats_payable; $stats_array['received'] = $_stats_received; if($_stats_receivable < 0){ $_stats_receivable = 0; } if($_stats_payable == 0){ $_stats_payable = 0; } if($_stats_received < 0){ $_stats_received = 0; } $_all_sum = $_stats_receivable + abs($_stats_payable) + $_stats_received; ($_all_sum <= 0) ? $_all_sum_div = 1 : $_all_sum_div = $_all_sum; $_stats_receivable_percent = ($_stats_receivable / $_all_sum_div) * 100; $_stats_payable_percent = (abs($_stats_payable) / $_all_sum_div) * 100; $_stats_received_percent = ($_stats_received / $_all_sum_div) * 100; $stats_array['all_sum'] = $_all_sum; $stats_array['receivable_percent'] = $_stats_receivable_percent; $stats_array['payable_percent'] = $_stats_payable_percent; $stats_array['received_percent'] = $_stats_received_percent; return $stats_array; } function _dashboard_calculate_system_cash_stats_section($sources) { $cash_amount = $sources['_cash_stats']['overall_cash']; $today_cash_amount = $sources['_cash_stats']['today_cash']; $currencies_bucket = array(); $currencies_bucket['current_cash'] = array(); $currencies_bucket['yesterday_cash'] = array(); foreach($sources['currencies'] as $currency) { $currency_cash_amount = array_key_exists($currency['uid'],$cash_amount) ? $cash_amount[$currency['uid']] : 0; $currency_today_cash_amount = array_key_exists($currency['uid'],$today_cash_amount) ? $today_cash_amount[$currency['uid']] : 0; $currencies_bucket['current_cash'][$currency['uid']] = $currency_cash_amount; $currencies_bucket['yesterday_cash'][$currency['uid']] = $currency_cash_amount - $currency_today_cash_amount; } return $currencies_bucket; } function _dashboard_calculate_system_profit_loss_section($sources) { $profit = $sources['_stats']['profit_amount']; $expenses = isset($sources['expenses']['total_amount']) ? (float)$sources['expenses']['total_amount'] : 0; $net_profit = $profit - $expenses; return array('profit' => $profit, 'expenses' => $expenses, 'net_profit' => $net_profit); } function dashboard_business_overall_stats($dashboard_currency) { $active_branch_id = active_branch_id(); $item_settings = get_item_settings(); $currencies = fetch_currencies(); $expense_types = fetch_table_branch('expenses_types'); $account_types = null; $dashboard_currency_data = fetch_table_where('currency','uid',$dashboard_currency,true); $requested_currency_data_usd_equalance = isset($dashboard_currency_data['usd_equalance']) ? (float)$dashboard_currency_data['usd_equalance'] : 1; $sold_lot_uids = std_obj_to_array(DB::table('lot_sold')->where('branch',active_branch_id())->pluck('child')->toArray()); $moved_lot_uids = std_obj_to_array(DB::table('purchases')->where('branch',active_branch_id())->where('main_approval','approved')->where('incoming','LOT')->pluck('lot_child_id')->toArray()); $processed_lot_uids = array_merge($sold_lot_uids,$moved_lot_uids); $cash_shared_uids_accounts = std_obj_to_array(DB::table('accounts')->where('branch',active_branch_id())->where('type','cashbook')->pluck('uid')->toArray()); $bank_shared_uids_accounts = std_obj_to_array(DB::table('accounts')->where('branch',active_branch_id())->where('type','bank')->pluck('uid')->toArray()); $receivable_shared_uids_accounts = DB::table('accounts')->where('branch',active_branch_id())->where(function($query) use ($account_types) { $query->where('type','client'); $query->orWhere('type','current_account'); $query->orWhere('type','employee'); })->pluck('uid')->toArray(); $receivable_shared_uids_accounts = std_obj_to_array($receivable_shared_uids_accounts); $payable_shared_uids_accounts = DB::table('accounts')->where('branch',active_branch_id())->where(function($query) use ($account_types) { $query->where('type','supplier'); $query->orWhere('type','transit'); })->pluck('uid')->toArray(); $payable_shared_uids_accounts = std_obj_to_array($payable_shared_uids_accounts); $lots_amount_in_all_currencies = []; $items_all_in_main_currency = []; $lots_profit_in_all_currencies = []; $cars_amount_in_all_currencies = []; $cars_profit_in_all_currencies = []; $sales_profit_in_all_currencies = []; $transfer_out_profit_in_all_currencies = []; $sales_amount_in_all_currencies = []; $metu_sales_amount_in_all_currencies = []; $purchases_amount_in_all_currencies = []; $production_amount_in_all_currencies = []; $cpurchases_amount_in_all_currencies = []; $purchase_order_all_in_main_currency = []; $inventory_amount_all_in_main_currency = []; $receivable_amount_all_in_main_currency = []; $received_amount_all_in_main_currency = []; $payable_amount_all_in_main_currency = []; $cash_amount_all_in_main_currency = []; $banks_amount_all_in_main_currency = []; $expenses_amount_all_in_main_currency = []; $damage_amount_all_in_main_currency = []; $assets_amount_all_in_main_currency = []; $capitals_amount_all_in_main_currency = []; $shareholder_credit_all_in_main_currency = array(); $turnover_all_in_main_currency = array(); $opening_balance_amount_all_in_main_currency = []; $extra_income_amount_all_in_main_currency = []; $services_all_in_main_currency = []; $types_wise_expenses = []; foreach($currencies as $currency) { $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray()); if($item_settings['item_measurements'] == 'get') { $opening_items_query = DB::table('items')->where('branch',active_branch_id())->select((DB::raw('sum((height * width * opening_stock) * cost) as balance')))->whereIn('currency',$shared_uids_currencies)->get()->first(); } else { $opening_items_query = DB::table('items')->where('branch',active_branch_id())->select((DB::raw('sum(cost * opening_stock) as balance')))->whereIn('currency',$shared_uids_currencies)->get()->first(); } $opening_items_balance = $opening_items_query->balance; $items_all_in_main_currency[] = amount_conversion($opening_items_balance, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $lots_data = DB::table('lot_sold')->where('branch',active_branch_id())->select((DB::raw('sum(total_profit) as profit, sum(gross_amount) as amount')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $lots_amount = $lots_data->amount; $lots_profits = $lots_data->profit; $net_lots_amount = $lots_amount - $lots_profits; $lots_amount_in_all_currencies[] = amount_conversion($net_lots_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $lots_profit_in_all_currencies[] = amount_conversion($lots_profits, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $cars_data = DB::table('showroom_sales')->where('branch',active_branch_id())->select((DB::raw('sum(profit) as profit, sum(gross_total) as amount')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $cars_amount = $cars_data->amount; $cars_profits = $cars_data->profit; $net_cars_amount = $cars_amount - $cars_profits; $cars_amount_in_all_currencies[] = amount_conversion($net_cars_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $cars_profit_in_all_currencies[] = amount_conversion($cars_profits, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $transfer_out_data = DB::table('transfer_out')->where('branch',active_branch_id())->select((DB::raw('sum(profit) as profit')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $transfer_out_profits = $transfer_out_data->profit; $transfer_out_profit_in_all_currencies[] = amount_conversion($transfer_out_profits, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $sales_data = DB::table('sales')->where('branch',active_branch_id())->where('main_approval','approved')->select((DB::raw('sum(total_profit_amount) as profit, sum(gross_total_amount) as amount')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $sales_amount = $sales_data->amount; $sales_profits = $sales_data->profit; $sales_return_data = DB::table('sales_return')->where('branch',active_branch_id())->select((DB::raw('sum(total_profit_amount) as profit, sum(refund_total) as amount')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $sales_return_amount = $sales_return_data->amount; $sales_return_profits = $sales_return_data->profit; $net_sales_profits = $sales_profits - $sales_return_profits; $net_sales_amount = $sales_amount - $sales_return_amount; $sales_profit_in_all_currencies[] = amount_conversion($net_sales_profits, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $sales_amount_in_all_currencies[] = amount_conversion($net_sales_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $metu_sales_data = DB::table('metu_sales')->where('branch',active_branch_id())->select((DB::raw('sum(value) as amount, sum(profit) as profit')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $metu_sales_amount = $metu_sales_data->amount; $metu_sales_profits = $metu_sales_data->profit; $metu_sales_amount_in_all_currencies[] = amount_conversion($metu_sales_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $purchases_data = DB::table('purchases')->where('branch',active_branch_id())->where('main_approval','approved')->select((DB::raw('sum(sub_total_amount) as amount')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $purchases_amount = $purchases_data->amount; $purchases_amount_in_all_currencies[] = amount_conversion($purchases_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $purchase_order = DB::table('purchases')->where('branch',active_branch_id())->where('main_approval','approved')->select((DB::raw('sum(sub_total_amount) as balance')))->whereIn('currency',$shared_uids_currencies)->where('status','pending')->get()->first(); $purchase_order_balance = $purchase_order->balance; $purchase_order_all_in_main_currency[] = amount_conversion($purchase_order_balance, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $production_data = DB::table('production')->where('branch',active_branch_id())->select((DB::raw('sum(total_raw_cost) as amount')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $production_amount = $production_data->amount; $production_amount_in_all_currencies[] = amount_conversion($production_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $cpurchases_data = DB::table('cpurchases')->where('branch',active_branch_id())->select((DB::raw('sum(total) as amount')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $cpurchases_amount = $cpurchases_data->amount; $cpurchases_amount_in_all_currencies[] = amount_conversion($cpurchases_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); if($item_settings['item_measurements'] == 'get') { $items_query = DB::table('items')->where('branch',active_branch_id())->select((DB::raw('sum((height * width * _avail_units) * _avg_cost) as amount')))->whereIn('currency',$shared_uids_currencies)->get()->first(); } else { $items_query = DB::table('items')->where('branch',active_branch_id())->select((DB::raw('sum(_avail_units * _avg_cost) as amount')))->whereIn('currency',$shared_uids_currencies)->get()->first(); } $items_amount = $items_query->amount; $cpurchases_data = DB::table('cpurchases')->where('branch',active_branch_id())->select((DB::raw('sum(total) as amount')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $cpurchases_amount = $cpurchases_data->amount; $item_stock_balance = DB::table('item_stock')->where('branch',active_branch_id())->select((DB::raw('sum(ava_qty * avg_cost) as balance')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $item_stock_in_out_balance = $item_stock_balance->balance; $cars_data = DB::table('car_purchases_details')->where('branch',active_branch_id())->select((DB::raw('sum(total_amount) as amount')))->whereIn('currency',$shared_uids_currencies)->whereNull('sold')->get()->first(); $cars_amount = $cars_data->amount; $lots_data = std_obj_to_array(DB::table('lot')->where('branch',active_branch_id())->whereIn('currency',$shared_uids_currencies)->get()); $lots_amounts = []; if(!empty($lots)) { foreach($lots_data as $in_lot) { $lot_list = isset($in_lot['lot_list']) ? json_decode($in_lot['lot_list'],true) : []; if(!empty($lot_list)) { foreach($lot_list as $in_lot_list) { if(!in_array($in_lot_list['uid'], $processed_lot_uids)) { $lots_amounts[] = (float)$in_lot_list['total_cost']; } } } } } $lot_balance = array_sum($lots_amounts); $total_inventory = $items_amount + $cpurchases_amount + $item_stock_in_out_balance + $cars_amount + $lot_balance + $purchase_order_balance; $inventory_amount_all_in_main_currency[] = amount_conversion($total_inventory, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); if($item_settings['item_measurements'] == 'get') { $receivable_data = DB::table('accounts_ledger')->select((DB::raw('sum(wim_debit) - sum(wim_credit) as amount, sum(wim_credit) as received')))->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$receivable_shared_uids_accounts)->get()->first(); } else { $receivable_data = DB::table('accounts_ledger')->select((DB::raw('sum(debit) - sum(credit) as amount, sum(credit) as received')))->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$receivable_shared_uids_accounts)->get()->first(); } $receivable_amount = $receivable_data->amount; $received_amount = $receivable_data->received; $receivable_amount_all_in_main_currency[] = amount_conversion($receivable_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $received_amount_all_in_main_currency[] = amount_conversion($received_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); if($item_settings['item_measurements'] == 'get') { $payable_data = DB::table('accounts_ledger')->select((DB::raw('sum(wim_debit) - sum(wim_credit) as amount')))->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$payable_shared_uids_accounts)->get()->first(); } else { $payable_data = DB::table('accounts_ledger')->select((DB::raw('sum(credit) - sum(debit) as amount')))->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$payable_shared_uids_accounts)->get()->first(); } $payable_amount = $payable_data->amount; $payable_amount_all_in_main_currency[] = amount_conversion($payable_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); if($item_settings['item_measurements'] == 'get') { $cash_data = DB::table('accounts_ledger')->select((DB::raw('sum(wim_debit) - sum(wim_credit) as amount')))->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$cash_shared_uids_accounts)->get()->first(); } else { $cash_data = DB::table('accounts_ledger')->select((DB::raw('sum(debit) - sum(credit) as amount')))->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$cash_shared_uids_accounts)->get()->first(); } $cash_amount = $cash_data->amount; $cash_amount_all_in_main_currency[] = amount_conversion($cash_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); if($item_settings['item_measurements'] == 'get') { $banks_data = DB::table('accounts_ledger')->select((DB::raw('sum(wim_debit) - sum(wim_credit) as amount')))->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$bank_shared_uids_accounts)->get()->first(); } else { $banks_data = DB::table('accounts_ledger')->select((DB::raw('sum(debit) - sum(credit) as amount')))->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$bank_shared_uids_accounts)->get()->first(); } $banks_amount = $banks_data->amount; $banks_amount_all_in_main_currency[] = amount_conversion($banks_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $expenses_data = DB::table('expenses')->where('branch',active_branch_id())->select((DB::raw('sum(amount) as amount')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $expenses_amount = $expenses_data->amount; $expenses_amount_all_in_main_currency[] = amount_conversion($expenses_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $damage_data = DB::table('damage')->where('branch',active_branch_id())->select((DB::raw('sum(total) as amount')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $damage_amount = $damage_data->amount; $damage_amount_all_in_main_currency[] = amount_conversion($damage_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $assets_data = DB::table('assets')->where('branch',active_branch_id())->select((DB::raw('sum(price * qty) as amount')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $assets_amount = $assets_data->amount; $assets_amount_all_in_main_currency[] = amount_conversion($assets_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $capitals_data = DB::table('capitals')->where('branch',active_branch_id())->select((DB::raw('sum(amount) as amount')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $capital_amount = $capitals_data->amount; $capitals_amount_all_in_main_currency[] = amount_conversion($capital_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $shareholder_credit = DB::table('shareholder_credit')->where('branch',active_branch_id())->select((DB::raw('sum(amount) as balance')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $shareholder_credit_balance = $shareholder_credit->balance; $shareholder_credit_all_in_main_currency[] = amount_conversion($shareholder_credit_balance, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $turnover = DB::table('turnover')->where('branch',active_branch_id())->select((DB::raw('sum(net_income) as balance')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $turnover_balance = $turnover->balance; $turnover_all_in_main_currency[] = amount_conversion($turnover_balance, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $receivable_opening_balance = DB::table('accounts_ledger')->where('branch',active_branch_id())->where('module_name','accounts')->select((DB::raw('sum(debit) - sum(credit) as amount')))->whereIn('currency',$shared_uids_currencies)->where(function($query) use ($account_types) { $query->where('account_type','client'); $query->orWhere('account_type','cashbook'); $query->orWhere('account_type','bank'); $query->orWhere('account_type','employee'); $query->orWhere('account_type','current_account'); })->get()->first(); $receivable_opening_balance_amount = $receivable_opening_balance->amount; $payable_opening_balance = DB::table('accounts_ledger')->where('branch',active_branch_id())->where('module_name','accounts')->select((DB::raw('sum(credit) - sum(debit) as amount')))->whereIn('currency',$shared_uids_currencies)->where(function($query) use ($account_types) { $query->where('account_type','supplier'); $query->orWhere('account_type','transit'); })->get()->first(); $payable_opening_balance_amount = $payable_opening_balance->amount; $opening_balance_amount = $receivable_opening_balance_amount - $payable_opening_balance_amount; $opening_balance_amount_all_in_main_currency[] = amount_conversion($opening_balance_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $extra_income_data = DB::table('extra_income')->where('branch',active_branch_id())->select((DB::raw('sum(amount) as amount')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $extra_income_amount = $extra_income_data->amount; $extra_income_amount_all_in_main_currency[] = amount_conversion($extra_income_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $services = DB::table('services')->where('branch',active_branch_id())->select((DB::raw('sum(gross_total) as balance')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $services_balance = $services->balance; $services_all_in_main_currency[] = amount_conversion($services_balance, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); } $_graphs_types_names = []; $_graphs_types_colors = []; $_graphs_types_amounts = []; if(!empty($expense_types)) { foreach($expense_types as $row) { $_graphs_types_names[] = $row['name']; $_graphs_types_colors[] = $row['color']; $type_wise_expense_amount = []; foreach($currencies as $currency_data) { $expense_amount = DB::table('expenses')->where('branch',active_branch_id())->where('type',$row['uid'])->where('currency',$currency_data['uid'])->sum('amount'); $type_wise_expense_amount[] = amount_conversion($expense_amount, (float)$currency_data['usd_equalance'], $requested_currency_data_usd_equalance); } $_graphs_types_amounts[] = array_sum($type_wise_expense_amount); } } $data_bucket['items_all_in_main_currency'] = array_sum($items_all_in_main_currency); $data_bucket['lots_amount_in_all_currencies'] = array_sum($lots_amount_in_all_currencies); $data_bucket['lots_profit_in_all_currencies'] = array_sum($lots_profit_in_all_currencies); $data_bucket['cars_amount_in_all_currencies'] = array_sum($cars_amount_in_all_currencies); $data_bucket['cars_profit_in_all_currencies'] = array_sum($cars_profit_in_all_currencies); $data_bucket['sales_profit_in_all_currencies'] = array_sum($sales_profit_in_all_currencies); $data_bucket['transfer_out_profit_in_all_currencies'] = array_sum($transfer_out_profit_in_all_currencies); $data_bucket['sales_amount_in_all_currencies'] = array_sum($sales_amount_in_all_currencies); $data_bucket['metu_sales_amount_in_all_currencies'] = array_sum($metu_sales_amount_in_all_currencies); $data_bucket['purchases_amount_in_all_currencies'] = array_sum($purchases_amount_in_all_currencies); $data_bucket['production_amount_in_all_currencies'] = array_sum($production_amount_in_all_currencies); $data_bucket['cpurchases_amount_in_all_currencies'] = array_sum($cpurchases_amount_in_all_currencies); $data_bucket['inventory_amount_all_in_main_currency'] = array_sum($inventory_amount_all_in_main_currency); $data_bucket['receivable_amount_all_in_main_currency'] = array_sum($receivable_amount_all_in_main_currency); $data_bucket['received_amount_all_in_main_currency'] = array_sum($received_amount_all_in_main_currency); $data_bucket['payable_amount_all_in_main_currency'] = array_sum($payable_amount_all_in_main_currency); $data_bucket['cash_amount_all_in_main_currency'] = array_sum($cash_amount_all_in_main_currency); $data_bucket['banks_amount_all_in_main_currency'] = array_sum($banks_amount_all_in_main_currency); $data_bucket['expenses_amount_all_in_main_currency'] = array_sum($expenses_amount_all_in_main_currency); $data_bucket['damage_amount_all_in_main_currency'] = array_sum($damage_amount_all_in_main_currency); $data_bucket['assets_amount_all_in_main_currency'] = array_sum($assets_amount_all_in_main_currency); $data_bucket['capitals_amount_all_in_main_currency'] = array_sum($capitals_amount_all_in_main_currency); $data_bucket['shareholder_credit_all_in_main_currency'] = array_sum($shareholder_credit_all_in_main_currency); $data_bucket['turnover_all_in_main_currency'] = array_sum($turnover_all_in_main_currency); $data_bucket['opening_balance_amount_all_in_main_currency'] = array_sum($opening_balance_amount_all_in_main_currency); $data_bucket['extra_income_amount_all_in_main_currency'] = array_sum($extra_income_amount_all_in_main_currency); $data_bucket['services_all_in_main_currency'] = array_sum($services_all_in_main_currency); $data_bucket['_graphs_types_names'] = $_graphs_types_names; $data_bucket['_graphs_types_colors'] = $_graphs_types_colors; $data_bucket['_graphs_types_amounts'] = $_graphs_types_amounts; return $data_bucket; } function dashboard_today_business_overall_stats($dashboard_currency) { $active_branch_id = active_branch_id(); $item_settings = get_item_settings(); $currencies = fetch_currencies(); $account_types = null; $today_date = date('Y-m-d'); $dashboard_currency_data = fetch_table_where('currency','uid',$dashboard_currency,true); $requested_currency_data_usd_equalance = isset($dashboard_currency_data['usd_equalance']) ? (float)$dashboard_currency_data['usd_equalance'] : 1; $sold_lot_uids = std_obj_to_array(DB::table('lot_sold')->where('branch',active_branch_id())->pluck('child')->toArray()); $moved_lot_uids = std_obj_to_array(DB::table('purchases')->where('branch',active_branch_id())->where('main_approval','approved')->where('incoming','LOT')->pluck('lot_child_id')->toArray()); $processed_lot_uids = array_merge($sold_lot_uids,$moved_lot_uids); $cash_shared_uids_accounts = std_obj_to_array(DB::table('accounts')->where('branch',active_branch_id())->where('type','cashbook')->pluck('uid')->toArray()); $bank_shared_uids_accounts = std_obj_to_array(DB::table('accounts')->where('branch',active_branch_id())->where('type','bank')->pluck('uid')->toArray()); $receivable_shared_uids_accounts = DB::table('accounts')->where('branch',active_branch_id())->where(function($query) use ($account_types) { $query->where('type','client'); $query->orWhere('type','current_account'); $query->orWhere('type','employee'); })->pluck('uid')->toArray(); $receivable_shared_uids_accounts = std_obj_to_array($receivable_shared_uids_accounts); $payable_shared_uids_accounts = DB::table('accounts')->where('branch',active_branch_id())->where(function($query) use ($account_types) { $query->where('type','supplier'); $query->orWhere('type','transit'); })->pluck('uid')->toArray(); $payable_shared_uids_accounts = std_obj_to_array($payable_shared_uids_accounts); $lots_amount_in_all_currencies = []; $lots_profit_in_all_currencies = []; $cars_amount_in_all_currencies = []; $cars_profit_in_all_currencies = []; $sales_profit_in_all_currencies = []; $sales_amount_in_all_currencies = []; $custom_sales_amount_in_all_currencies = []; $sales_return_amount_in_all_currencies = []; $purchases_amount_in_all_currencies = []; $production_amount_in_all_currencies = []; $cpurchases_amount_in_all_currencies = []; $receivable_amount_all_in_main_currency = []; $payable_amount_all_in_main_currency = []; $cash_in_amount_all_in_main_currency = []; $cash_out_amount_all_in_main_currency = []; $banks_in_amount_all_in_main_currency = []; $banks_out_amount_all_in_main_currency = []; $expenses_amount_all_in_main_currency = []; $extra_income_amount_all_in_main_currency = []; foreach($currencies as $currency) { $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray()); $lots_data = DB::table('lot_sold')->where('branch',active_branch_id())->where('created_at','>=',$today_date.' 00:00:00')->where('created_at','<=',$today_date.' 23:59:59')->select((DB::raw('sum(total_profit) as profit, sum(gross_amount) as amount')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $lots_amount = $lots_data->amount; $lots_profits = $lots_data->profit; $net_lots_amount = $lots_amount - $lots_profits; $lots_amount_in_all_currencies[] = amount_conversion($net_lots_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $lots_profit_in_all_currencies[] = amount_conversion($lots_profits, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $cars_data = DB::table('showroom_sales')->where('branch',active_branch_id())->where('created_at','>=',$today_date.' 00:00:00')->where('created_at','<=',$today_date.' 23:59:59')->select((DB::raw('sum(profit) as profit, sum(gross_total) as amount')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $cars_amount = $cars_data->amount; $cars_profits = $cars_data->profit; $net_cars_amount = $cars_amount - $cars_profits; $cars_amount_in_all_currencies[] = amount_conversion($net_cars_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $cars_profit_in_all_currencies[] = amount_conversion($cars_profits, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $sales_data = DB::table('sales')->where('branch',active_branch_id())->where('main_approval','approved')->where('created_at','>=',$today_date.' 00:00:00')->where('created_at','<=',$today_date.' 23:59:59')->select((DB::raw('sum(total_profit_amount) as profit, sum(gross_total_amount) as amount')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $sales_amount = $sales_data->amount; $sales_profits = $sales_data->profit; $sales_return_data = DB::table('sales_return')->where('branch',active_branch_id())->where('created_at','>=',$today_date.' 00:00:00')->where('created_at','<=',$today_date.' 23:59:59')->select((DB::raw('sum(total_profit_amount) as profit, sum(refund_total) as amount')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $sales_return_amount = $sales_return_data->amount; $sales_return_profits = $sales_return_data->profit; $sales_return_amount_in_all_currencies[] = amount_conversion($sales_return_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $net_sales_profits = $sales_profits - $sales_return_profits; $net_sales_amount = $sales_amount - $sales_return_amount; $sales_profit_in_all_currencies[] = amount_conversion($net_sales_profits, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $sales_amount_in_all_currencies[] = amount_conversion($net_sales_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $customer_sales = DB::table('batch_wise_stock')->where('item','like','%MITNAME_%')->where('branch',active_branch_id())->select((DB::raw('sum((cost + profit) * stock_out) as balance')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $customer_sales_amount = $customer_sales->balance; $custom_sales_amount_in_all_currencies[] = amount_conversion($customer_sales_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $purchases_data = DB::table('purchases')->where('branch',active_branch_id())->where('main_approval','approved')->where('created_at','>=',$today_date.' 00:00:00')->where('created_at','<=',$today_date.' 23:59:59')->select((DB::raw('sum(sub_total_amount) as amount')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $purchases_amount = $purchases_data->amount; $purchases_amount_in_all_currencies[] = amount_conversion($purchases_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $production_data = DB::table('production')->where('branch',active_branch_id())->select((DB::raw('sum(total_raw_cost) as amount')))->where('created_at','>=',$today_date.' 00:00:00')->where('created_at','<=',$today_date.' 23:59:59')->whereIn('currency',$shared_uids_currencies)->get()->first(); $production_amount = $production_data->amount; $production_amount_in_all_currencies[] = amount_conversion($production_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $cpurchases_data = DB::table('cpurchases')->where('branch',active_branch_id())->where('created_at','>=',$today_date.' 00:00:00')->where('created_at','<=',$today_date.' 23:59:59')->select((DB::raw('sum(total) as amount')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $cpurchases_amount = $cpurchases_data->amount; $cpurchases_amount_in_all_currencies[] = amount_conversion($cpurchases_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $expenses_data = DB::table('expenses')->where('branch',active_branch_id())->where('main_approval','approved')->where('exp_date','>=',$today_date.' 00:00:00')->where('exp_date','<=',$today_date.' 23:59:59')->select((DB::raw('sum(amount) as amount')))->whereIn('currency',$shared_uids_currencies)->get()->first(); $expenses_amount = $expenses_data->amount; $expenses_amount_all_in_main_currency[] = amount_conversion($expenses_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); if($item_settings['item_measurements'] == 'get') { $receivable_data = DB::table('accounts_ledger')->select((DB::raw('sum(wim_credit) as amount')))->where('aldate','>=',$today_date.' 00:00:00')->where('aldate','<=',$today_date.' 23:59:59')->where('module_name','journal')->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$receivable_shared_uids_accounts)->get()->first(); } else { $receivable_data = DB::table('accounts_ledger')->select((DB::raw('sum(credit) as amount')))->where('aldate','>=',$today_date.' 00:00:00')->where('aldate','<=',$today_date.' 23:59:59')->where('module_name','journal')->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$receivable_shared_uids_accounts)->get()->first(); } $receivable_amount = $receivable_data->amount; $receivable_amount_all_in_main_currency[] = amount_conversion($receivable_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); if($item_settings['item_measurements'] == 'get') { $payable_data = DB::table('accounts_ledger')->select((DB::raw('sum(wim_debit) as amount')))->where('aldate','>=',$today_date.' 00:00:00')->where('aldate','<=',$today_date.' 23:59:59')->where('module_name','journal')->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$payable_shared_uids_accounts)->get()->first(); } else { $payable_data = DB::table('accounts_ledger')->select((DB::raw('sum(credit) as amount')))->where('aldate','>=',$today_date.' 00:00:00')->where('aldate','<=',$today_date.' 23:59:59')->where('module_name','journal')->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$payable_shared_uids_accounts)->get()->first(); } $payable_amount = $payable_data->amount; $payable_amount_all_in_main_currency[] = amount_conversion($payable_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); if($item_settings['item_measurements'] == 'get') { $cash_data = DB::table('accounts_ledger')->select((DB::raw('sum(wim_credit) as cash_in, sum(wim_debit) as cash_out')))->where('aldate','>=',$today_date.' 00:00:00')->where('aldate','<=',$today_date.' 23:59:59')->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$cash_shared_uids_accounts)->get()->first(); } else { $cash_data = DB::table('accounts_ledger')->select((DB::raw('sum(credit) as cash_in, sum(debit) as cash_out')))->where('aldate','>=',$today_date.' 00:00:00')->where('aldate','<=',$today_date.' 23:59:59')->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$cash_shared_uids_accounts)->get()->first(); } $cash_in_amount = $cash_data->cash_in; $cash_out_amount = $cash_data->cash_out; $cash_in_amount_all_in_main_currency[] = amount_conversion($cash_in_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $cash_out_amount_all_in_main_currency[] = amount_conversion($cash_out_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); if($item_settings['item_measurements'] == 'get') { $banks_data = DB::table('accounts_ledger')->select((DB::raw('sum(wim_credit) as bank_out, sum(wim_debit) as bank_in')))->where('aldate','>=',$today_date.' 00:00:00')->where('aldate','<=',$today_date.' 23:59:59')->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$bank_shared_uids_accounts)->get()->first(); } else { $banks_data = DB::table('accounts_ledger')->select((DB::raw('sum(credit) as bank_out, sum(debit) as bank_in')))->where('aldate','>=',$today_date.' 00:00:00')->where('aldate','<=',$today_date.' 23:59:59')->whereIn('currency',$shared_uids_currencies)->whereIn('account_uid',$bank_shared_uids_accounts)->get()->first(); } $banks_in_amount = $banks_data->bank_in; $banks_out_amount = $banks_data->bank_out; $banks_in_amount_all_in_main_currency[] = amount_conversion($banks_in_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $banks_out_amount_all_in_main_currency[] = amount_conversion($banks_out_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $extra_income_data = DB::table('extra_income')->where('branch',active_branch_id())->select((DB::raw('sum(amount) as amount')))->where('created_at','>=',$today_date.' 00:00:00')->where('created_at','<=',$today_date.' 23:59:59')->whereIn('currency',$shared_uids_currencies)->get()->first(); $extra_income_amount = $extra_income_data->amount; $extra_income_amount_all_in_main_currency[] = amount_conversion($extra_income_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); } $data_bucket['lots_amount_in_all_currencies'] = array_sum($lots_amount_in_all_currencies); $data_bucket['lots_profit_in_all_currencies'] = array_sum($lots_profit_in_all_currencies); $data_bucket['cars_amount_in_all_currencies'] = array_sum($cars_amount_in_all_currencies); $data_bucket['cars_profit_in_all_currencies'] = array_sum($cars_profit_in_all_currencies); $data_bucket['sales_profit_in_all_currencies'] = array_sum($sales_profit_in_all_currencies); $data_bucket['sales_amount_in_all_currencies'] = array_sum($sales_amount_in_all_currencies); $data_bucket['custom_sales_amount_in_all_currencies'] = array_sum($custom_sales_amount_in_all_currencies); $data_bucket['sales_return_amount_in_all_currencies'] = array_sum($sales_return_amount_in_all_currencies); $data_bucket['purchases_amount_in_all_currencies'] = array_sum($purchases_amount_in_all_currencies); $data_bucket['production_amount_in_all_currencies'] = array_sum($production_amount_in_all_currencies); $data_bucket['cpurchases_amount_in_all_currencies'] = array_sum($cpurchases_amount_in_all_currencies); $data_bucket['expenses_amount_all_in_main_currency'] = array_sum($expenses_amount_all_in_main_currency); $data_bucket['payable_amount_all_in_main_currency'] = array_sum($payable_amount_all_in_main_currency); $data_bucket['receivable_amount_all_in_main_currency'] = array_sum($receivable_amount_all_in_main_currency); $data_bucket['cash_in_amount_all_in_main_currency'] = array_sum($cash_in_amount_all_in_main_currency); $data_bucket['cash_out_amount_all_in_main_currency'] = array_sum($cash_out_amount_all_in_main_currency); $data_bucket['banks_in_amount_all_in_main_currency'] = array_sum($banks_in_amount_all_in_main_currency); $data_bucket['banks_out_amount_all_in_main_currency'] = array_sum($banks_out_amount_all_in_main_currency); $data_bucket['extra_income_amount_all_in_main_currency'] = array_sum($extra_income_amount_all_in_main_currency); return $data_bucket; } function cash_flow_monthly_sales_calculations($year,$currency) { $requested_currency_data = fetch_table_where('currency','uid',$currency,true); $requested_currency_data_usd_equalance = isset($requested_currency_data['usd_equalance']) ? (float)$requested_currency_data['usd_equalance'] : 1; $active_branch_id = active_branch_id(); $currencies = fetch_currencies(); $month_1_from = $year.'-01-01'; $month_1_end = $year.'-01-31'; $month_2_from = $year.'-02-01'; $month_2_end = $year.'-02-31'; $month_3_from = $year.'-03-01'; $month_3_end = $year.'-03-31'; $month_4_from = $year.'-04-01'; $month_4_end = $year.'-04-31'; $month_5_from = $year.'-05-01'; $month_5_end = $year.'-05-31'; $month_6_from = $year.'-06-01'; $month_6_end = $year.'-06-31'; $month_7_from = $year.'-07-01'; $month_7_end = $year.'-07-31'; $month_8_from = $year.'-08-01'; $month_8_end = $year.'-08-31'; $month_9_from = $year.'-09-01'; $month_9_end = $year.'-09-31'; $month_10_from = $year.'-10-01'; $month_10_end = $year.'-10-31'; $month_11_from = $year.'-11-01'; $month_11_end = $year.'-11-31'; $month_12_from = $year.'-12-01'; $month_12_end = $year.'-12-31'; $monthly_sales = []; foreach($currencies as $currency) { $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray()); $sales_data = DB::table('sales')->where('branch',active_branch_id())->where('main_approval','approved'); $sales_data = $sales_data->select( DB::raw('
	    	        sum(case when 
	    	        created_at < "'.$month_1_from.'"
	    	        then cash_received END) as opening_amount
	    	    '), DB::raw('
	    	        sum(case when 
	    	        created_at < "'.$month_1_from.'"
	    	        then total_profit_amount END) as opening_profit
	    	    '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_1_from.'" AND created_at <= "'.$month_1_end.'"
	                then cash_received END) as month_1_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_1_from.'" AND created_at <= "'.$month_1_end.'"
	                then total_profit_amount END) as month_1_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_2_from.'" AND created_at <= "'.$month_2_end.'"
	                then cash_received END) as month_2_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_2_from.'" AND created_at <= "'.$month_2_end.'"
	                then total_profit_amount END) as month_2_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_3_from.'" AND created_at <= "'.$month_3_end.'"
	                then cash_received END) as month_3_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_3_from.'" AND created_at <= "'.$month_3_end.'"
	                then total_profit_amount END) as month_3_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_4_from.'" AND created_at <= "'.$month_4_end.'"
	                then cash_received END) as month_4_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_4_from.'" AND created_at <= "'.$month_4_end.'"
	                then total_profit_amount END) as month_4_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_5_from.'" AND created_at <= "'.$month_5_end.'"
	                then cash_received END) as month_5_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_5_from.'" AND created_at <= "'.$month_5_end.'"
	                then total_profit_amount END) as month_5_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_6_from.'" AND created_at <= "'.$month_6_end.'"
	                then cash_received END) as month_6_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_6_from.'" AND created_at <= "'.$month_6_end.'"
	                then total_profit_amount END) as month_6_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_7_from.'" AND created_at <= "'.$month_7_end.'"
	                then cash_received END) as month_7_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_7_from.'" AND created_at <= "'.$month_7_end.'"
	                then total_profit_amount END) as month_7_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_8_from.'" AND created_at <= "'.$month_8_end.'"
	                then cash_received END) as month_8_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_8_from.'" AND created_at <= "'.$month_8_end.'"
	                then total_profit_amount END) as month_8_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_9_from.'" AND created_at <= "'.$month_9_end.'"
	                then cash_received END) as month_9_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_9_from.'" AND created_at <= "'.$month_9_end.'"
	                then total_profit_amount END) as month_9_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_10_from.'" AND created_at <= "'.$month_10_end.'"
	                then cash_received END) as month_10_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_10_from.'" AND created_at <= "'.$month_10_end.'"
	                then total_profit_amount END) as month_10_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_11_from.'" AND created_at <= "'.$month_11_end.'"
	                then cash_received END) as month_11_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_11_from.'" AND created_at <= "'.$month_11_end.'"
	                then total_profit_amount END) as month_11_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_12_from.'" AND created_at <= "'.$month_12_end.'"
	                then cash_received END) as month_12_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_12_from.'" AND created_at <= "'.$month_12_end.'"
	                then total_profit_amount END) as month_12_profit
	            ') ); $sales_data = $sales_data->whereIn('currency',$shared_uids_currencies)->get()->first(); $monthly_sales['opening_amount'][] = amount_conversion($sales_data->opening_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['opening_profit'][] = amount_conversion($sales_data->opening_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_1_amount'][] = amount_conversion($sales_data->month_1_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_1_profit'][] = amount_conversion($sales_data->month_1_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_2_amount'][] = amount_conversion($sales_data->month_2_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_2_profit'][] = amount_conversion($sales_data->month_2_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_3_amount'][] = amount_conversion($sales_data->month_3_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_3_profit'][] = amount_conversion($sales_data->month_3_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_4_amount'][] = amount_conversion($sales_data->month_4_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_4_profit'][] = amount_conversion($sales_data->month_4_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_5_amount'][] = amount_conversion($sales_data->month_5_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_5_profit'][] = amount_conversion($sales_data->month_5_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_6_amount'][] = amount_conversion($sales_data->month_6_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_6_profit'][] = amount_conversion($sales_data->month_6_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_7_amount'][] = amount_conversion($sales_data->month_7_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_7_profit'][] = amount_conversion($sales_data->month_7_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_8_amount'][] = amount_conversion($sales_data->month_8_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_8_profit'][] = amount_conversion($sales_data->month_8_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_9_amount'][] = amount_conversion($sales_data->month_9_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_9_profit'][] = amount_conversion($sales_data->month_9_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_10_amount'][] = amount_conversion($sales_data->month_10_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_10_profit'][] = amount_conversion($sales_data->month_10_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_11_amount'][] = amount_conversion($sales_data->month_11_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_11_profit'][] = amount_conversion($sales_data->month_11_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_12_amount'][] = amount_conversion($sales_data->month_12_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_12_profit'][] = amount_conversion($sales_data->month_12_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); } return std_obj_to_array($monthly_sales); } function cash_flow_monthly_lots_sales_calculations($year,$currency) { $requested_currency_data = fetch_table_where('currency','uid',$currency,true); $requested_currency_data_usd_equalance = isset($requested_currency_data['usd_equalance']) ? (float)$requested_currency_data['usd_equalance'] : 1; $active_branch_id = active_branch_id(); $currencies = fetch_currencies(); $month_1_from = $year.'-01-01'; $month_1_end = $year.'-01-31'; $month_2_from = $year.'-02-01'; $month_2_end = $year.'-02-31'; $month_3_from = $year.'-03-01'; $month_3_end = $year.'-03-31'; $month_4_from = $year.'-04-01'; $month_4_end = $year.'-04-31'; $month_5_from = $year.'-05-01'; $month_5_end = $year.'-05-31'; $month_6_from = $year.'-06-01'; $month_6_end = $year.'-06-31'; $month_7_from = $year.'-07-01'; $month_7_end = $year.'-07-31'; $month_8_from = $year.'-08-01'; $month_8_end = $year.'-08-31'; $month_9_from = $year.'-09-01'; $month_9_end = $year.'-09-31'; $month_10_from = $year.'-10-01'; $month_10_end = $year.'-10-31'; $month_11_from = $year.'-11-01'; $month_11_end = $year.'-11-31'; $month_12_from = $year.'-12-01'; $month_12_end = $year.'-12-31'; $monthly_sales = []; foreach($currencies as $currency) { $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray()); $lots_sales_data = DB::table('lot_sold')->where('branch',active_branch_id()); $lots_sales_data = $lots_sales_data->select( DB::raw('
	    	        sum(case when 
	    	        created_at < "'.$month_1_from.'"
	    	        then cash END) as opening_amount
	    	    '), DB::raw('
	    	        sum(case when 
	    	        created_at < "'.$month_1_from.'"
	    	        then total_profit END) as opening_profit
	    	    '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_1_from.'" AND created_at <= "'.$month_1_end.'"
	                then cash END) as month_1_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_1_from.'" AND created_at <= "'.$month_1_end.'"
	                then total_profit END) as month_1_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_2_from.'" AND created_at <= "'.$month_2_end.'"
	                then cash END) as month_2_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_2_from.'" AND created_at <= "'.$month_2_end.'"
	                then total_profit END) as month_2_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_3_from.'" AND created_at <= "'.$month_3_end.'"
	                then cash END) as month_3_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_3_from.'" AND created_at <= "'.$month_3_end.'"
	                then total_profit END) as month_3_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_4_from.'" AND created_at <= "'.$month_4_end.'"
	                then cash END) as month_4_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_4_from.'" AND created_at <= "'.$month_4_end.'"
	                then total_profit END) as month_4_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_5_from.'" AND created_at <= "'.$month_5_end.'"
	                then cash END) as month_5_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_5_from.'" AND created_at <= "'.$month_5_end.'"
	                then total_profit END) as month_5_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_6_from.'" AND created_at <= "'.$month_6_end.'"
	                then cash END) as month_6_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_6_from.'" AND created_at <= "'.$month_6_end.'"
	                then total_profit END) as month_6_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_7_from.'" AND created_at <= "'.$month_7_end.'"
	                then cash END) as month_7_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_7_from.'" AND created_at <= "'.$month_7_end.'"
	                then total_profit END) as month_7_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_8_from.'" AND created_at <= "'.$month_8_end.'"
	                then cash END) as month_8_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_8_from.'" AND created_at <= "'.$month_8_end.'"
	                then total_profit END) as month_8_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_9_from.'" AND created_at <= "'.$month_9_end.'"
	                then cash END) as month_9_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_9_from.'" AND created_at <= "'.$month_9_end.'"
	                then total_profit END) as month_9_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_10_from.'" AND created_at <= "'.$month_10_end.'"
	                then cash END) as month_10_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_10_from.'" AND created_at <= "'.$month_10_end.'"
	                then total_profit END) as month_10_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_11_from.'" AND created_at <= "'.$month_11_end.'"
	                then cash END) as month_11_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_11_from.'" AND created_at <= "'.$month_11_end.'"
	                then total_profit END) as month_11_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_12_from.'" AND created_at <= "'.$month_12_end.'"
	                then cash END) as month_12_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_12_from.'" AND created_at <= "'.$month_12_end.'"
	                then total_profit END) as month_12_profit
	            ') ); $lots_sales_data = $lots_sales_data->whereIn('currency',$shared_uids_currencies)->get()->first(); $monthly_sales['opening_amount'][] = amount_conversion($lots_sales_data->opening_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['opening_profit'][] = amount_conversion($lots_sales_data->opening_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_1_amount'][] = amount_conversion($lots_sales_data->month_1_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_1_profit'][] = amount_conversion($lots_sales_data->month_1_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_2_amount'][] = amount_conversion($lots_sales_data->month_2_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_2_profit'][] = amount_conversion($lots_sales_data->month_2_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_3_amount'][] = amount_conversion($lots_sales_data->month_3_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_3_profit'][] = amount_conversion($lots_sales_data->month_3_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_4_amount'][] = amount_conversion($lots_sales_data->month_4_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_4_profit'][] = amount_conversion($lots_sales_data->month_4_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_5_amount'][] = amount_conversion($lots_sales_data->month_5_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_5_profit'][] = amount_conversion($lots_sales_data->month_5_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_6_amount'][] = amount_conversion($lots_sales_data->month_6_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_6_profit'][] = amount_conversion($lots_sales_data->month_6_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_7_amount'][] = amount_conversion($lots_sales_data->month_7_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_7_profit'][] = amount_conversion($lots_sales_data->month_7_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_8_amount'][] = amount_conversion($lots_sales_data->month_8_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_8_profit'][] = amount_conversion($lots_sales_data->month_8_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_9_amount'][] = amount_conversion($lots_sales_data->month_9_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_9_profit'][] = amount_conversion($lots_sales_data->month_9_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_10_amount'][] = amount_conversion($lots_sales_data->month_10_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_10_profit'][] = amount_conversion($lots_sales_data->month_10_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_11_amount'][] = amount_conversion($lots_sales_data->month_11_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_11_profit'][] = amount_conversion($lots_sales_data->month_11_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_12_amount'][] = amount_conversion($lots_sales_data->month_12_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_12_profit'][] = amount_conversion($lots_sales_data->month_12_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); } return std_obj_to_array($monthly_sales); } function cash_flow_monthly_cars_sales_calculations($year,$currency) { $requested_currency_data = fetch_table_where('currency','uid',$currency,true); $requested_currency_data_usd_equalance = isset($requested_currency_data['usd_equalance']) ? (float)$requested_currency_data['usd_equalance'] : 1; $active_branch_id = active_branch_id(); $currencies = fetch_currencies(); $month_1_from = $year.'-01-01'; $month_1_end = $year.'-01-31'; $month_2_from = $year.'-02-01'; $month_2_end = $year.'-02-31'; $month_3_from = $year.'-03-01'; $month_3_end = $year.'-03-31'; $month_4_from = $year.'-04-01'; $month_4_end = $year.'-04-31'; $month_5_from = $year.'-05-01'; $month_5_end = $year.'-05-31'; $month_6_from = $year.'-06-01'; $month_6_end = $year.'-06-31'; $month_7_from = $year.'-07-01'; $month_7_end = $year.'-07-31'; $month_8_from = $year.'-08-01'; $month_8_end = $year.'-08-31'; $month_9_from = $year.'-09-01'; $month_9_end = $year.'-09-31'; $month_10_from = $year.'-10-01'; $month_10_end = $year.'-10-31'; $month_11_from = $year.'-11-01'; $month_11_end = $year.'-11-31'; $month_12_from = $year.'-12-01'; $month_12_end = $year.'-12-31'; $monthly_sales = []; foreach($currencies as $currency) { $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray()); $cars_sales_data = DB::table('showroom_sales')->where('branch',active_branch_id()); $cars_sales_data = $cars_sales_data->select( DB::raw('
	    	        sum(case when 
	    	        created_at < "'.$month_1_from.'"
	    	        then cash_paid END) as opening_amount
	    	    '), DB::raw('
	    	        sum(case when 
	    	        created_at < "'.$month_1_from.'"
	    	        then profit END) as opening_profit
	    	    '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_1_from.'" AND created_at <= "'.$month_1_end.'"
	                then cash_paid END) as month_1_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_1_from.'" AND created_at <= "'.$month_1_end.'"
	                then profit END) as month_1_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_2_from.'" AND created_at <= "'.$month_2_end.'"
	                then cash_paid END) as month_2_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_2_from.'" AND created_at <= "'.$month_2_end.'"
	                then profit END) as month_2_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_3_from.'" AND created_at <= "'.$month_3_end.'"
	                then cash_paid END) as month_3_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_3_from.'" AND created_at <= "'.$month_3_end.'"
	                then profit END) as month_3_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_4_from.'" AND created_at <= "'.$month_4_end.'"
	                then cash_paid END) as month_4_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_4_from.'" AND created_at <= "'.$month_4_end.'"
	                then profit END) as month_4_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_5_from.'" AND created_at <= "'.$month_5_end.'"
	                then cash_paid END) as month_5_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_5_from.'" AND created_at <= "'.$month_5_end.'"
	                then profit END) as month_5_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_6_from.'" AND created_at <= "'.$month_6_end.'"
	                then cash_paid END) as month_6_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_6_from.'" AND created_at <= "'.$month_6_end.'"
	                then profit END) as month_6_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_7_from.'" AND created_at <= "'.$month_7_end.'"
	                then cash_paid END) as month_7_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_7_from.'" AND created_at <= "'.$month_7_end.'"
	                then profit END) as month_7_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_8_from.'" AND created_at <= "'.$month_8_end.'"
	                then cash_paid END) as month_8_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_8_from.'" AND created_at <= "'.$month_8_end.'"
	                then profit END) as month_8_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_9_from.'" AND created_at <= "'.$month_9_end.'"
	                then cash_paid END) as month_9_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_9_from.'" AND created_at <= "'.$month_9_end.'"
	                then profit END) as month_9_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_10_from.'" AND created_at <= "'.$month_10_end.'"
	                then cash_paid END) as month_10_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_10_from.'" AND created_at <= "'.$month_10_end.'"
	                then profit END) as month_10_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_11_from.'" AND created_at <= "'.$month_11_end.'"
	                then cash_paid END) as month_11_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_11_from.'" AND created_at <= "'.$month_11_end.'"
	                then profit END) as month_11_profit
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_12_from.'" AND created_at <= "'.$month_12_end.'"
	                then cash_paid END) as month_12_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_12_from.'" AND created_at <= "'.$month_12_end.'"
	                then profit END) as month_12_profit
	            ') ); $cars_sales_data = $cars_sales_data->whereIn('currency',$shared_uids_currencies)->get()->first(); $monthly_sales['opening_amount'][] = amount_conversion($cars_sales_data->opening_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['opening_profit'][] = amount_conversion($cars_sales_data->opening_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_1_amount'][] = amount_conversion($cars_sales_data->month_1_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_1_profit'][] = amount_conversion($cars_sales_data->month_1_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_2_amount'][] = amount_conversion($cars_sales_data->month_2_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_2_profit'][] = amount_conversion($cars_sales_data->month_2_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_3_amount'][] = amount_conversion($cars_sales_data->month_3_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_3_profit'][] = amount_conversion($cars_sales_data->month_3_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_4_amount'][] = amount_conversion($cars_sales_data->month_4_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_4_profit'][] = amount_conversion($cars_sales_data->month_4_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_5_amount'][] = amount_conversion($cars_sales_data->month_5_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_5_profit'][] = amount_conversion($cars_sales_data->month_5_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_6_amount'][] = amount_conversion($cars_sales_data->month_6_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_6_profit'][] = amount_conversion($cars_sales_data->month_6_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_7_amount'][] = amount_conversion($cars_sales_data->month_7_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_7_profit'][] = amount_conversion($cars_sales_data->month_7_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_8_amount'][] = amount_conversion($cars_sales_data->month_8_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_8_profit'][] = amount_conversion($cars_sales_data->month_8_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_9_amount'][] = amount_conversion($cars_sales_data->month_9_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_9_profit'][] = amount_conversion($cars_sales_data->month_9_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_10_amount'][] = amount_conversion($cars_sales_data->month_10_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_10_profit'][] = amount_conversion($cars_sales_data->month_10_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_11_amount'][] = amount_conversion($cars_sales_data->month_11_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_11_profit'][] = amount_conversion($cars_sales_data->month_11_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_12_amount'][] = amount_conversion($cars_sales_data->month_12_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_sales['month_12_profit'][] = amount_conversion($cars_sales_data->month_12_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); } return std_obj_to_array($monthly_sales); } function cash_flow_monthly_services_income_calculations($year,$currency) { $requested_currency_data = fetch_table_where('currency','uid',$currency,true); $requested_currency_data_usd_equalance = isset($requested_currency_data['usd_equalance']) ? (float)$requested_currency_data['usd_equalance'] : 1; $active_branch_id = active_branch_id(); $currencies = fetch_currencies(); $month_1_from = $year.'-01-01'; $month_1_end = $year.'-01-31'; $month_2_from = $year.'-02-01'; $month_2_end = $year.'-02-31'; $month_3_from = $year.'-03-01'; $month_3_end = $year.'-03-31'; $month_4_from = $year.'-04-01'; $month_4_end = $year.'-04-31'; $month_5_from = $year.'-05-01'; $month_5_end = $year.'-05-31'; $month_6_from = $year.'-06-01'; $month_6_end = $year.'-06-31'; $month_7_from = $year.'-07-01'; $month_7_end = $year.'-07-31'; $month_8_from = $year.'-08-01'; $month_8_end = $year.'-08-31'; $month_9_from = $year.'-09-01'; $month_9_end = $year.'-09-31'; $month_10_from = $year.'-10-01'; $month_10_end = $year.'-10-31'; $month_11_from = $year.'-11-01'; $month_11_end = $year.'-11-31'; $month_12_from = $year.'-12-01'; $month_12_end = $year.'-12-31'; $monthly_services_income = []; foreach($currencies as $currency) { $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray()); $services_income_data = DB::table('services')->where('branch',active_branch_id()); $services_income_data = $services_income_data->select( DB::raw('
	    	        sum(case when 
	    	        service_date < "'.$month_1_from.'"
	    	        then cash_paid END) as opening_amount
	    	    '), DB::raw('
	                sum(case when 
	                service_date >= "'.$month_1_from.'" AND service_date <= "'.$month_1_end.'"
	                then cash_paid END) as month_1_amount
	            '), DB::raw('
	                sum(case when 
	                service_date >= "'.$month_2_from.'" AND service_date <= "'.$month_2_end.'"
	                then cash_paid END) as month_2_amount
	            '), DB::raw('
	                sum(case when 
	                service_date >= "'.$month_3_from.'" AND service_date <= "'.$month_3_end.'"
	                then cash_paid END) as month_3_amount
	            '), DB::raw('
	                sum(case when 
	                service_date >= "'.$month_4_from.'" AND service_date <= "'.$month_4_end.'"
	                then cash_paid END) as month_4_amount
	            '), DB::raw('
	                sum(case when 
	                service_date >= "'.$month_5_from.'" AND service_date <= "'.$month_5_end.'"
	                then cash_paid END) as month_5_amount
	            '), DB::raw('
	                sum(case when 
	                service_date >= "'.$month_6_from.'" AND service_date <= "'.$month_6_end.'"
	                then cash_paid END) as month_6_amount
	            '), DB::raw('
	                sum(case when 
	                service_date >= "'.$month_7_from.'" AND service_date <= "'.$month_7_end.'"
	                then cash_paid END) as month_7_amount
	            '), DB::raw('
	                sum(case when 
	                service_date >= "'.$month_8_from.'" AND service_date <= "'.$month_8_end.'"
	                then cash_paid END) as month_8_amount
	            '), DB::raw('
	                sum(case when 
	                service_date >= "'.$month_9_from.'" AND service_date <= "'.$month_9_end.'"
	                then cash_paid END) as month_9_amount
	            '), DB::raw('
	                sum(case when 
	                service_date >= "'.$month_10_from.'" AND service_date <= "'.$month_10_end.'"
	                then cash_paid END) as month_10_amount
	            '), DB::raw('
	                sum(case when 
	                service_date >= "'.$month_11_from.'" AND service_date <= "'.$month_11_end.'"
	                then cash_paid END) as month_11_amount
	            '), DB::raw('
	                sum(case when 
	                service_date >= "'.$month_12_from.'" AND service_date <= "'.$month_12_end.'"
	                then cash_paid END) as month_12_amount
	            ') ); $services_income_data = $services_income_data->whereIn('currency',$shared_uids_currencies)->get()->first(); $monthly_services_income['opening_amount'][] = amount_conversion($services_income_data->opening_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_services_income['month_1_amount'][] = amount_conversion($services_income_data->month_1_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_services_income['month_2_amount'][] = amount_conversion($services_income_data->month_2_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_services_income['month_3_amount'][] = amount_conversion($services_income_data->month_3_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_services_income['month_4_amount'][] = amount_conversion($services_income_data->month_4_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_services_income['month_5_amount'][] = amount_conversion($services_income_data->month_5_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_services_income['month_6_amount'][] = amount_conversion($services_income_data->month_6_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_services_income['month_7_amount'][] = amount_conversion($services_income_data->month_7_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_services_income['month_8_amount'][] = amount_conversion($services_income_data->month_8_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_services_income['month_9_amount'][] = amount_conversion($services_income_data->month_9_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_services_income['month_10_amount'][] = amount_conversion($services_income_data->month_10_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_services_income['month_11_amount'][] = amount_conversion($services_income_data->month_11_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_services_income['month_12_amount'][] = amount_conversion($services_income_data->month_12_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); } return std_obj_to_array($monthly_services_income); } function cash_flow_monthly_capital_calculations($year,$currency) { $requested_currency_data = fetch_table_where('currency','uid',$currency,true); $requested_currency_data_usd_equalance = isset($requested_currency_data['usd_equalance']) ? (float)$requested_currency_data['usd_equalance'] : 1; $active_branch_id = active_branch_id(); $currencies = fetch_currencies(); $month_1_from = $year.'-01-01'; $month_1_end = $year.'-01-31'; $month_2_from = $year.'-02-01'; $month_2_end = $year.'-02-31'; $month_3_from = $year.'-03-01'; $month_3_end = $year.'-03-31'; $month_4_from = $year.'-04-01'; $month_4_end = $year.'-04-31'; $month_5_from = $year.'-05-01'; $month_5_end = $year.'-05-31'; $month_6_from = $year.'-06-01'; $month_6_end = $year.'-06-31'; $month_7_from = $year.'-07-01'; $month_7_end = $year.'-07-31'; $month_8_from = $year.'-08-01'; $month_8_end = $year.'-08-31'; $month_9_from = $year.'-09-01'; $month_9_end = $year.'-09-31'; $month_10_from = $year.'-10-01'; $month_10_end = $year.'-10-31'; $month_11_from = $year.'-11-01'; $month_11_end = $year.'-11-31'; $month_12_from = $year.'-12-01'; $month_12_end = $year.'-12-31'; $monthly_capital = []; foreach($currencies as $currency) { $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray()); $capital_data = DB::table('capitals')->where('branch',active_branch_id()); $capital_data = $capital_data->select( DB::raw('
	                sum(case when 
	                event_date < "'.$month_1_from.'"
	                then amount END) as opening_amount
	            '), DB::raw('
	                sum(case when 
	                event_date >= "'.$month_1_from.'" AND event_date <= "'.$month_1_end.'"
	                then amount END) as month_1_amount
	            '), DB::raw('
	                sum(case when 
	                event_date >= "'.$month_2_from.'" AND event_date <= "'.$month_2_end.'"
	                then amount END) as month_2_amount
	            '), DB::raw('
	                sum(case when 
	                event_date >= "'.$month_3_from.'" AND event_date <= "'.$month_3_end.'"
	                then amount END) as month_3_amount
	            '), DB::raw('
	                sum(case when 
	                event_date >= "'.$month_4_from.'" AND event_date <= "'.$month_4_end.'"
	                then amount END) as month_4_amount
	            '), DB::raw('
	                sum(case when 
	                event_date >= "'.$month_5_from.'" AND event_date <= "'.$month_5_end.'"
	                then amount END) as month_5_amount
	            '), DB::raw('
	                sum(case when 
	                event_date >= "'.$month_6_from.'" AND event_date <= "'.$month_6_end.'"
	                then amount END) as month_6_amount
	            '), DB::raw('
	                sum(case when 
	                event_date >= "'.$month_7_from.'" AND event_date <= "'.$month_7_end.'"
	                then amount END) as month_7_amount
	            '), DB::raw('
	                sum(case when 
	                event_date >= "'.$month_8_from.'" AND event_date <= "'.$month_8_end.'"
	                then amount END) as month_8_amount
	            '), DB::raw('
	                sum(case when 
	                event_date >= "'.$month_9_from.'" AND event_date <= "'.$month_9_end.'"
	                then amount END) as month_9_amount
	            '), DB::raw('
	                sum(case when 
	                event_date >= "'.$month_10_from.'" AND event_date <= "'.$month_10_end.'"
	                then amount END) as month_10_amount
	            '), DB::raw('
	                sum(case when 
	                event_date >= "'.$month_11_from.'" AND event_date <= "'.$month_11_end.'"
	                then amount END) as month_11_amount
	            '), DB::raw('
	                sum(case when 
	                event_date >= "'.$month_12_from.'" AND event_date <= "'.$month_12_end.'"
	                then amount END) as month_12_amount
	            ') ); $capital_data = $capital_data->whereIn('currency',$shared_uids_currencies)->get()->first(); $monthly_capital['opening_amount'][] = amount_conversion($capital_data->opening_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_capital['month_1_amount'][] = amount_conversion($capital_data->month_1_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_capital['month_2_amount'][] = amount_conversion($capital_data->month_2_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_capital['month_3_amount'][] = amount_conversion($capital_data->month_3_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_capital['month_4_amount'][] = amount_conversion($capital_data->month_4_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_capital['month_5_amount'][] = amount_conversion($capital_data->month_5_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_capital['month_6_amount'][] = amount_conversion($capital_data->month_6_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_capital['month_7_amount'][] = amount_conversion($capital_data->month_7_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_capital['month_8_amount'][] = amount_conversion($capital_data->month_8_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_capital['month_9_amount'][] = amount_conversion($capital_data->month_9_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_capital['month_10_amount'][] = amount_conversion($capital_data->month_10_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_capital['month_11_amount'][] = amount_conversion($capital_data->month_11_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_capital['month_12_amount'][] = amount_conversion($capital_data->month_12_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); } return std_obj_to_array($monthly_capital); } function cash_flow_monthly_extra_income_calculations($year,$currency) { $requested_currency_data = fetch_table_where('currency','uid',$currency,true); $requested_currency_data_usd_equalance = isset($requested_currency_data['usd_equalance']) ? (float)$requested_currency_data['usd_equalance'] : 1; $active_branch_id = active_branch_id(); $currencies = fetch_currencies(); $month_1_from = $year.'-01-01'; $month_1_end = $year.'-01-31'; $month_2_from = $year.'-02-01'; $month_2_end = $year.'-02-31'; $month_3_from = $year.'-03-01'; $month_3_end = $year.'-03-31'; $month_4_from = $year.'-04-01'; $month_4_end = $year.'-04-31'; $month_5_from = $year.'-05-01'; $month_5_end = $year.'-05-31'; $month_6_from = $year.'-06-01'; $month_6_end = $year.'-06-31'; $month_7_from = $year.'-07-01'; $month_7_end = $year.'-07-31'; $month_8_from = $year.'-08-01'; $month_8_end = $year.'-08-31'; $month_9_from = $year.'-09-01'; $month_9_end = $year.'-09-31'; $month_10_from = $year.'-10-01'; $month_10_end = $year.'-10-31'; $month_11_from = $year.'-11-01'; $month_11_end = $year.'-11-31'; $month_12_from = $year.'-12-01'; $month_12_end = $year.'-12-31'; $monthly_extra_income = []; foreach($currencies as $currency) { $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray()); $extra_income_data = DB::table('extra_income')->where('branch',active_branch_id()); $extra_income_data = $extra_income_data->select( DB::raw('
	                sum(case when 
	                created_at < "'.$month_1_from.'"
	                then amount END) as opening_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_1_from.'" AND created_at <= "'.$month_1_end.'"
	                then amount END) as month_1_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_2_from.'" AND created_at <= "'.$month_2_end.'"
	                then amount END) as month_2_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_3_from.'" AND created_at <= "'.$month_3_end.'"
	                then amount END) as month_3_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_4_from.'" AND created_at <= "'.$month_4_end.'"
	                then amount END) as month_4_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_5_from.'" AND created_at <= "'.$month_5_end.'"
	                then amount END) as month_5_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_6_from.'" AND created_at <= "'.$month_6_end.'"
	                then amount END) as month_6_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_7_from.'" AND created_at <= "'.$month_7_end.'"
	                then amount END) as month_7_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_8_from.'" AND created_at <= "'.$month_8_end.'"
	                then amount END) as month_8_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_9_from.'" AND created_at <= "'.$month_9_end.'"
	                then amount END) as month_9_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_10_from.'" AND created_at <= "'.$month_10_end.'"
	                then amount END) as month_10_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_11_from.'" AND created_at <= "'.$month_11_end.'"
	                then amount END) as month_11_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_12_from.'" AND created_at <= "'.$month_12_end.'"
	                then amount END) as month_12_amount
	            ') ); $extra_income_data = $extra_income_data->whereIn('currency',$shared_uids_currencies)->get()->first(); $monthly_extra_income['opening_amount'][] = amount_conversion($extra_income_data->opening_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_extra_income['month_1_amount'][] = amount_conversion($extra_income_data->month_1_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_extra_income['month_2_amount'][] = amount_conversion($extra_income_data->month_2_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_extra_income['month_3_amount'][] = amount_conversion($extra_income_data->month_3_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_extra_income['month_4_amount'][] = amount_conversion($extra_income_data->month_4_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_extra_income['month_5_amount'][] = amount_conversion($extra_income_data->month_5_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_extra_income['month_6_amount'][] = amount_conversion($extra_income_data->month_6_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_extra_income['month_7_amount'][] = amount_conversion($extra_income_data->month_7_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_extra_income['month_8_amount'][] = amount_conversion($extra_income_data->month_8_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_extra_income['month_9_amount'][] = amount_conversion($extra_income_data->month_9_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_extra_income['month_10_amount'][] = amount_conversion($extra_income_data->month_10_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_extra_income['month_11_amount'][] = amount_conversion($extra_income_data->month_11_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_extra_income['month_12_amount'][] = amount_conversion($extra_income_data->month_12_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); } return std_obj_to_array($monthly_extra_income); } function cash_flow_monthly_accounts_received_calculations($year,$currency,$receivable_shared_uids_accounts) { $requested_currency_data = fetch_table_where('currency','uid',$currency,true); $requested_currency_data_usd_equalance = isset($requested_currency_data['usd_equalance']) ? (float)$requested_currency_data['usd_equalance'] : 1; $active_branch_id = active_branch_id(); $currencies = fetch_currencies(); $month_1_from = $year.'-01-01'; $month_1_end = $year.'-01-31'; $month_2_from = $year.'-02-01'; $month_2_end = $year.'-02-31'; $month_3_from = $year.'-03-01'; $month_3_end = $year.'-03-31'; $month_4_from = $year.'-04-01'; $month_4_end = $year.'-04-31'; $month_5_from = $year.'-05-01'; $month_5_end = $year.'-05-31'; $month_6_from = $year.'-06-01'; $month_6_end = $year.'-06-31'; $month_7_from = $year.'-07-01'; $month_7_end = $year.'-07-31'; $month_8_from = $year.'-08-01'; $month_8_end = $year.'-08-31'; $month_9_from = $year.'-09-01'; $month_9_end = $year.'-09-31'; $month_10_from = $year.'-10-01'; $month_10_end = $year.'-10-31'; $month_11_from = $year.'-11-01'; $month_11_end = $year.'-11-31'; $month_12_from = $year.'-12-01'; $month_12_end = $year.'-12-31'; $monthly_accounts_received = []; foreach($currencies as $currency) { $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray()); $accounts_received_data = DB::table('accounts_ledger')->where('branch',active_branch_id()); $accounts_received_data = $accounts_received_data->select( DB::raw('
	    	        sum(case when 
	    	        aldate < "'.$month_1_from.'"
	    	        then credit END) as opening_amount
	    	    '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_1_from.'" AND aldate <= "'.$month_1_end.'"
	                then credit END) as month_1_amount
	            '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_2_from.'" AND aldate <= "'.$month_2_end.'"
	                then credit END) as month_2_amount
	            '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_3_from.'" AND aldate <= "'.$month_3_end.'"
	                then credit END) as month_3_amount
	            '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_4_from.'" AND aldate <= "'.$month_4_end.'"
	                then credit END) as month_4_amount
	            '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_5_from.'" AND aldate <= "'.$month_5_end.'"
	                then credit END) as month_5_amount
	            '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_6_from.'" AND aldate <= "'.$month_6_end.'"
	                then credit END) as month_6_amount
	            '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_7_from.'" AND aldate <= "'.$month_7_end.'"
	                then credit END) as month_7_amount
	            '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_8_from.'" AND aldate <= "'.$month_8_end.'"
	                then credit END) as month_8_amount
	            '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_9_from.'" AND aldate <= "'.$month_9_end.'"
	                then credit END) as month_9_amount
	            '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_10_from.'" AND aldate <= "'.$month_10_end.'"
	                then credit END) as month_10_amount
	            '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_11_from.'" AND aldate <= "'.$month_11_end.'"
	                then credit END) as month_11_amount
	            '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_12_from.'" AND aldate <= "'.$month_12_end.'"
	                then credit END) as month_12_amount
	            ') ); $accounts_received_data = $accounts_received_data->where('module_name','journal'); $accounts_received_data = $accounts_received_data->whereIn('currency',$shared_uids_currencies); $accounts_received_data = $accounts_received_data->whereIn('account_uid',$receivable_shared_uids_accounts)->get()->first(); $monthly_accounts_received['opening_amount'][] = amount_conversion($accounts_received_data->opening_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_received['month_1_amount'][] = amount_conversion($accounts_received_data->month_1_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_received['month_2_amount'][] = amount_conversion($accounts_received_data->month_2_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_received['month_3_amount'][] = amount_conversion($accounts_received_data->month_3_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_received['month_4_amount'][] = amount_conversion($accounts_received_data->month_4_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_received['month_5_amount'][] = amount_conversion($accounts_received_data->month_5_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_received['month_6_amount'][] = amount_conversion($accounts_received_data->month_6_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_received['month_7_amount'][] = amount_conversion($accounts_received_data->month_7_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_received['month_8_amount'][] = amount_conversion($accounts_received_data->month_8_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_received['month_9_amount'][] = amount_conversion($accounts_received_data->month_9_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_received['month_10_amount'][] = amount_conversion($accounts_received_data->month_10_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_received['month_11_amount'][] = amount_conversion($accounts_received_data->month_11_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_received['month_12_amount'][] = amount_conversion($accounts_received_data->month_12_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); } return std_obj_to_array($monthly_accounts_received); } function cash_flow_monthly_accounts_paid_calculations($year,$currency,$payable_shared_uids_accounts) { $requested_currency_data = fetch_table_where('currency','uid',$currency,true); $requested_currency_data_usd_equalance = isset($requested_currency_data['usd_equalance']) ? (float)$requested_currency_data['usd_equalance'] : 1; $active_branch_id = active_branch_id(); $currencies = fetch_currencies(); $month_1_from = $year.'-01-01'; $month_1_end = $year.'-01-31'; $month_2_from = $year.'-02-01'; $month_2_end = $year.'-02-31'; $month_3_from = $year.'-03-01'; $month_3_end = $year.'-03-31'; $month_4_from = $year.'-04-01'; $month_4_end = $year.'-04-31'; $month_5_from = $year.'-05-01'; $month_5_end = $year.'-05-31'; $month_6_from = $year.'-06-01'; $month_6_end = $year.'-06-31'; $month_7_from = $year.'-07-01'; $month_7_end = $year.'-07-31'; $month_8_from = $year.'-08-01'; $month_8_end = $year.'-08-31'; $month_9_from = $year.'-09-01'; $month_9_end = $year.'-09-31'; $month_10_from = $year.'-10-01'; $month_10_end = $year.'-10-31'; $month_11_from = $year.'-11-01'; $month_11_end = $year.'-11-31'; $month_12_from = $year.'-12-01'; $month_12_end = $year.'-12-31'; $monthly_accounts_paid = []; foreach($currencies as $currency) { $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray()); $accounts_paid_data = DB::table('accounts_ledger')->where('branch',active_branch_id()); $accounts_paid_data = $accounts_paid_data->select( DB::raw('
	    	        sum(case when 
	    	        aldate < "'.$month_1_from.'"
	    	        then debit END) as opening_amount
	    	    '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_1_from.'" AND aldate <= "'.$month_1_end.'"
	                then debit END) as month_1_amount
	            '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_2_from.'" AND aldate <= "'.$month_2_end.'"
	                then debit END) as month_2_amount
	            '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_3_from.'" AND aldate <= "'.$month_3_end.'"
	                then debit END) as month_3_amount
	            '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_4_from.'" AND aldate <= "'.$month_4_end.'"
	                then debit END) as month_4_amount
	            '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_5_from.'" AND aldate <= "'.$month_5_end.'"
	                then debit END) as month_5_amount
	            '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_6_from.'" AND aldate <= "'.$month_6_end.'"
	                then debit END) as month_6_amount
	            '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_7_from.'" AND aldate <= "'.$month_7_end.'"
	                then debit END) as month_7_amount
	            '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_8_from.'" AND aldate <= "'.$month_8_end.'"
	                then debit END) as month_8_amount
	            '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_9_from.'" AND aldate <= "'.$month_9_end.'"
	                then debit END) as month_9_amount
	            '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_10_from.'" AND aldate <= "'.$month_10_end.'"
	                then debit END) as month_10_amount
	            '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_11_from.'" AND aldate <= "'.$month_11_end.'"
	                then debit END) as month_11_amount
	            '), DB::raw('
	                sum(case when 
	                aldate >= "'.$month_12_from.'" AND aldate <= "'.$month_12_end.'"
	                then debit END) as month_12_amount
	            ') ); $accounts_paid_data = $accounts_paid_data->where('module_name','journal'); $accounts_paid_data = $accounts_paid_data->whereIn('currency',$shared_uids_currencies); $accounts_paid_data = $accounts_paid_data->whereIn('account_uid',$payable_shared_uids_accounts)->get()->first(); $monthly_accounts_paid['opening_amount'][] = amount_conversion($accounts_paid_data->opening_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_paid['month_1_amount'][] = amount_conversion($accounts_paid_data->month_1_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_paid['month_2_amount'][] = amount_conversion($accounts_paid_data->month_2_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_paid['month_3_amount'][] = amount_conversion($accounts_paid_data->month_3_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_paid['month_4_amount'][] = amount_conversion($accounts_paid_data->month_4_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_paid['month_5_amount'][] = amount_conversion($accounts_paid_data->month_5_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_paid['month_6_amount'][] = amount_conversion($accounts_paid_data->month_6_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_paid['month_7_amount'][] = amount_conversion($accounts_paid_data->month_7_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_paid['month_8_amount'][] = amount_conversion($accounts_paid_data->month_8_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_paid['month_9_amount'][] = amount_conversion($accounts_paid_data->month_9_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_paid['month_10_amount'][] = amount_conversion($accounts_paid_data->month_10_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_paid['month_11_amount'][] = amount_conversion($accounts_paid_data->month_11_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_accounts_paid['month_12_amount'][] = amount_conversion($accounts_paid_data->month_12_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); } return std_obj_to_array($monthly_accounts_paid); } function cash_flow_monthly_purchases_calculations($year,$currency) { $requested_currency_data = fetch_table_where('currency','uid',$currency,true); $requested_currency_data_usd_equalance = isset($requested_currency_data['usd_equalance']) ? (float)$requested_currency_data['usd_equalance'] : 1; $active_branch_id = active_branch_id(); $currencies = fetch_currencies(); $month_1_from = $year.'-01-01'; $month_1_end = $year.'-01-31'; $month_2_from = $year.'-02-01'; $month_2_end = $year.'-02-31'; $month_3_from = $year.'-03-01'; $month_3_end = $year.'-03-31'; $month_4_from = $year.'-04-01'; $month_4_end = $year.'-04-31'; $month_5_from = $year.'-05-01'; $month_5_end = $year.'-05-31'; $month_6_from = $year.'-06-01'; $month_6_end = $year.'-06-31'; $month_7_from = $year.'-07-01'; $month_7_end = $year.'-07-31'; $month_8_from = $year.'-08-01'; $month_8_end = $year.'-08-31'; $month_9_from = $year.'-09-01'; $month_9_end = $year.'-09-31'; $month_10_from = $year.'-10-01'; $month_10_end = $year.'-10-31'; $month_11_from = $year.'-11-01'; $month_11_end = $year.'-11-31'; $month_12_from = $year.'-12-01'; $month_12_end = $year.'-12-31'; $monthly_purchases = []; foreach($currencies as $currency) { $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray()); $purchases_data = DB::table('purchases')->where('branch',active_branch_id())->where('main_approval','approved'); $purchases_data = $purchases_data->select( DB::raw('
	    	        sum(case when 
	    	        created_at < "'.$month_1_from.'"
	    	        then paid_amount END) as opening_amount
	    	    '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_1_from.'" AND created_at <= "'.$month_1_end.'"
	                then paid_amount END) as month_1_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_2_from.'" AND created_at <= "'.$month_2_end.'"
	                then paid_amount END) as month_2_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_3_from.'" AND created_at <= "'.$month_3_end.'"
	                then paid_amount END) as month_3_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_4_from.'" AND created_at <= "'.$month_4_end.'"
	                then paid_amount END) as month_4_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_5_from.'" AND created_at <= "'.$month_5_end.'"
	                then paid_amount END) as month_5_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_6_from.'" AND created_at <= "'.$month_6_end.'"
	                then paid_amount END) as month_6_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_7_from.'" AND created_at <= "'.$month_7_end.'"
	                then paid_amount END) as month_7_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_8_from.'" AND created_at <= "'.$month_8_end.'"
	                then paid_amount END) as month_8_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_9_from.'" AND created_at <= "'.$month_9_end.'"
	                then paid_amount END) as month_9_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_10_from.'" AND created_at <= "'.$month_10_end.'"
	                then paid_amount END) as month_10_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_11_from.'" AND created_at <= "'.$month_11_end.'"
	                then paid_amount END) as month_11_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_12_from.'" AND created_at <= "'.$month_12_end.'"
	                then paid_amount END) as month_12_amount
	            ') ); $purchases_data = $purchases_data->whereIn('currency',$shared_uids_currencies)->get()->first(); $monthly_purchases['opening_amount'][] = amount_conversion($purchases_data->opening_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_purchases['month_1_amount'][] = amount_conversion($purchases_data->month_1_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_purchases['month_2_amount'][] = amount_conversion($purchases_data->month_2_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_purchases['month_3_amount'][] = amount_conversion($purchases_data->month_3_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_purchases['month_4_amount'][] = amount_conversion($purchases_data->month_4_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_purchases['month_5_amount'][] = amount_conversion($purchases_data->month_5_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_purchases['month_6_amount'][] = amount_conversion($purchases_data->month_6_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_purchases['month_7_amount'][] = amount_conversion($purchases_data->month_7_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_purchases['month_8_amount'][] = amount_conversion($purchases_data->month_8_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_purchases['month_9_amount'][] = amount_conversion($purchases_data->month_9_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_purchases['month_10_amount'][] = amount_conversion($purchases_data->month_10_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_purchases['month_11_amount'][] = amount_conversion($purchases_data->month_11_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_purchases['month_12_amount'][] = amount_conversion($purchases_data->month_12_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); } return std_obj_to_array($monthly_purchases); } function cash_flow_monthly_payslips_calculations($year,$currency) { $requested_currency_data = fetch_table_where('currency','uid',$currency,true); $requested_currency_data_usd_equalance = isset($requested_currency_data['usd_equalance']) ? (float)$requested_currency_data['usd_equalance'] : 1; $active_branch_id = active_branch_id(); $currencies = fetch_currencies(); $month_1_from = $year.'-01-01'; $month_1_end = $year.'-01-31'; $month_2_from = $year.'-02-01'; $month_2_end = $year.'-02-31'; $month_3_from = $year.'-03-01'; $month_3_end = $year.'-03-31'; $month_4_from = $year.'-04-01'; $month_4_end = $year.'-04-31'; $month_5_from = $year.'-05-01'; $month_5_end = $year.'-05-31'; $month_6_from = $year.'-06-01'; $month_6_end = $year.'-06-31'; $month_7_from = $year.'-07-01'; $month_7_end = $year.'-07-31'; $month_8_from = $year.'-08-01'; $month_8_end = $year.'-08-31'; $month_9_from = $year.'-09-01'; $month_9_end = $year.'-09-31'; $month_10_from = $year.'-10-01'; $month_10_end = $year.'-10-31'; $month_11_from = $year.'-11-01'; $month_11_end = $year.'-11-31'; $month_12_from = $year.'-12-01'; $month_12_end = $year.'-12-31'; $monthly_payslips = []; foreach($currencies as $currency) { $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray()); $payslips_data = DB::table('payslips')->where('branch',active_branch_id()); $payslips_data = $payslips_data->select( DB::raw('
	                sum(case when 
	                pay_date < "'.$month_1_from.'"
	                then net_salary END) as opening_amount
	            '), DB::raw('
	                sum(case when 
	                pay_date >= "'.$month_1_from.'" AND pay_date <= "'.$month_1_end.'"
	                then net_salary END) as month_1_amount
	            '), DB::raw('
	                sum(case when 
	                pay_date >= "'.$month_2_from.'" AND pay_date <= "'.$month_2_end.'"
	                then net_salary END) as month_2_amount
	            '), DB::raw('
	                sum(case when 
	                pay_date >= "'.$month_3_from.'" AND pay_date <= "'.$month_3_end.'"
	                then net_salary END) as month_3_amount
	            '), DB::raw('
	                sum(case when 
	                pay_date >= "'.$month_4_from.'" AND pay_date <= "'.$month_4_end.'"
	                then net_salary END) as month_4_amount
	            '), DB::raw('
	                sum(case when 
	                pay_date >= "'.$month_5_from.'" AND pay_date <= "'.$month_5_end.'"
	                then net_salary END) as month_5_amount
	            '), DB::raw('
	                sum(case when 
	                pay_date >= "'.$month_6_from.'" AND pay_date <= "'.$month_6_end.'"
	                then net_salary END) as month_6_amount
	            '), DB::raw('
	                sum(case when 
	                pay_date >= "'.$month_7_from.'" AND pay_date <= "'.$month_7_end.'"
	                then net_salary END) as month_7_amount
	            '), DB::raw('
	                sum(case when 
	                pay_date >= "'.$month_8_from.'" AND pay_date <= "'.$month_8_end.'"
	                then net_salary END) as month_8_amount
	            '), DB::raw('
	                sum(case when 
	                pay_date >= "'.$month_9_from.'" AND pay_date <= "'.$month_9_end.'"
	                then net_salary END) as month_9_amount
	            '), DB::raw('
	                sum(case when 
	                pay_date >= "'.$month_10_from.'" AND pay_date <= "'.$month_10_end.'"
	                then net_salary END) as month_10_amount
	            '), DB::raw('
	                sum(case when 
	                pay_date >= "'.$month_11_from.'" AND pay_date <= "'.$month_11_end.'"
	                then net_salary END) as month_11_amount
	            '), DB::raw('
	                sum(case when 
	                pay_date >= "'.$month_12_from.'" AND pay_date <= "'.$month_12_end.'"
	                then net_salary END) as month_12_amount
	            ') ); $payslips_data = $payslips_data->whereIn('currency',$shared_uids_currencies)->get()->first(); $monthly_payslips['month_1_amount'][] = amount_conversion($payslips_data->month_1_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_payslips['opening_amount'][] = amount_conversion($payslips_data->opening_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_payslips['month_2_amount'][] = amount_conversion($payslips_data->month_2_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_payslips['month_3_amount'][] = amount_conversion($payslips_data->month_3_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_payslips['month_4_amount'][] = amount_conversion($payslips_data->month_4_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_payslips['month_5_amount'][] = amount_conversion($payslips_data->month_5_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_payslips['month_6_amount'][] = amount_conversion($payslips_data->month_6_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_payslips['month_7_amount'][] = amount_conversion($payslips_data->month_7_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_payslips['month_8_amount'][] = amount_conversion($payslips_data->month_8_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_payslips['month_9_amount'][] = amount_conversion($payslips_data->month_9_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_payslips['month_10_amount'][] = amount_conversion($payslips_data->month_10_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_payslips['month_11_amount'][] = amount_conversion($payslips_data->month_11_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_payslips['month_12_amount'][] = amount_conversion($payslips_data->month_12_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); } return std_obj_to_array($monthly_payslips); } function cash_flow_monthly_advances_calculations($year,$currency) { $requested_currency_data = fetch_table_where('currency','uid',$currency,true); $requested_currency_data_usd_equalance = isset($requested_currency_data['usd_equalance']) ? (float)$requested_currency_data['usd_equalance'] : 1; $active_branch_id = active_branch_id(); $currencies = fetch_currencies(); $month_1_from = $year.'-01-01'; $month_1_end = $year.'-01-31'; $month_2_from = $year.'-02-01'; $month_2_end = $year.'-02-31'; $month_3_from = $year.'-03-01'; $month_3_end = $year.'-03-31'; $month_4_from = $year.'-04-01'; $month_4_end = $year.'-04-31'; $month_5_from = $year.'-05-01'; $month_5_end = $year.'-05-31'; $month_6_from = $year.'-06-01'; $month_6_end = $year.'-06-31'; $month_7_from = $year.'-07-01'; $month_7_end = $year.'-07-31'; $month_8_from = $year.'-08-01'; $month_8_end = $year.'-08-31'; $month_9_from = $year.'-09-01'; $month_9_end = $year.'-09-31'; $month_10_from = $year.'-10-01'; $month_10_end = $year.'-10-31'; $month_11_from = $year.'-11-01'; $month_11_end = $year.'-11-31'; $month_12_from = $year.'-12-01'; $month_12_end = $year.'-12-31'; $monthly_advances = []; foreach($currencies as $currency) { $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray()); $advances_data = DB::table('advances')->where('branch',active_branch_id()); $advances_data = $advances_data->select( DB::raw('
	                sum(case when 
	                advance_date < "'.$month_1_from.'"
	                then new_advance END) as opening_amount
	            '), DB::raw('
	                sum(case when 
	                advance_date >= "'.$month_1_from.'" AND advance_date <= "'.$month_1_end.'"
	                then new_advance END) as month_1_amount
	            '), DB::raw('
	                sum(case when 
	                advance_date >= "'.$month_2_from.'" AND advance_date <= "'.$month_2_end.'"
	                then new_advance END) as month_2_amount
	            '), DB::raw('
	                sum(case when 
	                advance_date >= "'.$month_3_from.'" AND advance_date <= "'.$month_3_end.'"
	                then new_advance END) as month_3_amount
	            '), DB::raw('
	                sum(case when 
	                advance_date >= "'.$month_4_from.'" AND advance_date <= "'.$month_4_end.'"
	                then new_advance END) as month_4_amount
	            '), DB::raw('
	                sum(case when 
	                advance_date >= "'.$month_5_from.'" AND advance_date <= "'.$month_5_end.'"
	                then new_advance END) as month_5_amount
	            '), DB::raw('
	                sum(case when 
	                advance_date >= "'.$month_6_from.'" AND advance_date <= "'.$month_6_end.'"
	                then new_advance END) as month_6_amount
	            '), DB::raw('
	                sum(case when 
	                advance_date >= "'.$month_7_from.'" AND advance_date <= "'.$month_7_end.'"
	                then new_advance END) as month_7_amount
	            '), DB::raw('
	                sum(case when 
	                advance_date >= "'.$month_8_from.'" AND advance_date <= "'.$month_8_end.'"
	                then new_advance END) as month_8_amount
	            '), DB::raw('
	                sum(case when 
	                advance_date >= "'.$month_9_from.'" AND advance_date <= "'.$month_9_end.'"
	                then new_advance END) as month_9_amount
	            '), DB::raw('
	                sum(case when 
	                advance_date >= "'.$month_10_from.'" AND advance_date <= "'.$month_10_end.'"
	                then new_advance END) as month_10_amount
	            '), DB::raw('
	                sum(case when 
	                advance_date >= "'.$month_11_from.'" AND advance_date <= "'.$month_11_end.'"
	                then new_advance END) as month_11_amount
	            '), DB::raw('
	                sum(case when 
	                advance_date >= "'.$month_12_from.'" AND advance_date <= "'.$month_12_end.'"
	                then new_advance END) as month_12_amount
	            ') ); $advances_data = $advances_data->whereIn('currency',$shared_uids_currencies)->get()->first(); $monthly_advances['opening_amount'][] = amount_conversion($advances_data->opening_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_advances['month_1_amount'][] = amount_conversion($advances_data->month_1_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_advances['month_2_amount'][] = amount_conversion($advances_data->month_2_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_advances['month_3_amount'][] = amount_conversion($advances_data->month_3_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_advances['month_4_amount'][] = amount_conversion($advances_data->month_4_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_advances['month_5_amount'][] = amount_conversion($advances_data->month_5_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_advances['month_6_amount'][] = amount_conversion($advances_data->month_6_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_advances['month_7_amount'][] = amount_conversion($advances_data->month_7_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_advances['month_8_amount'][] = amount_conversion($advances_data->month_8_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_advances['month_9_amount'][] = amount_conversion($advances_data->month_9_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_advances['month_10_amount'][] = amount_conversion($advances_data->month_10_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_advances['month_11_amount'][] = amount_conversion($advances_data->month_11_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_advances['month_12_amount'][] = amount_conversion($advances_data->month_12_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); } return std_obj_to_array($monthly_advances); } function cash_flow_monthly_expense_type_calculations($year,$currency,$type) { $requested_currency_data = fetch_table_where('currency','uid',$currency,true); $requested_currency_data_usd_equalance = isset($requested_currency_data['usd_equalance']) ? (float)$requested_currency_data['usd_equalance'] : 1; $active_branch_id = active_branch_id(); $currencies = fetch_currencies(); $month_1_from = $year.'-01-01'; $month_1_end = $year.'-01-31'; $month_2_from = $year.'-02-01'; $month_2_end = $year.'-02-31'; $month_3_from = $year.'-03-01'; $month_3_end = $year.'-03-31'; $month_4_from = $year.'-04-01'; $month_4_end = $year.'-04-31'; $month_5_from = $year.'-05-01'; $month_5_end = $year.'-05-31'; $month_6_from = $year.'-06-01'; $month_6_end = $year.'-06-31'; $month_7_from = $year.'-07-01'; $month_7_end = $year.'-07-31'; $month_8_from = $year.'-08-01'; $month_8_end = $year.'-08-31'; $month_9_from = $year.'-09-01'; $month_9_end = $year.'-09-31'; $month_10_from = $year.'-10-01'; $month_10_end = $year.'-10-31'; $month_11_from = $year.'-11-01'; $month_11_end = $year.'-11-31'; $month_12_from = $year.'-12-01'; $month_12_end = $year.'-12-31'; $monthly_expense = []; foreach($currencies as $currency) { $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray()); $expense_data = DB::table('expenses')->where('branch',active_branch_id())->where('main_approval','approved')->where('type',$type); $expense_data = $expense_data->select( DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_1_from.'" AND exp_date <= "'.$month_1_end.'"
	                then amount END) as month_1_amount
	            '), DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_2_from.'" AND exp_date <= "'.$month_2_end.'"
	                then amount END) as month_2_amount
	            '), DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_3_from.'" AND exp_date <= "'.$month_3_end.'"
	                then amount END) as month_3_amount
	            '), DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_4_from.'" AND exp_date <= "'.$month_4_end.'"
	                then amount END) as month_4_amount
	            '), DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_5_from.'" AND exp_date <= "'.$month_5_end.'"
	                then amount END) as month_5_amount
	            '), DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_6_from.'" AND exp_date <= "'.$month_6_end.'"
	                then amount END) as month_6_amount
	            '), DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_7_from.'" AND exp_date <= "'.$month_7_end.'"
	                then amount END) as month_7_amount
	            '), DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_8_from.'" AND exp_date <= "'.$month_8_end.'"
	                then amount END) as month_8_amount
	            '), DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_9_from.'" AND exp_date <= "'.$month_9_end.'"
	                then amount END) as month_9_amount
	            '), DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_10_from.'" AND exp_date <= "'.$month_10_end.'"
	                then amount END) as month_10_amount
	            '), DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_11_from.'" AND exp_date <= "'.$month_11_end.'"
	                then amount END) as month_11_amount
	            '), DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_12_from.'" AND exp_date <= "'.$month_12_end.'"
	                then amount END) as month_12_amount
	            ') ); $expense_data = $expense_data->whereIn('currency',$shared_uids_currencies)->get()->first(); $monthly_expense['month_1_amount'][] = amount_conversion($expense_data->month_1_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_expense['month_2_amount'][] = amount_conversion($expense_data->month_2_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_expense['month_3_amount'][] = amount_conversion($expense_data->month_3_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_expense['month_4_amount'][] = amount_conversion($expense_data->month_4_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_expense['month_5_amount'][] = amount_conversion($expense_data->month_5_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_expense['month_6_amount'][] = amount_conversion($expense_data->month_6_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_expense['month_7_amount'][] = amount_conversion($expense_data->month_7_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_expense['month_8_amount'][] = amount_conversion($expense_data->month_8_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_expense['month_9_amount'][] = amount_conversion($expense_data->month_9_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_expense['month_10_amount'][] = amount_conversion($expense_data->month_10_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_expense['month_11_amount'][] = amount_conversion($expense_data->month_11_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_expense['month_12_amount'][] = amount_conversion($expense_data->month_12_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); } return std_obj_to_array($monthly_expense); } function cash_flow_monthly_asset_type_calculations($year,$currency,$type) { $requested_currency_data = fetch_table_where('currency','uid',$currency,true); $requested_currency_data_usd_equalance = isset($requested_currency_data['usd_equalance']) ? (float)$requested_currency_data['usd_equalance'] : 1; $active_branch_id = active_branch_id(); $currencies = fetch_currencies(); $month_1_from = $year.'-01-01'; $month_1_end = $year.'-01-31'; $month_2_from = $year.'-02-01'; $month_2_end = $year.'-02-31'; $month_3_from = $year.'-03-01'; $month_3_end = $year.'-03-31'; $month_4_from = $year.'-04-01'; $month_4_end = $year.'-04-31'; $month_5_from = $year.'-05-01'; $month_5_end = $year.'-05-31'; $month_6_from = $year.'-06-01'; $month_6_end = $year.'-06-31'; $month_7_from = $year.'-07-01'; $month_7_end = $year.'-07-31'; $month_8_from = $year.'-08-01'; $month_8_end = $year.'-08-31'; $month_9_from = $year.'-09-01'; $month_9_end = $year.'-09-31'; $month_10_from = $year.'-10-01'; $month_10_end = $year.'-10-31'; $month_11_from = $year.'-11-01'; $month_11_end = $year.'-11-31'; $month_12_from = $year.'-12-01'; $month_12_end = $year.'-12-31'; $monthly_asset = []; foreach($currencies as $currency) { $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray()); $asset_data = DB::table('assets')->where('branch',active_branch_id())->where('type',$type); $asset_data = $asset_data->select( DB::raw('
	                sum(case when 
	                created_at >= "'.$month_1_from.'" AND created_at <= "'.$month_1_end.'"
	                then total END) as month_1_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_2_from.'" AND created_at <= "'.$month_2_end.'"
	                then total END) as month_2_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_3_from.'" AND created_at <= "'.$month_3_end.'"
	                then total END) as month_3_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_4_from.'" AND created_at <= "'.$month_4_end.'"
	                then total END) as month_4_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_5_from.'" AND created_at <= "'.$month_5_end.'"
	                then total END) as month_5_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_6_from.'" AND created_at <= "'.$month_6_end.'"
	                then total END) as month_6_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_7_from.'" AND created_at <= "'.$month_7_end.'"
	                then total END) as month_7_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_8_from.'" AND created_at <= "'.$month_8_end.'"
	                then total END) as month_8_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_9_from.'" AND created_at <= "'.$month_9_end.'"
	                then total END) as month_9_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_10_from.'" AND created_at <= "'.$month_10_end.'"
	                then total END) as month_10_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_11_from.'" AND created_at <= "'.$month_11_end.'"
	                then total END) as month_11_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_12_from.'" AND created_at <= "'.$month_12_end.'"
	                then total END) as month_12_amount
	            ') ); $asset_data = $asset_data->whereIn('currency',$shared_uids_currencies)->get()->first(); $monthly_asset['month_1_amount'][] = amount_conversion($asset_data->month_1_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_asset['month_2_amount'][] = amount_conversion($asset_data->month_2_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_asset['month_3_amount'][] = amount_conversion($asset_data->month_3_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_asset['month_4_amount'][] = amount_conversion($asset_data->month_4_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_asset['month_5_amount'][] = amount_conversion($asset_data->month_5_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_asset['month_6_amount'][] = amount_conversion($asset_data->month_6_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_asset['month_7_amount'][] = amount_conversion($asset_data->month_7_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_asset['month_8_amount'][] = amount_conversion($asset_data->month_8_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_asset['month_9_amount'][] = amount_conversion($asset_data->month_9_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_asset['month_10_amount'][] = amount_conversion($asset_data->month_10_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_asset['month_11_amount'][] = amount_conversion($asset_data->month_11_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_asset['month_12_amount'][] = amount_conversion($asset_data->month_12_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); } return std_obj_to_array($monthly_asset); } function cash_flow_expenses_opening_calculations($year,$currency) { $requested_currency_data = fetch_table_where('currency','uid',$currency,true); $requested_currency_data_usd_equalance = isset($requested_currency_data['usd_equalance']) ? (float)$requested_currency_data['usd_equalance'] : 1; $active_branch_id = active_branch_id(); $currencies = fetch_currencies(); $month_1_from = $year.'-01-01'; $monthly_expenses = []; foreach($currencies as $currency) { $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray()); $expenses_data = DB::table('expenses')->where('branch',active_branch_id())->where('main_approval','approved'); $expenses_data = $expenses_data->select( DB::raw('
	                sum(case when 
	                exp_date < "'.$month_1_from.'"
	                then amount END) as opening_amount
	            ') ); $expenses_data = $expenses_data->whereIn('currency',$shared_uids_currencies)->get()->first(); $monthly_expenses['opening_amount'][] = amount_conversion($expenses_data->opening_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); } return std_obj_to_array($monthly_expenses); } function cash_flow_assets_opening_calculations($year,$currency) { $requested_currency_data = fetch_table_where('currency','uid',$currency,true); $requested_currency_data_usd_equalance = isset($requested_currency_data['usd_equalance']) ? (float)$requested_currency_data['usd_equalance'] : 1; $active_branch_id = active_branch_id(); $currencies = fetch_currencies(); $month_1_from = $year.'-01-01'; $monthly_assets = []; foreach($currencies as $currency) { $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray()); $assets_data = DB::table('assets')->where('branch',active_branch_id()); $assets_data = $assets_data->select( DB::raw('
	                sum(case when 
	                created_at < "'.$month_1_from.'"
	                then total END) as opening_amount
	            ') ); $assets_data = $assets_data->whereIn('currency',$shared_uids_currencies)->get()->first(); $monthly_assets['opening_amount'][] = amount_conversion($assets_data->opening_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); } return std_obj_to_array($monthly_assets); } function cash_flow_monthly_expenses_calculations($year,$currency) { $requested_currency_data = fetch_table_where('currency','uid',$currency,true); $requested_currency_data_usd_equalance = isset($requested_currency_data['usd_equalance']) ? (float)$requested_currency_data['usd_equalance'] : 1; $active_branch_id = active_branch_id(); $currencies = fetch_currencies(); $month_1_from = $year.'-01-01'; $month_1_end = $year.'-01-31'; $month_2_from = $year.'-02-01'; $month_2_end = $year.'-02-31'; $month_3_from = $year.'-03-01'; $month_3_end = $year.'-03-31'; $month_4_from = $year.'-04-01'; $month_4_end = $year.'-04-31'; $month_5_from = $year.'-05-01'; $month_5_end = $year.'-05-31'; $month_6_from = $year.'-06-01'; $month_6_end = $year.'-06-31'; $month_7_from = $year.'-07-01'; $month_7_end = $year.'-07-31'; $month_8_from = $year.'-08-01'; $month_8_end = $year.'-08-31'; $month_9_from = $year.'-09-01'; $month_9_end = $year.'-09-31'; $month_10_from = $year.'-10-01'; $month_10_end = $year.'-10-31'; $month_11_from = $year.'-11-01'; $month_11_end = $year.'-11-31'; $month_12_from = $year.'-12-01'; $month_12_end = $year.'-12-31'; $monthly_expenses = []; foreach($currencies as $currency) { $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray()); $expenses_data = DB::table('expenses')->where('branch',active_branch_id())->where('main_approval','approved'); $expenses_data = $expenses_data->select( DB::raw('
	                sum(case when 
	                exp_date < "'.$month_1_from.'"
	                then amount END) as opening_amount
	            '), DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_1_from.'" AND exp_date <= "'.$month_1_end.'"
	                then amount END) as month_1_amount
	            '), DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_2_from.'" AND exp_date <= "'.$month_2_end.'"
	                then amount END) as month_2_amount
	            '), DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_3_from.'" AND exp_date <= "'.$month_3_end.'"
	                then amount END) as month_3_amount
	            '), DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_4_from.'" AND exp_date <= "'.$month_4_end.'"
	                then amount END) as month_4_amount
	            '), DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_5_from.'" AND exp_date <= "'.$month_5_end.'"
	                then amount END) as month_5_amount
	            '), DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_6_from.'" AND exp_date <= "'.$month_6_end.'"
	                then amount END) as month_6_amount
	            '), DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_7_from.'" AND exp_date <= "'.$month_7_end.'"
	                then amount END) as month_7_amount
	            '), DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_8_from.'" AND exp_date <= "'.$month_8_end.'"
	                then amount END) as month_8_amount
	            '), DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_9_from.'" AND exp_date <= "'.$month_9_end.'"
	                then amount END) as month_9_amount
	            '), DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_10_from.'" AND exp_date <= "'.$month_10_end.'"
	                then amount END) as month_10_amount
	            '), DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_11_from.'" AND exp_date <= "'.$month_11_end.'"
	                then amount END) as month_11_amount
	            '), DB::raw('
	                sum(case when 
	                exp_date >= "'.$month_12_from.'" AND exp_date <= "'.$month_12_end.'"
	                then amount END) as month_12_amount
	            ') ); $expenses_data = $expenses_data->whereIn('currency',$shared_uids_currencies)->get()->first(); $monthly_expenses['opening_amount'][] = amount_conversion($expenses_data->opening_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_expenses['month_1_amount'][] = amount_conversion($expenses_data->month_1_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_expenses['month_2_amount'][] = amount_conversion($expenses_data->month_2_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_expenses['month_3_amount'][] = amount_conversion($expenses_data->month_3_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_expenses['month_4_amount'][] = amount_conversion($expenses_data->month_4_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_expenses['month_5_amount'][] = amount_conversion($expenses_data->month_5_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_expenses['month_6_amount'][] = amount_conversion($expenses_data->month_6_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_expenses['month_7_amount'][] = amount_conversion($expenses_data->month_7_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_expenses['month_8_amount'][] = amount_conversion($expenses_data->month_8_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_expenses['month_9_amount'][] = amount_conversion($expenses_data->month_9_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_expenses['month_10_amount'][] = amount_conversion($expenses_data->month_10_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_expenses['month_11_amount'][] = amount_conversion($expenses_data->month_11_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_expenses['month_12_amount'][] = amount_conversion($expenses_data->month_12_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); } return std_obj_to_array($monthly_expenses); } function cash_flow_monthly_assets_calculations($year,$currency) { $requested_currency_data = fetch_table_where('currency','uid',$currency,true); $requested_currency_data_usd_equalance = isset($requested_currency_data['usd_equalance']) ? (float)$requested_currency_data['usd_equalance'] : 1; $active_branch_id = active_branch_id(); $currencies = fetch_currencies(); $month_1_from = $year.'-01-01'; $month_1_end = $year.'-01-31'; $month_2_from = $year.'-02-01'; $month_2_end = $year.'-02-31'; $month_3_from = $year.'-03-01'; $month_3_end = $year.'-03-31'; $month_4_from = $year.'-04-01'; $month_4_end = $year.'-04-31'; $month_5_from = $year.'-05-01'; $month_5_end = $year.'-05-31'; $month_6_from = $year.'-06-01'; $month_6_end = $year.'-06-31'; $month_7_from = $year.'-07-01'; $month_7_end = $year.'-07-31'; $month_8_from = $year.'-08-01'; $month_8_end = $year.'-08-31'; $month_9_from = $year.'-09-01'; $month_9_end = $year.'-09-31'; $month_10_from = $year.'-10-01'; $month_10_end = $year.'-10-31'; $month_11_from = $year.'-11-01'; $month_11_end = $year.'-11-31'; $month_12_from = $year.'-12-01'; $month_12_end = $year.'-12-31'; $monthly_assets = []; foreach($currencies as $currency) { $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray()); $assets_data = DB::table('assets')->where('branch',active_branch_id()); $assets_data = $assets_data->select( DB::raw('
	                sum(case when 
	                created_at < "'.$month_1_from.'"
	                then total END) as opening_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_1_from.'" AND created_at <= "'.$month_1_end.'"
	                then total END) as month_1_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_2_from.'" AND created_at <= "'.$month_2_end.'"
	                then total END) as month_2_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_3_from.'" AND created_at <= "'.$month_3_end.'"
	                then total END) as month_3_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_4_from.'" AND created_at <= "'.$month_4_end.'"
	                then total END) as month_4_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_5_from.'" AND created_at <= "'.$month_5_end.'"
	                then total END) as month_5_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_6_from.'" AND created_at <= "'.$month_6_end.'"
	                then total END) as month_6_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_7_from.'" AND created_at <= "'.$month_7_end.'"
	                then total END) as month_7_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_8_from.'" AND created_at <= "'.$month_8_end.'"
	                then total END) as month_8_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_9_from.'" AND created_at <= "'.$month_9_end.'"
	                then total END) as month_9_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_10_from.'" AND created_at <= "'.$month_10_end.'"
	                then total END) as month_10_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_11_from.'" AND created_at <= "'.$month_11_end.'"
	                then total END) as month_11_amount
	            '), DB::raw('
	                sum(case when 
	                created_at >= "'.$month_12_from.'" AND created_at <= "'.$month_12_end.'"
	                then total END) as month_12_amount
	            ') ); $assets_data = $assets_data->whereIn('currency',$shared_uids_currencies)->get()->first(); $monthly_assets['opening_amount'][] = amount_conversion($assets_data->opening_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_assets['month_1_amount'][] = amount_conversion($assets_data->month_1_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_assets['month_2_amount'][] = amount_conversion($assets_data->month_2_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_assets['month_3_amount'][] = amount_conversion($assets_data->month_3_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_assets['month_4_amount'][] = amount_conversion($assets_data->month_4_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_assets['month_5_amount'][] = amount_conversion($assets_data->month_5_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_assets['month_6_amount'][] = amount_conversion($assets_data->month_6_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_assets['month_7_amount'][] = amount_conversion($assets_data->month_7_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_assets['month_8_amount'][] = amount_conversion($assets_data->month_8_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_assets['month_9_amount'][] = amount_conversion($assets_data->month_9_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_assets['month_10_amount'][] = amount_conversion($assets_data->month_10_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_assets['month_11_amount'][] = amount_conversion($assets_data->month_11_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $monthly_assets['month_12_amount'][] = amount_conversion($assets_data->month_12_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); } return std_obj_to_array($monthly_assets); } ?>