<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use Mail; use Hash; class Accounts extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_account') === FALSE){ Redirect::to('/')->send(); } $accounts = fetch_all_accounts_branch(); if(!empty($request->root)) { $accounts = std_obj_to_array(DB::table('accounts')->where('branch',active_branch_id())->where('type',$request->root)->get()); } $accounts = set_array_keys($accounts,'uid'); $this->data["pageData"] = set_array_keys(fetch_all_accounts_branch(),'uid'); $this->data["records"] = $accounts; $this->data["search_root"] = $request->root; $this->data["root_accounts"] = fetch_root_accounts(); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'accounts'); $this->data["pageToLoad"] = "accounts/view.php"; $this->data["activeLink"] = "accounts"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_account') === FALSE){ Redirect::to('/')->send(); } $this->data["code"] = get_new_account_code(); $this->data["root_accounts"] = fetch_root_accounts(); $this->data["currencies"] = fetch_currencies(); $this->data["marketers"] = set_array_keys(fetch_table_branch('marketers'),'uid'); $this->data["sales_man"] = set_array_keys(fetch_table_branch('sales_man'),'uid'); $this->data["client_categories"] = set_array_keys(fetch_table_branch('client_categories'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'add_account'); $this->data["page"] = ''; $this->data["pageToLoad"] = "accounts/add.php"; $this->data["activeLink"] = "accounts"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'type' => 'required', ]); $validator->sometimes('username',['required', 'min:3', Rule::unique('users')],function($input){ if($input->is_user == 'no'){ return false; }else{ return true; } } ); $validator->sometimes('code',['required', 'numeric', Rule::unique('accounts')],function($input){ if($input->type == 'root'){ return false; }else{ return true; } } ); $validator->sometimes('memo','required',function($input){ if($input->type == 'root'){ return false; }else{ return true; } } ); $validator->validate(); $uid = getUniqueId('ACCT', 'accounts', 'uid'); $client_type = $request->client_type; if($client_type == 'general'){ $category = NULL; $sales_man = NULL; $marketer = NULL; } if($client_type == 'category'){ $category = $request->category; $sales_man = NULL; $marketer = NULL; } if($client_type == 'sales_man'){ $category = NULL; $sales_man = $request->sales_man; $marketer = NULL; } if($client_type == 'marketer'){ $category = NULL; $sales_man = NULL; $marketer = $request->marketer; } if($request->type == 'root') { $request->code = NULL; $request->memo = NULL; $opening_balance = json_encode(array()); } else { if(empty($request->currency)) { $opening_balance = json_encode(array()); } else { $counter = count($request->currency); $i = 0; $bucket = array(); while($i < $counter) { $currency = $request->currency[$i]; $ob_debit = $request->ob_debit[$i]; $ob_credit = $request->ob_credit[$i]; if(!empty($currency)) { $currency_data = fetch_table_where('currency','uid',$currency,true); $bucket[] = array('currency' => $currency, 'usd_equalance' => $currency_data['usd_equalance'], 'ob_debit' => $ob_debit, 'ob_credit' => $ob_credit); } $i++; } $opening_balance = json_encode($bucket); } } $username = NULL; $hashed_password = NULL; if($request->is_user == 'yes') { $username = $request->username; $hashed_password = Hash::make($request->password); } $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'name' => $request->name, 'type' => $request->type, 'client_type' => $client_type, 'category' => $category, 'sales_man' => $sales_man, 'marketer' => $marketer, 'code' => $request->code, 'shared' => $request->shared, 'mobile' => $request->mobile, 'email' => $request->email, 'memo' => $request->memo, 'address' => $request->address, 'is_user' => $request->is_user, 'opening_balance' => $opening_balance, 'username' => $username, 'password' => $hashed_password, ); insert_table('accounts',$db_array); _handle_account_ledger_effects(['uid' => $uid, 'state' => 'new']); if($request->is_user == 'yes') { $uid_user = getUniqueId('USR', 'users', 'uid'); $users_array = array( 'uid' => $uid_user, 'name' => $request->name, 'phone' => $request->mobile, 'branch' => active_branch_id(), 'username' => $username, 'password' => $hashed_password, 'role' => 'USER', 'customer' => $uid, 'is_customer' => 'yes', 'rights' => '[]', ); insert_table('users',$users_array); } $root_accounts = fetch_root_accounts(); $account_type_options = '<option selected="" value="root">'.print_lang($this->data["app_lang"],'root').'</option>'; foreach($root_accounts as $row) { $account_lang_name = ($row['branch'] == 'general') ? print_lang($this->data["app_lang"],'builtin_account_'.$row['uid']) : $row['name']; $account_type_options .= '<option value="'.$row['uid'].'">'.$account_lang_name.'</option>'; } echo json_encode(array('status' => 'success', 'mood' => 'new', 'code' => get_new_account_code(), 'account_type_options' => $account_type_options, 'message_head' => print_lang($this->data["app_lang"],'account_created'), 'message_body' => print_lang($this->data["app_lang"],'new_account_created_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_account') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('accounts','uid',$uid,true); $this->data["root_accounts"] = fetch_root_accounts(); $this->data["currencies"] = fetch_currencies(); $this->data["marketers"] = set_array_keys(fetch_table_branch('marketers'),'uid'); $this->data["sales_man"] = set_array_keys(fetch_table_branch('sales_man'),'uid'); $this->data["client_categories"] = set_array_keys(fetch_table_branch('client_categories'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'edit_account'); $this->data["page"] = ''; $this->data["pageToLoad"] = "accounts/edit.php"; $this->data["activeLink"] = "accounts"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'type' => 'required', ]); $validator->sometimes('username',['required', 'min:3'],function($input){ if($input->is_user == 'no'){ return false; }else{ return true; } } ); $validator->sometimes('code',['required', 'numeric', Rule::unique('accounts')->ignore($uid, 'uid')],function($input){ if($input->type == 'root'){ return false; }else{ return true; } } ); $validator->sometimes('memo','required',function($input){ if($input->type == 'root'){ return false; }else{ return true; } } ); $validator->validate(); if($request->is_user == 'yes') { $user_data = std_obj_to_array(DB::table('users')->where('username',$request->username)->get()->first()); if(!empty($user_data)) { if($user_data['customer'] != $uid) { if($request->username == $user_data['username']) { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => 'Username Exist', 'message_body' => 'This username already exist.')); die; } } } } $client_type = $request->client_type; if($client_type == 'general'){ $category = NULL; $sales_man = NULL; $marketer = NULL; } if($client_type == 'category'){ $category = $request->category; $sales_man = NULL; $marketer = NULL; } if($client_type == 'sales_man'){ $category = NULL; $sales_man = $request->sales_man; $marketer = NULL; } if($client_type == 'marketer'){ $category = NULL; $sales_man = NULL; $marketer = $request->marketer; } if($request->type == 'root') { $request->code = NULL; $request->memo = NULL; $opening_balance = json_encode(array()); } else { if(empty($request->currency)) { $opening_balance = json_encode(array()); } else { $counter = count($request->currency); $i = 0; $bucket = array(); while($i < $counter) { $currency = $request->currency[$i]; $ob_debit = $request->ob_debit[$i]; $ob_credit = $request->ob_credit[$i]; if(!empty($currency)) { $currency_data = fetch_table_where('currency','uid',$currency,true); $bucket[] = array('currency' => $currency, 'usd_equalance' => $currency_data['usd_equalance'], 'ob_debit' => $ob_debit, 'ob_credit' => $ob_credit); } $i++; } $opening_balance = json_encode($bucket); } } $account_data = fetch_table_where('accounts','uid',$uid,true); $username = NULL; if($account_data['is_user'] == 'yes') { $hashed_password = $account_data['password']; } else { $hashed_password = NULL; } if($request->is_user == 'yes') { $username = $request->username; if(!empty($request->update_password)) { $hashed_password = Hash::make($request->update_password); } } $db_array = array( 'name' => $request->name, 'type' => $request->type, 'client_type' => $client_type, 'category' => $category, 'sales_man' => $sales_man, 'marketer' => $marketer, 'shared' => $request->shared, 'code' => $request->code, 'mobile' => $request->mobile, 'email' => $request->email, 'memo' => $request->memo, 'address' => $request->address, 'is_user' => $request->is_user, 'opening_balance' => $opening_balance, 'username' => $username, 'password' => $hashed_password, ); update_table('accounts','uid',$uid,$db_array); _handle_account_ledger_effects(['uid' => $uid, 'state' => 'update']); if($request->is_user == 'yes') { if($account_data['is_user'] == 'no') { $uid_user = getUniqueId('USR', 'users', 'uid'); $users_array = array( 'uid' => $uid_user, 'name' => $request->name, 'phone' => $request->mobile, 'branch' => active_branch_id(), 'username' => $username, 'password' => $hashed_password, 'role' => 'USER', 'customer' => $uid, 'is_customer' => 'yes', 'rights' => '[]', ); insert_table('users',$users_array); } if($account_data['is_user'] == 'yes') { $users_array = array( 'name' => $request->name, 'phone' => $request->mobile, 'username' => $username, 'password' => $hashed_password, 'role' => 'USER', 'customer' => $uid, 'is_customer' => 'yes', 'rights' => '[]', ); update_table('users','customer',$uid,$users_array); } } else { if($account_data['is_user'] == 'yes') { delete_table('users','customer',$uid); } } update_table('assets','account',$uid,['account_name' => $request->name]); update_table('metu_purchases','supplier',$uid,['supplier_name' => $request->name]); update_table('metu_sales','client',$uid,['client_name' => $request->name]); update_table('metu_stock','account',$uid,['account_name' => $request->name]); update_table('tokens','account',$uid,['account_name' => $request->name]); update_table('tokens','client',$uid,['client_name' => $request->name]); update_table('item_stock_in','account',$uid,['account_name' => $request->name]); update_table('shareholder_credit','credit_account',$uid,['credit_account_name' => $request->name]); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'account_updated'), 'message_body' => print_lang($this->data["app_lang"],'account_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_account') === FALSE){ Redirect::to('/')->send(); } $account_data = fetch_table_where('accounts','uid',$uid,TRUE); $page_state = 'deleted'; delete_table('accounts','uid',$uid); _handle_account_ledger_effects(['uid' => $uid, 'state' => 'delete']); if($account_data['type'] == 'root') { $child_accounts = fetch_table_where_branch('accounts','type',$account_data['uid']); foreach($child_accounts as $row) { _handle_account_ledger_effects(['uid' => $row['uid'], 'state' => 'delete']); delete_table('accounts_ledger','account_uid',$row['uid']); } delete_table('accounts','type',$account_data['uid']); $page_state = 'reload'; } delete_table('accounts_ledger','account_uid',$uid); echo json_encode(array('status' => 'success', 'mode' => $page_state)); } public function email_alerts(Request $request) { if(check_user_access('email_alerts') === FALSE){ Redirect::to('/')->send(); } $this->data["title"] = print_lang($this->data["app_lang"],'mod_email_alerts_client'); $this->data["pageToLoad"] = "accounts/email_alerts.php"; $this->data["activeLink"] = "email_alerts"; $this->load_view($this->data); } public function send_mails(Request $request) { $branch = active_branch_id(); $currencies = fetch_currencies(); $clients = DB::table("accounts")->where("branch",$branch)->where("type","client")->where('email','<>','')->get(); $clients = json_decode(json_encode($clients),true); if(!empty($clients)) { foreach($clients as $row) { $client_balance = array(); foreach($currencies as $currency) { $client_balance[] = $currency['name'].": ".get_account_balance($row['uid'],$currency['uid']); } mail_alert($row['email'],$row['name'],$client_balance); } echo json_encode(array('status' => 'success', 'message' => "Mails send successfully!")); } else { echo json_encode(array('status' => 'error', 'message' => "No clients found to send payment alerts!")); } } public function message_alerts(Request $request) { if(check_user_access('message_alerts') === FALSE){ Redirect::to('/')->send(); } $this->data["title"] = print_lang($this->data["app_lang"],'mod_message_alerts_client'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["pageToLoad"] = "accounts/message_alerts.php"; $this->data["activeLink"] = "message_alerts"; $this->load_view($this->data); } public function send_message(Request $request) { $lang = get_app_language(); $branch = active_branch_id(); $currencies = fetch_currencies(); $clients = DB::table("accounts")->where("branch",$branch)->where("type","client")->where('mobile','<>','')->get(); $clients = json_decode(json_encode($clients),true); $branch_address = isset(active_branch_data()['branch_address']) ? active_branch_data()['branch_address'] : null; $branch_mobile = isset(active_branch_data()['branch_mobile']) ? active_branch_data()['branch_mobile'] : null; if(!empty($clients)) { foreach($clients as $row) { if(!empty($row['mobile'])) { $text_value = '\n*'.ucfirst(active_branch_data()['branch_name']).'*'; $text_value .= '\n'; $text_value .= '\n'; $text_value .= print_lang($lang,'mod_message_alerts_text_dear').' *'.$row['name'].'!*'; $text_value .= '\n'; $text_value .= print_lang($lang,'mod_message_alerts_text_make_payment').'!'; $text_value .= '\n'; $text_value .= print_lang($lang,'mod_message_alerts_text_current_balance').':'; $text_value .= '\n'; $customer_balance = 0; foreach($currencies as $currency) { $customer_balance = (float)get_account_balance($row['uid'],$currency['uid']); if($customer_balance != 0) { $text_value .= '\n'; $text_value .= $currency['name'].": *".amount_number_format($customer_balance).'*'; } } $text_value .= '\n'; $text_value .= '\n'; $text_value .= print_lang($lang,'mod_message_alerts_text_branch_address').' *'.$branch_address.'*'; $text_value .= '\n'; $text_value .= print_lang($lang,'mod_message_alerts_text_branch_mobile').' *'.$branch_mobile.'*'; $text_value .= '\n'; $text_value .= '\n'; $text_value .= ' *'.print_lang($lang,'mod_message_alerts_text_thanks').'!*'; $text_value .= '\n'; $text_value .= ' *'.print_lang($lang,'mod_message_alerts_text_fastbooks_business_erp').'*'; trigger_whatsapp_message($row['mobile'],$text_value); } } echo json_encode(array('status' => 'success', 'message' => "Messages send successfully!")); } else { echo json_encode(array('status' => 'error', 'message' => "No clients found to send payment alerts!")); } } }