<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use View; use Hash; class Activities extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { $branch_id = active_branch_id(); $user_id = Session::get('user_id'); $marketer = get_active_marketer(); $sales_man = get_active_sales_man(); $user_type = NULL; if(is_marketer_user() === true){ $user_type = 'marketer'; } if(is_sales_man_user() === true){ $user_type = 'salesman'; } $activities = DB::table('activities')->where('branch',$branch_id)->where('user_type',$user_type)->where('user',$user_id); if(!empty($request->currency)){ $activities->where('currency',$request->currency); } if(!empty($request->status)){ $activities->where('status',$request->status); } if(!empty($request->from)){ $activities->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $activities->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $activities = json_decode(json_encode($activities->get()),true); $this->data["pageData"] = $activities; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["search_status"] = $request->status; $this->data["title"] = print_lang($this->data["app_lang"],'activity_view_breadcrumb'); $this->data["pageToLoad"] = "activities/view.php"; $this->data["activeLink"] = "activities"; $this->load_view($this->data); } public function add(Request $request) { $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'activity_add_title'); $this->data["pageToLoad"] = "activities/add.php"; $this->data["activeLink"] = "activities"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'amount' => 'required|numeric', ]); $validator->validate(); $uid = getUniqueId('ACVT', 'activities', 'uid'); $active_branch_id = active_branch_id(); $currency_db_data = fetch_table_where('currency','uid',$request->currency,true); $user_id = Session::get('user_id'); $marketer = get_active_marketer(); $salesman = get_active_sales_man(); if(is_marketer_user() === true){ $user_type = 'marketer'; } if(is_sales_man_user() === true){ $user_type = 'salesman'; } $db_array = array( 'uid' => $uid, 'branch' => $active_branch_id, 'currency' => $request->currency, 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'amount' => $request->amount, 'narration' => $request->narration, 'debit_account' => $request->debit_account, 'user_type' => $user_type, 'marketer' => $marketer, 'salesman' => $salesman, 'user' => $user_id ); insert_table('activities',$db_array); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'activity_added'), 'message_body' => print_lang($this->data["app_lang"],'activity_save_successfully'))); } public function edit(Request $request, $uid) { $this->data["editing_data"] = fetch_table_where('activities','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/activities')->send(); } $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'activity_edit_title'); $this->data["pageToLoad"] = "activities/edit.php"; $this->data["activeLink"] = "activities"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'amount' => 'required|numeric', ]); $validator->validate(); $currency_db_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'currency' => $request->currency, 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'amount' => $request->amount, 'narration' => $request->narration, ); update_table('activities','uid',$uid,$db_array); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'activity_update'), 'message_body' => print_lang($this->data["app_lang"],'activity_update_successfully'))); } public function delete($uid) { delete_table('activities','uid',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }