<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; class Advances extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_advance') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $advances = DB::table('advances')->where('branch',$branch_id); $this->data["pageData"] = json_decode(json_encode($advances->get()),true); $this->data["employees"] = set_array_keys(fetch_table_branch('employees'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'advances'); $this->data["pageToLoad"] = "advances/view.php"; $this->data["activeLink"] = "hrm"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_advance') === FALSE){ Redirect::to('/')->send(); } $this->data["title"] = print_lang($this->data["app_lang"],'new_advance'); $this->data["employees"] = embed_employees_salaries(fetch_table_branch('employees')); $this->data["accounts"] = fetch_nested_accounts(); $this->data["pageToLoad"] = "advances/add.php"; $this->data["activeLink"] = "hrm"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'advance_date' => 'required', 'employee' => 'required', 'new_advance' => 'required', 'account' => 'required', ]); $validator->validate(); $uid = getUniqueId('EADV', 'advances', 'uid'); $employee_data = fetch_table_where('employees','uid',$request->employee,true); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'advance_date' => $request->advance_date, 'employee' => $request->employee, 'previous_advance' => $request->previous_advance, 'new_advance' => $request->new_advance, 'total_advance' => $request->total_advance, 'account' => $request->account, 'currency' => $employee_data['currency'], 'narration' => $request->narration, ); insert_table('advances',$db_array); _handle_advances_ledger_effects(['uid' => $uid, 'state' => 'new']); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'advance_granted'), 'message_body' => print_lang($this->data["app_lang"],'advance_granted_successfully'))); } public function delete($uid) { if(check_user_access('delete_advance') === FALSE){ Redirect::to('/')->send(); } delete_table('advances','uid',$uid); _handle_advances_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }