<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use View; use Hash; class Approvals extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_approval_receipts') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $account = $request->account; if(empty($request->currency)) { $request->currency = 'usd'; } $money_receipts = DB::table('money_receipts')->where('branch',$branch_id)->where('status','pending'); if(!empty($request->currency)){ $money_receipts->where('currency',$request->currency); } if(!empty($request->account)){ $money_receipts->where(function($query) use ($account){ $query->where('sales_man',$account)->orWhere('marketer',$account); }); } $money_receipts = json_decode(json_encode($money_receipts->get()),true); $this->data["pageData"] = $money_receipts; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["sales_man"] = set_array_keys(fetch_table_branch('sales_man'),'uid'); $this->data["marketers"] = set_array_keys(fetch_table_branch('marketers'),'uid'); $this->data["search_account"] = $request->account; $this->data["search_currency"] = $request->currency; $this->data["title"] = print_lang($this->data["app_lang"],'money_receipts_view_title'); $this->data["pageToLoad"] = "approvals/view.php"; $this->data["activeLink"] = "approvals"; $this->load_view($this->data); } public function approved(Request $request) { if(check_user_access('view_approved_receipts') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $account = $request->account; $money_receipts = DB::table('money_receipts')->where('branch',$branch_id)->where('status','passed'); if(!empty($request->account)){ $money_receipts->where(function($query) use ($account){ $query->where('sales_man',$account)->orWhere('marketer',$account); }); } if(!empty($request->currency)){ $money_receipts->where('currency',$request->currency); } if(!empty($request->from)){ $money_receipts->where('approved_date','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $money_receipts->where('approved_date','<=',get_true_date($request->to).' 23:59:59'); } $money_receipts = json_decode(json_encode($money_receipts->get()),true); $this->data["pageData"] = $money_receipts; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["sales_man"] = set_array_keys(fetch_table_branch('sales_man'),'uid'); $this->data["marketers"] = set_array_keys(fetch_table_branch('marketers'),'uid'); $this->data["users"] = set_array_keys(fetch_table('users'),'uid'); $this->data["search_account"] = $request->account; $this->data["search_currency"] = $request->currency; $this->data["search_convert_currency"] = $request->convert_currency; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'receipts_approved_view_title'); $this->data["pageToLoad"] = "approvals/approved.php"; $this->data["activeLink"] = "approvals"; $this->load_view($this->data); } public function approved_print(Request $request) { if(check_user_access('view_approved_receipts') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $account = $request->account; $money_receipts = DB::table('money_receipts')->where('branch',$branch_id)->where('status','passed'); if(!empty($request->account)){ $money_receipts->where(function($query) use ($account){ $query->where('sales_man',$account)->orWhere('marketer',$account); }); } if(!empty($request->currency)){ $money_receipts->where('currency',$request->currency); } if(!empty($request->from)){ $money_receipts->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $money_receipts->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $money_receipts = json_decode(json_encode($money_receipts->get()),true); $this->data["pageData"] = $money_receipts; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["sales_man"] = set_array_keys(fetch_table_branch('sales_man'),'uid'); $this->data["marketers"] = set_array_keys(fetch_table_branch('marketers'),'uid'); $this->data["users"] = set_array_keys(fetch_table('users'),'uid'); $this->data["search_account"] = $request->account; $this->data["search_currency"] = $request->currency; $this->data["search_convert_currency"] = $request->convert_currency; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'receipts_approved_view_title'); $this->data["pageToLoad"] = "approvals/approved_print.php"; $this->data["activeLink"] = "approvals"; $this->load_view($this->data); } public function update_status(Request $request) { $uids = $request->uids; $account = $request->account; $exchange_currency = $request->exchange_currency; $receipts_formula = $request->receipts_formula; $rate = $request->rate; $exchange_currency_data = fetch_table_where('currency','uid',$exchange_currency,true); if(!empty($uids)) { $exchange_amount = 0; foreach($uids as $uid_r) { $receipt_data = fetch_table_where('money_receipts','uid',$uid_r,true); $receipt_data_journal = fetch_table_where('journal','receipt_uid',$uid_r,true); if($receipt_data['status'] == 'pending') { if(empty($receipt_data_journal)) { $_activity_details = array( 'module' => 'money-receipts', 'activity' => 'receipt approved', 'url' => NULL, 'details' => 'Receipt Amount: '.amount_number_format($receipt_data['amount']), ); set_activity_alert($_activity_details); $uid = getUniqueId('JRNL', 'journal', 'uid'); $currency_data = fetch_table_where('currency','uid',$receipt_data['currency'],true); if($receipts_formula == 'divide') { $exchange_amount = $receipt_data['amount'] / $rate; } else { $exchange_amount = $receipt_data['amount'] * $rate; } $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'invoice' => get_journal_invoice_number(), 'journal_date' => date('Y-m-d'), 'receiving_currency' => $currency_data['uid'], 'payment_currency' => $exchange_currency_data['uid'], 'receiving_account' => $receipt_data['client'], 'payment_account' => $account, 'receiving_amount' => $receipt_data['amount'], 'payment_amount' => $exchange_amount, 'rate' => $rate, 'calculation_type' => $receipts_formula, 'receiving_narration' => 'Receipt # '.$receipt_data['invoice'].' '.$receipt_data['details'], 'payment_narration' => 'Receipt # '.$receipt_data['invoice'].' '.$receipt_data['details'], 'receiving_cue' => $currency_data['usd_equalance'], 'payment_cue' => $exchange_currency_data['usd_equalance'], 'is_receipt' => 'yes', 'receipt_uid' => $uid_r, ); insert_table('journal',$db_array); _handle_journal_ledger_effects(['uid' => $uid, 'state' => 'new']); $accounts = set_array_keys(fetch_all_accounts(),'uid'); $payment_account_name = array_key_exists($db_array['payment_account'],$accounts) ? $accounts[$db_array['payment_account']]['name'] : NULL; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_journal'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/journal/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_from').' '.$payment_account_name.','.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['payment_amount']), ); set_activity_alert($_activity_details); $db_array_r = array( 'debit_account' => $account, 'exchange_currency' => $exchange_currency, 'exchange_currency_usd_equalance' => $exchange_currency_data['usd_equalance'], 'receipts_formula' => $receipts_formula, 'rate' => $rate, 'exchange_amount' => $exchange_amount, 'status' => 'passed', 'approved_by' => Session::get('user_id'), 'approved_date' => date('Y-m-d H:i:s'), ); update_table('money_receipts','uid',$uid_r,$db_array_r); } } } echo json_encode(array('status' => 'success', 'mode' => 'status_passed')); } else { echo json_encode(array('status' => 'error', 'mode' => 'status_passed', 'message' => 'No Item Selected')); } } public function view_activities(Request $request) { if(check_user_access('view_approval_activities') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $account = $request->account; if(empty($request->currency)) { $request->currency = 'usd'; } $activities = DB::table('activities')->where('branch',$branch_id)->where('status','pending'); if(!empty($request->currency)){ $activities->where('currency',$request->currency); } if(!empty($request->account)){ $activities->where(function($query) use ($account){ $query->where('salesman',$account)->orWhere('marketer',$account); }); } $activities = json_decode(json_encode($activities->get()),true); $this->data["pageData"] = $activities; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["sales_man"] = set_array_keys(fetch_table_branch('sales_man'),'uid'); $this->data["marketers"] = set_array_keys(fetch_table_branch('marketers'),'uid'); $this->data["search_account"] = $request->account; $this->data["search_currency"] = $request->currency; $this->data["title"] = print_lang($this->data["app_lang"],'activities_approval'); $this->data["pageToLoad"] = "approvals/view_activities.php"; $this->data["activeLink"] = "approvals"; $this->load_view($this->data); } public function view_activities_approved(Request $request) { if(check_user_access('view_approved_activities') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $account = $request->account; if(empty($request->currency)) { $request->currency = 'usd'; } $activities = DB::table('activities')->where('branch',$branch_id)->where('status','approved'); if(!empty($request->currency)){ $activities->where('currency',$request->currency); } if(!empty($request->account)){ $activities->where(function($query) use ($account){ $query->where('salesman',$account)->orWhere('marketer',$account); }); } if(!empty($request->from)){ $activities->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $activities->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $activities = json_decode(json_encode($activities->get()),true); $this->data["pageData"] = $activities; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["sales_man"] = set_array_keys(fetch_table_branch('sales_man'),'uid'); $this->data["marketers"] = set_array_keys(fetch_table_branch('marketers'),'uid'); $this->data["users"] = set_array_keys(fetch_table('users'),'uid'); $this->data["search_account"] = $request->account; $this->data["search_currency"] = $request->currency; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'activities_approved'); $this->data["pageToLoad"] = "approvals/view_activities_approved.php"; $this->data["activeLink"] = "approvals"; $this->load_view($this->data); } public function update_status_activities(Request $request) { $uids = $request->uids; $account = $request->account; $exchange_currency = $request->exchange_currency; $activities_formula = $request->activities_formula; $rate = $request->rate; $exchange_currency_data = fetch_table_where('currency','uid',$exchange_currency,true); if(!empty($uids)) { foreach($uids as $uid) { $activity_data = fetch_table_where('activities','uid',$uid,true); if($activity_data['status'] == 'pending') { $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_activities'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_approved'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($activity_data['amount']), ); if($activities_formula == 'divide') { $exchange_amount = $activity_data['amount'] / $rate; } else { $exchange_amount = $activity_data['amount'] * $rate; } $db_array = array( 'credit_account' => $account, 'status' => 'approved', 'exchange_currency' => $exchange_currency, 'exchange_currency_usd_equalance' => $exchange_currency_data['usd_equalance'], 'activities_formula' => $activities_formula, 'rate' => $rate, 'exchange_amount' => $exchange_amount, 'approved_by' => Session::get('user_id'), 'approved_date' => date('Y-m-d H:i:s'), ); update_table('activities','uid',$uid,$db_array); _handle_activities_ledger_effects(['uid' => $uid, 'state' => 'new']); $j_uid = getUniqueId('JRNL', 'journal', 'uid'); $journal_array = array( 'uid' => $j_uid, 'branch' => active_branch_id(), 'invoice' => get_journal_invoice_number(), 'journal_date' => $activity_data['created_at'], 'receiving_currency' => $exchange_currency_data['uid'], 'payment_currency' => $activity_data['currency'], 'receiving_account' => $account, 'payment_account' => $activity_data['debit_account'], 'receiving_amount' => $exchange_amount, 'payment_amount' => $activity_data['amount'], 'rate' => $rate, 'calculation_type' => $activities_formula, 'receiving_narration' => $activity_data['narration'], 'payment_narration' => $activity_data['narration'], 'calculation_type' => 'multiply', 'receiving_cue' => $exchange_currency_data['usd_equalance'], 'payment_cue' => $activity_data['currency_usd_equalance'], 'is_activity' => 'yes', 'activity_uid' => $activity_data['uid'], ); insert_table('journal',$journal_array); } } echo json_encode(array('status' => 'success', 'mode' => 'status_passed')); } else { echo json_encode(array('status' => 'error', 'mode' => 'status_passed', 'message' => 'No Item Selected')); } } }