<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Assets extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_assets') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $assets = DB::table('assets')->where('branch',$branch_id); if(!empty($request->currency)){ $assets->where('currency',$request->currency); } if(!empty($request->from)){ $assets->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $assets->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($assets->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'assets'); $this->data["pageToLoad"] = "assets/view.php"; $this->data["activeLink"] = "assets"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_assets') === FALSE){ Redirect::to('/')->send(); } $account_types = 'cashbook'; $this->data["title"] = print_lang($this->data["app_lang"],'add_asset'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["types"] = fetch_table_branch('assets_categories'); $this->data["accounts"] = std_obj_to_array(DB::table('accounts')->where('branch',active_branch_id())->where(function($query) use ($account_types) { $query->where('type','cashbook'); $query->orWhere('type','bank'); })->get()); $this->data["pageToLoad"] = "assets/add.php"; $this->data["activeLink"] = "assets"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'account' => 'required', 'type' => 'required', 'name' => 'required', 'qty' => 'required', 'price' => 'required', ]); $validator->validate(); $uid = getUniqueId('ASET', 'assets', 'uid'); $currency_db_data = fetch_table_where('currency','uid',$request->currency,true); $account_db_data = fetch_table_where('accounts','uid',$request->account,true); $type_db_data = fetch_table_where('assets_categories','uid',$request->type,true); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'currency' => $request->currency, 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'currency_name' => $currency_db_data['name'], 'currency_symbol' => $currency_db_data['symbol'], 'account' => $request->account, 'account_name' => $account_db_data['name'], 'type' => $request->type, 'type_name' => $type_db_data['name'], 'name' => $request->name, 'qty' => $request->qty, 'price' => $request->price, 'total' => (float)$request->price * (float)$request->qty, 'narration' => $request->narration, ); insert_table('assets',$db_array); _handle_assets_ledger_effects(['uid' => $uid, 'state' => 'new']); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'asset_added'), 'message_body' => print_lang($this->data["app_lang"],'asset_added_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_assets') === FALSE){ Redirect::to('/')->send(); } $account_types = 'cashbook'; $this->data["editing_data"] = fetch_table_where('assets','uid',$uid,true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["types"] = fetch_table_branch('assets_categories'); $this->data["accounts"] = std_obj_to_array(DB::table('accounts')->where('branch',active_branch_id())->where(function($query) use ($account_types) { $query->where('type','cashbook'); $query->orWhere('type','bank'); })->get()); $this->data["title"] = print_lang($this->data["app_lang"],'edit_asset'); $this->data["pageToLoad"] = "assets/edit.php"; $this->data["activeLink"] = "assets"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'account' => 'required', 'type' => 'required', 'name' => 'required', 'qty' => 'required', 'price' => 'required', ]); $validator->validate(); $currency_db_data = fetch_table_where('currency','uid',$request->currency,true); $account_db_data = fetch_table_where('accounts','uid',$request->account,true); $type_db_data = fetch_table_where('assets_categories','uid',$request->type,true); $db_array = array( 'currency' => $request->currency, 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'currency_name' => $currency_db_data['name'], 'currency_symbol' => $currency_db_data['symbol'], 'account' => $request->account, 'account_name' => $account_db_data['name'], 'type' => $request->type, 'type_name' => $type_db_data['name'], 'name' => $request->name, 'qty' => $request->qty, 'price' => $request->price, 'total' => (float)$request->price * (float)$request->qty, 'narration' => $request->narration, ); update_table('assets','uid',$uid,$db_array); _handle_assets_ledger_effects(['uid' => $uid, 'state' => 'update']); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'asset_updated'), 'message_body' => print_lang($this->data["app_lang"],'asset_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_assets') === FALSE){ Redirect::to('/')->send(); } delete_table('assets','uid',$uid); _handle_assets_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }