<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Session; use Config; use Hash; use Storage; use File; class Authentication extends Controller { public function index() { if(Session::get('logged_status') == 'active') { return redirect("dashboard"); } return view("user.login"); } public function login(Request $request) { if(Session::get('logged_status') == 'active') { return redirect("dashboard"); } $username = $request->username; $password = $request->password; if(empty($username)) { echo json_encode(array('status' => 'error', 'message' => 'Username is mandatory.')); die; } if(empty($password)) { echo json_encode(array('status' => 'error', 'message' => 'Password is mandatory.')); die; } $response = DB::table('users')->where('username',$username)->get(); if($response->count()) { $response = json_decode(json_encode($response[0]),true); $hashed_password = $response['password']; if(Hash::check($password, $hashed_password)) { if (Hash::needsRehash($hashed_password)) { $rehashed_password = Hash::make($password); DB::table('users')->where('uid',$response['uid'])->update(array('password' => $rehashed_password)); } Session::put('logged_status', 'active'); Session::put('user_id', $response['uid']); Session::put('user_role', $response['role']); Session::put('user_name', $response['name']); $is_project_user = ($response['is_project'] == 'yes') ? 'project_user' : 'regular_user'; Session::put('log_type_status', $is_project_user); $app_languages = DB::table('language')->where('uid','english')->get(); if($app_languages->count() == 0) { $db_array = array( 'uid' => 'english', 'name' => 'English (Default)', 'direction' => 'ltr', 'details' => json_encode(app_default_language()), ); insert_table('language',$db_array); } $redirect_url = url('/select-branch'); echo json_encode(array('status' => 'success', 'redirect_url' => $redirect_url, 'message' => 'Redirecting to dashboard')); } else { echo json_encode(array('status' => 'error', 'message' => 'Password is not valid.')); } } else { echo json_encode(array('status' => 'error', 'message' => 'Username is not valid.')); } } public function logout() { Session::flush(); return redirect('/'); } public function database_backup() { $database = env('DB_DATABASE'); $user = env('DB_USERNAME'); $password = env('DB_PASSWORD'); if(env('APP_SERVER') == 'local') { \Spatie\DbDumper\Databases\MySql::create()->setDumpBinaryPath('C:/xampp/mysql/bin/')->setDbName($database)->setUserName($user)->setPassword($password)->dumpToFile('public/database-backup.sql'); } if(env('APP_SERVER') == 'live') { \Spatie\DbDumper\Databases\MySql::create()->setDbName($database)->setUserName($user)->setPassword($password)->dumpToFile('public/database-backup.sql'); } $dFileName = 'database-backup.sql'; $filePath = 'public/'.$dFileName; $headers = array('Content-Type' => File::mimeType($filePath)); return response()->download($filePath, $dFileName, $headers)->deleteFileAfterSend(true); } public function database_backup_old() { if(check_user_access('backup_right') === FALSE){ Redirect::to('/')->send(); } $dFileName = $this->db_dumper(); $filePath = 'public/uploads/'.$dFileName; $headers = array('Content-Type' => File::mimeType($filePath)); return response()->download($filePath, $dFileName, $headers)->deleteFileAfterSend(true); } private function db_dumper() { $db_name = env('DB_DATABASE'); $db_tables_to_export = array(); $db_tables_to_ignore = array(); if(count($db_tables_to_export) > 0) { $tables_for_export = $db_tables_to_export; } else { $tables_for_export = array(); $db_tables_list = DB::select('SHOW TABLES'); foreach($db_tables_list as $table_row) { $tables_for_export[] = head($table_row); } } $dump_collection = "\n\n\n\n"; foreach($tables_for_export as $export_table) { $dump_collection .= 'DROP TABLE IF EXISTS '.$export_table.';'; $dump_collection .= "\n\n\n\n"; $create_table_query = DB::select('SHOW CREATE TABLE '.$export_table); $create_table_query = json_decode(json_encode($create_table_query[0]),true); $create_table_query = array_values($create_table_query); $dump_collection .= $create_table_query[1]; $dump_collection .= ";\n\n\n\n"; $export_table_data = DB::table($export_table)->get(); if(count($export_table_data) > 0) { $export_table_columns = DB::select('SHOW COLUMNS FROM '.$export_table); $export_table_columns = array_column($export_table_columns, 'Field'); $export_table_columns_string = implode( ',', $export_table_columns); $export_table_values = array(); if(count($export_table_data) == 1) { $export_table_row = json_decode(json_encode($export_table_data[0]),true); $export_table_row_values = array(); foreach($export_table_columns as $export_table_column) { $export_table_row_values[] = empty($export_table_row[$export_table_column]) ? 'NULL' : "'".$export_table_row[$export_table_column]."'"; } $export_table_values_str = '('. implode(',', $export_table_row_values) .')'; } else { $export_table_data = json_decode(json_encode($export_table_data),true); foreach($export_table_data as $export_table_row) { $export_table_row_values = array(); foreach($export_table_columns as $export_table_column) { $export_table_row_values[] = empty($export_table_row[$export_table_column]) ? 'NULL' : "'".$export_table_row[$export_table_column]."'"; } $export_table_row_values_str = implode(',', $export_table_row_values); $export_table_values[] = '('.$export_table_row_values_str.')'; } $export_table_values_str = implode(',', $export_table_values); } $dump_collection .= 'INSERT INTO `'.$export_table.'` ('.$export_table_columns_string.') VALUES '; $dump_collection .= $export_table_values_str; $dump_collection .= ";"."\n\n\n\n"; } } $dFileName = $db_name.'-backup-'.date("Y-m-d-H-i-s", time()).'.sql'; Storage::disk('uploads')->put($dFileName, $dump_collection); return $dFileName; } }