<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Batch extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_batch') === FALSE){ Redirect::to('/')->send(); } $this->data["pageData"] = fetch_table_branch('batch'); $this->data["title"] = print_lang($this->data["app_lang"],'batch'); $this->data["pageToLoad"] = "batch/view.php"; $this->data["activeLink"] = "settings"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_batch') === FALSE){ Redirect::to('/')->send(); } $this->data["title"] = print_lang($this->data["app_lang"],'add_batch'); $this->data["pageToLoad"] = "batch/add.php"; $this->data["activeLink"] = "settings"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'number' => 'required|unique:batch', ]); $validator->validate(); $uid = getUniqueId('BACH', 'batch', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'name' => $request->name, 'number' => $request->number, ); insert_table('batch',$db_array); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'batch_created'), 'message_body' => print_lang($this->data["app_lang"],'new_batch_created_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_batch') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('batch','uid',$uid,true); $this->data["title"] = print_lang($this->data["app_lang"],'edit_batch'); $this->data["pageToLoad"] = "batch/edit.php"; $this->data["activeLink"] = "settings"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'number' => ['required', Rule::unique('batch')->ignore($uid, 'uid')], ]); $validator->validate(); $db_array = array( 'name' => $request->name, 'number' => $request->number, ); update_table('batch','uid',$uid,$db_array); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'batch_updated'), 'message_body' => print_lang($this->data["app_lang"],'batch_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_batch') === FALSE){ Redirect::to('/')->send(); } delete_table('batch','uid',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }