<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use View; use Hash; class Bookings extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(is_customer_user() === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $clients = array(); $user = Session::get('user_id'); $customer = get_active_customer(); $bookings = DB::table('bookings')->where('branch',$branch_id)->where('user',$user); if(!empty($request->currency)){ $bookings->where('currency',$request->currency); } if(!empty($request->status)){ $bookings->where('status',$request->status); } if(!empty($request->from)){ $bookings->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $bookings->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $bookings = json_decode(json_encode($bookings->get()),true); $this->data["pageData"] = $bookings; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["search_status"] = $request->status; $this->data["title"] = print_lang($this->data["app_lang"],'mod_bookings_view_title'); $this->data["pageToLoad"] = "bookings/view.php"; $this->data["activeLink"] = "bookings"; $this->load_view($this->data); } public function view_processed(Request $request) { if(is_customer_user() === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $clients = array(); $user = Session::get('user_id'); $customer = get_active_customer(); $bookings = DB::table('bookings')->where('branch',$branch_id)->where('user',$user)->where('status','processed'); if(!empty($request->currency)){ $bookings->where('currency',$request->currency); } if(!empty($request->from)){ $bookings->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $bookings->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $bookings = json_decode(json_encode($bookings->get()),true); $this->data["pageData"] = $bookings; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["search_status"] = $request->status; $this->data["title"] = print_lang($this->data["app_lang"],'mod_bookings_view_title'); $this->data["pageToLoad"] = "bookings/view_processed.php"; $this->data["activeLink"] = "bookings"; $this->load_view($this->data); } public function invoice(Request $request,$uid) { if(is_customer_user() === FALSE){ if(check_user_access('orders_view_invoice') === FALSE){ Redirect::to('/')->send(); } } $this->data["invoice_data"] = fetch_table_where('bookings','uid',$uid,true); $this->data["items"] = set_array_keys(fetch_table('items'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_bookings_view_title'); $this->data["pageToLoad"] = "bookings/invoice.php"; $this->data["activeLink"] = "bookings"; $this->load_view($this->data); } public function invoice_process(Request $request,$uid) { if(is_customer_user() === FALSE){ if(check_user_access('orders_view_invoice') === FALSE){ Redirect::to('/')->send(); } } $this->data["invoice_data"] = fetch_table_where('bookings','uid',$uid,true); $this->data["items"] = set_array_keys(fetch_table('items'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_bookings_view_title'); $this->data["pageToLoad"] = "bookings/invoice_process.php"; $this->data["activeLink"] = "bookings"; $this->load_view($this->data); } public function add(Request $request) { if(is_customer_user() === FALSE){ Redirect::to('/')->send(); } $this->data["items"] = fetch_table_branch('items'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_bookings_add_title'); $this->data["pageToLoad"] = "bookings/add.php"; $this->data["activeLink"] = "bookings"; $this->load_view($this->data); } public function save(Request $request) { $items_found = false; $active_branch_id = active_branch_id(); $booking_collection_of_items = array(); $booking_collection_of_items_uid = array(); $user = Session::get('user_id'); $customer = get_active_customer(); $currency_db_data = fetch_table_where('currency','uid',$request->currency[0],true); if(count($request->item) > 0) { $items_count = 0; while($items_count < count($request->item)) { $items_found = true; $item_array = array( 'item' => $request->item[$items_count], 'qty' => (float)$request->qty[$items_count], 'tp' => (float)$request->tp[$items_count], 'total' => (float)$request->total_r[$items_count], ); $booking_collection_of_items[] = $item_array; $booking_collection_of_items_uid[] = '-++-'.$request->item[$items_count].'-++-'; $items_count++; } } if($items_found == true) { $uid = getUniqueId('BOOK', 'bookings', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => $active_branch_id, 'currency' => $request->currency[0], 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'invoice' => get_booking_invoice_number(), 'memo' => $request->memo[0], 'items' => json_encode($booking_collection_of_items), 'items_uid' => implode(',', $booking_collection_of_items_uid), 'total' => (float)$request->total, 'user' => $user, 'customer' => $customer, 'expected_date' => get_true_date($request->pdate[0]), ); insert_table('bookings',$db_array); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_booking'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/bookings/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].','.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['total']), ); set_activity_alert($_activity_details); $invoice_url = url('/bookings/invoice').'/'.$uid; echo json_encode(array('status' => 'success', 'mood' => 'new', 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'mod_bookings_added'), 'message_body' => print_lang($this->data["app_lang"],'mod_bookings_save_successfully'))); } else { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'item_not_found'), 'message_body' => print_lang($this->data["app_lang"],'add_items_to_proceed'))); } } public function edit(Request $request, $uid) { if(is_customer_user() === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('bookings','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/bookings')->send(); } $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_bookings_edit_title'); $this->data["pageToLoad"] = "bookings/edit.php"; $this->data["activeLink"] = "bookings"; $this->load_view($this->data); } public function update(Request $request, $uid) { $items_found = false; $active_branch_id = active_branch_id(); $booking_collection_of_items = array(); $booking_collection_of_items_uid = array(); $user = Session::get('user_id'); $customer = get_active_customer(); $booking_data = fetch_table_where('bookings','uid',$uid,true); $currency_db_data = fetch_table_where('currency','uid',$request->currency[0],true); if(count($request->item) > 0) { $items_count = 0; while($items_count < count($request->item)) { $items_found = true; $item_array = array( 'item' => $request->item[$items_count], 'qty' => (float)$request->qty[$items_count], 'tp' => (float)$request->tp[$items_count], 'total' => (float)$request->total_r[$items_count], ); $booking_collection_of_items[] = $item_array; $booking_collection_of_items_uid[] = '-++-'.$request->item[$items_count].'-++-'; $items_count++; } } if($items_found == true) { $db_array = array( 'memo' => $request->memo[0], 'items' => json_encode($booking_collection_of_items), 'items_uid' => implode(',', $booking_collection_of_items_uid), 'total' => (float)$request->total, ); update_table('bookings','uid',$uid,$db_array); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_booking'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/bookings/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$booking_data['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['total']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'mod_bookings_update'), 'message_body' => print_lang($this->data["app_lang"],'mod_bookings_update_successfully'))); } else { echo json_encode(array('status' => 'error', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'item_not_found'), 'message_body' => print_lang($this->data["app_lang"],'add_items_to_proceed'))); } } public function delete($uid) { delete_table('bookings','uid',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function sales(Request $request) { if(is_customer_user() === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $clients = array(); $user = Session::get('user_id'); $client = get_active_customer(); $sales = DB::table('sales')->where('branch',$branch_id)->where('client',$client); if(!empty($request->currency)){ $sales->where('currency',$request->currency); } if(!empty($request->from)){ $sales->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $sales->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $sales = json_decode(json_encode($sales->get()),true); $this->data["pageData"] = $sales; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["search_client"] = $client; $this->data["title"] = print_lang($this->data["app_lang"],'mod_bookings_view_title'); $this->data["pageToLoad"] = "bookings/sales.php"; $this->data["activeLink"] = "bookings"; $this->load_view($this->data); } }