<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Session; class Branch_setup extends Controller { public function __construct() { $this->middleware(function ($request, $next) { if(is_log_in() === FALSE) { return redirect('/'); } else { return $next($request); } }); } public function select_branch(Request $request) { if(Session::get('branch_status') == 'active'){ return redirect("dashboard"); } $branches = DB::table('branches')->get(); $user_role = Session::get('user_role'); if($user_role == 'SUPERADMIN' OR $user_role == 'ADMIN') { if($branches->count() > 0) { $branches = json_decode(json_encode($branches),true); $data["branches"] = $branches; return view("user.branches")->with($data); } else { return redirect("branches-setup/add"); } } else { if($branches->count() > 0) { $user_id = Session::get('user_id'); $user_data = fetch_table_where('users','uid',$user_id,true); $user_branch_data = DB::table('branches')->where('uid',$user_data['branch'])->get(); if($user_branch_data->count() > 0) { $user_branch_data = json_decode(json_encode($user_branch_data[0]),true); Session::put('branch_status', 'active'); Session::put('branch_uid', $user_branch_data['uid']); Session::put('branch_name', $user_branch_data['branch_name']); return redirect("dashboard"); } } else { return redirect("logout"); } } } public function activate_branch(Request $request, $branch_uid) { $branches = DB::table('branches')->where('uid',$branch_uid)->get(); if($branches->count() > 0) { $branch_data = json_decode(json_encode($branches[0]),true); Session::put('branch_status', 'active'); Session::put('branch_uid', $branch_data['uid']); Session::put('branch_name', $branch_data['branch_name']); return redirect("dashboard"); } else { return redirect("select-branch"); } } public function add(Request $request) { if(check_user_access('add_department') === FALSE){ Redirect::to('/')->send(); } $data["languages"] = fetch_table('language'); return view("user.branches/add_setup")->with($data); } public function save(Request $request) { $request->validate([ 'branch_number' => 'required', 'branch_name' => 'required', 'branch_mobile' => 'required', 'branch_address' => 'required', 'branch_language' => 'required', ]); $uid = getUniqueId('BRCH', 'branches', 'uid'); $branch_logo = NULL; if($request->hasFile('branch_logo')) { $file = $request->file('branch_logo'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('BL'); $fileNamePrefix = db_unique_id('branches',$fileNamePrefix); $branch_logo = $fileNamePrefix.'.'.$extension; $file->move('uploads/branches/',$branch_logo); } $branch_banner_reports = NULL; if($request->hasFile('branch_banner_reports')) { $file = $request->file('branch_banner_reports'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('BBFR'); $fileNamePrefix = db_unique_id('branches',$fileNamePrefix); $branch_banner_reports = $fileNamePrefix.'.'.$extension; $file->move('uploads/branches/',$branch_banner_reports); } $branch_banner_invoices = NULL; if($request->hasFile('branch_banner_invoices')) { $file = $request->file('branch_banner_invoices'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('BBFI'); $fileNamePrefix = db_unique_id('branches',$fileNamePrefix); $branch_banner_invoices = $fileNamePrefix.'.'.$extension; $file->move('uploads/branches/',$branch_banner_invoices); } $branch_banner_return = NULL; if($request->hasFile('branch_banner_return')) { $file = $request->file('branch_banner_return'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('BBFIR'); $fileNamePrefix = db_unique_id('branches',$fileNamePrefix); $branch_banner_return = $fileNamePrefix.'.'.$extension; $file->move('uploads/branches/',$branch_banner_return); } $branch_banner_bookings = NULL; if($request->hasFile('branch_banner_bookings')) { $file = $request->file('branch_banner_bookings'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('BBFB'); $fileNamePrefix = db_unique_id('branches',$fileNamePrefix); $branch_banner_bookings = $fileNamePrefix.'.'.$extension; $file->move('uploads/branches/',$branch_banner_bookings); } $db_array = array( 'uid' => $uid, 'branch_number' => $request->branch_number, 'branch_name' => $request->branch_name, 'branch_mobile' => $request->branch_mobile, 'branch_address' => $request->branch_address, 'branch_logo' => $branch_logo, 'branch_banner_reports' => $branch_banner_reports, 'branch_banner_invoices' => $branch_banner_invoices, 'branch_banner_return' => $branch_banner_return, 'branch_banner_bookings' => $branch_banner_bookings, 'branch_language' => $request->branch_language, ); insert_table('branches',$db_array); $db_array = array( 'uid' => 'SAFEACCOUNT'.$uid, 'branch' => $uid, 'name' => 'Cash', 'type' => 'cashbook', 'code' => '111', 'memo' => 'Branch Safe Account', 'opening_balance' => json_encode(array()), ); insert_table('accounts',$db_array); $db_array = array( 'uid' => 'CASHSALE'.$uid, 'branch' => $uid, 'name' => 'Cash Sale', 'type' => 'client', 'code' => get_new_account_code(), 'memo' => 'Branch Cash Sale Account', 'opening_balance' => json_encode(array()), ); insert_table('accounts',$db_array); $currency = fetch_table_where('currency','uid','usd',true); if(empty($currency)) { $currency_db_array = array( 'uid' => 'usd', 'branch' => 'general', 'name' => 'USD', 'symbol' => '$', 'usd_equalance' => 1, ); insert_table('currency',$currency_db_array); } Session::put('branch_status', 'active'); Session::put('branch_uid', $uid); Session::put('branch_name', $request->branch_name); echo json_encode(array('status' => 'success', 'mood' => 'new', 'in_setup' => 'yes', 'redirect_url' => url('/dashboard'), 'message_head' => 'Branch Created', 'message_body' => 'New branch created successfully.')); } }