<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Branch_to_branch_transfer extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_assets') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $branch_to_branch_transfer = DB::table('branch_to_branch_transfer')->where('branch',$branch_id); if(!empty($request->currency)){ $branch_to_branch_transfer->where('currency',$request->currency); } if(!empty($request->from)){ $branch_to_branch_transfer->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $branch_to_branch_transfer->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($branch_to_branch_transfer->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["branches"] = set_array_keys(fetch_table('branches'),'uid'); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["warehouses"] = set_array_keys(fetch_table('warehouse'),'uid'); $this->data["items"] = set_array_keys(fetch_table('items'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'mod_branch_to_branch_transfer'); $this->data["pageToLoad"] = "branch_to_branch_transfer/view.php"; $this->data["activeLink"] = "branch_to_branch_transfer"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_assets') === FALSE){ Redirect::to('/')->send(); } $this->data["title"] = print_lang($this->data["app_lang"],'mod_branch_to_branch_transfer_add_title'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["branches"] = set_array_keys(fetch_table('branches'),'uid'); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["warehouses"] = set_array_keys(fetch_table('warehouse'),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["pageToLoad"] = "branch_to_branch_transfer/add.php"; $this->data["activeLink"] = "branch_to_branch_transfer"; $this->load_view($this->data); } public function save(Request $request) { $branch_id = active_branch_id(); if(!empty($request->item)) { foreach($request->item as $key => $item) { $warehouses = []; $opening_stock = []; $item_collection_of_warehouses_uid = []; $uid = getUniqueId('BTBTRNS', 'branch_to_branch_transfer', 'uid'); $item_data = fetch_table_where('items','uid',$item,true); $t_date_db = get_true_date( empty($request->t_date[$key]) ? date('y-m-d') : $request->t_date[$key] ); $time_cr = date('H:i:s'); $t_date_db = $t_date_db." ".$time_cr; if($request->unit[$key] == 'sale') { if(empty($item_data['sale_unit_equalance']) OR $item_data['sale_unit_equalance'] == 0) { $item_data['sale_unit_equalance'] = 1; } $cost = $request->cost[$key] / $item_data['sale_unit_equalance']; $profit = $request->profit[$key] / $item_data['sale_unit_equalance']; } else if($request->unit[$key] == 'production') { if(empty($item_data['production_unit_equalance']) OR $item_data['production_unit_equalance'] == 0) { $item_data['production_unit_equalance'] = 1; } $cost = $request->cost[$key] / $item_data['production_unit_equalance']; $profit = $request->profit[$key] / $item_data['production_unit_equalance']; } else { $cost = $request->cost[$key]; $profit = $request->profit[$key]; } $db_array = [ 'uid' => $uid, 'b_to_b_rel_uid' => $item_data['b_to_b_rel_uid'], 't_date' => $t_date_db, 'branch' => $branch_id, 'item' => $item, 'currency' => $item_data['currency'], 'currency_usd_equalance' => $item_data['currency_usd_equalance'], 'warehouse' => $request->warehouse[$key], 'to_branch' => $request->to_branch[$key], 'to_warehouse' => $request->to_warehouse[$key], 'unit' => $request->unit[$key], 'batch' => $request->batch[$key], 'category' => $item_data['category'], 'mfg' => $item_data['mfg_date'], 'expiry' => $item_data['expiry_date'], 'cost' => $cost, 'profit' => $profit, 'sale_price' => (float)$cost + (float)$profit, 'qty' => $request->qty[$key], 'total' => (float)$cost * (float)$request->qty[$key], 'details' => $request->details[$key], ]; insert_table('branch_to_branch_transfer',$db_array); $b_item_data = std_obj_to_array(DB::table('items')->where('branch',$db_array['to_branch'])->where('b_to_b_rel_uid',$db_array['b_to_b_rel_uid'])->get()->first()); if(empty($b_item_data)) { $item_currency = $item_data['currency']; $item_currency_data = fetch_table_where('currency','uid',$item_currency,true); $item_currency_branch_equalance = $item_currency_data['branch_equalance']; if($item_currency != 'usd') { $transfer_branch_currency = std_obj_to_array(DB::table('currency')->where('branch',$db_array['to_branch'])->where('branch_equalance',$item_currency_branch_equalance)->get()->first()); if(empty($transfer_branch_currency)) { $cur_uid = getUniqueId('CURR', 'currency', 'uid'); $currency_array = array( 'uid' => $cur_uid, 'branch' => $db_array['to_branch'], 'name' => $item_currency_data['name'], 'symbol' => $item_currency_data['symbol'], 'usd_equalance' => $item_currency_data['usd_equalance'], 'branch_equalance' => $item_currency_data['branch_equalance'], ); insert_table('currency',$currency_array); } else { $currency_array = $transfer_branch_currency; } } if($item_currency == 'usd') { $transfer_item_currency_data = $item_currency_data; } else { $transfer_item_currency_data = $currency_array; } $item_uid = getUniqueId('ITEM', 'items', 'uid'); $max_id = DB::table('items')->where('branch',$db_array['to_branch'])->max('item_id'); $max_id = (int)$max_id + 1; $warehouses[] = $db_array['to_warehouse']; $opening_stock[] = 0; $item_collection_of_warehouses_uid[] = '-++-'.$db_array['to_warehouse'].'-++-'; $item_db_array = [ 'uid' => $item_uid, 'b_to_b_rel_uid' => $item_data['b_to_b_rel_uid'], 'branch' => $db_array['to_branch'], 'item_id' => $max_id, 'name' => $item_data['name'], 'type' => $item_data['type'], 'category' => $item_data['category'], 'purchase_unit' => $item_data['purchase_unit'], 'purchase_unit_equalance' => $item_data['purchase_unit_equalance'], 'purchase_unit_name' => $item_data['purchase_unit_name'], 'sale_unit' => $item_data['sale_unit'], 'sale_unit_equalance' => $item_data['sale_unit_equalance'], 'sale_unit_name' => $item_data['sale_unit_name'], 'production_unit' => $item_data['production_unit'], 'production_unit_equalance' => $item_data['production_unit_equalance'], 'production_unit_equalance' => $item_data['production_unit_equalance'], 'warehouses' => json_encode($warehouses), 'warehouse_uids' => implode(',', $item_collection_of_warehouses_uid), 'opening_stocks' => json_encode($opening_stock), 'batch' => $db_array['batch'], 'currency' => $transfer_item_currency_data['uid'], 'currency_usd_equalance' => $transfer_item_currency_data['usd_equalance'], 'cost' => $db_array['cost'], 'sale_price' => $db_array['sale_price'], 'reorder_qty' => $item_data['reorder_qty'], 'height' => $item_data['height'], 'width' => $item_data['width'], 'length' => $item_data['length'], 'item_width' => $item_data['item_width'], 'item_length' => $item_data['item_length'], 'item_height' => $item_data['item_height'], 'cbm' => $item_data['cbm'], 'weight' => $item_data['weight'], 'reorder_qty' => $item_data['reorder_qty'], 'mfg_date' => $item_data['mfg_date'], 'expiry_date' => $item_data['expiry_date'], 'expiry_alert' => $item_data['expiry_alert'], 'details' => $item_data['details'], 'country' => $item_data['country'], 'company' => $item_data['company'], ]; insert_table('items',$item_db_array); _handle_items_inventory_stats_from_item_registration(['uid' => $item_uid, 'entry_status' => 'new']); } _handle_items_inventory_stats_from_branch_to_branch_transfer(['uid' => $uid, 'entry_status' => 'new']); } } echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'mod_branch_to_branch_transfer_added'), 'message_body' => print_lang($this->data["app_lang"],'mod_branch_to_branch_transfer_save_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_assets') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('branch_to_branch_transfer','uid',$uid,true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["branches"] = set_array_keys(fetch_table('branches'),'uid'); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["warehouses"] = set_array_keys(fetch_table('warehouse'),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["batch"] = _items_warehouse_wise_batch($this->data["editing_data"]['item'],$this->data["editing_data"]['warehouse']); $this->data["title"] = print_lang($this->data["app_lang"],'mod_branch_to_branch_transfer_edit_title'); $this->data["pageToLoad"] = "branch_to_branch_transfer/edit.php"; $this->data["activeLink"] = "branch_to_branch_transfer"; $this->load_view($this->data); } public function update(Request $request, $uid) { $item_data = fetch_table_where('items','uid',$request->item,true); $last_transfer = fetch_table_where('branch_to_branch_transfer','uid',$uid,true); $last_t_date = $last_transfer['t_date']; $last_time = date("H:i:s",strtotime($last_t_date)); $t_date_db = get_true_date( empty($request->t_date) ? date('Y-m-d') : $request->t_date ); $t_date_db = $t_date_db." ".$last_time; if($request->unit == 'sale') { if(empty($item_data['sale_unit_equalance']) OR $item_data['sale_unit_equalance'] == 0) { $item_data['sale_unit_equalance'] = 1; } $cost = $request->cost / $item_data['sale_unit_equalance']; $profit = $request->profit / $item_data['sale_unit_equalance']; } else if($request->unit == 'production') { if(empty($item_data['production_unit_equalance']) OR $item_data['production_unit_equalance'] == 0) { $item_data['production_unit_equalance'] = 1; } $cost = $request->cost / $item_data['production_unit_equalance']; $profit = $request->profit / $item_data['production_unit_equalance']; } else { $cost = $request->cost; $profit = $request->profit; } $db_array = [ 'branch' => active_branch_id(), 't_date' => $t_date_db, 'item' => $request->item, 'b_to_b_rel_uid' => $item_data['b_to_b_rel_uid'], 'currency' => $item_data['currency'], 'currency_usd_equalance' => $item_data['currency_usd_equalance'], 'warehouse' => $request->warehouse, 'to_branch' => $request->to_branch, 'to_warehouse' => $request->to_warehouse, 'unit' => $request->unit, 'batch' => $request->batch, 'category' => $item_data['category'], 'mfg' => $item_data['mfg_date'], 'expiry' => $item_data['expiry_date'], 'cost' => $request->cost, 'profit' => $request->profit, 'sale_price' => (float)$request->cost + (float)$request->profit, 'qty' => $request->qty, 'total' => (float)$request->cost * (float)$request->qty, 'details' => $request->details, ]; update_table('branch_to_branch_transfer','uid',$uid,$db_array); $b_item_data = std_obj_to_array(DB::table('items')->where('branch',$db_array['to_branch'])->where('b_to_b_rel_uid',$item_data['b_to_b_rel_uid'])->get()->first()); if(empty($b_item_data)) { $item_currency = $item_data['currency']; $item_currency_data = fetch_table_where('currency','uid',$item_currency,true); $item_currency_branch_equalance = $item_currency_data['branch_equalance']; if($item_currency != 'usd') { $transfer_branch_currency = std_obj_to_array(DB::table('currency')->where('branch',$db_array['to_branch'])->where('branch_equalance',$item_currency_branch_equalance)->get()->first()); if(empty($transfer_branch_currency)) { $cur_uid = getUniqueId('CURR', 'currency', 'uid'); $currency_array = array( 'uid' => $cur_uid, 'branch' => $db_array['to_branch'], 'name' => $item_currency_data['name'], 'symbol' => $item_currency_data['symbol'], 'usd_equalance' => $item_currency_data['usd_equalance'], 'branch_equalance' => $item_currency_data['branch_equalance'], ); insert_table('currency',$currency_array); } else { $currency_array = $transfer_branch_currency; } } if($item_currency == 'usd') { $transfer_item_currency_data = $item_currency_data; } else { $transfer_item_currency_data = $currency_array; } $item_uid = getUniqueId('ITEM', 'items', 'uid'); $max_id = DB::table('items')->where('branch',$db_array['to_branch'])->max('item_id'); $max_id = (int)$max_id + 1; $warehouses[] = $db_array['to_warehouse']; $opening_stock[] = 0; $item_collection_of_warehouses_uid[] = '-++-'.$db_array['to_warehouse'].'-++-'; $item_db_array = [ 'uid' => $item_uid, 'b_to_b_rel_uid' => $item_data['b_to_b_rel_uid'], 'branch' => $db_array['to_branch'], 'item_id' => $max_id, 'name' => $item_data['name'], 'type' => $item_data['type'], 'category' => $item_data['category'], 'purchase_unit' => $item_data['purchase_unit'], 'purchase_unit_equalance' => $item_data['purchase_unit_equalance'], 'purchase_unit_name' => $item_data['purchase_unit_name'], 'sale_unit' => $item_data['sale_unit'], 'sale_unit_equalance' => $item_data['sale_unit_equalance'], 'sale_unit_name' => $item_data['sale_unit_name'], 'production_unit' => $item_data['production_unit'], 'production_unit_equalance' => $item_data['production_unit_equalance'], 'production_unit_equalance' => $item_data['production_unit_equalance'], 'warehouses' => json_encode($warehouses), 'warehouse_uids' => implode(',', $item_collection_of_warehouses_uid), 'opening_stocks' => json_encode($opening_stock), 'batch' => $db_array['batch'], 'currency' => $transfer_item_currency_data['uid'], 'currency_usd_equalance' => $transfer_item_currency_data['usd_equalance'], 'cost' => $db_array['cost'], 'sale_price' => $db_array['sale_price'], 'reorder_qty' => $item_data['reorder_qty'], 'height' => $item_data['height'], 'width' => $item_data['width'], 'length' => $item_data['length'], 'item_width' => $item_data['item_width'], 'item_length' => $item_data['item_length'], 'item_height' => $item_data['item_height'], 'cbm' => $item_data['cbm'], 'weight' => $item_data['weight'], 'reorder_qty' => $item_data['reorder_qty'], 'mfg_date' => $item_data['mfg_date'], 'expiry_date' => $item_data['expiry_date'], 'expiry_alert' => $item_data['expiry_alert'], 'details' => $item_data['details'], 'country' => $item_data['country'], 'company' => $item_data['company'], ]; insert_table('items',$item_db_array); _handle_items_inventory_stats_from_item_registration(['uid' => $item_uid, 'entry_status' => 'new']); } _handle_items_inventory_stats_from_branch_to_branch_transfer(['uid' => $uid, 'entry_status' => 'update']); _calculate_item_wise_stats(['item' => $last_transfer['item']]); $other_item = fetch_table_where('items','b_to_b_rel_uid',$last_transfer['item'],true); if(!empty($other_item)) { _calculate_item_wise_stats(['item' => $other_item['uid']]); } echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'mod_branch_to_branch_transfer_update'), 'message_body' => print_lang($this->data["app_lang"],'mod_branch_to_branch_transfer_update_successfully'))); } public function delete($uid) { if(check_user_access('delete_assets') === FALSE){ Redirect::to('/')->send(); } $last_transfer = fetch_table_where('branch_to_branch_transfer','uid',$uid,true); $other_branch_old_item = std_obj_to_array(DB::table('items')->where('branch',$last_transfer['to_branch'])->where('b_to_b_rel_uid',$last_transfer['b_to_b_rel_uid'])->get()->first()); delete_table('branch_to_branch_transfer','uid',$uid); _handle_items_inventory_stats_from_branch_to_branch_transfer(['uid' => $uid, 'entry_status' => 'delete']); _calculate_item_wise_stats(['item' => $last_transfer['item']]); $other_item = fetch_table_where('items','b_to_b_rel_uid',$last_transfer['item'],true); if(!empty($other_item)) { _calculate_item_wise_stats(['item' => $other_item['uid']]); } echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }