<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Branch_transfer_out extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_sale') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $branch_transfer_out = DB::table('branch_transfer_out')->where('branch',$branch_id); if(!empty($request->item)){ $branch_transfer_out->where('item',$request->item); } if(!empty($request->warehouse)){ $branch_transfer_out->where('warehouse',$request->warehouse); } if(!empty($request->from)){ $branch_transfer_out->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $branch_transfer_out->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($branch_transfer_out->get()),true); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["warehouses"] = set_array_keys(fetch_table('warehouse'),'uid'); $this->data["branches"] = set_array_keys(fetch_table('branches'),'uid'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["search_item"] = $request->item; $this->data["search_warehouse"] = $request->warehouse; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'branch_transfer_out'); $this->data["pageToLoad"] = "branch-transfer-out/view.php"; $this->data["activeLink"] = "branch-transfer"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_sale') === FALSE){ Redirect::to('/')->send(); } $this->data["active_branch_id"] = active_branch_id(); $this->data["items"] = fetch_table_branch('items'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["warehouses"] = set_array_keys(fetch_table('warehouse'),'uid'); $this->data["branches"] = set_array_keys(fetch_table('branches'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'new_branch_transfer_out'); $this->data["pageToLoad"] = "branch-transfer-out/add.php"; $this->data["activeLink"] = "branch-transfer"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'item' => 'required', 'warehouse' => 'required', 'unit' => 'required', 'qty' => 'required', 'to_branch' => 'required', 'to_warehouse' => 'required', ]); $validator->validate(); $uid = getUniqueId('BTRO', 'branch_transfer_out', 'uid'); $item_record = fetch_table_where('items','uid',$request->item,true); $item_stats = json_decode($item_record['stats'],true); $cost = (float)$item_stats['last_cost']; $profit = (float)$item_stats['last_profit']; $sale_price = $cost + $profit; $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'item' => $request->item, 'warehouse' => $request->warehouse, 'unit' => $request->unit, 'batch' => empty($request->batch) ? env('APP_BATCH') : $request->batch, 'qty' => $request->qty, 'cost' => $cost, 'profit' => $profit, 'sale_price' => $sale_price, 'to_branch' => $request->to_branch, 'to_warehouse' => $request->to_warehouse, 'narration' => $request->narration, ); insert_table('branch_transfer_out',$db_array); _handle_items_inventory_stats_from_branch_transfer_out(['uid' => $uid, 'entry_status' => 'new']); $item_data = fetch_table_where('items','uid',$db_array['item'],true); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_branch_transfer_out'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/branch-transfer-out/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_item').': '.$item_data['name'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_qty').': '.amount_number_format($db_array['qty']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'branch_item_transferred_out'), 'message_body' => print_lang($this->data["app_lang"],'branch_item_transferred_out_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_sale') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('branch_transfer_out','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/branch-transfer-out')->send(); } $this->data["active_branch_id"] = active_branch_id(); $this->data["items"] = fetch_table_branch('items'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["warehouses"] = set_array_keys(fetch_table('warehouse'),'uid'); $this->data["branches"] = set_array_keys(fetch_table('branches'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'edit_branch_transfer_out'); $this->data["pageToLoad"] = "branch-transfer-out/edit.php"; $this->data["activeLink"] = "branch-transfer"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'item' => 'required', 'warehouse' => 'required', 'unit' => 'required', 'qty' => 'required', 'to_branch' => 'required', 'to_warehouse' => 'required', ]); $validator->validate(); $item_record = fetch_table_where('items','uid',$request->item,true); $item_stats = json_decode($item_record['stats'],true); $cost = (float)$item_stats['last_cost']; $profit = (float)$item_stats['last_profit']; $sale_price = $cost + $profit; $db_array = array( 'item' => $request->item, 'warehouse' => $request->warehouse, 'unit' => $request->unit, 'batch' => empty($request->batch) ? env('APP_BATCH') : $request->batch, 'qty' => $request->qty, 'cost' => $cost, 'profit' => $profit, 'sale_price' => $sale_price, 'to_branch' => $request->to_branch, 'to_warehouse' => $request->to_warehouse, 'narration' => $request->narration, ); $data_before_update = fetch_table_where('branch_transfer_out','uid',$uid,true); update_table('branch_transfer_out','uid',$uid,$db_array); _handle_items_inventory_stats_from_branch_transfer_out(['uid' => $uid, 'entry_status' => 'update']); _calculate_item_wise_stats(['item' => $data_before_update['item']]); $item_data = fetch_table_where('items','uid',$db_array['item'],true); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_branch_transfer_out'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/branch-transfer-out/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_item').': '.$item_data['name'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_qty').': '.amount_number_format($db_array['qty']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'branch_transferred_out_updated'), 'message_body' => print_lang($this->data["app_lang"],'branch_transferred_out_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_sale') === FALSE){ Redirect::to('/')->send(); } $db_array = fetch_table_where('branch_transfer_out','uid',$uid,true); $item_data = fetch_table_where('items','uid',$db_array['item'],true); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_branch_transfer_out'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_item').': '.$item_data['name'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_qty').': '.amount_number_format($db_array['qty']), ); set_activity_alert($_activity_details); delete_table('branch_transfer_out','uid',$uid); _handle_items_inventory_stats_from_branch_transfer_out(['uid' => $uid, 'entry_status' => 'delete']); _calculate_item_wise_stats(['item' => $db_array['item']]); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }