<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; class Branches extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_branch') === FALSE){ Redirect::to('/')->send(); } $branches = fetch_table('branches'); $this->data["pageData"] = $branches; $this->data["title"] = print_lang($this->data["app_lang"],'branches'); $this->data["pageToLoad"] = "branches/view.php"; $this->data["activeLink"] = "branches"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_branch') === FALSE){ Redirect::to('/')->send(); } $this->data["languages"] = fetch_table('language'); $this->data["title"] = print_lang($this->data["app_lang"],'add_branch'); $this->data["pageToLoad"] = "branches/add.php"; $this->data["activeLink"] = "branches"; $this->load_view($this->data); } public function save(Request $request) { $request->validate([ 'branch_number' => 'required', 'branch_name' => 'required', 'branch_mobile' => 'required', 'branch_address' => 'required', 'branch_language' => 'required', ]); $uid = getUniqueId('BRCH', 'branches', 'uid'); $branch_logo = NULL; if($request->hasFile('branch_logo')) { $file = $request->file('branch_logo'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('BL'); $fileNamePrefix = db_unique_id('branches',$fileNamePrefix); $branch_logo = $fileNamePrefix.'.'.$extension; $file->move('uploads/branches/',$branch_logo); } $branch_banner_reports = NULL; if($request->hasFile('branch_banner_reports')) { $file = $request->file('branch_banner_reports'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('BBFR'); $fileNamePrefix = db_unique_id('branches',$fileNamePrefix); $branch_banner_reports = $fileNamePrefix.'.'.$extension; $file->move('uploads/branches/',$branch_banner_reports); } $branch_banner_invoices = NULL; if($request->hasFile('branch_banner_invoices')) { $file = $request->file('branch_banner_invoices'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('BBFI'); $fileNamePrefix = db_unique_id('branches',$fileNamePrefix); $branch_banner_invoices = $fileNamePrefix.'.'.$extension; $file->move('uploads/branches/',$branch_banner_invoices); } $branch_banner_return = NULL; if($request->hasFile('branch_banner_return')) { $file = $request->file('branch_banner_return'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('BBFIR'); $fileNamePrefix = db_unique_id('branches',$fileNamePrefix); $branch_banner_return = $fileNamePrefix.'.'.$extension; $file->move('uploads/branches/',$branch_banner_return); } $branch_banner_bookings = NULL; if($request->hasFile('branch_banner_bookings')) { $file = $request->file('branch_banner_bookings'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('BBFB'); $fileNamePrefix = db_unique_id('branches',$fileNamePrefix); $branch_banner_bookings = $fileNamePrefix.'.'.$extension; $file->move('uploads/branches/',$branch_banner_bookings); } $db_array = array( 'uid' => $uid, 'branch_number' => $request->branch_number, 'branch_name' => $request->branch_name, 'branch_mobile' => $request->branch_mobile, 'branch_address' => $request->branch_address, 'branch_logo' => $branch_logo, 'branch_banner_reports' => $branch_banner_reports, 'branch_banner_invoices' => $branch_banner_invoices, 'branch_banner_return' => $branch_banner_return, 'branch_banner_bookings' => $branch_banner_bookings, 'branch_language' => $request->branch_language, ); insert_table('branches',$db_array); $db_array = array( 'uid' => 'SAFEACCOUNT'.$uid, 'branch' => $uid, 'name' => 'Cash', 'type' => 'cashbook', 'code' => '111', 'memo' => 'Branch Safe Account', 'opening_balance' => json_encode(array()), ); insert_table('accounts',$db_array); $db_array = array( 'uid' => 'CASHSALE'.$uid, 'branch' => $uid, 'name' => 'Cash Sale', 'type' => 'client', 'code' => get_new_account_code(), 'memo' => 'Branch Cash Sale Account', 'opening_balance' => json_encode(array()), ); insert_table('accounts',$db_array); echo json_encode(array('status' => 'success', 'mood' => 'new', 'in_setup' => 'no', 'redirect_url' => NULL, 'message_head' => print_lang($this->data["app_lang"],'branch_created'), 'message_body' => print_lang($this->data["app_lang"],'new_branch_created_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_branch') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('branches','uid',$uid,true); $this->data["languages"] = fetch_table('language'); $this->data["title"] = print_lang($this->data["app_lang"],'edit_branch'); $this->data["pageToLoad"] = "branches/edit.php"; $this->data["activeLink"] = "branches"; $this->load_view($this->data); } public function update(Request $request, $uid) { $request->validate([ 'branch_number' => 'required', 'branch_name' => 'required', 'branch_mobile' => 'required', 'branch_address' => 'required', 'branch_language' => 'required', ]); $db_array = array( 'branch_number' => $request->branch_number, 'branch_name' => $request->branch_name, 'branch_mobile' => $request->branch_mobile, 'branch_address' => $request->branch_address, 'branch_language' => $request->branch_language, ); $branch_data = fetch_table_where('branches','uid',$uid,TRUE); if($request->hasFile('branch_logo')) { $file = $request->file('branch_logo'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('BL'); $fileNamePrefix = db_unique_id('branches',$fileNamePrefix); $branch_logo = $fileNamePrefix.'.'.$extension; $file->move('uploads/branches/',$branch_logo); $db_array['branch_logo'] = $branch_logo; File::delete('uploads/branches/'.$branch_data["branch_logo"]); } if($request->hasFile('branch_banner_reports')) { $file = $request->file('branch_banner_reports'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('BBFR'); $fileNamePrefix = db_unique_id('branches',$fileNamePrefix); $branch_banner_reports = $fileNamePrefix.'.'.$extension; $file->move('uploads/branches/',$branch_banner_reports); $db_array['branch_banner_reports'] = $branch_banner_reports; File::delete('uploads/branches/'.$branch_data["branch_banner_reports"]); } if($request->hasFile('branch_banner_invoices')) { $file = $request->file('branch_banner_invoices'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('BBFI'); $fileNamePrefix = db_unique_id('branches',$fileNamePrefix); $branch_banner_invoices = $fileNamePrefix.'.'.$extension; $file->move('uploads/branches/',$branch_banner_invoices); $db_array['branch_banner_invoices'] = $branch_banner_invoices; File::delete('uploads/branches/'.$branch_data["branch_banner_invoices"]); } if($request->hasFile('branch_banner_return')) { $file = $request->file('branch_banner_return'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('BBFIR'); $fileNamePrefix = db_unique_id('branches',$fileNamePrefix); $branch_banner_return = $fileNamePrefix.'.'.$extension; $file->move('uploads/branches/',$branch_banner_return); $db_array['branch_banner_return'] = $branch_banner_return; File::delete('uploads/branches/'.$branch_data["branch_banner_return"]); } if($request->hasFile('branch_banner_bookings')) { $file = $request->file('branch_banner_bookings'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('BBFB'); $fileNamePrefix = db_unique_id('branches',$fileNamePrefix); $branch_banner_bookings = $fileNamePrefix.'.'.$extension; $file->move('uploads/branches/',$branch_banner_bookings); $db_array['branch_banner_bookings'] = $branch_banner_bookings; File::delete('uploads/branches/'.$branch_data["branch_banner_bookings"]); } update_table('branches','uid',$uid,$db_array); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'branch_updated'), 'message_body' => print_lang($this->data["app_lang"],'branch_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_branch') === FALSE){ Redirect::to('/')->send(); } $branch_data = fetch_table_where('branches','uid',$uid,TRUE); File::delete('uploads/branches/'.$branch_data["branch_logo"]); File::delete('uploads/branches/'.$branch_data["branch_banner_reports"]); File::delete('uploads/branches/'.$branch_data["branch_banner_invoices"]); File::delete('uploads/branches/'.$branch_data["branch_banner_return"]); File::delete('uploads/branches/'.$branch_data["branch_banner_bookings"]); delete_table('branches','uid',$uid); delete_table('accounts','uid','SAFEACCOUNT'.$uid); delete_table('accounts','uid','CASHSALE'.$uid); delete_table('accounts_ledger','branch',$uid); delete_table('sales','branch',$uid); delete_table('purchases','branch',$uid); delete_table('production','branch',$uid); delete_table('expenses','branch',$uid); delete_table('extra_income','branch',$uid); delete_table('debit_credit_note','branch',$uid); delete_table('debit_credit_vouchers','branch',$uid); delete_table('transfer_in','branch',$uid); delete_table('transfer_out','branch',$uid); delete_table('items','branch',$uid); delete_table('warehouse','branch',$uid); delete_table('items_bundle_toop_stock','branch',$uid); delete_table('item_inventory','branch',$uid); delete_table('journal','branch',$uid); delete_table('leaves','branch',$uid); delete_table('marketers','branch',$uid); delete_table('money_receipts','branch',$uid); delete_table('accounts','branch',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }