<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; class Buy_cars extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_shor_buy_cars') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $custom_expenses = DB::table('buy_cars')->where('branch',$branch_id); if(!empty($request->currency)){ $custom_expenses->where('currency',$request->currency); } if(!empty($request->from)){ $custom_expenses->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $custom_expenses->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($custom_expenses->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'buy_cars'); $this->data["pageToLoad"] = "buy_cars/view.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function invoice(Request $request,$uid) { if(check_user_access('add_purchase') === FALSE){ Redirect::to('/')->send(); } $this->data["invoice_data"] = fetch_table_where('car_purchases','uid',$uid,true); $this->data["invoice_details"] = fetch_table_where('car_purchases_details','purchase_id',$this->data["invoice_data"]['uid']); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'car_purchase_invoice'); $this->data["pageToLoad"] = "car_purchases/invoice.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_shor_buy_cars') === FALSE){ Redirect::to('/')->send(); } $this->data["accounts"] = fetch_nested_accounts(); $this->data["currencies"] = set_array_keys(fetch_currencies(),"uid"); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'new_buy_car'); $this->data["pageToLoad"] = "buy_cars/add.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'car_type' => 'required', 'currency' => 'required', 'car_name' => 'required', 'shasi_num' => 'required|unique:buy_cars', ]); $validator->validate(); $expense_collection = array(); $expense_collection_currencies = array(); $expense_collection_agents = array(); if(!empty($request->expense_date_snip)) { foreach($request->expense_date_snip as $key => $expenses) { $expenses_array = array( 'expense_date' => $request->expense_date_snip[$key], 'expense_currency' => $request->expense_currency_snip[$key], 'expense_currency_eq' => $request->expense_currency_eq_snip[$key], 'expense_amount' => $request->expense_amount_snip[$key], 'expense_agent' => $request->expense_agent_snip[$key], 'expense_details' => $request->expense_details_snip[$key], ); $expense_collection[] = $expenses_array; $expense_collection_currencies[] = '-++-'.$request->expense_currency_snip[$key].'-++-'; $expense_collection_agents[] = '-++-'.$request->expense_agent_snip[$key].'-++-'; } } $real_cost = (float)$request->car_cost + (float)$request->expense_totals; $pending = $real_cost - $request->payment; $uid = getUniqueId('BCAR', 'buy_cars', 'uid'); $curency_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'currency' => $request->currency, 'currency_usd_equalance' => (float)$curency_data['usd_equalance'], 'car_type' => $request->car_type, 'car_name' => $request->car_name, 'shasi_num' => $request->shasi_num, 'car_model' => $request->car_model, 'car_color' => $request->car_color, 'car_makes' => $request->car_makes, 'car_cost' => (float)$request->car_cost, 'real_cost' => (float)$real_cost, 'pending' => (float)$pending, 'total_convert_expense' => (float)$request->expense_totals, 'expenses' => json_encode($expense_collection), 'currencies_uids' => implode(',', $expense_collection_currencies), 'agents_uid' => implode(',', $expense_collection_agents), 'seller_name' => $request->seller_name, 'seller_tazkira' => $request->seller_tazkira, 'seller_address' => $request->seller_address, 'seller_mobile' => $request->seller_mobile, 'payment' => (float)$request->payment, 'payment_account' => $request->payment_account, ); if($request->hasFile('seller_image')) { $file = $request->file('seller_image'); $extension = $file->getClientOriginalExtension(); $file_name = 'BCSIMG'.generate_uid().'.'.$extension; $file->move('uploads/buy_cars/',$file_name); $db_array['seller_image'] = $file_name; } $car_images = array(); if($request->hasFile('car_images')) { $files = $request->file('car_images'); foreach($files as $file) { $extension = $file->getClientOriginalExtension(); $file_name = 'BCCIMG'.generate_uid().'.'.$extension; $file->move('uploads/buy_cars/',$file_name); $car_images[] = $file_name; } $db_array['car_images'] = implode(',',$car_images); } insert_table('buy_cars',$db_array); _handle_buy_cars_ledger_effects(['uid' => $uid, 'state' => 'new']); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'buy_car_saved'), 'message_body' => print_lang($this->data["app_lang"],'buy_car_saved_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_shor_buy_cars') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('buy_cars','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/buy-cars')->send(); } $this->data["accounts"] = fetch_nested_accounts(); $this->data["currencies"] = set_array_keys(fetch_currencies(),"uid"); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'edit_buy_car'); $this->data["pageToLoad"] = "buy_cars/edit.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'car_type' => 'required', 'currency' => 'required', 'car_name' => 'required', 'shasi_num' => ['required',Rule::unique('buy_cars')->ignore($uid, 'uid')], ]); $validator->validate(); $curency_data = fetch_table_where('currency','uid',$request->currency,true); $expense_collection = array(); $expense_collection_currencies = array(); $expense_collection_agents = array(); if(!empty($request->expense_date_snip)) { foreach($request->expense_date_snip as $key => $expenses) { $expenses_array = array( 'expense_date' => $request->expense_date_snip[$key], 'expense_currency' => $request->expense_currency_snip[$key], 'expense_currency_eq' => $request->expense_currency_eq_snip[$key], 'expense_amount' => $request->expense_amount_snip[$key], 'expense_agent' => $request->expense_agent_snip[$key], 'expense_details' => $request->expense_details_snip[$key], ); $expense_collection[] = $expenses_array; $expense_collection_currencies[] = '-++-'.$request->expense_currency_snip[$key].'-++-'; $expense_collection_agents[] = '-++-'.$request->expense_agent_snip[$key].'-++-'; } } $real_cost = (float)$request->car_cost + (float)$request->expense_totals; $pending = $real_cost - $request->payment; $db_array = array( 'currency' => $request->currency, 'currency_usd_equalance' => (float)$curency_data['usd_equalance'], 'car_type' => $request->car_type, 'car_name' => $request->car_name, 'shasi_num' => $request->shasi_num, 'car_model' => $request->car_model, 'car_color' => $request->car_color, 'car_makes' => $request->car_makes, 'car_cost' => (float)$request->car_cost, 'real_cost' => (float)$real_cost, 'pending' => (float)$pending, 'total_convert_expense' => (float)$request->expense_totals, 'expenses' => json_encode($expense_collection), 'currencies_uids' => implode(',', $expense_collection_currencies), 'agents_uid' => implode(',', $expense_collection_agents), 'seller_name' => $request->seller_name, 'seller_tazkira' => $request->seller_tazkira, 'seller_address' => $request->seller_address, 'seller_mobile' => $request->seller_mobile, 'payment' => (float)$request->payment, 'payment_account' => $request->payment_account, ); $car_buy_data = fetch_table_where('buy_cars','uid',$uid,true); if($request->hasFile('seller_image')) { $file = $request->file('seller_image'); $extension = $file->getClientOriginalExtension(); $file_name = 'BCSIMG'.generate_uid().'.'.$extension; $file->move('uploads/buy_cars/',$file_name); $db_array['seller_image'] = $file_name; File::delete('uploads/buy_cars/'.$car_buy_data['seller_image']); } $car_images = empty($car_buy_data['car_images']) ? array() : explode(',',$car_buy_data['car_images']); if($request->hasFile('car_images')) { $files = $request->file('car_images'); foreach($files as $file) { $extension = $file->getClientOriginalExtension(); $file_name = 'BCCIMG'.generate_uid().'.'.$extension; $file->move('uploads/buy_cars/',$file_name); $car_images[] = $file_name; } $db_array['car_images'] = implode(',',$car_images); } update_table('buy_cars','uid',$uid,$db_array); _handle_buy_cars_ledger_effects(['uid' => $uid, 'state' => 'update']); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'buy_car_updated'), 'message_body' => print_lang($this->data["app_lang"],'buy_car_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_shor_buy_cars') === FALSE){ Redirect::to('/')->send(); } $custom_expenses_data = fetch_table_where('buy_cars','uid',$uid,true); delete_table('buy_cars','uid',$uid); _handle_buy_cars_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function delete_images(Request $request, $uid) { $car_image = $request->image; $car_data = fetch_table_where('buy_cars','uid',$uid,true); if(isset($car_data['car_images'])) { $car_images = explode(',',$car_data['car_images']); $car_new_images = array(); foreach($car_images as $img) { if($car_image != $img){ $car_new_images[] = $img; } } $car_new_images = implode(',',$car_new_images); update_table('buy_cars','uid',$uid,array('car_images' => $car_new_images)); if(!empty($car_image)){ File::delete('uploads/buy_cars/'.$car_image); } echo json_encode(array('status' => 'success', 'uid' => $uid, 'images' => $car_new_images)); } } public function sale_view(Request $request) { if(check_user_access('buy_cars_sold_view') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $buy_car_sale = DB::table('buy_car_sale')->where('branch',$branch_id); if(!empty($request->currency)){ $buy_car_sale->where('currency',$request->currency); } if(!empty($request->client)){ $buy_car_sale->where('client',$request->client); } if(!empty($request->from)){ $buy_car_sale->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $buy_car_sale->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($buy_car_sale->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["car_details"] = set_array_keys(fetch_table_where_branch('buy_cars','sold','sold'),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'showroom_sales'); $this->data["pageToLoad"] = "buy_cars/sale_view.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function sale(Request $request, $uid) { if(check_user_access('sale_shor_buy_cars') === FALSE){ Redirect::to('/')->send(); } $this->data["car_details"] = fetch_table_where('buy_cars','uid',$uid,true); if(!is_array($this->data["car_details"])){ Redirect::to('/buy-cars')->send(); } if($this->data["car_details"]['sold'] == 'sold'){ Redirect::to('/buy-cars')->send(); } $this->data["accounts"] = fetch_nested_accounts(); $this->data["currencies"] = fetch_currencies(); $this->data["title"] = print_lang($this->data["app_lang"],'new_showroom_sale'); $this->data["pageToLoad"] = "buy_cars/sale.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function save_sale(Request $request) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'client' => 'required', 'invoice' => 'required|unique:buy_car_sale', 'sale_price' => 'required', ]); $validator->validate(); $uid = getUniqueId('BCSL', 'buy_car_sale', 'uid'); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'currency' => $request->currency, 'currency_usd_equalance' => (float)$currency_data['usd_equalance'], 'invoice' => $request->invoice, 'car' => $request->car_uid, 'real_cost' => (float)$request->real_cost, 'client' => $request->client, 'sale_price' => (float)$request->sale_price, 'profit' => (float)$request->profit, 'total' => (float)$request->total, 'discount' => (float)$request->discount, 'gross_total' => (float)$request->gross_total, 'cash_paid_account' => $request->cash_paid_account, 'cash_paid' => (float)$request->cash_paid, 'pending_amount' => (float)$request->pending_amount, 'name' => $request->name, 'father_name' => $request->father_name, 'tazkira' => $request->tazkira, 'mobile' => $request->mobile, 'address' => $request->address, ); if($request->hasFile('buyer_image')) { $file = $request->file('buyer_image'); $extension = $file->getClientOriginalExtension(); $file_name = 'BCSIMG'.generate_uid().'.'.$extension; $file->move('uploads/buy_car_sale/',$file_name); $db_array['buyer_image'] = $file_name; } if($request->hasFile('document')) { $file = $request->file('document'); $extension = $file->getClientOriginalExtension(); $file_name = 'BCSIMG'.generate_uid().'.'.$extension; $file->move('uploads/buy_car_sale/',$file_name); $db_array['document'] = $file_name; } insert_table('buy_car_sale',$db_array); _handle_buy_cars_sales_ledger_effects(['uid' => $uid, 'state' => 'new']); update_table('buy_cars','uid',$db_array['car'],array('sold' => 'sold')); $redirect_url = url('/buy-cars'); $_activity_details = array( 'module' => 'buy_cars', 'activity' => 'added', 'url' => '/buy-cars/edit/'.$db_array['uid'], 'details' => 'Invoice #'.$db_array['invoice'].', Amount: '.amount_number_format($db_array['gross_total']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'new', 'redirect_url' => $redirect_url, 'message_head' => print_lang($this->data["app_lang"],'showroom_sales_saved'), 'message_body' => print_lang($this->data["app_lang"],'showroom_sales_saved_successfully'))); } public function sale_edit(Request $request, $uid) { if(check_user_access('sale_edit_shor_buy_cars') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('buy_car_sale','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/buy-cars')->send(); } $this->data["car_details"] = fetch_table_where('buy_cars','uid',$this->data["editing_data"]['car'],true); $this->data["accounts"] = fetch_nested_accounts(); $this->data["currencies"] = fetch_currencies(); $this->data["title"] = print_lang($this->data["app_lang"],'edit_showroom_sale'); $this->data["pageToLoad"] = "buy_cars/sale_edit.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function sale_update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'client' => 'required', 'sale_price' => 'required', ]); $validator->validate(); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'currency' => $request->currency, 'currency_usd_equalance' => (float)$currency_data['usd_equalance'], 'invoice' => $request->invoice, 'car' => $request->car_uid, 'real_cost' => (float)$request->real_cost, 'client' => $request->client, 'sale_price' => (float)$request->sale_price, 'profit' => (float)$request->profit, 'total' => (float)$request->total, 'discount' => (float)$request->discount, 'gross_total' => (float)$request->gross_total, 'cash_paid_account' => $request->cash_paid_account, 'cash_paid' => (float)$request->cash_paid, 'pending_amount' => (float)$request->pending_amount, 'name' => $request->name, 'father_name' => $request->father_name, 'tazkira' => $request->tazkira, 'mobile' => $request->mobile, 'address' => $request->address, ); $car_buy_data = fetch_table_where('buy_car_sale','uid',$uid,true); if($request->hasFile('buyer_image')) { $file = $request->file('buyer_image'); $extension = $file->getClientOriginalExtension(); $file_name = 'BCSIMG'.generate_uid().'.'.$extension; $file->move('uploads/buy_car_sale/',$file_name); $db_array['buyer_image'] = $file_name; File::delete('uploads/buy_car_sale/'.$car_buy_data['buyer_image']); } if($request->hasFile('document')) { $file = $request->file('document'); $extension = $file->getClientOriginalExtension(); $file_name = 'BCSIMG'.generate_uid().'.'.$extension; $file->move('uploads/buy_car_sale/',$file_name); $db_array['document'] = $file_name; File::delete('uploads/buy_car_sale/'.$car_buy_data['document']); } update_table('buy_car_sale','uid',$uid,$db_array); _handle_buy_cars_sales_ledger_effects(['uid' => $uid, 'state' => 'update']); $_activity_details = array( 'module' => 'buy_cars', 'activity' => 'updated', 'url' => '/buy-cars/edit/'.$uid, 'details' => 'Invoice # '.$db_array['invoice'].', Amount: '.amount_number_format($db_array['gross_total']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'showroom_sales_updated'), 'message_body' => print_lang($this->data["app_lang"],'showroom_sales_updated_successfully'))); } public function sale_delete($uid) { if(check_user_access('sale_delete_shor_buy_cars') === FALSE){ Redirect::to('/')->send(); } $showroom_sale_data = fetch_table_where('buy_car_sale','uid',$uid,TRUE); $_activity_details = array( 'module' => 'showroom_sales', 'activity' => 'deleted', 'url' => NULL, 'details' => 'Invoice # '.$showroom_sale_data['invoice'].', Amount: '.amount_number_format($showroom_sale_data['gross_total']), ); set_activity_alert($_activity_details); delete_table('buy_car_sale','uid',$uid); update_table('buy_cars','uid',$showroom_sale_data['car'],array('sold' => '')); _handle_buy_cars_sales_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }