<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; class Car_purchases extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_shor_car_purchases') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $purchases = DB::table('car_purchases')->where('branch',$branch_id); if(!empty($request->currency)){ $purchases->where('currency',$request->currency); } if(!empty($request->agent)){ $purchases->where('agent',$request->agent); } if(!empty($request->from)){ $purchases->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $purchases->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $purchases = $purchases->get(); $purchases = json_decode(json_encode($purchases),true); $this->data["pageData"] = $purchases; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_agent"] = $request->agent; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'car_purchases'); $this->data["pageToLoad"] = "car_purchases/view.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function invoice(Request $request,$uid) { if(check_user_access('invoice_shor_car_purchases') === FALSE){ Redirect::to('/')->send(); } $this->data["invoice_data"] = fetch_table_where('car_purchases','uid',$uid,true); $this->data["invoice_details"] = fetch_table_where('car_purchases_details','purchase_id',$this->data["invoice_data"]['uid']); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'car_purchase_invoice'); $this->data["pageToLoad"] = "car_purchases/invoice.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_shor_car_purchases') === FALSE){ Redirect::to('/')->send(); } $this->data["invoice_num"] = get_car_purchase_invoice(); $this->data["currencies"] = fetch_currencies(); $this->data["suppliers"] = fetch_table_where_branch('accounts','type','supplier'); $this->data["title"] = print_lang($this->data["app_lang"],'add_car_purchase'); $this->data["pageToLoad"] = "car_purchases/add.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function save(Request $request) { $items_found = false; $active_branch_id = active_branch_id(); $invoice_num = isset($request->invoice[0]) ? $request->invoice[0] : generate_uid(); $invoice_num_exist = DB::table('car_purchases')->where('invoice',$invoice_num)->get(); if($invoice_num_exist->count() > 0) { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => 'Invoice Exist', 'message_body' => 'This invoice number already exist.')); die; } $cost = array(); $transfer_expenses = array(); $agent_commission = array(); $other_expenses = array(); $total_amount = array(); $currency = isset($request->currency[0]) ? $request->currency[0] : 'usd'; $currency_db_data = fetch_table_where('currency','uid',$currency,true); $uid = getUniqueId('CPUR', 'car_purchases', 'uid'); $items_count = 0; $cars_uids = array(); if(is_array($request->car_name) AND count($request->car_name) > 0) { while($items_count < count($request->car_name)) { if(empty($request->car_name[$items_count])){ continue; } $agent_commission_amount = (float)$request->agent_commission[$items_count]; $row_car_uid = getUniqueId('CPDT', 'car_purchases_details', 'uid'); $car_db_array = array( 'uid' => $row_car_uid, 'branch' => $active_branch_id, 'purchase_id' => $uid, 'currency' => $currency, 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'agent' => $request->agent[$items_count], 'invoice' => $invoice_num, 'car_name' => $request->car_name[$items_count], 'car_model' => $request->car_model[$items_count], 'shasi_num' => $request->shasi_num[$items_count], 'car_color' => $request->car_color[$items_count], 'car_make' => $request->car_make[$items_count], 'cost' => (float)$request->cost[$items_count], 'transfer_expenses' => (float)$request->transfer_expenses[$items_count], 'agent_commission' => (float)$request->agent_commission[$items_count], 'agent_commission_amount' => $agent_commission_amount, 'other_expenses' => (float)$request->other_expenses[$items_count], 'total_amount' => (float)$request->total_amount[$items_count], 'expense_details' => $request->expense_details[$items_count], ); insert_table('car_purchases_details',$car_db_array); $cars_uids[] = $row_car_uid; $items_found = true; $cost[] = (float)$request->cost[$items_count]; $transfer_expenses[] = (float)$request->transfer_expenses[$items_count]; $agent_commission[] = $agent_commission_amount; $other_expenses[] = (float)$request->other_expenses[$items_count]; $total_amount[] = (float)$request->total_amount[$items_count]; $items_count++; } } if($items_found == true) { $db_array = array( 'uid' => $uid, 'branch' => $active_branch_id, 'currency' => $currency, 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'agent' => $request->agent[0], 'invoice' => $invoice_num, 'cost' => array_sum($cost), 'transfer_expenses' => array_sum($transfer_expenses), 'agent_commission' => array_sum($agent_commission), 'other_expenses' => array_sum($other_expenses), 'total_amount' => array_sum($total_amount), 'cars' => implode('-,-', $cars_uids), ); insert_table('car_purchases',$db_array); _handle_showroom_purchases_ledger_effects(['uid' => $uid, 'state' => 'new']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_car_purchases'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/car-purchases/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['total_amount']), ); set_activity_alert($_activity_details); $invoice_url = url('/car-purchases/invoice').'/'.$uid; $invoice_num = get_car_purchase_invoice(); echo json_encode(array('status' => 'success', 'mood' => 'new', 'invoice_num' => $invoice_num, 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'purchase_added'), 'message_body' => print_lang($this->data["app_lang"],'new_purchase_added_successfully'))); } else { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'item_not_found'), 'message_body' => print_lang($this->data["app_lang"],'add_items_to_proceed'))); } } public function edit(Request $request, $uid) { if(check_user_access('edit_shor_car_purchases') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('car_purchases','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/car-purchases')->send(); } $this->data["purchase_items"] = fetch_table_where('car_purchases_details','purchase_id',$this->data["editing_data"]['uid']); $this->data["currencies"] = fetch_currencies(); $this->data["suppliers"] = fetch_table_where_branch('accounts','type','supplier'); $this->data["title"] = print_lang($this->data["app_lang"],'edit_car_purchase'); $this->data["pageToLoad"] = "car_purchases/edit.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function update(Request $request, $uid) { $items_found = false; $active_branch_id = active_branch_id(); $invoice_num = isset($request->invoice[0]) ? $request->invoice[0] : generate_uid(); $invoice_num_exist = DB::table('car_purchases')->where('branch',$active_branch_id)->where('uid','!=',$uid)->where('invoice',$invoice_num)->get(); if($invoice_num_exist->count() > 0) { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => 'Invoice Exist', 'message_body' => 'This invoice number already exist.')); die; } $cost = array(); $transfer_expenses = array(); $agent_commission = array(); $other_expenses = array(); $total_amount = array(); $currency = isset($request->currency[0]) ? $request->currency[0] : 'usd'; $currency_db_data = fetch_table_where('currency','uid',$currency,true); if(is_array($request->deleted) AND count($request->deleted) > 0) { foreach($request->deleted as $item_id) { delete_table('car_purchases_details','uid',$item_id); } } $items_count = 0; $cars_uids = array(); if(is_array($request->car_name) AND count($request->car_name) > 0) { while($items_count < count($request->car_name)) { if(empty($request->car_name[$items_count])){ continue; } $agent_commission_amount = (float)$request->agent_commission[$items_count]; $car_db_array = array( 'currency' => $currency, 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'agent' => $request->agent[$items_count], 'invoice' => $invoice_num, 'car_name' => $request->car_name[$items_count], 'car_model' => $request->car_model[$items_count], 'shasi_num' => $request->shasi_num[$items_count], 'car_color' => $request->car_color[$items_count], 'car_make' => $request->car_make[$items_count], 'cost' => (float)$request->cost[$items_count], 'transfer_expenses' => (float)$request->transfer_expenses[$items_count], 'agent_commission' => (float)$request->agent_commission[$items_count], 'agent_commission_amount' => $agent_commission_amount, 'other_expenses' => (float)$request->other_expenses[$items_count], 'total_amount' => (float)$request->total_amount[$items_count], 'expense_details' => $request->expense_details[$items_count], ); if($request->mode[$items_count] == 'existing') { $row_car_uid = $request->uid[$items_count]; update_table('car_purchases_details','uid',$request->uid[$items_count],$car_db_array); } else { $row_car_uid = getUniqueId('CPDT', 'car_purchases_details', 'uid'); $car_db_array['uid'] = $row_car_uid; $car_db_array['branch'] = $active_branch_id; $car_db_array['purchase_id'] = $uid; insert_table('car_purchases_details',$car_db_array); } $cars_uids[] = $row_car_uid; $items_found = true; $cost[] = (float)$request->cost[$items_count]; $transfer_expenses[] = (float)$request->transfer_expenses[$items_count]; $agent_commission[] = $agent_commission_amount; $other_expenses[] = (float)$request->other_expenses[$items_count]; $total_amount[] = (float)$request->total_amount[$items_count]; $items_count++; } } if($items_found == true) { $db_array = array( 'currency' => $currency, 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'agent' => $request->agent[0], 'invoice' => $invoice_num, 'cost' => array_sum($cost), 'transfer_expenses' => array_sum($transfer_expenses), 'agent_commission' => array_sum($agent_commission), 'other_expenses' => array_sum($other_expenses), 'total_amount' => array_sum($total_amount), 'cars' => implode('-,-', $cars_uids), ); update_table('car_purchases','uid',$uid,$db_array); _handle_showroom_purchases_ledger_effects(['uid' => $uid, 'state' => 'update']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_car_purchases'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/car-purchases/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['total_amount']), ); set_activity_alert($_activity_details); $invoice_url = url('/car-purchases/invoice').'/'.$uid; echo json_encode(array('status' => 'success', 'mood' => 'update', 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'purchase_updated'), 'message_body' => print_lang($this->data["app_lang"],'purchase_updated_successfully'))); } else { echo json_encode(array('status' => 'error', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'item_not_found'), 'message_body' => print_lang($this->data["app_lang"],'add_items_to_proceed'))); } } public function delete($uid) { if(check_user_access('delete_shor_car_purchases') === FALSE){ Redirect::to('/')->send(); } $purchase_data = fetch_table_where('car_purchases','uid',$uid,true); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_car_purchases'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$purchase_data['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($purchase_data['total_amount']), ); set_activity_alert($_activity_details); delete_table('car_purchases','uid',$uid); delete_table('car_purchases_details','purchase_id',$uid); _handle_showroom_purchases_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }