<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Ccontracts extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_project_contracts') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $ccontracts = DB::table('ccontracts')->where('branch',$branch_id); if(!empty($request->type)){ $ccontracts->where('contract_type',$request->type); } if(!empty($request->from)){ $ccontracts->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $ccontracts->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($ccontracts->get()),true); $this->data["search_type"] = $request->type; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'construction_contracts'); $this->data["pageToLoad"] = "ccontracts/view.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_project_contracts') === FALSE){ Redirect::to('/')->send(); } $this->data["accounts"] = fetch_nested_accounts(); $this->data["currencies"] = fetch_currencies(); $this->data["title"] = print_lang($this->data["app_lang"],'new_construction_contract'); $this->data["pageToLoad"] = "ccontracts/add.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'contract_type' => 'required', ]); $validator->validate(); $uid = getUniqueId('CCNT', 'ccontracts', 'uid'); $currency = ($request->contract_type == 'machinery') ? $request->machinery_currency : $request->currency; $currency_data = fetch_table_where('currency','uid',$currency,true); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'contract_type' => $request->contract_type, 'currency' => $currency, 'currency_usd_equalance' => (float)$currency_data['usd_equalance'], 'duration_type' => $request->duration_type, 'employee' => $request->employee, 'number_of_duration' => (float)$request->number_of_duration, 'amount' => (float)$request->amount, 'working_hours_per_day' => (float)$request->working_hours_per_day, 'supplier' => $request->supplier, 'machinery_name' => $request->machinery_name, 'machinery_rate' => (float)$request->machinery_rate, 'machinery_working_hours' => (float)$request->machinery_working_hours, 'machinery_driver_name' => $request->machinery_driver_name, 'machinery_driver_mobile' => $request->machinery_driver_mobile, 'machinery_details' => $request->machinery_details, 'user' => Session::get('user_id'), ); if($request->contract_type == 'machinery') { if($request->hasFile('image')) { $file = $request->file('image'); $extension = $file->getClientOriginalExtension(); $file_name = 'CMIMG'.generate_uid().'.'.$extension; $file->move('uploads/ccontracts/',$file_name); $db_array['image'] = $file_name; } } insert_table('ccontracts',$db_array); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_contracts'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/ccontracts/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_contract_created').', '.print_lang($this->data["app_lang"],'dashboard_activities_text_contract_type').': '.$db_array['contract_type'], ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'construction_contract_saved'), 'message_body' => print_lang($this->data["app_lang"],'construction_contract_saved_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_project_contracts') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('ccontracts','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/ccontracts')->send(); } $this->data["accounts"] = fetch_nested_accounts(); $this->data["currencies"] = fetch_currencies(); $this->data["title"] = print_lang($this->data["app_lang"],'edit_construction_contract'); $this->data["pageToLoad"] = "ccontracts/edit.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'contract_type' => 'required', ]); $validator->validate(); $currency = ($request->contract_type == 'machinery') ? $request->machinery_currency : $request->currency; $currency_data = fetch_table_where('currency','uid',$currency,true); $db_array = array( 'contract_type' => $request->contract_type, 'currency' => $currency, 'currency_usd_equalance' => (float)$currency_data['usd_equalance'], 'duration_type' => $request->duration_type, 'employee' => $request->employee, 'number_of_duration' => (float)$request->number_of_duration, 'amount' => (float)$request->amount, 'working_hours_per_day' => (float)$request->working_hours_per_day, 'supplier' => $request->supplier, 'machinery_name' => $request->machinery_name, 'machinery_rate' => (float)$request->machinery_rate, 'machinery_working_hours' => (float)$request->machinery_working_hours, 'machinery_driver_name' => $request->machinery_driver_name, 'machinery_driver_mobile' => $request->machinery_driver_mobile, 'machinery_details' => $request->machinery_details, ); if($request->contract_type == 'machinery') { if($request->hasFile('image')) { $file = $request->file('image'); $extension = $file->getClientOriginalExtension(); $file_name = 'CMIMG'.generate_uid().'.'.$extension; $file->move('uploads/ccontracts/',$file_name); $db_array['image'] = $file_name; $ccontract_data = fetch_table_where('ccontracts','uid',$uid,TRUE); if(!empty($ccontract_data['image'])) { File::delete('uploads/ccontracts/'.$ccontract_data["image"]); } } } update_table('ccontracts','uid',$uid,$db_array); _handle_contract_dependent_ledger_effects(['uid' => $uid]); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_contracts'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/ccontracts/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_contract_created').', '.print_lang($this->data["app_lang"],'dashboard_activities_text_contract_type').': '.$db_array['contract_type'], ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'construction_contract_updated'), 'message_body' => print_lang($this->data["app_lang"],'construction_contract_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_project_contracts') === FALSE){ Redirect::to('/')->send(); } $delete_data = fetch_table_where('ccontracts','uid',$uid,TRUE); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_contracts'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_contract_created').', '.print_lang($this->data["app_lang"],'dashboard_activities_text_contract_type').': '.$delete_data['contract_type'], ); set_activity_alert($_activity_details); delete_table('ccontracts','uid',$uid); $project_contract_assign = std_obj_to_array(DB::table('projects_assign')->where('employee',$sources['uid'])->orWhere('machinery',$sources['uid'])->get()); foreach($project_contract_assign as $row) { _handle_project_contract_assigned_ledger_effects(['uid' => $row['uid'], 'state' => 'delete']); } delete_table('projects_assign','employee',$uid); delete_table('projects_assign','machinery',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }