<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Citems extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_project_items') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $citems = DB::table('citems')->where('branch',$branch_id); if(!empty($request->name)){ $citems->where('name','like','%'.$request->name.'%'); } if(!empty($request->from)){ $citems->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $citems->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($citems->get()),true); $this->data["search_name"] = $request->name; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'construction_items'); $this->data["pageToLoad"] = "citems/view.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_project_items') === FALSE){ Redirect::to('/')->send(); } $this->data["title"] = print_lang($this->data["app_lang"],'new_construction_item'); $this->data["pageToLoad"] = "citems/add.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'unit' => 'required', ]); $validator->validate(); $uid = getUniqueId('CITM', 'citems', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'name' => $request->name, 'unit' => $request->unit, 'user' => Session::get('user_id'), ); insert_table('citems',$db_array); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_citems'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/citems/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_name').' '.$db_array['name'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_unit').': '.$db_array['unit'], ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'construction_item_saved'), 'message_body' => print_lang($this->data["app_lang"],'construction_item_saved_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_project_items') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('citems','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/citems')->send(); } $this->data["title"] = print_lang($this->data["app_lang"],'edit_construction_item'); $this->data["pageToLoad"] = "citems/edit.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'unit' => 'required', ]); $validator->validate(); $db_array = array( 'name' => $request->name, 'unit' => $request->unit, ); update_table('citems','uid',$uid,$db_array); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_citems'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/citems/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_name').' '.$db_array['name'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_unit').': '.$db_array['unit'], ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'construction_item_updated'), 'message_body' => print_lang($this->data["app_lang"],'construction_item_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_project_items') === FALSE){ Redirect::to('/')->send(); } $delete_data = fetch_table_where('citems','uid',$uid,TRUE); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_citems'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_name').' '.$delete_data['name'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_unit').': '.$delete_data['unit'], ); set_activity_alert($_activity_details); delete_table('citems','uid',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }