<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Cpurchases extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_project_purchases') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $cpurchases = DB::table('cpurchases')->where('branch',$branch_id); if(!empty($request->currency)){ $cpurchases->where('currency',$request->currency); } if(!empty($request->from)){ $cpurchases->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $cpurchases->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($cpurchases->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('citems'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'construction_purchases'); $this->data["pageToLoad"] = "cpurchases/view.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function invoice(Request $request,$uid) { if(check_user_access('invoice_project_purchases') === FALSE){ Redirect::to('/')->send(); } $this->data["invoice_data"] = fetch_table_where('cpurchases','uid',$uid,true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch("citems"),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'construction_purchases_invoice'); $this->data["pageToLoad"] = "cpurchases/invoice.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_project_purchases') === FALSE){ Redirect::to('/')->send(); } $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = fetch_table_branch('citems'); $this->data["warehouses"] = fetch_table_branch('cwarehouses'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'new_construction_purchase'); $this->data["pageToLoad"] = "cpurchases/add.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'item' => 'required', 'warehouse' => 'required', 'invoice' => 'required|unique:cpurchases', 'supplier' => 'required', 'rate' => 'required', 'qty' => 'required', ]); $validator->validate(); $uid = getUniqueId('CPCH', 'cpurchases', 'uid'); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'currency' => $request->currency, 'currency_usd_equalance' => (float)$currency_data['usd_equalance'], 'item' => $request->item, 'warehouse' => $request->warehouse, 'invoice' => $request->invoice, 'supplier' => $request->supplier, 'rate' => (float)$request->rate, 'qty' => (float)$request->qty, 'total' => (float)$request->total, 'cash_paid' => (float)$request->cash_paid, 'cash_paid_account' => $request->cash_paid_account, 'pending' => (float)$request->pending, 'user' => Session::get('user_id'), ); insert_table('cpurchases',$db_array); _handle_project_purchase_ledger_effects(['uid' => $uid, 'state' => 'new']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_cpurchases'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/cpurchases/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.$db_array['total'], ); set_activity_alert($_activity_details); $invoice_url = url('/cpurchases/invoice').'/'.$uid; echo json_encode(array('status' => 'success', 'mood' => 'new', 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'construction_purchase_saved'), 'message_body' => print_lang($this->data["app_lang"],'construction_purchase_saved_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_project_purchases') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('cpurchases','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/cpurchases')->send(); } $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = fetch_table_branch('citems'); $this->data["warehouses"] = fetch_table_branch('cwarehouses'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'edit_construction_purchase'); $this->data["pageToLoad"] = "cpurchases/edit.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'item' => 'required', 'warehouse' => 'required', 'invoice' => ['required',Rule::unique('cpurchases')->ignore($uid, 'uid')], 'supplier' => 'required', 'rate' => 'required', 'qty' => 'required', ]); $validator->validate(); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'currency' => $request->currency, 'currency_usd_equalance' => (float)$currency_data['usd_equalance'], 'item' => $request->item, 'warehouse' => $request->warehouse, 'invoice' => $request->invoice, 'supplier' => $request->supplier, 'rate' => (float)$request->rate, 'qty' => (float)$request->qty, 'total' => (float)$request->total, 'cash_paid' => (float)$request->cash_paid, 'cash_paid_account' => $request->cash_paid_account, 'pending' => (float)$request->pending, ); update_table('cpurchases','uid',$uid,$db_array); _handle_project_purchase_ledger_effects(['uid' => $uid, 'state' => 'update']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_cpurchases'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/cpurchases/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.$db_array['total'], ); set_activity_alert($_activity_details); $invoice_url = url('/cpurchases/invoice').'/'.$uid; echo json_encode(array('status' => 'success', 'mood' => 'update', 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'construction_purchase_updated'), 'message_body' => print_lang($this->data["app_lang"],'construction_purchase_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_project_purchases') === FALSE){ Redirect::to('/')->send(); } $delete_data = fetch_table_where('cpurchases','uid',$uid,TRUE); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_cpurchases'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$delete_data['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.$delete_data['total'], ); set_activity_alert($_activity_details); delete_table('cpurchases','uid',$uid); _handle_project_purchase_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }