<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Currency extends Setup { public function __construct() { parent::__construct(); } public function invoices_counters(Request $request) { if(check_user_access('view_invoice_counter') === FALSE){ Redirect::to('/')->send(); } $active_branch_id = active_branch_id(); $this->data["counters"] = fetch_table_where('branches','uid',$active_branch_id,true); $this->data["title"] = print_lang($this->data["app_lang"],'invoices_counters'); $this->data["pageToLoad"] = "currency/invoices_counters.php"; $this->data["activeLink"] = "settings"; $this->load_view($this->data); } public function update_invoices_counters(Request $request) { $production_invoice_counter = (float)$request->production_invoice_counter; if($production_invoice_counter <= 0){ $production_invoice_counter = 1; } $sales_invoice_counter = (float)$request->sales_invoice_counter; if($sales_invoice_counter <= 0){ $sales_invoice_counter = 1; } $active_branch_id = active_branch_id(); $db_array = array('production_invoice_counter' => $production_invoice_counter,'sales_invoice_counter' => $sales_invoice_counter); update_table('branches','uid',$active_branch_id,$db_array); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'counters_updated'), 'message_body' => print_lang($this->data["app_lang"],'counters_updated_successfully'))); } public function currency_rates(Request $request) { if(check_user_access('view_currency_rates') === FALSE){ Redirect::to('/')->send(); } $this->data["currencies"] = fetch_currencies(); $this->data["title"] = print_lang($this->data["app_lang"],'currency_rates'); $this->data["pageToLoad"] = "currency/currency_rates.php"; $this->data["activeLink"] = "settings"; $this->load_view($this->data); } public function update_currency_rates(Request $request) { $currencies = fetch_currencies(); foreach($currencies as $row) { if($row['uid'] == 'usd'){ continue; } $currency_uid = $row['uid']; $currency_usd_equalance = $request->$currency_uid; $currency_usd_equalance = (float)$currency_usd_equalance; if($currency_usd_equalance <= 0){ $currency_usd_equalance = 1; } $db_array = array('usd_equalance' => $currency_usd_equalance); update_table('currency','uid',$row['uid'],$db_array); update_table('items','currency',$row['uid'],['currency_usd_equalance' => $currency_usd_equalance]); update_table('projects','currency',$row['uid'],['currency_usd_equalance' => $currency_usd_equalance]); } echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'rates_update'), 'message_body' => print_lang($this->data["app_lang"],'currency_rates_update_successfully'))); } public function view(Request $request) { if(check_user_access('view_currency') === FALSE){ Redirect::to('/')->send(); } $this->data["pageData"] = fetch_currencies(); $this->data["title"] = print_lang($this->data["app_lang"],'currency'); $this->data["pageToLoad"] = "currency/view.php"; $this->data["activeLink"] = "settings"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_currency') === FALSE){ Redirect::to('/')->send(); } $this->data["title"] = print_lang($this->data["app_lang"],'add_currency'); $this->data["pageToLoad"] = "currency/add.php"; $this->data["activeLink"] = "settings"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'symbol' => 'required', 'usd_equalance' => 'required', 'branch_equalance' => 'required', ]); $validator->validate(); $uid = getUniqueId('CURR', 'currency', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'name' => $request->name, 'symbol' => $request->symbol, 'usd_equalance' => $request->usd_equalance, 'branch_equalance' => $request->branch_equalance, ); insert_table('currency',$db_array); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'currency_created'), 'message_body' => print_lang($this->data["app_lang"],'new_currency_created_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_currency') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('currency','uid',$uid,true); $this->data["title"] = print_lang($this->data["app_lang"],'edit_currency'); $this->data["pageToLoad"] = "currency/edit.php"; $this->data["activeLink"] = "settings"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'symbol' => 'required', 'usd_equalance' => 'required', 'branch_equalance' => 'required', ]); $validator->validate(); $db_array = array( 'name' => $request->name, 'symbol' => $request->symbol, 'usd_equalance' => $request->usd_equalance, 'branch_equalance' => $request->branch_equalance, ); update_table('currency','uid',$uid,$db_array); update_table('capitals','currency',$uid,['currency_name' => $request->name, 'currency_symbol' => $request->symbol]); update_table('assets','currency',$uid,['currency_name' => $request->name, 'currency_symbol' => $request->symbol]); update_table('metu','currency',$uid,['currency_name' => $request->name, 'currency_symbol' => $request->symbol]); update_table('metu_purchases','currency',$uid,['currency_name' => $request->name, 'currency_symbol' => $request->symbol]); update_table('metu_sales','currency',$uid,['currency_name' => $request->name, 'currency_symbol' => $request->symbol]); update_table('metu_stock','currency',$uid,['currency_name' => $request->name, 'currency_symbol' => $request->symbol]); update_table('items','currency',$uid,['currency_name' => $request->name, 'currency_symbol' => $request->symbol]); update_table('tokens','currency',$uid,['currency_name' => $request->name, 'currency_symbol' => $request->symbol]); update_table('shareholder_credit','currency',$uid,['currency_name' => $request->name, 'currency_symbol' => $request->symbol]); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'currency_update'), 'message_body' => print_lang($this->data["app_lang"],'currency_update_successfully'))); } public function delete($uid) { if(check_user_access('delete_currency') === FALSE){ Redirect::to('/')->send(); } if($uid != 'USD') { delete_table('currency','uid',$uid); } echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }