<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; class Custom_charges extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_shor_custom_charges') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $custom_charges = DB::table('custom_charges')->where('branch',$branch_id); if(!empty($request->currency)){ $custom_charges->where('currency',$request->currency); } if(!empty($request->agent)){ $custom_charges->where('agent',$request->agent); } if(!empty($request->from)){ $custom_charges->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $custom_charges->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($custom_charges->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["load_delivery"] = set_array_keys(fetch_table_branch('load_delivery'),'uid'); $this->data["car_purchases_details"] = set_array_keys(fetch_table_branch('car_purchases_details'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_agent"] = $request->agent; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'custom_charges'); $this->data["pageToLoad"] = "custom_charges/view.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function invoice(Request $request,$uid) { if(check_user_access('invoice_shor_custom_charges') === FALSE){ Redirect::to('/')->send(); } $this->data["invoice_data"] = fetch_table_where('car_purchases','uid',$uid,true); $this->data["invoice_details"] = fetch_table_where('car_purchases_details','purchase_id',$this->data["invoice_data"]['uid']); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'car_purchase_invoice'); $this->data["pageToLoad"] = "custom_charges/invoice.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_shor_custom_charges') === FALSE){ Redirect::to('/')->send(); } $this->data["accounts"] = fetch_nested_accounts(); $this->data["currencies"] = fetch_currencies(); $this->data["load_delivery"] = fetch_table_branch('load_delivery'); $this->data["car_purchases_details"] = fetch_table_branch('car_purchases_details'); $this->data["title"] = print_lang($this->data["app_lang"],'new_custom_charges'); $this->data["pageToLoad"] = "custom_charges/add.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'rate' => 'required', 'invoice' => 'required|unique:custom_charges', 'load_delivery' => 'required', 'car' => 'required', 'agent' => 'required', 'amount' => 'required', ]); $validator->validate(); $uid = getUniqueId('CCHR', 'custom_charges', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'currency' => $request->currency, 'currency_usd_equalance' => $request->rate, 'invoice' => $request->invoice, 'load_delivery' => $request->load_delivery, 'car' => $request->car, 'agent' => $request->agent, 'amount' => (float)$request->amount, 'details' => $request->details, ); $car_data = fetch_table_where('car_purchases_details','uid',$db_array['car'],true); if(is_array($car_data) AND isset($car_data['uid'])) { $purchase_data = fetch_table_where('car_purchases','uid',$car_data['purchase_id'],true); $purchase_currency_usd_equalance = isset($purchase_data['currency_usd_equalance']) ? $purchase_data['currency_usd_equalance'] : 1; $custom_charges = (float)$db_array['amount']; $custom_charges = amount_conversion($custom_charges, $db_array['currency_usd_equalance'], $purchase_currency_usd_equalance); $db_array['per_car_expenses'] = $custom_charges; $car_existing_expenses = (float)$car_data['custom_charges']; $car_new_expenses = $car_existing_expenses + $custom_charges; update_table('car_purchases_details','uid',$car_data['uid'],array('custom_charges' => $car_new_expenses)); } insert_table('custom_charges',$db_array); _handle_custom_charges_ledger_effects(['uid' => $uid, 'state' => 'new']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_custom_charges'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/custom-charges/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['amount']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'custom_charges_saved'), 'message_body' => print_lang($this->data["app_lang"],'custom_charges_saved_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_shor_custom_charges') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('custom_charges','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/custom-charges')->send(); } $this->data["accounts"] = fetch_nested_accounts(); $this->data["currencies"] = fetch_currencies(); $this->data["load_delivery"] = fetch_table_branch('load_delivery'); $this->data["car_purchases_details"] = fetch_table_branch('car_purchases_details'); $this->data["title"] = print_lang($this->data["app_lang"],'edit_custom_charges'); $this->data["pageToLoad"] = "custom_charges/edit.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'rate' => 'required', 'invoice' => ['required',Rule::unique('custom_charges')->ignore($uid, 'uid')], 'load_delivery' => 'required', 'car' => 'required', 'agent' => 'required', 'amount' => 'required', ]); $validator->validate(); $db_array = array( 'currency' => $request->currency, 'currency_usd_equalance' => $request->rate, 'invoice' => $request->invoice, 'load_delivery' => $request->load_delivery, 'car' => $request->car, 'agent' => $request->agent, 'amount' => (float)$request->amount, 'details' => $request->details, ); $custom_charges_data = fetch_table_where('custom_charges','uid',$uid,TRUE); $car_data = fetch_table_where('car_purchases_details','uid',$db_array['car'],true); if(is_array($car_data) AND isset($car_data['uid'])) { $purchase_data = fetch_table_where('car_purchases','uid',$car_data['purchase_id'],true); $purchase_currency_usd_equalance = isset($purchase_data['currency_usd_equalance']) ? $purchase_data['currency_usd_equalance'] : 1; $expenses_before_update = (float)$custom_charges_data["per_car_expenses"]; $custom_charges = (float)$db_array['amount']; $custom_charges = amount_conversion($custom_charges, $db_array['currency_usd_equalance'], $purchase_currency_usd_equalance); $db_array['per_car_expenses'] = $custom_charges; $car_existing_expenses = (float)$car_data['custom_charges']; $car_new_expenses = $car_existing_expenses + $custom_charges; $car_new_expenses = $car_new_expenses - $expenses_before_update; update_table('car_purchases_details','uid',$car_data['uid'],array('custom_charges' => $car_new_expenses)); } update_table('custom_charges','uid',$uid,$db_array); _handle_custom_charges_ledger_effects(['uid' => $uid, 'state' => 'update']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_custom_charges'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/custom-charges/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['amount']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'custom_charges_updated'), 'message_body' => print_lang($this->data["app_lang"],'custom_charges_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_shor_custom_charges') === FALSE){ Redirect::to('/')->send(); } $custom_charges_data = fetch_table_where('custom_charges','uid',$uid,TRUE); $car_data = fetch_table_where('car_purchases_details','uid',$custom_charges_data['car'],true); if(is_array($car_data) AND isset($car_data['uid'])) { $expenses_before_update = (float)$custom_charges_data["per_car_expenses"]; $car_existing_expenses = (float)$car_data['custom_charges']; $car_new_expenses = $car_existing_expenses - $expenses_before_update; update_table('car_purchases_details','uid',$car_data['uid'],array('custom_charges' => $car_new_expenses)); } $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_custom_charges'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$custom_charges_data['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($custom_charges_data['amount']), ); set_activity_alert($_activity_details); delete_table('custom_charges','uid',$uid); _handle_custom_charges_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }