<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; class Custom_expenses extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_shor_custom_expenses') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $custom_expenses = DB::table('custom_expenses')->where('branch',$branch_id); if(!empty($request->currency)){ $custom_expenses->where('currency',$request->currency); } if(!empty($request->agent)){ $custom_expenses->where('agent',$request->agent); } if(!empty($request->from)){ $custom_expenses->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $custom_expenses->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($custom_expenses->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["load_delivery"] = set_array_keys(fetch_table_branch('load_delivery'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_agent"] = $request->agent; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'custom_expenses'); $this->data["pageToLoad"] = "custom_expenses/view.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function invoice(Request $request,$uid) { if(check_user_access('invoice_shor_custom_expenses') === FALSE){ Redirect::to('/')->send(); } $this->data["invoice_data"] = fetch_table_where('car_purchases','uid',$uid,true); $this->data["invoice_details"] = fetch_table_where('car_purchases_details','purchase_id',$this->data["invoice_data"]['uid']); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'car_purchase_invoice'); $this->data["pageToLoad"] = "car_purchases/invoice.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_shor_custom_expenses') === FALSE){ Redirect::to('/')->send(); } $this->data["accounts"] = fetch_nested_accounts(); $this->data["currencies"] = fetch_currencies(); $this->data["load_delivery"] = fetch_table_branch('load_delivery'); $this->data["title"] = print_lang($this->data["app_lang"],'new_custom_expenses'); $this->data["pageToLoad"] = "custom_expenses/add.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'rate' => 'required', 'invoice' => 'required|unique:custom_expenses', 'load_delivery' => 'required', 'agent' => 'required', 'amount' => 'required', ]); $validator->validate(); $uid = getUniqueId('CEXP', 'custom_expenses', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'currency' => $request->currency, 'currency_usd_equalance' => $request->rate, 'invoice' => $request->invoice, 'load_delivery' => $request->load_delivery, 'agent' => $request->agent, 'amount' => (float)$request->amount, 'details' => $request->details, ); $load_delivery_id = $request->load_delivery; $load_delivery_data = fetch_table_where('load_delivery','uid',$load_delivery_id,true); $purchase_id = isset($load_delivery_data['purchase']) ? $load_delivery_data['purchase'] : NULL; $purchase_data = fetch_table_where('car_purchases','uid',$purchase_id,true); $purchase_currency_usd_equalance = isset($purchase_data['currency_usd_equalance']) ? $purchase_data['currency_usd_equalance'] : 1; $purchase_cars = fetch_table_where('car_purchases_details','purchase_id',$purchase_id); if(is_array($purchase_cars) AND count($purchase_cars) > 0) { $custom_expenses = (float)$db_array['amount']; $custom_expenses = amount_conversion($custom_expenses, $db_array['currency_usd_equalance'], $purchase_currency_usd_equalance); $number_of_cars = count($purchase_cars); $per_car_expenses = $custom_expenses / $number_of_cars; $db_array['per_car_expenses'] = $per_car_expenses; foreach($purchase_cars as $car) { $car_existing_expenses = (float)$car['custom_expenses']; $car_new_expenses = $car_existing_expenses + $per_car_expenses; update_table('car_purchases_details','uid',$car['uid'],array('custom_expenses' => $car_new_expenses)); } } insert_table('custom_expenses',$db_array); _handle_custom_expenses_ledger_effects(['uid' => $uid, 'state' => 'new']); $_activity_details = array( 'module' => 'custom_expenses', 'activity' => 'added', 'url' => '/custom-expenses/edit/'.$db_array['uid'], 'details' => 'Invoice #'.$db_array['invoice'].', Amount: '.amount_number_format($db_array['amount']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'custom_expenses_saved'), 'message_body' => print_lang($this->data["app_lang"],'custom_expenses_saved_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_shor_custom_expenses') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('custom_expenses','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/custom-expenses')->send(); } $this->data["accounts"] = fetch_nested_accounts(); $this->data["currencies"] = fetch_currencies(); $this->data["load_delivery"] = fetch_table_branch('load_delivery'); $this->data["title"] = print_lang($this->data["app_lang"],'edit_custom_expenses'); $this->data["pageToLoad"] = "custom_expenses/edit.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'rate' => 'required', 'invoice' => ['required',Rule::unique('custom_expenses')->ignore($uid, 'uid')], 'load_delivery' => 'required', 'agent' => 'required', 'amount' => 'required', ]); $validator->validate(); $db_array = array( 'currency' => $request->currency, 'currency_usd_equalance' => $request->rate, 'invoice' => $request->invoice, 'load_delivery' => $request->load_delivery, 'agent' => $request->agent, 'amount' => (float)$request->amount, 'details' => $request->details, ); $custom_expenses_data = fetch_table_where('custom_expenses','uid',$uid,TRUE); $load_delivery_id = $request->load_delivery; $load_delivery_data = fetch_table_where('load_delivery','uid',$load_delivery_id,true); $purchase_id = isset($load_delivery_data['purchase']) ? $load_delivery_data['purchase'] : NULL; $purchase_data = fetch_table_where('car_purchases','uid',$purchase_id,true); $purchase_currency_usd_equalance = isset($purchase_data['currency_usd_equalance']) ? $purchase_data['currency_usd_equalance'] : 1; $purchase_cars = fetch_table_where('car_purchases_details','purchase_id',$purchase_id); if(is_array($purchase_cars) AND count($purchase_cars) > 0) { $expenses_before_update = (float)$custom_expenses_data["per_car_expenses"]; $custom_expenses = (float)$db_array['amount']; $custom_expenses = amount_conversion($custom_expenses, $db_array['currency_usd_equalance'], $purchase_currency_usd_equalance); $number_of_cars = count($purchase_cars); $per_car_expenses = $custom_expenses / $number_of_cars; $db_array['per_car_expenses'] = $per_car_expenses; foreach($purchase_cars as $car) { $car_existing_expenses = (float)$car['custom_expenses']; $car_new_expenses = $car_existing_expenses + $per_car_expenses; $car_new_expenses = $car_new_expenses - $expenses_before_update; update_table('car_purchases_details','uid',$car['uid'],array('custom_expenses' => $car_new_expenses)); } } update_table('custom_expenses','uid',$uid,$db_array); _handle_custom_expenses_ledger_effects(['uid' => $uid, 'state' => 'update']); $_activity_details = array( 'module' => 'custom_expenses', 'activity' => 'updated', 'url' => '/custom-expenses/edit/'.$uid, 'details' => 'Invoice # '.$db_array['invoice'].', Amount: '.amount_number_format($db_array['amount']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'custom_expenses_updated'), 'message_body' => print_lang($this->data["app_lang"],'custom_expenses_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_shor_custom_expenses') === FALSE){ Redirect::to('/')->send(); } $custom_expenses_data = fetch_table_where('custom_expenses','uid',$uid,true); $load_delivery_id = $custom_expenses_data['load_delivery']; $load_delivery_data = fetch_table_where('load_delivery','uid',$load_delivery_id,true); $purchase_id = isset($load_delivery_data['purchase']) ? $load_delivery_data['purchase'] : NULL; $purchase_cars = fetch_table_where('car_purchases_details','purchase_id',$purchase_id); if(is_array($purchase_cars) AND count($purchase_cars) > 0) { $expenses_before_update = (float)$custom_expenses_data["per_car_expenses"]; foreach($purchase_cars as $car) { $car_existing_expenses = (float)$car['custom_expenses']; $car_new_expenses = $car_existing_expenses - $expenses_before_update; update_table('car_purchases_details','uid',$car['uid'],array('custom_expenses' => $car_new_expenses)); } } $_activity_details = array( 'module' => 'custom_expenses', 'activity' => 'deleted', 'url' => NULL, 'details' => 'Invoice # '.$custom_expenses_data['invoice'].', Amount: '.amount_number_format($custom_expenses_data['amount']), ); set_activity_alert($_activity_details); delete_table('custom_expenses','uid',$uid); _handle_custom_expenses_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }