<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Cwarehouses extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_project_warehouses') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $cwarehouses = DB::table('cwarehouses')->where('branch',$branch_id); if(!empty($request->name)){ $cwarehouses->where('name','like','%'.$request->name.'%'); } if(!empty($request->from)){ $cwarehouses->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $cwarehouses->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($cwarehouses->get()),true); $this->data["search_name"] = $request->name; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'construction_warehouses'); $this->data["pageToLoad"] = "cwarehouses/view.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_project_warehouses') === FALSE){ Redirect::to('/')->send(); } $this->data["title"] = print_lang($this->data["app_lang"],'new_construction_warehouse'); $this->data["pageToLoad"] = "cwarehouses/add.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', ]); $validator->validate(); $uid = getUniqueId('CWRS', 'cwarehouses', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'name' => $request->name, 'user' => Session::get('user_id'), ); insert_table('cwarehouses',$db_array); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_cwarehouses'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/cwarehouses/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_new_warehouse').', '.print_lang($this->data["app_lang"],'dashboard_activities_text_name').' '.$db_array['name'], ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'construction_warehouse_saved'), 'message_body' => print_lang($this->data["app_lang"],'construction_warehouse_saved_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_project_warehouses') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('cwarehouses','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/cwarehouses')->send(); } $this->data["title"] = print_lang($this->data["app_lang"],'edit_construction_warehouse'); $this->data["pageToLoad"] = "cwarehouses/edit.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', ]); $validator->validate(); $db_array = array( 'name' => $request->name, ); update_table('cwarehouses','uid',$uid,$db_array); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_cwarehouses'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/cwarehouses/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_updated_warehouse').', '.print_lang($this->data["app_lang"],'dashboard_activities_text_name').' '.$db_array['name'], ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'construction_warehouse_updated'), 'message_body' => print_lang($this->data["app_lang"],'construction_warehouse_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_project_warehouses') === FALSE){ Redirect::to('/')->send(); } $delete_data = fetch_table_where('cwarehouses','uid',$uid,TRUE); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_cwarehouses'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_deleted_warehouse').', '.print_lang($this->data["app_lang"],'dashboard_activities_text_name').' '.$delete_data['name'], ); set_activity_alert($_activity_details); delete_table('cwarehouses','uid',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function details(Request $request, $uid) { if(check_user_access('details_project_warehouses') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $c_items = DB::table('citems')->where('branch',$branch_id); $purchases = DB::table('cpurchases')->where('branch',$branch_id)->where('warehouse',$uid); $projects_assign = DB::table('projects_assign')->where('branch',$branch_id)->where('assign_type','material')->where('status','passed'); if(!empty($request->item)) { $c_items->where('uid',$request->item); $purchases->where('item',$request->item); $projects_assign->where('item',$request->item); } if(!empty($request->project)) { $projects_assign->where('project',$request->project); } if(!empty($request->from)) { $c_items->where('created_at','>=',get_true_date($request->from).' 00:00:00'); $purchases->where('created_at','>=',get_true_date($request->from).' 00:00:00'); $projects_assign->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)) { $c_items->where('created_at','<=',get_true_date($request->to).' 23:59:59'); $purchases->where('created_at','<=',get_true_date($request->to).' 23:59:59'); $projects_assign->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $c_items = json_decode(json_encode($c_items->get()),true); $purchases = json_decode(json_encode($purchases->get()),true); $projects_assign = json_decode(json_encode($projects_assign->get()),true); $details = c_warehouse_details($c_items,$purchases,$projects_assign); $this->data["pageData"] = $details; $this->data["search_item"] = $request->item; $this->data["search_project"] = $request->project; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["warehouse_uid"] = $uid; $this->data["projects"] = set_array_keys(fetch_table_branch('projects'),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('citems'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'cons_warehouse_details_title'); $this->data["pageToLoad"] = "cwarehouses/details.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } }