<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Damage extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_damage_stock') === FALSE){ Redirect::to('/')->send(); } $this->data["pageData"] = fetch_table_branch('damage'); $this->data["items"] = set_array_keys(get_warehouse_wise_items(),'uid'); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["batch"] = set_array_keys(fetch_table_branch('batch'),'uid'); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'damage_stock'); $this->data["pageToLoad"] = "damage/view.php"; $this->data["activeLink"] = "damage-stock"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_damage_stock') === FALSE){ Redirect::to('/')->send(); } $item_inventory_query = DB::table('items_inventory_stats')->where('branch',active_branch_id()); $item_inventory_query->select( 'item', 'item_name', 'warehouse', DB::raw('
                    sum(case when 
                    module_name = "items"
                    then purchase_unit_stock_in END) as opening_units' ), DB::raw('
                    sum(case when 
                    module_name = "purchases"
                    then purchase_unit_stock_in END) as purchase_units' ), DB::raw('
                    sum(case when 
                    module_name = "purchases"
                    then purchase_unit_bonus_in END) as purchase_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "production_in"
                    then purchase_unit_stock_in END) as production_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "production_out"
                    then purchase_unit_stock_out END) as production_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales"
                    then purchase_unit_stock_out END) as sale_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales"
                    then purchase_unit_bonus_out END) as sale_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales_return"
                    then purchase_unit_stock_in END) as sale_return_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales_return"
                    then purchase_unit_bonus_in END) as sale_return_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_to_branch_transfer_in"
                    then purchase_unit_stock_in END) as branch_to_branch_transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_to_branch_transfer_out"
                    then purchase_unit_stock_out END) as branch_to_branch_transfer_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "damage"
                    then purchase_unit_stock_in END) as damage_units' ), DB::raw('
                    sum(case when 
                    module_name = "expenses_deductions"
                    then purchase_unit_stock_in END) as expenses_deductions_units' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_in"
                    then purchase_unit_stock_in END) as transfer_in_pharma' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_in"
                    then purchase_unit_bonus_in END) as transfer_in_pharma_bonus' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_out"
                    then purchase_unit_stock_out END) as transfer_out_pharma' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_out"
                    then purchase_unit_bonus_out END) as transfer_out_pharma_bonus' ), DB::raw('
                    sum(case when 
                    module_name = "warehouse_transfer_in"
                    then purchase_unit_stock_in END) as transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "warehouse_transfer_out"
                    then purchase_unit_stock_out END) as transfer_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_transfer_in"
                    then purchase_unit_stock_in END) as branch_transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_transfer_out"
                    then purchase_unit_stock_out END) as branch_transfer_out_units' ), DB::raw('
                    sum(purchase_unit_stock_in) as total_stock_in' ), DB::raw('
                    sum(purchase_unit_stock_out) as total_stock_out' ) ); $item_inventory_query->groupBy('item'); $item_inventory_query->groupBy('item_name'); $item_inventory_query->groupBy('warehouse'); $item_inventory_query = std_obj_to_array($item_inventory_query->get()); $this->data["items"] = $item_inventory_query; $this->data["warehouse"] = fetch_table_branch('warehouse'); $this->data["batch"] = fetch_table_branch('batch'); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["items_data"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'add_damage'); $this->data["pageToLoad"] = "damage/add.php"; $this->data["activeLink"] = "damage-stock"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'warehouse' => 'required', 'item' => 'required', 'qty' => 'required', 'unit' => 'required', ]); $validator->validate(); $uid = getUniqueId('DMGI', 'damage', 'uid'); $item_record = fetch_table_where('items','uid',$request->item,true); if($request->unit == 'sale') { if((float)$item_record['sale_unit_equalance'] == 0) { (float)$item_record['sale_unit_equalance'] = 1; } $unit_qty = (float)$request->qty / (float)$item_record['sale_unit_equalance']; } else if($request->unit == 'production') { if((float)$item_record['production_unit_equalance'] == 0) { (float)$item_record['production_unit_equalance'] = 1; } $unit_qty = (float)$request->qty / (float)$item_record['production_unit_equalance']; } else { $unit_qty = $request->qty; } $cost = (float)$item_record['_avg_cost']; $total = $unit_qty * $cost; $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'currency' => $item_record['currency'], 'currency_usd_equalance' => $item_record['currency_usd_equalance'], 'warehouse' => $request->warehouse, 'item' => $request->item, 'batch' => $request->batch, 'qty' => $request->qty, 'unit' => $request->unit, 'narration' => $request->narration, 'cost' => $cost, 'total' => $total, 'unit_qty' => $unit_qty, ); insert_table('damage',$db_array); if($request->unit == 'sale') { if((float)$item_record['sale_unit_equalance'] == 0) { (float)$item_record['sale_unit_equalance'] = 1; } $request->qty = (float)$request->qty / (float)$item_record['sale_unit_equalance']; } else if($request->unit == 'production') { if((float)$item_record['production_unit_equalance'] == 0) { (float)$item_record['production_unit_equalance'] = 1; } $request->qty = (float)$request->qty / (float)$item_record['production_unit_equalance']; } else { $request->qty = $request->qty; } $uid_b = getUniqueId('BTCH', 'batch_wise_stock', 'uid'); $batch_db_array = array( 'uid' => $uid_b, 'module_uid' => $uid, 'branch' => active_branch_id(), 'entry_date' => date('Y-m-d'), 'module_created_at' => date('Y-m-d H:i:s'), 'item' => $request->item, 'unit' => $request->unit, 'warehouse' => $request->warehouse, 'batch' => $request->batch, 'stock_out' => $request->qty, 'module' => 'damage', 'status' => 'passed', ); insert_table('batch_wise_stock',$batch_db_array); $inventory_array = array( 'uid' => $uid_b, 'module_uid' => $uid, 'branch' => active_branch_id(), 'entry_date' => date('Y-m-d'), 'module_created_at' => date('Y-m-d H:i:s'), 'item' => $request->item, 'unit' => $request->unit, 'warehouse' => $request->warehouse, 'batch' => $request->batch, 'damage' => $request->qty, 'module' => 'damage', 'status' => 'passed', ); insert_table('item_inventory',$inventory_array); _handle_items_inventory_stats_from_damage(['uid' => $uid, 'entry_status' => 'new']); $items = fetch_table_where('items','uid',$db_array['item'],true); $item_name = isset($items['name']) ? $items['name'] : NULL; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_damage'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/damage-stock/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_item').': '.$item_name.', '.print_lang($this->data["app_lang"],'dashboard_activities_text_qty').': '.amount_number_format($db_array['qty']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'damage_stock_added'), 'message_body' => print_lang($this->data["app_lang"],'damage_stock_added_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_damage_stock') === FALSE){ Redirect::to('/')->send(); } $item_inventory_query = DB::table('items_inventory_stats')->where('branch',active_branch_id()); $item_inventory_query->select( 'item', 'item_name', 'warehouse', DB::raw('
                    sum(case when 
                    module_name = "items"
                    then purchase_unit_stock_in END) as opening_units' ), DB::raw('
                    sum(case when 
                    module_name = "purchases"
                    then purchase_unit_stock_in END) as purchase_units' ), DB::raw('
                    sum(case when 
                    module_name = "purchases"
                    then purchase_unit_bonus_in END) as purchase_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "production_in"
                    then purchase_unit_stock_in END) as production_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "production_out"
                    then purchase_unit_stock_out END) as production_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales"
                    then purchase_unit_stock_out END) as sale_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales"
                    then purchase_unit_bonus_out END) as sale_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales_return"
                    then purchase_unit_stock_in END) as sale_return_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales_return"
                    then purchase_unit_bonus_in END) as sale_return_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_to_branch_transfer_in"
                    then purchase_unit_stock_in END) as branch_to_branch_transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_to_branch_transfer_out"
                    then purchase_unit_stock_out END) as branch_to_branch_transfer_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "damage"
                    then purchase_unit_stock_in END) as damage_units' ), DB::raw('
                    sum(case when 
                    module_name = "expenses_deductions"
                    then purchase_unit_stock_in END) as expenses_deductions_units' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_in"
                    then purchase_unit_stock_in END) as transfer_in_pharma' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_in"
                    then purchase_unit_bonus_in END) as transfer_in_pharma_bonus' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_out"
                    then purchase_unit_stock_out END) as transfer_out_pharma' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_out"
                    then purchase_unit_bonus_out END) as transfer_out_pharma_bonus' ), DB::raw('
                    sum(case when 
                    module_name = "warehouse_transfer_in"
                    then purchase_unit_stock_in END) as transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "warehouse_transfer_out"
                    then purchase_unit_stock_out END) as transfer_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_transfer_in"
                    then purchase_unit_stock_in END) as branch_transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_transfer_out"
                    then purchase_unit_stock_out END) as branch_transfer_out_units' ), DB::raw('
                    sum(purchase_unit_stock_in) as total_stock_in' ), DB::raw('
                    sum(purchase_unit_stock_out) as total_stock_out' ), ); $item_inventory_query->groupBy('item'); $item_inventory_query->groupBy('item_name'); $item_inventory_query->groupBy('warehouse'); $item_inventory_query = std_obj_to_array($item_inventory_query->get()); $this->data["items"] = $item_inventory_query; $this->data["items_data"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["editing_data"] = fetch_table_where('damage','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/damage-stock')->send(); } $item = $this->data["editing_data"]['item']; $warehouse = $this->data["editing_data"]['warehouse']; $this->data["warehouse"] = fetch_table_branch('warehouse'); $this->data["batch"] = fetch_table_branch('batch'); $this->data["selected_item"] = fetch_table_where('items','uid',$item,true); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'edit_damage_stock'); $this->data["pageToLoad"] = "damage/edit.php"; $this->data["activeLink"] = "damage-stock"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'warehouse' => 'required', 'item' => 'required', 'qty' => 'required', 'unit' => 'required', ]); $validator->validate(); $data_before_update = fetch_table_where('damage','uid',$uid,true); $item_record = fetch_table_where('items','uid',$request->item,true); if($request->unit == 'sale') { if((float)$item_record['sale_unit_equalance'] == 0) { (float)$item_record['sale_unit_equalance'] = 1; } $unit_qty = (float)$request->qty / (float)$item_record['sale_unit_equalance']; } else if($request->unit == 'production') { if((float)$item_record['production_unit_equalance'] == 0) { (float)$item_record['production_unit_equalance'] = 1; } $unit_qty = (float)$request->qty / (float)$item_record['production_unit_equalance']; } else { $unit_qty = $request->qty; } $cost = (float)$item_record['_avg_cost']; $total = $unit_qty * $cost; $db_array = array( 'warehouse' => $request->warehouse, 'item' => $request->item, 'batch' => $request->batch, 'qty' => $request->qty, 'unit' => $request->unit, 'narration' => $request->narration, 'cost' => $cost, 'total' => $total, 'unit_qty' => $unit_qty, ); update_table('damage','uid',$uid,$db_array); _handle_items_inventory_stats_from_damage(['uid' => $uid, 'entry_status' => 'update']); _calculate_item_wise_stats(['item' => $data_before_update['item']]); $items = fetch_table_where('items','uid',$db_array['item'],true); $item_name = isset($items['name']) ? $items['name'] : NULL; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_damage'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/damage-stock/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_item').': '.$item_name.', '.print_lang($this->data["app_lang"],'dashboard_activities_text_qty').': '.amount_number_format($db_array['qty']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'damage_stock_updated'), 'message_body' => print_lang($this->data["app_lang"],'damage_stock_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_damage_stock') === FALSE){ Redirect::to('/')->send(); } $damage_data = fetch_table_where('damage','uid',$uid,true); $items = fetch_table_where('items','uid',$damage_data['item'],true); $item_name = isset($items['name']) ? $items['name'] : NULL; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_damage'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_item').': '.$item_name.', '.print_lang($this->data["app_lang"],'dashboard_activities_text_qty').': '.amount_number_format($damage_data['qty']), ); set_activity_alert($_activity_details); delete_table('damage','uid',$uid); _handle_items_inventory_stats_from_damage(['uid' => $uid, 'entry_status' => 'delete']); _calculate_item_wise_stats(['item' => $damage_data['item']]); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }