<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; class Debit_credit_note extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_debit_credit_note') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $debit_credit_note = DB::table('debit_credit_note')->where('branch',$branch_id); if(!empty($request->currency)){ $debit_credit_note->where('currency',$request->currency); } if(!empty($request->status)){ $debit_credit_note->where('status',$request->status); } if(!empty($request->from)){ $debit_credit_note->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $debit_credit_note->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $debit_credit_note = $debit_credit_note->get(); $debit_credit_note = json_decode(json_encode($debit_credit_note),true); $this->data["pageData"] = $debit_credit_note; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["search_status"] = $request->status; $this->data["search_currency"] = $request->currency; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'mod_db_cr_nt_view_title'); $this->data["pageToLoad"] = "debit_credit_note/view.php"; $this->data["activeLink"] = "debit_credit_note"; $this->load_view($this->data); } public function invoice(Request $request,$uid) { if(check_user_access('invoice_debit_credit_note') === FALSE){ Redirect::to('/')->send(); } $this->data["invoice_data"] = fetch_table_where('debit_credit_note','uid',$uid,true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_db_cr_nt_inv'); $this->data["pageToLoad"] = "debit_credit_note/invoice.php"; $this->data["activeLink"] = "debit_credit_note"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_debit_credit_note') === FALSE){ Redirect::to('/')->send(); } $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_db_cr_nt_add_title'); $this->data["pageToLoad"] = "debit_credit_note/add.php"; $this->data["activeLink"] = "debit_credit_note"; $this->load_view($this->data); } public function save(Request $request) { $items_found = false; $collection_of_accounts = array(); $collection_of_accounts_details = array(); $active_branch_id = active_branch_id(); $invoice = get_debit_credit_note_invoice_number(); $currency_db_data = fetch_table_where('currency','uid',$request->currency[0],true); if(count($request->d_account) > 0) { $items_count = 0; while($items_count < count($request->d_account)) { if(empty($request->d_account[$items_count])){ continue; } $items_found = true; $data_array = array( 'd_account' => $request->d_account[$items_count], 'd_account_type' => $request->d_account_type[$items_count], 'd_type' => $request->d_type[$items_count], 'd_amount' => (float)$request->d_amount[$items_count], 'narration' => $request->narration[$items_count], ); $collection_of_accounts_details[] = $data_array; $collection_of_accounts[] = '-++-'.$request->d_account[$items_count].'-++-'; $items_count++; } } if($items_found == true) { $uid = getUniqueId('DBCRNOTE', 'debit_credit_note', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => $active_branch_id, 'serial_id' => get_serial_id('debit_credit_note'), 'type' => $request->type[0], 'currency' => $request->currency[0], 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'invoice' => $invoice, 'account' => $request->account[0], 'amount' => (float)$request->total, 'd_amount' => (float)$request->d_total, 'pending' => (float)$request->pending, 'details' => json_encode($collection_of_accounts_details), 'd_accounts' => implode(',', $collection_of_accounts), 'narration' => $request->main_narration, ); insert_table('debit_credit_note',$db_array); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_debit_credit_note'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/debit-credit-note/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['amount']), ); set_activity_alert($_activity_details); $invoice_url = url('/debit-credit-note/invoice').'/'.$uid; echo json_encode(array('status' => 'success', 'mood' => 'new', 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'mod_db_cr_nt_added'), 'message_body' => print_lang($this->data["app_lang"],'mod_db_cr_nt_save_successfully'))); } else { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'item_not_found'), 'message_body' => print_lang($this->data["app_lang"],'add_items_to_proceed'))); } } public function edit(Request $request, $uid) { if(check_user_access('edit_debit_credit_note') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('debit_credit_note','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/debit-credit-note')->send(); } $this->data["currencies"] = fetch_currencies(); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_db_cr_nt_edit_title'); $this->data["pageToLoad"] = "debit_credit_note/edit.php"; $this->data["activeLink"] = "debit_credit_note"; $this->load_view($this->data); } public function update(Request $request, $uid) { $items_found = false; $collection_of_accounts = array(); $collection_of_accounts_details = array(); $active_branch_id = active_branch_id(); $currency_db_data = fetch_table_where('currency','uid',$request->currency[0],true); $db_cr_data = fetch_table_where('debit_credit_note','uid',$uid,true); if(count($request->d_account) > 0) { $items_count = 0; while($items_count < count($request->d_account)) { if(empty($request->d_account[$items_count])){ continue; } $items_found = true; $data_array = array( 'd_account' => $request->d_account[$items_count], 'd_account_type' => $request->d_account_type[$items_count], 'd_type' => $request->d_type[$items_count], 'd_amount' => (float)$request->d_amount[$items_count], 'narration' => $request->narration[$items_count], ); $collection_of_accounts_details[] = $data_array; $collection_of_accounts[] = '-++-'.$request->d_account[$items_count].'-++-'; $items_count++; } } if($items_found == true) { $db_array = array( 'type' => $request->type[0], 'currency' => $request->currency[0], 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'account' => $request->account[0], 'amount' => (float)$request->total, 'd_amount' => (float)$request->d_total, 'pending' => (float)$request->pending, 'details' => json_encode($collection_of_accounts_details), 'd_accounts' => implode(',', $collection_of_accounts), 'narration' => $request->main_narration, ); update_table('debit_credit_note','uid',$uid,$db_array); if($db_cr_data['status'] == 'passed') { _handle_debit_credit_note_ledger_effects(['uid' => $uid, 'state' => 'update']); } $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_debit_credit_note'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/debit-credit-note/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_cr_data['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['amount']), ); set_activity_alert($_activity_details); $invoice_url = url('/debit-credit-note/invoice').'/'.$uid; echo json_encode(array('status' => 'success', 'mood' => 'update', 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'mod_db_cr_nt_update'), 'message_body' => print_lang($this->data["app_lang"],'mod_db_cr_nt_update_successfully'))); } else { echo json_encode(array('status' => 'error', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'item_not_found'), 'message_body' => print_lang($this->data["app_lang"],'add_items_to_proceed'))); } } public function delete($uid) { if(check_user_access('delete_debit_credit_note') === FALSE){ Redirect::to('/')->send(); } $old_data = fetch_table_where('debit_credit_note','uid',$uid,true); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_debit_credit_note'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$old_data['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($old_data['amount']), ); set_activity_alert($_activity_details); delete_table('debit_credit_note','uid',$uid); _handle_debit_credit_note_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function update_status(Request $request) { $uids = $request->uids; if(!empty($uids)) { foreach($uids as $uid) { $entry_data = fetch_table_where('debit_credit_note','uid',$uid,true); if($entry_data['status'] == 'pending') { $_activity_details = array( 'module' => 'debit credit note', 'activity' => 'passed', 'url' => NULL, 'details' => 'Activity Amount: '.amount_number_format($entry_data['amount']), ); set_activity_alert($_activity_details); $db_array = array( 'status' => 'passed', ); update_table('debit_credit_note','uid',$uid,$db_array); _handle_debit_credit_note_ledger_effects(['uid' => $uid, 'state' => 'new']); } } echo json_encode(array('status' => 'success', 'mode' => 'status_passed')); } else { echo json_encode(array('status' => 'error', 'mode' => 'status_passed', 'message' => 'No Data Selected')); } } }