<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; class Debit_credit_voucher extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_debit_credit_voucher') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $debit_credit_voucher = DB::table('debit_credit_vouchers')->where('branch',$branch_id); if(!empty($request->currency)){ $debit_credit_voucher->where('currency',$request->currency); } if(!empty($request->account)){ $debit_credit_voucher->where('account',$request->account); } if(!empty($request->type)){ $debit_credit_voucher->where('type',$request->type); } if(!empty($request->from)){ $debit_credit_voucher->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $debit_credit_voucher->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $debit_credit_voucher = $debit_credit_voucher->get(); $debit_credit_voucher = json_decode(json_encode($debit_credit_voucher),true); $this->data["pageData"] = $debit_credit_voucher; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_account"] = $request->account; $this->data["search_type"] = $request->type; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'mod_db_cr_voucher_view_title'); $this->data["pageToLoad"] = "debit_credit_voucher/view.php"; $this->data["activeLink"] = "debit_credit_voucher"; $this->load_view($this->data); } public function invoice(Request $request,$uid) { if(check_user_access('invoice_debit_credit_voucher') === FALSE){ Redirect::to('/')->send(); } $this->data["invoice_data"] = fetch_table_where('debit_credit_vouchers','uid',$uid,true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_db_cr_voucher_inv'); $this->data["pageToLoad"] = "debit_credit_voucher/invoice.php"; $this->data["activeLink"] = "debit_credit_voucher"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_debit_credit_voucher') === FALSE){ Redirect::to('/')->send(); } $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_db_cr_voucher_add_title'); $this->data["pageToLoad"] = "debit_credit_voucher/add.php"; $this->data["activeLink"] = "debit_credit_voucher"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'account' => 'required', 'amount' => 'required', ]); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $uid = getUniqueId('DBCRvoucher', 'debit_credit_vouchers', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'invoice' => get_debit_credit_voucher_invoice_number(), 'serial_id' => get_serial_id('debit_credit_vouchers'), 'currency' => $request->currency, 'currency_usd_equalance' => $currency_data['usd_equalance'], 'type' => $request->type, 'account' => $request->account, 'amount' => (float)$request->amount, 'details' => $request->details, ); insert_table('debit_credit_vouchers',$db_array); _handle_debit_credit_voucher_ledger_effects(['uid' => $uid, 'state' => 'new']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_debit_credit_voucher'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/debit-credit-voucher/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_debit_credit_voucher').', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['amount']), ); set_activity_alert($_activity_details); $invoice_url = url('/debit-credit-voucher/invoice').'/'.$uid; echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'mod_db_cr_voucher_added'), 'message_body' => print_lang($this->data["app_lang"],'mod_db_cr_voucher_save_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_debit_credit_voucher') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('debit_credit_vouchers','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/debit-credit-voucher')->send(); } $this->data["currencies"] = fetch_currencies(); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_db_cr_voucher_edit_title'); $this->data["pageToLoad"] = "debit_credit_voucher/edit.php"; $this->data["activeLink"] = "debit_credit_voucher"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'account' => 'required', 'amount' => 'required', ]); $currency_db_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'type' => $request->type, 'currency' => $request->currency, 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'account' => $request->account, 'amount' => (float)$request->amount, 'details' => $request->details, ); update_table('debit_credit_vouchers','uid',$uid,$db_array); _handle_debit_credit_voucher_ledger_effects(['uid' => $uid, 'state' => 'update']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_debit_credit_voucher'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/debit-credit-voucher/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_debit_credit_voucher').', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['amount']), ); set_activity_alert($_activity_details); $invoice_url = url('/debit-credit-voucher/invoice').'/'.$uid; echo json_encode(array('status' => 'success', 'mood' => 'update', 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'mod_db_cr_voucher_update'), 'message_body' => print_lang($this->data["app_lang"],'mod_db_cr_voucher_update_successfully'))); } public function delete($uid) { if(check_user_access('delete_debit_credit_voucher') === FALSE){ Redirect::to('/')->send(); } $old_data = fetch_table_where('debit_credit_vouchers','uid',$uid,true); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_debit_credit_voucher'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_debit_credit_voucher').', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($old_data['amount']), ); set_activity_alert($_activity_details); delete_table('debit_credit_vouchers','uid',$uid); _handle_debit_credit_voucher_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }