<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Division extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_division') === FALSE){ Redirect::to('/')->send(); } $this->data["pageData"] = fetch_table_branch('division'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_division_view_title'); $this->data["pageToLoad"] = "division/view.php"; $this->data["activeLink"] = "hrm"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_division') === FALSE){ Redirect::to('/')->send(); } $this->data["title"] = print_lang($this->data["app_lang"],'mod_division_add_title'); $this->data["pageToLoad"] = "division/add.php"; $this->data["activeLink"] = "hrm"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', ]); $validator->validate(); $uid = getUniqueId('DVSN', 'division', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'name' => $request->name, ); insert_table('division',$db_array); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'mod_division_added'), 'message_body' => print_lang($this->data["app_lang"],'mod_division_save_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_division') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('division','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/division')->send(); } $this->data["title"] = print_lang($this->data["app_lang"],'mod_division_edit_title'); $this->data["pageToLoad"] = "division/edit.php"; $this->data["activeLink"] = "hrm"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', ]); $validator->validate(); $db_array = array( 'name' => $request->name, ); update_table('division','uid',$uid,$db_array); update_table('employees','division',$uid,['division_name' => $request->name]); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'mod_division_update'), 'message_body' => print_lang($this->data["app_lang"],'mod_division_update_successfully'))); } public function delete($uid) { if(check_user_access('delete_division') === FALSE){ Redirect::to('/')->send(); } delete_table('division','uid',$uid); delete_table('employees','division_uid',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }