<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; class Employees extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_employee') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $employees = DB::table('employees')->where('branch',$branch_id); if(!empty($request->division)){ $employees->where('division',$request->division); } $this->data["pageData"] = json_decode(json_encode($employees->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["division"] = set_array_keys(fetch_table_branch('division'),'uid'); $this->data["search_division"] = $request->division; $this->data["title"] = print_lang($this->data["app_lang"],'employees'); $this->data["pageToLoad"] = "employees/view.php"; $this->data["activeLink"] = "hrm"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_employee') === FALSE){ Redirect::to('/')->send(); } $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["division"] = fetch_table_branch('division'); $this->data["title"] = print_lang($this->data["app_lang"],'add_employee'); $this->data["pageToLoad"] = "employees/add.php"; $this->data["activeLink"] = "hrm"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'father_name' => 'required', 'date_of_birth' => 'required', 'phone' => 'required', 'gender' => 'required', 'marital_status' => 'required', 'nationality' => 'required', 'designation' => 'required', 'date_of_joining' => 'required', 'joining_salary' => 'required', 'currency' => 'required', 'employee_status' => 'required', 'division' => 'required', ]); $validator->validate(); $uid = getUniqueId('EMPL', 'employees', 'uid'); $division_data = fetch_table_where('division','uid',$request->division,true); $division_name = isset($division_data['name']) ? $division_data['name'] : null; $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'name' => $request->name, 'father_name' => $request->father_name, 'date_of_birth' => $request->date_of_birth, 'phone' => $request->phone, 'gender' => $request->gender, 'marital_status' => $request->marital_status, 'nationality' => $request->nationality, 'local_address' => $request->local_address, 'permanent_address' => $request->permanent_address, 'designation' => $request->designation, 'date_of_joining' => $request->date_of_joining, 'joining_salary' => $request->joining_salary, 'currency' => $request->currency, 'employee_status' => $request->employee_status, 'employee_details' => $request->employee_details, 'division' => $request->division, 'division_name' => $division_name, ); if($request->hasFile('profile_pic')) { $file = $request->file('profile_pic'); $extension = $file->getClientOriginalExtension(); $file_name_prefix = db_unique_id('employees',get_simple_unique_id('EPPC')); $profile_pic = $file_name_prefix.'.'.$extension; $file->move('uploads/employees/',$profile_pic); $db_array['profile_pic'] = $profile_pic; } $employee_documents = array(); if($request->hasFile('employee_documents')) { $files = $request->file('employee_documents'); $uploaded_files = array(); foreach($files as $file) { $file_extension = $file->getClientOriginalExtension(); $file_name_prefix = db_unique_id('employees',get_simple_unique_id('EMPD')); $file_true_name = $file_name_prefix.'.'.$file_extension; $file->move('uploads/employees/',$file_true_name); $employee_documents[] = $file_true_name; } } $db_array['employee_documents'] = json_encode($employee_documents); insert_table('employees',$db_array); $euid = getUniqueId('ACCT', 'accounts', 'uid'); $account_db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'name' => $db_array['name'], 'type' => 'employee', 'client_type' => 'general', 'code' => get_new_account_code(), 'memo' => 'employee account', 'employee_uid' => $uid, ); insert_table('accounts',$account_db_array); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'employee_added'), 'message_body' => print_lang($this->data["app_lang"],'employee_added_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_employee') === FALSE){ Redirect::to('/')->send(); } $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["division"] = fetch_table_branch('division'); $this->data["editing_data"] = fetch_table_where('employees','uid',$uid,true); $this->data["title"] = print_lang($this->data["app_lang"],'edit_employee'); $this->data["pageToLoad"] = "employees/edit.php"; $this->data["activeLink"] = "hrm"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'father_name' => 'required', 'date_of_birth' => 'required', 'phone' => 'required', 'gender' => 'required', 'marital_status' => 'required', 'nationality' => 'required', 'designation' => 'required', 'date_of_joining' => 'required', 'joining_salary' => 'required', 'currency' => 'required', 'employee_status' => 'required', 'division' => 'required', ]); $validator->validate(); $division_data = fetch_table_where('division','uid',$request->division,true); $division_name = isset($division_data['name']) ? $division_data['name'] : null; $db_array = array( 'name' => $request->name, 'father_name' => $request->father_name, 'date_of_birth' => $request->date_of_birth, 'phone' => $request->phone, 'gender' => $request->gender, 'marital_status' => $request->marital_status, 'nationality' => $request->nationality, 'local_address' => $request->local_address, 'permanent_address' => $request->permanent_address, 'designation' => $request->designation, 'date_of_joining' => $request->date_of_joining, 'joining_salary' => $request->joining_salary, 'currency' => $request->currency, 'employee_status' => $request->employee_status, 'employee_details' => $request->employee_details, 'division' => $request->division, 'division_name' => $division_name, ); $employee_db_data = fetch_table_where('employees','uid',$uid,TRUE); if($request->hasFile('profile_pic')) { $file = $request->file('profile_pic'); $extension = $file->getClientOriginalExtension(); $file_name_prefix = db_unique_id('employees',get_simple_unique_id('EPPC')); $profile_pic = $file_name_prefix.'.'.$extension; $file->move('uploads/employees/',$profile_pic); $db_array['profile_pic'] = $profile_pic; File::delete('uploads/employees/'.$employee_db_data["profile_pic"]); } $employee_documents = json_decode($employee_db_data["employee_documents"],true); if($request->hasFile('employee_documents')) { $files = $request->file('employee_documents'); $uploaded_files = array(); foreach($files as $file) { $file_extension = $file->getClientOriginalExtension(); $file_name_prefix = db_unique_id('employees',get_simple_unique_id('EMPD')); $file_true_name = $file_name_prefix.'.'.$file_extension; $file->move('uploads/employees/',$file_true_name); $employee_documents[] = $file_true_name; } } $db_array['employee_documents'] = json_encode($employee_documents); update_table('employees','uid',$uid,$db_array); $employee_account = fetch_table_where('accounts','employee_uid',$uid,true); if(!empty($employee_account)) { $account_db_array = array( 'name' => $db_array['name'], ); update_table('accounts','employee_uid',$uid,$account_db_array); update_table('assets','account',$employee_account['uid'],['account_name' => $request->name]); update_table('metu_purchases','supplier',$employee_account['uid'],['supplier_name' => $request->name]); update_table('metu_sales','client',$employee_account['uid'],['client_name' => $request->name]); update_table('metu_stock','account',$employee_account['uid'],['account_name' => $request->name]); update_table('tokens','account',$employee_account['uid'],['account_name' => $request->name]); update_table('tokens','client',$employee_account['uid'],['client_name' => $request->name]); update_table('item_stock_in','account',$employee_account['uid'],['account_name' => $request->name]); update_table('shareholder_credit','credit_account',$employee_account['uid'],['credit_account_name' => $request->name]); } else { $euid = getUniqueId('ACCT', 'accounts', 'uid'); $account_db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'name' => $db_array['name'], 'type' => 'employee', 'client_type' => 'general', 'code' => get_new_account_code(), 'memo' => 'employee account', 'employee_uid' => $uid, ); insert_table('accounts',$account_db_array); } echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'employee_updated'), 'message_body' => print_lang($this->data["app_lang"],'employee_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_employee') === FALSE){ Redirect::to('/')->send(); } delete_table('employees','uid',$uid); delete_table('accounts','employee_uid',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function delete_document(Request $request,$uid) { if(check_user_access('delete_department') === FALSE){ Redirect::to('/')->send(); } if(!empty($request->name)) { $employee_db_data = DB::table('employees')->where('uid',$uid)->get(); if($employee_db_data->count() > 0) { $employee_db_data = json_decode(json_encode($employee_db_data[0]),true); $employee_documents = json_decode($employee_db_data["employee_documents"],true); File::delete('uploads/employees/'.$request->name); $new_employee_documents = array(); foreach($employee_documents as $doc) { if($doc != $request->name){ $new_employee_documents[] = $doc; } } $new_employee_documents = json_encode($new_employee_documents); $db_array = array('employee_documents' => $new_employee_documents); update_table('employees','uid',$uid,$db_array); } } echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }