<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Expenses extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_expense') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $expenses = DB::table('expenses')->where('branch',$branch_id); if(!empty($request->currency)){ $expenses->where('currency',$request->currency); } if(!empty($request->type)){ $expenses->where('type',$request->type); } if(!empty($request->from)){ $expenses->where('exp_date','>=',get_true_date($request->from)); } if(!empty($request->to)){ $expenses->where('exp_date','<=',get_true_date($request->to)); } $expenses->where(function($query) use ($request){ $query->where('main_approval','pending')->orWhere('main_approval','approved'); }); $expenses = json_decode(json_encode($expenses->get()),true); $this->data["pageData"] = $expenses; $this->data["search_currency"] = $request->currency; $this->data["search_convert_currency"] = $request->convert_currency; $this->data["search_type"] = $request->type; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["expenses_types"] = set_array_keys(fetch_table_branch('expenses_types'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'expenses'); $this->data["pageToLoad"] = "expenses/view.php"; $this->data["activeLink"] = "expenses"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_expense') === FALSE){ Redirect::to('/')->send(); } $this->data["expenses_types"] = fetch_table_branch('expenses_types'); $this->data["currencies"] = fetch_currencies(); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'add_expenses'); $this->data["pageToLoad"] = "expenses/add.php"; $this->data["activeLink"] = "expenses"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'type' => 'required', 'exp_date' => 'required', 'account' => 'required', 'amount' => 'required', 'currency' => 'required', 'narration' => 'required', ]); $validator->validate(); $uid = getUniqueId('EXPE', 'expenses', 'uid'); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $expense_data = fetch_table_where('expenses_types','uid',$request->type,true); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'serial_id' => get_serial_id('expenses'), 'type' => $request->type, 'exp_date' => get_true_date($request->exp_date), 'account' => $request->account, 'amount' => $request->amount, 'currency' => $request->currency, 'currency_usd_equalance' => $currency_data['usd_equalance'], 'narration' => $request->narration, 'marketer' => $expense_data['marketer'], 'sub_approval' => user_approval_info('sub_approval'), 'sub_approval_user' => user_approval_info('sub_approval_user'), 'sub_approval_user_name' => user_approval_info('sub_approval_user_name'), 'main_approval' => user_approval_info('main_approval'), 'main_approval_user' => user_approval_info('main_approval_user'), 'main_approval_user_name' => user_approval_info('main_approval_user_name'), ); insert_table('expenses',$db_array); if(user_approval_info('main_approval') == 'approved') { _handle_expenses_ledger_effects(['uid' => $uid, 'state' => 'new']); } $expenses_types = set_array_keys(fetch_table_branch('expenses_types'),'uid'); $expenses_type_name = array_key_exists($db_array['type'],$expenses_types) ? $expenses_types[$db_array['type']]['name'] : NULL; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_expenses'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/expenses/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_type').': '.$expenses_type_name.', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['amount']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'expense_created'), 'message_body' => print_lang($this->data["app_lang"],'new_expense_created_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_expense') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('expenses','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/expenses')->send(); } $this->data["expenses_types"] = fetch_table_branch('expenses_types'); $this->data["currencies"] = fetch_currencies(); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'edit_expense'); $this->data["pageToLoad"] = "expenses/edit.php"; $this->data["activeLink"] = "expenses"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'type' => 'required', 'exp_date' => 'required', 'account' => 'required', 'amount' => 'required', 'currency' => 'required', 'narration' => 'required', ]); $validator->validate(); $expense_db_data = fetch_table_where('expenses','uid',$uid,true); $expense_data = fetch_table_where('expenses_types','uid',$request->type,true); $db_array = array( 'type' => $request->type, 'exp_date' => get_true_date($request->exp_date), 'account' => $request->account, 'amount' => $request->amount, 'currency' => $request->currency, 'narration' => $request->narration, 'marketer' => $expense_data['marketer'], ); update_table('expenses','uid',$uid,$db_array); if($expense_db_data['main_approval'] == 'approved') { _handle_expenses_ledger_effects(['uid' => $uid, 'state' => 'update']); } $expenses_types = set_array_keys(fetch_table_branch('expenses_types'),'uid'); $expenses_type_name = array_key_exists($db_array['type'],$expenses_types) ? $expenses_types[$db_array['type']]['name'] : NULL; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_expenses'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/expenses/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_type').': '.$expenses_type_name.', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['amount']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'expense_updated'), 'message_body' => print_lang($this->data["app_lang"],'expense_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_expense') === FALSE){ Redirect::to('/')->send(); } $expense_data = fetch_table_where('expenses','uid',$uid,true); $expenses_types = set_array_keys(fetch_table_branch('expenses_types'),'uid'); $expenses_type_name = array_key_exists($expense_data['type'],$expenses_types) ? $expenses_types[$expense_data['type']]['name'] : NULL; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_expenses'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_type').': '.$expenses_type_name.', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($expense_data['amount']), ); set_activity_alert($_activity_details); delete_table('expenses','uid',$uid); _handle_expenses_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }