<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; class Expenses_deductions extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_project_expenses_deductions') === FALSE){ Redirect::to('/')->send(); } $expenses_deductions = DB::table('expenses_deductions')->where('status','pending'); if(!empty($request->expense_type)){ $expenses_deductions->where('expenses_mood',$request->expense_type); } if(!empty($request->project_type)){ $expenses_deductions->where('expense_type',$request->project_type); } if(!empty($request->currency)){ $expenses_deductions->where('currency',$request->currency); } if(!empty($request->project)){ $expenses_deductions->where('project',$request->project); } if(!empty($request->user)){ $expenses_deductions->where('user',$request->user); } if(!empty($request->details)){ $expenses_deductions->where('comments','like','%'.$request->details.'%'); } if(!empty($request->from)){ $expenses_deductions->where('edate','>=',get_true_date($request->from)); } if(!empty($request->to)){ $expenses_deductions->where('edate','<=',get_true_date($request->to)); } $this->data["pageData"] = json_decode(json_encode($expenses_deductions->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["projects"] = set_array_keys(fetch_table_branch('projects'),'uid'); $this->data["users"] = set_array_keys(fetch_branch_users(),'uid'); $this->data["search_project_type"] = $request->project_type; $this->data["search_expense_type"] = $request->expense_type; $this->data["search_currency"] = $request->currency; $this->data["search_project"] = $request->project; $this->data["search_user"] = $request->user; $this->data["search_from"] = $request->from; $this->data["search_details"] = $request->details; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'expenses_deductions'); $this->data["pageToLoad"] = "expenses_deductions/view.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function approved_view(Request $request) { if(check_user_access('view_project_approved_expenses_deductions') === FALSE){ Redirect::to('/')->send(); } $expenses_deductions = DB::table('expenses_deductions')->where('status','approved'); if(!empty($request->expense_type)){ $expenses_deductions->where('expenses_mood',$request->expense_type); } if(!empty($request->project_type)){ $expenses_deductions->where('expense_type',$request->project_type); } if(!empty($request->currency)){ $expenses_deductions->where('currency',$request->currency); } if(!empty($request->project)){ $expenses_deductions->where('project',$request->project); } if(!empty($request->user)){ $expenses_deductions->where('user',$request->user); } if(!empty($request->details)){ $expenses_deductions->where('comments','like','%'.$request->details.'%'); } if(!empty($request->from)){ $expenses_deductions->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $expenses_deductions->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($expenses_deductions->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["projects"] = set_array_keys(fetch_table_branch('projects'),'uid'); $this->data["users"] = set_array_keys(fetch_branch_users(),'uid'); $this->data["search_project_type"] = $request->project_type; $this->data["search_expense_type"] = $request->expense_type; $this->data["search_currency"] = $request->currency; $this->data["search_project"] = $request->project; $this->data["search_user"] = $request->user; $this->data["search_details"] = $request->details; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'approved_expenses_deductions'); $this->data["pageToLoad"] = "expenses_deductions/approved_view.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function item_stats(Request $request, $uid) { if($request->ajax()) { $item_rel = get_item_related_for_expenses_deduction($this->data["app_lang"],$uid); echo json_encode($item_rel); } else { echo json_encode( array('status' => 'INVALID_REQUEST') ); } } public function add(Request $request) { if(check_user_access('add_project_expenses_deductions') === FALSE){ Redirect::to('/')->send(); } $this->data["projects"] = set_array_keys(fetch_table_where_branch('projects','status','pending'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["users"] = fetch_branch_users(); $this->data["title"] = print_lang($this->data["app_lang"],'add_expense_deduction'); $this->data["pageToLoad"] = "expenses_deductions/add.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), ['expenses_mood' => 'required']); $validator->sometimes('currency',['required'],function($input){ return ($input->expenses_mood == 'cash_expenses'); } ); $validator->sometimes('amount',['required'],function($input){ return ($input->expenses_mood == 'cash_expenses'); } ); $validator->sometimes('cash_date',['required'],function($input){ return ($input->expenses_mood == 'cash_expenses'); } ); $validator->sometimes('expense_type',['required'],function($input){ return ($input->expenses_mood == 'cash_expenses'); } ); $validator->sometimes('project',['required'],function($input){ return ($input->expenses_mood == 'cash_expenses'); } ); $validator->sometimes('account',['required'],function($input){ return ($input->expenses_mood == 'cash_expenses'); } ); $validator->sometimes('inv_project',['required'],function($input){ return ($input->expenses_mood == 'inventory_expenses'); } ); $validator->sometimes('inv_date',['required'],function($input){ return ($input->expenses_mood == 'inventory_expenses'); } ); $validator->sometimes('inv_item',['required'],function($input){ return ($input->expenses_mood == 'inventory_expenses'); } ); $validator->sometimes('inv_warehouse',['required'],function($input){ return ($input->expenses_mood == 'inventory_expenses'); } ); $validator->sometimes('inv_unit',['required'],function($input){ return ($input->expenses_mood == 'inventory_expenses'); } ); $validator->sometimes('inv_qty',['required'],function($input){ return ($input->expenses_mood == 'inventory_expenses'); } ); $validator->validate(); $uid = getUniqueId('PEDT', 'expenses_deductions', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'expenses_mood' => $request->expenses_mood, 'deduction_type' => 'project', 'comments' => $request->comments, ); if($request->expenses_mood == 'cash_expenses') { $currency_data = fetch_table_where('currency','uid',$request->currency,true); $db_array['currency'] = $request->currency; $db_array['currency_usd_equalance'] = $currency_data['usd_equalance']; $db_array['amount'] = $request->amount; $db_array['edate'] = get_true_date($request->cash_date); $db_array['expense_type'] = $request->expense_type; $db_array['project'] = $request->project; $db_array['project_according_amount'] = $request->project_according_amount; $db_array['account'] = $request->account; $db_array['user'] = empty($request->supervisor) ? Session::get('user_id') : $request->supervisor; if($request->hasFile('scan_copy')) { $file = $request->file('scan_copy'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('PPDI'); $fileNamePrefix = db_unique_id('expenses_deductions',$fileNamePrefix); $scan_copy = $fileNamePrefix.'.'.$extension; $file->move('uploads/expenses-deductions/',$scan_copy); $db_array['scan_copy'] = $scan_copy; } } if($request->expenses_mood == 'inventory_expenses') { $project_data = fetch_table_where('projects','uid',$request->inv_project,true); $db_array['project'] = $request->inv_project; $db_array['currency'] = $project_data['currency']; $db_array['currency_usd_equalance'] = $project_data['currency_usd_equalance']; $db_array['edate'] = get_true_date($request->inv_date); $db_array['item'] = $request->inv_item; $db_array['warehouse'] = $request->inv_warehouse; $db_array['unit'] = $request->inv_unit; $db_array['qty'] = $request->inv_qty; $db_array['amount'] = $request->inv_total_amount; $db_array['project_according_amount'] = $request->inv_total_amount; $db_array['item_avg_cost_usd'] = $request->inv_avg_cost_usd; $db_array['user'] = empty($request->inv_supervisor) ? Session::get('user_id') : $request->inv_supervisor; } insert_table('expenses_deductions',$db_array); _handle_expense_deduction_ledger_effects(['uid' => $uid, 'state' => 'new']); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'deduction_saved'), 'message_body' => print_lang($this->data["app_lang"],'deduction_saved_successfully'))); } public function edit(Request $request, $uid) { $this->data["editing_data"] = fetch_table_where('expenses_deductions','uid',$uid,true); $this->data["projects"] = set_array_keys(fetch_table_where_branch('projects','status','pending'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["users"] = fetch_branch_users(); $this->data["item_helpers"] = get_item_related_for_expenses_deduction($this->data["app_lang"],$this->data["editing_data"]['item']); $this->data["title"] = print_lang($this->data["app_lang"],'edit_expense_deduction'); $this->data["pageToLoad"] = "expenses_deductions/edit.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), ['expenses_mood' => 'required']); $validator->sometimes('currency',['required'],function($input){ return ($input->expenses_mood == 'cash_expenses'); } ); $validator->sometimes('amount',['required'],function($input){ return ($input->expenses_mood == 'cash_expenses'); } ); $validator->sometimes('cash_date',['required'],function($input){ return ($input->expenses_mood == 'cash_expenses'); } ); $validator->sometimes('expense_type',['required'],function($input){ return ($input->expenses_mood == 'cash_expenses'); } ); $validator->sometimes('project',['required'],function($input){ return ($input->expenses_mood == 'cash_expenses'); } ); $validator->sometimes('account',['required'],function($input){ return ($input->expenses_mood == 'cash_expenses'); } ); $validator->sometimes('inv_project',['required'],function($input){ return ($input->expenses_mood == 'inventory_expenses'); } ); $validator->sometimes('inv_date',['required'],function($input){ return ($input->expenses_mood == 'inventory_expenses'); } ); $validator->sometimes('inv_item',['required'],function($input){ return ($input->expenses_mood == 'inventory_expenses'); } ); $validator->sometimes('inv_warehouse',['required'],function($input){ return ($input->expenses_mood == 'inventory_expenses'); } ); $validator->sometimes('inv_unit',['required'],function($input){ return ($input->expenses_mood == 'inventory_expenses'); } ); $validator->sometimes('inv_qty',['required'],function($input){ return ($input->expenses_mood == 'inventory_expenses'); } ); $validator->validate(); $db_array = array( 'expenses_mood' => $request->expenses_mood, 'comments' => $request->comments, ); if($request->expenses_mood == 'cash_expenses') { $currency_data = fetch_table_where('currency','uid',$request->currency,true); $db_array['currency'] = $request->currency; $db_array['currency_usd_equalance'] = $currency_data['usd_equalance']; $db_array['amount'] = $request->amount; $db_array['edate'] = get_true_date($request->cash_date); $db_array['expense_type'] = $request->expense_type; $db_array['project'] = $request->project; $db_array['project_according_amount'] = $request->project_according_amount; $db_array['account'] = $request->account; $db_array['user'] = $request->supervisor; $project_data = fetch_table_where('expenses_deductions','uid',$uid,TRUE); if($request->hasFile('scan_copy')) { $file = $request->file('scan_copy'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('PIMG'); $fileNamePrefix = db_unique_id('expenses_deductions',$fileNamePrefix); $scan_copy = $fileNamePrefix.'.'.$extension; $file->move('uploads/expenses-deductions/',$scan_copy); $db_array['scan_copy'] = $scan_copy; File::delete('uploads/expenses-deductions/'.$project_data["scan_copy"]); } } if($request->expenses_mood == 'inventory_expenses') { $project_data = fetch_table_where('projects','uid',$request->inv_project,true); $db_array['project'] = $request->inv_project; $db_array['currency'] = $project_data['currency']; $db_array['currency_usd_equalance'] = $project_data['currency_usd_equalance']; $db_array['edate'] = get_true_date($request->inv_date); $db_array['item'] = $request->inv_item; $db_array['warehouse'] = $request->inv_warehouse; $db_array['unit'] = $request->inv_unit; $db_array['qty'] = $request->inv_qty; $db_array['amount'] = $request->inv_total_amount; $db_array['project_according_amount'] = $request->inv_total_amount; $db_array['item_avg_cost_usd'] = $request->inv_avg_cost_usd; $db_array['user'] = $request->inv_supervisor; } $data_before_update = fetch_table_where('expenses_deductions','uid',$uid,true); update_table('expenses_deductions','uid',$uid,$db_array); $data_after_update = fetch_table_where('expenses_deductions','uid',$uid,true); _handle_expense_deduction_ledger_effects(['uid' => $uid, 'state' => 'update']); if($data_after_update['status'] == 'approved') { $_items_effected = array(); if(isset($db_array['item'])){ $_items_effected[] = $db_array['item']; } if(!empty($data_before_update['item'])){ $_items_effected[] = $data_before_update['item']; } $_items_effected = (count($_items_effected) > 0) ? array_unique($_items_effected) : array(); foreach($_items_effected as $item_uid){ _handle_item_stats(['uid' => $item_uid]); } } echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'deduction_updated'), 'message_body' => print_lang($this->data["app_lang"],'deduction_updated_successfully'))); } public function delete($uid) { $project = fetch_table_where('expenses_deductions','uid',$uid,TRUE); if(!empty($project["scan_copy"])){ File::delete('uploads/expenses-deductions/'.$project["scan_copy"]); } delete_table('expenses_deductions','uid',$uid); _handle_expense_deduction_ledger_effects(['uid' => $uid, 'state' => 'delete']); if(!empty($project['item']) AND $project['status'] == 'approved') { _handle_item_stats(['uid' => $project['item']]); } echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function delete_all(Request $request) { $uids = $request->uids; $uids = explode(',',$uids); foreach($uids as $uid) { $project = fetch_table_where('expenses_deductions','uid',$uid,TRUE); if(!empty($project["scan_copy"])){ File::delete('uploads/expenses-deductions/'.$project["scan_copy"]); } delete_table('expenses_deductions','uid',$uid); _handle_expense_deduction_ledger_effects(['uid' => $uid, 'state' => 'delete']); if(!empty($project['item']) AND $project['status'] == 'approved') { _handle_item_stats(['uid' => $project['item']]); } } echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function approve($uid) { if(check_user_access('approve_project_expenses_deductions') === FALSE){ Redirect::to('/')->send(); } update_table('expenses_deductions','uid',$uid,array('status' => 'approved')); $expenses_deduction = fetch_table_where('expenses_deductions','uid',$uid,TRUE); if(!empty($expenses_deduction['item'])) { _handle_item_stats(['uid' => $expenses_deduction['item']]); } _handle_expense_deduction_ledger_effects(['uid' => $uid, 'state' => 'new']); echo json_encode(array('status' => 'success', 'mode' => 'approved')); } public function approved_all(Request $request) { if(check_user_access('approve_project_expenses_deductions') === FALSE){ Redirect::to('/')->send(); } $uids = $request->uids; $uids = explode(',',$uids); foreach($uids as $uid) { update_table('expenses_deductions','uid',$uid,array('status' => 'approved')); $expenses_deduction = fetch_table_where('expenses_deductions','uid',$uid,TRUE); if(!empty($expenses_deduction['item'])) { _handle_item_stats(['uid' => $expenses_deduction['item']]); } } echo json_encode(array('status' => 'success', 'mode' => 'approved')); } public function disapprove($uid) { if(check_user_access('disapprove_project_approved_expenses_deductions') === FALSE){ Redirect::to('/')->send(); } update_table('expenses_deductions','uid',$uid,array('status' => 'pending')); $expenses_deduction = fetch_table_where('expenses_deductions','uid',$uid,TRUE); if(!empty($expenses_deduction['item'])) { _handle_item_stats(['uid' => $expenses_deduction['item']]); } echo json_encode(array('status' => 'success', 'mode' => 'pending')); } public function disapprove_all(Request $request) { if(check_user_access('disapprove_project_approved_expenses_deductions') === FALSE){ Redirect::to('/')->send(); } $uids = $request->uids; $uids = explode(',',$uids); foreach($uids as $uid) { update_table('expenses_deductions','uid',$uid,array('status' => 'pending')); $expenses_deduction = fetch_table_where('expenses_deductions','uid',$uid,TRUE); if(!empty($expenses_deduction['item'])) { _handle_item_stats(['uid' => $expenses_deduction['item']]); } } echo json_encode(array('status' => 'success', 'mode' => 'pending')); } }