<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Expenses_types extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_expense_type') === FALSE){ Redirect::to('/')->send(); } $this->data["pageData"] = fetch_table_branch('expenses_types'); $this->data["title"] = print_lang($this->data["app_lang"],'expenses_types'); $this->data["pageToLoad"] = "expenses_types/view.php"; $this->data["activeLink"] = "expenses"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_expense_type') === FALSE){ Redirect::to('/')->send(); } $this->data["title"] = print_lang($this->data["app_lang"],'add_expense_type'); $this->data["pageToLoad"] = "expenses_types/add.php"; $this->data["activeLink"] = "expenses"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', ]); $validator->validate(); $uid = getUniqueId('EXPT', 'expenses_types', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'name' => $request->name, 'color' => $request->color, 'marketer' => $request->marketer, ); insert_table('expenses_types',$db_array); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'expense_type_created'), 'message_body' => print_lang($this->data["app_lang"],'expense_type_created_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_expense_type') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('expenses_types','uid',$uid,true); $this->data["title"] = print_lang($this->data["app_lang"],'edit_expense_type'); $this->data["pageToLoad"] = "expenses_types/edit.php"; $this->data["activeLink"] = "expenses"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', ]); $validator->validate(); $db_array = array( 'name' => $request->name, 'color' => $request->color, 'marketer' => $request->marketer, ); update_table('expenses_types','uid',$uid,$db_array); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'expense_type_updated'), 'message_body' => print_lang($this->data["app_lang"],'expense_type_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_expense_type') === FALSE){ Redirect::to('/')->send(); } delete_table('expenses_types','uid',$uid); $expenses_of_this_type = fetch_table_where_branch('expenses','type',$uid); foreach($expenses_of_this_type as $row) { _handle_expenses_ledger_effects(['uid' => $row['uid'], 'state' => 'delete']); } delete_table('expenses','type',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }