<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Extra_income extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_extra_income') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $extra_income = DB::table('extra_income')->where('branch',$branch_id); if(!empty($request->currency)){ $extra_income->where('currency',$request->currency); } if(!empty($request->type)){ $extra_income->where('type',$request->type); } if(!empty($request->account)){ $extra_income->where('account',$request->account); } if(!empty($request->from)){ $extra_income->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $extra_income->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $extra_income = $extra_income->get(); $extra_income = json_decode(json_encode($extra_income),true); $this->data["pageData"] = $extra_income; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_table_branch('accounts'),'uid'); $this->data["extra_income_type"] = set_array_keys(fetch_table_branch('extra_income_type'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_type"] = $request->type; $this->data["search_convert_currency"] = $request->convert_currency; $this->data["search_account"] = $request->account; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'extra_income'); $this->data["pageToLoad"] = "extra_income/view.php"; $this->data["activeLink"] = "extra_income"; $this->load_view($this->data); } public function invoice(Request $request, $uid) { if(check_user_access('add_production') === FALSE){ Redirect::to('/')->send(); } $this->data["invoice_data"] = fetch_table_where('production','uid',$uid,true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["items"] = set_array_keys(get_items_for_production(),'uid'); $this->data["batch"] = set_array_keys(fetch_table_branch('batch'),'uid'); $this->data["expenses"] = set_array_keys(fetch_table_where_branch('accounts','type','expense'),'uid'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'production_invoice'); $this->data["pageToLoad"] = "production/invoice.php"; $this->data["activeLink"] = "production"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_extra_income') === FALSE){ Redirect::to('/')->send(); } $this->data["currencies"] = fetch_currencies(); $this->data["accounts"] = fetch_table_branch('accounts'); $this->data["extra_income_type"] = fetch_table_branch('extra_income_type'); $this->data["title"] = print_lang($this->data["app_lang"],'add_extra_income'); $this->data["pageToLoad"] = "extra_income/add.php"; $this->data["activeLink"] = "extra_income"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'account' => 'required', 'amount' => 'required', 'type' => 'required', ]); $validator->validate(); $uid = getUniqueId('EXTIC', 'extra_income', 'uid'); $currency_db_data = fetch_table_where('currency','uid',$request->currency,true); $type_data = fetch_table_where('extra_income_type','uid',$request->type,true); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'serial_id' => get_serial_id('extra_income'), 'type' => $request->type, 'type_name' => isset($type_data['name']) ? $type_data['name'] : null, 'currency' => $request->currency, 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'account' => $request->account, 'amount' => $request->amount, 'description' => $request->description, 'created_at' => get_true_date( empty($request->edate) ? date('y-m-d') : $request->edate ), ); insert_table('extra_income',$db_array); _handle_extra_income_ledger_effects(['uid' => $uid, 'state' => 'new']); $accounts = set_array_keys(fetch_all_accounts(),'uid'); $payment_account_name = array_key_exists($db_array['account'],$accounts) ? $accounts[$db_array['account']]['name'] : NULL; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_extra_income'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/extra-income/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_account').': '.$payment_account_name.', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['amount']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'extra_income_added'), 'message_body' => print_lang($this->data["app_lang"],'new_extra_income_added_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_extra_income') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('extra_income','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/extra-income')->send(); } $this->data["currencies"] = fetch_currencies(); $this->data["accounts"] = fetch_table_branch('accounts'); $this->data["extra_income_type"] = fetch_table_branch('extra_income_type'); $this->data["title"] = print_lang($this->data["app_lang"],'edit_extra_income'); $this->data["pageToLoad"] = "extra_income/edit.php"; $this->data["activeLink"] = "extra_income"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'account' => 'required', 'amount' => 'required', 'type' => 'required', ]); $validator->validate(); $currency_db_data = fetch_table_where('currency','uid',$request->currency,true); $type_data = fetch_table_where('extra_income_type','uid',$request->type,true); $db_array = array( 'type' => $request->type, 'type_name' => isset($type_data['name']) ? $type_data['name'] : null, 'currency' => $request->currency, 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'account' => $request->account, 'amount' => $request->amount, 'description' => $request->description, 'created_at' => get_true_date( empty($request->edate) ? date('y-m-d') : $request->edate ), ); update_table('extra_income','uid',$uid,$db_array); _handle_extra_income_ledger_effects(['uid' => $uid, 'state' => 'update']); $accounts = set_array_keys(fetch_all_accounts(),'uid'); $payment_account_name = array_key_exists($db_array['account'],$accounts) ? $accounts[$db_array['account']]['name'] : NULL; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_extra_income'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/extra-income/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_account').': '.$payment_account_name.', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['amount']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'extra_income_updated'), 'message_body' => print_lang($this->data["app_lang"],'extra_income_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_extra_income') === FALSE){ Redirect::to('/')->send(); } $extra_income_data = fetch_table_where('extra_income','uid',$uid,true); $accounts = set_array_keys(fetch_all_accounts(),'uid'); $payment_account_name = array_key_exists($extra_income_data['account'],$accounts) ? $accounts[$extra_income_data['account']]['name'] : NULL; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_extra_income'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_account').': '.$payment_account_name.', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($extra_income_data['amount']), ); set_activity_alert($_activity_details); delete_table('extra_income','uid',$uid); _handle_extra_income_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function item_details(Request $request) { $item = $request->item; $avail_units = $request->avail_units; $avg_cost = $request->avg_cost; $first_cost = $request->first_cost; $output_array = array( 'status' => 'success', 'avail_units' => 0, 'avg_cost' => 0, 'first_cost' => 0, ); $item_data = fetch_table_where('items','uid',$item,true); if($avail_units == 'yes') { $output_array['avail_units'] = unit_based_conversion($item_data,'production',get_item_avail_units($item)); } if($avg_cost == 'yes') { $output_array['avg_cost'] = unit_based_conversion($item_data,'production',get_item_avg_cost($item)); } if($first_cost == 'yes') { $output_array['first_cost'] = unit_based_conversion($item_data,'production',get_item_first_cost($item)); } echo json_encode($output_array); } }