<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; class Fixing_expenses extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_purchase') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $fixing_expenses = DB::table('fixing_expenses')->where('branch',$branch_id); if(!empty($request->currency)){ $fixing_expenses->where('currency',$request->currency); } if(!empty($request->agent)){ $fixing_expenses->where('agent',$request->agent); } if(!empty($request->from)){ $fixing_expenses->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $fixing_expenses->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($fixing_expenses->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["cars"] = set_array_keys(fetch_table_branch('car_purchases_details'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_agent"] = $request->agent; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'fixing_expenses'); $this->data["pageToLoad"] = "fixing_expenses/view.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function invoice(Request $request,$uid) { if(check_user_access('invoice_shor_fixing_expenses') === FALSE){ Redirect::to('/')->send(); } $this->data["invoice_data"] = fetch_table_where('fixing_expenses','uid',$uid,true); $this->data["invoice_details"] = fetch_table_where('fixing_expenses_details','parent_id',$this->data["invoice_data"]['uid']); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["cars"] = set_array_keys(fetch_table_branch('car_purchases_details'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'fixing_expenses_invoice'); $this->data["pageToLoad"] = "fixing_expenses/invoice.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_shor_fixing_expenses') === FALSE){ Redirect::to('/')->send(); } $this->data["currencies"] = fetch_currencies(); $this->data["accounts"] = fetch_nested_accounts(); $this->data["cars"] = fetch_table_branch('car_purchases_details'); $this->data["title"] = print_lang($this->data["app_lang"],'new_fixing_expenses'); $this->data["pageToLoad"] = "fixing_expenses/add.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function save(Request $request) { $items_found = false; $active_branch_id = active_branch_id(); $invoice_num = isset($request->invoice[0]) ? $request->invoice[0] : generate_uid(); $invoice_num_exist = DB::table('fixing_expenses')->where('invoice',$invoice_num)->get(); if($invoice_num_exist->count() > 0) { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => 'Invoice Exist', 'message_body' => 'This invoice number already exist.')); die; } $currency = isset($request->currency[0]) ? $request->currency[0] : 'usd'; $currency_rate = isset($request->rate[0]) ? $request->rate[0] : 1; $agent = isset($request->agent[0]) ? $request->agent[0] : NULL; $uid = getUniqueId('FEXP', 'fixing_expenses', 'uid'); $items_count = 0; $cars_uids = array(); if(is_array($request->car) AND count($request->car) > 0) { while($items_count < count($request->car)) { if(empty($request->car[$items_count])){ continue; } $row_car_uid = getUniqueId('FXPD', 'fixing_expenses_details', 'uid'); $car_db_array = array( 'uid' => $row_car_uid, 'branch' => $active_branch_id, 'parent_id' => $uid, 'currency' => $currency, 'currency_usd_equalance' => $currency_rate, 'invoice' => $invoice_num, 'car' => $request->car[$items_count], 'amount' => $request->amount[$items_count], 'details' => $request->details[$items_count], ); $car_data = fetch_table_where('car_purchases_details','uid',$car_db_array['car'],true); if(is_array($car_data) AND isset($car_data['uid'])) { $purchase_data = fetch_table_where('car_purchases','uid',$car_data['purchase_id'],true); $purchase_currency_usd_equalance = isset($purchase_data['currency_usd_equalance']) ? $purchase_data['currency_usd_equalance'] : 1; $fixing_expenses = (float)$car_db_array['amount']; $fixing_expenses = amount_conversion($fixing_expenses, $car_db_array['currency_usd_equalance'], $purchase_currency_usd_equalance); $car_db_array['per_car_expenses'] = $fixing_expenses; $car_existing_expenses = (float)$car_data['fixing_expenses']; $car_new_expenses = $car_existing_expenses + $fixing_expenses; update_table('car_purchases_details','uid',$car_data['uid'],array('fixing_expenses' => $car_new_expenses)); } insert_table('fixing_expenses_details',$car_db_array); $cars_uids[] = $row_car_uid; $items_found = true; $items_count++; } } if($items_found == true) { $db_array = array( 'uid' => $uid, 'branch' => $active_branch_id, 'currency' => $currency, 'currency_usd_equalance' => $currency_rate, 'invoice' => $invoice_num, 'agent' => $agent, 'total_amount' => $request->total_amount, 'cars' => implode('-,-', $cars_uids), ); insert_table('fixing_expenses',$db_array); _handle_fixing_expenses_ledger_effects(['uid' => $uid, 'state' => 'new']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_fixing_expenses'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/fixing-expenses/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['total_amount']), ); set_activity_alert($_activity_details); $invoice_url = url('/fixing-expenses/invoice').'/'.$uid; echo json_encode(array('status' => 'success', 'mood' => 'new', 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'fixing_expenses_saved'), 'message_body' => print_lang($this->data["app_lang"],'fixing_expenses_saved_successfully'))); } else { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'item_not_found'), 'message_body' => print_lang($this->data["app_lang"],'add_items_to_proceed'))); } } public function edit(Request $request, $uid) { if(check_user_access('edit_shor_fixing_expenses') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('fixing_expenses','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/fixing-expenses')->send(); } $this->data["invoice_details"] = fetch_table_where('fixing_expenses_details','parent_id',$this->data["editing_data"]['uid']); $this->data["currencies"] = fetch_currencies(); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["cars"] = set_array_keys(fetch_table_branch('car_purchases_details'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'edit_fixing_expenses'); $this->data["pageToLoad"] = "fixing_expenses/edit.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function update(Request $request, $uid) { $items_found = false; $active_branch_id = active_branch_id(); $invoice_num = isset($request->invoice[0]) ? $request->invoice[0] : generate_uid(); $invoice_num_exist = DB::table('fixing_expenses')->where('uid','!=',$uid)->where('invoice',$invoice_num)->get(); if($invoice_num_exist->count() > 0) { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => 'Invoice Exist', 'message_body' => 'This invoice number already exist.')); die; } $currency = isset($request->currency[0]) ? $request->currency[0] : 'usd'; $currency_rate = isset($request->rate[0]) ? $request->rate[0] : 1; $agent = isset($request->agent[0]) ? $request->agent[0] : NULL; if(is_array($request->deleted) AND count($request->deleted) > 0) { foreach($request->deleted as $item_id) { $fixing_expense_data = fetch_table_where('fixing_expenses_details','uid',$item_id,true); $expenses_before_update = (float)$fixing_expense_data["per_car_expenses"]; $car_data = fetch_table_where('car_purchases_details','uid',$fixing_expense_data['car'],true); if(is_array($car_data) AND isset($car_data['uid'])) { $car_existing_expenses = (float)$car_data['fixing_expenses']; $car_new_expenses = $car_existing_expenses - $expenses_before_update; update_table('car_purchases_details','uid',$car_data['uid'],array('fixing_expenses' => $car_new_expenses)); } delete_table('fixing_expenses_details','uid',$item_id); } } $items_count = 0; $cars_uids = array(); if(is_array($request->car) AND count($request->car) > 0) { while($items_count < count($request->car)) { if(empty($request->car[$items_count])){ continue; } $car_db_array = array( 'currency' => $currency, 'currency_usd_equalance' => $currency_rate, 'invoice' => $invoice_num, 'car' => $request->car[$items_count], 'amount' => (float)$request->amount[$items_count], 'details' => $request->details[$items_count], ); $expenses_before_update = 0; if($request->mode[$items_count] == 'existing') { $fixing_expense_data = fetch_table_where('fixing_expenses_details','uid',$request->uid[$items_count],true); $expenses_before_update = (float)$fixing_expense_data["per_car_expenses"]; } $car_data = fetch_table_where('car_purchases_details','uid',$car_db_array['car'],true); if(is_array($car_data) AND isset($car_data['uid'])) { $purchase_data = fetch_table_where('car_purchases','uid',$car_data['purchase_id'],true); $purchase_currency_usd_equalance = isset($purchase_data['currency_usd_equalance']) ? $purchase_data['currency_usd_equalance'] : 1; $fixing_expenses = (float)$car_db_array['amount']; $fixing_expenses = amount_conversion($fixing_expenses, $car_db_array['currency_usd_equalance'], $purchase_currency_usd_equalance); $car_db_array['per_car_expenses'] = $fixing_expenses; $car_existing_expenses = (float)$car_data['fixing_expenses']; $car_new_expenses = $car_existing_expenses + $fixing_expenses; $car_new_expenses = $car_new_expenses - $expenses_before_update; update_table('car_purchases_details','uid',$car_data['uid'],array('fixing_expenses' => $car_new_expenses)); } if($request->mode[$items_count] == 'existing') { $row_car_uid = $request->uid[$items_count]; update_table('fixing_expenses_details','uid',$request->uid[$items_count],$car_db_array); } else { $row_car_uid = getUniqueId('FXPD', 'fixing_expenses_details', 'uid'); $car_db_array['uid'] = $row_car_uid; $car_db_array['branch'] = $active_branch_id; $car_db_array['parent_id'] = $uid; insert_table('fixing_expenses_details',$car_db_array); } $cars_uids[] = $row_car_uid; $items_found = true; $items_count++; } } if($items_found == true) { $db_array = array( 'currency' => $currency, 'currency_usd_equalance' => $currency_rate, 'invoice' => $invoice_num, 'agent' => $agent, 'total_amount' => $request->total_amount, 'cars' => implode('-,-', $cars_uids), ); update_table('fixing_expenses','uid',$uid,$db_array); _handle_fixing_expenses_ledger_effects(['uid' => $uid, 'state' => 'update']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_fixing_expenses'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/fixing-expenses/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['total_amount']), ); set_activity_alert($_activity_details); $invoice_url = url('/fixing-expenses/invoice').'/'.$uid; echo json_encode(array('status' => 'success', 'mood' => 'update', 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'fixing_expenses_updated'), 'message_body' => print_lang($this->data["app_lang"],'fixing_expenses_updated_successfully'))); } else { echo json_encode(array('status' => 'error', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'item_not_found'), 'message_body' => print_lang($this->data["app_lang"],'add_items_to_proceed'))); } } public function delete($uid) { if(check_user_access('delete_shor_fixing_expenses') === FALSE){ Redirect::to('/')->send(); } $fixing_expenses_data = fetch_table_where('fixing_expenses','uid',$uid,true); $fixing_expenses_details_data = fetch_table_where('fixing_expenses_details','parent_id',$uid); foreach($fixing_expenses_details_data as $fixing_expense_data) { $expenses_before_update = (float)$fixing_expense_data["per_car_expenses"]; $car_data = fetch_table_where('car_purchases_details','uid',$fixing_expense_data['car'],true); if(is_array($car_data) AND isset($car_data['uid'])) { $car_existing_expenses = (float)$car_data['fixing_expenses']; $car_new_expenses = $car_existing_expenses - $expenses_before_update; update_table('car_purchases_details','uid',$car_data['uid'],array('fixing_expenses' => $car_new_expenses)); } } $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_fixing_expenses'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$fixing_expenses_data['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($fixing_expenses_data['total_amount']), ); set_activity_alert($_activity_details); delete_table('fixing_expenses','uid',$uid); delete_table('fixing_expenses_details','parent_id',$uid); _handle_fixing_expenses_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }