<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Fixing_expenses_old extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_purchase') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $fixing_expenses = DB::table('fixing_expenses')->where('branch',$branch_id); if(!empty($request->currency)){ $fixing_expenses->where('currency',$request->currency); } if(!empty($request->agent)){ $fixing_expenses->where('agent',$request->agent); } if(!empty($request->from)){ $fixing_expenses->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $fixing_expenses->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($fixing_expenses->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["car_purchases_details"] = set_array_keys(fetch_table_branch('car_purchases_details'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_agent"] = $request->agent; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'fixing_expenses'); $this->data["pageToLoad"] = "fixing_expenses/view.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function invoice(Request $request,$uid) { if(check_user_access('add_purchase') === FALSE){ Redirect::to('/')->send(); } $this->data["invoice_data"] = fetch_table_where('car_purchases','uid',$uid,true); $this->data["invoice_details"] = fetch_table_where('car_purchases_details','purchase_id',$this->data["invoice_data"]['uid']); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'car_purchase_invoice'); $this->data["pageToLoad"] = "fixing_expenses/invoice.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_purchase') === FALSE){ Redirect::to('/')->send(); } $this->data["accounts"] = fetch_nested_accounts(); $this->data["currencies"] = fetch_currencies(); $this->data["car_purchases_details"] = fetch_table_branch('car_purchases_details'); $this->data["title"] = print_lang($this->data["app_lang"],'new_fixing_expenses'); $this->data["pageToLoad"] = "fixing_expenses/add.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'rate' => 'required', 'invoice' => 'required|unique:fixing_expenses', 'car' => 'required', 'agent' => 'required', 'amount' => 'required', ]); $validator->validate(); $uid = getUniqueId('FEXP', 'fixing_expenses', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'currency' => $request->currency, 'currency_usd_equalance' => $request->rate, 'invoice' => $request->invoice, 'car' => $request->car, 'agent' => $request->agent, 'amount' => (float)$request->amount, 'details' => $request->details, ); insert_table('fixing_expenses',$db_array); $_activity_details = array( 'module' => 'fixing_expenses', 'activity' => 'added', 'url' => '/fixing-expenses/edit/'.$db_array['uid'], 'details' => 'Invoice #'.$db_array['invoice'].', Amount: '.amount_number_format($db_array['amount']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'fixing_expenses_saved'), 'message_body' => print_lang($this->data["app_lang"],'fixing_expenses_saved_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_purchase') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('fixing_expenses','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/fixing-expenses')->send(); } $this->data["accounts"] = fetch_nested_accounts(); $this->data["currencies"] = fetch_currencies(); $this->data["car_purchases_details"] = fetch_table_branch('car_purchases_details'); $this->data["title"] = print_lang($this->data["app_lang"],'edit_fixing_expenses'); $this->data["pageToLoad"] = "fixing_expenses/edit.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'rate' => 'required', 'invoice' => ['required',Rule::unique('fixing_expenses')->ignore($uid, 'uid')], 'car' => 'required', 'agent' => 'required', 'amount' => 'required', ]); $validator->validate(); $db_array = array( 'currency' => $request->currency, 'currency_usd_equalance' => $request->rate, 'invoice' => $request->invoice, 'car' => $request->car, 'agent' => $request->agent, 'amount' => (float)$request->amount, 'details' => $request->details, ); update_table('fixing_expenses','uid',$uid,$db_array); $_activity_details = array( 'module' => 'fixing_expenses', 'activity' => 'updated', 'url' => '/fixing-expenses/edit/'.$uid, 'details' => 'Invoice # '.$db_array['invoice'].', Amount: '.amount_number_format($db_array['amount']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'fixing_expenses_updated'), 'message_body' => print_lang($this->data["app_lang"],'fixing_expenses_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_purchase') === FALSE){ Redirect::to('/')->send(); } $load_data = fetch_table_where('fixing_expenses','uid',$uid,true); $_activity_details = array( 'module' => 'fixing_expenses', 'activity' => 'deleted', 'url' => NULL, 'details' => 'Invoice # '.$load_data['invoice'].', Amount: '.amount_number_format($load_data['amount']), ); set_activity_alert($_activity_details); delete_table('fixing_expenses','uid',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }