<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Item_stock extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { $this->data["pageData"] = fetch_table_branch('item_stock'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_stock_item_view_title'); $this->data["pageToLoad"] = "item_stock/view.php"; $this->data["activeLink"] = "stock"; $this->load_view($this->data); } public function add(Request $request) { $this->data["currencies"] = fetch_currencies(); $this->data["title"] = print_lang($this->data["app_lang"],'mod_stock_item_add_title'); $this->data["pageToLoad"] = "item_stock/add.php"; $this->data["activeLink"] = "stock"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'currency' => 'required', 'unit' => 'required', ]); $validator->validate(); $uid = getUniqueId('ITM', 'item_stock', 'uid'); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'name' => $request->name, 'currency' => $request->currency, 'currency_name' => isset($currency_data['name']) ? $currency_data['name'] : null, 'currency_symbol' => isset($currency_data['symbol']) ? $currency_data['symbol'] : null, 'unit' => $request->unit, ); insert_table('item_stock',$db_array); handle_item_stock_stats($uid); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'mod_stock_item_added'), 'message_body' => print_lang($this->data["app_lang"],'mod_stock_item_save_successfully'))); } public function edit(Request $request, $uid) { $this->data["editing_data"] = fetch_table_where('item_stock','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/item-stock')->send(); } $this->data["currencies"] = fetch_currencies(); $this->data["title"] = print_lang($this->data["app_lang"],'mod_stock_item_edit_title'); $this->data["pageToLoad"] = "item_stock/edit.php"; $this->data["activeLink"] = "stock"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'currency' => 'required', 'unit' => 'required', ]); $validator->validate(); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'name' => $request->name, 'currency' => $request->currency, 'currency_name' => isset($currency_data['name']) ? $currency_data['name'] : null, 'currency_symbol' => isset($currency_data['symbol']) ? $currency_data['symbol'] : null, 'unit' => $request->unit, ); update_table('item_stock','uid',$uid,$db_array); handle_item_stock_stats($uid); update_table('item_stock_out','item',$uid,['item_name' => $request->item]); update_table('item_stock_balance','item',$uid,['item_name' => $request->item]); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'mod_stock_item_update'), 'message_body' => print_lang($this->data["app_lang"],'mod_stock_item_update_successfully'))); } public function delete($uid) { delete_table('item_stock','uid',$uid); handle_item_stock_stats($uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }