<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Item_stock_in extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_item_stock_in_right') === FALSE){ Redirect::to('/')->send(); } $extractions = DB::table('item_stock_in')->where('branch',active_branch_id()); $extractions->where(function($query) use ($request){ $query->where('main_approval','pending')->orWhere('main_approval','approved'); }); $extractions = json_decode(json_encode($extractions->get()),true); $this->data["pageData"] = $extractions; $this->data["title"] = print_lang($this->data["app_lang"],'mod_item_stock_in_view_title'); $this->data["pageToLoad"] = "item_stock_in/view.php"; $this->data["activeLink"] = "stock"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_item_stock_in_right') === FALSE){ Redirect::to('/')->send(); } $this->data["currencies"] = fetch_currencies(); $this->data["items"] = fetch_table_branch('item_stock'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'mod_item_stock_in_add_title'); $this->data["pageToLoad"] = "item_stock_in/add.php"; $this->data["activeLink"] = "stock"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'account' => 'required', 'currency' => 'required', 'item' => 'required', 'unit' => 'required', 'quantity' => 'required', 'cost' => 'required', 'bill_number' => 'required', ]); $validator->validate(); $uid = getUniqueId('ITMSN', 'item_stock_in', 'uid'); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $account_data = fetch_table_where('accounts','uid',$request->account,true); if($request->account == 'opening_stock') { $account_data['name'] = print_lang($this->data["app_lang"],'mod_item_stock_in_add_input_option_opening_stock'); } $item_data = fetch_table_where('item_stock','uid',$request->item,true); $total = $request->quantity * $request->cost; $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'event_date' => get_true_date($request->event_date), 'account' => $request->account, 'account_name' => isset($account_data['name']) ? $account_data['name'] : null, 'currency' => $request->currency, 'currency_name' => isset($currency_data['name']) ? $currency_data['name'] : null, 'currency_symbol' => isset($currency_data['symbol']) ? $currency_data['symbol'] : null, 'item' => $request->item, 'item_name' => isset($item_data['name']) ? $item_data['name'] : null, 'bill_number' => $request->bill_number, 'unit' => $request->unit, 'quantity' => $request->quantity, 'cost' => $request->cost, 'total' => $total, 'details' => $request->details, 'sub_approval' => user_approval_info('sub_approval'), 'sub_approval_user' => user_approval_info('sub_approval_user'), 'sub_approval_user_name' => user_approval_info('sub_approval_user_name'), 'main_approval' => user_approval_info('main_approval'), 'main_approval_user' => user_approval_info('main_approval_user'), 'main_approval_user_name' => user_approval_info('main_approval_user_name'), ); insert_table('item_stock_in',$db_array); if(user_approval_info('main_approval') == 'approved') { _handle_item_stock_in_balance_effects(['uid' => $uid, 'state' => 'new']); handle_item_stock_stats($db_array['item']); _handle_item_stock_in_ledger_effects(['uid' => $uid, 'state' => 'new']); } echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'mod_item_stock_in_added'), 'message_body' => print_lang($this->data["app_lang"],'mod_item_stock_in_save_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_item_stock_in_right') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('item_stock_in','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/item_stock_in')->send(); } $this->data["currencies"] = fetch_currencies(); $this->data["items"] = fetch_table_branch('item_stock'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'mod_item_stock_in_edit_title'); $this->data["pageToLoad"] = "item_stock_in/edit.php"; $this->data["activeLink"] = "stock"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'account' => 'required', 'currency' => 'required', 'item' => 'required', 'unit' => 'required', 'quantity' => 'required', 'cost' => 'required', 'bill_number' => 'required', ]); $validator->validate(); $old_data = fetch_table_where('item_stock_in','uid',$uid,true); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $account_data = fetch_table_where('accounts','uid',$request->account,true); if($request->account == 'opening_stock') { $account_data['name'] = print_lang($this->data["app_lang"],'mod_item_stock_in_add_input_option_opening_stock'); } $item_data = fetch_table_where('item_stock','uid',$request->item,true); $total = $request->quantity * $request->cost; $db_array = array( 'event_date' => get_true_date($request->event_date), 'account' => $request->account, 'account_name' => isset($account_data['name']) ? $account_data['name'] : null, 'currency' => $request->currency, 'currency_name' => isset($currency_data['name']) ? $currency_data['name'] : null, 'currency_symbol' => isset($currency_data['symbol']) ? $currency_data['symbol'] : null, 'item' => $request->item, 'item_name' => isset($item_data['name']) ? $item_data['name'] : null, 'bill_number' => $request->bill_number, 'unit' => $request->unit, 'quantity' => $request->quantity, 'cost' => $request->cost, 'total' => $total, 'details' => $request->details, ); update_table('item_stock_in','uid',$uid,$db_array); handle_item_stock_stats($old_data['item']); handle_item_stock_stats($db_array['item']); update_table('item_stock_out','item',$uid,['item_name' => $request->item]); _handle_item_stock_in_balance_effects(['uid' => $uid, 'state' => 'update']); _handle_item_stock_in_ledger_effects(['uid' => $uid, 'state' => 'update']); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'mod_item_stock_in_update'), 'message_body' => print_lang($this->data["app_lang"],'mod_item_stock_in_update_successfully'))); } public function delete($uid) { if(check_user_access('delete_item_stock_in_right') === FALSE){ Redirect::to('/')->send(); } $old_data = fetch_table_where('item_stock_in','uid',$uid,true); delete_table('item_stock_in','uid',$uid); _handle_item_stock_in_balance_effects(['uid' => $uid, 'state' => 'delete']); _handle_item_stock_in_ledger_effects(['uid' => $uid, 'state' => 'delete']); handle_item_stock_stats($old_data['item']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }