<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Item_stock_out extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_item_stock_out_right') === FALSE){ Redirect::to('/')->send(); } $extractions = DB::table('item_stock_out')->where('branch',active_branch_id()); $extractions->where(function($query) use ($request){ $query->where('main_approval','pending')->orWhere('main_approval','approved'); }); $extractions = json_decode(json_encode($extractions->get()),true); $this->data["pageData"] = $extractions; $this->data["title"] = print_lang($this->data["app_lang"],'mod_item_stock_out_view_title'); $this->data["pageToLoad"] = "item_stock_out/view.php"; $this->data["activeLink"] = "stock"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_item_stock_out_right') === FALSE){ Redirect::to('/')->send(); } $this->data["item"] = fetch_table_branch('item_stock'); $this->data["expense_types"] = fetch_table_branch('expenses_types'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_item_stock_out_add_title'); $this->data["pageToLoad"] = "item_stock_out/add.php"; $this->data["activeLink"] = "stock"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'item' => 'required', 'event_date' => 'required', 'out_quantity' => 'required', ]); $validator->validate(); $uid = getUniqueId('ITMST', 'item_stock_out', 'uid'); $item_data = fetch_table_where('item_stock','uid',$request->item,true); $item_name = isset($item_data['name']) ? $item_data['name'] : null; $item_unit = isset($item_data['unit']) ? $item_data['unit'] : null; $item_currency = isset($item_data['currency']) ? $item_data['currency'] : null; $cost = isset($item_data['avg_cost']) ? $item_data['avg_cost'] : null; $total = $request->out_quantity * $cost; $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'event_date' => get_true_date($request->event_date), 'item' => $request->item, 'item_name' => $item_name, 'out_quantity' => $request->out_quantity, 'unit' => $item_unit, 'total' => $total, 'details' => $request->details, 'expense_type' => $request->expense_type, 'sub_approval' => user_approval_info('sub_approval'), 'sub_approval_user' => user_approval_info('sub_approval_user'), 'sub_approval_user_name' => user_approval_info('sub_approval_user_name'), 'main_approval' => user_approval_info('main_approval'), 'main_approval_user' => user_approval_info('main_approval_user'), 'main_approval_user_name' => user_approval_info('main_approval_user_name'), ); insert_table('item_stock_out',$db_array); if(user_approval_info('main_approval') == 'approved') { _handle_item_stock_out_balance_effects(['uid' => $uid, 'state' => 'new']); handle_item_stock_stats($db_array['item']); $currency_data = fetch_table_where('currency','uid',$item_currency,true); $euid = getUniqueId('EXPE', 'expenses', 'uid'); $edb_array = array( 'uid' => $euid, 'branch' => active_branch_id(), 'serial_id' => get_serial_id('expenses'), 'type' => $request->expense_type, 'exp_date' => date('Y-m-d'), 'account' => 'Stock In', 'amount' => $total, 'currency' => $item_currency, 'currency_usd_equalance' => $currency_data['usd_equalance'], 'narration' => $request->details, 'stock_uid' => $uid, ); insert_table('expenses',$edb_array); } echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'mod_item_stock_out_added'), 'message_body' => print_lang($this->data["app_lang"],'mod_item_stock_out_save_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_item_stock_out_right') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('item_stock_out','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/item_stock_out')->send(); } $this->data["item"] = fetch_table_branch('item_stock'); $this->data["expense_types"] = fetch_table_branch('expenses_types'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_item_stock_out_edit_title'); $this->data["pageToLoad"] = "item_stock_out/edit.php"; $this->data["activeLink"] = "stock"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'item' => 'required', 'event_date' => 'required', 'out_quantity' => 'required', ]); $validator->validate(); $old_data = fetch_table_where('item_stock_out','uid',$uid,true); $item_data = fetch_table_where('item_stock','uid',$request->item,true); $item_name = isset($item_data['name']) ? $item_data['name'] : null; $item_unit = isset($item_data['unit']) ? $item_data['unit'] : null; $item_currency = isset($item_data['currency']) ? $item_data['currency'] : null; $cost = isset($item_data['avg_cost']) ? $item_data['avg_cost'] : null; $total = $request->out_quantity * $cost; $db_array = array( 'event_date' => get_true_date($request->event_date), 'item' => $request->item, 'item_name' => $item_name, 'out_quantity' => $request->out_quantity, 'unit' => $item_unit, 'total' => $total, 'details' => $request->details, ); update_table('item_stock_out','uid',$uid,$db_array); _handle_item_stock_out_balance_effects(['uid' => $uid, 'state' => 'update']); handle_item_stock_stats($old_data['item']); handle_item_stock_stats($db_array['item']); $currency_data = fetch_table_where('currency','uid',$item_currency,true); $edb_array = array( 'type' => $request->expense_type, 'amount' => $total, 'currency' => $item_currency, 'currency_usd_equalance' => $currency_data['usd_equalance'], 'narration' => $request->details, ); update_table('expenses','stock_uid',$uid,$edb_array); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'mod_item_stock_out_update'), 'message_body' => print_lang($this->data["app_lang"],'mod_item_stock_out_update_successfully'))); } public function delete($uid) { if(check_user_access('delete_item_stock_out_right') === FALSE){ Redirect::to('/')->send(); } $old_data = fetch_table_where('item_stock_out','uid',$uid,true); delete_table('item_stock_out','uid',$uid); delete_table('expenses','stock_uid',$uid); _handle_item_stock_out_balance_effects(['uid' => $uid, 'state' => 'delete']); handle_item_stock_stats($old_data['item']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function item_stock_balance_report(Request $request) { if(check_user_access('view_item_stock_balance_report') === FALSE){ Redirect::to('/')->send(); } $this->data["pageData"] = fetch_table_branch('item_stock'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_item_stock_in_out_view_title'); $this->data["pageToLoad"] = "item_stock_out/item_stock_in_out.php"; $this->data["activeLink"] = "stock"; $this->load_view($this->data); } }