<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; use View; class Items extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_item') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $items = DB::table('items')->where('branch',$branch_id); if(!empty($request->type)){ $items->where('type',$request->type); } if(!empty($request->category)){ $items->where('category',$request->category); } if(!empty($request->from)) { $items->where('created_at','>=',$request->from.' 00:00:00'); } if(!empty($request->to)) { $items->where('created_at','<=',$request->to.' 23:59:59'); } if(!empty($request->_search)) { $items->where(function($query) use ($request) { $query->where('name','like','%'.$request->_search.'%'); }); } $items = $items->paginate($this->data['rows_per_page']); $pagination = $items->appends(request()->except(['page','search_type']))->links(); $items = json_decode(json_encode($items),true); $this->data["pagination"] = $pagination; $this->data["records"] = array('from' => $items['from'], 'to' => $items['to'], 'total' => $items['total']); $items = $items['data']; $this->data["pageData"] = $items; $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["product_categories"] = set_array_keys(fetch_table('product_category'),'uid'); $this->data["search_type"] = $request->type; $this->data["search_category"] = $request->category; $this->data["search_currency"] = $request->currency; $this->data["search_unit"] = $request->unit; $this->data["_search"] = $request->_search; if($request->search_type == 'live_search') { $this->data["live_search_data"] = 'yes'; $view_records = (string)View::make('user.items.view',$this->data); $stats = "Showing ".(float)$this->data["records"]['from'].' - '.(float)$this->data["records"]['to'].' of '.(float)$this->data["records"]['total']; $output_array = array('records' => $view_records, 'stats' => $stats, 'pagination' => (string)$pagination); echo json_encode($output_array); } else { $this->data["live_search_data"] = 'no'; $this->data["title"] = print_lang($this->data["app_lang"],'items'); $this->data["pageToLoad"] = "items/view.php"; $this->data["activeLink"] = "items"; $this->data["_datatable_pagination"] = false; $this->load_view($this->data); } } public function view_all(Request $request) { if(check_user_access('view_item') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $items = DB::table('items')->where('branch',$branch_id); if(!empty($request->type)){ $items->where('type',$request->type); } if(!empty($request->category)){ $items->where('category',$request->category); } if(!empty($request->from)) { $items->where('created_at','>=',$request->from.' 00:00:00'); } if(!empty($request->to)) { $items->where('created_at','<=',$request->to.' 23:59:59'); } $items = json_decode(json_encode($items->get()),true); $this->data["pageData"] = $items; $this->data["search_type"] = $request->type; $this->data["search_category"] = $request->category; $this->data["search_currency"] = $request->currency; $this->data["search_unit"] = $request->unit; $this->data["_search"] = $request->_search; $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["product_categories"] = set_array_keys(fetch_table('product_category'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'items'); $this->data["pageToLoad"] = "items/all.php"; $this->data["activeLink"] = "items"; $this->load_view($this->data); } public function view_print(Request $request) { if(check_user_access('view_item') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $items = DB::table('items')->where('branch',$branch_id); if(!empty($request->type)){ $items->where('type',$request->type); } if(!empty($request->category)){ $items->where('category',$request->category); } if(!empty($request->from)) { $items->where('created_at','>=',$request->from.' 00:00:00'); } if(!empty($request->to)) { $items->where('created_at','<=',$request->to.' 23:59:59'); } $items = json_decode(json_encode($items->get()),true); $this->data["pageData"] = $items; $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["product_categories"] = set_array_keys(fetch_table('product_category'),'uid'); $this->data["search_type"] = $request->type; $this->data["search_category"] = $request->category; $this->data["search_currency"] = $request->currency; $this->data["search_unit"] = $request->unit; $this->data["title"] = print_lang($this->data["app_lang"],'items'); $this->data["pageToLoad"] = "items/print.php"; $this->data["activeLink"] = "items"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_item') === FALSE){ Redirect::to('/')->send(); } $this->data["item_id"] = get_new_item_id(); $this->data["product_categories"] = fetch_table('product_category'); $this->data["units"] = fetch_table('units'); $this->data["warehouse"] = fetch_table_branch('warehouse'); $this->data["accounts"] = fetch_table_where_branch('accounts','type','supplier'); $this->data["currencies"] = fetch_currencies(); $this->data["title"] = print_lang($this->data["app_lang"],'add_item'); $this->data["pageToLoad"] = "items/add.php"; $this->data["activeLink"] = "items"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'item_id' => 'required', 'name' => 'required', 'type' => 'required', 'purchase_unit' => 'required', 'purchase_unit_equalance' => 'required', 'currency' => 'required', 'cost' => 'required', 'reorder_qty' => 'required', ]); $validator->sometimes('sale_price','required',function($input){ if($input->type == 'sales'){ return true; }else{ return false; } } ); $validator->validate(); $uid = getUniqueId('ITEM', 'items', 'uid'); $item_collection_of_warehouses_uid = []; foreach($request->warehouse as $roww) { $item_collection_of_warehouses_uid[] = '-++-'.$roww.'-++-'; } $item_image = NULL; if($request->hasFile('item_image')) { $file = $request->file('item_image'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('ITEM'); $fileNamePrefix = db_unique_id('items',$fileNamePrefix); $item_image = $fileNamePrefix.'.'.$extension; $file->move('uploads/items/',$item_image); } if($request->type == 'sales') { if(empty($request->sale_price)) { $request->sale_price = $request->cost; } } if($request->type == 'raw') { if(empty($request->sale_price)) { $request->sale_price = $request->cost; } } if(empty($request->sale_unit)){ $request->sale_unit = $request->purchase_unit; } if(empty($request->sale_unit_equalance)){ $request->sale_unit_equalance = $request->purchase_unit_equalance; } if(empty($request->production_unit)){ $request->production_unit = $request->purchase_unit; } if(empty($request->production_unit_equalance)){ $request->production_unit_equalance = $request->purchase_unit_equalance; } $currency_db_data = fetch_table_where('currency','uid',$request->currency,true); $purchase_unit_db_data = fetch_table_where('units','uid',$request->purchase_unit,true); $sale_unit_db_data = fetch_table_where('units','uid',$request->sale_unit,true); $production_unit_db_data = fetch_table_where('units','uid',$request->production_unit,true); $mfg_date = NULL; if(!empty($request->mfg_date)){ $mfg_date = get_true_date($request->mfg_date); } $expiry_date = NULL; if(!empty($request->expiry_date)){ $expiry_date = get_true_date($request->expiry_date); } if(empty($request->batch)){ $request->batch = env('APP_BATCH'); } $profit = (float)$request->sale_price - (float)$request->cost; $db_array = array( 'uid' => $uid, 'b_to_b_rel_uid' => $uid, 'branch' => active_branch_id(), 'item_id' => $request->item_id, 'name' => $request->name, 'type' => $request->type, 'category' => $request->category, 'purchase_unit' => $request->purchase_unit, 'purchase_unit_name' => isset($purchase_unit_db_data['name']) ? $purchase_unit_db_data['name'] : null, 'purchase_unit_equalance' => $request->purchase_unit_equalance, 'sale_unit' => $request->sale_unit, 'sale_unit_name' => isset($sale_unit_db_data['name']) ? $sale_unit_db_data['name'] : null, 'sale_unit_equalance' => $request->sale_unit_equalance, 'production_unit' => $request->production_unit, 'production_unit_name' => isset($production_unit_db_data['name']) ? $production_unit_db_data['name'] : null, 'production_unit_equalance' => $request->production_unit_equalance, 'bundle' => $request->bundle, 'toop' => $request->toop, 'batch' => $request->batch, 'currency' => $request->currency, 'currency_name' => isset($currency_db_data['name']) ? $currency_db_data['name'] : 1, 'currency_symbol' => isset($currency_db_data['symbol']) ? $currency_db_data['symbol'] : 1, 'currency_usd_equalance' => isset($currency_db_data['usd_equalance']) ? $currency_db_data['usd_equalance'] : 1, 'cost' => $request->cost, 'sale_price' => $request->sale_price, 'profit' => $profit, 'reorder_qty' => $request->reorder_qty, 'mfg_date' => $mfg_date, 'expiry_date' => $expiry_date, 'expiry_alert' => $request->expiry_alert, 'details' => $request->details, 'country' => $request->country, 'company' => $request->company, 'warehouses' => json_encode($request->warehouse), 'warehouse_uids' => implode(',', $item_collection_of_warehouses_uid), 'opening_stocks' => json_encode($request->opening_stock), 'opening_stock' => array_sum($request->opening_stock), 'item_image' => $item_image, ); $item_settings = get_item_settings(); if($item_settings['item_measurements'] == 'get') { $db_array['height'] = (float)$request->height; $db_array['width'] = (float)$request->width; $db_array['length'] = (float)$request->length; } if($item_settings['cbm'] == 'enable') { $db_array['item_width'] = (float)$request->item_width; $db_array['item_length'] = (float)$request->item_length; $db_array['item_height'] = (float)$request->item_height; $db_array['cbm'] = (float)$request->cbm; $db_array['weight'] = (float)$request->weight; } insert_table('items',$db_array); _handle_items_inventory_stats_from_item_registration(['uid' => $uid, 'entry_status' => 'new']); echo json_encode(array('status' => 'success', 'mood' => 'new', 'get_new_item_id' => get_new_item_id(), 'message_head' => print_lang($this->data["app_lang"],'item_created'), 'message_body' => print_lang($this->data["app_lang"],'new_item_created_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_item') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('items','uid',$uid,true); $this->data["product_categories"] = fetch_table('product_category'); $this->data["units"] = fetch_table('units'); $this->data["warehouse"] = fetch_table_branch('warehouse'); $this->data["accounts"] = fetch_table_where_branch('accounts','type','supplier'); $this->data["currencies"] = fetch_currencies(); $this->data["title"] = print_lang($this->data["app_lang"],'edit_item'); $this->data["pageToLoad"] = "items/edit.php"; $this->data["activeLink"] = "items"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'item_id' => 'required', 'name' => 'required', 'type' => 'required', 'purchase_unit' => 'required', 'purchase_unit_equalance' => 'required', 'currency' => 'required', 'cost' => 'required', 'reorder_qty' => 'required', ]); $validator->sometimes('sale_price','required',function($input){ if($input->type == 'sales'){ return true; }else{ return false; } } ); $validator->validate(); if($request->type == 'sales') { if(empty($request->sale_price)) { $request->sale_price = $request->cost; } } if($request->type == 'raw') { if(empty($request->sale_price)) { $request->sale_price = $request->cost; } } if(empty($request->sale_unit)){ $request->sale_unit = $request->purchase_unit; } if(empty($request->sale_unit_equalance)){ $request->sale_unit_equalance = $request->purchase_unit_equalance; } if(empty($request->production_unit)){ $request->production_unit = $request->purchase_unit; } if(empty($request->production_unit_equalance)){ $request->production_unit_equalance = $request->purchase_unit_equalance; } $mfg_date = NULL; if(!empty($request->mfg_date)){ $mfg_date = get_true_date($request->mfg_date); } $expiry_date = NULL; if(!empty($request->expiry_date)){ $expiry_date = get_true_date($request->expiry_date); } if(empty($request->batch)){ $request->batch = env('APP_BATCH'); } $currency_db_data = fetch_table_where('currency','uid',$request->currency,true); $purchase_unit_db_data = fetch_table_where('units','uid',$request->purchase_unit,true); $sale_unit_db_data = fetch_table_where('units','uid',$request->sale_unit,true); $production_unit_db_data = fetch_table_where('units','uid',$request->production_unit,true); $profit = (float)$request->sale_price - (float)$request->cost; $item_collection_of_warehouses_uid = []; foreach($request->warehouse as $roww) { $item_collection_of_warehouses_uid[] = '-++-'.$roww.'-++-'; } $db_array = array( 'item_id' => $request->item_id, 'name' => $request->name, 'type' => $request->type, 'category' => $request->category, 'purchase_unit' => $request->purchase_unit, 'purchase_unit_name' => isset($purchase_unit_db_data['name']) ? $purchase_unit_db_data['name'] : null, 'purchase_unit_equalance' => $request->purchase_unit_equalance, 'sale_unit' => $request->sale_unit, 'sale_unit_name' => isset($sale_unit_db_data['name']) ? $sale_unit_db_data['name'] : null, 'sale_unit_equalance' => $request->sale_unit_equalance, 'production_unit' => $request->production_unit, 'production_unit_name' => isset($production_unit_db_data['name']) ? $production_unit_db_data['name'] : null, 'production_unit_equalance' => $request->production_unit_equalance, 'toop' => $request->toop, 'batch' => $request->batch, 'currency' => $request->currency, 'currency_name' => isset($currency_db_data['name']) ? $currency_db_data['name'] : 1, 'currency_symbol' => isset($currency_db_data['symbol']) ? $currency_db_data['symbol'] : 1, 'currency_usd_equalance' => isset($currency_db_data['usd_equalance']) ? $currency_db_data['usd_equalance'] : 1, 'cost' => $request->cost, 'sale_price' => $request->sale_price, 'profit' => $profit, 'reorder_qty' => $request->reorder_qty, 'mfg_date' => $mfg_date, 'expiry_date' => $expiry_date, 'expiry_alert' => $request->expiry_alert, 'details' => $request->details, 'country' => $request->country, 'company' => $request->company, 'warehouses' => json_encode($request->warehouse), 'warehouse_uids' => implode(',', $item_collection_of_warehouses_uid), 'opening_stocks' => json_encode($request->opening_stock), 'opening_stock' => array_sum($request->opening_stock), ); $item_data = fetch_table_where('items','uid',$uid,TRUE); if($request->hasFile('item_image')) { $file = $request->file('item_image'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('ITEM'); $fileNamePrefix = db_unique_id('items',$fileNamePrefix); $item_image = $fileNamePrefix.'.'.$extension; $file->move('uploads/items/',$item_image); $db_array['item_image'] = $item_image; File::delete('uploads/items/'.$item_data["item_image"]); } $item_settings = get_item_settings(); if($item_settings['item_measurements'] == 'get') { $db_array['height'] = (float)$request->height; $db_array['width'] = (float)$request->width; $db_array['length'] = (float)$request->length; } if($item_settings['cbm'] == 'enable') { $db_array['item_width'] = (float)$request->item_width; $db_array['item_length'] = (float)$request->item_length; $db_array['item_height'] = (float)$request->item_height; $db_array['cbm'] = (float)$request->cbm; $db_array['weight'] = (float)$request->weight; } $item_before_update = fetch_table_where('items','uid',$uid,true); update_table('items','uid',$uid,$db_array); update_table('items_inventory_stats','item',$uid,['item_name' => $request->name]); update_table('items_inventory_stats','item',$uid,['item_category' => $request->category]); update_table('tokens','item',$uid,['item_name' => $request->name]); _handle_items_inventory_stats_from_item_registration(['uid' => $uid, 'entry_status' => 'update']); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'item_updated'), 'message_body' => print_lang($this->data["app_lang"],'item_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_item') === FALSE){ Redirect::to('/')->send(); } $item_data = fetch_table_where('items','uid',$uid,TRUE); File::delete('uploads/items/'.$item_data["item_image"]); delete_table('items','uid',$uid); _handle_items_inventory_stats_from_item_registration(['uid' => $uid, 'entry_status' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function settings(Request $request) { if(check_user_access('item_settings') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = get_item_settings(); $this->data["title"] = print_lang($this->data["app_lang"],'item_settings'); $this->data["pageToLoad"] = "items/item_settings.php"; $this->data["activeLink"] = "settings"; $this->load_view($this->data); } public function save_settings(Request $request) { $active_branch_id = active_branch_id(); $db_array = array( 'item_measurements' => $request->item_measurements, 'fuel_parts' => $request->fuel_parts, 'invoice_units' => $request->invoice_units, 'showroom' => $request->showroom, 'construction' => $request->construction, 'service' => $request->service, 'bundle_toop' => $request->bundle_toop, 'sale_invoice' => $request->sales_invoice, 'transfer' => $request->transfer, 'cbm' => $request->cbm, 'carton_purchase_sale' => $request->carton_purchase_sale, 'distribution' => $request->distribution, 'orderm' => $request->orderm, 'journal' => $request->journal, 'debit_credit_note' => $request->debit_credit_note, 'debit_credit_voucher' => $request->debit_credit_voucher, 'quotation' => $request->quotation, 'transferm' => $request->transferm, 'sale' => $request->sale, 'purchase' => $request->purchase, 'production' => $request->production, 'extra_income' => $request->extra_income, 'item_stock' => $request->item_stock, 'expenses' => $request->expenses, 'transit' => $request->transit, 'hrm' => $request->hrm, 'assets' => $request->assets, 'synchronization' => $request->synchronization, 'share_capital' => $request->share_capital, 'metu' => $request->metu, ); $item_settings = DB::table('item_settings')->where('branch',$active_branch_id)->get(); if($item_settings->count() > 0) { update_table('item_settings','branch',$active_branch_id,$db_array); } else { $db_array['branch'] = $active_branch_id; insert_table('item_settings',$db_array); } echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'settings_updated'), 'message_body' => print_lang($this->data["app_lang"],'settings_updated_successfully'))); } public function save_columns(Request $request) { $branch_id = active_branch_id(); $columns = $request->columns; if(!empty($columns)) { $columns = implode(',', $columns); } $check_exist = fetch_table_where('items_columns','branch_id',$branch_id,true); if(!empty($check_exist)) { $db_array = [ 'columns' => $columns, ]; update_table('items_columns',"branch_id",$branch_id,$db_array); } else { $db_array = [ 'branch_id' => $branch_id, 'columns' => $columns ]; insert_table('items_columns',$db_array); } echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'items_popup_columns_success_head'), 'message_body' => print_lang($this->data["app_lang"],'items_popup_columns_success_message'))); } public function update_system_modules(Request $request) { $column_name = $request->input_name; $column_value = $request->input_val; $active_branch_id = active_branch_id(); $db_array = array( 'item_measurements' => 'ignore', 'invoice_units' => 'one_unit', 'fuel_parts' => 'disable', 'showroom' => 'disable', 'construction' => 'disable', 'service' => 'disable', 'sale_invoice' => 'sales_invoice_3', 'transfer' => 'n_transfer', 'cbm' => 'disable', 'bundle_toop' => 'disable', 'item_token' => 'disable', 'carton_purchase_sale' => 'disable', 'synchronization' => 'disable', 'distribution' => 'enable', 'orderm' => 'enable', 'journal' => 'enable', 'debit_credit_note' => 'enable', 'debit_credit_voucher' => 'enable', 'quotation' => 'enable', 'transferm' => 'enable', 'sale' => 'enable', 'purchase' => 'enable', 'production' => 'enable', 'extra_income' => 'enable', 'item_stock' => 'enable', 'expenses' => 'enable', 'transit' => 'enable', 'hrm' => 'enable', 'assets' => 'enable', 'share_capital' => 'enable', 'metu' => 'enable', 'b_to_b_business' => 'enable', 'item_stock_in_out' => 'enable', ); $item_settings = DB::table('item_settings')->where('branch',$active_branch_id)->get(); if($item_settings->count() == 0) { $db_array['branch'] = $active_branch_id; insert_table('item_settings',$db_array); } $settings_info = [$column_name => $column_value]; update_table('item_settings','branch',$active_branch_id,$settings_info); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'settings_updated'), 'message_body' => print_lang($this->data["app_lang"],'settings_updated_successfully'))); } }