<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use View; class Journal extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_journal') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $journal = DB::table('journal')->where('branch',$branch_id)->orderBy('id','asc'); if(!empty($request->from)){ $journal->where('journal_date','>=',get_true_date($request->from)); } if(!empty($request->to)){ $journal->where('journal_date','<=',get_true_date($request->to)); } if(!empty($request->account)) { $journal->where(function($query) use ($request){ $query->where('receiving_account',$request->account)->orWhere('payment_account',$request->account); }); } $journal->where(function($query) use ($request){ $query->where('main_approval','pending')->orWhere('main_approval','approved'); }); if(!empty($request->_search)) { $journal->where(function($query) use ($request) { $query->where('journal_date','like','%'.$request->_search.'%'); $query->orWhere('receiving_currency','like','%'.$request->_search.'%'); $query->orWhere('payment_currency','like','%'.$request->_search.'%'); $query->orWhere('receiving_amount','like','%'.$request->_search.'%'); $query->orWhere('payment_amount','like','%'.$request->_search.'%'); $query->orWhere('receiving_narration','like','%'.$request->_search.'%'); $query->orWhere('payment_narration','like','%'.$request->_search.'%'); }); } $journal = $journal->paginate($this->data['rows_per_page']); $pagination = $journal->appends(request()->except(['page','search_type']))->links(); $journal = json_decode(json_encode($journal),true); $this->data["pageData"] = $journal['data']; $this->data["pagination"] = $pagination; $this->data["records"] = array('from' => $journal['from'], 'to' => $journal['to'], 'total' => $journal['total']); $this->data["search_account"] = $request->account; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["accounts"] = set_array_keys(fetch_all_accounts(),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); if($request->search_type == 'live_search') { $this->data["live_search_data"] = 'yes'; $view_records = (string)View::make('user.journal.view',$this->data); $stats = "Showing ".(float)$this->data["records"]['from'].' - '.(float)$this->data["records"]['to'].' of '.(float)$this->data["records"]['total']; $output_array = array('records' => $view_records, 'stats' => $stats, 'pagination' => (string)$pagination); echo json_encode($output_array); } else { $this->data["live_search_data"] = 'no'; $this->data["_search"] = $request->_search; $this->data["title"] = print_lang($this->data["app_lang"],'journal'); $this->data["pageToLoad"] = "journal/view.php"; $this->data["activeLink"] = "journal"; $this->load_view($this->data); } } public function view_all(Request $request) { if(check_user_access('view_journal') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $journal = DB::table('journal')->where('branch',$branch_id); if(!empty($request->from)){ $journal->where('journal_date','>=',get_true_date($request->from)); } if(!empty($request->to)){ $journal->where('journal_date','<=',get_true_date($request->to)); } $journal = json_decode( json_encode( $journal->orderBy('id','asc')->get() ),true ); $this->data["pageData"] = $journal; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["accounts"] = set_array_keys(fetch_all_accounts(),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'journal'); $this->data["pageToLoad"] = "journal/view.php"; $this->data["activeLink"] = "journal"; $this->load_view($this->data); } public function print(Request $request) { if(check_user_access('view_journal') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $journal = DB::table('journal')->where('branch',$branch_id); if(!empty($request->from)){ $journal->where('journal_date','>=',get_true_date($request->from)); } if(!empty($request->to)){ $journal->where('journal_date','<=',get_true_date($request->to)); } $journal = json_decode( json_encode( $journal->get() ),true ); $this->data["pageData"] = $journal; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["accounts"] = set_array_keys(fetch_all_accounts(),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'journal'); $this->data["pageToLoad"] = "journal/print.php"; $this->data["activeLink"] = "journal"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_journal') === FALSE){ Redirect::to('/')->send(); } $this->data["currencies"] = fetch_currencies(); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'add_journal'); $this->data["pageToLoad"] = "journal/add.php"; $this->data["activeLink"] = "journal"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'journal_date' => 'required', 'receiving_currency' => 'required', 'payment_currency' => 'required', 'receiving_account' => 'required', 'payment_account' => 'required', 'receiving_amount' => 'required', 'payment_amount' => 'required', 'receiving_narration' => 'required', ]); $validator->validate(); $receiving_account_data = fetch_table_where('accounts','uid',$request->receiving_account,true); $payment_account_data = fetch_table_where('accounts','uid',$request->payment_account,true); if($receiving_account_data['type'] == 'expense') { if($payment_account_data['type'] == 'client' OR $payment_account_data['type'] == 'supplier' OR $payment_account_data['type'] == 'liability') { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'journal_exception'), 'message_body' => print_lang($this->data["app_lang"],'journal_exception_message'))); die; } } if($receiving_account_data['type'] == 'client' OR $receiving_account_data['type'] == 'supplier' OR $receiving_account_data['type'] == 'liability') { if($payment_account_data['type'] == 'expense') { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'journal_exception'), 'message_body' => print_lang($this->data["app_lang"],'journal_exception_message'))); die; } } $uid = getUniqueId('JRNL', 'journal', 'uid'); $receiving_currency_data = fetch_table_where('currency','uid',$request->receiving_currency,true); $payment_currency_data = fetch_table_where('currency','uid',$request->payment_currency,true); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'invoice' => get_journal_invoice_number(), 'serial_id' => get_serial_id('journal'), 'journal_date' => get_true_date($request->journal_date), 'receiving_currency' => $request->receiving_currency, 'payment_currency' => $request->payment_currency, 'receiving_account' => $request->receiving_account, 'payment_account' => $request->payment_account, 'receiving_amount' => $request->receiving_amount, 'payment_amount' => $request->payment_amount, 'receiving_narration' => $request->receiving_narration, 'payment_narration' => $request->receiving_narration, 'calculation_type' => $request->calculation_type, 'rate' => $request->rate, 'receiving_cue' => $receiving_currency_data['usd_equalance'], 'payment_cue' => $payment_currency_data['usd_equalance'], 'extra_income_account' => $request->extra_income_account, 'extra_income_amount' => $request->extra_income_amount, 'sub_approval' => user_approval_info('sub_approval'), 'sub_approval_user' => user_approval_info('sub_approval_user'), 'sub_approval_user_name' => user_approval_info('sub_approval_user_name'), 'main_approval' => user_approval_info('main_approval'), 'main_approval_user' => user_approval_info('main_approval_user'), 'main_approval_user_name' => user_approval_info('main_approval_user_name'), ); if(!empty($request->extra_income_account) AND $request->extra_income_amount > 0) { $db_array['is_extra_income'] = 'yes'; $uid_income = getUniqueId('EXTIC', 'extra_income', 'uid'); $extra_income_db_array = array( 'uid' => $uid_income, 'branch' => active_branch_id(), 'currency' => $db_array['payment_currency'], 'currency_usd_equalance' => $db_array['payment_cue'], 'account' => $request->extra_income_account, 'amount' => $request->extra_income_amount, 'description' => $request->receiving_narration, 'journal_uid' => $uid, 'journal_invoice' => $db_array['invoice'], 'is_journal' => 'yes', 'created_at' => $db_array['journal_date'], ); insert_table('extra_income',$extra_income_db_array); _handle_extra_income_ledger_effects(['uid' => $uid_income, 'state' => 'new']); } insert_table('journal',$db_array); if(user_approval_info('main_approval') == 'approved') { _handle_journal_ledger_effects(['uid' => $uid, 'state' => 'new']); message_from_journal($uid); } $accounts = set_array_keys(fetch_all_accounts(),'uid'); $payment_account_name = array_key_exists($db_array['payment_account'],$accounts) ? $accounts[$db_array['payment_account']]['name'] : NULL; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_journal'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/journal/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_from').': '.$payment_account_name.', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['payment_amount']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'journal_created'), 'message_body' => print_lang($this->data["app_lang"],'new_journal_created_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_journal') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('journal','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/journal')->send(); } $this->data["currencies"] = fetch_currencies(); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'edit_journal'); $this->data["pageToLoad"] = "journal/edit.php"; $this->data["activeLink"] = "journal"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'journal_date' => 'required', 'receiving_currency' => 'required', 'payment_currency' => 'required', 'receiving_account' => 'required', 'payment_account' => 'required', 'receiving_amount' => 'required', 'payment_amount' => 'required', 'receiving_narration' => 'required', ]); $validator->validate(); $receiving_account_data = fetch_table_where('accounts','uid',$request->receiving_account,true); $payment_account_data = fetch_table_where('accounts','uid',$request->payment_account,true); if($receiving_account_data['type'] == 'expense') { if($payment_account_data['type'] == 'client' OR $payment_account_data['type'] == 'supplier' OR $payment_account_data['type'] == 'liability') { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'journal_exception'), 'message_body' => print_lang($this->data["app_lang"],'journal_exception_message'))); die; } } if($receiving_account_data['type'] == 'client' OR $receiving_account_data['type'] == 'supplier' OR $receiving_account_data['type'] == 'liability') { if($payment_account_data['type'] == 'expense') { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'journal_exception'), 'message_body' => print_lang($this->data["app_lang"],'journal_exception_message'))); die; } } $editing_data = fetch_table_where('journal','uid',$uid,true); if($editing_data['receiving_currency'] == $request->receiving_currency AND $editing_data['payment_currency'] == $request->payment_currency AND $editing_data['receiving_amount'] == $request->receiving_amount AND $editing_data['payment_amount'] == $request->payment_amount) { $receiving_cue = $editing_data['receiving_cue']; $payment_cue = $editing_data['payment_cue']; } else { $receiving_currency_data = fetch_table_where('currency','uid',$request->receiving_currency,true); $payment_currency_data = fetch_table_where('currency','uid',$request->payment_currency,true); $receiving_cue = $receiving_currency_data['usd_equalance']; $payment_cue = $payment_currency_data['usd_equalance']; } $db_array = array( 'journal_date' => get_true_date($request->journal_date), 'receiving_currency' => $request->receiving_currency, 'payment_currency' => $request->payment_currency, 'receiving_account' => $request->receiving_account, 'payment_account' => $request->payment_account, 'receiving_amount' => $request->receiving_amount, 'payment_amount' => $request->payment_amount, 'receiving_narration' => $request->receiving_narration, 'payment_narration' => $request->receiving_narration, 'receiving_cue' => $receiving_cue, 'payment_cue' => $payment_cue, 'calculation_type' => $request->calculation_type, 'rate' => $request->rate, 'extra_income_account' => $request->extra_income_account, 'extra_income_amount' => $request->extra_income_amount, ); $journal_data_before_update = fetch_table_where('journal','uid',$uid,true); $income_data_before_update = fetch_table_where('extra_income','journal_uid',$uid,true); if(!empty($income_data_before_update)) { delete_table('extra_income','journal_uid',$uid); _handle_extra_income_ledger_effects(['uid' => $income_data_before_update['uid'], 'state' => 'delete']); } if(!empty($request->extra_income_account) AND $request->extra_income_amount > 0) { $db_array['is_extra_income'] = 'yes'; $uid_income = getUniqueId('EXTIC', 'extra_income', 'uid'); $extra_income_db_array = array( 'uid' => $uid_income, 'branch' => active_branch_id(), 'currency' => $db_array['payment_currency'], 'currency_usd_equalance' => $db_array['payment_cue'], 'account' => $request->extra_income_account, 'amount' => $request->extra_income_amount, 'description' => $request->receiving_narration, 'journal_uid' => $uid, 'journal_invoice' => $journal_data_before_update['invoice'], 'is_journal' => 'yes', 'created_at' => $db_array['journal_date'], ); insert_table('extra_income',$extra_income_db_array); _handle_extra_income_ledger_effects(['uid' => $uid_income, 'state' => 'update']); } else { $db_array['is_extra_income'] = 'no'; } update_table('journal','uid',$uid,$db_array); if($journal_data_before_update['is_activity'] == 'yes' AND !empty($journal_data_before_update['activity_uid'])) { $activity_uid = $journal_data_before_update['activity_uid']; $activity_array = array( 'currency' => $db_array['payment_currency'], 'currency_usd_equalance' => $db_array['payment_cue'], 'amount' => $db_array['payment_amount'], 'exchange_currency' => $db_array['receiving_currency'], 'exchange_currency_usd_equalance' => $db_array['receiving_cue'], 'rate' => $request->rate, 'activities_formula' => $request->calculation_type, 'exchange_amount' => $db_array['receiving_amount'], 'narration' => $db_array['receiving_narration'], 'debit_account' => $db_array['payment_account'], 'credit_account' => $db_array['receiving_account'], ); update_table('activities','uid',$activity_uid,$activity_array); _handle_activities_ledger_effects(['uid' => $activity_uid, 'state' => 'update']); } else if($journal_data_before_update['is_receipt'] == 'yes' AND !empty($journal_data_before_update['receipt_uid'])) { $receipt_uid = $journal_data_before_update['receipt_uid']; $receipt_array = array( 'currency' => $db_array['receiving_currency'], 'currency_usd_equalance' => $db_array['receiving_cue'], 'amount' => $db_array['receiving_amount'], 'exchange_currency' => $db_array['payment_currency'], 'exchange_currency_usd_equalance' => $db_array['payment_cue'], 'rate' => $request->rate, 'receipts_formula' => $request->calculation_type, 'exchange_amount' => $db_array['payment_amount'], 'details' => $db_array['receiving_narration'], 'client' => $db_array['receiving_account'], 'debit_account' => $db_array['payment_account'], ); update_table('money_receipts','uid',$receipt_uid,$receipt_array); _handle_journal_ledger_effects(['uid' => $uid, 'state' => 'update']); } else { _handle_journal_ledger_effects(['uid' => $uid, 'state' => 'update']); } $accounts = set_array_keys(fetch_all_accounts(),'uid'); $payment_account_name = array_key_exists($db_array['payment_account'],$accounts) ? $accounts[$db_array['payment_account']]['name'] : NULL; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_journal'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/journal/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_from').': '.$payment_account_name.', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['payment_amount']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'journal_updated'), 'message_body' => print_lang($this->data["app_lang"],'journal_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_journal') === FALSE){ Redirect::to('/')->send(); } $journal_data = fetch_table_where('journal','uid',$uid,true); $extra_income_data = fetch_table_where('extra_income','journal_uid',$uid,true); $accounts = set_array_keys(fetch_all_accounts(),'uid'); $payment_account_name = array_key_exists($journal_data['payment_account'],$accounts) ? $accounts[$journal_data['payment_account']]['name'] : NULL; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_journal'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_from').': '.$payment_account_name.', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($journal_data['payment_amount']), ); set_activity_alert($_activity_details); delete_table('journal','uid',$uid); if(!empty($extra_income_data)) { delete_table('extra_income','journal_uid',$uid); _handle_extra_income_ledger_effects(['uid' => $extra_income_data['uid'], 'state' => 'delete']); } if($journal_data['is_activity'] == 'yes' AND !empty($journal_data['activity_uid'])) { $activity_uid = $journal_data['activity_uid']; delete_table('activities','uid',$activity_uid); _handle_activities_ledger_effects(['uid' => $activity_uid, 'state' => 'delete']); } else if($journal_data['is_receipt'] == 'yes' AND !empty($journal_data['receipt_uid'])) { $receipt_uid = $journal_data['receipt_uid']; delete_table('money_receipts','uid',$receipt_uid); _handle_journal_ledger_effects(['uid' => $uid, 'state' => 'delete']); } else { _handle_journal_ledger_effects(['uid' => $uid, 'state' => 'delete']); } echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function invoice(Request $request, $uid) { if(check_user_access('view_records') === FALSE){ Redirect::to('/')->send(); } $this->data["invoice_data"] = fetch_table_where('journal','uid',$uid,true); if(!is_array($this->data["invoice_data"])){ Redirect::to('/journal')->send(); } $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'invoice_journal'); $this->data["pageToLoad"] = "journal/invoice.php"; $this->data["activeLink"] = "journal"; $this->load_view($this->data); } }