<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Language_setup extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_language') === FALSE){ Redirect::to('/')->send(); } $this->data["pageData"] = fetch_table('language'); $this->data["title"] = print_lang($this->data["app_lang"],'language'); $this->data["pageToLoad"] = "language/view.php"; $this->data["activeLink"] = "settings"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_language') === FALSE){ Redirect::to('/')->send(); } $this->data["title"] = print_lang($this->data["app_lang"],'add_language'); $this->data["pageToLoad"] = "language/add.php"; $this->data["activeLink"] = "settings"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'direction' => 'required', ]); $validator->validate(); $uid = getUniqueId('LANG', 'language', 'uid'); $db_array = array( 'uid' => $uid, 'name' => $request->name, 'direction' => $request->direction, 'details' => json_encode(app_default_language()), ); insert_table('language',$db_array); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'language_added'), 'message_body' => print_lang($this->data["app_lang"],'new_language_added_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_language') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('language','uid',$uid,true); $this->data["title"] = print_lang($this->data["app_lang"],'edit_language'); $this->data["pageToLoad"] = "language/edit.php"; $this->data["activeLink"] = "settings"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'direction' => 'required', ]); $validator->validate(); $db_array = array( 'name' => $request->name, 'direction' => $request->direction, ); update_table('language','uid',$uid,$db_array); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'language_updated'), 'message_body' => print_lang($this->data["app_lang"],'language_updated_successfully'))); } public function edit_phrase(Request $request, $uid) { if(check_user_access('edit_language_phrase') === FALSE){ Redirect::to('/')->send(); } $this->data["app_default_language"] = app_default_language(); $this->data["editing_data"] = fetch_table_where('language','uid',$uid,true); $this->data["title"] = print_lang($this->data["app_lang"],'edit_language_phrase'); $this->data["pageToLoad"] = "language/edit_phrase.php"; $this->data["activeLink"] = "settings"; $this->load_view($this->data); } public function update_phrase(Request $request, $uid) { $content_array = array(); $app_default_language = app_default_language(); foreach($app_default_language as $key => $value) { $content_array[$key] = $request->$key; } $db_array = array( 'details' => json_encode($content_array), ); update_table('language','uid',$uid,$db_array); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'language_updated'), 'message_body' => print_lang($this->data["app_lang"],'language_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_language') === FALSE){ Redirect::to('/')->send(); } delete_table('language','uid',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }