<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; class Leaves extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_batch') === FALSE){ Redirect::to('/')->send(); } $leaves = DB::table('leaves'); if(!empty($request->currency)){ $leaves->where('currency',$request->currency); } if(!empty($request->user)){ $leaves->where('user',$request->user); } if(!empty($request->from)){ $leaves->where('l_date','>=',$request->from); } if(!empty($request->to)){ $leaves->where('l_date','<=',$request->to); } $this->data["pageData"] = json_decode(json_encode($leaves->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["users"] = set_array_keys(fetch_branch_users(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_user"] = $request->user; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'leaves'); $this->data["pageToLoad"] = "leaves/view.php"; $this->data["activeLink"] = "hrm"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_batch') === FALSE){ Redirect::to('/')->send(); } $this->data["currencies"] = fetch_currencies(); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'add_leave'); $this->data["pageToLoad"] = "leaves/add.php"; $this->data["activeLink"] = "hrm"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'l_date' => 'required', 'out_time' => 'required', 'reason' => 'required', 'currency' => 'required', 'expense' => 'required', 'account' => 'required', ]); $validator->validate(); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $uid = getUniqueId('OLEV', 'leaves', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'l_date' => $request->l_date, 'out_time' => $request->out_time, 'reason' => $request->reason, 'currency' => $request->currency, 'currency_usd_equalance' => $currency_data['usd_equalance'], 'expense' => $request->expense, 'account' => $request->account, 'user' => Session::get('user_id'), ); insert_table('leaves',$db_array); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'leave_saved'), 'message_body' => print_lang($this->data["app_lang"],'leave_saved_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_batch') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('leaves','uid',$uid,true); $this->data["currencies"] = fetch_currencies(); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'edit_leave'); $this->data["pageToLoad"] = "leaves/edit.php"; $this->data["activeLink"] = "hrm"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'l_date' => 'required', 'out_time' => 'required', 'reason' => 'required', 'currency' => 'required', 'expense' => 'required', 'account' => 'required', ]); $validator->validate(); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'l_date' => $request->l_date, 'out_time' => $request->out_time, 'reason' => $request->reason, 'currency' => $request->currency, 'currency_usd_equalance' => $currency_data['usd_equalance'], 'expense' => $request->expense, 'account' => $request->account, ); update_table('leaves','uid',$uid,$db_array); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'leave_updated'), 'message_body' => print_lang($this->data["app_lang"],'leave_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_batch') === FALSE){ Redirect::to('/')->send(); } delete_table('leaves','uid',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function save_return(Request $request) { $validator = Validator::make($request->request->all(), [ 'uid' => 'required', 'in_time' => 'required', 'comments' => 'required', ]); $validator->validate(); $db_array = array( 'in_time' => $request->in_time, 'comments' => $request->comments, ); $leaves_data = fetch_table_where('leaves','uid',$request->uid,TRUE); $attachment_link = false; if($request->hasFile('attachment')) { $file = $request->file('attachment'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('LAMT'); $fileNamePrefix = db_unique_id('leaves',$fileNamePrefix); $attachment = $fileNamePrefix.'.'.$extension; $file->move('uploads/leaves/',$attachment); $db_array['attachment'] = $attachment; if(!empty($leaves_data["attachment"])) { File::delete('uploads/leaves/'.$leaves_data["attachment"]); } $attachment_link = '<a class="btn btn-primary btn-xs" target="_blank" href="'.url('/').'/uploads/leaves/'.$attachment.'">'.print_lang($this->data["app_lang"],'preview').'</a>'; } if($attachment_link == false) { if(!empty($leaves_data["attachment"])) { $attachment_link = '<a class="btn btn-primary btn-xs" target="_blank" href="'.url('/').'/uploads/leaves/'.$leaves_data['attachment'].'">'.print_lang($this->data["app_lang"],'preview').'</a>'; } else { $attachment_link = '<span class="label label-info">'.print_lang($this->data["app_lang"],'no_image').'</span>'; } } update_table('leaves','uid',$request->uid,$db_array); echo json_encode(array('status' => 'success', 'mood' => 'update', 'attachment' => $attachment_link, 'uid' => $request->uid, 'in_time' => $request->in_time, 'comments' => $request->comments, 'message_head' => print_lang($this->data["app_lang"],'leave_updated'), 'message_body' => print_lang($this->data["app_lang"],'leave_updated_successfully'))); } }