<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; class Load_delivery extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_shor_load_delivery') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $load_delivery = DB::table('load_delivery')->where('branch',$branch_id); if(!empty($request->currency)){ $load_delivery->where('currency',$request->currency); } if(!empty($request->account)){ $load_delivery->where('account',$request->account); } if(!empty($request->from)){ $load_delivery->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $load_delivery->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($load_delivery->get()),true); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_account"] = $request->account; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'load_deliveries'); $this->data["pageToLoad"] = "load_delivery/view.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function invoice(Request $request,$uid) { if(check_user_access('invoice_shor_load_delivery') === FALSE){ Redirect::to('/')->send(); } $this->data["invoice_data"] = fetch_table_where('car_purchases','uid',$uid,true); $this->data["invoice_details"] = fetch_table_where('car_purchases_details','purchase_id',$this->data["invoice_data"]['uid']); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'car_purchase_invoice'); $this->data["pageToLoad"] = "car_purchases/invoice.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_shor_load_delivery') === FALSE){ Redirect::to('/')->send(); } $this->data["accounts"] = fetch_nested_accounts(); $this->data["currencies"] = fetch_currencies(); $this->data["purchases"] = fetch_table_branch('car_purchases'); $this->data["title"] = print_lang($this->data["app_lang"],'new_load_delivery'); $this->data["pageToLoad"] = "load_delivery/add.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'purchase' => 'required', 'account' => 'required', 'load_plate' => 'required|unique:load_delivery', 'load_expenses' => 'required', 'charges' => 'required', ]); $validator->validate(); $uid = getUniqueId('LDLV', 'load_delivery', 'uid'); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $currency_usd_equalance = isset($currency_data['usd_equalance']) ? $currency_data['usd_equalance'] : '1'; $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'purchase' => implode(',',$request->purchase), 'currency' => $request->currency, 'currency_usd_equalance' => $currency_usd_equalance, 'account' => $request->account, 'load_plate' => $request->load_plate, 'load_expenses' => (float)$request->load_expenses, 'charges' => (float)$request->charges, 'total' => (float)$request->total, 'cash_paid' => (float)$request->cash_paid, 'cash_paid_account' => $request->cash_paid_account, 'pending' => (float)$request->pending, ); if($request->hasFile('document')) { $file = $request->file('document'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('LDDC'); $fileNamePrefix = db_unique_id('load_delivery',$fileNamePrefix); $document = $fileNamePrefix.'.'.$extension; $file->move('uploads/load-delivery/',$document); $db_array['document'] = $document; } if(is_array($request->purchase) AND count($request->purchase) > 0) { $number_of_cars_in_purchase = array(); foreach($request->purchase as $purchase_id) { $purchase_cars = fetch_table_where('car_purchases_details','purchase_id',$purchase_id); $number_of_cars_in_purchase[] = count($purchase_cars); } $load_expenses = (float)$db_array['total']; $number_of_cars = array_sum($number_of_cars_in_purchase); $per_car_load_expenses = $load_expenses / $number_of_cars; $db_array['per_car_expenses'] = $per_car_load_expenses; foreach($request->purchase as $purchase_id) { $purchase_cars = fetch_table_where('car_purchases_details','purchase_id',$purchase_id); if(is_array($purchase_cars) AND count($purchase_cars) > 0) { foreach($purchase_cars as $car) { $per_car_load_expenses = amount_conversion($per_car_load_expenses, (float)$db_array['currency_usd_equalance'], (float)$car['currency_usd_equalance']); $car_existing_expenses = (float)$car['load_delivery_expenses']; $car_new_expenses = $car_existing_expenses + $per_car_load_expenses; update_table('car_purchases_details','uid',$car['uid'],array('load_delivery_expenses' => $car_new_expenses)); } } } } insert_table('load_delivery',$db_array); _handle_load_delivery_ledger_effects(['uid' => $uid, 'state' => 'new']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_load_delivery'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/load-deliveries/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_load_plate_num').' '.$db_array['load_plate'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['total']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'load_delivery_saved'), 'message_body' => print_lang($this->data["app_lang"],'load_delivery_saved_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_shor_load_delivery') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('load_delivery','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/load-deliveries')->send(); } $this->data["accounts"] = fetch_nested_accounts(); $this->data["currencies"] = fetch_currencies(); $this->data["purchases"] = fetch_table_branch('car_purchases'); $this->data["title"] = print_lang($this->data["app_lang"],'edit_load_delivery'); $this->data["pageToLoad"] = "load_delivery/edit.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'purchase' => 'required', 'account' => 'required', 'load_plate' => ['required',Rule::unique('load_delivery')->ignore($uid, 'uid')], 'load_expenses' => 'required', 'charges' => 'required', ]); $validator->validate(); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $currency_usd_equalance = isset($currency_data['usd_equalance']) ? $currency_data['usd_equalance'] : '1'; $db_array = array( 'purchase' => implode(',',$request->purchase), 'currency' => $request->currency, 'currency_usd_equalance' => $currency_usd_equalance, 'account' => $request->account, 'load_plate' => $request->load_plate, 'load_expenses' => $request->load_expenses, 'charges' => $request->charges, 'total' => $request->total, 'cash_paid' => $request->cash_paid, 'cash_paid_account' => $request->cash_paid_account, 'pending' => $request->pending, ); $delivery_data = fetch_table_where('Load_delivery','uid',$uid,TRUE); if($request->hasFile('document')) { $file = $request->file('document'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('LDDC'); $fileNamePrefix = db_unique_id('Load_delivery',$fileNamePrefix); $document = $fileNamePrefix.'.'.$extension; $file->move('uploads/load-delivery/',$document); $db_array['document'] = $document; File::delete('uploads/load-delivery/'.$delivery_data["document"]); } if(is_array($request->purchase) AND count($request->purchase) > 0) { $number_of_cars_in_purchase = array(); foreach($request->purchase as $purchase_id) { $purchase_cars = fetch_table_where('car_purchases_details','purchase_id',$purchase_id); $number_of_cars_in_purchase[] = count($purchase_cars); } $per_car_delivery_expenses_before_update = (float)$delivery_data["per_car_expenses"]; $load_expenses = (float)$db_array['total']; $number_of_cars = array_sum($number_of_cars_in_purchase); $per_car_load_expenses = $load_expenses / $number_of_cars; $db_array['per_car_expenses'] = $per_car_load_expenses; foreach($request->purchase as $purchase_id) { $purchase_cars = fetch_table_where('car_purchases_details','purchase_id',$purchase_id); if(is_array($purchase_cars) AND count($purchase_cars) > 0) { foreach($purchase_cars as $car) { $_per_car_load_expenses = amount_conversion($per_car_load_expenses, (float)$db_array['currency_usd_equalance'], (float)$car['currency_usd_equalance']); $_per_car_delivery_expenses_before_update = amount_conversion($per_car_delivery_expenses_before_update, (float)$db_array['currency_usd_equalance'], (float)$car['currency_usd_equalance']); $car_existing_expenses = (float)$car['load_delivery_expenses']; $car_new_expenses = $car_existing_expenses + $_per_car_load_expenses; $car_new_expenses = $car_new_expenses - $_per_car_delivery_expenses_before_update; update_table('car_purchases_details','uid',$car['uid'],array('load_delivery_expenses' => $car_new_expenses)); } } } } update_table('Load_delivery','uid',$uid,$db_array); _handle_load_delivery_ledger_effects(['uid' => $uid, 'state' => 'update']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_load_delivery'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/load-deliveries/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_load_plate_num').' '.$db_array['load_plate'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['total']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'load_delivery_updated'), 'message_body' => print_lang($this->data["app_lang"],'load_delivery_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_shor_load_delivery') === FALSE){ Redirect::to('/')->send(); } $load_data = fetch_table_where('load_delivery','uid',$uid,true); if(!empty($load_data["document"])){ File::delete('uploads/load-delivery/'.$load_data["document"]); } $load_purchases = explode(',',$load_data['purchase']); if(is_array($load_purchases) AND count($load_purchases) > 0) { $per_car_delivery_expenses_before_update = (float)$load_data["per_car_expenses"]; foreach($load_purchases as $purchase_id) { $purchase_cars = fetch_table_where('car_purchases_details','purchase_id',$purchase_id); if(is_array($purchase_cars) AND count($purchase_cars) > 0) { foreach($purchase_cars as $car) { $_per_car_delivery_expenses_before_update = amount_conversion($per_car_delivery_expenses_before_update, (float)$load_data['currency_usd_equalance'], (float)$car['currency_usd_equalance']); $car_existing_expenses = (float)$car['load_delivery_expenses']; $car_new_expenses = $car_existing_expenses - $_per_car_delivery_expenses_before_update; update_table('car_purchases_details','uid',$car['uid'],array('load_delivery_expenses' => $car_new_expenses)); } } } } $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_load_delivery'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_load_plate_num').' '.$load_data['load_plate'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($load_data['total']), ); set_activity_alert($_activity_details); delete_table('load_delivery','uid',$uid); _handle_load_delivery_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }