<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; class Lot extends Setup { public function __construct() { parent::__construct(); $this->middleware(function ($request, $next) { $item_settings = get_item_settings(); if($item_settings['fuel_parts'] != 'enable') { Redirect::to('/')->send(); } else { return $next($request); } }); } public function view(Request $request) { if(check_user_access('view_lot_purchase') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $purchases = DB::table('lot')->where('branch',$branch_id); if(!empty($request->currency)){ $purchases->where('currency',$request->currency); } if(!empty($request->supplier)){ $purchases->where('supplier',$request->supplier); } if(!empty($request->from)){ $purchases->where('lot_date','>=',get_true_date($request->from)); } if(!empty($request->to)){ $purchases->where('lot_date','<=',get_true_date($request->to)); } $purchases = $purchases->get(); $purchases = json_decode(json_encode($purchases),true); $this->data["pageData"] = $purchases; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_supplier"] = $request->supplier; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'lot_purchase'); $this->data["pageToLoad"] = "lot/view.php"; $this->data["activeLink"] = "lot"; $this->load_view($this->data); } public function invoice(Request $request,$uid) { if(check_user_access('add_lot_purchase') === FALSE){ Redirect::to('/')->send(); } if(!$request->has('type') OR !$request->filled('type')){ die('System found invalid request! Go Back'); } $this->data["invoice_data"] = fetch_table_where('lot','uid',$uid,true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["transits"] = set_array_keys(fetch_table_where_branch('accounts','type','transit'),'uid'); $this->data["invoice_type"] = $request->type; $this->data["title"] = print_lang($this->data["app_lang"],'lot_purchase_invoice'); $this->data["pageToLoad"] = "lot/invoice.php"; $this->data["activeLink"] = "lot"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_lot_purchase') === FALSE){ Redirect::to('/')->send(); } $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["suppliers"] = fetch_table_where_branch('accounts','type','supplier'); $this->data["transits"] = fetch_table_where_branch('accounts','type','transit'); $this->data["expenses"] = $this->data["transits"]; $this->data["pending_weight"] = get_tankers_pending_weight(); $this->data["receipt_num"] = get_lot_purchase_invoice(); $this->data["title"] = print_lang($this->data["app_lang"],'add_lot_purchase'); $this->data["pageToLoad"] = "lot/add.php"; $this->data["activeLink"] = "lot"; $this->load_view($this->data); } public function save(Request $request) { $items_found = false; $active_branch_id = active_branch_id(); $lot_collection_of_list = array(); $lot_collection_of_transits = array(); $lot_collection_of_expenses = array(); $lot_purchase_type = $request->lot_purchase_type; $lot_division_list = array(); $lot_division_transits = array(); $lot_division_expenses = array(); $receipt = (float)$request->receipt[0]; $receipt_exist = DB::table('lot')->where('receipt',$receipt)->get(); if($receipt_exist->count() > 0) { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => 'receipt_exist', 'message_body' => 'receipt_number_exist')); die; } if(count($request->weight) > 0) { $items_count = 0; while($items_count < count($request->weight)) { if(empty($request->weight[$items_count])){ continue; } $items_found = true; $item_array = array( 'uid' => generate_uid(), 'transit_account' => $request->transit_account[$items_count], 'expense_account' => $request->expense_account[$items_count], 'fuel_type' => $request->fuel_type[$items_count], 'driver' => $request->driver[$items_count], 'mobile' => $request->mobile[$items_count], 'plate' => $request->plate[$items_count], 'cmr' => $request->cmr[$items_count], 'weight' => $request->weight[$items_count], 'weight_plus' => $request->weight_plus[$items_count], 'weight_minus' => $request->weight_minus[$items_count], 'weight_lose' => $request->weight_lose[$items_count], 'gross_weight' => $request->gross_weight[$items_count], 'cost' => (float)$request->cost[$items_count], 'rent' => (float)$request->rent[$items_count], 'rent_currency' => $request->rent_currency[$items_count], 'rent_currency_usd_equalance' => (float)$request->rent_currency_usd_equalance[$items_count], 'expenses' => (float)$request->expenses[$items_count], 'expenses_currency' => $request->expenses_currency[$items_count], 'expenses_currency_usd_equalance' => (float)$request->expenses_currency_usd_equalance[$items_count], 'real_cost' => (float)$request->real_cost[$items_count], 'total_cost' => (float)$request->total_cost[$items_count], ); $lot_collection_of_list[] = $item_array; $lot_collection_of_transits[] = '-++-'.$request->transit_account[$items_count].'-++-'; $lot_collection_of_expenses[] = '-++-'.$request->expense_account[$items_count].'-++-'; $items_count++; } } if($lot_purchase_type == 'iran_to_border') { if(count($request->div_weight) > 0) { $items_count = 0; while($items_count < count($request->div_weight)) { if(empty($request->div_weight[$items_count])){ continue; } $item_array = array( 'uid' => generate_uid(), 'transit_account' => $request->div_transit_account[$items_count], 'expense_account' => $request->div_expense_account[$items_count], 'driver' => $request->div_driver[$items_count], 'mobile' => $request->div_mobile[$items_count], 'plate' => $request->div_plate[$items_count], 'cmr' => $request->div_cmr[$items_count], 'weight' => $request->div_weight[$items_count], 'weight_plus' => $request->div_weight_plus[$items_count], 'weight_minus' => $request->div_weight_minus[$items_count], 'weight_lose' => $request->div_weight_lose[$items_count], 'gross_weight' => $request->div_gross_weight[$items_count], 'cost' => (float)$request->div_cost[$items_count], 'rent' => (float)$request->div_rent[$items_count], 'rent_currency' => $request->div_rent_currency[$items_count], 'rent_currency_usd_equalance' => (float)$request->div_rent_currency_usd_equalance[$items_count], 'expenses' => (float)$request->div_expenses[$items_count], 'expenses_currency' => $request->div_expenses_currency[$items_count], 'expenses_currency_usd_equalance' => (float)$request->div_expenses_currency_usd_equalance[$items_count], 'real_cost' => (float)$request->div_real_cost[$items_count], 'total_cost' => (float)$request->div_total_cost[$items_count], ); $lot_division_list[] = $item_array; $lot_collection_of_transits[] = '-++-'.$request->div_transit_account[$items_count].'-++-'; $lot_collection_of_expenses[] = '-++-'.$request->div_expense_account[$items_count].'-++-'; $items_count++; } } } if($items_found == true) { $supplier_old_balance = get_account_balance($request->supplier[0],$request->currency[0]); $email_attachment = NULL; if($request->hasFile('email_attachment')) { $file = $request->file('email_attachment'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('LESS'); $fileNamePrefix = db_unique_id('lot',$fileNamePrefix); $email_attachment = $fileNamePrefix.'.'.$extension; $file->move('uploads/screenshots/',$email_attachment); } $uid = getUniqueId('LOTP', 'lot', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => $active_branch_id, 'currency' => $request->currency[0], 'currency_usd_equalance' => $request->currency_usd_equalance[0], 'supplier' => $request->supplier[0], 'old_balance' => $supplier_old_balance, 'lot_date' => $request->date[0], 'receipt' => $request->receipt[0], 'email_attachment' => $email_attachment, 'total_weight' => $request->total_weight, 'total_gross_weight' => $request->total_gross_weight, 'total_cost' => (float)$request->total_tcost, 'total_rent' => (float)$request->total_rent, 'total_expenses' => (float)$request->total_expenses, 'total_real_cost' => (float)$request->total_real_cost, 'lot_list' => json_encode($lot_collection_of_list), 'transits' => implode(',', $lot_collection_of_transits), 'expenses' => implode(',', $lot_collection_of_expenses), 'division_list' => json_encode($lot_division_list), 'total_division_weight' => $request->total_division_weight, 'total_division_gross_weight' => $request->total_division_gross_weight, 'total_division_tcost' => (float)$request->total_division_tcost, 'total_division_rent' => (float)$request->total_division_rent, 'total_division_expenses' => (float)$request->total_division_expenses, 'total_division_real_cost' => (float)$request->total_division_real_cost, 'pending_weight' => (float)$request->pending_weight, 'purchase_type' => $request->lot_purchase_type, ); insert_table('lot',$db_array); _handle_lot_ledger_effects(['uid' => $uid, 'state' => 'new']); $activity_real_cost = ($db_array['purchase_type'] == 'iran_to_border') ? $db_array['total_division_real_cost'] : $db_array['total_real_cost']; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_lot_purchase'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/lot-purchase/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_receipt').' '.$db_array['receipt'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_cost').': '.amount_number_format($activity_real_cost), ); set_activity_alert($_activity_details); $invoice_url = url('/lot-purchase/invoice').'/'.$uid; $receipt_num = get_lot_purchase_invoice(); $tankers_new_pending_weight = get_tankers_pending_weight(); echo json_encode(array('status' => 'success', 'mood' => 'new', 'tankers_new_pending_weight' => $tankers_new_pending_weight, 'receipt_num' => $receipt_num, 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'lot_added'), 'message_body' => print_lang($this->data["app_lang"],'lot_added_successfully'))); } else { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'item_not_found'), 'message_body' => print_lang($this->data["app_lang"],'add_items_to_proceed'))); } } public function edit(Request $request, $uid) { if(check_user_access('edit_lot_purchase') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('lot','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/lot-purchase')->send(); } $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["suppliers"] = fetch_table_where_branch('accounts','type','supplier'); $this->data["transits"] = fetch_table_where_branch('accounts','type','transit'); $this->data["expenses"] = $this->data["transits"]; $this->data["title"] = print_lang($this->data["app_lang"],'edit_lot'); $this->data["pageToLoad"] = "lot/edit.php"; $this->data["activeLink"] = "lot"; $this->load_view($this->data); } public function update(Request $request, $uid) { $items_found = false; $active_branch_id = active_branch_id(); $lot_collection_of_list = array(); $lot_collection_of_transits = array(); $lot_collection_of_expenses = array(); $lot_purchase_type = $request->lot_purchase_type; $lot_division_list = array(); $lot_division_transits = array(); $lot_division_expenses = array(); $receipt = (float)$request->receipt[0]; $receipt_exist = DB::table('lot')->where('uid','!=',$uid)->where('receipt',$receipt)->get(); if($receipt_exist->count() > 0) { echo json_encode(array('status' => 'error', 'mood' => 'update', 'message_head' => 'receipt_exist', 'message_body' => 'receipt_number_exist')); die; } if(count($request->weight) > 0) { $items_count = 0; while($items_count < count($request->weight)) { if(empty($request->weight[$items_count])){ continue; } $items_found = true; $item_uid = $request->uid[$items_count]; if(empty($item_uid)) { $item_uid = generate_uid(); } $item_array = array( 'uid' => $item_uid, 'transit_account' => $request->transit_account[$items_count], 'expense_account' => $request->expense_account[$items_count], 'fuel_type' => $request->fuel_type[$items_count], 'driver' => $request->driver[$items_count], 'mobile' => $request->mobile[$items_count], 'plate' => $request->plate[$items_count], 'cmr' => $request->cmr[$items_count], 'weight' => $request->weight[$items_count], 'weight_plus' => $request->weight_plus[$items_count], 'weight_minus' => $request->weight_minus[$items_count], 'weight_lose' => $request->weight_lose[$items_count], 'gross_weight' => $request->gross_weight[$items_count], 'cost' => (float)$request->cost[$items_count], 'rent' => (float)$request->rent[$items_count], 'rent_currency' => $request->rent_currency[$items_count], 'rent_currency_usd_equalance' => (float)$request->rent_currency_usd_equalance[$items_count], 'expenses' => (float)$request->expenses[$items_count], 'expenses_currency' => $request->expenses_currency[$items_count], 'expenses_currency_usd_equalance' => (float)$request->expenses_currency_usd_equalance[$items_count], 'real_cost' => (float)$request->real_cost[$items_count], 'total_cost' => (float)$request->total_cost[$items_count], ); $lot_collection_of_list[] = $item_array; $lot_collection_of_transits[] = '-++-'.$request->transit_account[$items_count].'-++-'; $lot_collection_of_expenses[] = '-++-'.$request->expense_account[$items_count].'-++-'; $items_count++; } } if($lot_purchase_type == 'iran_to_border') { if(count($request->div_weight) > 0) { $items_count = 0; while($items_count < count($request->div_weight)) { if(empty($request->div_weight[$items_count])){ continue; } $item_uid = $request->div_uid[$items_count]; if(empty($item_uid)) { $item_uid = generate_uid(); } $item_array = array( 'uid' => $item_uid, 'transit_account' => $request->div_transit_account[$items_count], 'expense_account' => $request->div_expense_account[$items_count], 'driver' => $request->div_driver[$items_count], 'mobile' => $request->div_mobile[$items_count], 'plate' => $request->div_plate[$items_count], 'cmr' => $request->div_cmr[$items_count], 'weight' => $request->div_weight[$items_count], 'weight_plus' => $request->div_weight_plus[$items_count], 'weight_minus' => $request->div_weight_minus[$items_count], 'weight_lose' => $request->div_weight_lose[$items_count], 'gross_weight' => $request->div_gross_weight[$items_count], 'cost' => (float)$request->div_cost[$items_count], 'rent' => (float)$request->div_rent[$items_count], 'rent_currency' => $request->div_rent_currency[$items_count], 'rent_currency_usd_equalance' => (float)$request->div_rent_currency_usd_equalance[$items_count], 'expenses' => (float)$request->div_expenses[$items_count], 'expenses_currency' => $request->div_expenses_currency[$items_count], 'expenses_currency_usd_equalance' => (float)$request->div_expenses_currency_usd_equalance[$items_count], 'real_cost' => (float)$request->div_real_cost[$items_count], 'total_cost' => (float)$request->div_total_cost[$items_count], ); $lot_division_list[] = $item_array; $lot_collection_of_transits[] = '-++-'.$request->div_transit_account[$items_count].'-++-'; $lot_collection_of_expenses[] = '-++-'.$request->div_expense_account[$items_count].'-++-'; $items_count++; } } } if($items_found == true) { $supplier_old_balance = get_account_balance($request->supplier[0],$request->currency[0]); $deleted_items = $request->deleted; if(is_array($deleted_items)) { foreach($deleted_items as $del_item_uid) { delete_table('lot_sold','child',$del_item_uid); $purchase_data = fetch_table_where('purchases','lot_child_id',$del_item_uid,true); delete_table('purchases','lot_child_id',$del_item_uid); $_items_effected = array(); $purchase_items_before_delete = empty($purchase_data['items']) ? array() : json_decode($purchase_data['items'],true); foreach($purchase_items_before_delete as $old_item){ $_items_effected[] = $old_item['item']; } if(count($_items_effected) > 0){ $_items_effected = array_unique($_items_effected); } foreach($_items_effected as $item_uid){ _handle_item_stats(['uid' => $item_uid]); } } } $div_deleted_items = $request->div_deleted; if(is_array($div_deleted_items)) { foreach($div_deleted_items as $del_item_uid) { delete_table('lot_sold','child',$del_item_uid); $purchase_data = fetch_table_where('purchases','lot_child_id',$del_item_uid,true); delete_table('purchases','lot_child_id',$del_item_uid); $_items_effected = array(); $purchase_items_before_delete = empty($purchase_data['items']) ? array() : json_decode($purchase_data['items'],true); foreach($purchase_items_before_delete as $old_item){ $_items_effected[] = $old_item['item']; } if(count($_items_effected) > 0){ $_items_effected = array_unique($_items_effected); } foreach($_items_effected as $item_uid){ _handle_item_stats(['uid' => $item_uid]); } } } $db_array = array( 'currency' => $request->currency[0], 'currency_usd_equalance' => $request->currency_usd_equalance[0], 'supplier' => $request->supplier[0], 'old_balance' => $supplier_old_balance, 'lot_date' => $request->date[0], 'receipt' => $request->receipt[0], 'total_weight' => $request->total_weight, 'total_gross_weight' => $request->total_gross_weight, 'total_cost' => (float)$request->total_tcost, 'total_rent' => (float)$request->total_rent, 'total_expenses' => (float)$request->total_expenses, 'total_real_cost' => (float)$request->total_real_cost, 'lot_list' => json_encode($lot_collection_of_list), 'transits' => implode(',', $lot_collection_of_transits), 'expenses' => implode(',', $lot_collection_of_expenses), 'division_list' => json_encode($lot_division_list), 'total_division_weight' => $request->total_division_weight, 'total_division_gross_weight' => $request->total_division_gross_weight, 'total_division_tcost' => (float)$request->total_division_tcost, 'total_division_rent' => (float)$request->total_division_rent, 'total_division_expenses' => (float)$request->total_division_expenses, 'total_division_real_cost' => (float)$request->total_division_real_cost, 'pending_weight' => (float)$request->pending_weight, 'purchase_type' => $request->lot_purchase_type, ); $lot_data = fetch_table_where('lot','uid',$uid,TRUE); if($request->hasFile('email_attachment')) { $file = $request->file('email_attachment'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('LESS'); $fileNamePrefix = db_unique_id('lot',$fileNamePrefix); $email_attachment = $fileNamePrefix.'.'.$extension; $file->move('uploads/screenshots/',$email_attachment); $db_array['email_attachment'] = $email_attachment; File::delete('uploads/screenshots/'.$lot_data["email_attachment"]); } update_table('lot','uid',$uid,$db_array); _handle_lot_ledger_effects(['uid' => $uid, 'state' => 'update']); $activity_lot_weight = ($db_array['purchase_type'] == 'iran_to_border') ? $db_array['total_division_weight'] : $db_array['total_weight']; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_lot_purchase'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/lot-purchase/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_receipt').' '.$db_array['receipt'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_weight').': '.amount_number_format($activity_lot_weight), ); set_activity_alert($_activity_details); $invoice_url = url('/lot-purchase/invoice').'/'.$uid; echo json_encode(array('status' => 'success', 'mood' => 'update', 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'lot_updated'), 'message_body' => print_lang($this->data["app_lang"],'lot_updated_successfully'))); } else { echo json_encode(array('status' => 'error', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'item_not_found'), 'message_body' => print_lang($this->data["app_lang"],'add_items_to_proceed'))); } } public function delete($uid) { if(check_user_access('delete_lot_purchase') === FALSE){ Redirect::to('/')->send(); } $lot_data = fetch_table_where('lot','uid',$uid,TRUE); if(!empty($lot_data["email_attachment"])){ File::delete('uploads/screenshots/'.$lot_data["email_attachment"]); } $activity_lot_weight = ($lot_data['purchase_type'] == 'iran_to_border') ? $lot_data['total_division_weight'] : $lot_data['total_weight']; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_lot_purchase'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_receipt').' '.$lot_data['receipt'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_weight').': '.amount_number_format($activity_lot_weight), ); set_activity_alert($_activity_details); delete_table('lot','uid',$uid); delete_table('lot_sold','parent',$uid); $purchases = fetch_table_where('purchases','lot_id',$uid); delete_table('purchases','lot_id',$uid); foreach($purchases as $purchase_data) { $_items_effected = array(); $purchase_items_before_delete = empty($purchase_data['items']) ? array() : json_decode($purchase_data['items'],true); foreach($purchase_items_before_delete as $old_item){ $_items_effected[] = $old_item['item']; } if(count($_items_effected) > 0){ $_items_effected = array_unique($_items_effected); } foreach($_items_effected as $item_uid){ _handle_item_stats(['uid' => $item_uid]); } } _handle_lot_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function avail(Request $request) { if(check_user_access('view_avail_lot') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $purchases = DB::table('lot')->where('branch',$branch_id); if(!empty($request->currency)){ $purchases->where('currency',$request->currency); } if(!empty($request->supplier)){ $purchases->where('supplier',$request->supplier); } if(!empty($request->type)){ $purchases->where('purchase_type',$request->type); } if(!empty($request->from)){ $purchases->where('lot_date','>=',get_true_date($request->from)); } if(!empty($request->to)){ $purchases->where('lot_date','<=',get_true_date($request->to)); } $purchases = $purchases->get(); $purchases = json_decode(json_encode($purchases),true); $this->data["pageData"] = $purchases; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["transits"] = set_array_keys(fetch_table_where_branch('accounts','type','transit'),'uid'); $this->data["expenses"] = $this->data["transits"]; $this->data["accounts"] = fetch_nested_accounts(); $this->data["items"] = fetch_table_branch('items'); $this->data["warehouse"] = fetch_table_branch('warehouse'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["lot_sales"] = set_array_keys(fetch_table_branch('lot_sold'),'child'); $this->data["moved_lots"] = set_array_keys(fetch_table_where_branch('purchases','incoming','LOT'),'lot_child_id'); $this->data["search_currency"] = $request->currency; $this->data["search_type"] = $request->type; $this->data["search_supplier"] = $request->supplier; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'lot_purchase_avail'); $this->data["pageToLoad"] = "lot/avail.php"; $this->data["activeLink"] = "lot"; $this->load_view($this->data); } public function invoice_sale_data(Request $request) { if(!empty($request->parent_id)) { $parent_id = $request->parent_id; $lot_data = DB::table('lot')->where('uid',$parent_id)->get(); if($lot_data->count() > 0) { $lot_data = json_decode(json_encode($lot_data[0]),true); if($lot_data['purchase_type'] == 'iran_to_border') { $lot_list = json_decode($lot_data['division_list'],true); } else { $lot_list = json_decode($lot_data['lot_list'],true); } $lot_child_found = false; $invoice_items = array(); $invoice_weight = array(); $invoice_cost = array(); foreach($lot_list as $row) { $if_lot_sold = DB::table('lot_sold')->where('uid',$row['uid'])->get(); if($if_lot_sold->count() == 0) { $lot_child_found = true; $invoice_items[] = $row['uid']; $invoice_weight[] = $row['gross_weight']; $invoice_cost[] = $row['real_cost']; } } if($lot_child_found === true) { $client_sales = fetch_lot_sold_invoices(); echo json_encode(array('status' => 'success', 'parent' => $lot_data, 'items_count' => count($invoice_items), 'items' => implode(',',$invoice_items), 'weight' => implode(',',$invoice_weight), 'cost' => implode(',',$invoice_cost), 'client_sales' => $client_sales)); } else { echo json_encode(array('status' => 'sold', 'message_head' => 'invoice_sold', 'message_body' => 'invoice_already_sold')); } } else { echo json_encode(array('status' => 'error', 'message_head' => 'Invalid Request', 'message_body' => 'invalid_request_body')); } } else { echo json_encode(array('status' => 'error', 'message_head' => 'Invalid Request', 'message_body' => 'invalid_request_body')); } } public function save_sold_invoice(Request $request) { if(empty($request->invoice_parent_uid)) { echo json_encode(array('status' => 'error', 'message_head' => 'Invalid Request', 'message_body' => 'invalid_request_body')); } else { $lot_invoice_data = DB::table('lot')->where('uid',$request->invoice_parent_uid)->get(); if($lot_invoice_data->count() > 0) { $lot_invoice_data = json_decode(json_encode($lot_invoice_data[0]),true); $lot_tankers_list = ($lot_invoice_data['purchase_type'] == 'iran_to_border') ? json_decode($lot_invoice_data['division_list'],true) : json_decode($lot_invoice_data['lot_list'],true); $currency_db_data = fetch_table_where('currency','uid',$request->_invoice_sold_currency,true); if(empty($request->_invoice_sold_invoice)) { $sold_invoice = get_lot_sold_invoice(); $invoice_merged = 'NO'; } else { $sold_invoice = $request->_invoice_sold_invoice; $invoice_merged = 'YES'; } $invoice_tankers = explode(',',$request->invoice_child_uid); $uid = NULL; $tankers_uids = array(); foreach($invoice_tankers as $tanker_uid) { $uid = generate_uid(); $tanker_weight = 0; $tanker_real_cost = 0; $tanker_difference_type = 'plus'; $tanker_difference = 0; $tanker_profit = 0; $tanker_total_profit = 0; $tanker_total_sale_price = 0; foreach($lot_tankers_list as $lot_tanker) { if($lot_tanker['uid'] == $tanker_uid) { $tanker_weight = $lot_tanker['gross_weight']; $tanker_real_cost = $lot_tanker['real_cost']; $tanker_real_cost = amount_conversion($tanker_real_cost, $lot_invoice_data['currency_usd_equalance'], $currency_db_data['usd_equalance']); $tanker_profit = (float)$request->_invoice_sold_sale_price - $tanker_real_cost; $tanker_total_profit = $tanker_profit * $tanker_weight; $tanker_total_sale_price = (float)$request->_invoice_sold_sale_price * $tanker_weight; } } $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'parent' => $request->invoice_parent_uid, 'child' => $tanker_uid, 'currency' => $request->_invoice_sold_currency, 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'client' => $request->_invoice_sold_client, 'invoice' => $sold_invoice, 'invoice_merged' => $invoice_merged, 'weight' => $tanker_weight, 'difference_type' => $tanker_difference_type, 'difference' => $tanker_difference, 'real_cost' => $tanker_real_cost, 'gross_weight' => $tanker_weight, 'sale_price' => (float)$request->_invoice_sold_sale_price, 'profit' => $tanker_profit, 'total_profit' => $tanker_total_profit, 'total' => $tanker_total_sale_price, 'discount' => 0, 'discount_amount' => 0, 'gross_amount' => $tanker_total_sale_price, 'cash' => 0, 'cash_account' => NULL, ); insert_table('lot_sold',$db_array); $tankers_uids[] = $tanker_uid; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_lot_sold'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/lot-purchase/sold', 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_weight').': '.amount_number_format($db_array['gross_weight']), ); set_activity_alert($_activity_details); } _handle_lot_ledger_effects(['uid' => $request->invoice_parent_uid, 'state' => 'update']); $invoice_url = url('/lot-purchase/sold/invoice').'/'.$uid; echo json_encode(array('status' => 'success', 'mood' => 'new', 'tankers' => implode(',',$tankers_uids), 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'sold_saved'), 'message_body' => print_lang($this->data["app_lang"],'sold_lot_saved_successfully'))); } else { echo json_encode(array('status' => 'error', 'message_head' => 'Invalid Request', 'message_body' => 'invalid_request_body')); } } } public function sale_data(Request $request) { if(!empty($request->parent_id) AND !empty($request->child_id)) { $parent_id = $request->parent_id; $child_id = $request->child_id; $lot_data = DB::table('lot')->where('uid',$parent_id)->get(); if($lot_data->count() > 0) { $lot_data = json_decode(json_encode($lot_data[0]),true); if($lot_data['purchase_type'] == 'iran_to_border') { $lot_list = json_decode($lot_data['division_list'],true); } else { $lot_list = json_decode($lot_data['lot_list'],true); } $lot_child_data = NULL; $lot_child_found = false; foreach($lot_list as $row) { if($row['uid'] == $child_id) { $lot_child_data = $row; $lot_child_found = true; } } if($lot_child_found === true) { $client_sales = fetch_lot_sold_invoices(); echo json_encode(array('status' => 'success', 'parent' => $lot_data, 'child' => $lot_child_data, 'client_sales' => $client_sales)); } else { echo json_encode(array('status' => 'error', 'message_head' => 'Invalid Request', 'message_body' => 'invalid_request_body')); } } else { echo json_encode(array('status' => 'error', 'message_head' => 'Invalid Request', 'message_body' => 'invalid_request_body')); } } else { echo json_encode(array('status' => 'error', 'message_head' => 'Invalid Request', 'message_body' => 'invalid_request_body')); } } public function save_sold(Request $request) { if(empty($request->parent_uid) AND empty($request->child_uid)) { echo json_encode(array('status' => 'error', 'message_head' => 'Invalid Request', 'message_body' => 'invalid_request_body')); } else { $uid = generate_uid(); if(empty($request->_sold_invoice)) { $sold_invoice = get_lot_sold_invoice(); $invoice_merged = 'NO'; } else { $sold_invoice = $request->_sold_invoice; $invoice_merged = 'YES'; } $currency_db_data = fetch_table_where('currency','uid',$request->_sold_currency,true); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'parent' => $request->parent_uid, 'child' => $request->child_uid, 'currency' => $request->_sold_currency, 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'client' => $request->_sold_client, 'invoice' => $sold_invoice, 'invoice_merged' => $invoice_merged, 'weight' => $request->_sold_weight, 'difference_type' => $request->_sold_difference_type, 'difference' => $request->_sold_difference, 'real_cost' => $request->lot_real_cost, 'gross_weight' => $request->_sold_gross_weight, 'saqlat' => $request->_saqlat, 'litres_qty' => $request->_litres_qty, 'sale_price' => $request->_sold_sale_price, 'profit' => $request->_sold_profit, 'total_profit' => $request->_sold_total_profit, 'total' => $request->_sold_total, 'discount' => $request->_sold_discount, 'discount_amount' => $request->_sold_discount_amount, 'gross_amount' => $request->_sold_gross_amount, 'cash' => $request->_sold_cash, 'cash_account' => $request->_sold_cash_account, ); insert_table('lot_sold',$db_array); _handle_lot_ledger_effects(['uid' => $request->parent_uid, 'state' => 'update']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_lot_sold'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/lot-purchase/sold', 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_weight').': '.amount_number_format($db_array['gross_weight']), ); set_activity_alert($_activity_details); $invoice_url = url('/lot-purchase/sold/invoice').'/'.$uid; echo json_encode(array('status' => 'success', 'mood' => 'new', 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'sold_saved'), 'message_body' => print_lang($this->data["app_lang"],'sold_lot_saved_successfully'))); } } public function edit_sale(Request $request, $uid) { if(check_user_access('view_lot_sold') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $this->data["editing_data"] = fetch_table_where('lot_sold','uid',$uid,true); $this->data["lot_data"] = fetch_table_where('lot','uid',$this->data["editing_data"]["parent"],true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["sold_invoices"] = fetch_lot_sold_invoices(); $this->data["title"] = print_lang($this->data["app_lang"],'edit_lot_sale'); $this->data["pageToLoad"] = "lot/edit_sale.php"; $this->data["activeLink"] = "lot"; $this->load_view($this->data); } public function update_sale(Request $request, $uid) { $currency_db_data = fetch_table_where('currency','uid',$request->_sold_currency,true); $db_array = array( 'parent' => $request->parent_uid, 'child' => $request->child_uid, 'currency' => $request->_sold_currency, 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'client' => $request->_sold_client, 'invoice' => $request->_sold_invoice, 'weight' => $request->_sold_weight, 'difference_type' => $request->_sold_difference_type, 'difference' => $request->_sold_difference, 'real_cost' => $request->lot_real_cost, 'gross_weight' => $request->_sold_gross_weight, 'saqlat' => $request->_saqlat, 'litres_qty' => $request->_litres_qty, 'sale_price' => $request->_sold_sale_price, 'profit' => $request->_sold_profit, 'total_profit' => $request->_sold_total_profit, 'total' => $request->_sold_total, 'discount' => $request->_sold_discount, 'discount_amount' => $request->_sold_discount_amount, 'gross_amount' => $request->_sold_gross_amount, 'cash' => $request->_sold_cash, 'cash_account' => $request->_sold_cash_account, ); update_table('lot_sold','uid',$uid,$db_array); _handle_lot_ledger_effects(['uid' => $request->parent_uid, 'state' => 'update']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_lot_sold'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/lot-purchase/sold', 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_weight').': '.amount_number_format($db_array['gross_weight']), ); set_activity_alert($_activity_details); $invoice_url = url('/lot-purchase/sold/invoice').'/'.$uid; echo json_encode(array('status' => 'success', 'mood' => 'update', 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'lot_sold_updated'), 'message_body' => print_lang($this->data["app_lang"],'sold_lot_updated_successfully'))); } public function sales(Request $request) { if(check_user_access('view_lot_sold') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $lot_sales = DB::table('lot_sold')->where('branch',$branch_id); if(!empty($request->client)){ $lot_sales->where('client',$request->client); } if(!empty($request->from)){ $lot_sales->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $lot_sales->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $lot_sales = $lot_sales->get(); $lot_sales = json_decode(json_encode($lot_sales),true); $this->data["pageData"] = $lot_sales; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["transits"] = set_array_keys(fetch_table_where_branch('accounts','type','transit'),'uid'); $this->data["expenses"] = $this->data["transits"]; $this->data["lots"] = set_array_keys(fetch_table_branch('lot'),'uid'); $this->data["search_client"] = $request->client; $this->data["search_supplier"] = $request->supplier; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'lot_sales'); $this->data["pageToLoad"] = "lot/sales.php"; $this->data["activeLink"] = "lot"; $this->load_view($this->data); } public function sale_invoice(Request $request,$uid) { if(check_user_access('add_lot_sold') === FALSE){ Redirect::to('/')->send(); } $invoice_data = fetch_table_where('lot_sold','uid',$uid,true); $invoice_number = $invoice_data['invoice']; $invoice_sales = fetch_table_where_branch('lot_sold','invoice',$invoice_number); $this->data["invoice_data"] = $invoice_data; $this->data["invoice_sales"] = $invoice_sales; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["lots"] = set_array_keys(fetch_table_branch('lot'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'lot_sold_invoice'); $this->data["pageToLoad"] = "lot/sale_invoice.php"; $this->data["activeLink"] = "lot"; $this->load_view($this->data); } public function delete_sale($uid) { if(check_user_access('delete_lot_sold') === FALSE){ Redirect::to('/')->send(); } $lot_sold_data = fetch_table_where('lot_sold','uid',$uid,true); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_lot_sold'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$lot_sold_data['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_weight').': '.amount_number_format($lot_sold_data['gross_weight']), ); set_activity_alert($_activity_details); delete_table('lot_sold','uid',$uid); _handle_lot_ledger_effects(['uid' => $lot_sold_data['parent'], 'state' => 'update']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function save_moved(Request $request) { if(empty($request->_move_parent_uid) AND empty($request->_move_child_uid)) { echo json_encode(array('status' => 'error', 'message_head' => 'Invalid Request', 'message_body' => 'invalid_request_body')); } else { $active_branch_id = active_branch_id(); $uid = generate_uid(); $parent_uid = $request->_move_parent_uid; $child_uid = $request->_move_child_uid; $move_item = $request->_move_item; $move_warehouse = $request->_move_warehouse; $move_unit = $request->_move_unit; $_move_difference_type = $request->_move_difference_type; $_move_difference = (float)$request->_move_difference; $_move_gross_weight = (float)$request->_move_gross_weight; $lot_item_data = array(); $lot_item_data_found = false; $lot_data = fetch_table_where('lot','uid',$parent_uid,true); if(isset($lot_data['lot_list'])) { if($lot_data['purchase_type'] == 'iran_to_border') { $lot_list = json_decode($lot_data['division_list'],true); } else { $lot_list = json_decode($lot_data['lot_list'],true); } foreach($lot_list as $lot_item) { if($lot_item['uid'] == $child_uid) { $lot_item_data = $lot_item; $lot_item_data_found = true; } } } if($lot_item_data_found === true) { $_items_effected = array(); $purchase_collection_of_items = array(); $purchase_collection_of_items_uid = array(); $purchase_collection_of_warehouses_uid = array(); $purchase_collection_of_batch_uid = array(); $purchase_collection_of_expense_uid = array(); $purchase_collection_of_transport_expenses = array(); $_move_lot_cost = (float)$lot_item_data['total_cost'] / $_move_gross_weight; $_move_lot_real_cost = $_move_lot_cost; $_move_lot_weight = $_move_gross_weight; $_move_lot_sale_price = $_move_lot_cost; $_move_lot_transport_exp = 0; $_move_lot_total = $_move_lot_cost; $item_array = array( 'item' => $move_item, 'warehouse' => $move_warehouse, 'cost' => $_move_lot_cost, 'real_cost' => $_move_lot_real_cost, 'qty' => $_move_lot_weight, 'm2' => 0, 'width' => 0, 'height' => 0, 'unit' => $move_unit, 'profit' => 0, 'discount' => 0, 'batch' => NULL, 'sale_price' => $_move_lot_sale_price, 'transport_expense' => $_move_lot_transport_exp, 'expense' => $lot_item_data['expense_account'], 'total' => $_move_lot_total, ); $purchase_collection_of_items[] = $item_array; $purchase_collection_of_items_uid[] = '-++-'.$move_item.'-++-'; $purchase_collection_of_warehouses_uid[] = '-++-'.$move_warehouse.'-++-'; $purchase_collection_of_batch_uid[] = '-++-'.NULL.'-++-'; $purchase_collection_of_expense_uid[] = '-++-'.$lot_item_data['expense_account'].'-++-'; $purchase_collection_of_transport_expenses[] = $_move_lot_transport_exp; $uid = getUniqueId('PRCH', 'purchases', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => $active_branch_id, 'currency' => $lot_data['currency'], 'currency_usd_equalance' => (float)$lot_data['currency_usd_equalance'], 'supplier' => $lot_data['supplier'], 'old_balance' => $lot_data['old_balance'], 'invoice' => 'PINV'.db_unique_id('purchases'), 'memo' => NULL, 'grand_total' => $_move_lot_total, 'discount_amount' => 0, 'sub_total_amount' => $_move_lot_total, 'paid_amount' => 0, 'pending_amount' => $_move_lot_total, 'cash_paid_account' => NULL, 'transport_expense' => array_sum($purchase_collection_of_transport_expenses), 'items' => json_encode($purchase_collection_of_items), 'items_uid' => implode(',', $purchase_collection_of_items_uid), 'warehouses_uid' => implode(',', $purchase_collection_of_warehouses_uid), 'batch_uid' => implode(',', $purchase_collection_of_batch_uid), 'expense_uid' => implode(',', $purchase_collection_of_expense_uid), 'incoming' => 'LOT', 'lot_id' => $parent_uid, 'lot_child_id' => $child_uid, 'lot_move_diff_type' => $_move_difference_type, 'lot_move_diff' => $_move_difference, 'lot_move_gross_weight' => $_move_gross_weight, ); insert_table('purchases',$db_array); _handle_item_stats(['uid' => $child_uid]); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_lot_moved'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/lot-purchase/moved', 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_receipt').' '.$lot_data['receipt'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_weight').': '.amount_number_format($db_array['lot_move_gross_weight']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'lot_moved'), 'message_body' => print_lang($this->data["app_lang"],'lot_moved_successfully'))); } else { echo json_encode(array('status' => 'error', 'message_head' => 'Invalid Request', 'message_body' => 'invalid_request_body')); } } } public function moved(Request $request) { if(check_user_access('view_lot_moved') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $moved_lots = DB::table('purchases')->where('branch',$branch_id)->where('incoming','LOT'); if(!empty($request->from)){ $moved_lots->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $moved_lots->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $moved_lots = $moved_lots->get(); $moved_lots = json_decode(json_encode($moved_lots),true); $this->data["pageData"] = $moved_lots; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["transits"] = set_array_keys(fetch_table_where_branch('accounts','type','transit'),'uid'); $this->data["lots"] = set_array_keys(fetch_table_branch('lot'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_supplier"] = $request->supplier; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'moved_lots'); $this->data["pageToLoad"] = "lot/moved.php"; $this->data["activeLink"] = "lot"; $this->load_view($this->data); } public function delete_moved($uid) { if(check_user_access('delete_lot_moved') === FALSE){ Redirect::to('/')->send(); } $purchase_data = fetch_table_where('purchases','uid',$uid,true); if(is_array($purchase_data)) { $lot_data = fetch_table_where('lot','uid',$purchase_data['lot_id'],true); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_lot_moved'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_receipt').' '.$lot_data['receipt'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_weight').': '.amount_number_format($purchase_data['lot_move_gross_weight']), ); set_activity_alert($_activity_details); } delete_table('purchases','uid',$uid); $_items_effected = array(); $purchase_items_before_delete = empty($purchase_data['items']) ? array() : json_decode($purchase_data['items'],true); foreach($purchase_items_before_delete as $old_item){ $_items_effected[] = $old_item['item']; } if(count($_items_effected) > 0){ $_items_effected = array_unique($_items_effected); } foreach($_items_effected as $item_uid){ _handle_item_stats(['uid' => $item_uid]); } _handle_items_inventory_stats_from_purchases(['uid' => $uid, 'entry_status' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function sales_difference_report(Request $request) { if(check_user_access('view_lot_difference_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $lot_sales = DB::table('lot_sold')->where('branch',$branch_id); if(!empty($request->currency)){ $lot_sales->where('currency',$request->currency); } if(!empty($request->from)){ $lot_sales->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $lot_sales->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $lot_sales = $lot_sales->get(); $lot_sales = json_decode(json_encode($lot_sales),true); $this->data["pageData"] = $lot_sales; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["transits"] = set_array_keys(fetch_table_where_branch('accounts','type','transit'),'uid'); $this->data["expenses"] = $this->data["transits"]; $this->data["lots"] = set_array_keys(fetch_table_branch('lot'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_supplier"] = $request->supplier; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'lot_difference_report'); $this->data["pageToLoad"] = "lot/difference_report.php"; $this->data["activeLink"] = "lot"; $this->load_view($this->data); } public function moved_difference_report(Request $request) { if(check_user_access('view_lot_difference_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $lot_moved = DB::table('purchases')->where('branch',$branch_id)->where('incoming','LOT'); if(!empty($request->currency)){ $lot_moved->where('currency',$request->currency); } if(!empty($request->from)){ $lot_moved->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $lot_moved->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $lot_moved = $lot_moved->get(); $lot_moved = json_decode(json_encode($lot_moved),true); $this->data["pageData"] = $lot_moved; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["transits"] = set_array_keys(fetch_table_where_branch('accounts','type','transit'),'uid'); $this->data["expenses"] = $this->data["transits"]; $this->data["lots"] = set_array_keys(fetch_table_branch('lot'),'uid'); $_display = 'normal'; if($request->filled('display')){ $_display = $request->display; } $this->data["search_display"] = $_display; $this->data["search_currency"] = $request->currency; $this->data["search_supplier"] = $request->supplier; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'lot_moved_difference_report'); $this->data["pageToLoad"] = "lot/moved_difference_report.php"; $this->data["activeLink"] = "lot"; $this->load_view($this->data); } public function show_lot_moved_items(Request $request) { $uids = $request->uids; $uids = explode(',',$uids); foreach($uids as $parent_child) { $ids = explode('__',$parent_child); $uid = $ids[0]; $item_uid = $ids[1]; $lot_data = fetch_table_where_branch('lot','uid',$uid,true); if(is_array($lot_data)) { $existing_hidden_items = array(); if(!empty($lot_data['moved_hidden_items'])) { $existing_hidden_items = explode(',',$lot_data['moved_hidden_items']); } $new_hidden_items = array(); foreach($existing_hidden_items as $litem) { if($litem != $item_uid){ $new_hidden_items[] = $litem; } } update_table('lot','uid',$uid,array('moved_hidden_items' => implode(',',$new_hidden_items))); } } echo json_encode(array('status' => 'success', 'mood' => 'hidden')); } public function hide_lot_moved_items(Request $request) { $uids = $request->uids; $uids = explode(',',$uids); foreach($uids as $parent_child) { $ids = explode('__',$parent_child); $uid = $ids[0]; $item_uid = $ids[1]; $lot_data = fetch_table_where_branch('lot','uid',$uid,true); if(is_array($lot_data)) { $existing_hidden_items = array(); if(!empty($lot_data['moved_hidden_items'])) { $existing_hidden_items = explode(',',$lot_data['moved_hidden_items']); } if(!empty($item_uid)) { $existing_hidden_items[] = $item_uid; } $new_hidden_items = array_unique($existing_hidden_items); update_table('lot','uid',$uid,array('moved_hidden_items' => implode(',',$new_hidden_items))); } } echo json_encode(array('status' => 'success', 'mood' => 'hidden')); } public function purchase_difference_report(Request $request) { if(!$request->has('type') OR !$request->filled('type')){ Redirect::to('/')->send(); } if($request->type == 'iran_to_afghanistan') { if(check_user_access('view_iran_to_afghanistan_difference_report') === FALSE){ Redirect::to('/')->send(); } } if($request->type == 'iran_to_border') { if(check_user_access('view_iran_to_border_difference_report') === FALSE){ Redirect::to('/')->send(); } } $branch_id = active_branch_id(); $lots = DB::table('lot')->where('branch',$branch_id)->where('purchase_type',$request->type); if($request->filled('currency')){ $lots->where('currency',$request->currency); } if($request->filled('from')){ $lots->where('lot_date','>=',get_true_date($request->from)); } if($request->filled('to')){ $lots->where('lot_date','<=',get_true_date($request->to)); } $lots = json_decode(json_encode($lots->get()),true); $this->data["pageData"] = $lots; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $_display = 'normal'; if($request->filled('display')){ $_display = $request->display; } $this->data["purchase_type"] = $request->type; $this->data["purchase_source"] = $request->source; $this->data["search_currency"] = $request->currency; $this->data["search_supplier"] = $request->supplier; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["search_display"] = $_display; $this->data["title"] = print_lang($this->data["app_lang"],'purchases_difference_report'); $this->data["pageToLoad"] = "lot/purchase_difference_report.php"; $this->data["activeLink"] = "lot"; $this->load_view($this->data); } public function show_lot_items(Request $request) { $uids = $request->uids; $uids = explode(',',$uids); foreach($uids as $parent_child) { $ids = explode('__',$parent_child); $uid = $ids[0]; $item_uid = $ids[1]; $lot_data = fetch_table_where_branch('lot','uid',$uid,true); if(is_array($lot_data)) { $existing_hidden_items = array(); if(!empty($lot_data['hidden_items'])) { $existing_hidden_items = explode(',',$lot_data['hidden_items']); } $new_hidden_items = array(); foreach($existing_hidden_items as $litem) { if($litem != $item_uid){ $new_hidden_items[] = $litem; } } update_table('lot','uid',$uid,array('hidden_items' => implode(',',$new_hidden_items))); } } echo json_encode(array('status' => 'success', 'mood' => 'hidden')); } public function hide_lot_items(Request $request) { $uids = $request->uids; $uids = explode(',',$uids); foreach($uids as $parent_child) { $ids = explode('__',$parent_child); $uid = $ids[0]; $item_uid = $ids[1]; $lot_data = fetch_table_where_branch('lot','uid',$uid,true); if(is_array($lot_data)) { $existing_hidden_items = array(); if(!empty($lot_data['hidden_items'])) { $existing_hidden_items = explode(',',$lot_data['hidden_items']); } if(!empty($item_uid)) { $existing_hidden_items[] = $item_uid; } $new_hidden_items = array_unique($existing_hidden_items); update_table('lot','uid',$uid,array('hidden_items' => implode(',',$new_hidden_items))); } } echo json_encode(array('status' => 'success', 'mood' => 'hidden')); } public function purchase_difference_report_fuel(Request $request) { if(check_user_access('view_iran_to_border_difference_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $lots = DB::table('lot')->where('branch',$branch_id)->where('purchase_type','iran_to_border'); if($request->filled('currency')){ $lots->where('currency',$request->currency); } if($request->filled('from')){ $lots->where('lot_date','>=',get_true_date($request->from)); } if($request->filled('to')){ $lots->where('lot_date','<=',get_true_date($request->to)); } $lots = json_decode(json_encode($lots->get()),true); $this->data["pageData"] = $lots; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_supplier"] = $request->supplier; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'fuel_difference_report'); $this->data["pageToLoad"] = "lot/purchase_difference_report_fuel.php"; $this->data["activeLink"] = "lot"; $this->load_view($this->data); } public function purchase_fuel_lose_report(Request $request) { if(check_user_access('view_fuel_lose_report') === FALSE){ Redirect::to('/')->send(); } if(!$request->has('type') OR !$request->filled('type')){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $lots = DB::table('lot')->where('branch',$branch_id)->where('purchase_type',$request->type);; if($request->filled('currency')){ $lots->where('currency',$request->currency); } if($request->filled('from')){ $lots->where('lot_date','>=',get_true_date($request->from)); } if($request->filled('to')){ $lots->where('lot_date','<=',get_true_date($request->to)); } $lots = json_decode(json_encode($lots->get()),true); $this->data["pageData"] = $lots; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["report_type"] = $request->type; $this->data["report_source"] = $request->source; $this->data["search_currency"] = $request->currency; $this->data["search_supplier"] = $request->supplier; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'fuel_lose_report'); $this->data["pageToLoad"] = "lot/purchase_fuel_lose_report.php"; $this->data["activeLink"] = "lot"; $this->load_view($this->data); } public function purchase_fuel_pending_report(Request $request) { if(check_user_access('view_fuel_lose_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $lots = DB::table('lot')->where('branch',$branch_id)->where('purchase_type','iran_to_border'); if($request->filled('currency')){ $lots->where('currency',$request->currency); } if($request->filled('from')){ $lots->where('lot_date','>=',get_true_date($request->from)); } if($request->filled('to')){ $lots->where('lot_date','<=',get_true_date($request->to)); } $lots = json_decode(json_encode($lots->get()),true); $this->data["pageData"] = lot_pending_report($lots); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_supplier"] = $request->supplier; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'fuel_lose_report'); $this->data["pageToLoad"] = "lot/purchase_fuel_pending_report.php"; $this->data["activeLink"] = "lot"; $this->load_view($this->data); } }