<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use View; use Hash; class Marketers extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_marketers') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $marketers = DB::table('marketers')->where('branch',$branch_id); if(!empty($request->currency)){ $marketers->where('currency',$request->currency); } if(!empty($request->from)){ $marketers->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $marketers->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $marketers = json_decode(json_encode($marketers->get()),true); $this->data["pageData"] = $marketers; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'marketers_view_title'); $this->data["pageToLoad"] = "marketers/view.php"; $this->data["activeLink"] = "marketers"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_marketers') === FALSE){ Redirect::to('/')->send(); } $this->data["title"] = print_lang($this->data["app_lang"],'marketers_add_title'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["pageToLoad"] = "marketers/add.php"; $this->data["activeLink"] = "marketers"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'account' => 'required', 'last_name' => 'required', 'mobile' => 'required|numeric', 'commission' => 'required|numeric', 'email' => 'required|unique:users', 'username' => 'required|min:3|unique:users', 'password' => 'required|min:3', ]); $validator->validate(); $uid = getUniqueId('MARKTRS', 'services', 'uid'); $uid_user = getUniqueId('USR', 'users', 'uid'); $active_branch_id = active_branch_id(); $hashed_password = Hash::make($request->password); $users_array = array( 'uid' => $uid_user, 'name' => $request->name." ".$request->last_name, 'email' => $request->email, 'phone' => $request->mobile, 'branch' => $active_branch_id, 'username' => $request->username, 'password' => $hashed_password, 'role' => 'USER', 'marketer' => $uid, 'is_marketer' => 'yes', 'rights' => '[]', ); $user_insert = insert_table('users',$users_array); $db_array = array( 'uid' => $uid, 'branch' => $active_branch_id, 'name' => $request->name, 'last_name' => $request->last_name, 'mobile' => $request->mobile, 'commission_type' => $request->commission_type, 'commission' => $request->commission, 'email' => $request->email, 'username' => $request->username, 'password' => $request->password, 'account' => $request->account, ); insert_table('marketers',$db_array); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'marketers_service_added'), 'message_body' => print_lang($this->data["app_lang"],'marketers_save_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_marketers') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('marketers','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/marketers')->send(); } $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'marketers_edit_title'); $this->data["pageToLoad"] = "marketers/edit.php"; $this->data["activeLink"] = "marketers"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'account' => 'required', 'last_name' => 'required', 'email' => ['required','email', Rule::unique('users')->ignore($uid, 'marketer')], 'username' => ['required','min:3',Rule::unique('users')->ignore($uid, 'marketer')], 'mobile' => 'required|numeric', 'commission' => 'required|numeric', ]); $validator->sometimes('update_password','min:3',function($input){ return !empty($input->update_password); } ); $validator->validate(); $active_branch_id = active_branch_id(); $users_array = array( 'name' => $request->name." ".$request->last_name, 'email' => $request->email, 'phone' => $request->mobile, 'username' => $request->username, ); if(!empty($request->update_password)){ $users_array['password'] = Hash::make($request->update_password); } update_table('users','marketer',$uid,$users_array); $db_array = array( 'name' => $request->name, 'last_name' => $request->last_name, 'mobile' => $request->mobile, 'commission_type' => $request->commission_type, 'commission' => $request->commission, 'email' => $request->email, 'username' => $request->username, 'account' => $request->account, ); if(!empty($request->update_password)){ $db_array['password'] = Hash::make($request->update_password); } update_table('marketers','uid',$uid,$db_array); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'marketers_update'), 'message_body' => print_lang($this->data["app_lang"],'marketers_update_successfully'))); } public function delete($uid) { if(check_user_access('delete_marketers') === FALSE){ Redirect::to('/')->send(); } delete_table('marketers','uid',$uid); delete_table('users','marketer',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }