<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Metu extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_metu_right') === FALSE){ Redirect::to('/')->send(); } $this->data["pageData"] = fetch_table_branch('metu'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_metu_stock_metu_view_title'); $this->data["pageToLoad"] = "metu/view.php"; $this->data["activeLink"] = "metu"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_metu_right') === FALSE){ Redirect::to('/')->send(); } $this->data["title"] = print_lang($this->data["app_lang"],'mod_metu_stock_metu_add_title'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["pageToLoad"] = "metu/add.php"; $this->data["activeLink"] = "metu"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'currency' => 'required', ]); $validator->validate(); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $uid = getUniqueId('METU', 'metu', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'name' => $request->name, 'currency' => $request->currency, 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'currency_usd_equalance' => $currency_data['usd_equalance'], ); insert_table('metu',$db_array); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'mod_metu_stock_metu_added'), 'message_body' => print_lang($this->data["app_lang"],'mod_metu_stock_metu_save_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_metu_right') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('metu','uid',$uid,true); $this->data["title"] = print_lang($this->data["app_lang"],'mod_metu_stock_metu_edit_title'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["pageToLoad"] = "metu/edit.php"; $this->data["activeLink"] = "metu"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'currency' => 'required', ]); $validator->validate(); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'name' => $request->name, 'number' => $request->number, 'currency' => $request->currency, 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'currency_usd_equalance' => $currency_data['usd_equalance'], ); update_table('metu','uid',$uid,$db_array); update_table('metu_purchases','metu',$uid,['metu_name' => $request->name]); update_table('metu_sales','metu',$uid,['metu_name' => $request->name]); update_table('metu_stock','metu',$uid,['metu_name' => $request->name]); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'mod_metu_stock_metu_update'), 'message_body' => print_lang($this->data["app_lang"],'mod_metu_stock_metu_update_successfully'))); } public function delete($uid) { if(check_user_access('delete_metu_right') === FALSE){ Redirect::to('/')->send(); } delete_table('metu','uid',$uid); delete_table('metu_purchases','metu',$uid); delete_table('metu_sales','metu',$uid); delete_table('metu_stock','metu',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function report(Request $request) { if(check_user_access('metu_report_right') === FALSE){ Redirect::to('/')->send(); } $metu_stock = DB::table('metu_stock')->where('branch',active_branch_id()); if(!empty($request->metu)){$metu_stock->where('metu',$request->metu);} if(!empty($request->from)){ $metu_stock->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $metu_stock->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $metu_stock = $metu_stock->orderBy('created_at','asc')->get(); $metu_stock = json_decode(json_encode($metu_stock),true); $metu_available_stock = DB::table('metu_stock')->where('branch',active_branch_id())->select((DB::raw('sum(debit) - sum(credit) as balance'))); if(!empty($request->metu)){$metu_available_stock->where('metu',$request->metu);} if(!empty($request->from)){ $metu_available_stock->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $metu_available_stock->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $metu_available_stock = $metu_available_stock->get()->first(); $metu_available_amount = $metu_available_stock->balance; $this->data["pageData"] = $metu_stock; $this->data["search_metu"] = $request->metu; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["metu_available_amount"] = $metu_available_amount; $this->data["metu"] = fetch_table_branch('metu'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_metu_stock_report_view_title'); $this->data["pageToLoad"] = "metu/report.php"; $this->data["activeLink"] = "metu_report"; $this->load_view($this->data); } }