<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Metu_purchases extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_metu_purchases_right') === FALSE){ Redirect::to('/')->send(); } $metu_purchases = DB::table('metu_purchases')->where('branch',active_branch_id()); if(!empty($request->supplier)){$metu_purchases->where('supplier',$request->supplier);} if(!empty($request->from)){ $metu_purchases->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $metu_purchases->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $metu_purchases = $metu_purchases->get(); $metu_purchases = json_decode(json_encode($metu_purchases),true); $this->data["pageData"] = $metu_purchases; $this->data["suppliers"] = fetch_table_where_branch('accounts','type','supplier'); $this->data["search_supplier"] = $request->supplier; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'mod_metu_stock_purchase_view_title'); $this->data["pageToLoad"] = "metu_purchases/view.php"; $this->data["activeLink"] = "metu_purchases"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_metu_purchases_right') === FALSE){ Redirect::to('/')->send(); } $this->data["suppliers"] = fetch_table_where_branch('accounts','type','supplier'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["metu"] = fetch_table_branch('metu'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_metu_stock_purchase_add_title'); $this->data["pageToLoad"] = "metu_purchases/add.php"; $this->data["activeLink"] = "metu_purchases"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'p_date' => 'required', 'supplier' => 'required', 'metu' => 'required', 'value' => 'required', 'percentage' => 'required', 'total' => 'required', ]); $validator->validate(); $supplier_data = fetch_table_where('accounts','uid',$request->supplier,true); $metu_data = fetch_table_where('metu','uid',$request->metu,true); $created_at = get_true_date( empty($request->p_date) ? date('Y-m-d') : $request->p_date ); $time_cr = date('H:i:s'); $created_at = $created_at." ".$time_cr; $uid = getUniqueId('METUPUR', 'metu_purchases', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'currency' => isset($metu_data['currency']) ? $metu_data['currency'] : null, 'currency_name' => isset($metu_data['currency_name']) ? $metu_data['currency_name'] : null, 'currency_symbol' => isset($metu_data['currency_symbol']) ? $metu_data['currency_symbol'] : null, 'currency_usd_equalance' => isset($metu_data['currency_usd_equalance']) ? $metu_data['currency_usd_equalance'] : null, 'metu' => $request->metu, 'metu_name' => isset($metu_data['name']) ? $metu_data['name'] : null, 'supplier' => $request->supplier, 'supplier_name' => isset($supplier_data['name']) ? $supplier_data['name'] : null, 'details' => $request->details, 'value' => $request->value, 'percentage' => $request->percentage, 'percentage_amount' => $request->percentage_amount, 'cost' => $request->cost, 'total' => $request->total, 'created_at' => $created_at, ); insert_table('metu_purchases',$db_array); _handle_metu_purchases_ledger_effects(['uid' => $uid, 'state' => 'new']); _handle_metu_purchases_stock_effects(['uid' => $uid, 'state' => 'new']); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'mod_metu_stock_purchase_added'), 'message_body' => print_lang($this->data["app_lang"],'mod_metu_stock_purchase_save_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_metu_purchases_right') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('metu_purchases','uid',$uid,true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["suppliers"] = fetch_table_where_branch('accounts','type','supplier'); $this->data["metu"] = fetch_table_branch('metu'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_metu_stock_purchase_edit_title'); $this->data["pageToLoad"] = "metu_purchases/edit.php"; $this->data["activeLink"] = "metu_purchases"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'p_date' => 'required', 'supplier' => 'required', 'metu' => 'required', 'value' => 'required', 'percentage' => 'required', 'total' => 'required', ]); $validator->validate(); $supplier_data = fetch_table_where('accounts','uid',$request->supplier,true); $metu_data = fetch_table_where('metu','uid',$request->metu,true); $last_purchase = fetch_table_where('metu_purchases','uid',$uid,true); $last_created_at = $last_purchase['created_at']; $last_time = date("H:i:s",strtotime($last_created_at)); $created_at = get_true_date( empty($request->p_date) ? date('Y-m-d') : $request->p_date ); $created_at = $created_at." ".$last_time; $db_array = array( 'currency' => isset($metu_data['currency']) ? $metu_data['currency'] : null, 'currency_name' => isset($metu_data['currency_name']) ? $metu_data['currency_name'] : null, 'currency_symbol' => isset($metu_data['currency_symbol']) ? $metu_data['currency_symbol'] : null, 'currency_usd_equalance' => isset($metu_data['currency_usd_equalance']) ? $metu_data['currency_usd_equalance'] : null, 'metu' => $request->metu, 'metu_name' => isset($metu_data['name']) ? $metu_data['name'] : null, 'supplier' => $request->supplier, 'supplier_name' => isset($supplier_data['name']) ? $supplier_data['name'] : null, 'details' => $request->details, 'value' => $request->value, 'percentage' => $request->percentage, 'percentage_amount' => $request->percentage_amount, 'cost' => $request->cost, 'total' => $request->total, 'created_at' => $created_at, ); update_table('metu_purchases','uid',$uid,$db_array); _handle_metu_purchases_ledger_effects(['uid' => $uid, 'state' => 'update']); _handle_metu_purchases_stock_effects(['uid' => $uid, 'state' => 'update']); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'mod_metu_stock_purchase_update'), 'message_body' => print_lang($this->data["app_lang"],'mod_metu_stock_purchase_update_successfully'))); } public function delete($uid) { if(check_user_access('delete_metu_purchases_right') === FALSE){ Redirect::to('/')->send(); } delete_table('metu_purchases','uid',$uid); _handle_metu_purchases_ledger_effects(['uid' => $uid, 'state' => 'delete']); _handle_metu_purchases_stock_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }