<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Metu_sales extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_metu_sales_right') === FALSE){ Redirect::to('/')->send(); } $metu_sales = DB::table('metu_sales')->where('branch',active_branch_id()); if(!empty($request->client)){$metu_sales->where('client',$request->client);} if(!empty($request->from)){ $metu_sales->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $metu_sales->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $metu_sales = $metu_sales->get(); $metu_sales = json_decode(json_encode($metu_sales),true); $this->data["pageData"] = $metu_sales; $this->data["clients"] = fetch_table_where_branch('accounts','type','client'); $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'mod_metu_stock_sale_view_title'); $this->data["pageToLoad"] = "metu_sales/view.php"; $this->data["activeLink"] = "metu_sales"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_metu_sales_right') === FALSE){ Redirect::to('/')->send(); } $this->data["clients"] = fetch_table_where_branch('accounts','type','client'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["metu"] = fetch_table_branch('metu'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_metu_stock_sale_add_title'); $this->data["pageToLoad"] = "metu_sales/add.php"; $this->data["activeLink"] = "metu_sales"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 's_date' => 'required', 'client' => 'required', 'metu' => 'required', 'value' => 'required', 'percentage' => 'required', 'total' => 'required', ]); $validator->validate(); $client_data = fetch_table_where('accounts','uid',$request->client,true); $metu_data = fetch_table_where('metu','uid',$request->metu,true); $metu_last_purchase_percentage = 0; $metu_last_purchase = std_obj_to_array(DB::table('metu_purchases')->where('branch',active_branch_id())->where('metu',$request->metu)->orderBy('id','desc')->get()->first()); if(!empty($metu_last_purchase)) { $metu_last_purchase_percentage = $metu_last_purchase['percentage']; } $profit_percentage = (float)$metu_last_purchase_percentage - (float)$request->percentage; $profit_amount = amount_number_format(($request->value * $profit_percentage) / 100); $created_at = get_true_date( empty($request->s_date) ? date('Y-m-d') : $request->s_date ); $time_cr = date('H:i:s'); $created_at = $created_at." ".$time_cr; $uid = getUniqueId('METUPUR', 'metu_sales', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'currency' => isset($metu_data['currency']) ? $metu_data['currency'] : null, 'currency_name' => isset($metu_data['currency_name']) ? $metu_data['currency_name'] : null, 'currency_symbol' => isset($metu_data['currency_symbol']) ? $metu_data['currency_symbol'] : null, 'currency_usd_equalance' => isset($metu_data['currency_usd_equalance']) ? $metu_data['currency_usd_equalance'] : null, 'metu' => $request->metu, 'metu_name' => isset($metu_data['name']) ? $metu_data['name'] : null, 'client' => $request->client, 'client_name' => isset($client_data['name']) ? $client_data['name'] : null, 'details' => $request->details, 'value' => $request->value, 'percentage' => $request->percentage, 'percentage_amount' => $request->percentage_amount, 'cost' => $request->cost, 'sale_price' => $request->cost, 'total' => $request->total, 'profit' => $profit_amount, 'created_at' => $created_at, ); insert_table('metu_sales',$db_array); _handle_metu_sales_ledger_effects(['uid' => $uid, 'state' => 'new']); _handle_metu_sales_stock_effects(['uid' => $uid, 'state' => 'new']); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'mod_metu_stock_sale_added'), 'message_body' => print_lang($this->data["app_lang"],'mod_metu_stock_sale_save_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_metu_sales_right') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('metu_sales','uid',$uid,true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = fetch_table_where_branch('accounts','type','client'); $this->data["metu"] = fetch_table_branch('metu'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_metu_stock_sale_edit_title'); $this->data["pageToLoad"] = "metu_sales/edit.php"; $this->data["activeLink"] = "metu_sales"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 's_date' => 'required', 'client' => 'required', 'metu' => 'required', 'value' => 'required', 'percentage' => 'required', 'total' => 'required', ]); $validator->validate(); $client_data = fetch_table_where('accounts','uid',$request->client,true); $metu_data = fetch_table_where('metu','uid',$request->metu,true); $metu_last_purchase_percentage = 0; $metu_last_purchase = std_obj_to_array(DB::table('metu_purchases')->where('branch',active_branch_id())->where('metu',$request->metu)->orderBy('id','desc')->get()->first()); if(!empty($metu_last_purchase)) { $metu_last_purchase_percentage = $metu_last_purchase['percentage']; } $profit_percentage = (float)$metu_last_purchase_percentage - (float)$request->percentage; $profit_amount = amount_number_format(($request->value * $profit_percentage) / 100); $last_purchase = fetch_table_where('metu_sales','uid',$uid,true); $last_created_at = $last_purchase['created_at']; $last_time = date("H:i:s",strtotime($last_created_at)); $created_at = get_true_date( empty($request->s_date) ? date('Y-m-d') : $request->s_date ); $created_at = $created_at." ".$last_time; $db_array = array( 'currency' => isset($metu_data['currency']) ? $metu_data['currency'] : null, 'currency_name' => isset($metu_data['currency_name']) ? $metu_data['currency_name'] : null, 'currency_symbol' => isset($metu_data['currency_symbol']) ? $metu_data['currency_symbol'] : null, 'currency_usd_equalance' => isset($metu_data['currency_usd_equalance']) ? $metu_data['currency_usd_equalance'] : null, 'metu' => $request->metu, 'metu_name' => isset($metu_data['name']) ? $metu_data['name'] : null, 'client' => $request->client, 'client_name' => isset($client_data['name']) ? $client_data['name'] : null, 'details' => $request->details, 'value' => $request->value, 'percentage' => $request->percentage, 'percentage_amount' => $request->percentage_amount, 'cost' => $request->cost, 'sale_price' => $request->cost, 'total' => $request->total, 'profit' => $profit_amount, 'created_at' => $created_at, ); update_table('metu_sales','uid',$uid,$db_array); _handle_metu_sales_ledger_effects(['uid' => $uid, 'state' => 'update']); _handle_metu_sales_stock_effects(['uid' => $uid, 'state' => 'update']); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'mod_metu_stock_sale_update'), 'message_body' => print_lang($this->data["app_lang"],'mod_metu_stock_sale_update_successfully'))); } public function delete($uid) { if(check_user_access('delete_metu_sales_right') === FALSE){ Redirect::to('/')->send(); } delete_table('metu_sales','uid',$uid); _handle_metu_sales_ledger_effects(['uid' => $uid, 'state' => 'delete']); _handle_metu_sales_stock_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }