<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use View; use Hash; class Money_receipts extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { $branch_id = active_branch_id(); $clients = array(); $user_id = Session::get('user_id'); $marketer = get_active_marketer(); $sales_man = get_active_sales_man(); if(is_marketer_user() === true){ $clients = fetch_table_where('accounts','marketer',$marketer); $user_type = 'marketer'; } if(is_sales_man_user() === true){ $clients = fetch_table_where('accounts','sales_man',$sales_man); $user_type = 'sales_man'; } $money_receipts = DB::table('money_receipts')->where('branch',$branch_id)->where('user_type',$user_type)->where('user_id',$user_id); if(!empty($request->currency)){ $money_receipts->where('currency',$request->currency); } if(!empty($request->status)){ $money_receipts->where('status',$request->status); } if(!empty($request->from)){ $money_receipts->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $money_receipts->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $money_receipts = json_decode(json_encode($money_receipts->get()),true); $this->data["pageData"] = $money_receipts; $this->data["clients"] = set_array_keys($clients,'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["search_status"] = $request->status; $this->data["title"] = print_lang($this->data["app_lang"],'money_receipts_view_title'); $this->data["pageToLoad"] = "money_receipts/view.php"; $this->data["activeLink"] = "money_receipts"; $this->load_view($this->data); } public function add(Request $request) { $clients = array(); $user_id = Session::get('user_id'); $marketer = get_active_marketer(); $sales_man = get_active_sales_man(); if(is_marketer_user() === true){ $clients = fetch_table_where('accounts','marketer',$marketer); } if(is_sales_man_user() === true){ $clients = fetch_table_where('accounts','sales_man',$sales_man); } $this->data["clients"] = $clients; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'money_receipts_add_title'); $this->data["pageToLoad"] = "money_receipts/add.php"; $this->data["activeLink"] = "money_receipts"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'client' => 'required', 'amount' => 'required|numeric', ]); $validator->validate(); $uid = getUniqueId('MNRCT', 'money_receipts', 'uid'); $active_branch_id = active_branch_id(); $currency_db_data = fetch_table_where('currency','uid',$request->currency,true); $user_id = Session::get('user_id'); $marketer = get_active_marketer(); $sales_man = get_active_sales_man(); if(is_marketer_user() === true){ $user_type = 'marketer'; } if(is_sales_man_user() === true){ $user_type = 'sales_man'; } $db_array = array( 'uid' => $uid, 'branch' => $active_branch_id, 'currency' => $request->currency, 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'invoice' => get_new_money_receipt_invoice_number(), 'client' => $request->client, 'amount' => $request->amount, 'details' => $request->details, 'user_type' => $user_type, 'marketer' => $marketer, 'sales_man' => $sales_man, 'user_id' => $user_id, 'submitted_date' => date('Y-m-d H:i:s'), ); insert_table('money_receipts',$db_array); $invoice_url = url('/money-receipts/invoice').'/'.$uid; echo json_encode(array('status' => 'success', 'mood' => 'new', 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'money_receipts_added'), 'message_body' => print_lang($this->data["app_lang"],'money_receipts_save_successfully'))); } public function edit(Request $request, $uid) { $this->data["editing_data"] = fetch_table_where('money_receipts','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/money_receipts')->send(); } $balance = get_account_balance($this->data["editing_data"]['client'],$this->data["editing_data"]['currency']); $clients = array(); $user_id = Session::get('user_id'); $marketer = get_active_marketer(); $sales_man = get_active_sales_man(); if(is_marketer_user() === true){ $clients = fetch_table_where('accounts','marketer',$marketer); } if(is_sales_man_user() === true){ $clients = fetch_table_where('accounts','sales_man',$sales_man); } $this->data["clients"] = $clients; $this->data["balance"] = $balance; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'money_receipts_edit_title'); $this->data["pageToLoad"] = "money_receipts/edit.php"; $this->data["activeLink"] = "money_receipts"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'client' => 'required', 'amount' => 'required|numeric', ]); $validator->validate(); $currency_db_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'currency' => $request->currency, 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'client' => $request->client, 'amount' => $request->amount, 'details' => $request->details, ); update_table('money_receipts','uid',$uid,$db_array); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'money_receipts_update'), 'message_body' => print_lang($this->data["app_lang"],'money_receipts_update_successfully'))); } public function delete($uid) { delete_table('money_receipts','uid',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function get_client_balance(Request $request) { $balance = get_account_balance($request->client,$request->currency); echo amount_number_format($balance); } public function sales(Request $request) { $branch_id = active_branch_id(); $clients = array(); $user_id = Session::get('user_id'); $marketer = get_active_marketer(); $sales_man = get_active_sales_man(); $sales = DB::table('sales')->where('branch',$branch_id); if(is_marketer_user() === true) { $clients = fetch_table_where('accounts','marketer',$marketer); $user_type = 'marketer'; $_fetch_user = $marketer; $sales->where('marketer',$_fetch_user); if(!empty($request->currency)){ $sales->where('currency',$request->currency); } if(!empty($request->from)){ $sales->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $sales->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } } if(is_sales_man_user() === true) { $clients = fetch_table_where('accounts','sales_man',$sales_man); $user_type = 'sales_man'; $_fetch_user = $sales_man; $sales->where('sales_man',$_fetch_user); if(!empty($request->currency)){ $sales->where('currency',$request->currency); } if(!empty($request->from)){ $sales->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $sales->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } } $sales = json_decode(json_encode($sales->get()),true); $this->data["pageData"] = $sales; $this->data["clients_user"] = set_array_keys($clients,'uid'); $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'my_sales_view_title'); $this->data["pageToLoad"] = "money_receipts/sales.php"; $this->data["activeLink"] = "money_receipts"; $this->load_view($this->data); } public function invoice(Request $request, $uid) { $this->data["invoice_data"] = fetch_table_where('money_receipts','uid',$uid,true); if(!is_array($this->data["invoice_data"])){ Redirect::to('/money_receipts')->send(); } $user_id = Session::get('user_id'); $marketer = get_active_marketer(); $sales_man = get_active_sales_man(); if(is_marketer_user() === true) { $logged_user_data = fetch_table_where('marketers','uid',$marketer,true); } if(is_sales_man_user() === true) { $logged_user_data = fetch_table_where('sales_man','uid',$sales_man,true); } $branch = active_branch_id(); $branch_data = fetch_table_where('branches','uid',$branch,true); $client_data = fetch_table_where('accounts','uid',$this->data["invoice_data"]['client'],true); $currency_data = fetch_table_where('currency','uid',$this->data["invoice_data"]['currency'],true); $this->data["user"] = $logged_user_data; $this->data["branch_data"] = $branch_data; $this->data["client_data"] = $client_data; $this->data["currency_data"] = $currency_data; $this->data["title"] = print_lang($this->data["app_lang"],'money_receipts_vc_view_title'); $this->data["pageToLoad"] = "money_receipts/invoice.php"; $this->data["activeLink"] = "money_receipts"; $this->load_view($this->data); } }